#include "common.h"
#include "hardware.h"
#include "csl_chip.h"
#include "csl_cache.h"
#include "csl_cacheAux.h"

#pragma DATA_SECTION(CPBInfo, ".device_info")
#pragma DATA_ALIGN(CPBInfo, 8)
TCPBInfo CPBInfo;		// write from host

volatile int volatileDummy;

int Lamp1_Status, Lamp2_Status;

unsigned short ReadBoardID()
{
	return *((unsigned short *)0x300);
}

int cacheInvaliDate_ddr3(char *srcAddr, int nSize)
{
	//   ȿȭϰ ٸ ھ  Ÿ  (б)
	int i;
	int div;

	div = nSize / (1024 * 128);
	if(div == 0)
		CACHE_invL2((void *)srcAddr, nSize, CACHE_WAIT);

	else
	{
		for( i = 0; i < div; i ++)
			CACHE_invL2((void *)(srcAddr + i * (1024 * 128)), (1024 * 128), CACHE_NOWAIT);

		if((1024 * 128) * div < nSize)
			CACHE_invL2((void *)(srcAddr + i * (1024 * 128)), nSize - (i * (1024 * 128)), CACHE_NOWAIT);

		CACHE_invL2Wait(); //  ó  ó ٲִ ſ ⼭ ٸ .
	}


	return 0;
}

int cacheWriteBack_ddr3(char *srcAddr, int nSize)
{
	// ٸ ھ   ֵ  Ÿ  ()
	// srcAddr    ö

	int i;
	int div;

	div = nSize / (1024 * 128);
	if(div == 0)
		CACHE_wbL2(srcAddr, nSize, CACHE_WAIT);

	else
	{
		for( i = 0; i < div; i ++)
			CACHE_wbL2((void *)(srcAddr + i * (1024 * 128)), (1024 * 128), CACHE_NOWAIT);

		if((1024 * 128) * div < nSize)
			CACHE_wbL2((void *)(srcAddr + i * (1024 * 128)), nSize - (i * (1024 * 128)), CACHE_NOWAIT);

		CACHE_invL2Wait(); //  ó  ó ٲִ ſ ⼭ ٸ .
	}


	return 0;
}

/*
void HardwareInit()
{
    unsigned int status = 0;

    //Enable L2
    *(unsigned int *)(0x01846008) = 0x1; //enable EDC
    status = *(unsigned int *)(0x01846004);

    unsigned int status = 0;

    *(unsigned int *)(L1PEDCMD) = 0x1;  //Set EN(bit0)=1

    //Check the status
    status = *(unsigned int *)(L1PEDSTAT);


}
*/
