#ifndef _HARDWARE_H_
#define _HARDWARE_H_

#define CACHE_BASE          0x01840000
#define CACHE_L2CFG             (*( unsigned int* )( CACHE_BASE ))
#define CACHE_L1PCFG            (*( unsigned int* )( CACHE_BASE + 0x0020 ))
#define CACHE_L1DCFG            (*( unsigned int* )( CACHE_BASE + 0x0040 ))

typedef struct 
{
	unsigned int BoardID;
	unsigned char CPUKind;
	unsigned char dummy[3];
} TCPBInfo;

extern TCPBInfo CPBInfo;
#ifdef __cplusplus
extern "C" {
#endif
int cacheInvaliDate_ddr3(char *srcAddr, int nSize);
int cacheWriteBack_ddr3(char *srcAddr, int nSize);
#ifdef __cplusplus
}
#endif
#endif
