#include "srio_slave.h"
#include "hardware.h"
#include "environment.h"
#include "CPB_Global.h"
#include "CPB_Module_Main.h"
#include "csl_chip.h"
#include "csl_cache.h"
#include "csl_cacheAux.h"

static unsigned int LampSW = 0; 
static unsigned int CurrentLampSW = 0;
volatile unsigned int SYSLock = 0;

/*
*  ======== main ========
*/

#pragma DATA_SECTION(test_sdram, ".sdram")
#pragma DATA_SECTION(test_stack, ".stack")

int test_sdramp[1024];
int test_stack[1024];
int test_l2[1024];
int test_count =0 ;
void main(void)
{
	int i;

	CPB_CORE_NUMBER = DNUM;

	*(unsigned int *) CACHE_L1PCFG = 4;  // 32K
	*(unsigned int *) CACHE_L1DCFG = 4;  // 32K

	//ddr3 config
	for(i = 128; i < 128 + MAX_PROCESSING_CORE_COUNT * 8; i ++)
	{
		*(unsigned int *) (0x01848000 + i * 4) |= 0x1;
	}

	EnvironmentInit();
	Srio_Slave_Init();
	Set_Status();

	while (1)
	{	
		if (Process_Function != PROCESS_FUNC_NONE)
		{	
			CPB_Module_Processing();
			Process_Function = PROCESS_FUNC_NONE;
			Set_Processing_Status(CPB_PROCESSING_FINISHED);
		}
		else
		{
			Set_Status();
		}
		Srio_Slave_Process();
	}
}
