#ifndef _COMMAND_H_
#define _COMMAND_H_

#include "common.h"
#include "io_port.h"

#define HCB_STATUS_KIND_MACHINE		0
#define HCB_STATUS_KIND_ALARM		  1
#define HCB_STATUS_KIND_WARNING		2

#define RUN_MODE_PROGRAM_CHANGE		1
#define RUN_MODE_RERUN				    2
#define RUN_MODE_TEST				      3

// machine control data structure
#define MACHINE_CONTROL_GENERAL			      0
#define MACHINE_CONTROL_RINGBLOWER		    1
#define MACHINE_CONTROL_SERVOMOTOR		    2
#define MACHINE_CONTROL_VIBRATOR		      4
#define MACHINE_CONTROL_PROCEDURE		      5
#define MACHINE_CONTROL_ILLUMINATOR		    6
#define MACHINE_CONTROL_SUCTION_DISK	    7
#define MACHINE_CONTROL_BOWL_FEEDER		    8
#define MACHINE_CONTROL_EJECTOR			      9
#define MACHINE_CONTROL_STEPMOTOR		      10
#define MACHINE_CONTROL_MISEJECT		      11
#define SungChul_Data	  				          12

#define PROCEDURE_MODE_NONE				  0
#define PROCEDURE_MODE_TEST				  1
#define PROCEDURE_MODE_CAPTURE			2
#define PROCEDURE_MODE_STUDY			  3
#define PROCEDURE_MODE_INSPECTION		4
#define PROCEDURE_MODE_WAITSTOP1			5
#define PROCEDURE_MODE_WAITSTOP2			6
#define PROCEDURE_MODE_WAITSTOP_RESUME  7

typedef struct
{
	int CaptureType;
	unsigned char CamEnabled;
	unsigned char ShutterSpeed[SYSTEM_SPB_CAMERA_MAX_COUNT];
  int CaptureLength[SYSTEM_SPB_CAMERA_MAX_COUNT];
	int ShutterDelay[SYSTEM_SPB_CAMERA_MAX_COUNT];
  int GlobalCameraIndex[SYSTEM_SPB_CAMERA_MAX_COUNT];
} TSPBSetupInfo;

typedef struct
{
	char Connected;
	char Enabled;
	char MotorIndex;
	char FeedRate;
} TMEStatus;

typedef struct
{
	unsigned char ControlMode;
	unsigned char AlarmExist;
	unsigned char WarningExist;
	unsigned char VibratorOn;
	unsigned char VibratorMode;
	unsigned char OperationState;	
	unsigned char Suspended;
	unsigned char SuspendReason;	
	unsigned short Motor1ShortTermRPM;
	unsigned short Motor2ShortTermRPM;
	int ServoMotorEncoderDiff[MAX_SERVO_MOTOR_COUNT];
	int StepMotorAbsEncoder[MAX_STEP_MOTOR_COUNT];
	char OriginDetected[MAX_STEP_MOTOR_COUNT];
	char StepMotorMoving[MAX_STEP_MOTOR_COUNT];
	char reservedChar1[16 - MAX_STEP_MOTOR_COUNT - MAX_STEP_MOTOR_COUNT];
	unsigned char VFSpeed;
	unsigned char BFEmptySensorRatio;
	unsigned char BFFullSensorRatio;
	unsigned char SuctionDisk1LampKind;
	unsigned char SuctionDisk2LampKind;
	unsigned char reservedChar2[3];
	TMEStatus MEStatus;
  unsigned char BlackOut;
  unsigned char MachineOff;
  unsigned char dummy[2];
} TMachineStatus;

typedef struct
{
	int Target;
} TMachineControlHeader;

typedef struct
{
	TMachineControlHeader MachineControlHeader;
  int Action;
	int DiscSpeed[2];
	unsigned char SuctionDisk1InverterSpeed;
	unsigned char SuctionDisk2InverterSpeed;
  char Dummy[2];
} TMachineControlData_SuctionDisk;

typedef struct
{
	TMachineControlHeader MachineControlHeader;
	int Action;
	int InnerDiskSpeed;
	int OuterDisk1Speed;
	int OuterDisk2Speed;
	char AirKnifeSpeed;
	char dummyChar[3];
} TMachineControlData_BowlFeeder;

typedef struct
{
	TMachineControlHeader MachineControlHeader;
  int Action;
	int Mode;
  int MotorSpeed[MAX_SERVO_MOTOR_COUNT];
	char AirKnifeSpeed;
	char dummyChar;
	unsigned char MaxSpeedTrainingMode;
	unsigned char ManualMaxSpeed;
  int ManualModeSensorIndex;
  int ManualModeSensorActiveRatio;
	unsigned char ManualLimitSpeed;
	int ManualModeLimitSensorIndex;
	int ManualModeLimitSensorActiveRatio;
	int EmptySensorActiveRatio;
	int FullSensorActiveRatio;
	unsigned char SuctionDisk1InverterSpeed;
	unsigned char SuctionDisk2InverterSpeed;
  unsigned char SuctionDisk3InverterSpeed;
	char dummyChar2[2];
	int NCMotorPos[MAX_STEP_MOTOR_COUNT];
  //sjm
  int applyEjectorDelay;
  int adjustUnInsDelay;
  int adjustDefectDelay;
  int adjustEjectoWindStrength;

  int EnabledSensorType;
} TMachineControlData_Procedure;

typedef struct
{
	TMachineControlHeader MachineControlHeader;
  int ActionN;
  int Value[4];
} TMachineControlData_General;

typedef struct
{
	TMachineControlHeader MachineControlHeader;
  int Action;
  int EjectorIndex;
  unsigned int EjectorMask;
  int EjectorMaskCount;
  int EjectorWindStrength;
} TMachineControlData_Ejector;

typedef struct
{
	int SuctionDiskSpeed; 
	int StudiedSensorIntervalA;
	int StudiedSensorIntervalB;
	int StudiedTabletSensor1Length;
	int StudiedTabletSensor2Length;
	int StudiedTabletSensor3Length;
	int CaptureMode;
}TEjectorTestSetupData;

typedef struct
{
	TMachineControlHeader MachineControlHeader;
	int Action;
	int ActiveDelay;
	int DurationTime;
} TMachineControlData_Miseject;

typedef struct
{
	TMachineControlHeader MachineControlHeader;
  unsigned char SolIndex;
  char Action;
  char dummy[2];
} TMachineControlData_Solenoid;

typedef struct
{
	TMachineControlHeader MachineControlHeader;
  unsigned char BlowerIndex;
  char Action;
	unsigned char Speed1;
	unsigned char Speed2;
  unsigned char Speed3;
} TMachineControlData_RingBlower;

typedef struct
{
	TMachineControlHeader MachineControlHeader;
  char Action;
  char TrainingMode;
  char DisplayMode;
  char dummy[1];
  int Speed;
	int ManualModeSensorIndex;
	int ManualModeSensorActiveRatio;
	int LimitSpeed;
	int ManualModeLimitSensorIndex;
	int ManualModeLimitSensorActiveRatio;
  int Sensor1Ratio;
  int Sensor2Ratio;
	int StartSpeed;
} TMachineControlData_VibrationFeeder;

typedef struct
{
	TMachineControlHeader MachineControlHeader;
  int StartSpeedMode;
} TMachineControlData_SungChulData;

typedef struct
{
	TMachineControlHeader MachineControlHeader;
  char MotorIndex;
  char Action;
  char dummy[2];
  int BaseSpeed;
  int AccTime;
  int DecTime;
  int Dir;
  int TargetSpeed;
} TMachineControlData_ServoMotor;

typedef struct
{
	TMachineControlHeader MachineControlHeader;
	char MotorIndex;
	char Action;
	char Dir;
	char dummy[1];
	int PulseCount;
	int TargetEncoderPosition;
} TMachineControlData_StepMotor;

typedef struct
{
	TMachineControlHeader MachineControlHeader;
  unsigned char LEDIndex;
  char Action;
  char Mode;
  char dummy[1];
  int Interval1;
  int Interval2;
} TMachineControlData_Illuminator;

typedef struct
{
	int Action;
	unsigned int CaptureMode;
  int FrameTime;
  int LEDDelay[SYSTEM_MACHINE_CAPTURE_COUNT];
  int LEDOnTime[SYSTEM_MACHINE_CAPTURE_COUNT];
  int LEDMask[SYSTEM_MACHINE_CAPTURE_COUNT];
  int ShutterDelay;
  unsigned int CamMask;
} TCaptureCommandParam_HCB;

typedef struct
{
	int Running;
	int CurrentCPBIndex;
} TCPBRunStatus;

typedef struct
{
  int ShutterSpeed;
  int AnalogGain;
  int DigitalGain; 
  int WhiteBalance[3];
  int bounaryStartY;
  int bounaryEndY;
  int mask;
  int InsAreaLeft;
  int InsAreaRight;
  int InsAreaTop;
  int InsAreaBottom;
  int Threshold;

  int ImageScale;
  int FrameTime;
  int LedOnTime;
  int CaptureDelay_Min;
  int CaptureDelay_Max;
  int FreeCaptureUpload;

}TTPBCameraParams;

#endif
