#ifndef _RS232_MODULE_H_
#define _RS232_MODULE_H_

#include <csl_mcbsp.h>

#define RS232_MAX_BIT_RX	16
#define RS232_MAX_BIT_TX	16

// full duplex ̹Ƿ rx tx status иѴ.
#define RS232_TX_STATUS_NONE		0
#define RS232_TX_STATUS_READY		1
#define RS232_TX_STATUS_SENDING		2
#define RS232_TX_STATUS_SENT		3

#define RS232_RX_STATUS_NONE		0
#define RS232_RX_STATUS_READY		1
#define RS232_RX_STATUS_RECEIVING	2
#define RS232_RX_STATUS_RECEIVED	3


/////////////////////////////////////////////////////////////
//	McBSP ̿ RS232  
/////////////////////////////////////////////////////////////

typedef struct
{
	char *DataBufferAddr;
	int DataBufferSize;
	int DataPosition;	
	unsigned int BitBuffer[RS232_MAX_BIT_RX];
	int BitBufferPosition;
	int StopBitCount;
	int DataBitCount;
	int BitCount;
	volatile int Status;
	int EOT_DataSize;
	char EOT_Type;
	char EOT_Char;
} TRS232RX;

typedef struct
{
	char *DataBufferAddr;
	int DataBufferSize;
	int DataPosition;	
	unsigned int BitBuffer[RS232_MAX_BIT_TX];
	int BitBufferPosition;
	int StopBitCount;
	int DataBitCount;
	int BitCount;
	int Status;
	int DataLength;
} TRS232TX;




typedef struct
{
	TRS232RX RX;
	TRS232TX TX;	
	MCBSP_Handle McbspHandle;
} TRS232Handle;

#endif
