#include "RS232_Module.h"

#define CSL_V3

#define EOT_TYPE_NONE				0
#define EOT_TYPE_CHAR				1
#define EOT_TYPE_COUNT				2
#define EOT_TYPE_TIME				3


#define OSC_CLK						50000000		// 50MHz
#define CPU_CLK						600000000		// 600MHz

int test;
CSL_McbspObj         mcbsp1Obj;
CSL_McbspHandle handle_mcbsp1;

void RS232_ProcessRx(unsigned int *buffer, char *rxchar);
void RS232_ProcessTx(unsigned int *buffer, char txchar, int stopBitCount);
//---------------------------------------------------------------------------

void McBSP_Init(int bps, int tx_stop_bits, int tx_data_bits,
	int rx_stop_bits, int rx_data_bits, int mcbspDeviceIndex, char isInternalCLK)
{
	CSL_McbspConfig mcbspCfg;      /* Config Structures */
	CSL_McbspContext     pContext;
	unsigned int clkdv;
	CSL_Status           status = CSL_SOK;
	
	
	// CSL 3.0 MCBSP Init
	status = CSL_mcbspInit(&pContext);

	if (status != CSL_SOK) {
		return;
	}

	// CSL 3.0 MCBSP Open
	memset (&mcbsp1Obj, 0, sizeof(CSL_McbspObj)); 
	//    *handle = MCBSP_open(mcbspDeviceIndex, MCBSP_OPEN_RESET);
	handle_mcbsp1= CSL_mcbspOpen (&mcbsp1Obj, CSL_MCBSP_1,NULL, &status);

	if( (handle_mcbsp1 == NULL) || (status != CSL_SOK)) {
		return;
	}
	
//    MCBSP_getConfig(*handle, &mcbspCfg);

    clkdv = (unsigned int)(OSC_CLK / (bps * 32)) - 1;

    /* clkdv is max 8-bits long, so make sure we didn't overflow ... */
    if (clkdv > 0xff) {
        return;
    }
	
#ifndef CSL_V3	
    // McBSP Config 
    mcbspCfg.SPCR =
        MCBSP_FMK(SPCR,XIOEN,MCBSP_PCR_XIOEN_SP) |		//0x00000000u		0
        MCBSP_FMK(SPCR,RIOEN,MCBSP_PCR_RIOEN_SP) |		//0x00000000u 		0
        MCBSP_FMK(SPCR,FSXM,MCBSP_PCR_FSXM_INTERNAL) |	//0x00000001u		1
        MCBSP_FMK(SPCR,FSRM,MCBSP_PCR_FSRM_EXTERNAL) |	//0x00000000u		0
        MCBSP_FMK(SPCR,CLKXM,MCBSP_PCR_CLKXM_OUTPUT) |	//0x00000001u		1
        MCBSP_FMK(SPCR,CLKRM,MCBSP_PCR_CLKRM_OUTPUT) |	//0x00000001u		1
        MCBSP_FMK(SPCR,CLKSSTAT,MCBSP_PCR_CLKSSTAT_0) |	//0x00000000u		0
        MCBSP_FMK(SPCR,DXSTAT,MCBSP_PCR_DXSTAT_0) |		//0x00000000u		0
        MCBSP_FMK(SPCR,FSXP,MCBSP_PCR_FSXP_ACTIVELOW) |	//0x00000001u		1
        MCBSP_FMK(SPCR,FSRP,MCBSP_PCR_FSRP_ACTIVELOW) |	//0x00000001u		1
        MCBSP_FMK(SPCR,CLKXP,MCBSP_PCR_CLKXP_RISING) |	//0x00000000u		0
        MCBSP_FMK(SPCR,CLKRP,MCBSP_PCR_CLKRP_FALLING);	//0x00000000u		0

    /*
     * Here we compute the bit rate of the McBSP.  Each UART bit is
     * represented by 16 McBSP bits.
     */


    mcbspCfg.SRGR = 
        MCBSP_FMK(SRGR,GSYNC,MCBSP_SRGR_GSYNC_FREE) |		//0x00000000u		0
        MCBSP_FMK(SRGR,CLKSP,MCBSP_SRGR_CLKSP_RISING) |		//0x00000000u		0
        MCBSP_FMK(SRGR,FSGM,MCBSP_SRGR_FSGM_DXR2XSR) |		//0x00000000u		0
        MCBSP_FMK(SRGR,FPER,MCBSP_SRGR_FPER_DEFAULT) |		//0x00000000u		0
        MCBSP_FMK(SRGR,FWID,MCBSP_SRGR_FWID_DEFAULT) |		//0x00000000u		0
        MCBSP_FMK(SRGR,CLKGDV,MCBSP_SRGR_CLKGDV_OF(clkdv));   //clkdv			value

	if (isInternalCLK)
	{
		mcbspCfg.SRGR|= MCBSP_FMK(SRGR,CLKSM,MCBSP_SRGR_CLKSM_INTERNAL);		//0x00000001u
	}
	else
	{
		mcbspCfg.SRGR |= MCBSP_FMK(SRGR,CLKSM,MCBSP_SRGR_CLKSM_CLKS);		//0x00000000u
	}

    mcbspCfg.XCR =
        MCBSP_FMK(XCR,XPHASE,MCBSP_XCR_XPHASE_DUAL) |					//0x00000001u
        MCBSP_FMK(XCR,XFRLEN2,MCBSP_XCR_XFRLEN2_OF(tx_stop_bits - 1)) |		// tx_stop_bits - 1
        MCBSP_FMK(XCR,XWDLEN2,MCBSP_XCR_XWDLEN2_16BIT) |					//0x00000002u
        MCBSP_FMK(XCR,XCOMPAND,MCBSP_XCR_XCOMPAND_MSB) |				//0x00000000u
        MCBSP_FMK(XCR,XFIG,MCBSP_XCR_XFIG_YES) |							//0x00000001u
        MCBSP_FMK(XCR,XDATDLY,MCBSP_XCR_XDATDLY_0BIT) |					//0x00000000u
        MCBSP_FMK(XCR,XFRLEN1,MCBSP_XCR_XFRLEN1_OF(tx_data_bits)) |		//tx_data_bits
        MCBSP_FMK(XCR,XWDLEN1,MCBSP_XCR_XWDLEN1_32BIT) |					//0x00000005u
        MCBSP_FMK(XCR,XWDREVRS,MCBSP_XCR_XWDREVRS_DISABLE);			//0x00000000u

    mcbspCfg.RCR =
        MCBSP_FMK(RCR,RPHASE,MCBSP_RCR_RPHASE_DUAL) |					//0x00000001u
        MCBSP_FMK(RCR,RFRLEN2,MCBSP_RCR_RFRLEN2_OF(rx_stop_bits - 1)) |		//rx_stop_bits - 1
        MCBSP_FMK(RCR,RWDLEN2,MCBSP_RCR_RWDLEN2_16BIT) |					//0x00000002u
        MCBSP_FMK(RCR,RCOMPAND,MCBSP_RCR_RCOMPAND_MSB) |				//0x00000000u
        MCBSP_FMK(RCR,RFIG,MCBSP_RCR_RFIG_YES) |							//0x00000001u
        MCBSP_FMK(RCR,RDATDLY,MCBSP_RCR_RDATDLY_1BIT) |					//0x00000001u
        MCBSP_FMK(RCR,RFRLEN1,MCBSP_RCR_RFRLEN1_OF(rx_data_bits)) |		//rx_data_bits
        MCBSP_FMK(RCR,RWDLEN1,MCBSP_RCR_RWDLEN1_32BIT) |					//0x00000005u
        MCBSP_FMK(RCR,RWDREVRS,MCBSP_RCR_RWDREVRS_DISABLE);			//0x00000000u

    mcbspCfg.SPCR =
        MCBSP_FMK(SPCR,FREE,MCBSP_SPCR_FREE_YES) |				// NO  0x00000001u
        MCBSP_FMK(SPCR,SOFT,MCBSP_SPCR_SOFT_DEFAULT) |			// YES  0x00000000u
        MCBSP_FMK(SPCR,FRST,MCBSP_SPCR_FRST_DEFAULT) |			// YES  0x00000000u
        MCBSP_FMK(SPCR,GRST,MCBSP_SPCR_GRST_DEFAULT) |			// YES  0x00000000u
        MCBSP_FMK(SPCR,XINTM,MCBSP_SPCR_XINTM_XRDY) | 				//0x00000000u
        MCBSP_FMK(SPCR,XSYNCERR,MCBSP_SPCR_XSYNCERR_DEFAULT) |	// NO  0x00000000u
        MCBSP_FMK(SPCR,XSYNCERR,MCBSP_SPCR_XRST_DEFAULT) |		//	0x00000000u
        MCBSP_FMK(SPCR,DLB,MCBSP_SPCR_DLB_OFF) |					//  0x00000000u
        MCBSP_FMK(SPCR,RJUST,MCBSP_SPCR_RJUST_RZF) |				//  0x00000000u
        MCBSP_FMK(SPCR,CLKSTP,MCBSP_SPCR_CLKSTP_DISABLE) |		//  0x00000000u
        MCBSP_FMK(SPCR,DXENA,MCBSP_SPCR_DXENA_OFF) | 				//  0x00000000u
        MCBSP_FMK(SPCR,RINTM,MCBSP_SPCR_RINTM_RRDY) |     		// EOS  0x00000000u
        MCBSP_FMK(SPCR,XSYNCERR,MCBSP_SPCR_RSYNCERR_DEFAULT) |	//  0x00000000u
        MCBSP_FMK(SPCR,XSYNCERR,MCBSP_SPCR_RRST_DEFAULT);		//  0x00000000u

	mcbspCfg.MCR= 0;
	mcbspCfg.RECERE0 = 0;
	mcbspCfg.XECERE0 = 0;
	mcbspCfg.RECERE1 = 0;
	mcbspCfg.XECERE1 = 0;
	mcbspCfg.RECERE2 = 0;
	mcbspCfg.XECERE2 = 0;
	mcbspCfg.RCERE3 = 0;
	mcbspCfg.XCERE3 = 0; 

	  MCBSP_config(handle_mcbsp1, &mcbspCfg);

	// Disable any previous machine state
	// - McBSP disable
	MCBSP_FSETSH(handle_mcbsp1,SPCR,RRST,YES);
	MCBSP_FSETSH(handle_mcbsp1,SPCR,XRST,YES);

	// Start Sample Rate Generator: set /GRST = 1 
	MCBSP_enableSrgr(handle_mcbsp1);
	    
	// Enable Frame Sync Generator for McBSP: set /FRST = 1
	MCBSP_enableFsync(handle_mcbsp1);
#else

// Mcbsp register configure
     mcbspCfg.PCR = 
		CSL_FMK(MCBSP_PCR_XIOEN,0x00) |
		CSL_FMK(MCBSP_PCR_RIOEN,0x00) |
		CSL_FMK(MCBSP_PCR_FSXM,0x01) |
		CSL_FMK(MCBSP_PCR_FSRM,0x00) |
		CSL_FMK(MCBSP_PCR_CLKXM,0x01) |
		CSL_FMK(MCBSP_PCR_CLKRM,0x01) |
		CSL_FMK(MCBSP_PCR_CLKSSTAT,0x00) |
		CSL_FMK(MCBSP_PCR_DXSTAT,0x01) |
		CSL_FMK(MCBSP_PCR_FSXP,0x01) |
		CSL_FMK(MCBSP_PCR_FSRP,0x01) |
		CSL_FMK(MCBSP_PCR_CLKXP,0x00) |
		CSL_FMK(MCBSP_PCR_CLKRP,0x00);

    mcbspCfg.SRGR = 
		CSL_FMK(MCBSP_SRGR_GSYNC,0x00) |
		CSL_FMK(MCBSP_SRGR_CLKSP,0x00) |
		CSL_FMK(MCBSP_SRGR_FSGM,0x00) |
		CSL_FMK(MCBSP_SRGR_FPER,0x00) |
		CSL_FMK(MCBSP_SRGR_FWID,0x00) |
		CSL_FMK(MCBSP_SRGR_CLKGDV,clkdv);

	if(isInternalCLK)
	{
		mcbspCfg.SRGR|= CSL_FMK(MCBSP_SRGR_CLKSM,0x01);		//0x00000001u
	}
	else
	{
		mcbspCfg.SRGR|= CSL_FMK(MCBSP_SRGR_CLKSM,0x00);		//0x00000000u
	}

    mcbspCfg.XCR =
        CSL_FMK(MCBSP_XCR_XPHASE,0x01) |					//0x00000001u
        CSL_FMK(MCBSP_XCR_XFRLEN2,(Uint32)(tx_stop_bits - 1)) |		// tx_stop_bits - 1
        CSL_FMK(MCBSP_XCR_XWDLEN2,0x02) |					//0x00000002u
        CSL_FMK(MCBSP_XCR_XCOMPAND,0x00) |				//0x00000000u
        CSL_FMK(MCBSP_XCR_XFIG,0x01) |							//0x00000001u
        CSL_FMK(MCBSP_XCR_XDATDLY,0x00) |					//0x00000000u
        CSL_FMK(MCBSP_XCR_XFRLEN1,(Uint32)tx_data_bits) |		//tx_data_bits
        CSL_FMK(MCBSP_XCR_XWDLEN1,0x05) |					//0x00000005u
        CSL_FMK(MCBSP_XCR_XWDREVRS,0x00);			//0x00000000u

    mcbspCfg.RCR =
        CSL_FMK(MCBSP_RCR_RPHASE,0x01) |					//0x00000001u
        CSL_FMK(MCBSP_RCR_RFRLEN2,(Uint32)(rx_stop_bits - 1)) |		//rx_stop_bits - 1
        CSL_FMK(MCBSP_RCR_RWDLEN2,0x02) |					//0x00000002u
        CSL_FMK(MCBSP_RCR_RCOMPAND,0x00) |				//0x00000000u
        CSL_FMK(MCBSP_RCR_RFIG,0x01) |							//0x00000001u
        CSL_FMK(MCBSP_RCR_RDATDLY,0x01) |					//0x00000001u
        CSL_FMK(MCBSP_RCR_RFRLEN1,(Uint32)rx_data_bits) |		//rx_data_bits
        CSL_FMK(MCBSP_RCR_RWDLEN1,0x05) |					//0x00000005u
        CSL_FMK(MCBSP_RCR_RWDREVRS,0x00);			//0x00000000u

    mcbspCfg.SPCR =
        CSL_FMK(MCBSP_SPCR_FREE,0x01) |				// NO  0x00000001u
        CSL_FMK(MCBSP_SPCR_SOFT,0x00) |			// YES  0x00000000u
        CSL_FMK(MCBSP_SPCR_FRST,0x00) |			// YES  0x00000000u
        CSL_FMK(MCBSP_SPCR_GRST,0x00) |			// YES  0x00000000u
        CSL_FMK(MCBSP_SPCR_XINTM,0x00) | 				//0x00000000u
        CSL_FMK(MCBSP_SPCR_XSYNCERR,0x00) |	// NO  0x00000000u
        CSL_FMK(MCBSP_SPCR_XRST,0x00) |		//	0x00000000u
        CSL_FMK(MCBSP_SPCR_DLB,0x00) |					//  0x00000000u
        CSL_FMK(MCBSP_SPCR_RJUST,0x00) |				//  0x00000000u
        CSL_FMK(MCBSP_SPCR_CLKSTP,0x00) |		//  0x00000000u
        CSL_FMK(MCBSP_SPCR_DXENA,0x00) | 				//  0x00000000u
        CSL_FMK(MCBSP_SPCR_RINTM,0x00) |     		// EOS  0x00000000u
        CSL_FMK(MCBSP_SPCR_RSYNCERR,0x00) |	//  0x00000000u
        CSL_FMK(MCBSP_SPCR_RRST,0x00);		//  0x00000000u
        
	mcbspCfg.MCR= 0;
	mcbspCfg.RCERE0 = 0;
	mcbspCfg.XCERE0 = 0;
	mcbspCfg.RCERE1 = 0;
	mcbspCfg.XCERE1 = 0;
	mcbspCfg.RCERE2 = 0;
	mcbspCfg.XCERE2 = 0;
	mcbspCfg.RCERE3 = 0;
	mcbspCfg.XCERE3 = 0; 
	
	status = CSL_mcbspHwSetupRaw(handle_mcbsp1, &mcbspCfg);

	// Disable any previous machine state
	// - McBSP disable   (aA Oo oIAo Aע AII Disable I A E)

	
	mcbspCfg.SPCR |= CSL_FMK(MCBSP_SPCR_RRST, 0);		//yes
	mcbspCfg.SPCR |= CSL_FMK(MCBSP_SPCR_XRST, 0);		//yes
	//sample rate set
//	mcbspCfg.SPCR |= CSL_FMK(MCBSP_SPCR_GRST, 1);	//no
//	mcbspCfg.SPCR |= CSL_FMK(MCBSP_SPCR_FRST, 1);		//no
	status = CSL_mcbspHwSetupRaw(handle_mcbsp1, &mcbspCfg);
#endif
}
//---------------------------------------------------------------------------
void McBSP_Close()
{
	CSL_mcbspClose(handle_mcbsp1);
}
//---------------------------------------------------------------------------
void McBSP_Enable()
{
	handle_mcbsp1->regs->SPCR |= CSL_FMK(MCBSP_SPCR_RRST, 1);
	handle_mcbsp1->regs->SPCR |= CSL_FMK(MCBSP_SPCR_XRST, 1);
}
	
//---------------------------------------------------------------------------
void RS232_Init(TRS232Handle *handle, int bps, int tx_stop_bits, int tx_data_bits,
	int tx_total_bits, int rx_stop_bits, int rx_data_bits, int rx_total_bits, int mcbspDeviceIndex, char isInternalCLK)
{
	handle->TX.BitBufferPosition = 0;
	handle->TX.DataPosition = 0;
	handle->TX.DataLength = 0;
	handle->TX.Status = RS232_TX_STATUS_NONE;	
	handle->TX.BitCount = tx_total_bits;
	handle->TX.DataBitCount = tx_data_bits;
	handle->TX.StopBitCount = tx_stop_bits;
	handle->RX.BitBufferPosition = 0;
	handle->RX.DataPosition = 0;
	handle->RX.Status = RS232_RX_STATUS_NONE;
	handle->RX.BitCount = rx_total_bits;
	handle->RX.DataBitCount = rx_data_bits;
	handle->RX.StopBitCount = rx_stop_bits;

	McBSP_Init(bps, tx_stop_bits, tx_data_bits, rx_stop_bits, rx_data_bits, mcbspDeviceIndex, isInternalCLK);
} 
//---------------------------------------------------------------------------
void RS232_Close(TRS232Handle *handle)
{
	McBSP_Close();
}
//---------------------------------------------------------------------------
void RS232_Enable(TRS232Handle *handle)
{
	McBSP_Enable();
}
//---------------------------------------------------------------------------
void RS232_SetAddr(TRS232Handle *handle, char *txAddr, int txMaxSize, char *rxAddr, int rxMaxSize)
{
	handle->TX.DataBufferAddr = txAddr;
	handle->TX.DataBufferSize = txMaxSize;
	handle->RX.DataBufferAddr = rxAddr;
	handle->RX.DataBufferSize = rxMaxSize;
}
//---------------------------------------------------------------------------
void RS232_ClearRX(TRS232Handle *handle)
{
	handle->RX.BitBufferPosition = 0;
	handle->RX.DataPosition = 0;
} 
//---------------------------------------------------------------------------
void RS232_SetEOT_Time(TRS232Handle *handle)
{
	handle->RX.EOT_Type = EOT_TYPE_TIME;
}
//---------------------------------------------------------------------------
void RS232_SetEOT_None(TRS232Handle *handle)
{
	handle->RX.EOT_Type = EOT_TYPE_NONE;
}
//---------------------------------------------------------------------------
void RS232_SetEOT_Count(TRS232Handle *handle, int count)
{
	handle->RX.EOT_Type = EOT_TYPE_COUNT;
	handle->RX.EOT_DataSize = count;
}
//---------------------------------------------------------------------------
void RS232_SetEOT_Char(TRS232Handle *handle, char eotChar)
{
	handle->RX.EOT_Type = EOT_TYPE_CHAR;
	handle->RX.EOT_Char = eotChar;
}
//---------------------------------------------------------------------------
void RS232_TxStart(TRS232Handle *handle, int length)
{

	CSL_BitMask16        ctrlMask;
	handle->TX.DataPosition = 0;	
	handle->TX.DataLength = length;
	handle->TX.BitBufferPosition = 0;
	handle->TX.Status = RS232_TX_STATUS_SENDING;

	handle->RX.Status = RS232_RX_STATUS_READY;
	RS232_ClearRX(handle);

       ctrlMask = CSL_MCBSP_CTRL_TX_ENABLE | CSL_MCBSP_CTRL_RX_ENABLE;
       CSL_mcbspHwControl(handle_mcbsp1, CSL_MCBSP_CMD_RESET_CONTROL, &ctrlMask);

	RS232_ProcessTx(handle->TX.BitBuffer, handle->TX.DataBufferAddr[handle->TX.DataPosition], handle->TX.StopBitCount);
//	CSL_mcbspWrite(handle_mcbsp1,CSL_MCBSP_WORDLEN_32, &handle->TX.BitBuffer[handle->TX.BitBufferPosition++]);
	handle_mcbsp1->regs->DXR = handle->TX.BitBuffer[handle->TX.BitBufferPosition++];
}
//---------------------------------------------------------------------------

/*
 *  ======== decodeBit ========
 *
 *  This function decoded the received character by testing the     
 *  center 4 bits of the baud. A majority rule is used for the      
 *  decoding
 */
int RS232_DecodeBit(unsigned int value)
{
    /* Test middle 4 bits in received raw data */
    value = ((value >> 14) & 0x0F);

    if ((value == 7) || (value > 10))           // sampled bit 0111, 1011, 1100, 1101, 1110 and 1111 are equal to 1
    {
        return (1);
    }
    else 
    {
        return (0);
    }
}


/*
 *  ======== processRx ========
 *  Process Reception function : Reception of a buffer from the 
 *  McBSP and reformat it to get the associated character value 
 */

// decode 1 start word(32bits) + 8 data word(8 * 32bits) + n stop words(n * 32bits)
// to 1 start bit + 8 data bits + n stop bits
void RS232_ProcessRx(unsigned int *buffer, char *rxchar)
{
    unsigned int rawData = 0;
    int bitValue;
    unsigned int bitCnt;

	*rxchar = 0;

	// skip start bit
    rawData = *buffer++;
	
        
    /* Walk through each data bit */
    for (bitCnt = 0; bitCnt < 8; bitCnt++) 
    {
        /* read raw bit (word) from dma buffer */
        rawData = *buffer++;

        /* get the value of the majority of the bits */
        bitValue = RS232_DecodeBit(rawData);
                        
        /* put received bit into proper place */
        *rxchar += bitValue << bitCnt;
    }
}
//---------------------------------------------------------------------------
/*
 *  ======== processTx ========
 *
 *  Process transmission function : this function is filling the
 *  xmitbuffer with appropriate data or 0xFFFF if idle mode.
 */
void RS232_ProcessTx(unsigned int *buffer, char txchar, int stopBitCount)
{
    unsigned int bitCnt;
                        
    /* Set start bit in buffer */
    *buffer++ = 0x00000000;

    /* Walk through each data bit */
    for (bitCnt = 0; bitCnt < 8; bitCnt++) 
    {
        /* determine state of bit and set dma buffer value */
        if ((txchar >> bitCnt & 0x1) == 1 ) 
        {
            *buffer++ = 0xFFFFFFFF;
        }
        else 
        {
            *buffer++ = 0x00000000;
        }
    }

	for (bitCnt = 0; bitCnt < stopBitCount; bitCnt++)
	{
	    *buffer++ = 0xFFFFFFFF;
	}
}
//---------------------------------------------------------------------------
void IsrRS232Rx(TRS232Handle *handle)
{
	unsigned int dummy;
	CSL_Status           status = CSL_SOK;

//	dummy = CSL_mcbspRead(handle_mcbsp1,CSL_MCBSP_WORDLEN_32 ,&dummy);
	dummy = handle_mcbsp1->regs->DRR;

	if (handle->RX.Status == RS232_RX_STATUS_READY)
	{
	   	if (handle->RX.BitBufferPosition < handle->RX.BitCount)
	   	{
			if (handle->RX.BitBufferPosition == 0)
			{
				if (RS232_DecodeBit(dummy) == 0)	// checking start bit
				{
					handle->RX.BitBuffer[handle->RX.BitBufferPosition++] = dummy;
				}
			}
			else
			{
				handle->RX.BitBuffer[handle->RX.BitBufferPosition++] = dummy;
			}
		} 

	   	if (handle->RX.BitBufferPosition >= handle->RX.BitCount)
		{
			if (handle->RX.DataPosition < handle->RX.DataBufferSize) 
			{
				RS232_ProcessRx(handle->RX.BitBuffer, &(handle->RX.DataBufferAddr[handle->RX.DataPosition]));
				if (handle->RX.EOT_Type == EOT_TYPE_CHAR)
				{
					if (handle->RX.DataBufferAddr[handle->RX.DataPosition] == handle->RX.EOT_Char) 
					{
						handle->RX.Status = RS232_RX_STATUS_RECEIVED;
					}
				}
				else if (handle->RX.EOT_Type == EOT_TYPE_COUNT)
				{
					if (handle->RX.DataPosition + 1 == handle->RX.EOT_DataSize) 
					{
						handle->RX.Status = RS232_RX_STATUS_RECEIVED;
					}
				}
				handle->RX.DataPosition++;
			}
			else
			{
				handle->RX.Status = RS232_RX_STATUS_RECEIVED;		// received, but overflowed
			}
			handle->RX.BitBufferPosition = 0;
		}
	}
}
//---------------------------------------------------------------------------
void IsrRS232Tx(TRS232Handle *handle)
{

	if (handle->TX.Status == RS232_TX_STATUS_SENDING)
	{
		if (handle->TX.BitBufferPosition >= handle->TX.BitCount)
		{
			handle->TX.BitBufferPosition = 0;
			handle->TX.DataPosition++;
			if (handle->TX.DataPosition >= handle->TX.DataLength)
			{
				handle->TX.Status = RS232_TX_STATUS_READY;		// tx complete
			}
			else
			{
				RS232_ProcessTx(handle->TX.BitBuffer, handle->TX.DataBufferAddr[handle->TX.DataPosition], handle->TX.StopBitCount);
				//CSL_mcbspWrite(handle_mcbsp1, CSL_MCBSP_WORDLEN_32, &handle->TX.BitBuffer[handle->TX.BitBufferPosition++]);
				handle_mcbsp1->regs->DXR = handle->TX.BitBuffer[handle->TX.BitBufferPosition++];
				
			}
		}
		else
		{
				//CSL_mcbspWrite(handle_mcbsp1, CSL_MCBSP_WORDLEN_32, &handle->TX.BitBuffer[handle->TX.BitBufferPosition++]);
				handle_mcbsp1->regs->DXR = handle->TX.BitBuffer[handle->TX.BitBufferPosition++];
		}
	}
}
//---------------------------------------------------------------------------
void RS232_SetBaudRate(TRS232Handle *handle, int baudRate)
{
	unsigned int clkdv;
	char isInternalCLK;

/*
	if (baudRate > 50000)
	{
		isInternalCLK = TRUE;
	}
	else
	{
		isInternalCLK = FALSE;
	}
*/
	isInternalCLK = FALSE;
	//mcbsp1 disable
	handle_mcbsp1->regs->SPCR ^= CSL_FMK(MCBSP_SPCR_GRST, 1);	//disable
	handle_mcbsp1->regs->SPCR ^= CSL_FMK(MCBSP_SPCR_FRST, 1);		//disable

	if (isInternalCLK)
	{
//		MCBSP_FSETSH(handle->McbspHandle, SRGR, CLKSM, INTERNAL);
		handle_mcbsp1->regs->SRGR |=  CSL_FMK(MCBSP_SRGR_CLKSM,0x01);
		clkdv = (unsigned int)(((float)CPU_CLK / (float)(baudRate * 32)) + 0.75) - 1;
//		MCBSP_FSETH(handle->McbspHandle, SRGR, CLKGDV, MCBSP_SRGR_CLKGDV_OF(clkdv));
		handle_mcbsp1->regs->SRGR |=  CSL_FMK(MCBSP_SRGR_CLKGDV,clkdv);
	}
	else
	{
//		MCBSP_FSETSH(handle->McbspHandle, SRGR, CLKSM, CLKS);
		handle_mcbsp1->regs->SRGR |= CSL_FMK(MCBSP_SRGR_CLKSM,0x00);
		clkdv = (unsigned int)(((float)OSC_CLK / (float)(baudRate * 32)) + 0.75) - 1;
//		MCBSP_FSETH(handle->McbspHandle, SRGR, CLKGDV, MCBSP_SRGR_CLKGDV_OF(clkdv));
		handle_mcbsp1->regs->SRGR &= CSL_FMK(MCBSP_SRGR_CLKGDV,0);
		handle_mcbsp1->regs->SRGR |= CSL_FMK(MCBSP_SRGR_CLKGDV,clkdv);
	}
	handle_mcbsp1->regs->SPCR |= CSL_FMK(MCBSP_SPCR_GRST, 1);	//enable
	handle_mcbsp1->regs->SPCR |= CSL_FMK(MCBSP_SPCR_FRST, 1);		//enable
}
