#ifndef _USB_CONTROL_TRANSFER_H_
#define _USB_CONTROL_TRANSFER_H_

#include "usb_standard.h"
#include "USB_IO_Control.h"

#define MAX_CONTROLDATA_SIZE					16


#define USB_IO_REQUEST_STATE_IDLE				0
#define USB_IO_REQUEST_STATE_PENDING			1

typedef struct 
{
	unsigned char 		DCP_state;
	unsigned char 		USBRxIORequestState;
	unsigned char 		USBTxIORequestState;
	unsigned char 		USBSetupIORequestState;
	unsigned char 		SetupPacketDone;
	unsigned char 		RxPacketDone;
	unsigned char 		TxPacketDone;
	unsigned char		RxDataExists;
	unsigned char 		TxIdle;
	unsigned char		reserved[3];

	TDeviceRequestData  DeviceRequest;
	unsigned short  	RequestDataLength;
	unsigned short  	TXLength;
	unsigned short  	RXLength;
	unsigned short  	TXCount;
	unsigned short  	RXCount;
	unsigned char		*TXAddr;
	unsigned char		DataStageBuffer[MAX_CONTROLDATA_SIZE];


	TUSBIORequestControlData RXIORequestControlData;
	TUSBIORequestControlData TXIORequestControlData;
	TUSBIORequestControlData SetupIORequestControlData;
} TUSBControlTransferInfo;

extern TUSBControlTransferInfo USBControlTransferInfo;

#endif
