#include "common.h"


// Common Function

unsigned int CheckSum(unsigned int* src, unsigned int len)
{
	register unsigned int sum = 0;
	while (len--)
	{
		sum += *src++;
	}
	return sum;
}

unsigned int CheckSumByte(unsigned char* src, unsigned int len)
{
	register unsigned int sum = 0;
	while (len--)
	{
		sum += *src++;
	}
	return sum;
}

unsigned int ImageCheckSum(unsigned char* src, int left, int top, int width, int height, int ImageWidth, int size)
{
	int x, y;
	int startX, endX, startY, endY;
	register unsigned int sum = 0;

	startX = left;
	endX = left + width;
	startY = top;
	endY = top + height;

	startX += 8;
	endX -= 8;
	startY += 8;
	endY -= 8;

	for(y = startY; y <= endY; y+=size)
	{
		for(x = startX; x <= endX; x+=size)
		{
			sum += *(src + ImageWidth * y + x);		
		}
	}

	return sum;
}

unsigned int CheckParity(unsigned int* src, unsigned int len)
{
	register unsigned int sum = 0;
	while (len--)
	{
		sum ^= *src++;
	}
	return sum;
}


int SizeOfWord(int size)
{
	return (size + 3) / 4;
}

