//---------------------------------------------------------------------------
#ifndef AbstractDBH
#define AbstractDBH

#include <Classes.hpp>
#include "Processing.h"
//---------------------------------------------------------------------------
#define CURRENT_DEFECT_DATA_VERSION			101

typedef struct
{
	int Version;
	int dummy[3];
} TDefectDataHeader;

typedef struct
{
	TDefectDataHeader DefectDataHeader;
	TDefectData_PC DefectData;
} TDefectFileData;

class TDefectDataDB
{
private:
	WideString FProductCode;
	WideString FLotCode;
	int FDataCount;
	TList *DataList;
	TList *DataValidList;

  int StandardFDataCount;
	void __fastcall ClearList(void);
	bool __fastcall WriteDefectDataCount(void);

public:
	__fastcall TDefectDataDB();
	__fastcall ~TDefectDataDB();
	void __fastcall LoadData(bool Inspectionstatus = false,bool ReadAllData = false);
	bool __fastcall ConnectTable(WideString productCode, WideString lotCode,bool Inspectionstatus = false,bool ReadAllData = false );
	bool __fastcall GetDefectData(TDefectData_PC *aDefectData, int defectDataIndex);
	bool __fastcall ReadDefectData(TDefectData_PC *aDefectData, int defectDataIndex);
	int __fastcall AddDefectData(TDefectData_PC *aDefectData);
	bool __fastcall CleanDefectData(void);

	__property int DataCount = {read = FDataCount};
  __property int StandardDataCount = {write = StandardFDataCount};
};

extern TDefectDataDB DefectDataDB;
//---------------------------------------------------------------------------
#endif
