//---------------------------------------------------------------------------
// For SELMA200, 20180223, moon,  
//---------------------------------------------------------------------------

#include <vcl.h>
#pragma hdrstop

#include "AdvMachineControl_Form.h"
#include "Environment.h"
#include "Message_Form.h"
#include "Keyboard_Form.h"
#include "MotorSpeedSelection_Form.h"
#include "NCControl_Form.h"
#include "MachineSetting_Form.h"
#include "MachineControl.h"
#include "MultiLanguage.h"

//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma link "TntButtons"
#pragma link "TntExtCtrls"
#pragma link "TntStdCtrls"
#pragma resource "*.dfm"
TAdvMachineControlForm *AdvMachineControlForm;
//---------------------------------------------------------------------------
__fastcall TAdvMachineControlForm::TAdvMachineControlForm(TComponent* Owner)
	: TTntForm(Owner)
{
	if (DefaultLCID == 1028 || DefaultLCID == 2052 || DefaultLCID == 3076 || DefaultLCID == 4100)
		ComponentSetFontName(this, "SimSun");
	else if (DefaultLCID == 1041)
		ComponentSetFontName(this, "Meiryo UI");
  else if(DefaultLCID == 3082)
  {
    ComponentSetFontName(this, "Segoe UI");
    ComponentSetMultiLine(this);
  }

	GetDefaultString();

	ServoMotorSpeedToRPMParam[0] = SERVO_MOTOR_SPEED_TO_RPM_PARAM1;
	ServoMotorSpeedToRPMParam[1] = SERVO_MOTOR_SPEED_TO_RPM_PARAM2;
	ServoMotorSpeedToRPMParam[2] = SERVO_MOTOR_SPEED_TO_RPM_PARAM3;
	ServoMotorSpeedToRPMParam[3] = SERVO_MOTOR_SPEED_TO_RPM_PARAM4;
    ServoMotorSpeedToRPMParam[4] = SERVO_MOTOR_SPEED_TO_RPM_PARAM5;

	if (MachineSetupData.CompanyID == INTERNATIONAL_MACHINE1)
	{
		InverterSpeedLabel3->Visible = true;
		TntLabel1->Visible = true;
		Machine.MisejectClose();
	}
}
//---------------------------------------------------------------------------
void __fastcall TAdvMachineControlForm::GetDefaultString()
{
	VFRunSpeedButton->Caption = ADVMACHINECONTROLFORM_BUTTON_CAPTION_01;
	BlowerAllOffButton->Caption = ADVMACHINECONTROLFORM_BUTTON_CAPTION_02;
	BlowerAllOnButton->Caption = ADVMACHINECONTROLFORM_BUTTON_CAPTION_03;
	LowLevelControlButton->Caption = ADVMACHINECONTROLFORM_BUTTON_CAPTION_04;
	ServoMotorSpeedSpeedButton2->Caption = ADVMACHINECONTROLFORM_BUTTON_CAPTION_05;
	Button1->Caption = ADVMACHINECONTROLFORM_BUTTON_CAPTION_06;
	ServoMotorSpeedSpeedButton1->Caption = ADVMACHINECONTROLFORM_BUTTON_CAPTION_07;
	CloseButton->Caption = ADVMACHINECONTROLFORM_BUTTON_CAPTION_08;
	MainControlReadyButton->Caption = ADVMACHINECONTROLFORM_BUTTON_CAPTION_09;
	RBOffSpeedButton4->Caption = ADVMACHINECONTROLFORM_BUTTON_CAPTION_10;
	RBOnSpeedButton4->Caption = ADVMACHINECONTROLFORM_BUTTON_CAPTION_11;
	ServoMotorSpeedSpeedButton3->Caption = ADVMACHINECONTROLFORM_BUTTON_CAPTION_12;
	RBOffSpeedButton1->Caption = ADVMACHINECONTROLFORM_BUTTON_CAPTION_13;
	RBOnSpeedButton1->Caption = ADVMACHINECONTROLFORM_BUTTON_CAPTION_14;
	RBOffSpeedButton3->Caption = ADVMACHINECONTROLFORM_BUTTON_CAPTION_15;
	RBOnSpeedButton3->Caption = ADVMACHINECONTROLFORM_BUTTON_CAPTION_16;
	NCControlButton->Caption = ADVMACHINECONTROLFORM_BUTTON_CAPTION_17;
	MainControlRunButton->Caption = ADVMACHINECONTROLFORM_BUTTON_CAPTION_18;
	VFAutoSpeedButton->Caption = ADVMACHINECONTROLFORM_BUTTON_CAPTION_19;
	MainControlStopButton->Caption = ADVMACHINECONTROLFORM_BUTTON_CAPTION_20;
	VDStopSpeedButton->Caption = ADVMACHINECONTROLFORM_BUTTON_CAPTION_21;
	MainControlCleaningButton->Caption = ADVMACHINECONTROLFORM_BUTTON_CAPTION_22;
	MainMachineStatusCleaningPanel->Caption = ADVMACHINECONTROLFORM_BUTTON_CAPTION_22;
	this->Caption = ADVMACHINECONTROLFORM_FORM_CAPTION_01;
	GroupBox11->Caption = ADVMACHINECONTROLFORM_GROUPBOX_CAPTION_01;
	GroupBox10->Caption = ADVMACHINECONTROLFORM_GROUPBOX_CAPTION_02;
	GroupBox15->Caption = ADVMACHINECONTROLFORM_GROUPBOX_CAPTION_03;
	GroupBox8->Caption = ADVMACHINECONTROLFORM_GROUPBOX_CAPTION_04;
	GroupBox12->Caption = ADVMACHINECONTROLFORM_GROUPBOX_CAPTION_05;
	GroupBox2->Caption = ADVMACHINECONTROLFORM_GROUPBOX_CAPTION_06;
	GroupBox16->Caption = ADVMACHINECONTROLFORM_GROUPBOX_CAPTION_07;
	GroupBox5->Caption = ADVMACHINECONTROLFORM_GROUPBOX_CAPTION_08;
	GroupBox7->Caption = ADVMACHINECONTROLFORM_GROUPBOX_CAPTION_09;
	GroupBox6->Caption = ADVMACHINECONTROLFORM_GROUPBOX_CAPTION_10;
	GroupBox3->Caption = ADVMACHINECONTROLFORM_GROUPBOX_CAPTION_11;
	GroupBox17->Caption = ADVMACHINECONTROLFORM_GROUPBOX_CAPTION_12;
	GroupBox9->Caption = ADVMACHINECONTROLFORM_GROUPBOX_CAPTION_13;
	GroupBox14->Caption = ADVMACHINECONTROLFORM_GROUPBOX_CAPTION_15;
	GroupBox1->Caption = ADVMACHINECONTROLFORM_GROUPBOX_CAPTION_16;
	Label40->Caption = ADVMACHINECONTROLFORM_LABEL_CAPTION_01;
	Label12->Caption = ADVMACHINECONTROLFORM_LABEL_CAPTION_02;
	Label17->Caption = ADVMACHINECONTROLFORM_LABEL_CAPTION_03;
	TntLabel1->Caption = ADVMACHINECONTROLFORM_LABEL_CAPTION_43;
	Label4->Caption = ADVMACHINECONTROLFORM_LABEL_CAPTION_04;
	Label25->Caption = ADVMACHINECONTROLFORM_LABEL_CAPTION_05;
	Label36->Caption = ADVMACHINECONTROLFORM_LABEL_CAPTION_06;
	Label42->Caption = ADVMACHINECONTROLFORM_LABEL_CAPTION_07;
	Label1->Caption = ADVMACHINECONTROLFORM_LABEL_CAPTION_08;
	Label2->Caption = ADVMACHINECONTROLFORM_LABEL_CAPTION_09;
	TemperatureLabel1->Caption = ADVMACHINECONTROLFORM_LABEL_CAPTION_10;
	Label29->Caption = ADVMACHINECONTROLFORM_LABEL_CAPTION_11;
	Label30->Caption = ADVMACHINECONTROLFORM_LABEL_CAPTION_12;
	Label5->Caption = ADVMACHINECONTROLFORM_LABEL_CAPTION_13;
	Label5->Caption = ADVMACHINECONTROLFORM_LABEL_CAPTION_15;
	Label28->Caption = ADVMACHINECONTROLFORM_LABEL_CAPTION_16;
	Label27->Caption = ADVMACHINECONTROLFORM_LABEL_CAPTION_17;	
	Label38->Caption = ADVMACHINECONTROLFORM_LABEL_CAPTION_19;
	Label8->Caption = ADVMACHINECONTROLFORM_LABEL_CAPTION_20;
	Label13->Caption = ADVMACHINECONTROLFORM_LABEL_CAPTION_21;
	Label18->Caption = ADVMACHINECONTROLFORM_LABEL_CAPTION_22;
	Label20->Caption = ADVMACHINECONTROLFORM_LABEL_CAPTION_23;
	Label22->Caption = ADVMACHINECONTROLFORM_LABEL_CAPTION_24;
	Label23->Caption = ADVMACHINECONTROLFORM_LABEL_CAPTION_26;
	Label30->Caption = ADVMACHINECONTROLFORM_LABEL_CAPTION_28;
	Label7->Caption = ADVMACHINECONTROLFORM_LABEL_CAPTION_28;
	Label10->Caption = ADVMACHINECONTROLFORM_LABEL_CAPTION_30;
	Label19->Caption = ADVMACHINECONTROLFORM_LABEL_CAPTION_31;
	Label21->Caption = ADVMACHINECONTROLFORM_LABEL_CAPTION_32;
	Label48->Caption = ADVMACHINECONTROLFORM_LABEL_CAPTION_33;
	Label11->Caption = ADVMACHINECONTROLFORM_LABEL_CAPTION_35;
	Label16->Caption = ADVMACHINECONTROLFORM_LABEL_CAPTION_36;
	Label3->Caption = ADVMACHINECONTROLFORM_LABEL_CAPTION_37;
	Label24->Caption = ADVMACHINECONTROLFORM_LABEL_CAPTION_38;
	Label26->Caption = ADVMACHINECONTROLFORM_LABEL_CAPTION_39;

	AirKnifeSpeedPanel1->Caption = ADVMACHINECONTROLFORM_PANEL_CAPTION_01;
	AirKnifeSpeedPanel2->Caption = ADVMACHINECONTROLFORM_PANEL_CAPTION_02;
	AirKnifeSpeedPanel3->Caption = ADVMACHINECONTROLFORM_PANEL_CAPTION_03;
	MainMachineStatusRunPanel->Caption = ADVMACHINECONTROLFORM_PANEL_CAPTION_04;
	SubControlMenuPanel->Caption = ADVMACHINECONTROLFORM_PANEL_CAPTION_05;
	Panel1->Caption = ADVMACHINECONTROLFORM_PANEL_CAPTION_06;
	MainMachineStatusEmergencyStopPanel->Caption = ADVMACHINECONTROLFORM_PANEL_CAPTION_07;
	UnitControlMenuPanel->Caption = ADVMACHINECONTROLFORM_PANEL_CAPTION_08;
	StatusMenuPanel->Caption = ADVMACHINECONTROLFORM_PANEL_CAPTION_09;
	ParameterMenuPanel->Caption = ADVMACHINECONTROLFORM_PANEL_CAPTION_10;

	Label43->Caption = ADVMACHINECONTROLFORM_LABEL_CAPTION_42; //
	
	GroupBox4->Caption = ADVMACHINECONTROLFORM_GROUPBOX_CAPTION_06; //ο
	MainMachineStatusStopPanel->Caption = ADVMACHINECONTROLFORM_BUTTON_CAPTION_21; // 
	Label35->Caption = ADVMACHINECONTROLFORM_LABEL_CAPTION_12; // Ƽ Ʈ 2 
	BowlFeederRunButton->Caption = ADVMACHINECONTROLFORM_BUTTON_CAPTION_18; // 
	BowlFeederStopButton->Caption = ADVMACHINECONTROLFORM_BUTTON_CAPTION_21; // 
	VDRunSpeedButton->Caption = ADVMACHINECONTROLFORM_BUTTON_CAPTION_18; // 

	ErrorMsg[0] = ADVMACHINECONTROLFORM_MSG_01;

	if(MachineSetupData.MachineType < 2)
	{
		Label6->Caption = ADVMACHINECONTROLFORM_LABEL_CAPTION_13;// Ǵ ٱ ũ ӵ
		//TntLabel2->Caption = "ȸ̵  ũ";
		Label14->Caption = ADVMACHINECONTROLFORM_LABEL_CAPTION_14;
		Label15->Caption = ADVMACHINECONTROLFORM_LABEL_CAPTION_18;
		TntLabel2->Visible =false;
		BFOD2SpeedPanel->Visible = false;
		
	}
	else// ۾
	{
		Label6->Caption = ADVMACHINECONTROLFORM_LABEL_CAPTION_45;// Ǵ ٱ ũ ӵ
		TntLabel2->Caption = ADVMACHINECONTROLFORM_LABEL_CAPTION_46;
		Label14->Caption = ADVMACHINECONTROLFORM_LABEL_CAPTION_47;//ADVMACHINECONTROLFORM_LABEL_CAPTION_14;
		Label15->Caption = ADVMACHINECONTROLFORM_LABEL_CAPTION_48;//ADVMACHINECONTROLFORM_LABEL_CAPTION_18;		
		TntLabel2->Visible =true;
        BFOD2SpeedPanel->Visible = true;
	}


}
//---------------------------------------------------------------------------
void __fastcall TAdvMachineControlForm::CloseButtonClick(TObject *Sender)
{
	this->Close();
}
//---------------------------------------------------------------------------
void __fastcall TAdvMachineControlForm::MainControlRunButtonClick(
	TObject *Sender)
{
	if (ProductData.ProductCode.IsEmpty())
	{
		ShowMessageFA(ErrorMsg[0]);
		return;
	}

  if (Machine.Status.OperationState != MACHINE_STATE_STOP &&
			Machine.Status.OperationState != MACHINE_STATE_CLEANING &&
			Machine.Status.OperationState != MACHINE_STATE_ATTACHING &&
			Machine.Status.OperationState != MACHINE_STATE_DETACHING)
  {
    Machine.MachineStop();
    ShowMessageFA(INSPECTIONFORM_MSG_23);
    return;
  }

	TMachineRunOption machineRunOption;

	if (MachineControlParams.VFAutoTrainMode)
	{
		machineRunOption.MaxSpeedTrainingMode = MAX_SPEED_TRAINING_MODE_AUTO;
	}
	else
	{
		machineRunOption.MaxSpeedTrainingMode = MAX_SPEED_TRAINING_MODE_MANUAL;
	}
	machineRunOption.ManualMaxSpeed = MachineControlParams.VFManualMaxSpeed;
	machineRunOption.ManualModeSensorIndex = MachineControlParams.ManualModeSensorIndex;
	machineRunOption.ManualModeSensorActiveRatio = MachineControlParams.ManualModeSensorActiveRatio;
	machineRunOption.ManualLimitSpeed = MachineControlParams.VFManualLimitSpeed;
	machineRunOption.ManualModeLimitSensorIndex = MachineControlParams.ManualModeLimitSensorIndex;
	machineRunOption.ManualModeLimitSensorActiveRatio = MachineControlParams.ManualModeLimitSensorActiveRatio;
	machineRunOption.EmptySensorActiveRatio = MachineControlParams.EmptySensorActiveRatio;
	machineRunOption.FullSensorActiveRatio = MachineControlParams.FullSensorActiveRatio;
	machineRunOption.AirKnifeSpeed = MachineControlParams.AirKnifeSpeed;
	machineRunOption.SuctionDisk1InverterSpeed = MachineControlParams.SuctionDisk1InverterSpeed;
	machineRunOption.SuctionDisk2InverterSpeed = MachineControlParams.SuctionDisk2InverterSpeed;
	machineRunOption.adjustEjectorWindStrength = MachineSetupData.EjectorInfo.EjectorWindStrength;

	if (SensorRadioBtn1->Checked)
		machineRunOption.EnabledSensorType = 0;
	else if (SensorRadioBtn2->Checked)
		machineRunOption.EnabledSensorType = 1;
	else
		machineRunOption.EnabledSensorType = 0;

	Machine.MachineRun(PROCEDURE_MODE_CAPTURE, &machineRunOption, ProductData.NCMotorPos, MachineControlParams.ServoMotorSpeed);

	MachineOperationInfo.ServoMotorSpeed[SD1_MOTOR_INDEX] = MachineControlParams.ServoMotorSpeed[SD1_MOTOR_INDEX];
	MachineOperationInfo.ServoMotorSpeed[SD2_MOTOR_INDEX] = MachineControlParams.ServoMotorSpeed[SD2_MOTOR_INDEX];
	MachineOperationInfo.ServoMotorSpeed[BF_ID_MOTOR_INDEX] = MachineControlParams.ServoMotorSpeed[BF_ID_MOTOR_INDEX];
	MachineOperationInfo.ServoMotorSpeed[BF_OD_IN_MOTOR_INDEX] = MachineControlParams.ServoMotorSpeed[BF_OD_IN_MOTOR_INDEX];

	if(MachineSetupData.MachineType == MACHINE_TYPE_SELMA_ADVANCED || MachineSetupData.MachineType == MACHINE_TYPE_LIMA_ADVANCED)
	{
		MachineOperationInfo.ServoMotorSpeed[BF_OD_OUT_MOTOR_INDEX] = MachineControlParams.ServoMotorSpeed[BF_OD_OUT_MOTOR_INDEX];
	}
	else
	{
		MachineOperationInfo.ServoMotorSpeed[BF_OD_OUT_MOTOR_INDEX] = 0;
	}
}
//---------------------------------------------------------------------------
void __fastcall TAdvMachineControlForm::MainControlStopButtonClick(
	TObject *Sender)
{
	Machine.MachineStop();
}
//---------------------------------------------------------------------------
void __fastcall TAdvMachineControlForm::MainControlCleaningButtonClick(
	TObject *Sender)
{
	Machine.MachineCleaning();
}
//---------------------------------------------------------------------------
void __fastcall TAdvMachineControlForm::MainControlReadyButtonClick(
	TObject *Sender)
{
	if (ProductData.ProductCode.IsEmpty())
	{
		ShowMessageFA(ErrorMsg[0]);
		return;
	}

	Machine.MachineReady();
}
//---------------------------------------------------------------------------
void __fastcall TAdvMachineControlForm::ApplyProductInfo(void)
{
	if (ProductData.MachineRunOption.MaxSpeedTrainingMode == MAX_SPEED_TRAINING_MODE_AUTO)
	{
		MachineControlParams.VFAutoTrainMode = true;
	}
	else
	{
		MachineControlParams.VFAutoTrainMode = false;
	}
	MachineControlParams.VFManualMaxSpeed = ProductData.MachineRunOption.ManualMaxSpeed;
	MachineControlParams.ManualModeSensorIndex = ProductData.MachineRunOption.ManualModeSensorIndex;
	MachineControlParams.ManualModeSensorActiveRatio = ProductData.MachineRunOption.ManualModeSensorActiveRatio;
	MachineControlParams.VFManualLimitSpeed = ProductData.MachineRunOption.ManualLimitSpeed;
	MachineControlParams.ManualModeLimitSensorIndex = ProductData.MachineRunOption.ManualModeLimitSensorIndex;
	MachineControlParams.ManualModeLimitSensorActiveRatio = ProductData.MachineRunOption.ManualModeLimitSensorActiveRatio;
	MachineControlParams.EmptySensorActiveRatio = ProductData.MachineRunOption.EmptySensorActiveRatio;
	MachineControlParams.FullSensorActiveRatio = ProductData.MachineRunOption.FullSensorActiveRatio;
	MachineControlParams.AirKnifeSpeed = ProductData.MachineRunOption.AirKnifeSpeed;
	MachineControlParams.SuctionDisk1InverterSpeed = ProductData.MachineRunOption.SuctionDisk1InverterSpeed;
	MachineControlParams.SuctionDisk2InverterSpeed = ProductData.MachineRunOption.SuctionDisk2InverterSpeed;

  ServoMotorSpeedSpeedButton1->Down = true;
  ServoMotorSpeedSpeedButton1->Click();

  /*
	for (int motorIndex = 0; motorIndex < MAX_SERVO_MOTOR_COUNT; motorIndex++)
	{
		MachineControlParams.ServoMotorSpeed[motorIndex] = ProductData.MotorSpeedList[motorIndex][0];
	}
  */
  
	ApplyParams();
}
//---------------------------------------------------------------------------
void __fastcall TAdvMachineControlForm::FormCreate(TObject *Sender)
{
	InitMachineControlParams();
	ApplyParams();
	RedrawForm();

  TTntSpeedButton *tempSpeedButton;
  for(int m = 1; m <= 3; m++)
  {
    tempSpeedButton = (TTntSpeedButton *) FindComponent("ServoMotorSpeedSpeedButton" + IntToStr(m));
    tempSpeedButton->Font->Color = clGray;
    tempSpeedButton->Font->Style = tempSpeedButton->Font->Style >> fsBold;
  }
}
//---------------------------------------------------------------------------
void __fastcall TAdvMachineControlForm::InitMachineControlParams(void)
{
	MachineControlParams.VFAutoTrainMode = true;
	MachineControlParams.VFManualMaxSpeed = 0;
	MachineControlParams.ManualModeSensorIndex = MachineSetupData.VFInfo.ManualModeSensorIndex;
	MachineControlParams.ManualModeSensorActiveRatio = MachineSetupData.VFInfo.ManualModeSensorActiveRatio;
	MachineControlParams.VFManualLimitSpeed = 0;

  MachineControlParams.ManualModeLimitSensorIndex = MachineSetupData.VFInfo.ManualModeLimitSensorIndex;
	MachineControlParams.ManualModeLimitSensorActiveRatio = MachineSetupData.VFInfo.ManualModeLimitSensorActiveRatio;

	MachineControlParams.EmptySensorActiveRatio = MachineSetupData.VFInfo.EmptySensorActiveRatio;
	MachineControlParams.FullSensorActiveRatio = MachineSetupData.VFInfo.FullSensorActiveRatio;
	MachineControlParams.AirKnifeSpeed = 0;
	MachineControlParams.SuctionDisk1InverterSpeed = 150;
	MachineControlParams.SuctionDisk2InverterSpeed = 150;

	MachineControlParams.ServoMotorSpeed[SD1_MOTOR_INDEX] = MachineOperationInfo.ServoMotorSpeed[SD1_MOTOR_INDEX];
	MachineControlParams.ServoMotorSpeed[SD2_MOTOR_INDEX] = MachineOperationInfo.ServoMotorSpeed[SD2_MOTOR_INDEX];
	MachineControlParams.ServoMotorSpeed[BF_ID_MOTOR_INDEX] = MachineOperationInfo.ServoMotorSpeed[BF_ID_MOTOR_INDEX];
	MachineControlParams.ServoMotorSpeed[BF_OD_IN_MOTOR_INDEX] = MachineOperationInfo.ServoMotorSpeed[BF_OD_IN_MOTOR_INDEX];

	if(MachineSetupData.MachineType == MACHINE_TYPE_SELMA_ADVANCED || MachineSetupData.MachineType == MACHINE_TYPE_LIMA_ADVANCED)
	{
		MachineControlParams.ServoMotorSpeed[BF_OD_OUT_MOTOR_INDEX] = MachineOperationInfo.ServoMotorSpeed[BF_OD_OUT_MOTOR_INDEX];
	}
	else
	{
		MachineControlParams.ServoMotorSpeed[BF_OD_OUT_MOTOR_INDEX] = 0;
	}
	
}
//---------------------------------------------------------------------------


void __fastcall TAdvMachineControlForm::RedrawForm(void)
{
	/*
	int clientWidth = 0;
	int formLeft = 0;
	clientWidth += MainMenuPanel->Width;
	if (SubControlPanel->Visible)
	{
	clientWidth += SubControlPanel->Width;
	}
	if (UnitControlPanel->Visible)
	{
	UnitControlPanel->Left = clientWidth;
	clientWidth += UnitControlPanel->Width;
	}
	if (ParameterPanel->Visible)
	{
	ParameterPanel->Left = clientWidth;
	clientWidth += ParameterPanel->Width;
	}
	if (StatusPanel->Visible)
	{
	StatusPanel->Left = clientWidth;
	clientWidth += StatusPanel->Width;
	}

	this->ClientWidth = clientWidth;

	// position screen center
	formLeft = (Screen->Width - this->Width) / 2;
	if (formLeft < 0) formLeft = 0;
	this->Left = formLeft;
	*/
}
//---------------------------------------------------------------------------


void __fastcall TAdvMachineControlForm::RBOnSpeedButtonClick(
	TObject *Sender)
{
	try
	{
		TTntSpeedButton *theButton = (TTntSpeedButton *)Sender;

		int blowerIndex = 0;
		int speed1 = MachineControlParams.SuctionDisk1InverterSpeed;
		int speed2 = MachineControlParams.SuctionDisk2InverterSpeed;

		if (theButton->Tag < 4)
		{
			blowerIndex = theButton->Tag;
		}
		else
		{
			blowerIndex = 0xFF;
		}

		Machine.RingBlowerOn(blowerIndex, speed1, speed2);
	}
	catch (Exception &ec)
	{
		ShowMessageFA(ec.Message);
	}
}
//---------------------------------------------------------------------------
void __fastcall TAdvMachineControlForm::RBOffSpeedButtonClick(
	TObject *Sender)
{
	int blowerIndex = 0;
	TTntSpeedButton *theButton = (TTntSpeedButton *)Sender;
	if (theButton->Tag < 4)
	{
		blowerIndex = theButton->Tag;
	}
	else
	{
		blowerIndex = 0xFF;
	}

	Machine.RingBlowerOff(blowerIndex);
}
//---------------------------------------------------------------------------
void __fastcall TAdvMachineControlForm::NumEditClick(TObject *Sender)
{
	TTntEdit *theEdit = (TTntEdit *)Sender;
	/*
	if(DefaultLCID != 1042 && DefaultLCID != 2066 && DefaultLCID != 1033)
	{
	KeyboardForm->SetWindowsKeyboard();
	}
	else*/
	{
		KeyboardForm->Text = theEdit->Text;
		if (KeyboardForm->ShowKeypad() == mrOk)
		{
			theEdit->Text = KeyboardForm->Text;
		}
	}
}
//---------------------------------------------------------------------------

void __fastcall TAdvMachineControlForm::RB1InverterSpeedEditChange(
	TObject *Sender)
{
	try
	{
		MachineControlParams.SuctionDisk1InverterSpeed = StrToInt(RB1InverterSpeedEdit->Text);
	}
	catch (...)
	{

	}
}
//---------------------------------------------------------------------------

void __fastcall TAdvMachineControlForm::RB2InverterSpeedEditChange(
	TObject *Sender)
{
	try
	{
		MachineControlParams.SuctionDisk2InverterSpeed = StrToInt(RB2InverterSpeedEdit->Text);
	}
	catch (...)
	{

	}
}
//---------------------------------------------------------------------------
void __fastcall TAdvMachineControlForm::ApplyParams(void)
{
	RB1InverterSpeedEdit->Text = IntToStr(MachineControlParams.SuctionDisk1InverterSpeed);
	RB2InverterSpeedEdit->Text = IntToStr(MachineControlParams.SuctionDisk2InverterSpeed);

	SD1SpeedPanel->Caption = IntToStr(MachineSetupData.ServoMotorData[SD1_MOTOR_INDEX].BaseSpeed * 100 / MachineControlParams.ServoMotorSpeed[SD1_MOTOR_INDEX]) + "%(" +
		IntToStr((int)(ServoMotorSpeedToRPMParam[SD1_MOTOR_INDEX] / MachineControlParams.ServoMotorSpeed[SD1_MOTOR_INDEX])) + "RPM)";
	SD2SpeedPanel->Caption = IntToStr(MachineSetupData.ServoMotorData[SD2_MOTOR_INDEX].BaseSpeed * 100 / MachineControlParams.ServoMotorSpeed[SD2_MOTOR_INDEX]) + "%(" +
		IntToStr((int)(ServoMotorSpeedToRPMParam[SD2_MOTOR_INDEX] / MachineControlParams.ServoMotorSpeed[SD2_MOTOR_INDEX])) + "RPM)";
	BFIDSpeedPanel->Caption = IntToStr(MachineSetupData.ServoMotorData[BF_ID_MOTOR_INDEX].BaseSpeed * 100 / MachineControlParams.ServoMotorSpeed[BF_ID_MOTOR_INDEX]) + "%(" +
		IntToStr((int)(ServoMotorSpeedToRPMParam[BF_ID_MOTOR_INDEX] / MachineControlParams.ServoMotorSpeed[BF_ID_MOTOR_INDEX])) + "RPM)";
	BFOD1SpeedPanel->Caption = IntToStr(MachineSetupData.ServoMotorData[BF_OD_IN_MOTOR_INDEX].BaseSpeed * 100 / MachineControlParams.ServoMotorSpeed[BF_OD_IN_MOTOR_INDEX]) + "%(" +
		IntToStr((int)(ServoMotorSpeedToRPMParam[BF_OD_IN_MOTOR_INDEX] / MachineControlParams.ServoMotorSpeed[BF_OD_IN_MOTOR_INDEX])) + "RPM)";

	if(MachineSetupData.MachineType == MACHINE_TYPE_SELMA_ADVANCED || MachineSetupData.MachineType == MACHINE_TYPE_LIMA_ADVANCED)
	{
		BFOD2SpeedPanel->Caption = IntToStr(MachineSetupData.ServoMotorData[BF_OD_OUT_MOTOR_INDEX].BaseSpeed * 100 / MachineControlParams.ServoMotorSpeed[BF_OD_OUT_MOTOR_INDEX]) + "%(" +
		IntToStr((int)(ServoMotorSpeedToRPMParam[BF_OD_OUT_MOTOR_INDEX] / MachineControlParams.ServoMotorSpeed[BF_OD_OUT_MOTOR_INDEX])) + "RPM)";
	}

	for (int airKnifeSpeedPanelIndex = 0; airKnifeSpeedPanelIndex < 4; airKnifeSpeedPanelIndex++)
	{
		TTntPanel *aPanel = (TTntPanel *)FindComponent("AirKnifeSpeedPanel" + IntToStr(airKnifeSpeedPanelIndex));
		if (airKnifeSpeedPanelIndex == MachineControlParams.AirKnifeSpeed)
		{
			aPanel->Color = clBlue;
			aPanel->Font->Color = clWhite;
		}
		else
		{
			aPanel->Color = clWhite;
			aPanel->Font->Color = clBlack;
		}
	}

	if (MachineControlParams.VFAutoTrainMode)
	{
		VFAutoTrainModeRadioButton->Checked = true;
	}
	else
	{
		VFManualTrainModeRadioButton->Checked = true;
	}

	ManualMaxSpeedEdit->Text = IntToStr(MachineControlParams.VFManualMaxSpeed);
	ManualModeSensorIndexComboBox->ItemIndex = MachineControlParams.ManualModeSensorIndex;
	ManualModeSensorActiveRatioEdit->Text = IntToStr(MachineControlParams.ManualModeSensorActiveRatio);

	Sensor1RatioEdit->Text = IntToStr(MachineControlParams.EmptySensorActiveRatio);
	Sensor2RatioEdit->Text = IntToStr(MachineControlParams.FullSensorActiveRatio);

  if(0)//(MachineSetupData.LasercomplexerInfo.Laser_complexer_Enable)
  {
    SensorRadioBtn1->Enabled = false;
    SensorRadioBtn2->Enabled = false;
    SensorRadioBtn3->Checked = true;
  }
  else
  {
    SensorRadioBtn1->Enabled = true;
    SensorRadioBtn2->Enabled = true;
    SensorRadioBtn3->Enabled = false;
    SensorRadioBtn1->Checked = true;
  }
}

//---------------------------------------------------------------------------



void __fastcall TAdvMachineControlForm::MotorSpeedPanelClick(TObject *Sender)
{
	TTntPanel *thePanel = (TTntPanel *)Sender;
	int motorIndex = thePanel->Tag;

	TMotorSpeedSelectionForm *motorSpeedSelectionForm = new TMotorSpeedSelectionForm(this);
	motorSpeedSelectionForm->SetSpeed(MachineSetupData.ServoMotorData[motorIndex].BaseSpeed, MachineControlParams.ServoMotorSpeed[motorIndex]);
	if (motorSpeedSelectionForm->ShowModal() == mrOk)
	{
		MachineControlParams.ServoMotorSpeed[motorIndex] = motorSpeedSelectionForm->GetSelectedSpeed();
		thePanel->Caption = IntToStr(MachineSetupData.ServoMotorData[motorIndex].BaseSpeed * 100 / MachineControlParams.ServoMotorSpeed[motorIndex]) + "%(" +
			IntToStr((int)(ServoMotorSpeedToRPMParam[motorIndex] / MachineControlParams.ServoMotorSpeed[motorIndex])) + "RPM)";
	}
	delete motorSpeedSelectionForm;
}
//---------------------------------------------------------------------------

void __fastcall TAdvMachineControlForm::AirKnifeSpeedPanelClick(
	TObject *Sender)
{
	TTntPanel *thePanel = (TTntPanel *)Sender;
	MachineControlParams.AirKnifeSpeed = thePanel->Tag;
	for (int airKnifeSpeedPanelIndex = 0; airKnifeSpeedPanelIndex < 4; airKnifeSpeedPanelIndex++)
	{
		TTntPanel *aPanel = (TTntPanel *)FindComponent("AirKnifeSpeedPanel" + IntToStr(airKnifeSpeedPanelIndex));
		if (aPanel == thePanel)
		{
			aPanel->Color = clBlue;
			aPanel->Font->Color = clWhite;
		}
		else
		{
			aPanel->Color = clWhite;
			aPanel->Font->Color = clBlack;
		}
	}
}
//---------------------------------------------------------------------------
void __fastcall TAdvMachineControlForm::VDRunSpeedButtonClick(
	TObject *Sender)
{
	try
	{
		Machine.SuctionDiskRun(MachineControlParams.ServoMotorSpeed[SD1_MOTOR_INDEX], MachineControlParams.ServoMotorSpeed[SD2_MOTOR_INDEX],
			MachineControlParams.SuctionDisk1InverterSpeed, MachineControlParams.SuctionDisk2InverterSpeed);
	}
	catch (...)
	{

	}
}
//---------------------------------------------------------------------------
void __fastcall TAdvMachineControlForm::VDStopSpeedButtonClick(
	TObject *Sender)
{
	Machine.SuctionDiskStop();
}
//---------------------------------------------------------------------------
void __fastcall TAdvMachineControlForm::BowlFeederRunButtonClick(
	TObject *Sender)
{
	try
	{
		Machine.BowlFeederRun(MachineControlParams.ServoMotorSpeed[BF_ID_MOTOR_INDEX], MachineControlParams.ServoMotorSpeed[BF_OD_IN_MOTOR_INDEX],MachineControlParams.ServoMotorSpeed[BF_OD_OUT_MOTOR_INDEX],  MachineControlParams.AirKnifeSpeed);
	}
	catch (...)
	{

	}
}
//---------------------------------------------------------------------------

void __fastcall TAdvMachineControlForm::BowlFeederStopButtonClick(
	TObject *Sender)
{
	Machine.BowlFeederStop();
}
//---------------------------------------------------------------------------

void __fastcall TAdvMachineControlForm::VFRunSpeedButtonClick(
	TObject *Sender)
{
	try
	{
		int vfSpeed = StrToInt(VFSpeedEdit->Text);
		Machine.VFRun(vfSpeed);
	}
	catch (...)
	{

	}
}
//---------------------------------------------------------------------------

void __fastcall TAdvMachineControlForm::VFAutoSpeedButtonClick(
	TObject *Sender)
{
	TMachineRunOption machineRunOption;

	if (VFAutoTrainModeRadioButton->Checked)
	{
		machineRunOption.MaxSpeedTrainingMode = MAX_SPEED_TRAINING_MODE_AUTO;
	}
	else
	{
		machineRunOption.MaxSpeedTrainingMode = MAX_SPEED_TRAINING_MODE_MANUAL;
	}
	machineRunOption.ManualMaxSpeed = StrToInt(ManualMaxSpeedEdit->Text);
	machineRunOption.ManualModeSensorIndex = ManualModeSensorIndexComboBox->ItemIndex;
	machineRunOption.ManualModeSensorActiveRatio = StrToInt(ManualModeSensorActiveRatioEdit->Text);
	machineRunOption.EmptySensorActiveRatio = StrToInt(Sensor1RatioEdit->Text);
	machineRunOption.FullSensorActiveRatio = StrToInt(Sensor2RatioEdit->Text);

	Machine.VFRun_AutoControl(machineRunOption.MaxSpeedTrainingMode, machineRunOption.ManualMaxSpeed, machineRunOption.ManualModeSensorIndex,
		machineRunOption.ManualModeSensorActiveRatio, machineRunOption.EmptySensorActiveRatio, machineRunOption.FullSensorActiveRatio);
}
//---------------------------------------------------------------------------

void __fastcall TAdvMachineControlForm::VFStopSpeedButtonClick(
	TObject *Sender)
{
	Machine.VFStop();
}
//---------------------------------------------------------------------------

void __fastcall TAdvMachineControlForm::VFDelayRunSpeedButtonClick(
	TObject *Sender)
{
	try
	{
		int vfSpeed = StrToInt(VFSpeedEdit->Text);
		Machine.VFRun(vfSpeed);
		int vibratorRunDelay = StrToInt(VFDelayRunEdit->Text);
		VibratorStopTime = GetTickCount() + vibratorRunDelay * 1000;
		VibratorRunTimer->Enabled = true;
	}
	catch (...)
	{

	}
}
//---------------------------------------------------------------------------
void __fastcall TAdvMachineControlForm::VibratorRunTimerTimer(
	TObject *Sender)
{
	if (GetTickCount() > VibratorStopTime)
	{
		VFStopSpeedButton->Click();
		VFStopSpeedButton->Down = true;
		VibratorRunTimer->Enabled = false;
	}
}
//---------------------------------------------------------------------------
void __fastcall TAdvMachineControlForm::NCControlButtonClick(
	TObject *Sender)
{
	NCControlForm->IsMEMode = false;
	NCControlForm->ShowModal();
}
//---------------------------------------------------------------------------

void __fastcall TAdvMachineControlForm::ServoMotorSpeedSpeedButtonClick(
	TObject *Sender)
{
	TTntSpeedButton *theSpeedButton = (TTntSpeedButton *) Sender;
  TTntSpeedButton *tempSpeedButton;
	int motorSpeedIndex = theSpeedButton->Tag;
	for (int motorIndex = 0; motorIndex < MAX_SERVO_MOTOR_COUNT; motorIndex++)
	{
		if (!ProductData.ProductCode.IsEmpty())
		{
			MachineControlParams.ServoMotorSpeed[motorIndex] = ProductData.MotorSpeedList[motorIndex][motorSpeedIndex];
		}
		else
		{
			MachineControlParams.ServoMotorSpeed[motorIndex] = MachineParams.MotorSpeedList[0][0][motorIndex][motorSpeedIndex];
		}
		if (MachineControlParams.ServoMotorSpeed[motorIndex] <= 0)
		{
			MachineControlParams.ServoMotorSpeed[motorIndex] = 25000000;
		}
	}

  for(int m = 1; m <= 3; m++)
  {
    tempSpeedButton = (TTntSpeedButton *) FindComponent("ServoMotorSpeedSpeedButton" + IntToStr(m));
    tempSpeedButton->Font->Color = clGray;
    tempSpeedButton->Font->Style = tempSpeedButton->Font->Style >> fsBold;

    if(motorSpeedIndex == tempSpeedButton->Tag)
    {
      tempSpeedButton->Font->Color = clBlue;
      tempSpeedButton->Font->Style = tempSpeedButton->Font->Style << fsBold;
    }
  }

	ApplyParams();
}
//---------------------------------------------------------------------------

void __fastcall TAdvMachineControlForm::StatusCheckTimerTimer(
	TObject *Sender)
{
	if (!bSystemStatusCheckSW) return;

	// check main machine status
	MainMachineStatusStopPanel->Color = clWhite;
	MainMachineStatusRunPanel->Color = clWhite;
	MainMachineStatusCleaningPanel->Color = clWhite;
	MainMachineStatusAttachingPanel->Color = clWhite;
	MainMachineStatusDetachingPanel->Color = clWhite;
	MainMachineStatusStartingPanel->Color = clWhite;
	MainMachineStatusStoppingPanel->Color = clWhite;
	MainMachineStatusEmergencyStopPanel->Color = clWhite;

	switch (Machine.Status.OperationState)
	{
	case MACHINE_STATE_STOP:
		MainMachineStatusStopPanel->Color = clLime;
		break;
	case MACHINE_STATE_RUN:
		MainMachineStatusRunPanel->Color = clLime;
		break;
	case MACHINE_STATE_CLEANING:
		MainMachineStatusCleaningPanel->Color = clLime;
		break;
	case MACHINE_STATE_ATTACHING:
		MainMachineStatusAttachingPanel->Color = clLime;
		break;
	case MACHINE_STATE_DETACHING:
		MainMachineStatusDetachingPanel->Color = clLime;
		break;
	case MACHINE_STATE_STARTING:
		MainMachineStatusStartingPanel->Color = clLime;
		break;
	case MACHINE_STATE_STOPPING:
		MainMachineStatusStoppingPanel->Color = clLime;
		break;
	case MACHINE_STATE_EMERGENCY_STOP:
		MainMachineStatusEmergencyStopPanel->Color = clRed;
		break;
	}

	WCHAR StrBuf[100];
	wsprintfW(StrBuf, L"%SRPM", FloatToStrF(Machine.GetServoMotorRPM(SD1_MOTOR_INDEX), ffFixed, 10, 3));
	ServoMotorRPMLabel1->Caption = StrBuf;
	wsprintfW(StrBuf, L"%SRPM", FloatToStrF(Machine.GetServoMotorRPM(SD2_MOTOR_INDEX), ffFixed, 10, 3));
	ServoMotorRPMLabel2->Caption = StrBuf;

	


	if(MachineSetupData.MachineType == MACHINE_TYPE_SELMA_ADVANCED || MachineSetupData.MachineType == MACHINE_TYPE_LIMA_ADVANCED)
	{
		wsprintfW(StrBuf, L"%SRPM", FloatToStrF(Machine.GetServoMotorRPM(BF_OD_IN_MOTOR_INDEX), ffFixed, 10, 3));
		ServoMotorRPMLabel3->Caption = StrBuf;	
		wsprintfW(StrBuf, L"%SRPM", FloatToStrF(Machine.GetServoMotorRPM(BF_OD_OUT_MOTOR_INDEX), ffFixed, 10, 3));
		ServoMotorRPMLabel4->Caption = StrBuf;
	}
    else
    {
		wsprintfW(StrBuf, L"%SRPM", FloatToStrF(Machine.GetServoMotorRPM(BF_ID_MOTOR_INDEX), ffFixed, 10, 3));
		ServoMotorRPMLabel3->Caption = StrBuf;	    
		wsprintfW(StrBuf, L"%SRPM", FloatToStrF(Machine.GetServoMotorRPM(BF_OD_IN_MOTOR_INDEX), ffFixed, 10, 3));
		ServoMotorRPMLabel4->Caption = StrBuf;
    }

	//ServoMotorRPMLabel2->Caption = ServoMotorRPMLabel2->Caption.sprintf("%.SRPM", FloatToStrF( Machine.GetServoMotorRPM(SD2_MOTOR_INDEX), ffFixed, 10, 3));
	//ServoMotorRPMLabel3->Caption = ServoMotorRPMLabel3->Caption.sprintf("%.SRPM", FloatToStrF( Machine.GetServoMotorRPM(BF_ID_MOTOR_INDEX), ffFixed, 10, 3));
	//ServoMotorRPMLabel4->Caption = ServoMotorRPMLabel4->Caption.sprintf("%.SRPM", FloatToStrF( Machine.GetServoMotorRPM(BF_OD_MOTOR_INDEX), ffFixed, 10, 3));


	wsprintfW(StrBuf, L"%SHz", FloatToStrF(SystemMonitorInfo.InverterSpeed[0] / 30.0, ffFixed, 10, 3));
	InverterSpeedLabel1->Caption = StrBuf;
	wsprintfW(StrBuf, L"%SHz", FloatToStrF(SystemMonitorInfo.InverterSpeed[1] / 30.0, ffFixed, 10, 3));
	InverterSpeedLabel2->Caption = StrBuf;
	wsprintfW(StrBuf, L"%SHz", FloatToStrF(SystemMonitorInfo.InverterSpeed[2] / 30.0, ffFixed, 10, 3));
	InverterSpeedLabel3->Caption = StrBuf;

	//InverterSpeedLabel1->Caption = InverterSpeedLabel1->Caption.sprintf("%.SHz", FloatToStrF( SystemMonitorInfo.InverterSpeed[0] / 30.0, ffFixed, 10, 3));
	//InverterSpeedLabel2->Caption = InverterSpeedLabel2->Caption.sprintf("%.SHz", FloatToStrF( SystemMonitorInfo.InverterSpeed[1] / 30.0, ffFixed, 10, 3));

	for (int thermometerIndex = 0; thermometerIndex < 3; thermometerIndex++)
	{
		TTntLabel *temperatureLabel = (TTntLabel *)FindComponent("TemperatureLabel" + IntToStr(thermometerIndex + 1));
		TTntLabel *humidityLabel = (TTntLabel *)FindComponent("HumidityLabel" + IntToStr(thermometerIndex + 1));
		if (temperatureLabel)
		{
			temperatureLabel->Caption = FloatToStr(SystemMonitorInfo.CurrentTemperature[thermometerIndex] / 100.0) + "";
			if (SystemMonitorInfo.CurrentTemperature[thermometerIndex] < 3000)
			{
				temperatureLabel->Font->Color = clBlue;
			}
			else if (SystemMonitorInfo.CurrentTemperature[thermometerIndex] < 4000)
			{
				temperatureLabel->Font->Color = clLime;
			}
			else if (SystemMonitorInfo.CurrentTemperature[thermometerIndex] < 5000)
			{
				temperatureLabel->Font->Color = clYellow;
			}
			else
			{
				temperatureLabel->Font->Color = clRed;
			}
		}
		if (humidityLabel)
		{
			humidityLabel->Caption = FloatToStr(SystemMonitorInfo.CurrentHumidity[thermometerIndex] / 100.0) + "%Rh";
		}
	}

	PressureLabel1->Caption = FloatToStr(SystemMonitorInfo.Pressure[0]) + "kPa";
	PressureLabel2->Caption = FloatToStr(SystemMonitorInfo.Pressure[1]) + "kPa";
	PressureLabel3->Caption = FloatToStr(SystemMonitorInfo.Pressure[2]) + "kPa";

	wsprintfW(StrBuf, L"%Smm", FloatToStrF(Machine.Status.StepMotorAbsEncoder[0] * (double)NC_POS_PARAM_1_DIV / NC_POS_PARAM_1_MUL - MachineSetupData.ZeroPositionValue[0], ffFixed, 10, 2));
	NCPosLabel1->Caption = StrBuf;
	wsprintfW(StrBuf, L"%Smm", FloatToStrF(Machine.Status.StepMotorAbsEncoder[1] * (double)NC_POS_PARAM_2_DIV / NC_POS_PARAM_2_MUL - MachineSetupData.ZeroPositionValue[1], ffFixed, 10, 2));
	NCPosLabel2->Caption = StrBuf;
	wsprintfW(StrBuf, L"%Smm", FloatToStrF(Machine.Status.StepMotorAbsEncoder[2] * (double)NC_POS_PARAM_3_DIV / NC_POS_PARAM_3_MUL - MachineSetupData.ZeroPositionValue[2], ffFixed, 10, 2));
	NCPosLabel3->Caption = StrBuf;
	wsprintfW(StrBuf, L"%Smm", FloatToStrF(Machine.Status.StepMotorAbsEncoder[3] * (double)NC_POS_PARAM_4_DIV / NC_POS_PARAM_4_MUL - MachineSetupData.ZeroPositionValue[3], ffFixed, 10, 2));
	NCPosLabel4->Caption = StrBuf;
	wsprintfW(StrBuf, L"%Smm", FloatToStrF(Machine.Status.StepMotorAbsEncoder[4] * (double)NC_POS_PARAM_5_DIV / NC_POS_PARAM_5_MUL - MachineSetupData.ZeroPositionValue[4], ffFixed, 10, 2));
	NCPosLabel5->Caption = StrBuf;
}
//---------------------------------------------------------------------------

void __fastcall TAdvMachineControlForm::AirKnifeRunPanelClick(
	TObject *Sender)
{
	Machine.BowlFeederAKSpeedChange(MachineControlParams.AirKnifeSpeed);
}
//---------------------------------------------------------------------------

void __fastcall TAdvMachineControlForm::AirKnifeStopPanelClick(
	TObject *Sender)
{
	Machine.BowlFeederAKSpeedChange(0);
}
//---------------------------------------------------------------------------

void __fastcall TAdvMachineControlForm::LowLevelControlButtonClick(
	TObject *Sender)
{
#ifdef TEST_APP
	MachineSettingForm->Show();
#else
	TMachineSettingForm *machineSettingForm = new TMachineSettingForm(this);
	machineSettingForm->ShowModal();
	delete machineSettingForm;
#endif
}
//---------------------------------------------------------------------------


void __fastcall TAdvMachineControlForm::SubControlMenuPanelClick(
	TObject *Sender)
{
	if (SubControlPanel->Visible)
	{
		SubControlPanel->Visible = false;
		SubControlMenuPanel->Color = clWhite;
		SubControlMenuPanel->Font->Color = clBlack;
	}
	else
	{
		SubControlPanel->Visible = true;
		SubControlMenuPanel->Color = clBlue;
		SubControlMenuPanel->Font->Color = clWhite;
	}
	RedrawForm();
}
//---------------------------------------------------------------------------

void __fastcall TAdvMachineControlForm::UnitControlMenuPanelClick(
	TObject *Sender)
{
	if (UnitControlPanel->Visible)
	{
		UnitControlPanel->Visible = false;
		UnitControlMenuPanel->Color = clWhite;
		UnitControlMenuPanel->Font->Color = clBlack;
	}
	else
	{
		UnitControlPanel->Visible = true;
		UnitControlMenuPanel->Color = clBlue;
		UnitControlMenuPanel->Font->Color = clWhite;
	}
	RedrawForm();
}
//---------------------------------------------------------------------------

void __fastcall TAdvMachineControlForm::ParameterMenuPanelClick(
	TObject *Sender)
{
	if (ParameterPanel->Visible)
	{
		ParameterPanel->Visible = false;
		ParameterMenuPanel->Color = clWhite;
		ParameterMenuPanel->Font->Color = clBlack;
	}
	else
	{
		ParameterPanel->Visible = true;
		ParameterMenuPanel->Color = clBlue;
		ParameterMenuPanel->Font->Color = clWhite;
	}
	RedrawForm();
}
//---------------------------------------------------------------------------

void __fastcall TAdvMachineControlForm::StatusMenuPanelClick(
	TObject *Sender)
{
	if (StatusPanel->Visible)
	{
		StatusPanel->Visible = false;
		StatusMenuPanel->Color = clWhite;
		StatusMenuPanel->Font->Color = clBlack;
	}
	else
	{
		StatusPanel->Visible = true;
		StatusMenuPanel->Color = clBlue;
		StatusMenuPanel->Font->Color = clWhite;
	}
	RedrawForm();
}
//---------------------------------------------------------------------------

void __fastcall TAdvMachineControlForm::VFAutoTrainModeRadioButtonClick(
	TObject *Sender)
{
	MachineControlParams.VFAutoTrainMode = true;
}
//---------------------------------------------------------------------------

void __fastcall TAdvMachineControlForm::VFManualTrainModeRadioButtonClick(
	TObject *Sender)
{
	MachineControlParams.VFAutoTrainMode = false;
}
//---------------------------------------------------------------------------

void __fastcall TAdvMachineControlForm::ManualMaxSpeedEditChange(
	TObject *Sender)
{
	try
	{
		MachineControlParams.VFManualMaxSpeed = StrToInt(ManualMaxSpeedEdit->Text);
	}
	catch (...)
	{

	}
}
//---------------------------------------------------------------------------
void __fastcall TAdvMachineControlForm::ManualModeSensorIndexComboBoxChange(
	TObject *Sender)
{
	MachineControlParams.ManualModeSensorIndex = ManualModeSensorIndexComboBox->ItemIndex;
}
//---------------------------------------------------------------------------

void __fastcall TAdvMachineControlForm::Sensor1RatioEditChange(
	TObject *Sender)
{
	try
	{
		MachineControlParams.EmptySensorActiveRatio = StrToInt(Sensor1RatioEdit->Text);
	}
	catch (...)
	{

	}
}
//---------------------------------------------------------------------------

void __fastcall TAdvMachineControlForm::Sensor2RatioEditChange(
	TObject *Sender)
{
	try
	{
		MachineControlParams.FullSensorActiveRatio = StrToInt(Sensor2RatioEdit->Text);
	}
	catch (...)
	{

	}
}
//---------------------------------------------------------------------------

void __fastcall TAdvMachineControlForm::ManualModeSensorActiveRatioEditChange(
	TObject *Sender)
{
	try
	{
		MachineControlParams.ManualModeSensorActiveRatio = StrToInt(ManualModeSensorActiveRatioEdit->Text);
	}
	catch (...)
	{

	}
}
//---------------------------------------------------------------------------

void __fastcall TAdvMachineControlForm::TntFormActivate(TObject *Sender)
{
  GetDefaultString();
  SetScreenPosition(this);
  
  ApplyParams();
}
//---------------------------------------------------------------------------

void __fastcall TAdvMachineControlForm::ApplyDefaultParams(void)
{
  InitMachineControlParams();
  TTntSpeedButton *tempSpeedButton;
  for(int m = 1; m <= 3; m++)
  {
    tempSpeedButton = (TTntSpeedButton *) FindComponent("ServoMotorSpeedSpeedButton" + IntToStr(m));
    tempSpeedButton->Font->Color = clGray;
    tempSpeedButton->Font->Style = tempSpeedButton->Font->Style >> fsBold;
  }
  
	ApplyParams();
}
//---------------------------------------------------------------------------
