//---------------------------------------------------------------------------

#ifndef AdvMachineControl_FormH
#define AdvMachineControl_FormH
//---------------------------------------------------------------------------
#include <Classes.hpp>
#include <Controls.hpp>
#include <StdCtrls.hpp>
#include <Forms.hpp>

#include "common.h"
#include <ExtCtrls.hpp>
#include <Buttons.hpp>
#include "TntButtons.hpp"
#include "TntExtCtrls.hpp"
#include "TntStdCtrls.hpp"
#include "TntForms.hpp"

//---------------------------------------------------------------------------
typedef struct
{
	bool VFAutoTrainMode;
	unsigned short VFManualMaxSpeed;
    int ManualModeSensorIndex;
    int ManualModeSensorActiveRatio;
  	unsigned short VFManualLimitSpeed;
	int ManualModeLimitSensorIndex;
	int ManualModeLimitSensorActiveRatio;
	int EmptySensorActiveRatio;
	int FullSensorActiveRatio;
	char AirKnifeSpeed;
	int SuctionDisk1InverterSpeed;
	int SuctionDisk2InverterSpeed;
	int ServoMotorSpeed[MAX_SERVO_MOTOR_COUNT];
} TMachineControlParams;
//---------------------------------------------------------------------------
class TAdvMachineControlForm : public TTntForm
{
__published:	// IDE-managed Components
	TTntPanel *MainMenuPanel;
	TTntGroupBox *GroupBox8;
	TTntButton *MainControlRunButton;
	TTntButton *MainControlStopButton;
	TTntButton *MainControlCleaningButton;
	TTntButton *MainControlReadyButton;
	TTntButton *CloseButton;
	TTntPanel *SubControlPanel;
	TTntGroupBox *GroupBox3;
	TTntSpeedButton *VDRunSpeedButton;
	TTntSpeedButton *VDStopSpeedButton;
	TTntGroupBox *GroupBox5;
	TTntButton *BowlFeederRunButton;
	TTntButton *BowlFeederStopButton;
	TTntGroupBox *GroupBox1;
	TTntSpeedButton *VFRunSpeedButton;
	TTntSpeedButton *VFStopSpeedButton;
	TTntSpeedButton *VFAutoSpeedButton;
	TTntLabel *Label13;
	TTntLabel *Label26;
	TTntSpeedButton *VFDelayRunSpeedButton;
	TTntEdit *VFSpeedEdit;
	TTntEdit *VFDelayRunEdit;
	TTntPanel *UnitControlPanel;
	TTntGroupBox *GroupBox2;
	TTntSpeedButton *RBOnSpeedButton1;
	TTntSpeedButton *RBOffSpeedButton1;
	TTntSpeedButton *RBOnSpeedButton3;
	TTntSpeedButton *RBOffSpeedButton3;
	TTntSpeedButton *RBOnSpeedButton4;
	TTntSpeedButton *RBOffSpeedButton4;
	TTntButton *BlowerAllOnButton;
	TTntButton *BlowerAllOffButton;
	TTntPanel *ParameterPanel;
	TTntGroupBox *GroupBox4;
	TTntEdit *RB1InverterSpeedEdit;
	TTntEdit *RB2InverterSpeedEdit;
	TTntLabel *Label1;
	TTntLabel *Label2;
	TTntGroupBox *GroupBox6;
	TTntLabel *Label3;
	TTntPanel *SD1SpeedPanel;
	TTntLabel *Label4;
	TTntPanel *SD2SpeedPanel;
	TTntLabel *Label5;
	TTntPanel *BFIDSpeedPanel;
	TTntLabel *Label6;
	TTntPanel *BFOD1SpeedPanel;
	TTntGroupBox *GroupBox7;
	TTntLabel *Label7;
	TTntPanel *AirKnifeSpeedPanel0;
	TTntPanel *AirKnifeSpeedPanel1;
	TTimer *VibratorRunTimer;
	TTntButton *Button1;
	TTntButton *NCControlButton;
	TTntSpeedButton *ServoMotorSpeedSpeedButton1;
	TTntSpeedButton *ServoMotorSpeedSpeedButton2;
	TTntSpeedButton *ServoMotorSpeedSpeedButton3;
	TTntPanel *StatusPanel;
	TTntGroupBox *GroupBox10;
	TTntPanel *MainMachineStatusCleaningPanel;
	TTntPanel *MainMachineStatusAttachingPanel;
	TTntPanel *MainMachineStatusStopPanel;
	TTntPanel *MainMachineStatusDetachingPanel;
	TTntPanel *MainMachineStatusStartingPanel;
	TTntPanel *MainMachineStatusRunPanel;
	TTntPanel *MainMachineStatusStoppingPanel;
	TTimer *StatusCheckTimer;
	TTntPanel *MainMachineStatusEmergencyStopPanel;
	TTntGroupBox *GroupBox11;
	TTntGroupBox *GroupBox12;
	TTntLabel *Label11;
	TTntLabel *Label12;
	TTntLabel *Label14;
	TTntLabel *Label15;
	TTntPanel *Panel1;
	TTntLabel *ServoMotorRPMLabel1;
	TTntLabel *ServoMotorRPMLabel2;
	TTntLabel *ServoMotorRPMLabel4;
	TTntLabel *ServoMotorRPMLabel3;
	TTntLabel *Label10;
	TTntLabel *TemperatureLabel1;
	TTntLabel *Label18;
	TTntLabel *HumidityLabel1;
	TTntLabel *Label19;
	TTntLabel *TemperatureLabel2;
	TTntLabel *Label20;
	TTntLabel *HumidityLabel2;
	TTntLabel *Label21;
	TTntLabel *TemperatureLabel3;
	TTntLabel *Label22;
	TTntLabel *HumidityLabel3;
	TTntGroupBox *GroupBox14;
	TTntLabel *Label16;
	TTntLabel *Label17;
	TTntLabel *InverterSpeedLabel2;
	TTntLabel *InverterSpeedLabel1;
	TTntLabel *Label23;
	TTntLabel *Label24;
	TTntLabel *Label25;
	TTntLabel *PressureLabel3;
	TTntLabel *PressureLabel2;
	TTntLabel *PressureLabel1;
	TTntLabel *Label30;
	TTntPanel *AirKnifeRunPanel;
	TTntPanel *AirKnifeStopPanel;
	TTntButton *LowLevelControlButton;
	TTntGroupBox *GroupBox15;
	TTntLabel *Label27;
	TTntLabel *Label28;
	TTntLabel *Label29;
	TTntLabel *Label35;
	TTntLabel *Label36;
	TTntLabel *NCPosLabel1;
	TTntLabel *NCPosLabel2;
	TTntLabel *NCPosLabel3;
	TTntLabel *NCPosLabel4;
	TTntLabel *NCPosLabel5;
	TTntPanel *SubControlMenuPanel;
	TTntPanel *UnitControlMenuPanel;
	TTntPanel *ParameterMenuPanel;
	TTntPanel *StatusMenuPanel;
	TTntGroupBox *GroupBox16;
	TTntPanel *Panel3;
	TTntLabel *Label48;
	TTntRadioButton *VFAutoTrainModeRadioButton;
	TTntRadioButton *VFManualTrainModeRadioButton;
	TTntPanel *AirKnifeSpeedPanel2;
	TTntPanel *AirKnifeSpeedPanel3;
	TTntGroupBox *GroupBox9;
	TTntLabel *Label8;
	TTntLabel *Label37;
	TTntLabel *Label38;
	TTntLabel *Label39;
	TTntEdit *Sensor2RatioEdit;
	TTntEdit *Sensor1RatioEdit;
	TTntGroupBox *GroupBox17;
	TTntLabel *Label40;
	TTntLabel *Label42;
	TTntLabel *Label43;
	TTntLabel *Label44;
	TTntEdit *ManualMaxSpeedEdit;
	TTntEdit *ManualModeSensorActiveRatioEdit;
	TTntComboBox *ManualModeSensorIndexComboBox;
  TTntGroupBox *TntGroupBox1;
  TRadioButton *SensorRadioBtn1;
  TRadioButton *SensorRadioBtn2;
  TTntLabel *TntLabel1;
  TTntLabel *InverterSpeedLabel3;
  TRadioButton *SensorRadioBtn3;
	TTntLabel *TntLabel2;
	TTntPanel *BFOD2SpeedPanel;
	void __fastcall CloseButtonClick(TObject *Sender);
	void __fastcall MainControlRunButtonClick(TObject *Sender);
	void __fastcall MainControlStopButtonClick(TObject *Sender);
	void __fastcall MainControlCleaningButtonClick(TObject *Sender);
	void __fastcall MainControlReadyButtonClick(TObject *Sender);
	void __fastcall FormCreate(TObject *Sender);
	void __fastcall RBOnSpeedButtonClick(TObject *Sender);
	void __fastcall RBOffSpeedButtonClick(TObject *Sender);
	void __fastcall NumEditClick(TObject *Sender);
	void __fastcall RB1InverterSpeedEditChange(TObject *Sender);
	void __fastcall RB2InverterSpeedEditChange(TObject *Sender);
	void __fastcall MotorSpeedPanelClick(TObject *Sender);
	void __fastcall AirKnifeSpeedPanelClick(TObject *Sender);
	void __fastcall VDRunSpeedButtonClick(TObject *Sender);
	void __fastcall VDStopSpeedButtonClick(TObject *Sender);
	void __fastcall BowlFeederRunButtonClick(TObject *Sender);
	void __fastcall BowlFeederStopButtonClick(TObject *Sender);
	void __fastcall VFRunSpeedButtonClick(TObject *Sender);
	void __fastcall VFAutoSpeedButtonClick(TObject *Sender);
	void __fastcall VFStopSpeedButtonClick(TObject *Sender);
	void __fastcall VFDelayRunSpeedButtonClick(TObject *Sender);
	void __fastcall VibratorRunTimerTimer(TObject *Sender);
	void __fastcall NCControlButtonClick(TObject *Sender);
	void __fastcall ServoMotorSpeedSpeedButtonClick(TObject *Sender);
	void __fastcall StatusCheckTimerTimer(TObject *Sender);
	void __fastcall AirKnifeRunPanelClick(TObject *Sender);
	void __fastcall AirKnifeStopPanelClick(TObject *Sender);
	void __fastcall LowLevelControlButtonClick(TObject *Sender);
	void __fastcall SubControlMenuPanelClick(TObject *Sender);
	void __fastcall UnitControlMenuPanelClick(TObject *Sender);
	void __fastcall ParameterMenuPanelClick(TObject *Sender);
	void __fastcall StatusMenuPanelClick(TObject *Sender);
	void __fastcall VFAutoTrainModeRadioButtonClick(TObject *Sender);
	void __fastcall VFManualTrainModeRadioButtonClick(TObject *Sender);
	void __fastcall ManualMaxSpeedEditChange(TObject *Sender);

	void __fastcall ManualModeSensorIndexComboBoxChange(TObject *Sender);
	void __fastcall Sensor1RatioEditChange(TObject *Sender);
	void __fastcall Sensor2RatioEditChange(TObject *Sender);
	void __fastcall ManualModeSensorActiveRatioEditChange(TObject *Sender);
  void __fastcall TntFormActivate(TObject *Sender);
private:	// User declarations
	double ServoMotorSpeedToRPMParam[MAX_SERVO_MOTOR_COUNT];
	unsigned int VibratorStopTime;

	void __fastcall InitMachineControlParams(void);
	void __fastcall RedrawForm(void);
	void __fastcall ApplyParams(void);
  void __fastcall GetDefaultString();
public:		// User declarations
	__fastcall TAdvMachineControlForm(TComponent* Owner);

	void __fastcall ApplyProductInfo(void);
  void __fastcall ApplyDefaultParams(void);
  TMachineControlParams MachineControlParams;

  WideString ErrorMsg[10];
};
//---------------------------------------------------------------------------
extern PACKAGE TAdvMachineControlForm *AdvMachineControlForm;
//---------------------------------------------------------------------------
#endif
