//---------------------------------------------------------------------------
// For SELMA200, 20180223, moon,  
//---------------------------------------------------------------------------
#include <vcl.h>
#pragma hdrstop

#include "Alarm_Form.h"
#include "Environment.h"
#include "MultiLanguage.h"
#include "wchar.h"
#include "inspection_Form.h"

#include "SafetyForm.h"			//Safety Circuit

//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma link "TntExtCtrls"
#pragma link "TntStdCtrls"
#pragma resource "*.dfm"

#define MAX_ALARM_TEXT_COUNT			7
#define MIN_FORM_HEIGHT					450 // 370
TAlarmForm *AlarmForm;
int alarm_reset_button_on = 0;
int AlarmFormAutoCloseCount = 0;
//---------------------------------------------------------------------------
__fastcall TAlarmForm::TAlarmForm(TComponent* Owner)
		: TTntForm(Owner)
{
	if (DefaultLCID == 1028 || DefaultLCID == 2052 || DefaultLCID == 3076 || DefaultLCID == 4100)
		ComponentSetFontName(this, "SimSun");
	else if (DefaultLCID == 1041)
		ComponentSetFontName(this, "Meiryo UI");
	else if (DefaultLCID == 3082)
	{
		ComponentSetFontName(this, "Segoe UI");
		ComponentSetMultiLine(this);
	}

	GetDefaultString();

	AlarmStringList = new TTntStringList;
	WarningStringList = new TTntStringList;
	LastHideTime = 0;
	SleepMode = false;
	WarningSleep = false;
	SpbDisconnect = false;
}
//---------------------------------------------------------------------------
void __fastcall TAlarmForm::GetDefaultString()
{
	BuzzerOffButton->Caption = ALARMFORM_BUTTON_CAPTION_01;
	SoftResetButton->Caption = ALARMFORM_BUTTON_CAPTION_02;
	AlarmResetButton->Caption = ALARMFORM_BUTTON_CAPTION_03;
	OkButton->Caption = ALARMFORM_BUTTON_CAPTION_04;
	StaticText1->Caption = ALARMFORM_TEXT_CAPTION_01;
	StaticText7->Caption = ALARMFORM_TEXT_CAPTION_02;
	WarningOff->Caption = ALARMFORM_BUTTON_CAPTION_05;
}
//---------------------------------------------------------------------------
void __fastcall TAlarmForm::FormActivate(TObject *Sender)
{
	RefreshAlarm();
}
//---------------------------------------------------------------------------

void __fastcall TAlarmForm::FormClick(TObject *Sender)
{
	//	this->Close();
}
//---------------------------------------------------------------------------

void __fastcall TAlarmForm::FormDestroy(TObject *Sender)
{
	AlarmFormAutoCloseCount = 0;
	delete AlarmStringList;
	delete WarningStringList;

}
//---------------------------------------------------------------------------
void __fastcall TAlarmForm::ShowAlarm(void)
{
	if (!this->Visible && (GetTickCount() - LastHideTime) >= 3000)
	{
		AlarmFormAutoCloseCount = 0;
		this->ShowModal();
	}
}
//---------------------------------------------------------------------------
void __fastcall TAlarmForm::FormHide(TObject *Sender)
{
	AlarmFormAutoCloseCount = 0;
	LastHideTime = GetTickCount();
}
//---------------------------------------------------------------------------

void __fastcall TAlarmForm::RefreshAlarm(void)
{

	AlarmStringList->Clear();
	WarningStringList->Clear();
	alarm_reset_button_on = 0;
	/*if (SystemMonitorInfo.CurrentTemperature[0] > 5000)
	{
		AlarmStringList->Add(ALARMFORM_STRINGLIST_ADD_21);
	    if(AppOnOffFlag == true)
	    {
	       ClientForm->SendCmd(16);
	       AppOnOffFlag = false;
	    }
	}
	if (SystemMonitorInfo.CurrentTemperature[1] > 5000)
	{
		AlarmStringList->Add(ALARMFORM_STRINGLIST_ADD_27);
	     if(AppOnOffFlag == true)
	     {
	       ClientForm->SendCmd(22);
	       AppOnOffFlag = false;
	     }
	}
	if (SystemMonitorInfo.CurrentTemperature[2] > 5000)
	{
		AlarmStringList->Add(ALARMFORM_STRINGLIST_ADD_22);
	     if(AppOnOffFlag == true)
	     {
	       ClientForm->SendCmd(17);
	       AppOnOffFlag = false;
	     }
	} */


	if (!Comm_IsConnected(COMM_HCB))
	{
		AlarmStringList->Add(ALARMFORM_STRINGLIST_ADD_16);
		if (AppOnOffFlag == true)
		{
			ClientForm->SendCmd(11);
			AppOnOffFlag = false;
		}
	}
	for (int spbIndex = 0; spbIndex < MachineSetupData.IPB_BoardCount; spbIndex++)
	{
		if (!Comm_IsConnected(COMM_SPB + spbIndex))
		{
			WCHAR tempString[100];
			wsprintfW(tempString, ALARMFORM_STRINGLIST_ADD_01, (spbIndex + 1));
			AlarmStringList->Add(tempString);
			if (AppOnOffFlag == true)
			{
				ClientForm->SendCmd(1);
				AppOnOffFlag = false;
			}
		}
	}

	if (Machine.Status.AlarmExist)
	{
		if (MachineSetupData.CompanyID == DOMESTIC_MACHINE2)
		{
			if (PCProgramOption.UVLaserEnabled)
			{
				//PcUiFlag.Alarm = 1;
				Machine.SetUIFlagData();
			}
		}
		if (Machine.AlarmStatus.EmissionSensorOn)
		{
			if (AppOnOffFlag == true)
			{
				ClientForm->SendCmd(32); //32
				AppOnOffFlag = false;
			}
			AlarmStringList->Add(NEW_ADD_STRING_06);
		}
		if (Machine.AlarmStatus.RegulatorError)
		{
			AlarmStringList->Add(ALARMFORM_STRINGLIST_ADD_19);
			if (AppOnOffFlag == true)
			{
				ClientForm->SendCmd(14);
				AppOnOffFlag = false;
			}
		}
		if (Machine.AlarmStatus.TemperatureOver[0])
		{
			WCHAR tempString[100];
			wsprintfW(tempString, ALARMFORM_STRINGLIST_ADD_21, MachineSetupData.AlarmSetupInfo.TemperatureAlarmLevel1);
			AlarmStringList->Add(tempString);
		}
		if (Machine.AlarmStatus.TemperatureOver[1])
		{
			WCHAR tempString[100];
			wsprintfW(tempString, ALARMFORM_STRINGLIST_ADD_22, MachineSetupData.AlarmSetupInfo.TemperatureAlarmLevel2);
			AlarmStringList->Add(tempString);
		}
		if (Machine.AlarmStatus.TemperatureOver[2])
		{
			WCHAR tempString[100];
			wsprintfW(tempString, ALARMFORM_STRINGLIST_ADD_27, MachineSetupData.AlarmSetupInfo.TemperatureAlarmLevel3);
			AlarmStringList->Add(tempString);
		}
		if (Machine.AlarmStatus.EmergencyOn)
		{
			if ( PCProgramOption.UVLaserEnabled && MachineSetupData.CompanyID == DOMESTIC_MACHINE2)
			{
				PcUiFlag.InsReady = 0;
				PcUiFlag.InsActive = 0;
				PcUiFlag.EMR = 1;
				Machine.SetUIFlagData();
			}
			else if (MachineSetupData.CompanyID == INTERNATIONAL_MACHINE1)
			{
				UVLaser.SELMAStatus.EMR = 1;
			}
			AlarmStringList->Add(ALARMFORM_STRINGLIST_ADD_15);
			if (AppOnOffFlag == true)
			{
				ClientForm->SendCmd(10);
				AppOnOffFlag = false;
			}
		}
		if (Machine.AlarmStatus.Inverter1Trip)
		{
			AlarmStringList->Add(ALARMFORM_STRINGLIST_ADD_07);
			if (AppOnOffFlag == true)
			{
				ClientForm->SendCmd(2);
				AppOnOffFlag = false;
			}
		}
		if (Machine.AlarmStatus.Inverter2Trip)
		{
			AlarmStringList->Add(ALARMFORM_STRINGLIST_ADD_11);
			if (AppOnOffFlag == true)
			{
				ClientForm->SendCmd(6);
				AppOnOffFlag = false;
			}
		}
		if (Machine.AlarmStatus.Inverter3Trip)
		{
			if (MachineSetupData.CompanyID == INTERNATIONAL_MACHINE1)
			{
				AlarmStringList->Add(ALARMFORM_STRINGLIST_ADD_38);
			}
			else
			{
				AlarmStringList->Add(ALARMFORM_STRINGLIST_ADD_28);
			}
		}

		if (Machine.AlarmStatus.Disk1SuctionLow)
		{
			AlarmStringList->Add(ALARMFORM_STRINGLIST_ADD_09);
			if (AppOnOffFlag == true)
			{
				ClientForm->SendCmd(4);
				AppOnOffFlag = false;
			}
		}
		if (Machine.AlarmStatus.Disk2SuctionLow)
		{
			AlarmStringList->Add(ALARMFORM_STRINGLIST_ADD_13);
			if (AppOnOffFlag == true)
			{
				ClientForm->SendCmd(8);
				AppOnOffFlag = false;
			}
		}
		if (Machine.AlarmStatus.TotalFull)
		{
			AlarmStringList->Add(ALARMFORM_STRINGLIST_ADD_47);
		}
		if (Machine.AlarmStatus.GPFull)
		{
			AlarmStringList->Add(ALARMFORM_STRINGLIST_ADD_23);
			if (AppOnOffFlag == true)
			{
				ClientForm->SendCmd(18);
				AppOnOffFlag = false;
			}
		}
		if (Machine.AlarmStatus.DPFull)
		{
			AlarmStringList->Add(ALARMFORM_STRINGLIST_ADD_30);
			if (AppOnOffFlag == true)
			{
				ClientForm->SendCmd(25);
				AppOnOffFlag = false;
			}
		}
		if (Machine.AlarmStatus.UPFull)
		{
			AlarmStringList->Add(ALARMFORM_STRINGLIST_ADD_24);
			if (AppOnOffFlag == true)
			{
				ClientForm->SendCmd(19);
				AppOnOffFlag = false;
			}
		}
		if (Machine.AlarmStatus.DPRatioOver)
		{
			AlarmStringList->Add(ALARMFORM_STRINGLIST_ADD_29);
			if (AppOnOffFlag == true)
			{
				ClientForm->SendCmd(24);
				AppOnOffFlag = false;
			}
		}
		if (Machine.AlarmStatus.CritDPRatioOver)
		{
			AlarmStringList->Add(ALARMFORM_STRINGLIST_ADD_49);
		}
		if (Machine.AlarmStatus.UPRatioOver)
		{
			AlarmStringList->Add(ALARMFORM_STRINGLIST_ADD_25);
			AlarmStringList->Add(unInsReason);
			if (AppOnOffFlag == true)
			{
				ClientForm->SendCmd(20);
				AppOnOffFlag = false;
			}
		}
		if (Machine.AlarmStatus.CritUPRatioOver)
		{
			AlarmStringList->Add(ALARMFORM_STRINGLIST_ADD_50);
			AlarmStringList->Add(unInsReason);
			if (AppOnOffFlag == true)
			{
				ClientForm->SendCmd(20);
				AppOnOffFlag = false;
			}
		}

		if (Machine.AlarmStatus.Sensor1Error)
		{
			AlarmStringList->Add(ALARMFORM_STRINGLIST_ADD_08);
			if (AppOnOffFlag == true)
			{
				ClientForm->SendCmd(3);
				AppOnOffFlag = false;
			}
		}
		if (Machine.AlarmStatus.Sensor2Error)
		{
			AlarmStringList->Add(ALARMFORM_STRINGLIST_ADD_12);
			if (AppOnOffFlag == true)
			{
				ClientForm->SendCmd(7);
				AppOnOffFlag = false;
			}
		}
		if (Machine.AlarmStatus.BrightnessDown)
		{
			AlarmStringList->Add(ALARMFORM_STRINGLIST_ADD_34);
			if (AppOnOffFlag == true)
			{
				ClientForm->SendCmd(29);
				AppOnOffFlag = false;
			}
		}
		if (Machine.AlarmStatus.ServoAlarm)
		{
			AlarmStringList->Add(ALARMFORM_STRINGLIST_ADD_32);
			if (AppOnOffFlag == true)
			{
				ClientForm->SendCmd(27);
				AppOnOffFlag = false;
			}
		}
		if (Machine.AlarmStatus.Interlock)
		{
			AlarmStringList->Add(ALARMFORM_STRINGLIST_ADD_20);
			if (AppOnOffFlag == true)
			{
				ClientForm->SendCmd(15);
				AppOnOffFlag = false;
			}
		}
		if (Machine.AlarmStatus.Disk1Stall)
		{
			AlarmStringList->Add(ALARMFORM_STRINGLIST_ADD_10);
			if (AppOnOffFlag == true)
			{
				ClientForm->SendCmd(5);
				AppOnOffFlag = false;
			}
		}
		if (Machine.AlarmStatus.Disk2Stall)
		{
			AlarmStringList->Add(ALARMFORM_STRINGLIST_ADD_14);
			if (AppOnOffFlag == true)
			{
				ClientForm->SendCmd(9);
				AppOnOffFlag = false;
			}
		}
		if (Machine.AlarmStatus.StepMotorStall[0])
		{
			AlarmStringList->Add(ALARMFORM_STRINGLIST_ADD_04);
		}
		if (Machine.AlarmStatus.StepMotorStall[1])
		{
			AlarmStringList->Add(ALARMFORM_STRINGLIST_ADD_05);
		}
		if (Machine.AlarmStatus.StepMotorStall[2])
		{
			AlarmStringList->Add(ALARMFORM_STRINGLIST_ADD_02);
		}
		if (Machine.AlarmStatus.StepMotorStall[3])
		{
			AlarmStringList->Add(ALARMFORM_STRINGLIST_ADD_03);
		}
		if (Machine.AlarmStatus.StepMotorStall[4])
		{
			AlarmStringList->Add(ALARMFORM_STRINGLIST_ADD_06);
		}

		//sjm Add
		if (Machine.AlarmStatus.CheckMisEjector)
		{
			AlarmStringList->Add(ALARMFORM_STRINGLIST_ADD_48);
		}
		if (Machine.AlarmStatus.CheckDistributor)
		{
			AlarmStringList->Add(ALARMFORM_STRINGLIST_ADD_51);
		}
		if (Machine.AlarmStatus.MisEjectFull)
		{
			AlarmStringList->Add(ALARMFORM_STRINGLIST_ADD_37);
		}
		if (MachineSetupData.CompanyID == INTERNATIONAL_MACHINE1)
		{
			if (Machine.AlarmStatus.mes_status)
			{
				AlarmStringList->Add(ALARMFORM_STRINGLIST_ADD_42);
			}
			if (Machine.AlarmStatus.Qjp_object_status)
			{
				AlarmStringList->Add(ALARMFORM_STRINGLIST_ADD_43);
			}
			if (Machine.AlarmStatus.upstream_status)
			{
				AlarmStringList->Add(ALARMFORM_STRINGLIST_ADD_44);
			}
			if (Machine.AlarmStatus.downstream_status)
			{
				AlarmStringList->Add(ALARMFORM_STRINGLIST_ADD_45);
			}
			if (Machine.AlarmStatus.laser_emergency)
			{
				AlarmStringList->Add(ALARMFORM_STRINGLIST_ADD_46);
			}
		}
	}


	if (MachineSetupData.CompanyID == DOMESTIC_MACHINE2 && PCProgramOption.UVLaserEnabled )
	{
		if (LaserPrinterEMRAlarm)
		{
			WarningStringList->Add("Laser Print EMS ON");
		}
		if (LaserPrinterAlarm)
		{
			WarningStringList->Add("Laser Print Alarm ON");
		}
	}


	if (Machine.Status.WarningExist)
	{
		if (Machine.WarningStatus.VBFeederEmpty)
		{
			WarningStringList->Add(ALARMFORM_STRINGLIST_ADD_17);
		}
	}

	//sjm Q Alarm Reset
	/*if (Machine.AlarmStatus.AlarmClear)
	{
	 	if (!Comm_IsConnected(COMM_HCB))
	{
	Comm_Reconnect(COMM_HCB);
	}
	for (int spbIndex = 0; spbIndex < MachineSetupData.IPB_BoardCount; spbIndex++)
	{
	if (!Comm_IsConnected(COMM_SPB + spbIndex))
	{
		Comm_Reconnect(COMM_SPB + spbIndex);
	}
	}

	if (Machine.Status.AlarmExist || Machine.Status.WarningExist)
	{
	Comm_Request(COMM_HCB, CMD_ALARM_RESET);
	}
	//this->Close();
	}
	} */

	if (Machine.PortStatus.IPStatus[IP_ALARM_RESET])
	{
		if (Machine.Status.AlarmExist || Machine.Status.WarningExist)
		{
			Comm_Request(COMM_HCB, CMD_ALARM_RESET);
		}
		this->Close();
	}

	if (AlarmFormAutoCloseCount > 20 )
	{
		AlarmFormAutoCloseCount = 0;
		this->Close();
	}
	else
	{
		if (AlarmStringList->Count == 0 && WarningStringList->Count == 0)
		{
			AlarmFormAutoCloseCount++;
		}
		else
		{
			AlarmFormAutoCloseCount = 0;
		}
	}

	// show alarm messages
	for (int textIndex = 0; textIndex < MAX_ALARM_TEXT_COUNT; textIndex++)
	{
		TTntStaticText *staticText = (TTntStaticText *) FindComponent("AlarmStaticText" + IntToStr(textIndex + 1));
		if (textIndex < AlarmStringList->Count)
		{
			staticText->Caption = AlarmStringList->Strings[textIndex];
		}
		else
		{
			staticText->Caption = "";
		}
	}

	// show warning messages
	for (int textIndex = 0; textIndex < MAX_ALARM_TEXT_COUNT; textIndex++)
	{
		TTntStaticText *staticText = (TTntStaticText *) FindComponent("WarningStaticText" + IntToStr(textIndex + 1));
		if (textIndex < WarningStringList->Count)
		{
			staticText->Caption = WarningStringList->Strings[textIndex];
		}
		else
		{
			staticText->Caption = "";
		}
	}

	int alarmPanelHeight, warningPanelHeight;

	//	if (AlarmStringList->Count == 0)  // 350 default : 100 140  340 340 680 340350 690 680   830 - 680 150
	/*if (Machine.Status.AlarmExist || AlarmStringList->Count > 0)
	{
		AlarmPanel->Visible = true;
		alarmPanelHeight = 60 + 40 * AlarmStringList->Count;
	   AlarmPanel->Height = alarmPanelHeight;
	}
	else
	{
		AlarmPanel->Visible = false;
		alarmPanelHeight = 0;
	}*/



	/*if((Machine.Status.WarningExist && Machine.WarningStatus.VBFeederEmpty) || WarningStringList->Count > 0)
	{
	  WarningPanel->Visible = true;
	  warningPanelHeight = 60 + 40 * WarningStringList->Count ;
	  WarningPanel->Height = warningPanelHeight;
	  WarningOff->Visible = true;
	}
	else
	{
	  warningPanelHeight = 0;
	  WarningPanel->Visible = false;
	  WarningOff->Visible = false;
	}*/

	//warningPanelHeight = 0;
	//WarningPanel->Visible = false;
	/*
	   if (WarningStringList->Count == 0)
	   {
	   	WarningPanel->Visible = false;
	       warningPanelHeight = 0;
		//this->ClientHeight = AlarmPanel->Height + 2;
		this->ClientHeight = AlarmPanel->Height + 102;
	   }
	   else
	   {
	   	WarningPanel->Visible = true;
		warningPanelHeight = 64 + 40 * WarningStringList->Count + 24;
	   }
	*/

	//AlarmPanel->Height = alarmPanelHeight;

	/*if (alarmPanelHeight + warningPanelHeight > MIN_FORM_HEIGHT)
	{
	this->ClientHeight = alarmPanelHeight + warningPanelHeight + 2;
	}
	else
	{
	this->ClientHeight = MIN_FORM_HEIGHT + 2;
	}*/


	/*if (AlarmCount > 0)
	{
	AlarmPanel->Visible = true;
	alarmPanelHeight = 60 + 40 * AlarmStringList->Count;
	  AlarmPanel->Height = alarmPanelHeight;
	}
	else
	{
	AlarmPanel->Visible = false;
	alarmPanelHeight = 0;
	}

	 if (WarningCount > 0)
	{
	WarningPanel->Visible = true;
	warningPanelHeight = 60 + 40 * AlarmStringList->Count;
	}
	else
	{
	WarningPanel->Visible = false;
	warningPanelHeight = 0;
	}


	this->ClientHeight = warningPanelHeight + warningPanelHeight + 250 ; */

	if (Machine.Status.AlarmExist || AlarmStringList->Count > 0)
	{
		AlarmPanel->Visible = true;
		alarmPanelHeight = 64 + 40 * AlarmStringList->Count + 24;
		AlarmPanel->Height = alarmPanelHeight;
	}
	else
	{
		AlarmPanel->Visible = false;
		alarmPanelHeight = 0;
	}


	if ((Machine.Status.WarningExist && Machine.WarningStatus.VBFeederEmpty) || WarningStringList->Count > 0)
	{
		WarningPanel->Visible = true;
		warningPanelHeight = 64 + 40 * WarningStringList->Count + 24;
		WarningPanel->Height = warningPanelHeight;
		WarningOff->Visible = true;
	}
	else
	{
		warningPanelHeight = 0;
		WarningPanel->Visible = false;
		WarningOff->Visible = false;
	}

	if (alarmPanelHeight + warningPanelHeight > MIN_FORM_HEIGHT)
	{
		this->ClientHeight = alarmPanelHeight + warningPanelHeight + 2;
	}
	else
	{
		this->ClientHeight = MIN_FORM_HEIGHT + 2;
	}

	this->Top = (Screen->Height - this->Height) / 2;
}
//---------------------------------------------------------------------------

void __fastcall TAlarmForm::AlarmResetButtonClick(TObject *Sender)
{

	if (BtnOnOffFlag == true)
	{
		if(0) //(MachineSetupData.LasercomplexerInfo.Laser_complexer_Enable)
		{
			BtnOnOffFlag = false;
		}
		else
		{
			InspectionForm->APP->Caption = "APP OFF";
			InspectionForm->APP->Font->Color = clRed;
			AppOnOffFlag = false;
			BtnOnOffFlag = false;
			ShowMessage("App On ư ٽ ֽʽÿ");
		}
	}

	if (!Comm_IsConnected(COMM_HCB))
	{
		Comm_Reconnect(COMM_HCB);
	}
	for (int spbIndex = 0; spbIndex < MachineSetupData.IPB_BoardCount; spbIndex++)
	{
		if (!Comm_IsConnected(COMM_SPB + spbIndex))
		{
			Comm_Reconnect(COMM_SPB + spbIndex);
		}
	}



	if (MachineSetupData.CompanyID == DOMESTIC_MACHINE2 && PCProgramOption.UVLaserEnabled)
	{
		//PcUiFlag.Alarm = 0;
		PcUiFlag.EMR = 0;
		Machine.SetUIFlagData();
	}

	if (Machine.Status.AlarmExist || Machine.Status.WarningExist)
	{
		alarm_reset_button_on = 1;       // ʵ ˶ ¸ ޾Ƽ ڿ ־
		Machine.AlarmBuzzerOff();

		Comm_Request(COMM_HCB, CMD_ALARM_RESET);
	}
	this->Close();
}
//---------------------------------------------------------------------------
void __fastcall TAlarmForm::OkButtonClick(TObject *Sender)
{
	this->Close();
}
//---------------------------------------------------------------------------

void __fastcall TAlarmForm::HiddenPanelDblClick(TObject *Sender)
{
	{
		SleepMode = true;
		this->Close();
	}
}
//---------------------------------------------------------------------------
void __fastcall TAlarmForm::BuzzerOffButtonClick(TObject *Sender)
{
	if (Machine.Status.AlarmExist || Machine.Status.WarningExist)
	{
		Machine.AlarmBuzzerOff();
	}
}
//---------------------------------------------------------------------------


void __fastcall TAlarmForm::WarningOffClick(TObject *Sender)
{
	WarningSleep = true;
	Machine.AlarmBuzzerOff();
	this->Close();
}
//---------------------------------------------------------------------------
void __fastcall TAlarmForm::SoftResetButtonClick(TObject *Sender)
{
	if (!Comm_IsConnected(COMM_HCB))
	{
		Comm_Reconnect(COMM_HCB);
	}
	for (int spbIndex = 0; spbIndex < MachineSetupData.IPB_BoardCount; spbIndex++)
	{
		if (!Comm_IsConnected(COMM_SPB + spbIndex))
		{
			Comm_Reconnect(COMM_SPB + spbIndex);
		}
	}

	if (Machine.Status.AlarmExist || Machine.Status.WarningExist)
	{
		Comm_Request(COMM_HCB, CMD_ALARM_RESET);
	}
}
//---------------------------------------------------------------------------



void __fastcall TAlarmForm::CheckTimerTimer(TObject *Sender)
{
	if (!bSystemStatusCheckSW)
		return ;

	RefreshAlarm();
}
//---------------------------------------------------------------------------



