//---------------------------------------------------------------------------

#ifndef AuditTrail_FormH
#define AuditTrail_FormH
//---------------------------------------------------------------------------
#include <Classes.hpp>
#include <Controls.hpp>
#include <StdCtrls.hpp>
#include <Forms.hpp>
#include <ExtCtrls.hpp>
#include <ComCtrls.hpp>
#include <Grids.hpp>
#include <FileCtrl.hpp>

#include "CSVLog.h"
#include "TntExtCtrls.hpp"
#include "TntGrids.hpp"
#include "TntStdCtrls.hpp"
#include "TntForms.hpp"
#include "TntComCtrls.hpp"

#define MAX_PRINT_PAGE_INDEX  9
#define MAX_CSV_LOG_INDEX     21
#define MAX_PRINT_LOG_INDEX (MAX_PRINT_PAGE_INDEX * MAX_CSV_LOG_INDEX) + 19
//---------------------------------------------------------------------------
class TAuditTrailForm : public TTntForm
{
__published:	// IDE-managed Components
	TTntPanel* RightMenuPanel;
	TTntButton* BrowseButton;
	TTntButton* CloseButton;
	TTntStringGrid* LogReportStringGrid;
	TTntMemo* DetailInfoMemo;
	TTntPanel* Panel1;
	TTntGroupBox* GroupBox1;
	TTntCheckBox* EventKindCheckBox;
	TTntCheckBox* ActionKindCheckBox;
	TTntGroupBox* GroupBox2;
	TTntLabel* Label1;
	TTntLabel* BrowseStartDateLabel;
	TTntLabel* Label3;
	TTntLabel* BrowseEndDateLabel;
	TTntButton* BrowseStartDateButton;
	TTntButton* BrowseEndDataButton;
	TTntButton* PeriodButton1;
	TTntButton* PeriodButton2;
	TTntButton* PeriodButton3;
	TTntGroupBox* GroupBox3;
	TTntRadioButton* AllProductRadioButton;
	TTntRadioButton* CurrentProductRadioButton;
	TTntRadioButton* SpecifiedProductRadioButton;
	TTntEdit* ProductNameEdit;
	TTntGroupBox* GroupBox4;
	TTntRadioButton* AllUserRadioButton;
	TTntRadioButton* CurrentUserRadioButton;
	TTntRadioButton* SpecifiedUserRadioButton;
	TTntEdit* UserNameEdit;
	TTntButton* PeriodButton4;
	TTntButton* PrintButton;
	TSplitter* Splitter1;
	TTntCheckBox* AlarmOnlyCheckBox;
	TTntLabel* BrowseStartTimeLabel;
	TTntLabel* BrowseEndTimeLabel;
	TTntEdit* BrowseStartHourEdit;
	TTntEdit* BrowseStartMinEdit;
	TTntEdit* BrowseEndHourEdit;
	TTntEdit* BrowseEndMinEdit;
	TTntLabel* TntLabel1;
	TTntLabel* TntLabel2;
	TTntLabel* TntLabel4;
	TTntLabel* TntLabel3;
	TPanel* Panel2;
	TTntGroupBox* LogChangeGroupBox;
	TTntGroupBox* TntGroupBox1;
	TButton* LogTimeChangeButton;
	TTntMonthCalendar* MonthCalendar;
	TTntPanel* TimeEditPanel;
	TTntLabel* Label6;
	TTntLabel* Label7;
	TTntLabel* Label8;
	TTntEdit* HourEdit;
	TTntEdit* MinEdit;
	TTntEdit* SecEdit;
	TTntGroupBox* TntGroupBox2;
	TButton* LogDeleteButton;
  TPanel *pnCSV_Option;
  TPageControl *PageControl1;
  TTabSheet *TabSheet1;
  TTntEdit *eStartUserName;
  TTntEdit *eStartProductName;
  TTntButton *TntButton1;
  TTntLabel *TntLabel5;
  TTntLabel *TntLabel6;
  TTntEdit *eLotName;
  TTntLabel *TntLabel7;
  TTntEdit *eTotalCnt;
  TTntEdit *eGoodCnt;
  TTntEdit *eDefectCnt;
  TTntEdit *eUninsCnt;
  TTntButton *TntButton2;
  TTntLabel *TntLabel8;
  TTntLabel *TntLabel9;
  TTntLabel *TntLabel10;
  TTntLabel *TntLabel11;
  TTntButton *TntButton3;
  TTntCheckBox *ckbShowCSV_Option;

	void __fastcall BrowseButtonClick(TObject* Sender);
	void __fastcall FormClose(TObject* Sender, TCloseAction& Action);
	void __fastcall FormCreate(TObject* Sender);
	void __fastcall LogReportStringGridClick(TObject* Sender);
	void __fastcall PeriodButton1Click(TObject* Sender);
	void __fastcall PeriodButton2Click(TObject* Sender);
	void __fastcall PeriodButton3Click(TObject* Sender);
	void __fastcall PeriodButton4Click(TObject* Sender);
	void __fastcall BrowseStartDateButtonClick(TObject* Sender);
	void __fastcall BrowseEndDataButtonClick(TObject* Sender);
	void __fastcall FormDestroy(TObject* Sender);
	void __fastcall EventKindCheckBoxClick(TObject* Sender);
  void __fastcall BackupButtonClick(TObject* Sender);
	void __fastcall PrintButtonClick(TObject* Sender);
	void __fastcall NumberEditClick(TObject* Sender);
	void __fastcall BrowseEditChange(TObject* Sender);
	void __fastcall TntFormShow(TObject* Sender);
	void __fastcall ProductNameEditClick(TObject* Sender);
	void __fastcall TntFormActivate(TObject* Sender);
	void __fastcall Panel2DblClick(TObject* Sender);
	void __fastcall HourEditClick(TObject* Sender);
	void __fastcall LogTimeChangeButtonClick(TObject* Sender);
	void __fastcall LogDeleteButtonClick(TObject* Sender);
	void __fastcall HourEditKeyPress(TObject* Sender, char& Key);
  void __fastcall TntButton1Click(TObject *Sender);
  void __fastcall TntButton2Click(TObject *Sender);
  void __fastcall TntButton3Click(TObject *Sender);
  void __fastcall eStartUserNameClick(TObject *Sender);
  void __fastcall eTotalCntClick(TObject *Sender);
  void __fastcall ckbShowCSV_OptionClick(TObject *Sender);
private:	// User declarations
	TCSVLogList* CSVLogList;
	int* RowToDataMap;
	TDateTime BrowseStartTime;
	TDateTime BrowseEndTime;
	WideString ProductName;
	AnsiString  CreatorName;
	int ValidData;
	TDateTime StartDateTime, EndDateTime;
	bool checkTime;

	void __fastcall ClearReportStringGrid(void);
	void __fastcall DrawStringGrid(void);
	void __fastcall GetDefaultString();
	bool __fastcall CheckDateTime(TDateTime StartDate, TDateTime EndDate);
	bool __fastcall SearchAndRevisionLogFile(AnsiString filename, TDateTime SelectedLogTime, TDateTime newLogTime, int mode);
public:		// User declarations
	__fastcall TAuditTrailForm(TComponent* Owner);
	void __fastcall OnUserChange(void);

};
//---------------------------------------------------------------------------
extern PACKAGE TAuditTrailForm* AuditTrailForm;
//---------------------------------------------------------------------------
#endif
