//---------------------------------------------------------------------------
// For SELMA200, 20180223, moon, Ϸ
// CPB04, CPB05 version ¿  밡 CPU   ٸǷ ̿  UI  
//  CPU  ī޶ ϴ κп ؼ Ͽ CPU  ī޶  ˰   ֵ 
// CPB05  ÿ  Ư   ߰ ۾ ߻  
//---------------------------------------------------------------------------

#include <vcl.h>
#pragma hdrstop

#include "CPBSetting_Form.h"
#include "CPBStatus_Form.h"
#include "Environment.h"
#include "SystemSetup.h"
#include "MultiLanguage.h"
//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma link "TntButtons"
#pragma link "TntExtCtrls"
#pragma link "TntStdCtrls"
#pragma resource "*.dfm"
TCPBSettingForm *CPBSettingForm;
//---------------------------------------------------------------------------
__fastcall TCPBSettingForm::TCPBSettingForm(TComponent* Owner)
	: TTntForm(Owner)
{
	if (DefaultLCID == 1028 || DefaultLCID == 2052 || DefaultLCID == 3076 || DefaultLCID == 4100)
		ComponentSetFontName(this, "SimSun");
  else if(DefaultLCID == 1041)
    ComponentSetFontName(this, "Meiryo UI");
  else if(DefaultLCID == 3082)
  {
    ComponentSetFontName(this, "Segoe UI");
    ComponentSetMultiLine(this);
  }

	CurrentSPBIndex = 0;
	CurrentCameraIndex = 0;
}
//---------------------------------------------------------------------------
void __fastcall TCPBSettingForm::CloseButtonClick(TObject *Sender)
{
	this->Close();
}
//---------------------------------------------------------------------------
void __fastcall TCPBSettingForm::SPBSpeedButtonClick(TObject *Sender)
{
	TTntSpeedButton *theSpeedButton = (TTntSpeedButton *)Sender;
	CurrentSPBIndex = theSpeedButton->Tag;
	ShowSPBSystemSetupInfo(CurrentSPBIndex);
}
//---------------------------------------------------------------------------
void __fastcall TCPBSettingForm::ShowSPBSystemSetupInfo(int spbIndex)
{
	int groupEnableCount = 0;
	int cpbCamCount[3];
  AnsiString cpuCountString;

	cpbCamCount[0] = 0;
	cpbCamCount[1] = 0;
	cpbCamCount[2] = 0;                                      

  if(TempSPBSystemSetupData[spbIndex].CPBVersion == CPB_VERSION_04)
  {
    CPBVersionRadioBtn1->Checked = true;
    CurrentCPUIndex = 8;
    CurrentMaxCPUIndex = 32;
    cpuCountString = "x 8EA (CPU)";

    CPBGroupEnableLabel4->Visible = true;
    CPUCountLabel4->Visible = true;
    Label4->Visible = true;
    CPBSDRSizeComboBox4->Visible = true;
    Label9->Visible = true;
    CPBClockComboBox4->Visible = true;
  }
  else if(TempSPBSystemSetupData[spbIndex].CPBVersion == CPB_VERSION_05)
  {
    CPBVersionRadioBtn2->Checked = true;
    CurrentCPUIndex = 32;
    CurrentMaxCPUIndex = 96;
    cpuCountString = "x 32EA (CPU)";

    CPBGroupEnableLabel4->Visible = false;
    CPUCountLabel4->Visible = false;
    Label4->Visible = false;
    CPBSDRSizeComboBox4->Visible = false;
    Label9->Visible = false;
    CPBClockComboBox4->Visible = false;
  }

  TempSPBSystemSetupData[spbIndex].MaxProcessingCoreCount = CurrentMaxCPUIndex;
  
  for(int cpuLabeIndex = 1; cpuLabeIndex <= 4; cpuLabeIndex++)
  {
    TTntLabel *CPUCountLabel = (TTntLabel *)FindComponent("CPUCountLabel" + IntToStr(cpuLabeIndex));

    if(CPUCountLabel)
    {
      CPUCountLabel->Caption = cpuCountString;
    }
  }

  CPBGroupEnableLabel1->Color = clBtnFace;
  CPBGroupEnableLabel2->Color = clBtnFace;
  CPBGroupEnableLabel3->Color = clBtnFace;
  CPBGroupEnableLabel4->Color = clBtnFace;
	for (int cpbIndex = 0; cpbIndex < SYSTEM_CPB_MAX_COUNT; cpbIndex++)
	{
	
    if(cpbIndex < CurrentMaxCPUIndex)
    {
      if (TempSPBSystemSetupData[spbIndex].CPBEnabled[cpbIndex])
      {
        groupEnableCount++;
      }
#ifdef BOARD_TYPE_IPB		   
      if (cpbIndex % CurrentCPUIndex == CurrentCPUIndex - 1)
      {
        TTntLabel *cpbGroupEnableLabel = (TTntLabel *)FindComponent("CPBGroupEnableLabel" + IntToStr(cpbIndex / CurrentCPUIndex + 1));

        if (cpbGroupEnableLabel)
        {
          if (groupEnableCount == CurrentCPUIndex-1)
          {
            cpbGroupEnableLabel->Color = clLime;
          }
          else if (groupEnableCount == 0)
          {
            cpbGroupEnableLabel->Color = clRed;
          }
          else
          {
            cpbGroupEnableLabel->Color = clGray;
          }

          groupEnableCount = 0;
        }
      }
#else 
      if (cpbIndex % CurrentCPUIndex == CurrentCPUIndex - 1)
      {
        TTntLabel *cpbGroupEnableLabel = (TTntLabel *)FindComponent("CPBGroupEnableLabel" + IntToStr(cpbIndex / CurrentCPUIndex + 1));

        if (cpbGroupEnableLabel)
        {
          if (groupEnableCount == CurrentCPUIndex)
          {
            cpbGroupEnableLabel->Color = clLime;
          }
          else if (groupEnableCount == 1)
          {
            cpbGroupEnableLabel->Color = clRed;
          }
          else
          {
            cpbGroupEnableLabel->Color = clGray;
          }

          groupEnableCount = 0;
        }
      }
#endif	  
    }
	}

	for (int cpbGroupIndex = 0; cpbGroupIndex < SYSTEM_CPB_MAX_COUNT / CurrentCPUIndex; cpbGroupIndex++)
	{
    if(cpbGroupIndex < CurrentMaxCPUIndex / CurrentCPUIndex)
    {
      TTntComboBox *cpbSDRSizeComboBox = (TTntComboBox *)FindComponent("CPBSDRSizeComboBox" + IntToStr(cpbGroupIndex + 1));
      if (cpbSDRSizeComboBox)
      {
        cpbSDRSizeComboBox->ItemIndex = TempSPBSystemSetupData[spbIndex].CPBSDRSizeType[cpbGroupIndex * CurrentCPUIndex];
      }

      TTntComboBox *cpbClockComboBox = (TTntComboBox *)FindComponent("CPBClockComboBox" + IntToStr(cpbGroupIndex + 1));
      if (cpbClockComboBox)
      {
        cpbClockComboBox->ItemIndex = TempSPBSystemSetupData[spbIndex].CPBClockKind[cpbGroupIndex * CurrentCPUIndex];
      }
    }
	}

	HPITransferMethodRadioGroup->ItemIndex = TempSPBSystemSetupData[spbIndex].ImageTransferMethod;

  // khd1994 IPּ  Portó
  Edit_IpAddr->Text  = TempSPBSystemSetupData[spbIndex].szIpAddr;
  Edit_TcpPort->Text = IntToStr(TempSPBSystemSetupData[spbIndex].nTcpPort);
}
//---------------------------------------------------------------------------
void __fastcall TCPBSettingForm::CPBGroupEnableLabelClick(TObject *Sender)
{
	TTntLabel *theLabel = (TTntLabel *)Sender;
	int groupIndex = theLabel->Tag;
	for (int cpbIndex = groupIndex * CurrentCPUIndex; cpbIndex < (groupIndex + 1) * CurrentCPUIndex; cpbIndex++)
	{
    if (theLabel->Color != clLime)
    {
      TempSPBSystemSetupData[CurrentSPBIndex].CPBEnabled[cpbIndex] = 1;
      TempSPBSystemSetupData[CurrentSPBIndex].CameraDistributionIndex[cpbIndex] = 0xFF;
    }
    else
    {
      TempSPBSystemSetupData[CurrentSPBIndex].CPBEnabled[cpbIndex] = 0;
      TempSPBSystemSetupData[CurrentSPBIndex].CameraDistributionIndex[cpbIndex] = 0;
    }
	}
#ifdef BOARD_TYPE_IPB	
	TempSPBSystemSetupData[CurrentSPBIndex].CPBEnabled[0] = 0;
	TempSPBSystemSetupData[CurrentSPBIndex].CPBEnabled[8] = 0;
	TempSPBSystemSetupData[CurrentSPBIndex].CPBEnabled[16] = 0;
	TempSPBSystemSetupData[CurrentSPBIndex].CPBEnabled[24] = 0;
#endif
	ShowSPBSystemSetupInfo(CurrentSPBIndex);
}
//---------------------------------------------------------------------------

void __fastcall TCPBSettingForm::SystemSetupButtonClick(TObject *Sender)
{
  TempSPBSystemSetupData[0].CameraDistributionIndex;

	memcpy(SPBSystemSetupData, TempSPBSystemSetupData, SYSTEM_SPB_MAX_COUNT * sizeof(TSPBSystemSetupData));
	WriteSPBSystemSetupData(ProgramPath.Env + "\\SystemInfor.ini", SPBSystemSetupData);
	if (SendSystemSetupData())
	{
		ShowMessageW(DATAMATCHINGFORM_MSG_13);
	}
}
//---------------------------------------------------------------------------

void __fastcall TCPBSettingForm::CPBSDRSizeComboBoxChange(TObject *Sender)
{
	TTntComboBox *theComboBox = (TTntComboBox *)Sender;
	int groupIndex = theComboBox->Tag;
	for (int cpbIndex = groupIndex * CurrentCPUIndex; cpbIndex < (groupIndex + 1) * CurrentCPUIndex; cpbIndex++)
	{
		TempSPBSystemSetupData[CurrentSPBIndex].CPBSDRSizeType[cpbIndex] = theComboBox->ItemIndex;
	}
}
//---------------------------------------------------------------------------

void __fastcall TCPBSettingForm::EnableSettingSpeedButtonClick(
	TObject *Sender)
{
	ShowSPBSystemSetupInfo(CurrentSPBIndex);
}
//---------------------------------------------------------------------------

void __fastcall TCPBSettingForm::CPBClockComboBoxChange(TObject *Sender)
{
	TTntComboBox *theComboBox = (TTntComboBox *)Sender;
	int groupIndex = theComboBox->Tag;
	for (int cpbIndex = groupIndex * CurrentCPUIndex; cpbIndex < (groupIndex + 1) * CurrentCPUIndex; cpbIndex++)
	{
		TempSPBSystemSetupData[CurrentSPBIndex].CPBClockKind[cpbIndex] = theComboBox->ItemIndex;
	}
}
//---------------------------------------------------------------------------

void __fastcall TCPBSettingForm::FormCreate(TObject *Sender)
{
	memcpy(TempSPBSystemSetupData, SPBSystemSetupData, SYSTEM_SPB_MAX_COUNT * sizeof(TSPBSystemSetupData));

	for (int spbIndex = 0; spbIndex < MachineSetupData.IPB_BoardCount; spbIndex++)
	{
		TTntSpeedButton *theSpeedButton = (TTntSpeedButton *)FindComponent("SPBSpeedButton" + IntToStr(spbIndex + 1));
   		theSpeedButton->Visible = true;
/*
		if (theSpeedButton)
		{
			if (Comm_IsConnected(COMM_SPB + spbIndex))
			{
				theSpeedButton->Enabled = true;
			}
			else
			{
				theSpeedButton->Enabled = false;
			}
		}
*/		
	}
	SPBSpeedButton1->Click();
}
//---------------------------------------------------------------------------

void __fastcall TCPBSettingForm::HPITransferMethodRadioGroupClick(
	TObject *Sender)
{
	TempSPBSystemSetupData[CurrentSPBIndex].ImageTransferMethod = HPITransferMethodRadioGroup->ItemIndex;
}
//---------------------------------------------------------------------------

void __fastcall TCPBSettingForm::CPBVersionRadioBtn1Click(TObject *Sender)
{
  if(CPBVersionRadioBtn1->Checked)
  {
    TempSPBSystemSetupData[CurrentSPBIndex].CPBVersion = CPB_VERSION_04;
  }
  else if(CPBVersionRadioBtn2->Checked)
  {
    TempSPBSystemSetupData[CurrentSPBIndex].CPBVersion = CPB_VERSION_05; 
  }

  ShowSPBSystemSetupInfo(CurrentSPBIndex);
}
//---------------------------------------------------------------------------

void __fastcall TCPBSettingForm::Edit_IpAddrChange(TObject *Sender)
{
    strcpy(TempSPBSystemSetupData[CurrentSPBIndex].szIpAddr, Edit_IpAddr->Text.c_str());
}
//---------------------------------------------------------------------------

void __fastcall TCPBSettingForm::Edit_TcpPortChange(TObject *Sender)
{
    TempSPBSystemSetupData[CurrentSPBIndex].nTcpPort = StrToIntDef(Edit_TcpPort->Text,7000);
}
//---------------------------------------------------------------------------
void __fastcall TCPBSettingForm::CpbStatusCheckBtnClick(TObject *Sender)
{
  CheckCPBBootStatus(false,false);  
}
//---------------------------------------------------------------------------

