//---------------------------------------------------------------------------
// For SELMA200, 20180223, moon, Ϸ
// Camera Index  
//---------------------------------------------------------------------------
#pragma hdrstop
#include "CSVLog.h"
#include "common.h"
#include "Common_PC.h"
#include "Environment.h"
#include "MultiLanguage.h"

#pragma package(smart_init) 
//---------------------------------------------------------------------------
//	CSVLogException class
//---------------------------------------------------------------------------
__fastcall CSVLogException::CSVLogException(ECSVError error)
{
	FMessage = MessageOfErrorCode(error);
}
//---------------------------------------------------------------------------
WideString __fastcall CSVLogException::MessageOfErrorCode(ECSVError error)
{
	WideString returnMessage = CSVLOG_RETURNSTR_126;
	switch (error)
	{
	case ECSV_FILE_CANNOT_OPEN:
		returnMessage = CSVLOG_RETURNSTR_95;
		break;
	case ECSV_ERROR_VERSION_NOT_MATCHED:
		returnMessage = CSVLOG_RETURNSTR_94;
		break;
	default:
		break;
	}
	return returnMessage;
}
//---------------------------------------------------------------------------
//	TCSVLogFileHeader class
//---------------------------------------------------------------------------
__fastcall TCSVLogFileHeader::TCSVLogFileHeader()
{
	CSVLogFileHeaderStr.FileHeader = CSV_LOG_FILE_HEADER_IDENTIFIER;
	CSVLogFileHeaderStr.MajorVersion = CSV_LOG_FILE_HEADER_CURRENT_MAJOR_VERSION;
	CSVLogFileHeaderStr.MinorVersion = CSV_LOG_FILE_HEADER_CURRENT_MINOR_VERSION;
	CSVLogFileHeaderStr.HeaderSize = sizeof(TCSVLogFileHeaderStr);
	CSVLogFileHeaderStr.CreateTime = 0;
}
//---------------------------------------------------------------------------
__fastcall TCSVLogFileHeader::TCSVLogFileHeader(double createTime)
{
	CSVLogFileHeaderStr.FileHeader = CSV_LOG_FILE_HEADER_IDENTIFIER;
	CSVLogFileHeaderStr.MajorVersion = CSV_LOG_FILE_HEADER_CURRENT_MAJOR_VERSION;
	CSVLogFileHeaderStr.MinorVersion = CSV_LOG_FILE_HEADER_CURRENT_MINOR_VERSION;
	CSVLogFileHeaderStr.HeaderSize = sizeof(TCSVLogFileHeaderStr);
	CSVLogFileHeaderStr.CreateTime = createTime;
}
//---------------------------------------------------------------------------
void __fastcall TCSVLogFileHeader::SaveToFileStream(TFileStream *fileStream)
{
	fileStream->Write(&CSVLogFileHeaderStr, sizeof(TCSVLogFileHeaderStr));
}
//---------------------------------------------------------------------------
bool __fastcall TCSVLogFileHeader::LoadFromFileStream(TFileStream *fileStream)
{
	unsigned int fileHeader;
	unsigned int majorVersion;
	unsigned int minorVersion;
	unsigned int headerSize;
	fileStream->Read(&fileHeader, sizeof(unsigned int));
	fileStream->Read(&majorVersion, sizeof(unsigned int));
	fileStream->Read(&minorVersion, sizeof(unsigned int));
	fileStream->Read(&headerSize, sizeof(unsigned int));

	if (fileHeader != CSV_LOG_FILE_HEADER_IDENTIFIER || majorVersion > CSV_LOG_FILE_HEADER_CURRENT_MAJOR_VERSION
	        || headerSize != sizeof(TCSVLogFileHeaderStr))
	{
		throw CSVLogException(ECSV_FILE_CANNOT_OPEN);
	}
	else if (minorVersion != CSV_LOG_FILE_HEADER_CURRENT_MINOR_VERSION)
	{
		throw CSVLogException(ECSV_ERROR_VERSION_NOT_MATCHED);
	}
	else
	{
		fileStream->Read((unsigned char *)&CSVLogFileHeaderStr + 16, sizeof(TCSVLogFileHeaderStr) - 16);
	}

}
//---------------------------------------------------------------------------
//	TCSVLog class
//---------------------------------------------------------------------------
__fastcall TCSVLog::TCSVLog()
{
	Params = NULL;
	ParamSize = 0;
	Message = NULL;
	MessageLength = 0;
}
//---------------------------------------------------------------------------
__fastcall TCSVLog::~TCSVLog()
{
	ClearData();
}
//---------------------------------------------------------------------------
void __fastcall TCSVLog::ClearData(void)
{
	//	if (Params) {delete[] Params; Params = NULL;}
	if (Message)
	{
		delete[] Message;
		Message = NULL;
	}
}
//---------------------------------------------------------------------------
ECSVLogKind __fastcall TCSVLog::GetKind(void)
{
	return FKind;
}
//---------------------------------------------------------------------------
double __fastcall TCSVLog::GetTime(void)
{
	return FTime;
}
//---------------------------------------------------------------------------
AnsiString __fastcall TCSVLog::GetFileName(void)
{
	return FFromFileName;
}
//---------------------------------------------------------------------------
//	TCSVEventLog class
//---------------------------------------------------------------------------
__fastcall TCSVEventLog::TCSVEventLog()
{
	FEvent = ECSV_EVENT_NONE;
	Params = NULL;
	ParamSize = 0;
}
//---------------------------------------------------------------------------
__fastcall TCSVEventLog::TCSVEventLog(ECSVEvent event)
{
	FEvent = event;
	Params = NULL;
	ParamSize = 0;
}
//---------------------------------------------------------------------------
__fastcall TCSVEventLog::~TCSVEventLog()
{
	if (Params)
		delete[] Params;
}
//---------------------------------------------------------------------------
/*
void __fastcall TCSVEventLog::SetLogInfoParam(void *param)
{
	AnsiString *id = (AnsiString *)param;
	strncpy(LogInfoID, id->c_str(), 32);
}
*/ 
//---------------------------------------------------------------------------
void __fastcall TCSVEventLog::SetParams(unsigned char *params, int paramSize)
{
	if (Params)
	{
		delete[] Params;
		Params = NULL;
	}
	if (paramSize > 0)
	{
		Params = new unsigned char[paramSize];
		memcpy(Params, params, paramSize);
	}
	ParamSize = paramSize;
}
//---------------------------------------------------------------------------
bool __fastcall TCSVEventLog::SaveToFileStream(TFileStream *fileStream)
{
	bool returnValue = true;
	TCSVLogUnitHeader csvLogUnitHeader;
	struct
	{
		unsigned int Version;
		int Event;
	}
	eventLogHeader;

	struct
	{
		char UserName[32];
	}
	logEventData;

	try
	{
		if (FEvent == ECSV_EVENT_APPLICATION_STARTED || FEvent == ECSV_EVENT_APPLICATION_TERMINATED || FEvent == ECSV_EVENT_APPLICATION_TIMECHANGEED ||
			FEvent == ECSV_EVENT_MACHINE_OFF)
		{
			unsigned int dataSize = sizeof(eventLogHeader);
			csvLogUnitHeader.Version = CSV_UNIT_HEADER_CURRENT_VERSION;
			csvLogUnitHeader.Size = sizeof(TCSVLogUnitHeader) + dataSize;
			csvLogUnitHeader.Kind = ECSV_LOG_KIND_EVENT;
			csvLogUnitHeader.Time = Now().Val;
			if (fileStream->Write(&csvLogUnitHeader, sizeof(TCSVLogUnitHeader)) != sizeof(TCSVLogUnitHeader))
			{
				throw CSVLogException(ECSV_FILE_CANNOT_WRITE);
			}
			eventLogHeader.Version = CSV_EVENT_LOG_CURRENT_VERSION;
			eventLogHeader.Event = FEvent;

			if (fileStream->Write(&eventLogHeader, sizeof(eventLogHeader)) != sizeof(eventLogHeader))
			{
				throw CSVLogException(ECSV_FILE_CANNOT_WRITE);
			}
		}
		else if (FEvent == ECSV_EVENT_MACHINE_SUSPEND)
		{
			unsigned int dataSize = sizeof(eventLogHeader) + ParamSize;
			csvLogUnitHeader.Version = CSV_UNIT_HEADER_CURRENT_VERSION;
			csvLogUnitHeader.Size = sizeof(TCSVLogUnitHeader) + dataSize;
			csvLogUnitHeader.Kind = ECSV_LOG_KIND_EVENT;
			csvLogUnitHeader.Time = Now().Val;
			if (fileStream->Write(&csvLogUnitHeader, sizeof(TCSVLogUnitHeader)) != sizeof(TCSVLogUnitHeader))
			{
				throw CSVLogException(ECSV_FILE_CANNOT_WRITE);
			}
			eventLogHeader.Version = CSV_EVENT_LOG_CURRENT_VERSION;
			eventLogHeader.Event = FEvent;

			if (fileStream->Write(&eventLogHeader, sizeof(eventLogHeader)) != sizeof(eventLogHeader))
			{
				throw CSVLogException(ECSV_FILE_CANNOT_WRITE);
			}
			if (fileStream->Write(&ParamSize, sizeof(int)) != sizeof(int))
			{
				throw CSVLogException(ECSV_FILE_CANNOT_WRITE);
			}
			if (fileStream->Write(Params, ParamSize) != ParamSize)
			{
				throw CSVLogException(ECSV_FILE_CANNOT_WRITE);
			}
		}
		else
		{
			unsigned int dataSize = sizeof(eventLogHeader) + ParamSize;
			csvLogUnitHeader.Version = CSV_UNIT_HEADER_CURRENT_VERSION;
			csvLogUnitHeader.Size = sizeof(TCSVLogUnitHeader) + dataSize;
			csvLogUnitHeader.Kind = ECSV_LOG_KIND_EVENT;
			csvLogUnitHeader.Time = Now().Val;
			if (fileStream->Write(&csvLogUnitHeader, sizeof(TCSVLogUnitHeader)) != sizeof(TCSVLogUnitHeader))
			{
				throw CSVLogException(ECSV_FILE_CANNOT_WRITE);
			}
			eventLogHeader.Version = CSV_EVENT_LOG_CURRENT_VERSION;
			eventLogHeader.Event = FEvent;

			if (fileStream->Write(&eventLogHeader, sizeof(eventLogHeader)) != sizeof(eventLogHeader))
			{
				throw CSVLogException(ECSV_FILE_CANNOT_WRITE);
			}
			if (fileStream->Write(&ParamSize, sizeof(int)) != sizeof(int))
			{
				throw CSVLogException(ECSV_FILE_CANNOT_WRITE);
			}
			if (fileStream->Write(Params, ParamSize) != ParamSize)
			{
				throw CSVLogException(ECSV_FILE_CANNOT_WRITE);
			}
		}
		/*
		else if (FEvent == ECSV_EVENT_LOGIN || FEvent == ECSV_EVENT_LOGOUT)
		{
			unsigned int dataSize = sizeof(eventLogHeader) + sizeof(logEventData);
			csvLogUnitHeader.Version = CSV_UNIT_HEADER_CURRENT_VERSION;
			csvLogUnitHeader.Size = sizeof(TCSVLogUnitHeader) + dataSize;
			csvLogUnitHeader.Kind = ECSV_LOG_KIND_EVENT;
			csvLogUnitHeader.Time = Now().Val;
			if (fileStream->Write(&csvLogUnitHeader, sizeof(TCSVLogUnitHeader)) != sizeof(TCSVLogUnitHeader))
			{
				throw CSVLogException(ECSV_FILE_CANNOT_WRITE);
			}
			eventLogHeader.Version = CSV_EVENT_LOG_CURRENT_VERSION;
			eventLogHeader.Event = FEvent;

			if (fileStream->Write(&eventLogHeader, sizeof(eventLogHeader)) != sizeof(eventLogHeader))
			{
				throw CSVLogException(ECSV_FILE_CANNOT_WRITE);
			}

			memcpy(logEventData.UserName, Params, 32);
			if (fileStream->Write(&logEventData, sizeof(logEventData)) != sizeof(logEventData))
			{
				throw CSVLogException(ECSV_FILE_CANNOT_WRITE);
			}
		}
		*/
	}
	catch (CSVLogException &ec)
	{
		returnValue = false;
	}
	return returnValue;
}
//---------------------------------------------------------------------------
bool __fastcall TCSVEventLog::LoadFromFileStream(TFileStream *fileStream)
{
	bool returnValue = true;

	struct
	{
		unsigned int Version;
		int Event;
	}
	eventLogHeader;

	struct
	{
		char UserName[32];
	}
	logEventData;

	TCSVLogUnitHeader csvLogUnitHeader;
	try
	{
		if (fileStream->Read(&eventLogHeader, sizeof(eventLogHeader)) != sizeof(eventLogHeader))
		{
			throw CSVLogException(ECSV_FILE_CANNOT_READ);
		}
		if (eventLogHeader.Version == CSV_EVENT_LOG_CURRENT_VERSION)
		{
			FEvent = eventLogHeader.Event;
			if (FEvent == ECSV_EVENT_MACHINE_SUSPEND || FEvent == ECSV_EVENT_ALARM ||
			        FEvent == ECSV_EVENT_ALARM_CLEAR)
			{
				if (fileStream->Read(&ParamSize, sizeof(int)) != sizeof(int))
				{
					throw CSVLogException(ECSV_FILE_CANNOT_READ);
				}
				if (ParamSize < 0)
				{
					throw CSVLogException(ECSV_FILE_CANNOT_READ);
				}

				if (Params)
				{
					delete[] Params;
					Params = NULL;
				}
				if (ParamSize > 0)
				{
					Params = new unsigned char[ParamSize];
					if (fileStream->Read(Params, ParamSize) != ParamSize)
					{
						throw CSVLogException(ECSV_FILE_CANNOT_READ);
					}
				}
			}
			/*
			if (FEvent == ECSV_EVENT_LOGIN || FEvent == ECSV_EVENT_LOGOUT)
			{
				if (fileStream->Read(&logEventData, sizeof(logEventData)) != sizeof(logEventData))
				{
					throw CSVLogException(ECSV_FILE_CANNOT_READ);
				}
				else
				{
					if (Params) delete[] Params;
					Params = new unsigned char[32];
					memcpy(Params, logEventData.UserName, 32);
				}
			}
			*/
		}
		else
		{
			throw CSVLogException(ECSV_FILE_CANNOT_READ);
		}
	}
	catch (CSVLogException &ec)
	{
		returnValue = false;
	}
	return returnValue;
}
//---------------------------------------------------------------------------
WideString __fastcall TCSVEventLog::GetCreatorName(void)
{
	//	return "ý";
	return "";
}
//---------------------------------------------------------------------------
WideString __fastcall TCSVEventLog::GetMessage(void)
{
	WideString returnStr = "";
	int suspendReason;
	unsigned int alarmCode;
	WideString suspendStr;
	WideString alarmStr;
	WCHAR TempString[100];
	WideString* str;  ////
	if (MachineSetupData.CompanyID == INTERNATIONAL_MACHINE2)
	{
		switch (FEvent)
		{
		case ECSV_EVENT_MACHINE_OFF:
			returnStr = CSVLOG_RETURNSTR_176;
			break;			
		case ECSV_EVENT_APPLICATION_STARTED:
			returnStr = CSVLOG_RETURNSTR_145;
			break;
		case ECSV_EVENT_APPLICATION_TERMINATED:
			returnStr = CSVLOG_RETURNSTR_146;
			break;
		case ECSV_EVENT_APPLICATION_TIMECHANGEED:
			returnStr = CSVLOG_RETURNSTR_161;
			break;
		case ECSV_EVENT_MACHINE_SUSPEND:
			suspendReason = *(unsigned char *)Params;
			switch (suspendReason)
			{
			case MACHINE_SUSPEND_REASON_FEEDER_EMPTY:  //INSPECTIONFORM_MSG_10
				suspendStr = "[" +WideString(INSPECTIONFORM_MSG_10)+"]";
				break;
			case MACHINE_SUSPEND_REASON_FEEDER_TROUBLE:  //INSPECTIONFORM_MSG_07
				suspendStr = "[" +WideString(INSPECTIONFORM_MSG_07)+"]";
				break;
			case MACHINE_SUSPEND_REASON_DEFECT:  //INSPECTIONFORM_MSG_15
				suspendStr = "[" +WideString(INSPECTIONFORM_MSG_15)+"]";
				break;
			case MACHINE_SUSPEND_REASON_UNINSPECT:  //INSPECTIONFORM_MSG_13
				suspendStr = "[" +WideString(INSPECTIONFORM_MSG_13)+"]";
				break;
			case MACHINE_SUSPEND_REASON_TIMEOUT:  //INSPECTIONFORM_MSG_22
				suspendStr = "[" +WideString(INSPECTIONFORM_MSG_22)+"]";
				break;
			case MACHINE_SUSPEND_REASON_TABLET_DISAPPEAR:  //INSPECTIONFORM_MSG_21
				suspendStr = "[" +WideString(INSPECTIONFORM_MSG_21)+"]";
				break;
			case MACHINE_SUSPEND_REASON_REGULATOR:  //INSPECTIONFORM_MSG_08
				suspendStr = "[" +WideString(INSPECTIONFORM_MSG_08)+"]";
				break;
			case MACHINE_SUSPEND_REASON_BLOWER_OL:  //INSPECTIONFORM_MSG_01
				suspendStr = "[" +WideString(INSPECTIONFORM_MSG_01)+"]";
				break;
			case MACHINE_SUSPEND_REASON_VD1_STALL:  //INSPECTIONFORM_MSG_02
				suspendStr = "[" +WideString(INSPECTIONFORM_MSG_02)+"]";
				break;
			case MACHINE_SUSPEND_REASON_VD2_STALL:  //INSPECTIONFORM_MSG_03
				suspendStr = "[" +WideString(INSPECTIONFORM_MSG_03)+"]";
				break;
			case MACHINE_SUSPEND_REASON_GP_COUNT_REACHED:  //INSPECTIONFORM_MSG_11
				suspendStr = "[" +WideString(INSPECTIONFORM_MSG_11)+"]";
				break;
			case MACHINE_SUSPEND_REASON_BRIGHTNESS_DOWN:  //INSPECTIONFORM_MSG_20
				suspendStr = "[" +WideString(INSPECTIONFORM_MSG_20)+"]";
				break;
			case MACHINE_SUSPEND_REASON_DOOR_OPEN:  //INSPECTIONFORM_MSG_09
				suspendStr = "[" +WideString(INSPECTIONFORM_MSG_09)+"]";
				break;
			case MACHINE_SUSPEND_REASON_DP_COUNT_REACHED:  //INSPECTIONFORM_MSG_16
				suspendStr = "[" +WideString(INSPECTIONFORM_MSG_16)+"]";
				break;
			case MACHINE_SUSPEND_REASON_UP_COUNT_REACHED:  //INSPECTIONFORM_MSG_12
				suspendStr = "[" +WideString(INSPECTIONFORM_MSG_12)+"]";
				break;
			case MACHINE_SUSPEND_REASON_VISION_SENSOR_1:  //INSPECTIONFORM_MSG_19
				suspendStr = "[" +WideString(INSPECTIONFORM_MSG_19)+"]";
				break;
			case MACHINE_SUSPEND_REASON_VISION_SENSOR_2:  //INSPECTIONFORM_MSG_18
				suspendStr = "[" +WideString(INSPECTIONFORM_MSG_18)+"]";
				break;
			case MACHINE_SUSPEND_REASON_TIME_OVER:  //INSPECTIONFORM_MSG_18
				suspendStr = "[" +WideString(INSPECTIONFORM_MSG_18)+"]";
				break;
			default:
				suspendStr = CSVLOG_RETURNSTR_53;
				break;
			}
			wsprintfW(TempString, CSVLOG_RETURNSTR_01, suspendStr);
			returnStr = WideString(TempString);   ////
			break;
		case ECSV_EVENT_ALARM:
			alarmCode = *(unsigned int *)Params;
			switch (alarmCode)
			{
			case CSV_ALARM_CODE_HCB_NC:  //ALARMFORM_STRINGLIST_ADD_16
				alarmStr = "[" +WideString(ALARMFORM_STRINGLIST_ADD_16)+"]";
				break;
			case CSV_ALARM_CODE_SPB_1_NC:  //ALARMFORM_STRINGLIST_ADD_01
				wsprintfW(TempString, ALARMFORM_STRINGLIST_ADD_01, 1);
				alarmStr = "[" +WideString(TempString)+"]";
				break;
			case CSV_ALARM_CODE_SPB_2_NC:  //ALARMFORM_STRINGLIST_ADD_01
				wsprintfW(TempString, ALARMFORM_STRINGLIST_ADD_01, 2);
				alarmStr = "[" +WideString(TempString)+"]";
				break;
			case CSV_ALARM_CODE_SPB_3_NC:  //ALARMFORM_STRINGLIST_ADD_01
				wsprintfW(TempString, ALARMFORM_STRINGLIST_ADD_01, 3);
				alarmStr = "[" +WideString(TempString)+"]";
				break;
			case CSV_ALARM_CODE_SPB_4_NC:  //ALARMFORM_STRINGLIST_ADD_01
				wsprintfW(TempString, ALARMFORM_STRINGLIST_ADD_01, 4);
				alarmStr = "[" +WideString(TempString)+"]";
				break;
			case CSV_ALARM_CODE_SPB_5_NC:  //ALARMFORM_STRINGLIST_ADD_01
				wsprintfW(TempString, ALARMFORM_STRINGLIST_ADD_01, 5);
				alarmStr = "[" +WideString(TempString)+"]";
				break;
			case CSV_ALARM_CODE_SPB_6_NC:  //ALARMFORM_STRINGLIST_ADD_01
				wsprintfW(TempString, ALARMFORM_STRINGLIST_ADD_01, 6);
				alarmStr = "[" +WideString(TempString)+"]";
				break;
			case CSV_ALARM_CODE_COMPRESSED_AIR:  //ALARMFORM_STRINGLIST_ADD_19
				alarmStr = "[" +WideString(ALARMFORM_STRINGLIST_ADD_19)+"]";
				break;
			case CSV_ALARM_CODE_EMERGENCY_ON:  //ALARMFORM_STRINGLIST_ADD_15
				alarmStr = "[" +WideString(ALARMFORM_STRINGLIST_ADD_15)+"]";
				break;
			case CSV_ALARM_CODE_INVERTER_1_TRIP:  //ALARMFORM_STRINGLIST_ADD_07
				alarmStr = "[" +WideString(ALARMFORM_STRINGLIST_ADD_07)+"]";
				break;
			case CSV_ALARM_CODE_INVERTER_2_TRIP:  //ALARMFORM_STRINGLIST_ADD_11
				alarmStr = "[" +WideString(ALARMFORM_STRINGLIST_ADD_11)+"]";
				break;
			case CSV_ALARM_CODE_INVERTER_3_TRIP:  //ALARMFORM_STRINGLIST_ADD_28
				alarmStr = "[" +WideString(ALARMFORM_STRINGLIST_ADD_28)+"]";
				break;
			case CSV_ALARM_CODE_RING_BLOWER_3_OL:  
				alarmStr = "[" +WideString(ALARMFORM_STRINGLIST_ADD_28)+"]";
				break;
			case CSV_ALARM_CODE_DISK_1_SUCTION_LOW:  //ALARMFORM_STRINGLIST_ADD_09
				alarmStr = "[" +WideString(ALARMFORM_STRINGLIST_ADD_09)+"]";
				break;
			case CSV_ALARM_CODE_DISK_2_SUCTION_LOW:  //ALARMFORM_STRINGLIST_ADD_13
				alarmStr = "[" +WideString(ALARMFORM_STRINGLIST_ADD_13)+"]";
				break;
			case CSV_ALARM_CODE_SERVO_ALARM:  //ALARMFORM_STRINGLIST_ADD_32
				alarmStr = "[" +WideString(ALARMFORM_STRINGLIST_ADD_32)+"]";
				break;
			case CSV_ALARM_CODE_INTERLOCK:  //ALARMFORM_STRINGLIST_ADD_20
				alarmStr = "[" +WideString(ALARMFORM_STRINGLIST_ADD_20)+"]";
				break;
			case CSV_ALARM_CODE_DISK_1_STALL:  //ALARMFORM_STRINGLIST_ADD_10
				alarmStr = "[" +WideString(ALARMFORM_STRINGLIST_ADD_10)+"]";
				break;
			case CSV_ALARM_CODE_DISK_2_STALL:  //ALARMFORM_STRINGLIST_ADD_14
				alarmStr = "[" +WideString(ALARMFORM_STRINGLIST_ADD_14)+"]";
				break;
			case CSV_ALARM_CODE_TOTAL_FULL:  //ALARMFORM_STRINGLIST_ADD_47
				alarmStr = "[" +WideString(ALARMFORM_STRINGLIST_ADD_47)+"]";
				break;
			case CSV_ALARM_CODE_GP_FULL:  //ALARMFORM_STRINGLIST_ADD_23
				alarmStr = "[" +WideString(ALARMFORM_STRINGLIST_ADD_23)+"]";
				break;
			case CSV_ALARM_CODE_DP_FULL:  //ALARMFORM_STRINGLIST_ADD_30
				alarmStr = "[" +WideString(ALARMFORM_STRINGLIST_ADD_30)+"]";
				break;
			case CSV_ALARM_CODE_UP_FULL:  //ALARMFORM_STRINGLIST_ADD_24
				alarmStr = "[" +WideString(ALARMFORM_STRINGLIST_ADD_24)+"]";
				break;
			case CSV_ALARM_CODE_DP_RATIO_OVER:  //ALARMFORM_STRINGLIST_ADD_29
				alarmStr = "[" +WideString(ALARMFORM_STRINGLIST_ADD_29)+"]";
				break;
			case CSV_ALARM_CODE_CRIT_DP_RATIO_OVER: //ALARMFORM_STRINGLIST_ADD_49
				alarmStr = "[" +WideString(ALARMFORM_STRINGLIST_ADD_49)+"]";
				break;
			case CSV_ALARM_CODE_UP_RATIO_OVER:  //ALARMFORM_STRINGLIST_ADD_25
				alarmStr = "[" +WideString(ALARMFORM_STRINGLIST_ADD_25)+"]";
				break;
			case CSV_ALARM_CODE_CRIT_UP_RATIO_OVER:  //ALARMFORM_STRINGLIST_ADD_50
				alarmStr = "[" +WideString(ALARMFORM_STRINGLIST_ADD_50)+"]";
				break;
			case CSV_ALARM_CODE_SENSOR_1_ERROR:  //ALARMFORM_STRINGLIST_ADD_08
				alarmStr = "[" +WideString(ALARMFORM_STRINGLIST_ADD_08)+"]";
				break;
			case CSV_ALARM_CODE_SENSOR_2_ERROR: //ALARMFORM_STRINGLIST_ADD_12
				alarmStr = "[" +WideString(ALARMFORM_STRINGLIST_ADD_12)+"]";
				break;
			case CSV_ALARM_CODE_BRIGHTNESS_DOWN:  //ALARMFORM_STRINGLIST_ADD_34
				alarmStr = "[" +WideString(ALARMFORM_STRINGLIST_ADD_34)+"]";
				break;
			case CSV_ALARM_CODE_STEPMOTOR_1_STALL:  //ALARMFORM_STRINGLIST_ADD_04
				alarmStr = "[" +WideString(ALARMFORM_STRINGLIST_ADD_04)+"]";
				break;
			case CSV_ALARM_CODE_STEPMOTOR_2_STALL:  //ALARMFORM_STRINGLIST_ADD_05
				alarmStr = "[" +WideString(ALARMFORM_STRINGLIST_ADD_05)+"]";
				break;
			case CSV_ALARM_CODE_STEPMOTOR_3_STALL:  //ALARMFORM_STRINGLIST_ADD_02
				alarmStr = "[" +WideString(ALARMFORM_STRINGLIST_ADD_02)+"]";
				break;
			case CSV_ALARM_CODE_STEPMOTOR_4_STALL:  //ALARMFORM_STRINGLIST_ADD_03
				alarmStr = "[" +WideString(ALARMFORM_STRINGLIST_ADD_03)+"]";
				break;
			case CSV_ALARM_CODE_STEPMOTOR_5_STALL:  //ALARMFORM_STRINGLIST_ADD_06
				alarmStr = "[" +WideString(ALARMFORM_STRINGLIST_ADD_06)+"]";
				break;
			case CSV_ALARM_CODE_BLACKOUT:  
				alarmStr = "[Machine Blackout]";
				break;
			case CSV_ALARM_CODE_TEMPERATURE_1_OVER:  //ALARMFORM_STRINGLIST_ADD_21
				wsprintfW(TempString, ALARMFORM_STRINGLIST_ADD_21, MachineSetupData.AlarmSetupInfo.TemperatureAlarmLevel1);
				alarmStr = "[" +WideString(TempString)+"]";
				break;
			case CSV_ALARM_CODE_TEMPERATURE_2_OVER:  //ALARMFORM_STRINGLIST_ADD_22
				wsprintfW(TempString, ALARMFORM_STRINGLIST_ADD_22, MachineSetupData.AlarmSetupInfo.TemperatureAlarmLevel2);
				alarmStr = "[" +WideString(TempString)+"]";
				break;
			case CSV_ALARM_CODE_TEMPERATURE_3_OVER:  //ALARMFORM_STRINGLIST_ADD_27
				wsprintfW(TempString, ALARMFORM_STRINGLIST_ADD_27, MachineSetupData.AlarmSetupInfo.TemperatureAlarmLevel3);
				alarmStr = "[" +WideString(TempString)+"]";
				break;
			case CSV_ALARM_CODE_MISEJECTOR_CHECK:  //ALARMFORM_STRINGLIST_ADD_48
				alarmStr = "[" +WideString(ALARMFORM_STRINGLIST_ADD_48)+"]";
				break;
			case CSV_ALARM_CODE_MISEJECTOR_FULL:  //ALARMFORM_STRINGLIST_ADD_37
				alarmStr = "[" +WideString(ALARMFORM_STRINGLIST_ADD_37)+"]";
				break;
			case CSV_ALARM_CODE_ACROCIA_MES_STATUS_ERROR :  //ALARMFORM_STRINGLIST_ADD_42
				alarmStr = "[" +WideString(ALARMFORM_STRINGLIST_ADD_42)+"]";
				break;
			case CSV_ALARM_CODE_ACROCIA_DLL_OBJECT_ERROR :  //ALARMFORM_STRINGLIST_ADD_43
				alarmStr = "[" +WideString(ALARMFORM_STRINGLIST_ADD_43)+"]";
				break;
			case CSV_ALARM_CODE_ACROCIA_UPSTREAM_STATUS_ERROR :  //ALARMFORM_STRINGLIST_ADD_44
				alarmStr = "[" +WideString(ALARMFORM_STRINGLIST_ADD_44)+"]";
				break;
			case CSV_ALARM_CODE_ACROCIA_DOWNSTREAM_STATUS_ERROR :  //ALARMFORM_STRINGLIST_ADD_45
				alarmStr = "[" +WideString(ALARMFORM_STRINGLIST_ADD_45)+"]";
				break;
			case CSV_ALARM_CODE_ACROCIA_LASER_EMERGENCY_ON :  //ALARMFORM_STRINGLIST_ADD_46
				alarmStr = "[" +WideString(ALARMFORM_STRINGLIST_ADD_46)+"]";
				break;
			case CSV_ALARM_CODE_EMISSIONSENSOR_ON :  //NEW_ADD_STRING_06
				alarmStr = "[" +WideString(NEW_ADD_STRING_06)+"]";
				break;

			default:
				alarmStr = CSVLOG_RETURNSTR_43;
				break;

			}
			wsprintfW(TempString, CSVLOG_RETURNSTR_15, alarmStr);
			returnStr = WideString(TempString); ////
			break;
		case ECSV_EVENT_ALARM_CLEAR:
			alarmCode = *(unsigned int *)Params;
			switch (alarmCode)
			{
			case CSV_ALARM_CODE_HCB_NC:  //ALARMFORM_STRINGLIST_ADD_16
				alarmStr = "[" +WideString(ALARMFORM_STRINGLIST_ADD_16)+"]";
				break;
			case CSV_ALARM_CODE_SPB_1_NC:  //ALARMFORM_STRINGLIST_ADD_01
				wsprintfW(TempString, ALARMFORM_STRINGLIST_ADD_01, 1);
				alarmStr = "[" +WideString(TempString)+"]";
				break;
			case CSV_ALARM_CODE_SPB_2_NC:  //ALARMFORM_STRINGLIST_ADD_01
				wsprintfW(TempString, ALARMFORM_STRINGLIST_ADD_01, 2);
				alarmStr = "[" +WideString(TempString)+"]";
				break;
			case CSV_ALARM_CODE_SPB_3_NC:  //ALARMFORM_STRINGLIST_ADD_01
				wsprintfW(TempString, ALARMFORM_STRINGLIST_ADD_01, 3);
				alarmStr = "[" +WideString(TempString)+"]";
				break;
			case CSV_ALARM_CODE_SPB_4_NC:  //ALARMFORM_STRINGLIST_ADD_01
				wsprintfW(TempString, ALARMFORM_STRINGLIST_ADD_01, 4);
				alarmStr = "[" +WideString(TempString)+"]";
				break;
			case CSV_ALARM_CODE_SPB_5_NC:  //ALARMFORM_STRINGLIST_ADD_01
				wsprintfW(TempString, ALARMFORM_STRINGLIST_ADD_01, 5);
				alarmStr = "[" +WideString(TempString)+"]";
				break;
			case CSV_ALARM_CODE_SPB_6_NC:  //ALARMFORM_STRINGLIST_ADD_01
				wsprintfW(TempString, ALARMFORM_STRINGLIST_ADD_01, 6);
				alarmStr = "[" +WideString(TempString)+"]";
				break;
			case CSV_ALARM_CODE_COMPRESSED_AIR:  //ALARMFORM_STRINGLIST_ADD_19
				alarmStr = "[" +WideString(ALARMFORM_STRINGLIST_ADD_19)+"]";
				break;
			case CSV_ALARM_CODE_EMERGENCY_ON:  //ALARMFORM_STRINGLIST_ADD_15
				alarmStr = "[" +WideString(ALARMFORM_STRINGLIST_ADD_15)+"]";
				break;
			case CSV_ALARM_CODE_INVERTER_1_TRIP:  //ALARMFORM_STRINGLIST_ADD_07
				alarmStr = "[" +WideString(ALARMFORM_STRINGLIST_ADD_07)+"]";
				break;
			case CSV_ALARM_CODE_INVERTER_2_TRIP:  //ALARMFORM_STRINGLIST_ADD_11
				alarmStr = "[" +WideString(ALARMFORM_STRINGLIST_ADD_11)+"]";
				break;
			case CSV_ALARM_CODE_INVERTER_3_TRIP:  //ALARMFORM_STRINGLIST_ADD_28
				alarmStr = "[" +WideString(ALARMFORM_STRINGLIST_ADD_28)+"]";
				break;
			case CSV_ALARM_CODE_RING_BLOWER_3_OL:  //ALARMFORM_STRINGLIST_ADD_19
				alarmStr = "[" +WideString(ALARMFORM_STRINGLIST_ADD_28)+"]";
				break;
			case CSV_ALARM_CODE_DISK_1_SUCTION_LOW:  //ALARMFORM_STRINGLIST_ADD_09
				alarmStr = "[" +WideString(ALARMFORM_STRINGLIST_ADD_09)+"]";
				break;
			case CSV_ALARM_CODE_DISK_2_SUCTION_LOW:  //ALARMFORM_STRINGLIST_ADD_13
				alarmStr = "[" +WideString(ALARMFORM_STRINGLIST_ADD_13)+"]";
				break;
			case CSV_ALARM_CODE_SERVO_ALARM:  //ALARMFORM_STRINGLIST_ADD_32
				alarmStr = "[" +WideString(ALARMFORM_STRINGLIST_ADD_32)+"]";
				break;
			case CSV_ALARM_CODE_INTERLOCK:  //ALARMFORM_STRINGLIST_ADD_20
				alarmStr = "[" +WideString(ALARMFORM_STRINGLIST_ADD_20)+"]";
				break;
			case CSV_ALARM_CODE_DISK_1_STALL:  //ALARMFORM_STRINGLIST_ADD_10
				alarmStr = "[" +WideString(ALARMFORM_STRINGLIST_ADD_10)+"]";
				break;
			case CSV_ALARM_CODE_DISK_2_STALL:  //ALARMFORM_STRINGLIST_ADD_14
				alarmStr = "[" +WideString(ALARMFORM_STRINGLIST_ADD_14)+"]";
				break;
			case CSV_ALARM_CODE_TOTAL_FULL:  //ALARMFORM_STRINGLIST_ADD_47
				alarmStr = "[" +WideString(ALARMFORM_STRINGLIST_ADD_47)+"]";
				break;
			case CSV_ALARM_CODE_GP_FULL:  //ALARMFORM_STRINGLIST_ADD_23
				alarmStr = "[" +WideString(ALARMFORM_STRINGLIST_ADD_23)+"]";
				break;
			case CSV_ALARM_CODE_DP_FULL:  //ALARMFORM_STRINGLIST_ADD_30
				alarmStr = "[" +WideString(ALARMFORM_STRINGLIST_ADD_30)+"]";
				break;
			case CSV_ALARM_CODE_UP_FULL:  //ALARMFORM_STRINGLIST_ADD_24
				alarmStr = "[" +WideString(ALARMFORM_STRINGLIST_ADD_24)+"]";
				break;
			case CSV_ALARM_CODE_DP_RATIO_OVER:  //ALARMFORM_STRINGLIST_ADD_29
				alarmStr = "[" +WideString(ALARMFORM_STRINGLIST_ADD_29)+"]";
				break;
			case CSV_ALARM_CODE_CRIT_DP_RATIO_OVER: //ALARMFORM_STRINGLIST_ADD_49
				alarmStr = "[" +WideString(ALARMFORM_STRINGLIST_ADD_49)+"]";
				break;
			case CSV_ALARM_CODE_UP_RATIO_OVER:  //ALARMFORM_STRINGLIST_ADD_25
				alarmStr = "[" +WideString(ALARMFORM_STRINGLIST_ADD_25)+"]";
				break;
			case CSV_ALARM_CODE_CRIT_UP_RATIO_OVER:  //ALARMFORM_STRINGLIST_ADD_50
				alarmStr = "[" +WideString(ALARMFORM_STRINGLIST_ADD_50)+"]";
				break;
			case CSV_ALARM_CODE_SENSOR_1_ERROR:  //ALARMFORM_STRINGLIST_ADD_08
				alarmStr = "[" +WideString(ALARMFORM_STRINGLIST_ADD_08)+"]";
				break;
			case CSV_ALARM_CODE_SENSOR_2_ERROR: //ALARMFORM_STRINGLIST_ADD_12
				alarmStr = "[" +WideString(ALARMFORM_STRINGLIST_ADD_12)+"]";
				break;
			case CSV_ALARM_CODE_BRIGHTNESS_DOWN:  //ALARMFORM_STRINGLIST_ADD_34
				alarmStr = "[" +WideString(ALARMFORM_STRINGLIST_ADD_34)+"]";
				break;
			case CSV_ALARM_CODE_STEPMOTOR_1_STALL:  //ALARMFORM_STRINGLIST_ADD_04
				alarmStr = "[" +WideString(ALARMFORM_STRINGLIST_ADD_04)+"]";
				break;
			case CSV_ALARM_CODE_STEPMOTOR_2_STALL:  //ALARMFORM_STRINGLIST_ADD_05
				alarmStr = "[" +WideString(ALARMFORM_STRINGLIST_ADD_05)+"]";
				break;
			case CSV_ALARM_CODE_STEPMOTOR_3_STALL:  //ALARMFORM_STRINGLIST_ADD_02
				alarmStr = "[" +WideString(ALARMFORM_STRINGLIST_ADD_02)+"]";
				break;
			case CSV_ALARM_CODE_STEPMOTOR_4_STALL:  //ALARMFORM_STRINGLIST_ADD_03
				alarmStr = "[" +WideString(ALARMFORM_STRINGLIST_ADD_03)+"]";
				break;
			case CSV_ALARM_CODE_STEPMOTOR_5_STALL:  //ALARMFORM_STRINGLIST_ADD_06
				alarmStr = "[" +WideString(ALARMFORM_STRINGLIST_ADD_06)+"]";
				break;
			case CSV_ALARM_CODE_BLACKOUT:  
				alarmStr = "[Machine Blackout]";
				break;
			case CSV_ALARM_CODE_TEMPERATURE_1_OVER:  //ALARMFORM_STRINGLIST_ADD_21
				wsprintfW(TempString, ALARMFORM_STRINGLIST_ADD_21, MachineSetupData.AlarmSetupInfo.TemperatureAlarmLevel1);
				alarmStr = "[" +WideString(TempString)+"]";
				break;
			case CSV_ALARM_CODE_TEMPERATURE_2_OVER:  //ALARMFORM_STRINGLIST_ADD_22
				wsprintfW(TempString, ALARMFORM_STRINGLIST_ADD_22, MachineSetupData.AlarmSetupInfo.TemperatureAlarmLevel2);
				alarmStr = "[" +WideString(TempString)+"]";
				break;
			case CSV_ALARM_CODE_TEMPERATURE_3_OVER:  //ALARMFORM_STRINGLIST_ADD_27
				wsprintfW(TempString, ALARMFORM_STRINGLIST_ADD_27, MachineSetupData.AlarmSetupInfo.TemperatureAlarmLevel3);
				alarmStr = "[" +WideString(TempString)+"]";
				break;
			case CSV_ALARM_CODE_MISEJECTOR_CHECK:  //ALARMFORM_STRINGLIST_ADD_48
				alarmStr = "[" +WideString(ALARMFORM_STRINGLIST_ADD_48)+"]";
				break;
			case CSV_ALARM_CODE_MISEJECTOR_FULL:  //ALARMFORM_STRINGLIST_ADD_37
				alarmStr = "[" +WideString(ALARMFORM_STRINGLIST_ADD_37)+"]";
				break;
			case CSV_ALARM_CODE_ACROCIA_MES_STATUS_ERROR :  //ALARMFORM_STRINGLIST_ADD_42
				alarmStr = "[" +WideString(ALARMFORM_STRINGLIST_ADD_42)+"]";
				break;
			case CSV_ALARM_CODE_ACROCIA_DLL_OBJECT_ERROR :  //ALARMFORM_STRINGLIST_ADD_43
				alarmStr = "[" +WideString(ALARMFORM_STRINGLIST_ADD_43)+"]";
				break;
			case CSV_ALARM_CODE_ACROCIA_UPSTREAM_STATUS_ERROR :  //ALARMFORM_STRINGLIST_ADD_44
				alarmStr = "[" +WideString(ALARMFORM_STRINGLIST_ADD_44)+"]";
				break;
			case CSV_ALARM_CODE_ACROCIA_DOWNSTREAM_STATUS_ERROR :  //ALARMFORM_STRINGLIST_ADD_45
				alarmStr = "[" +WideString(ALARMFORM_STRINGLIST_ADD_45)+"]";
				break;
			case CSV_ALARM_CODE_ACROCIA_LASER_EMERGENCY_ON :  //ALARMFORM_STRINGLIST_ADD_46
				alarmStr = "[" +WideString(ALARMFORM_STRINGLIST_ADD_46)+"]";
				break;
			case CSV_ALARM_CODE_EMISSIONSENSOR_ON :  //NEW_ADD_STRING_06
				alarmStr = "[" +WideString(NEW_ADD_STRING_06)+"]";
				break;
			default:
				alarmStr = CSVLOG_RETURNSTR_43;
				break;
			}

			wsprintfW(TempString, CSVLOG_RETURNSTR_16, alarmStr);
			returnStr = WideString(TempString); ////
			break;

			/*
					case ECSV_EVENT_LOGIN:
						returnStr = returnStr.sprintf("[%s] α", (char *)Params);
						break;
					case ECSV_EVENT_LOGOUT:
						returnStr = returnStr.sprintf("[%s] α׾ƿ", (char *)Params);
						break;
			*/
		default:
			returnStr = "UNKNOWN";
			break;
		}
	}
	else
	{
		switch (FEvent)
		{
		case ECSV_EVENT_APPLICATION_STARTED:
			returnStr = CSVLOG_RETURNSTR_145;
			break;
		case ECSV_EVENT_APPLICATION_TERMINATED:
			returnStr = CSVLOG_RETURNSTR_146;
			break;
		case ECSV_EVENT_APPLICATION_TIMECHANGEED:
			returnStr = CSVLOG_RETURNSTR_161;
			break;
		case ECSV_EVENT_MACHINE_SUSPEND:
			suspendReason = *(unsigned char *)Params;
			switch (suspendReason)
			{
			case MACHINE_SUSPEND_REASON_FEEDER_EMPTY:  //INSPECTIONFORM_MSG_10
				suspendStr = CSVLOG_RETURNSTR_22;
				break;
			case MACHINE_SUSPEND_REASON_FEEDER_TROUBLE:  //INSPECTIONFORM_MSG_10
				suspendStr = CSVLOG_RETURNSTR_80;
				break;
			case MACHINE_SUSPEND_REASON_DEFECT:  //INSPECTIONFORM_MSG_15
				suspendStr = CSVLOG_RETURNSTR_46;
				break;
			case MACHINE_SUSPEND_REASON_UNINSPECT:  //INSPECTIONFORM_MSG_13
				suspendStr = CSVLOG_RETURNSTR_39;
				break;
			case MACHINE_SUSPEND_REASON_TIMEOUT:  //INSPECTIONFORM_MSG_22
				suspendStr = CSVLOG_RETURNSTR_21;
				break;
			case MACHINE_SUSPEND_REASON_TABLET_DISAPPEAR:  //INSPECTIONFORM_MSG_21
				suspendStr = CSVLOG_RETURNSTR_64;
				break;
			case MACHINE_SUSPEND_REASON_REGULATOR:  //INSPECTIONFORM_MSG_08
				suspendStr = CSVLOG_RETURNSTR_23;
				break;
			case MACHINE_SUSPEND_REASON_BLOWER_OL:  //INSPECTIONFORM_MSG_01
				suspendStr = CSVLOG_RETURNSTR_20;
				break;
			case MACHINE_SUSPEND_REASON_VD1_STALL:  //INSPECTIONFORM_MSG_02
				suspendStr = CSVLOG_RETURNSTR_17;
				break;
			case MACHINE_SUSPEND_REASON_VD2_STALL:  //INSPECTIONFORM_MSG_03
				suspendStr = CSVLOG_RETURNSTR_18;
				break;
			case MACHINE_SUSPEND_REASON_GP_COUNT_REACHED:  //INSPECTIONFORM_MSG_11
				suspendStr = CSVLOG_RETURNSTR_37;
				break;
			case MACHINE_SUSPEND_REASON_BRIGHTNESS_DOWN:  //INSPECTIONFORM_MSG_20
				suspendStr = CSVLOG_RETURNSTR_44;
				break;
			case MACHINE_SUSPEND_REASON_DOOR_OPEN:  //INSPECTIONFORM_MSG_09
				suspendStr = CSVLOG_RETURNSTR_38;
				break;
			case MACHINE_SUSPEND_REASON_DP_COUNT_REACHED:  //INSPECTIONFORM_MSG_16
				suspendStr = CSVLOG_RETURNSTR_48;
				break;
			case MACHINE_SUSPEND_REASON_UP_COUNT_REACHED:  //INSPECTIONFORM_MSG_12
				suspendStr = CSVLOG_RETURNSTR_41;
				break;
			case MACHINE_SUSPEND_REASON_VISION_SENSOR_1:  //INSPECTIONFORM_MSG_19
				suspendStr = CSVLOG_RETURNSTR_70;
				break;
			case MACHINE_SUSPEND_REASON_VISION_SENSOR_2:  //INSPECTIONFORM_MSG_18
				suspendStr = CSVLOG_RETURNSTR_25;
				break;
			case MACHINE_SUSPEND_REASON_TIME_OVER:  //INSPECTIONFORM_MSG_18
				suspendStr = CSVLOG_RETURNSTR_79;
				break;
			default:
				suspendStr = CSVLOG_RETURNSTR_53;
				break;
			}
			wsprintfW(TempString, CSVLOG_RETURNSTR_01, suspendStr);
			returnStr = WideString(TempString);   ////
			break;
		case ECSV_EVENT_ALARM:
			alarmCode = *(unsigned int *)Params;
			switch (alarmCode)
			{
			case CSV_ALARM_CODE_HCB_NC:  //ALARMFORM_STRINGLIST_ADD_16
				alarmStr = CSVLOG_RETURNSTR_19;
				break;
			case CSV_ALARM_CODE_SPB_1_NC:  //ALARMFORM_STRINGLIST_ADD_01
				alarmStr = CSVLOG_RETURNSTR_04;
				break;
			case CSV_ALARM_CODE_SPB_2_NC:  //ALARMFORM_STRINGLIST_ADD_01
				alarmStr = CSVLOG_RETURNSTR_06;
				break;
			case CSV_ALARM_CODE_SPB_3_NC:  //ALARMFORM_STRINGLIST_ADD_01
				alarmStr = CSVLOG_RETURNSTR_12;
				break;
			case CSV_ALARM_CODE_SPB_4_NC:  //ALARMFORM_STRINGLIST_ADD_01
				alarmStr = CSVLOG_RETURNSTR_14;
				break;
			case CSV_ALARM_CODE_SPB_5_NC:  //ALARMFORM_STRINGLIST_ADD_01
				alarmStr = CSVLOG_RETURNSTR_159;
				break;
			case CSV_ALARM_CODE_SPB_6_NC:  //ALARMFORM_STRINGLIST_ADD_01
				alarmStr = CSVLOG_RETURNSTR_160;
				break;
			case CSV_ALARM_CODE_COMPRESSED_AIR:  //ALARMFORM_STRINGLIST_ADD_19
				alarmStr = CSVLOG_RETURNSTR_23;
				break;
			case CSV_ALARM_CODE_EMERGENCY_ON:  //ALARMFORM_STRINGLIST_ADD_15
				alarmStr = CSVLOG_RETURNSTR_50;
				break;
			case CSV_ALARM_CODE_INVERTER_1_TRIP:  //ALARMFORM_STRINGLIST_ADD_07
				alarmStr = CSVLOG_RETURNSTR_05;
				break;
			case CSV_ALARM_CODE_INVERTER_2_TRIP:  //ALARMFORM_STRINGLIST_ADD_11
				alarmStr = CSVLOG_RETURNSTR_07;
				break;
			case CSV_ALARM_CODE_INVERTER_3_TRIP:  //ALARMFORM_STRINGLIST_ADD_28
				alarmStr = CSVLOG_RETURNSTR_156;
				break;
			case CSV_ALARM_CODE_RING_BLOWER_3_OL:  //ALARMFORM_STRINGLIST_ADD_19
				alarmStr = CSVLOG_RETURNSTR_13;
				break;
			case CSV_ALARM_CODE_DISK_1_SUCTION_LOW:  //ALARMFORM_STRINGLIST_ADD_09
				alarmStr = CSVLOG_RETURNSTR_60;
				break;
			case CSV_ALARM_CODE_DISK_2_SUCTION_LOW:  //ALARMFORM_STRINGLIST_ADD_13
				alarmStr = CSVLOG_RETURNSTR_57;
				break;
			case CSV_ALARM_CODE_SERVO_ALARM:  //ALARMFORM_STRINGLIST_ADD_32
				alarmStr = CSVLOG_RETURNSTR_51;
				break;
			case CSV_ALARM_CODE_INTERLOCK:  //ALARMFORM_STRINGLIST_ADD_20
				alarmStr = CSVLOG_RETURNSTR_63;
				break;
			case CSV_ALARM_CODE_DISK_1_STALL:  //ALARMFORM_STRINGLIST_ADD_10
				alarmStr = CSVLOG_RETURNSTR_58;
				break;
			case CSV_ALARM_CODE_DISK_2_STALL:  //ALARMFORM_STRINGLIST_ADD_14
				alarmStr = CSVLOG_RETURNSTR_55;
				break;
			case CSV_ALARM_CODE_TOTAL_FULL:  //ALARMFORM_STRINGLIST_ADD_47
				alarmStr = CSVLOG_RETURNSTR_167;
				break;
			case CSV_ALARM_CODE_GP_FULL:  //ALARMFORM_STRINGLIST_ADD_23
				alarmStr = CSVLOG_RETURNSTR_54;
				break;
			case CSV_ALARM_CODE_DP_FULL:  //ALARMFORM_STRINGLIST_ADD_30
				alarmStr = CSVLOG_RETURNSTR_49;
				break;
			case CSV_ALARM_CODE_UP_FULL:  //ALARMFORM_STRINGLIST_ADD_24
				alarmStr = CSVLOG_RETURNSTR_42;
				break;
			case CSV_ALARM_CODE_DP_RATIO_OVER:  //ALARMFORM_STRINGLIST_ADD_29
				alarmStr = CSVLOG_RETURNSTR_47;
				break;
			case CSV_ALARM_CODE_CRIT_DP_RATIO_OVER: //ALARMFORM_STRINGLIST_ADD_49
				alarmStr = CSVLOG_RETURNSTR_158;
				break;
			case CSV_ALARM_CODE_UP_RATIO_OVER:  //ALARMFORM_STRINGLIST_ADD_25
				alarmStr = CSVLOG_RETURNSTR_40;
				break;
			case CSV_ALARM_CODE_CRIT_UP_RATIO_OVER:  //ALARMFORM_STRINGLIST_ADD_50
				alarmStr = CSVLOG_RETURNSTR_52;
				break;
			case CSV_ALARM_CODE_SENSOR_1_ERROR:  //ALARMFORM_STRINGLIST_ADD_08
				alarmStr = CSVLOG_RETURNSTR_59;
				break;
			case CSV_ALARM_CODE_SENSOR_2_ERROR: //ALARMFORM_STRINGLIST_ADD_12
				alarmStr = CSVLOG_RETURNSTR_56;
				break;
			case CSV_ALARM_CODE_BRIGHTNESS_DOWN:  //ALARMFORM_STRINGLIST_ADD_34
				alarmStr = CSVLOG_RETURNSTR_44;
				break;
			case CSV_ALARM_CODE_STEPMOTOR_1_STALL:  //ALARMFORM_STRINGLIST_ADD_04
				alarmStr = CSVLOG_RETURNSTR_151;
				break;
			case CSV_ALARM_CODE_STEPMOTOR_2_STALL:  //ALARMFORM_STRINGLIST_ADD_05
				alarmStr = CSVLOG_RETURNSTR_152;
				break;
			case CSV_ALARM_CODE_STEPMOTOR_3_STALL:  //ALARMFORM_STRINGLIST_ADD_02
				alarmStr = CSVLOG_RETURNSTR_153;
				break;
			case CSV_ALARM_CODE_STEPMOTOR_4_STALL:  //ALARMFORM_STRINGLIST_ADD_03
				alarmStr = CSVLOG_RETURNSTR_154;
				break;
			case CSV_ALARM_CODE_STEPMOTOR_5_STALL:  //ALARMFORM_STRINGLIST_ADD_06
				alarmStr = CSVLOG_RETURNSTR_155;
				break;
			case CSV_ALARM_CODE_BLACKOUT:  
				alarmStr = "Machine Blackout";
				break;
			case CSV_ALARM_CODE_TEMPERATURE_1_OVER:  //ALARMFORM_STRINGLIST_ADD_21
				alarmStr = CSVLOG_RETURNSTR_162;
				break;
			case CSV_ALARM_CODE_TEMPERATURE_2_OVER:  //ALARMFORM_STRINGLIST_ADD_22
				alarmStr = CSVLOG_RETURNSTR_163;
				break;
			case CSV_ALARM_CODE_TEMPERATURE_3_OVER:  //ALARMFORM_STRINGLIST_ADD_27
				alarmStr = CSVLOG_RETURNSTR_164;
				break;
			case CSV_ALARM_CODE_MISEJECTOR_CHECK:  //ALARMFORM_STRINGLIST_ADD_48
				alarmStr = CSVLOG_RETURNSTR_166;
				break;
			case CSV_ALARM_CODE_MISEJECTOR_FULL:  //ALARMFORM_STRINGLIST_ADD_37
				alarmStr = CSVLOG_RETURNSTR_165;
				break;
			case CSV_ALARM_CODE_ACROCIA_MES_STATUS_ERROR :  //ALARMFORM_STRINGLIST_ADD_42
				alarmStr = CSVLOG_RETURNSTR_168;
				break;
			case CSV_ALARM_CODE_ACROCIA_DLL_OBJECT_ERROR :  //ALARMFORM_STRINGLIST_ADD_43
				alarmStr = CSVLOG_RETURNSTR_169;
				break;
			case CSV_ALARM_CODE_ACROCIA_UPSTREAM_STATUS_ERROR :  //ALARMFORM_STRINGLIST_ADD_44
				alarmStr = CSVLOG_RETURNSTR_170;
				break;
			case CSV_ALARM_CODE_ACROCIA_DOWNSTREAM_STATUS_ERROR :  //ALARMFORM_STRINGLIST_ADD_45
				alarmStr = CSVLOG_RETURNSTR_171;
				break;
			case CSV_ALARM_CODE_ACROCIA_LASER_EMERGENCY_ON :  //ALARMFORM_STRINGLIST_ADD_46
				alarmStr = CSVLOG_RETURNSTR_172;
				break;
			case CSV_ALARM_CODE_EMISSIONSENSOR_ON :  //NEW_ADD_STRING_06
				alarmStr = CSVLOG_RETURNSTR_173;
				break;

			default:
				alarmStr = CSVLOG_RETURNSTR_43;
				break;

			}
			wsprintfW(TempString, CSVLOG_RETURNSTR_15, alarmStr);
			returnStr = WideString(TempString); ////
			break;
		case ECSV_EVENT_ALARM_CLEAR:
			alarmCode = *(unsigned int *)Params;
			switch (alarmCode)
			{
			case CSV_ALARM_CODE_HCB_NC:
				alarmStr = CSVLOG_RETURNSTR_19;
				break;
			case CSV_ALARM_CODE_SPB_1_NC:
				alarmStr = CSVLOG_RETURNSTR_04;
				break;
			case CSV_ALARM_CODE_SPB_2_NC:
				alarmStr = CSVLOG_RETURNSTR_06;
				break;
			case CSV_ALARM_CODE_SPB_3_NC:
				alarmStr = CSVLOG_RETURNSTR_12;
				break;
			case CSV_ALARM_CODE_SPB_4_NC:
				alarmStr = CSVLOG_RETURNSTR_14;
				break;
			case CSV_ALARM_CODE_SPB_5_NC:
				alarmStr = CSVLOG_RETURNSTR_159;
				break;
			case CSV_ALARM_CODE_SPB_6_NC:
				alarmStr = CSVLOG_RETURNSTR_160;
				break;
			case CSV_ALARM_CODE_COMPRESSED_AIR:
				alarmStr = CSVLOG_RETURNSTR_23;
				break;
			case CSV_ALARM_CODE_EMERGENCY_ON:
				alarmStr = CSVLOG_RETURNSTR_50;
				break;
			case CSV_ALARM_CODE_INVERTER_1_TRIP:
				alarmStr = CSVLOG_RETURNSTR_05;
				break;
			case CSV_ALARM_CODE_INVERTER_2_TRIP:
				alarmStr = CSVLOG_RETURNSTR_07;
				break;
			case CSV_ALARM_CODE_INVERTER_3_TRIP:
				alarmStr = CSVLOG_RETURNSTR_156;
				break;
			case CSV_ALARM_CODE_RING_BLOWER_3_OL:
				alarmStr = CSVLOG_RETURNSTR_13;
				break;
			case CSV_ALARM_CODE_DISK_1_SUCTION_LOW:
				alarmStr = CSVLOG_RETURNSTR_60;
				break;
			case CSV_ALARM_CODE_DISK_2_SUCTION_LOW:
				alarmStr = CSVLOG_RETURNSTR_57;
				break;
			case CSV_ALARM_CODE_SERVO_ALARM:
				alarmStr = CSVLOG_RETURNSTR_51;
				break;
			case CSV_ALARM_CODE_INTERLOCK:
				alarmStr = CSVLOG_RETURNSTR_63;
				break;
			case CSV_ALARM_CODE_DISK_1_STALL:
				alarmStr = CSVLOG_RETURNSTR_58;
				break;
			case CSV_ALARM_CODE_DISK_2_STALL:
				alarmStr = CSVLOG_RETURNSTR_55;
				break;
			case CSV_ALARM_CODE_TOTAL_FULL:
				alarmStr = CSVLOG_RETURNSTR_167;
				break;
			case CSV_ALARM_CODE_GP_FULL:
				alarmStr = CSVLOG_RETURNSTR_54;
				break;
			case CSV_ALARM_CODE_DP_FULL:
				alarmStr = CSVLOG_RETURNSTR_49;
				break;
			case CSV_ALARM_CODE_UP_FULL:
				alarmStr = CSVLOG_RETURNSTR_42;
				break;
			case CSV_ALARM_CODE_DP_RATIO_OVER:
				alarmStr = CSVLOG_RETURNSTR_47;
				break;
			case CSV_ALARM_CODE_UP_RATIO_OVER:
				alarmStr = CSVLOG_RETURNSTR_40;
				break;
			case CSV_ALARM_CODE_CRIT_DP_RATIO_OVER:
				alarmStr = CSVLOG_RETURNSTR_158;
				break;
			case CSV_ALARM_CODE_CRIT_UP_RATIO_OVER:
				alarmStr = CSVLOG_RETURNSTR_52;
				break;
			case CSV_ALARM_CODE_SENSOR_1_ERROR:
				alarmStr = CSVLOG_RETURNSTR_59;
				break;
			case CSV_ALARM_CODE_SENSOR_2_ERROR:
				alarmStr = CSVLOG_RETURNSTR_56;
				break;
			case CSV_ALARM_CODE_BRIGHTNESS_DOWN:
				alarmStr = CSVLOG_RETURNSTR_44;
				break;
			case CSV_ALARM_CODE_STEPMOTOR_1_STALL:
				alarmStr = CSVLOG_RETURNSTR_151;
				break;
			case CSV_ALARM_CODE_STEPMOTOR_2_STALL:
				alarmStr = CSVLOG_RETURNSTR_152;
				break;
			case CSV_ALARM_CODE_STEPMOTOR_3_STALL:
				alarmStr = CSVLOG_RETURNSTR_153;
				break;
			case CSV_ALARM_CODE_STEPMOTOR_4_STALL:
				alarmStr = CSVLOG_RETURNSTR_154;
				break;
			case CSV_ALARM_CODE_STEPMOTOR_5_STALL:
				alarmStr = CSVLOG_RETURNSTR_155;
				break;
			case CSV_ALARM_CODE_BLACKOUT:
				alarmStr = "Machine Blackout";
				break;
			case CSV_ALARM_CODE_TEMPERATURE_1_OVER:
				alarmStr = CSVLOG_RETURNSTR_162;
				break;
			case CSV_ALARM_CODE_TEMPERATURE_2_OVER:
				alarmStr = CSVLOG_RETURNSTR_163;
				break;
			case CSV_ALARM_CODE_TEMPERATURE_3_OVER:
				alarmStr = CSVLOG_RETURNSTR_164;
				break;
			case CSV_ALARM_CODE_MISEJECTOR_CHECK:
				alarmStr = CSVLOG_RETURNSTR_166;
				break;
			case CSV_ALARM_CODE_MISEJECTOR_FULL:
				alarmStr = CSVLOG_RETURNSTR_165;
				break;

			case CSV_ALARM_CODE_ACROCIA_MES_STATUS_ERROR :
				alarmStr = CSVLOG_RETURNSTR_168;
				break;
			case CSV_ALARM_CODE_ACROCIA_DLL_OBJECT_ERROR :
				alarmStr = CSVLOG_RETURNSTR_169;
				break;
			case CSV_ALARM_CODE_ACROCIA_UPSTREAM_STATUS_ERROR :
				alarmStr = CSVLOG_RETURNSTR_170;
				break;
			case CSV_ALARM_CODE_ACROCIA_DOWNSTREAM_STATUS_ERROR :
				alarmStr = CSVLOG_RETURNSTR_171;
				break;
			case CSV_ALARM_CODE_ACROCIA_LASER_EMERGENCY_ON :
				alarmStr = CSVLOG_RETURNSTR_172;
				break;
			case CSV_ALARM_CODE_EMISSIONSENSOR_ON :
				alarmStr = CSVLOG_RETURNSTR_173;
				break;
			default:
				alarmStr = CSVLOG_RETURNSTR_43;
				break;
			}

			wsprintfW(TempString, CSVLOG_RETURNSTR_16, alarmStr);
			returnStr = WideString(TempString); ////
			break;

			/*
					case ECSV_EVENT_LOGIN:
						returnStr = returnStr.sprintf("[%s] α", (char *)Params);
						break;
					case ECSV_EVENT_LOGOUT:
						returnStr = returnStr.sprintf("[%s] α׾ƿ", (char *)Params);
						break;
			*/
		default:
			returnStr = "UNKNOWN";
			break;
		}	
	}
	return returnStr;
}
//---------------------------------------------------------------------------
int __fastcall TCSVEventLog::GetEventKind(void)
{
	return FEvent;
}
//---------------------------------------------------------------------------
void __fastcall TCSVEventLog::SetKind(ECSVLogKind kind)
{
	FKind = kind;
}
//---------------------------------------------------------------------------
void __fastcall TCSVEventLog::SetTime(double time)
{
	FTime = time;
}
//---------------------------------------------------------------------------
void __fastcall TCSVEventLog::SetFileName(AnsiString filename)
{
	FFromFileName = filename;
}
//---------------------------------------------------------------------------
//	TCSVActionLog class
//---------------------------------------------------------------------------
__fastcall TCSVActionLog::TCSVActionLog()
{
	FAction = ECSV_ACTION_NONE;
	Params = NULL;
	ParamSize = 0;
}
//---------------------------------------------------------------------------
__fastcall TCSVActionLog::TCSVActionLog(ECSVAction action)
{
	FAction = action;
	Params = NULL;
	ParamSize = 0;
}
//---------------------------------------------------------------------------
__fastcall TCSVActionLog::~TCSVActionLog()
{
	if (Params)
		delete[] Params;
}
//---------------------------------------------------------------------------
void __fastcall TCSVActionLog::SetParams(char *userName, char *productName, unsigned char *params, int paramSize)
{
	strncpy(UserName, userName, 32);
	strncpy(ProductName, productName, 64);
	if (Params)
	{
		delete[] Params;
		Params = NULL;
	}
	if (paramSize > 0)
	{
		Params = new unsigned char[paramSize];
		memcpy(Params, params, paramSize);
	}
	ParamSize = paramSize;
}
//---------------------------------------------------------------------------
bool __fastcall TCSVActionLog::SaveToFileStream(TFileStream *fileStream)
{
	bool returnValue = true;
	TCSVLogUnitHeader csvLogUnitHeader;
	TActionLogHeader actionLogHeader;
	try
	{
		unsigned int dataSize = sizeof(actionLogHeader) + ParamSize;
		csvLogUnitHeader.Version = CSV_UNIT_HEADER_CURRENT_VERSION;
		csvLogUnitHeader.Size = sizeof(TCSVLogUnitHeader) + dataSize;
		csvLogUnitHeader.Kind = ECSV_LOG_KIND_ACTION;
		csvLogUnitHeader.Time = Now().Val;
		if (fileStream->Write(&csvLogUnitHeader, sizeof(TCSVLogUnitHeader)) != sizeof(TCSVLogUnitHeader))
		{
			throw CSVLogException(ECSV_FILE_CANNOT_WRITE);
		}
		actionLogHeader.Version = CSV_ACTION_LOG_CURRENT_VERSION;
		actionLogHeader.Action = FAction;
		memcpy(actionLogHeader.UserName, this->UserName, 32);
		memcpy(actionLogHeader.ProcuctName, this->ProductName, 64);
		actionLogHeader.ParamSize = this->ParamSize;

		if (fileStream->Write(&actionLogHeader, sizeof(actionLogHeader)) != sizeof(actionLogHeader))
		{
			throw CSVLogException(ECSV_FILE_CANNOT_WRITE);
		}
		if (fileStream->Write(Params, ParamSize) != ParamSize)
		{
			throw CSVLogException(ECSV_FILE_CANNOT_WRITE);
		}
	}
	catch (CSVLogException &ec)
	{
		returnValue = false;
	}
	return returnValue;
}
//---------------------------------------------------------------------------
bool __fastcall TCSVActionLog::LoadFromFileStream(TFileStream *fileStream)
{
	bool returnValue = true;
	TCSVLogUnitHeader csvLogUnitHeader;
	TActionLogHeader actionLogHeader;

	int actionLogHeaderSize = 0;
	int startPosition = fileStream->Position;
	try
	{

		actionLogHeaderSize = fileStream->Read(&actionLogHeader, sizeof(actionLogHeader));

		if (actionLogHeader.Version == 100)
		{
			TActionLogHeader_Ver100 actionLogHeader_ver100;
			fileStream->Position = startPosition;
			memset(&actionLogHeader_ver100, 0, sizeof(actionLogHeader_ver100));

			actionLogHeaderSize = fileStream->Read(&actionLogHeader_ver100, sizeof(actionLogHeader_ver100));
			if (actionLogHeaderSize != sizeof(actionLogHeader_ver100))
			{
				throw CSVLogException(ECSV_FILE_CANNOT_READ);
			}

			FAction = actionLogHeader_ver100.Action;
			if (actionLogHeader_ver100.ParamSize < 0)
			{
				throw CSVLogException(ECSV_FILE_CANNOT_READ);
			}

			if (Params)
			{
				delete[] Params;
				Params = NULL;
			}
			if (actionLogHeader_ver100.ParamSize > 0)
			{
				Params = new unsigned char[actionLogHeader_ver100.ParamSize];
				if (actionLogHeader_ver100.Version == 100)
				{
					if (fileStream->Read(Params, actionLogHeader_ver100.ParamSize) != actionLogHeader_ver100.ParamSize)
					{
						throw CSVLogException(ECSV_FILE_CANNOT_READ);
					}
				}
			}
			memcpy(this->UserName, actionLogHeader_ver100.UserName, 32);
			memcpy(this->ProductName, actionLogHeader_ver100.ProcuctName, 32);
		}
		else if (actionLogHeader.Version == CSV_ACTION_LOG_CURRENT_VERSION)
		{
			if (actionLogHeaderSize != sizeof(actionLogHeader))
			{
				throw CSVLogException(ECSV_FILE_CANNOT_READ);
			}
			//if (actionLogHeader.Version == CSV_ACTION_LOG_CURRENT_VERSION)
			{
				FAction = actionLogHeader.Action;
				if (actionLogHeader.ParamSize < 0)
				{
					throw CSVLogException(ECSV_FILE_CANNOT_READ);
				}

				if (Params)
				{
					delete[] Params;
					Params = NULL;
				}
				if (actionLogHeader.ParamSize > 0)
				{
					Params = new unsigned char[actionLogHeader.ParamSize];
					if (actionLogHeader.Version == CSV_ACTION_LOG_CURRENT_VERSION)
					{
						if (fileStream->Read(Params, actionLogHeader.ParamSize) != actionLogHeader.ParamSize)
						{
							throw CSVLogException(ECSV_FILE_CANNOT_READ);
						}
					}
				}
				memcpy(this->UserName, actionLogHeader.UserName, 32);
				memcpy(this->ProductName, actionLogHeader.ProcuctName, 64);
			}
		}
		else
		{
			throw CSVLogException(ECSV_FILE_CANNOT_READ);
		}
	}
	catch (CSVLogException &ec)
	{
		returnValue = false;
	}
	return returnValue;
}
//---------------------------------------------------------------------------
WideString __fastcall TCSVActionLog::GetCreatorName(void)
{
	return WideString(UserName);
}
//---------------------------------------------------------------------------
WideString __fastcall TCSVActionLog::GetProductName(void)
{
	return WideString(ProductName);
}
//---------------------------------------------------------------------------
WideString __fastcall TCSVActionLog::GetMessage(void)
{
	WideString returnStr = "";
	TCSVRenameActionLogData *csvRenameActionLogData;
	TCSVInspectionStartActionLogData *csvInspectionStartActionLogData;

	WideString Word ;
	WideString O_DATA;
	WideString DATA;
	int Status = 0;

	WCHAR TempString[1000];
	switch (FAction)
	{
	case ECSV_ACTION_USER_ADD:
		wsprintfW(TempString, CSVLOG_RETURNSTR_134, WideString((char *)Params));
		returnStr = WideString(TempString);
		break;
	case ECSV_ACTION_USER_DELETE:
		wsprintfW(TempString, CSVLOG_RETURNSTR_136, WideString((char *)Params));
		returnStr = WideString(TempString);
		break;
	case ECSV_ACTION_USER_PASSWORD_CHANGE:
		wsprintfW(TempString, CSVLOG_RETURNSTR_135, WideString(UserName));
		returnStr = WideString(TempString);
		break;
	case ECSV_ACTION_LOGIN:
		wsprintfW(TempString, CSVLOG_RETURNSTR_03, WideString(UserName));
		returnStr = WideString(TempString);
		break;
	case ECSV_ACTION_LOGOUT:
		wsprintfW(TempString, CSVLOG_RETURNSTR_02, WideString(UserName));
		returnStr = WideString(TempString);
		break;
	case ECSV_ACTION_WRONG_PASSWORD:
		wsprintfW(TempString, CSVLOG_RETURNSTR_137, *(int *)Params);
		returnStr = WideString(TempString);
		break;
	case ECSV_ACTION_UNPERMITTED_USER:
		wsprintfW(TempString, CSVLOG_RETURNSTR_149, WideString(UserName));
		returnStr = WideString(TempString);
		break;
	case ECSV_ACTION_PRODUCT_ADD:
		wsprintfW(TempString, CSVLOG_RETURNSTR_123, WideString(ProductName));
		returnStr = WideString(TempString);
		break;
	case ECSV_ACTION_PRODUCT_EDIT:
		wsprintfW(TempString, CSVLOG_RETURNSTR_157, WideString(ProductName));
		returnStr = WideString(TempString);
		break;
	case ECSV_ACTION_PRODUCT_RENAME:
		csvRenameActionLogData = (TCSVRenameActionLogData *) Params;
		wsprintfW(TempString, CSVLOG_RETURNSTR_141, WideString((char *)csvRenameActionLogData->OldName), WideString((char *)csvRenameActionLogData->NewName));
		returnStr = WideString(TempString);
		break;
	case ECSV_ACTION_PRODUCT_CLONE:
		csvRenameActionLogData = (TCSVRenameActionLogData *) Params;
		wsprintfW(TempString, CSVLOG_RETURNSTR_124, WideString((char *)csvRenameActionLogData->NewName), WideString((char *)csvRenameActionLogData->OldName));
		returnStr = WideString(TempString);
		break;
	case ECSV_ACTION_PRODUCT_DELETE:
		wsprintfW(TempString, CSVLOG_RETURNSTR_140, WideString(ProductName));
		returnStr = WideString(TempString);
		break;
	case ECSV_ACTION_PRODUCT_SELECTION:
		wsprintfW(TempString, CSVLOG_RETURNSTR_139, WideString(ProductName));
		returnStr = WideString(TempString);
		break;
	case ECSV_ACTION_IMAGE_CAPTURE_START:
		wsprintfW(TempString, CSVLOG_RETURNSTR_131);
		returnStr = WideString(TempString);
		break;
	case ECSV_ACTION_IMAGE_CAPTURE_STOP:
		wsprintfW(TempString, CSVLOG_RETURNSTR_133, *((int *)Params) + *((int *)Params + 1));
		returnStr = WideString(TempString);
		break;
	case ECSV_ACTION_IMAGE_CAPTURE_COMPLETE:
		wsprintfW(TempString, CSVLOG_RETURNSTR_132);
		returnStr = WideString(TempString);
		break;
	case ECSV_ACTION_TABLET_CHARACTER_EXTRACT:
		wsprintfW(TempString, CSVLOG_RETURNSTR_144);
		returnStr = WideString(TempString);
		break;
	case ECSV_ACTION_TABLET_CHARACTER_EXTRACT_END:
		wsprintfW(TempString, NEW_ADD_STRING_30);
		returnStr = WideString(TempString);
		break;
	case ECSV_ACTION_FIRST_STUDY:
		wsprintfW(TempString, NEW_ADD_STRING_31);
		returnStr = WideString(TempString);
		break;
	case ECSV_ACTION_STUDY_START:
		wsprintfW(TempString, NEW_ADD_STRING_32);
		returnStr = WideString(TempString);
		break;
	case ECSV_ACTION_SECOND_STUDY:
		wsprintfW(TempString, CSVLOG_RETURNSTR_91);
		returnStr = WideString(TempString);

		break;
	case ECSV_ACTION_INSPECTION_START:
		csvInspectionStartActionLogData = (TCSVInspectionStartActionLogData *) Params;
		if (MachineSetupData.CompanyID == INTERNATIONAL_MACHINE2)
		{
			Word = "Start Inspection (Batch Name -%s)";
			wsprintfW(TempString, Word, WideString(csvInspectionStartActionLogData->LotName));
		}
		else
			wsprintfW(TempString, CSVLOG_RETURNSTR_106, WideString(csvInspectionStartActionLogData->LotName));

		returnStr = WideString(TempString);
		break;
	case ECSV_ACTION_INSPECTION_PAUSE:
		wsprintfW(TempString, CSVLOG_RETURNSTR_108, *((int *)Params + 1), *((int *)Params + 2), *((int *)Params + 3), *((int *)Params + 1) + *((int *)Params + 2) + *((int *)Params + 3));
		returnStr = WideString(TempString);
		break;
	case ECSV_ACTION_INSPECTION_RESTART:

		if (MachineSetupData.CompanyID == INTERNATIONAL_MACHINE2)
		{
			Word = "Restart Inspection (Batch Name -%s)";
			wsprintfW(TempString, Word, WideString((char *)Params));
		}
		else
			wsprintfW(TempString, CSVLOG_RETURNSTR_107, WideString((char *)Params)); //(char *)Params);

		returnStr = WideString(TempString);
		break;
	case ECSV_ACTION_INSPECTION_BATCH_END:

		if (MachineSetupData.CompanyID == INTERNATIONAL_MACHINE2)
		{
			Word = "Batch End (Batch Name -%s)";
			wsprintfW(TempString, Word, WideString((char *)Params));
		}


		returnStr = WideString(TempString);
		break;
	case ECSV_ACTION_GRADE_CHANGE:
		wsprintfW(TempString, CSVLOG_RETURNSTR_113);
		returnStr = WideString(TempString);
		break;
	case ECSV_ACTION_CHANGE_MACHINE_SETTING:
		wsprintfW(TempString, CSVLOG_RETURNSTR_112);
		returnStr = WideString(TempString);
		break;
	case ECSV_ACTION_EXPIRATION_LOCK_USER:
		if (DefaultLCID == 1042 || DefaultLCID == 2066)
		{
			Word = "[α ] ID  () Ǵ Ȱȭ Ǿϴ.";
		}
		else
		{
			Word = "[Login Fail]Operator ID Expiration(Lock) or Deactive";
		}
		wsprintfW(TempString, Word, WideString((char *)Params));
		returnStr = WideString(TempString);
		break;
	case ECSV_ACTION_CHANGE_ACTIVE:
		O_DATA = WideString((char *)Params);
		DATA = O_DATA.SubString(0, O_DATA.Length() - 1);		
		wsprintfW(TempString, CSVLOG_RETURNSTR_177, WideString(DATA));
		returnStr = WideString(TempString);
		break;
	case ECSV_ACTION_CHANGE_DEACTIVE:
		O_DATA = WideString((char *)Params);
		DATA = O_DATA.SubString(0, O_DATA.Length() - 1);
		wsprintfW(TempString, CSVLOG_RETURNSTR_178, WideString(DATA));
		returnStr = WideString(TempString);
		break;
	case ECSV_ACTION_UNLOCK:
		O_DATA = WideString((char *)Params);
		wsprintfW(TempString, CSVLOG_RETURNSTR_179, WideString(O_DATA));
		returnStr = WideString(TempString);
		break;
	default:
		wsprintfW(TempString, CSVLOG_RETURNSTR_138);
		returnStr = WideString(TempString);
		break;
	}
	return returnStr;
}
//---------------------------------------------------------------------------

void __fastcall TCSVActionLog::GetDetailInfo(TTntStrings *strings)
{
	TCSVGradeChangeActionLogData *csvGradeChangeActionLogData;
	TCSVInspectionStartActionLogData *csvInspectionStartActionLogData;
	TCSVMachineSettingChangeData *csvMachineSettingChangeData;
	WideString oldTabletSizeStr, newTabletSizeStr;
	int changeIndex;
	int cameraMap;
	WideString Word;
	WideString gradeNameList[50];

	gradeNameList[0] = CSVLOG_RETURNSTR_97;
	gradeNameList[1] = CSVLOG_RETURNSTR_08;
	gradeNameList[2] = CSVLOG_RETURNSTR_85;
	gradeNameList[3] = CSVLOG_RETURNSTR_86;
	gradeNameList[4] = CSVLOG_RETURNSTR_81;
	gradeNameList[5] = CSVLOG_RETURNSTR_82;
	gradeNameList[6] = CSVLOG_RETURNSTR_66;
	gradeNameList[7] = CSVLOG_RETURNSTR_67;
	gradeNameList[8] = CSVLOG_RETURNSTR_68;
	gradeNameList[9] = CSVLOG_RETURNSTR_69;
	gradeNameList[10] = CSVLOG_RETURNSTR_78;
	gradeNameList[11] = "frontShapeEdgeNeighborRange";
	gradeNameList[12] = CSVLOG_RETURNSTR_143;
	gradeNameList[13] = "frontSmallSizeGrade";
	gradeNameList[14] = CSVLOG_RETURNSTR_10;
	gradeNameList[15] = CSVLOG_RETURNSTR_99;
	gradeNameList[16] = CSVLOG_RETURNSTR_11;
	gradeNameList[17] = CSVLOG_RETURNSTR_76;
	gradeNameList[18] = CSVLOG_RETURNSTR_77;
	gradeNameList[19] = CSVLOG_RETURNSTR_74;
	gradeNameList[20] = CSVLOG_RETURNSTR_75;
	gradeNameList[21] = CSVLOG_RETURNSTR_90;
	gradeNameList[22] = "sideShapeEdgeMaskRange";
	gradeNameList[23] = CSVLOG_RETURNSTR_116;
	gradeNameList[24] = "frontShapeEdgeSaturationEraseSW";
	gradeNameList[25] = CSVLOG_RETURNSTR_65;
	gradeNameList[26] = CSVLOG_RETURNSTR_09;
	gradeNameList[27] = CSVLOG_RETURNSTR_62;
	gradeNameList[28] = CSVLOG_RETURNSTR_61;
	gradeNameList[29] = CSVLOG_RETURNSTR_83;
	gradeNameList[30] = CSVLOG_RETURNSTR_84;
	gradeNameList[31] = CSVLOG_RETURNSTR_88;
	gradeNameList[32] = CSVLOG_RETURNSTR_89;
	gradeNameList[33] = CSVLOG_RETURNSTR_92;
	gradeNameList[34] = CSVLOG_RETURNSTR_93;
	gradeNameList[35] = CSVLOG_RETURNSTR_35;
	gradeNameList[36] = CSVLOG_RETURNSTR_36;
	gradeNameList[37] = CSVLOG_RETURNSTR_31;
	gradeNameList[38] = CSVLOG_RETURNSTR_32;
	gradeNameList[39] = CSVLOG_RETURNSTR_27;
	gradeNameList[40] = CSVLOG_RETURNSTR_28;
	gradeNameList[41] = CSVLOG_RETURNSTR_29;
	gradeNameList[42] = CSVLOG_RETURNSTR_30;
	gradeNameList[43] = CSVLOG_RETURNSTR_26;
	gradeNameList[44] = CSVLOG_RETURNSTR_33;
	gradeNameList[45] = CSVLOG_RETURNSTR_34;
	gradeNameList[46] = CSVLOG_RETURNSTR_71;
	gradeNameList[47] = CSVLOG_RETURNSTR_72;
	gradeNameList[48] = CSVLOG_RETURNSTR_174;
	gradeNameList[49] = CSVLOG_RETURNSTR_175;

	WideString tempStr;
	strings->Clear();
	int ncIndex;
	WideString NCControlName[5];
	NCControlName[0] = CSVLOG_RETURNSTR_120;
	NCControlName[1] = CSVLOG_RETURNSTR_121;
	NCControlName[2] = CSVLOG_RETURNSTR_109;
	NCControlName[3] = CSVLOG_RETURNSTR_110;
	NCControlName[4] = CSVLOG_RETURNSTR_125;

	WCHAR TempString[100];

	switch (FAction)
	{
	case ECSV_ACTION_CHANGE_MACHINE_SETTING:

		csvMachineSettingChangeData = (TCSVMachineSettingChangeData *) Params;
		if (csvMachineSettingChangeData->OldRotGuide != csvMachineSettingChangeData->NewRotGuide)
		{
			wsprintfW(TempString, CSVLOG_RETURNSTR_150, csvMachineSettingChangeData->OldRotGuide, csvMachineSettingChangeData->NewRotGuide);
			strings->Add(WideString(TempString));
		}
		if (csvMachineSettingChangeData->OldPEGuide != csvMachineSettingChangeData->NewPEGuide)
		{

			wsprintfW(TempString, CSVLOG_RETURNSTR_111, csvMachineSettingChangeData->OldPEGuide, csvMachineSettingChangeData->NewPEGuide);
			strings->Add(WideString(TempString));
		}
		if (csvMachineSettingChangeData->OldVerticalGateKind != csvMachineSettingChangeData->NewVerticalGateKind)
		{
			wsprintfW(TempString, CSVLOG_RETURNSTR_98, csvMachineSettingChangeData->OldVerticalGateKind, csvMachineSettingChangeData->NewVerticalGateKind);
			strings->Add(WideString(TempString));
		}

		if (csvMachineSettingChangeData->OldAirKnifeSpeed != csvMachineSettingChangeData->NewAirKnifeSpeed)
		{
			if (csvMachineSettingChangeData->OldAirKnifeSpeed == 0)
			{
				wsprintfW(TempString, CSVLOG_RETURNSTR_129, csvMachineSettingChangeData->NewAirKnifeSpeed);
				strings->Add(WideString(TempString));
			}
			else if (csvMachineSettingChangeData->NewAirKnifeSpeed == 0)
			{
				wsprintfW(TempString, CSVLOG_RETURNSTR_128, csvMachineSettingChangeData->OldAirKnifeSpeed);
				strings->Add(WideString(TempString));
			}
			else
			{
				wsprintfW(TempString, CSVLOG_RETURNSTR_127, csvMachineSettingChangeData->OldAirKnifeSpeed, csvMachineSettingChangeData->NewAirKnifeSpeed);
				strings->Add(WideString(TempString));
			}
		}
		if (csvMachineSettingChangeData->OldSuctionDisk1InverterSpeed != csvMachineSettingChangeData->NewSuctionDisk1InverterSpeed)
		{
			wsprintfW(TempString, CSVLOG_RETURNSTR_130, csvMachineSettingChangeData->OldSuctionDisk1InverterSpeed, csvMachineSettingChangeData->NewSuctionDisk1InverterSpeed);
			strings->Add(WideString(TempString));
		}
		if (csvMachineSettingChangeData->OldSuctionDisk2InverterSpeed != csvMachineSettingChangeData->NewSuctionDisk2InverterSpeed)
		{
			wsprintfW(TempString, CSVLOG_RETURNSTR_130, csvMachineSettingChangeData->OldSuctionDisk2InverterSpeed, csvMachineSettingChangeData->NewSuctionDisk2InverterSpeed);
			strings->Add(WideString(TempString));
		}
		for (ncIndex = 0; ncIndex < 5; ncIndex++)
		{
			double doubleValA = csvMachineSettingChangeData->OldNCPos[ncIndex];			
			double doubleValB = csvMachineSettingChangeData->NewNCPos[ncIndex];		
			int intValA = (int)(doubleValA * 100);
			int intValB = (int)(doubleValB * 100);		
			
			//if (csvMachineSettingChangeData->OldNCPos[ncIndex] != csvMachineSettingChangeData->NewNCPos[ncIndex])
			if (intValA != intValB)			
			{
				wsprintfW(TempString, L"%s : %S -> %S", NCControlName[ncIndex], FloatToStrF( csvMachineSettingChangeData->OldNCPos[ncIndex], ffFixed, 10, 2), FloatToStrF( csvMachineSettingChangeData->NewNCPos[ncIndex], ffFixed, 10, 2));
				strings->Add(WideString(TempString));
			}
		}
		break;
	case ECSV_ACTION_GRADE_CHANGE:
		csvGradeChangeActionLogData = (TCSVGradeChangeActionLogData *) Params;
		for (changeIndex = 0; changeIndex < csvGradeChangeActionLogData->Count; changeIndex++)
		{
			int gradeID = csvGradeChangeActionLogData->GradeChangeData[changeIndex].GradeID;
			switch (gradeID)
			{
			case 1:
			case 14:
			case 48:
				wsprintfW(TempString, L"%s : %Smm -> %Smm", gradeNameList[gradeID], FloatToStrF(csvGradeChangeActionLogData->GradeChangeData[changeIndex].OldValue *30.0 / 10.0 / 1000.0, ffFixed, 10, 3), FloatToStrF( csvGradeChangeActionLogData->GradeChangeData[changeIndex].NewValue *30.0 / 10.0 / 1000.0, ffFixed, 10, 3));
				strings->Add(WideString(TempString));
				break;
			case 2:
			case 4:
			case 6:
			case 8:
			case 10:
			case 12:
			case 15:
			case 17:
			case 19:
			case 25:
			case 27:
			case 28:
			case 29:
			case 35:
			case 37:
			case 39:
			case 41:
			case 43:
			case 44:
			case 46:
			case 47:
				wsprintfW(TempString, L"%s : %d -> %d", gradeNameList[gradeID], csvGradeChangeActionLogData->GradeChangeData[changeIndex].OldValue, csvGradeChangeActionLogData->GradeChangeData[changeIndex].NewValue);
				strings->Add(WideString(TempString));
				break;
			case 3:
			case 5:
			case 7:
			case 9:
			case 16:
			case 18:
			case 20:
			case 26:
			case 30:
			case 36:
			case 38:
			case 40:
			case 42:
			case 45:
			case 49:
				wsprintfW(TempString, L"%s : %Smm -> %Smm", gradeNameList[gradeID], FloatToStrF(DefectSizePixelToMili(csvGradeChangeActionLogData->GradeChangeData[changeIndex].OldValue) / 100.0, ffFixed, 10, 2), FloatToStrF( DefectSizePixelToMili(csvGradeChangeActionLogData->GradeChangeData[changeIndex].NewValue) / 100.0, ffFixed, 10, 2));
				strings->Add(WideString(TempString));
				break;
			case 21:
			case 23:
			case 31:
			case 32:
			case 33:
			case 34:
				wsprintfW(TempString, L"%s : %Smm -> %Smm", gradeNameList[gradeID], FloatToStrF(csvGradeChangeActionLogData->GradeChangeData[changeIndex].OldValue * 0.04, ffFixed, 10, 2), FloatToStrF( csvGradeChangeActionLogData->GradeChangeData[changeIndex].NewValue * 0.04, ffFixed, 10, 2));
				strings->Add(WideString(TempString));
				break;
			case 11:
				break;
			case 13:
			case 22:
			case 24:
			default:
				wsprintfW(TempString, L"%s : %d -> %d", "Unknown grade change", csvGradeChangeActionLogData->GradeChangeData[changeIndex].OldValue, csvGradeChangeActionLogData->GradeChangeData[changeIndex].NewValue);
				strings->Add(WideString(TempString));
			}
		}
		break;
	case ECSV_ACTION_INSPECTION_START:
		csvInspectionStartActionLogData = (TCSVInspectionStartActionLogData *) Params;
		if (MachineSetupData.CompanyID == INTERNATIONAL_MACHINE2)
		{
			Word = "Batch name =%s";
			wsprintfW(TempString, Word, WideString(csvInspectionStartActionLogData->LotName));
		}
		else
			wsprintfW(TempString, CSVLOG_RETURNSTR_96, WideString(csvInspectionStartActionLogData->LotName));

		strings->Add(WideString(TempString));
		if (csvInspectionStartActionLogData->IsReInspection)
		{
			if (csvInspectionStartActionLogData->ReInspectionType == RE_INSPECTION_TYPE_NEW)
			{
				strings->Add(CSVLOG_RETURNSTR_102);
			}
			else if (csvInspectionStartActionLogData->ReInspectionType == RE_INSPECTION_TYPE_CONTINUE)
			{
				strings->Add(CSVLOG_RETURNSTR_105);
			}
			else if (csvInspectionStartActionLogData->ReInspectionType == RE_INSPECTION_TYPE_REINS1)
			{
				strings->Add(CSVLOG_RETURNSTR_100);
			}
			else if (csvInspectionStartActionLogData->ReInspectionType == RE_INSPECTION_TYPE_REINS2)
			{
				strings->Add(CSVLOG_RETURNSTR_101);
			}
			else
			{
				strings->Add(CSVLOG_RETURNSTR_104);
			}
		}
		else
		{
			strings->Add(CSVLOG_RETURNSTR_103);
		}

		if (csvInspectionStartActionLogData->DesiredInspectionCount <= 0)
		{
			strings->Add(CSVLOG_RETURNSTR_118);
		}
		else
		{
			wsprintfW(TempString, CSVLOG_RETURNSTR_117, csvInspectionStartActionLogData->DesiredInspectionCount);

			strings->Add(WideString(TempString));
		}

		cameraMap = 0;
		for (int globalCameraIndex = 0; globalCameraIndex < SYSTEM_TOTAL_CAMERA_COUNT; globalCameraIndex++)
		{
			if (csvInspectionStartActionLogData->CameraEnabled[globalCameraIndex])
			{
				cameraMap |= (0x00000001 << globalCameraIndex);
			}
		}

		wsprintfW(TempString, CSVLOG_RETURNSTR_142, cameraMap);
		strings->Add(TempString);

		if (csvInspectionStartActionLogData->MachineStopActivated)
		{
			wsprintfW(TempString, CSVLOG_RETURNSTR_122, csvInspectionStartActionLogData->MachineStopDefectRatio);
			strings->Add(TempString);

			wsprintfW(TempString, CSVLOG_RETURNSTR_119, csvInspectionStartActionLogData->MachineStopUnInsRatio);
			strings->Add(TempString);
		}
		else
		{
			strings->Add("Defect limit = UNKNOWN");
			strings->Add("Un-inspection limit = UNKNOWN");
		}

		wsprintfW(TempString, CSVLOG_RETURNSTR_114, (int)(csvInspectionStartActionLogData->MotorSpeed[0] * 100));
		strings->Add(TempString);

		wsprintfW(TempString, CSVLOG_RETURNSTR_115, (int)(csvInspectionStartActionLogData->MotorSpeed[1] * 100));
		strings->Add(TempString);

		wsprintfW(TempString, CSVLOG_RETURNSTR_148, (int)(csvInspectionStartActionLogData->MotorSpeed[2] * 100));
		strings->Add(TempString);

		wsprintfW(TempString, CSVLOG_RETURNSTR_147, (int)(csvInspectionStartActionLogData->MotorSpeed[3] * 100));
		strings->Add(TempString);
		break;
		/*
		case ECSV_ACTION_GRADE_CHANGE:
			csvGradeChangeActionLogData = (TCSVGradeChangeActionLogData *) Params;
			for (changeIndex = 0; changeIndex < csvGradeChangeActionLogData->Count; changeIndex++)
			{
				int gradeID = csvGradeChangeActionLogData->GradeChangeData[changeIndex].GradeID;
				if (gradeID > 0 && gradeID <= 45)
				{
					strings->Add(tempStr.sprintf("%s : %d -> %d", gradeNameList[gradeID], csvGradeChangeActionLogData->GradeChangeData[changeIndex].OldValue,
						csvGradeChangeActionLogData->GradeChangeData[changeIndex].NewValue));
				}
			}
			break;
		*/
	}
}
//---------------------------------------------------------------------------
int __fastcall TCSVActionLog::GetEventKind(void)
{
	return FAction;
}
//---------------------------------------------------------------------------
void __fastcall TCSVActionLog::SetKind(ECSVLogKind kind)
{
	FKind = kind;
}
//---------------------------------------------------------------------------
void __fastcall TCSVActionLog::SetTime(double time)
{
	FTime = time;
}
//---------------------------------------------------------------------------
void __fastcall TCSVActionLog::SetFileName(AnsiString filename)
{
	FFromFileName = filename;
}
//---------------------------------------------------------------------------
//	TCSVLogList class
//---------------------------------------------------------------------------
__fastcall TCSVLogList::TCSVLogList()
{
	FDataCount = 0;
}
//---------------------------------------------------------------------------
void __fastcall TCSVLogList::Clear(void)
{
	FDataCount = 0;
	while (InspectionReportList.size() > 0)
	{
		TCSVLog *aLog = InspectionReportList.back();
		InspectionReportList.pop_back();
		delete aLog;

	}
}
//---------------------------------------------------------------------------
bool __fastcall TCSVLogList::LoadFromFileStream(TFileStream *fileStream, AnsiString filename, TDateTime startDate, TDateTime endDate)
{
	bool returnValue = true;
	TCSVLogFileHeader *csvLogFileHeader = NULL;
	try
	{
		csvLogFileHeader = new TCSVLogFileHeader;
		csvLogFileHeader->LoadFromFileStream(fileStream);
		TCSVLogFileHeaderStr csvLogFileHeaderStr = csvLogFileHeader->CSVLogFileHeaderStr;
		delete csvLogFileHeader;
		csvLogFileHeader = NULL;

		if (csvLogFileHeaderStr.CreateTime >= (int)startDate.Val - 7 &&
		        csvLogFileHeaderStr.CreateTime <= (int)endDate.Val + 7)
		{
			while (true)
			{
				try
				{
					TCSVLogUnitHeader csvLogUnitHeader;
					if (fileStream->Read(&csvLogUnitHeader, sizeof(TCSVLogUnitHeader)) != sizeof(TCSVLogUnitHeader))
					{
						break;
					}
					if (csvLogUnitHeader.Kind == ECSV_LOG_KIND_EVENT)
					{
						TCSVEventLog *csvEventLog = new TCSVEventLog;
						csvEventLog->SetKind(csvLogUnitHeader.Kind);
						csvEventLog->SetTime(csvLogUnitHeader.Time);
						csvEventLog->SetFileName(filename);
						if (!csvEventLog->LoadFromFileStream(fileStream))
						{
							delete csvEventLog;
							break;
						}
						else
						{
							if (csvLogUnitHeader.Time == CSV_DELETE_LOG_TIME)
							{
								continue;
							}

							InspectionReportList.push_back(csvEventLog);
						}
					}
					else if (csvLogUnitHeader.Kind == ECSV_LOG_KIND_ACTION)
					{
						TCSVActionLog *csvActionLog = new TCSVActionLog;
						csvActionLog->SetKind(csvLogUnitHeader.Kind);
						csvActionLog->SetTime(csvLogUnitHeader.Time);
						csvActionLog->SetFileName(filename);
						if (!csvActionLog->LoadFromFileStream(fileStream))
						{
							delete csvActionLog;
							break;
						}
						else
						{
							if (csvLogUnitHeader.Time == CSV_DELETE_LOG_TIME)
							{
								continue;
							}

							InspectionReportList.push_back(csvActionLog);
						}
					}
					else
					{
						//fileStream->Seek(csvLogUnitHeader.Size - sizeof(TCSVLogUnitHeader), soFromCurrent);
					}

				}
				catch (CSVLogException &ec)
				{
					break;
				}
			}
		}
	}
	catch (CSVLogException &ec)
	{
		returnValue = false;
		if (csvLogFileHeader)
			delete csvLogFileHeader;
	}
	FDataCount = InspectionReportList.size();
	return returnValue;
}
//---------------------------------------------------------------------------
ECSVLogKind __fastcall TCSVLogList::GetKind(int dataIndex)
{
	return InspectionReportList[dataIndex]->GetKind();
}
//---------------------------------------------------------------------------
double __fastcall TCSVLogList::GetTime(int dataIndex)
{
	return InspectionReportList[dataIndex]->GetTime();
}
//---------------------------------------------------------------------------
WideString __fastcall TCSVLogList::GetKindStr(int dataIndex)
{
	WideString returnStr = "UNKNOWN";
	ECSVLogKind kind = InspectionReportList[dataIndex]->GetKind();
	switch (kind)
	{
	case ECSV_LOG_KIND_EVENT:
		returnStr = "Event";
		break;
	case ECSV_LOG_KIND_ACTION:
		returnStr = "Action";
		break;
	default:
		break;
	}
	return returnStr;
}
//---------------------------------------------------------------------------
WideString __fastcall TCSVLogList::GetTimeStr(int dataIndex)
{
	WideString timeStr;
	TDateTime *dateTime = new TDateTime(InspectionReportList[dataIndex]->GetTime());

	if (MachineSetupData.CompanyID == INTERNATIONAL_MACHINE2)
		timeStr = dateTime->FormatString("DD/MM/YYYY    HH:MM:SS");
	else
		timeStr = dateTime->DateTimeString();
	delete dateTime;
	return timeStr;
}
//---------------------------------------------------------------------------
WideString __fastcall TCSVLogList::GetCreatorName(int dataIndex)
{
	return InspectionReportList[dataIndex]->GetCreatorName();
}
//---------------------------------------------------------------------------
WideString __fastcall TCSVLogList::GetProductName(int dataIndex)
{
	return InspectionReportList[dataIndex]->GetProductName();
}
//---------------------------------------------------------------------------
WideString __fastcall TCSVLogList::GetMessage(int dataIndex)
{
	return InspectionReportList[dataIndex]->GetMessage();
}
//---------------------------------------------------------------------------
int __fastcall TCSVLogList::GetEventKind(int dataIndex)
{
	return InspectionReportList[dataIndex]->GetEventKind();
}
//---------------------------------------------------------------------------
void __fastcall TCSVLogList::GetDetailInfo(int dataIndex, TTntStrings *strings)
{
	InspectionReportList[dataIndex]->GetDetailInfo(strings);
}
//---------------------------------------------------------------------------
TDateTime __fastcall TCSVLogList::GetTimeInfo(int dataIndex)
{
	TDateTime dateTime = TDateTime(InspectionReportList[dataIndex]->GetTime());
	return dateTime;
}
//---------------------------------------------------------------------------
AnsiString __fastcall TCSVLogList::GetLogFileName(int dataIndex)
{
	AnsiString filename = InspectionReportList[dataIndex]->GetFileName();
	return filename;
}
//---------------------------------------------------------------------------







