//---------------------------------------------------------------------------
#ifndef CSVLogH
#define CSVLogH

#include <vcl.h>
#include <vector.h>
#include "TntClasses.hpp"
//---------------------------------------------------------------------------
#define CSV_ALARM_CODE_HCB_NC				0x100
#define CSV_ALARM_CODE_SPB_1_NC				0x101
#define CSV_ALARM_CODE_SPB_2_NC				0x102
#define CSV_ALARM_CODE_SPB_3_NC				0x103
#define CSV_ALARM_CODE_SPB_4_NC				0x104
#define CSV_ALARM_CODE_SPB_5_NC				0x105
#define CSV_ALARM_CODE_SPB_6_NC				0x106
#define CSV_ALARM_CODE_COMPRESSED_AIR		0x110
#define CSV_ALARM_CODE_EMERGENCY_ON			0x111
#define CSV_ALARM_CODE_INVERTER_1_TRIP		0x112
#define CSV_ALARM_CODE_INVERTER_2_TRIP		0x113
#define CSV_ALARM_CODE_INVERTER_3_TRIP		0x129
#define CSV_ALARM_CODE_RING_BLOWER_3_OL		0x114
#define CSV_ALARM_CODE_DISK_1_SUCTION_LOW	0x115
#define CSV_ALARM_CODE_DISK_2_SUCTION_LOW	0x116
#define CSV_ALARM_CODE_SERVO_ALARM			0x117
#define CSV_ALARM_CODE_INTERLOCK			0x118
#define CSV_ALARM_CODE_DISK_1_STALL			0x119
#define CSV_ALARM_CODE_DISK_2_STALL			0x11A
#define CSV_ALARM_CODE_GP_FULL				0x11B
#define CSV_ALARM_CODE_DP_FULL				0x11C
#define CSV_ALARM_CODE_UP_FULL				0x11D
#define CSV_ALARM_CODE_DP_RATIO_OVER		0x11E
#define CSV_ALARM_CODE_UP_RATIO_OVER		0x11F
#define CSV_ALARM_CODE_CRIT_UP_RATIO_OVER  	0x120
#define CSV_ALARM_CODE_SENSOR_1_ERROR  		0x121
#define CSV_ALARM_CODE_SENSOR_2_ERROR  		0x122
#define CSV_ALARM_CODE_BRIGHTNESS_DOWN  	0x123
#define CSV_ALARM_CODE_STEPMOTOR_1_STALL  	0x124
#define CSV_ALARM_CODE_STEPMOTOR_2_STALL  	0x125
#define CSV_ALARM_CODE_STEPMOTOR_3_STALL	0x126
#define CSV_ALARM_CODE_STEPMOTOR_4_STALL	0x127
#define CSV_ALARM_CODE_STEPMOTOR_5_STALL	0x128
#define CSV_ALARM_CODE_BLACKOUT         	0x200
#define CSV_ALARM_CODE_TOTAL_FULL				0x201
#define CSV_ALARM_CODE_CRIT_DP_RATIO_OVER  	0x202
#define CSV_ALARM_CODE_TEMPERATURE_1_OVER  	0x203
#define CSV_ALARM_CODE_TEMPERATURE_2_OVER  	0x204
#define CSV_ALARM_CODE_TEMPERATURE_3_OVER  	0x205
#define CSV_ALARM_CODE_MISEJECTOR_CHECK  	0x206
#define CSV_ALARM_CODE_MISEJECTOR_FULL  	0x207

#define CSV_ALARM_CODE_ACROCIA_MES_STATUS_ERROR   	0x208
#define CSV_ALARM_CODE_ACROCIA_DLL_OBJECT_ERROR   	0x209
#define CSV_ALARM_CODE_ACROCIA_UPSTREAM_STATUS_ERROR   	0x20A
#define CSV_ALARM_CODE_ACROCIA_DOWNSTREAM_STATUS_ERROR   	0x20B
#define CSV_ALARM_CODE_ACROCIA_LASER_EMERGENCY_ON   	0x20C

#define CSV_ALARM_CODE_EMISSIONSENSOR_ON 0x20D

//   ĸ  , CSV α    ϳ   Դϴ. ߰Ͻ  ִٸ 0x20D   ڷ   ּ ּ߰ 


#define	RE_INSPECTION_TYPE_NEW			0
#define	RE_INSPECTION_TYPE_CONTINUE		1
#define RE_INSPECTION_TYPE_REINS1		2
#define RE_INSPECTION_TYPE_REINS2		3
#define SYSTEM_TOTAL_CAMERA_COUNT		16

#define CSV_DELETE_LOG_TIME 12345.65478

typedef enum {
	ECSV_FILE_CANNOT_OPEN,
	ECSV_ERROR_VERSION_NOT_MATCHED,
	ECSV_FILE_CANNOT_WRITE,
	ECSV_FILE_CANNOT_READ
} ECSVError;
typedef enum { ECSV_LOG_KIND_NONE = 0, ECSV_LOG_KIND_EVENT = 1, ECSV_LOG_KIND_ACTION = 2 } ECSVLogKind;					//    	1, 2, 4, 8 

typedef enum {
	ECSV_EVENT_NONE = 0,
	ECSV_EVENT_APPLICATION_STARTED = 0x001,
	ECSV_EVENT_APPLICATION_TERMINATED = 0x002,
	ECSV_EVENT_APPLICATION_TIMECHANGEED = 0x003,
	ECSV_EVENT_MACHINE_SUSPEND = 0x100,
	ECSV_EVENT_ALARM = 0x200,
	ECSV_EVENT_ALARM_CLEAR = 0x201,
	ECSV_EVENT_MACHINE_OFF = 0x202		
} ECSVEvent;		//    

typedef enum {
	ECSV_ACTION_NONE = 0,
	ECSV_ACTION_USER_ADD = 0x100,
	ECSV_ACTION_USER_DELETE = 0x101,
	ECSV_ACTION_USER_PASSWORD_CHANGE = 0x102,
	ECSV_ACTION_LOGIN = 0x200,
	ECSV_ACTION_LOGOUT = 0x201,
	ECSV_ACTION_WRONG_PASSWORD = 0x202,
	ECSV_ACTION_UNPERMITTED_USER = 0x203,
	ECSV_ACTION_EXPIRATION_LOCK_USER = 0x204,
	ECSV_ACTION_CHANGE_ACTIVE = 0x205,
	ECSV_ACTION_CHANGE_DEACTIVE = 0x206,		
	ECSV_ACTION_UNLOCK = 0x207,		
	ECSV_ACTION_PRODUCT_ADD = 0x300,
	ECSV_ACTION_PRODUCT_EDIT = 0x301,
	ECSV_ACTION_PRODUCT_RENAME = 0x302,
	ECSV_ACTION_PRODUCT_CLONE = 0x303,
	ECSV_ACTION_PRODUCT_DELETE = 0x304,
	ECSV_ACTION_PRODUCT_SELECTION = 0x400,
	ECSV_ACTION_IMAGE_CAPTURE_START = 0x500,
	ECSV_ACTION_IMAGE_CAPTURE_STOP = 0x501,
	ECSV_ACTION_IMAGE_CAPTURE_COMPLETE = 0x502,
	ECSV_ACTION_TABLET_CHARACTER_EXTRACT = 0x600,
	ECSV_ACTION_TABLET_CHARACTER_EXTRACT_END = 0x601,
	ECSV_ACTION_FIRST_STUDY = 0x700,
	ECSV_ACTION_SECOND_STUDY = 0x800,
	ECSV_ACTION_STUDY_START = 0x850,
	ECSV_ACTION_INSPECTION_START = 0x900,
	ECSV_ACTION_INSPECTION_RESTART = 0x901,
	ECSV_ACTION_INSPECTION_PAUSE = 0x902,
	ECSV_ACTION_INSPECTION_BATCH_END = 0x903,
	ECSV_ACTION_GRADE_CHANGE = 0xA00,
	ECSV_ACTION_CHANGE_MACHINE_SETTING = 0xB00
} ECSVAction;		//    
//---------------------------------------------------------------------------
//	CSV Log File Header Information
//---------------------------------------------------------------------------
#define CSV_LOG_FILE_HEADER_IDENTIFIER						(('C' << 24) | ('S' << 16) | ('V' << 8) | ('L'))
#define CSV_LOG_FILE_HEADER_CURRENT_MAJOR_VERSION			100		// file ũⰡ ϰų  structure  ٲ  Ų.
#define CSV_LOG_FILE_HEADER_CURRENT_MINOR_VERSION			100		//  structure dummy  ο  ߰  Ų.
//---------------------------------------------------------------------------
#define CSV_UNIT_HEADER_CURRENT_VERSION						100		//  ٲ ʵ Ѵ.

#define CSV_EVENT_LOG_CURRENT_VERSION						100
#define CSV_ACTION_LOG_CURRENT_VERSION						101 // 2022-04-28 ver 100 -> ver 101 
//---------------------------------------------------------------------------
typedef struct
{
	unsigned int FileHeader;
	unsigned int MajorVersion;
	unsigned int MinorVersion;
	unsigned int HeaderSize;
	double CreateTime;
	char dummy[1000];
} TCSVLogFileHeaderStr;		// total 1024 bytes

typedef struct
{
	unsigned int Version;		// version, size   ٲ ʴ´.
	unsigned int Size;
	unsigned int Kind;
	double Time;
	unsigned int dummy[12];
} TCSVLogUnitHeader;		// total 32 bytes

typedef struct
{
	char OldData;
	char NewData;
} TCSVInformationChangeData;

// Version 100
typedef struct
{
	unsigned int Version;
	int Action;
	char UserName[32];
	char ProcuctName[32];
	int ParamSize;
} TActionLogHeader_Ver100;

// Version 101
typedef struct
{
	unsigned int Version;
	int Action;
	char UserName[32];
	char ProcuctName[64]; // ver 100 : 32 , ver 101 : 64
	int ParamSize;
} TActionLogHeader;

typedef struct
{
	unsigned int GradeID;
	int OldValue;
	int NewValue;
} TGradeChangeData;

typedef struct
{
	int Count;
	TGradeChangeData GradeChangeData[50];
} TCSVGradeChangeActionLogData;

typedef struct
{
	int IsReInspection;
	int DesiredInspectionCount;
	int ReInspectionType;
	int ReInspectionTabletCount;
	int CameraEnabled[SYSTEM_TOTAL_CAMERA_COUNT];
	int MachineStopActivated;
	int MachineStopDefectRatio;
	int MachineStopUnInsRatio;
	int NCAsDefect;
	float MotorSpeed[4];
	char LotName[64];
} TCSVInspectionStartActionLogData;

typedef struct
{
	char OldName[64];
	char NewName[64];
} TCSVRenameActionLogData;

typedef struct
{
	char OldVerticalGateKind;
	char NewVerticalGateKind;
	char OldRotGuide;
	char NewRotGuide;
	char OldPEGuide;
	char NewPEGuide;
	//	short OldTabletSize;
	//	short NewTabletSize;
	char OldAirKnifeSpeed;
	char NewAirKnifeSpeed;
	unsigned char OldSuctionDisk1InverterSpeed;
	unsigned char NewSuctionDisk1InverterSpeed;
	unsigned char OldSuctionDisk2InverterSpeed;
	unsigned char NewSuctionDisk2InverterSpeed;	// 12 bytes
	double OldNCPos[5];
	double NewNCPos[5];
	char reserved[36];
} TCSVMachineSettingChangeData;
//---------------------------------------------------------------------------
class CSVLogException
{
private:
	WideString FMessage;
	WideString __fastcall MessageOfErrorCode(ECSVError error);
public:
	__fastcall CSVLogException(WideString msg);
	__fastcall CSVLogException(ECSVError error);
	__property WideString Message = { read = FMessage };
};

//---------------------------------------------------------------------------
class TCSVLogFileHeader
{
private:
public:
	TCSVLogFileHeaderStr CSVLogFileHeaderStr;
	__fastcall TCSVLogFileHeader();
	__fastcall TCSVLogFileHeader(double createTime);
	void __fastcall SaveToFileStream(TFileStream* fileStream);
	bool __fastcall LoadFromFileStream(TFileStream* fileStream);
};
//---------------------------------------------------------------------------
class TCSVLog
{
private:
protected:
	ECSVLogKind FKind;
	double FTime;
	char UserName[32];
	unsigned char* Params;
	int ParamSize;
	char* Message;
	int MessageLength;
	AnsiString FFromFileName;

	void __fastcall ClearData(void);
public:
	__fastcall TCSVLog();
	__fastcall ~TCSVLog();
	ECSVLogKind __fastcall GetKind(void);
	double __fastcall GetTime(void);
	AnsiString __fastcall GetFileName(void);
	virtual WideString __fastcall GetCreatorName(void) { return ""; };
	virtual WideString __fastcall GetProductName(void) { return ""; };
	virtual WideString __fastcall GetMessage(void) { return ""; };
	virtual int __fastcall GetEventKind(void) { return 0; };
	virtual void __fastcall GetDetailInfo(TTntStrings* strings) { strings->Clear(); };
};
//---------------------------------------------------------------------------
class TCSVEventLog : public TCSVLog
{
private:
	ECSVEvent FEvent;
public:
	__fastcall TCSVEventLog();
	__fastcall TCSVEventLog(ECSVEvent event);
	__fastcall ~TCSVEventLog();
	bool __fastcall SaveToFileStream(TFileStream* fileStream);
	bool __fastcall LoadFromFileStream(TFileStream* fileStream);
	WideString __fastcall GetCreatorName(void);
	WideString __fastcall GetMessage(void);
	int __fastcall GetEventKind(void);
	void __fastcall SetKind(ECSVLogKind kind);
	void __fastcall SetTime(double time);
	void __fastcall SetFileName(AnsiString filename);
	void __fastcall SetLogInfoParam(void* param);
	void __fastcall SetParams(unsigned char* params, int paramSize);
};
//---------------------------------------------------------------------------
class TCSVActionLog : public TCSVLog
{
private:
	ECSVAction FAction;
	char UserName[32];
	char ProductName[64]; // ver 100 : 32 , ver 101 : 64
	unsigned char* Params;
	int ParamSize;
	char* Message;
	int MessageLength;
public:
	__fastcall TCSVActionLog();
	__fastcall TCSVActionLog(ECSVAction action);
	__fastcall ~TCSVActionLog();
	bool __fastcall SaveToFileStream(TFileStream* fileStream);
	bool __fastcall LoadFromFileStream(TFileStream* fileStream);
	WideString __fastcall GetCreatorName(void);
	WideString __fastcall GetProductName(void);
	WideString __fastcall GetMessage(void);
	int __fastcall GetEventKind(void);
	void __fastcall GetDetailInfo(TTntStrings* strings);
	void __fastcall SetKind(ECSVLogKind kind);
	void __fastcall SetTime(double time);
	void __fastcall SetFileName(AnsiString filename);
	void __fastcall SetParams(char* userName, char* productName, unsigned char* params, int paramSize);
};
//---------------------------------------------------------------------------
class TCSVLogList
{
private:
	vector<TCSVLog*> InspectionReportList;
	int FDataCount;
public:
	__fastcall TCSVLogList();
	void __fastcall Clear(void);
	bool __fastcall LoadFromFileStream(TFileStream* fileStream, AnsiString filename, TDateTime startDate, TDateTime endDate);

	ECSVLogKind __fastcall GetKind(int dataIndex);
	double __fastcall GetTime(int dataIndex);

	WideString __fastcall GetKindStr(int dataIndex);
	WideString __fastcall GetTimeStr(int dataIndex);
	WideString __fastcall GetCreatorName(int dataIndex);
	WideString __fastcall GetProductName(int dataIndex);
	WideString __fastcall GetMessage(int dataIndex);
	int __fastcall GetEventKind(int dataIndex);
	void __fastcall GetDetailInfo(int dataIndex, TTntStrings* strings);
	TDateTime __fastcall GetTimeInfo(int dataIndex);
	AnsiString __fastcall GetLogFileName(int dataIndex);

	__property int DataCount = { read = FDataCount, write = FDataCount };
};
//---------------------------------------------------------------------------
#endif
