//---------------------------------------------------------------------------

#ifndef Calibration3D_FormH
#define Calibration3D_FormH
//---------------------------------------------------------------------------
#include <Classes.hpp>
#include <Controls.hpp>
#include <StdCtrls.hpp>
#include <Forms.hpp>
#include <ExtCtrls.hpp>
#include "CGAUGES.h"
#include "TntExtCtrls.hpp"
#include "TntForms.hpp"
#include "TntStdCtrls.hpp"
#include <Grids.hpp>

#define MAX_3D_CAMERA_COUNT			2
#define PARAM_GRADE_EXP_COUNT			15
#define PARAM_GRADE_GAIN_COUNT			5
//#define PARAM_GRADE_COUNT			5
#define MAX_IMAGE_COUNT_PER_GRADE	4
//---------------------------------------------------------------------------
typedef enum {ECS3_NONE, ECS3_SETTING_PARAM, ECS3_ON_CAPTURE} ECalibrationStep_3D;
typedef enum {ESS_NONE, ESS_FIRST, ESS_SECOND} ESelectionStep;
//---------------------------------------------------------------------------
class TCalibration3DForm : public TTntForm
{
__published:	// IDE-managed Components
	TTntPanel *MainMenuPanel;
	TTntButton *CaptureStartButton;
	TTntButton *CaptureStopButton;
	TTntButton *ImageSelectionButton;
	TTntButton *CloseButton;
	TTntPanel *Panel2;
	TTntGroupBox *GroupBox1;
	TTntImage *CaptureImage5_1;
	TTntImage *CaptureImage5_2;
	TTntGroupBox *GroupBox2;
	TTimer *CaptureCheckTimer;
	TTntPanel *CaptureProgressPanel;
	TCGauge *CaptureProcessGauge;
	TTntPanel *CapturePanel;
	TTntImage *CaptureImage5_3;
	TTntImage *CaptureImage5_4;
	TTntImage *CaptureImage13_1;
	TTntImage *CaptureImage13_2;
	TTntImage *CaptureImage13_3;
	TTntImage *CaptureImage13_4;
	TTntPanel *ImageSelectionMenuPanel;
	TTntButton *ImageSelectionPrevButton;
	TTntPanel *ImageSelectionCam5Panel;
	TTntPanel *ImageSelectionCam13Panel;
	TTntButton *ImageSelectionNextButton;
  TTntGroupBox *TntGroupBox1;
  TTntLabel *TntLabel1;
  TTntEdit *StartShutterSpeedEdit;
  TTntLabel *EndShutterSpeedLabel;
  TTntButton *SelectCameraParamButton;
  TTntPanel *Camera5_SetCheckPanel;
  TTntPanel *Camera13_SetCheckPanel;
  TTntLabel *Camera5_SetCheckLabel;
  TTntLabel *Camera13_SetCheckLabel;
  TRadioButton *RadioButton1;
  TRadioButton *RadioButton2;
  TTntLabel *TntLabel2;
  TLabel *ValueLabel1;
  TLabel *ValueLabel2;
  TStringGrid *StringGrid1;
  TTntGroupBox *CaptureMessagePanel;
  TTntButton *ReturnButton;
  TTntButton *SpeedBtn;
  TTntButton *ReCaptureBtn;
  TRadioButton *RadioButton3;
  TTntPanel *BgPanel;
  TTntLabel *TntLabel3;
  TTntGroupBox *ViewGroupBox5_1;
  TTntImage *ViewImage5_1;
  TTntImage *ViewImage5_2;
  TTntImage *ViewImage5_3;
  TTntImage *ViewImage5_4;
  TTntLabel *TntLabel4;
  TTntGroupBox *ViewGroupBox5_2;
  TTntImage *ViewImage5_5;
  TTntImage *ViewImage5_6;
  TTntImage *ViewImage5_7;
  TTntImage *ViewImage5_8;
  TTntGroupBox *ViewGroupBox5_3;
  TTntImage *ViewImage5_9;
  TTntImage *ViewImage5_10;
  TTntImage *ViewImage5_11;
  TTntImage *ViewImage5_12;
  TTntGroupBox *ViewGroupBox5_4;
  TTntImage *ViewImage5_13;
  TTntImage *ViewImage5_14;
  TTntImage *ViewImage5_15;
  TTntImage *ViewImage5_16;
  TTntGroupBox *ViewGroupBox13_1;
  TTntImage *ViewImage13_1;
  TTntImage *ViewImage13_2;
  TTntImage *ViewImage13_3;
  TTntImage *ViewImage13_4;
  TTntGroupBox *ViewGroupBox13_2;
  TTntImage *ViewImage13_5;
  TTntImage *ViewImage13_6;
  TTntImage *ViewImage13_7;
  TTntImage *ViewImage13_8;
  TTntGroupBox *ViewGroupBox13_3;
  TTntImage *ViewImage13_9;
  TTntImage *ViewImage13_10;
  TTntImage *ViewImage13_11;
  TTntImage *ViewImage13_12;
  TTntGroupBox *ViewGroupBox13_4;
  TTntImage *ViewImage13_13;
  TTntImage *ViewImage13_14;
  TTntImage *ViewImage13_15;
  TTntImage *ViewImage13_16;
	void __fastcall CaptureStartButtonClick(TObject *Sender);
	void __fastcall CaptureCheckTimerTimer(TObject *Sender);
	void __fastcall FormDestroy(TObject *Sender);
	void __fastcall FormCreate(TObject *Sender);
	void __fastcall CaptureStopButtonClick(TObject *Sender);
	void __fastcall ImageSelectionButtonClick(TObject *Sender);
	void __fastcall ImageSelectionNextButtonClick(TObject *Sender);
	void __fastcall ImageSelectionPrevButtonClick(TObject *Sender);
	void __fastcall CloseButtonClick(TObject *Sender);
  void __fastcall ImageSelectionCam5PanelClick(TObject *Sender);
  void __fastcall ImageSelectionCam13PanelClick(TObject *Sender);
  void __fastcall SelectCameraParamButtonClick(TObject *Sender);
  void __fastcall StartShutterSpeedEditClick(TObject *Sender);
  void __fastcall RadioButton1Click(TObject *Sender);
  void __fastcall ReturnButtonClick(TObject *Sender);
  void __fastcall SpeedBtnClick(TObject *Sender);
  void __fastcall ReCaptureBtnClick(TObject *Sender);
private:	// User declarations
	bool HorzScrollDown, VertScrollDown;
	TPoint MouseDownPos;
	TPoint CurrentScrollPos;
	ESelectionStep CurrentSelectionStep;

	unsigned char *CaptureData;
	Graphics::TBitmap *CaptureBitmap;
  Graphics::TBitmap *CaptureSaveBitmap;

	int	CurrentExposureTimeGrade[MAX_3D_CAMERA_COUNT];
  int	CurrentGainGrade[MAX_3D_CAMERA_COUNT];

	int TotalCapturedCount[MAX_3D_CAMERA_COUNT];
	int CurrentCapturedCount[MAX_3D_CAMERA_COUNT];
	int CurrentExposureTime[MAX_3D_CAMERA_COUNT];
	int CurrentThreshold[MAX_3D_CAMERA_COUNT];
  int CurrentGain[MAX_3D_CAMERA_COUNT];
	unsigned long SetParamTime[MAX_3D_CAMERA_COUNT];
	int CurrentSelectionCamera3DIndex;
	ECalibrationStep_3D CalibrationStep_3D[MAX_3D_CAMERA_COUNT];
  TTntImage *ImagePanelList[MAX_3D_CAMERA_COUNT][8];
	int	SelectedParamGradeValue[MAX_3D_CAMERA_COUNT];


	int PreSetExposureTimeList[MAX_3D_CAMERA_COUNT][PARAM_GRADE_EXP_COUNT];
	int PreSetThresholdList[MAX_3D_CAMERA_COUNT][PARAM_GRADE_GAIN_COUNT];
  int PreSetGainList[MAX_3D_CAMERA_COUNT][PARAM_GRADE_GAIN_COUNT];

  int IncreaseSpeed;
  bool __fastcall RefreshCameraInfo(int camIndex, int ExposureTime, int Threshold);
  void __fastcall GetDefaultString();

  bool SaveDataFlag[MAX_3D_CAMERA_COUNT];
  int  LastCaptureShutterSpeed;
  int  LastIncreaseSpeed;

  void __fastcall LoadImage(int cameraIndex, int Gain , int ExposureTime);
  void __fastcall ExitForm();
  void __fastcall RemoveWholeDir(AnsiString folderName);

  int ImageViewScroll_Gain;
  int ImageViewScroll_Exposure;
  int CaptureEndCheckCount;

  int CapturePanelBaseNumber; // г ݺ  
  int CaptureStep[2];
  int GroupStep[2];

  unsigned int camMask; 
public:		// User declarations
	__fastcall TCalibration3DForm(TComponent* Owner);

};
//---------------------------------------------------------------------------
extern PACKAGE TCalibration3DForm *Calibration3DForm;
//---------------------------------------------------------------------------
#endif
