//---------------------------------------------------------------------------

#ifndef CameraSetting3D_FormH
#define CameraSetting3D_FormH
//---------------------------------------------------------------------------
#include <Classes.hpp>
#include <Controls.hpp>
#include <StdCtrls.hpp>
#include <Forms.hpp>
#include <Buttons.hpp>
#include <ExtCtrls.hpp>
#include <FileCtrl.hpp>

#include "common.h"
#include "TntButtons.hpp"
#include "TntExtCtrls.hpp"
#include "TntForms.hpp"
#include "TntStdCtrls.hpp"
#include "CSPIN.h"
#include "Environment.h"
#include "TntComCtrls.hpp"
#include <ComCtrls.hpp>
#define CAMERA_SETUP_3D_WAITING_TIME				1000

// Line Scan Image
#define LINE_FRAME_WIDTH_RANGER_3D					480
#define LINE_FRAME_HEIGHT_RANGER_3D					640

// One Frame Image
// 1280 * 1024
#define AREA_FRAME_WIDTH_RANGER_3D					640
#define AREA_FRAME_HEIGHT_RANGER_3D					1024//512


#define MAX_3D_CAMERA_COUNT			2
//#define EXPOSURE_TIME_GRADE_COUNT	8
//#define PARAM_GRADE_COUNT			7
//#define MAX_IMAGE_COUNT_PER_GRADE	8

//20201106 cjg added 3d camera param
#define DEFAULT_OFFSET_PROCESS  0  
#define MAX_OFFSET_PROCESS  1
#define AVG_OFFSET_PROCESS  2

//---------------------------------------------------------------------------
typedef enum {ERCM_CALIB, ERCM_GRAY, ERCM_3D}ERangerCaptureMode;
//---------------------------------------------------------------------------
class TCameraSetting3DForm : public TTntForm
{
__published:	// IDE-managed Components
	TTntPanel *Panel1;
	TTntLabel *lblFPS;
	TTntShape *shRefresh;
	TTntImage *BufferImage;
	TTntLabel *lblAvgFPS;
	TTntLabel *Label8;
	TTntSpeedButton *SaveSpeedButton;
	TDirectoryListBox *ImageDirectoryListBox;
	TTntButton *StopTimerButton;
	TFileListBox *ImageFileListBox;
	TTntEdit *SubDirEdit;
	TTntButton *SaveImageButton;
	TTntCheckBox *cbRAWData;
	TDriveComboBox *ImageDriveComboBox;
	TTntButton *NewFolderButton;
  TTntScrollBox *qqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqq;
	TTntImage *CaptureImage;
	TTimer *CaptureCheckTimer;
	TTntPanel *Panel4;
	TTntPanel *Panel5;
	TTntButton *CloseButton;
  TTntPanel *SettingPanel;
  TTntLabel *TntLabel8;
  TTntLabel *TntLabel9;
  TTntLabel *TntLabel11;
  TTntLabel *TntLabel12;
  TTntLabel *TntLabel13;
  TTntLabel *TntLabel14;
  TTntLabel *TntLabel15;
  TTntLabel *TntLabel16;
  TTntLabel *TntLabel17;
  TTntLabel *TntLabel18;
  TTntLabel *TntLabel19;
  TTntLabel *TntLabel20;
  TTntLabel *TntLabel23;
  TTntComboBox *cmdNFACameraData1;
  TTntLabel *TntLabel7;
  TTntEdit *cmdNFACameraData6;
  TTntLabel *Label5;
  TTntEdit *cmdNFACameraData7;
  TTntLabel *TntLabel24;
  TTntLabel *TntLabel6;
  TTntSpeedButton *CalibrationModeSpeedButton;
  TTntSpeedButton *ThreeDModeSpeedButton;
  TTntButton *SetupButton;
  TTntSpeedButton *CameraSpeedButton5;
  TTntSpeedButton *CameraSpeedButton13;
  TTntPanel *ImageInfoPanel;
  TTntImage *EnlargeImage;
  TTntImage *RedImage;
  TTntImage *GreenImage;
  TTntImage *BlueImage;
  TTntButton *CaptureStartButton;
  TTntButton *HCBCaptureStartButton;
  TTntButton *HCBCaptureStopButton;
  TTntButton *CaptureStopButton;
  TTntButton *AdvMachineControlButton;
  TGroupBox *GroupBox1;
  TTntLabel *TntLabel1;
  TTntEdit *LineScanTimeEdit;
  TTntLabel *TntLabel2;
  TTntLabel *TntLabel4;
  TTntComboBox *cmdNFACameraData9;
  TCSpinEdit *cmdNFACameraData8;
  TTntLabel *TntLabel3;
  TTntEdit *cmdNFACameraData2;
  TTntEdit *cmdNFACameraData3;
  TTntEdit *cmdNFACameraData4;
  TTntEdit *cmdNFACameraData5;
  TButton *Button1;
  TTntLabel *TntLabel5;
  TTntLabel *TntLabel10;
  TCSpinEdit *CSpinEdit1;
  TTntLabel *TntLabel21;
  TButton *Button2;
  TRadioGroup *TriggerMethodRadioBox1;
  TRadioGroup *TriggerMethodRadioBox2;
  TGroupBox *CalModeBox;
  TImage *ySliceImage;
  TLabel *Label1;
  TLabel *Label2;
  TLabel *RAWValueLabel;
  TGroupBox *CameraHWSetupGroupBox;
  TSpeedButton *FirstCalEnableBtn;
  TSpeedButton *DummySpeedBtn;
  TTntSpeedButton *ImageClickMode1;
  TTntSpeedButton *ImageClickMode2;
  TGroupBox *PreviewInspectionImageGroupBox;
  TButton *ProcessImageBtn;
  TLabel *Label3;
  TLabel *ProcessingResultLabel;
  TImage *PreviewImage;
  TImage *StretchImage;
  TLabel *Label111;
  TLabel *Label4;
  TSpeedButton *SpeedButton1;
  TSpeedButton *SpeedButton2;
  TTntPageControl *TntPageControl1;
  TTntTabSheet *TntTabSheet1;
  TTntTabSheet *TntTabSheet2;
  TTntGroupBox *TntGroupBox1;
  TTntLabel *TntLabel22;
  TTntLabel *TntLabel25;
  TTntLabel *TntLabel26;
  TTntLabel *TntLabel27;
  TTntLabel *TntLabel28;
  TTntEdit *CutOffLavel;
  TTntEdit *GainLevel;
  TTntEdit *CogThreshold;
  TTntEdit *CogGain;
  TTntEdit *CogOffset;
  TTntButton *btnCOGdefault;
  TTntButton *btnCOGWrite;
  TTntButton *btnCOGRead;
  TTntButton *CaptureStartButton_copy2;
  TTntButton *CaptureStopButton_copy2;
  TTntLabel *TntLabel29;
  TTntLabel *TntLabel30;
  TTntLabel *TntLabel31;
  TTntLabel *CamVerDisk1Copy;
  TTntLabel *CamVerDisk2Copy;
  TTntGroupBox *TntGroupBox2;
  TTntLabel *TntLabel32;
  TTntEdit *Average_1_0;
  TTntLabel *TntLabel33;
  TTntLabel *TntLabel34;
  TTntEdit *Average_2_0;
  TTntEdit *Offset_0;
  TTntEdit *SysGain_0;
  TTntLabel *TntLabel35;
  TTntLabel *TntLabel36;
  TTntLabel *TntLabel37;
  TTntEdit *Average_1_1;
  TTntEdit *Average_1_2;
  TTntEdit *Average_1_3;
  TTntEdit *Average_1_4;
  TTntEdit *Average_1_5;
  TTntEdit *Average_1_6;
  TTntEdit *Average_1_7;
  TTntEdit *Average_1_12;
  TTntEdit *Average_1_13;
  TTntEdit *Average_1_14;
  TTntEdit *Average_1_15;
  TTntEdit *Average_1_8;
  TTntEdit *Average_1_9;
  TTntEdit *Average_1_10;
  TTntEdit *Average_1_11;
  TTntEdit *Average_2_1;
  TTntEdit *Average_2_2;
  TTntEdit *Average_2_3;
  TTntEdit *Average_2_4;
  TTntEdit *Average_2_5;
  TTntEdit *Average_2_6;
  TTntEdit *Average_2_7;
  TTntEdit *Average_2_8;
  TTntEdit *Average_2_9;
  TTntEdit *Average_2_10;
  TTntEdit *Average_2_11;
  TTntEdit *Average_2_12;
  TTntEdit *Average_2_13;
  TTntEdit *Average_2_14;
  TTntEdit *Average_2_15;
  TTntEdit *Offset_1;
  TTntEdit *Offset_2;
  TTntEdit *Offset_3;
  TTntEdit *Offset_4;
  TTntEdit *Offset_5;
  TTntEdit *Offset_6;
  TTntEdit *Offset_7;
  TTntEdit *Offset_8;
  TTntEdit *Offset_9;
  TTntEdit *Offset_10;
  TTntEdit *Offset_11;
  TTntEdit *Offset_12;
  TTntEdit *Offset_13;
  TTntEdit *Offset_14;
  TTntEdit *Offset_15;
  TTntEdit *SysGain_1;
  TTntEdit *SysGain_2;
  TTntEdit *SysGain_3;
  TTntEdit *SysGain_4;
  TTntEdit *SysGain_5;
  TTntEdit *SysGain_6;
  TTntEdit *SysGain_7;
  TTntEdit *SysGain_8;
  TTntEdit *SysGain_9;
  TTntEdit *SysGain_10;
  TTntEdit *SysGain_11;
  TTntEdit *SysGain_12;
  TTntEdit *SysGain_13;
  TTntEdit *SysGain_14;
  TTntEdit *SysGain_15;
  TTntLabel *TntLabel38;
  TTntLabel *TntLabel39;
  TTntLabel *TntLabel40;
  TTntLabel *CamVerDisk1;
  TTntLabel *CamVerDisk2;
  TTntButton *btnAutoGainCal;
  TTntButton *Offset_Max;
  TTntButton *Offset_Avg;
  TTntButton *btnDefaultOffsetMode;
  TTntButton *AutoCalButton;
  TTntButton *AutoCalStopButton;
  TTntButton *defaultParam;
  TTntButton *CaptureStartButton_copy1;
  TTntButton *CaptureStopButton_copy1;
  TTntButton *btnOffsetSet;
  TTntButton *btnOffsetWrite;
  TTntButton *btnOffsetRead;
  TTntButton *btnLogCopy;
  TTntButton *btnChOffsetReset;
  TTntButton *btnSysGainReset;
  TTntButton *btnGainCal;
  TTntCheckBox *chkLogEnable;
  TTntLabel *TntLabel41;
  TTntLabel *TntLabel42;
  TTntLabel *TntLabel43;
  TTntLabel *TntLabel44;
  TTntLabel *TntLabel45;
  TTntLabel *TntLabel46;
  TTntLabel *TntLabel47;
  TTntLabel *TntLabel48;
  TTntLabel *TntLabel49;
  TTntLabel *TntLabel50;
  TTntLabel *TntLabel51;
  TTntLabel *TntLabel52;
  TTntLabel *TntLabel53;
  TTntLabel *TntLabel54;
  TTntEdit *EAutoOffset;
  TTntEdit *EAutoCalCnt;
  TTntEdit *ImageCountEdit;
  TTntComboBox *cbCamCalibMode;
  TTntLabel *TntLabel55;
  TTntLabel *TntLabel56;
  TTntLabel *TntLabel57;
  TTntLabel *TntLabel58;
  TTimer *AutoCalChkTimer;
  TTntLabel *lblRemovePacket;
  TTntGroupBox *TntGroupBox3;
  TTntLabel *TntLabel59;
  TTntComboBox *cb3D_Cam_ADC_Resolution;
  TTntButton *btnWrite3D_Cam_ADC_Res;
  TTntButton *btnRead3D_Cam_ADC_Res;
        TTntLabel *TntLabel60;
        TTntEdit *e3D_LaserGuideGapVal;
        TTntCheckBox *cb3D_LaserGuideEnable;
  
	void __fastcall FormCreate(TObject *Sender);
	void __fastcall CaptureStartButtonClick(TObject *Sender);
	void __fastcall CameraSpeedButtonClick(TObject *Sender);
	void __fastcall CaptureStopButtonClick(TObject *Sender);
	void __fastcall CaptureCheckTimerTimer(TObject *Sender);
	void __fastcall FormDestroy(TObject *Sender);
	void __fastcall CalibrationModeSpeedButtonClick(TObject *Sender);
	void __fastcall ThreeDModeSpeedButtonClick(TObject *Sender);
	void __fastcall CloseButtonClick(TObject *Sender);
	void __fastcall HCBCaptureStartButtonClick(TObject *Sender);
	void __fastcall HCBCaptureStopButtonClick(TObject *Sender);
	void __fastcall NumEditClick(TObject *Sender);
	void __fastcall AdvMachineControlButtonClick(TObject *Sender);
  void __fastcall SetupButtonClick(TObject *Sender);
  void __fastcall cmdNFACameraData2Click(TObject *Sender);
  void __fastcall cmdNFACameraData8Click(TObject *Sender);
  void __fastcall Button1Click(TObject *Sender);
  void __fastcall Button2Click(TObject *Sender);
  void __fastcall ImageClickMode1Click(TObject *Sender);
  void __fastcall ImageClickMode2Click(TObject *Sender);
  void __fastcall CaptureImageMouseDown(TObject *Sender,
          TMouseButton Button, TShiftState Shift, int X, int Y);
  void __fastcall TriggerMethodRadioBox1Click(TObject *Sender);
  void __fastcall TriggerMethodRadioBox2Click(TObject *Sender);
  void __fastcall FirstCalEnableBtnClick(TObject *Sender);
  void __fastcall SaveSpeedButtonClick(TObject *Sender);
  void __fastcall CaptureImageMouseMove(TObject *Sender, TShiftState Shift,
          int X, int Y);
  void __fastcall ProcessImageBtnClick(TObject *Sender);
  void __fastcall SpeedButton1Click(TObject *Sender);
  void __fastcall btnCOGdefaultClick(TObject *Sender);
  void __fastcall btnCOGWriteClick(TObject *Sender);
  void __fastcall btnCOGReadClick(TObject *Sender);
  void __fastcall CaptureStartButton_copy2Click(TObject *Sender);
  void __fastcall CaptureStopButton_copy2Click(TObject *Sender);
  void __fastcall Offset_MaxClick(TObject *Sender);
  void __fastcall Offset_AvgClick(TObject *Sender);
  void __fastcall btnDefaultOffsetModeClick(TObject *Sender);
  void __fastcall btnAutoGainCalClick(TObject *Sender);
  void __fastcall AutoCalButtonClick(TObject *Sender);
  void __fastcall AutoCalStopButtonClick(TObject *Sender);
  void __fastcall defaultParamClick(TObject *Sender);
  void __fastcall CaptureStartButton_copy1Click(TObject *Sender);
  void __fastcall CaptureStopButton_copy1Click(TObject *Sender);
  void __fastcall btnOffsetSetClick(TObject *Sender);
  void __fastcall btnOffsetWriteClick(TObject *Sender);
  void __fastcall btnOffsetReadClick(TObject *Sender);
  void __fastcall btnGainCalClick(TObject *Sender);
  void __fastcall btnSysGainResetClick(TObject *Sender);
  void __fastcall btnChOffsetResetClick(TObject *Sender);
  void __fastcall btnLogCopyClick(TObject *Sender);
  void __fastcall chkLogEnableClick(TObject *Sender);
  void __fastcall AutoCalChkTimerTimer(TObject *Sender);
  void __fastcall btnWrite3D_Cam_ADC_ResClick(TObject *Sender);
  void __fastcall btnRead3D_Cam_ADC_ResClick(TObject *Sender);
    void __fastcall CutOffLavelClick(TObject *Sender);
    void __fastcall GainLevelClick(TObject *Sender);
    void __fastcall CogThresholdClick(TObject *Sender);
    void __fastcall CogGainClick(TObject *Sender);
    void __fastcall CogOffsetClick(TObject *Sender);
        void __fastcall e3D_LaserGuideGapValClick(TObject *Sender);
  void __fastcall TntFormActivate(TObject *Sender);
private:	// User declarations
	TTntImage *DestImage;
	int AreaFrameCaptureWidth, AreaFrameCaptureHeight;
	int LineFrameCaptureWidth, LineFrameCaptureHeight;
	void __fastcall CaptureStart(bool bFrame, bool bFullCapture);
	unsigned int CaptureFirstStartTime;
	unsigned int CaptureStartTime;
	int CaptureCount;
	int ImageSubDirIndex;
	int CurrentImageIndex;
	int GlobalCameraIndex;
	bool bFrameCapture;
	unsigned char *CaptureData;
	bool SaveSpeedValue;
  unsigned char *FullScaleImage;
  int eImageClickEvent;
  ERangerCaptureMode RangerCaptureMode;
  bool FirstCalEnable;
  int Data[MAX_3D_CAMERA_DATA_INDEX];
  unsigned char ScaleConversionImage[AREA_FRAME_WIDTH_RANGER_3D * AREA_FRAME_HEIGHT_RANGER_3D];
  unsigned short ThreeDRAWData[LINE_FRAME_WIDTH_RANGER_3D * LINE_FRAME_HEIGHT_RANGER_3D];
	TPoint MousePos;

  int SaveImageCount;

  int fstThreeDCameraIndex;
  int secThreeDCameraIndex;
  bool bSendSetupData;

  int ProtoTabletCenterX;
  int ProtoTabletCenterY;
  int ProtoTabletCenterZ;

  int MeanNormalVecter[3];
  unsigned int SqrtData[90000];
  short ArcSinData[10001];
  short xyTransData[620*2*40];
  short zTransData[512*2*30];

  int Cos_RotationAngle, Sin_RotationAngle;
  typedef struct
  {
      int px;
      int py;
      int pz;
  }TThreeDPoint;

  bool bImageGrabMode;

  unsigned char HalfTempImage[IMAGE_3D_WIDTH*IMAGE_3D_HEIGHT/2];
  unsigned char HalfShapeData[IMAGE_3D_WIDTH*IMAGE_3D_HEIGHT/2];
  unsigned char HalfShapeBinaryImage[IMAGE_3D_WIDTH*IMAGE_3D_HEIGHT/2];
  unsigned char HalfShrinkShapeBinaryImage[IMAGE_3D_WIDTH*IMAGE_3D_HEIGHT/2];
  unsigned char HalfExtendShapeBinaryImage[IMAGE_3D_WIDTH*IMAGE_3D_HEIGHT/2];
  short HalfLabelImage[IMAGE_3D_WIDTH*IMAGE_3D_HEIGHT/2];
  unsigned char ShapeBinaryImage[640*480];
  unsigned char Temp_ShapeBinaryImage[640*480];
  unsigned char AdjustThreeD_Data[640*480];

  //20201106 cjg added 3d camera param
//20201020 cjg 3D camera param control
	TCaptureCommandParam AutoCal_CaptureCommandParam;
	int flagOffsetMode;
	unsigned int Auto_Cal_Cnt;
    TCamera3D_CalOffsetParam Camera3D_OffsetParamData;
	TCamera3D_CalCOGParam Camera3D_COGParamData;
	T3DCameraVersion SpbCamVer;
	unsigned char ProcessedScaleImage[FULL_SCALE_IMAGE_WIDTH * FULL_SCALE_IMAGE_HEIGHT / 2];
	T3DCamera_ADC_Resolution Camera3D_ADC_Resolution;

	void __fastcall UpdateImageFileList(void);
	void __fastcall SetCameraConfig(int configIndex);
	void __fastcall RefreshSubImage(void);
	void __fastcall RefreshPixelInfo(int X, int Y);
  void __fastcall GetDefaultString(); 

  bool __fastcall ThreeDCameraSetup(int cameraIndex, bool bCali);

  bool __fastcall FristCalConfigRead(int cameraIndex);
  bool __fastcall FristCalConfigWrite(int cameraIndex);
  void __fastcall InitThreeDPrcComponents();
  int __fastcall PreProcessingForThreeD(unsigned char *ThreeD_Image);
  int __fastcall LabellingForTabletImage(short *label_Image, unsigned char *smallSizeBinaryImage, int startX, int endX, int startY, int endY, int imageWidth, int imageHeight);
  int __fastcall FindRotationAxis(unsigned char *ThreeD_Image);
  void __fastcall Adjust_3D_Data(unsigned char *ThreeD_Image);
  void __fastcall FindNormalVecter(int *point1, int *point2, int *point3, int *normalVecter);

  TCommDataLength __fastcall MakeCameraDataPacket(char *code, int cameraIndex, int dataIndex);
  //TCommDataLength __fastcall MakeCameraDataPacket(char *code, int cameraIndex, int dataIndex);
  unsigned char __fastcall TxValueInterpreter(int cameraIndex, int *cameraData, int dIndex);
  bool __fastcall RequestCameraCommand(char *sendData, char *receivedData, unsigned int SendDataLength, unsigned int ReceiveDataLength, int cameraIndex, int highLatencyCmdSW);
  TCommDataLength __fastcall MakeCameraWriteDataPacket(char *code, int cameraIndex, int *cameraData, int dataIndex);
  void __fastcall FlashWrite(int cameraIndex);
  void __fastcall RefreshCameraInfo(int ShutterTime);
  void __fastcall SetDefaultValue(int cameraIndex);
  TCommDataLength __fastcall ReadMakeCameraDataPacket(char *code, int cameraIndex, int dataIndex);
  void __fastcall GetCameraValue(char *buff, int cameraIndex, int dataIndex);
  void __fastcall Doprocessing();
//20201106 cjg added 3d camera param
  void __fastcall TCameraSetting3DForm::SetCaptureDisplaySize();
public:		// User declarations
	__fastcall TCameraSetting3DForm(TComponent* Owner);
  int TimeoutCheck_3D;
  int LineScanTime_3D[2];
};
//---------------------------------------------------------------------------

TCommDataLength gMakeCameraWriteDataPacket(char *code, int cameraIndex, int *cameraData, int dataIndex);
bool gRequestCameraCommand(char *sendData, char *receivedData, unsigned int SendDataLength, unsigned int ReceiveDataLength, int cameraIndex, int highLatencyCmdSW);
void gThreeDCameraSetup(int cameraIndex);
unsigned char gTxValueInterpreter(int cameraIndex, int *cameraData, int dIndex);

extern PACKAGE TCameraSetting3DForm *CameraSetting3DForm;
//---------------------------------------------------------------------------
#endif
