//---------------------------------------------------------------------------

#ifndef AutoBrightnessSetting_FormH
#define AutoBrightnessSetting_FormH
//---------------------------------------------------------------------------
#include <Classes.hpp>
#include <Controls.hpp>
#include <StdCtrls.hpp>
#include <Forms.hpp>
#include <ExtCtrls.hpp>
#include <Buttons.hpp>
#include "TntStdCtrls.hpp"
#include "TntExtCtrls.hpp"
#include "TntButtons.hpp"

#include "Environment.h"
#include "MultiLanguage.h"
#include "common.h"
#include "cpb_module.h"
#include "Message_Form.h"
#include <ComCtrls.hpp>
#include "TntComCtrls.hpp"
#include "Calibration_Form.h"
//---------------------------------------------------------------------------
#define DEFAULT_OBJECT_TRACKING_ST    80
#define DEFAULT_OBJECT_TRACKING_GAIN  1

#define DEFAULT_TARGET_BRIGHTNESS_LEVEL 60

#define DEFAULT_VERTICAL_ACTIVE_CAMERA_INDEX  1
#define DEFAULT_SIDE_ACTIVE_CAMERA_INDEX      3

#define MIN_BRIGHTNESS_LEVEL 40
#define MAX_BRIGHTNESS_LEVEL 170

#define CAMERA_GAIN_SHIFT_SIZE  1
#define BRIGHTNESS_SHIFT_SIZE   5

#define MAX_PROCESSING_STEP   6

#define PROCESSING_STEP_NONE                          0
#define PROCESSING_STEP_GET_BACKGROUND_INFO           1
#define PROCESSING_STEP_GET_OBJECT_INFO               2
#define PROCESSING_STEP_SET_MAIN_CAMERA_BRIGHTNESS    3
#define PROCESSING_STEP_SET_SUB_CAMERA_BRIGHTNESS     4
#define PROCESSING_STEP_CHECK_CAMERA_BRIGHTNESS       5
#define PROCESSING_STEP_COMPLETE                      6

#define HELP_REFRESH_TIME           2
#define CAMERA_INACTIVE_CHECK_TIME  10
#define SERVO_MOTOR_SPEED_STABLE_TIME 6
#define MAX_SERVO_MOTOR_STOPPING_TIME 10

#define MAX_BACKGROUND_STUDY_COUNT 50

#define MAX_OBJECT_COLOR_DIFF 20

#define MAIN_MIN_SHUTTER_SPEED 5
#define SUB_MIN_SHUTTER_SPEED 1
#define MAX_SHUTTER_SPEED 100

#define MIN_DIGITAL_GAIN  1
#define MAX_DIGITAL_GAIN  4

#define MAIN_SHUTTER_SPEED_INCRESEMENT 5
#define SUB_SHUTTER_SPEED_INCRESEMENT 2
#define MAIN_PERMISSIBLE_DIFF_RANGE   4
#define SUB_PERMISSIBLE_DIFF_RANGE    2

#define CAMERA_BRIGHTNESS_CHECK_NONE      0
#define CAMERA_BRIGHTNESS_CHECK_COMPLETED 1
#define CAMERA_BRIGHTNESS_CHECK_FAILED    2

#define MIN_OBJECT_BRIGHTNESS  30
#define CHROMATIC_TABLET_VALUE 40

//---------------------------------------------------------------------------
class TAutoBrightnessSettingForm : public TForm
{
__published:	// IDE-managed Components
  TTntPanel *HelpPanel;
  TTntPanel *ImagePanel;
  TTntGroupBox *GroupBox1;
  TTntGroupBox *GroupBox2;
  TTntImage *CameraImage2;
  TTntImage *CameraImage3;
  TTntImage *CameraImage4;
  TTntImage *CameraImage1;
  TTntImage *CameraImage9;
  TTntImage *CameraImage6;
  TTntImage *CameraImage7;
  TTntImage *CameraImage8;
  TTntImage *CameraImage10;
  TTntImage *CameraImage11;
  TTntImage *CameraImage12;
  TTntImage *CameraImage14;
  TTntImage *CameraImage15;
  TTntImage *CameraImage16;
  TTntLabel *CameraLabel1;
  TTntLabel *CameraLabel9;
  TTntLabel *CameraLabel2;
  TTntLabel *CameraLabel3;
  TTntLabel *CameraLabel4;
  TTntLabel *CameraLabel6;
  TTntLabel *CameraLabel7;
  TTntLabel *CameraLabel8;
  TTntLabel *CameraLabel10;
  TTntLabel *CameraLabel11;
  TTntLabel *CameraLabel14;
  TTntLabel *CameraLabel15;
  TTntLabel *CameraLabel16;
  TTntPanel *Panel1;
  TTntPanel *Panel4;
  TTntGroupBox *GroupBox3;
  TTntLabel *Label15;
  TTntSpeedButton *CameraSpeedButton1;
  TTntSpeedButton *CameraSpeedButton9;
  TTntLabel *Label16;
  TTntSpeedButton *CameraSpeedButton2;
  TTntSpeedButton *CameraSpeedButton3;
  TTntSpeedButton *CameraSpeedButton4;
  TTntSpeedButton *CameraSpeedButton6;
  TTntSpeedButton *CameraSpeedButton7;
  TTntSpeedButton *CameraSpeedButton8;
  TTntSpeedButton *CameraSpeedButton10;
  TTntSpeedButton *CameraSpeedButton11;
  TTntSpeedButton *CameraSpeedButton12;
  TTntSpeedButton *CameraSpeedButton14;
  TTntSpeedButton *CameraSpeedButton15;
  TTntSpeedButton *CameraSpeedButton16;
  TTntGroupBox *GroupBox4;
  TTntPanel *CameraResulrMenuPanel;
  TTntPanel *Panel3;
  TTntPanel *Panel5;
  TTntPanel *Panel6;
  TTntPanel *Panel7;
  TTntPanel *CameraNamePanel1;
  TTntPanel *CameraNamePanel2;
  TTntPanel *CameraNamePanel3;
  TTntPanel *CameraNamePanel4;
  TTntPanel *CameraNamePanel6;
  TTntPanel *CameraNamePanel7;
  TTntPanel *CameraNamePanel9;
  TTntPanel *CameraNamePanel8;
  TTntPanel *CameraNamePanel10;
  TTntPanel *CameraNamePanel11;
  TTntPanel *CameraNamePanel12;
  TTntPanel *CameraNamePanel16;
  TTntPanel *CameraNamePanel15;
  TTntPanel *CameraNamePanel14;
  TTntPanel *Panel22;
  TTntPanel *Panel23;
  TTntPanel *Panel24;
  TTntPanel *Panel25;
  TTntPanel *Panel26;
  TTntPanel *Panel27;
  TTntPanel *Panel28;
  TTntPanel *Panel29;
  TTntPanel *Panel30;
  TTntPanel *Panel31;
  TTntPanel *Panel32;
  TTntPanel *Panel33;
  TTntPanel *Panel34;
  TTntPanel *CameraStatusPanel1;
  TTntPanel *CameraStatusPanel2;
  TTntPanel *CameraStatusPanel3;
  TTntPanel *CameraStatusPanel4;
  TTntPanel *CameraStatusPanel6;
  TTntPanel *CameraStatusPanel7;
  TTntPanel *CameraStatusPanel8;
  TTntPanel *CameraStatusPanel9;
  TTntPanel *CameraStatusPanel10;
  TTntPanel *CameraStatusPanel11;
  TTntPanel *CameraStatusPanel12;
  TTntPanel *CameraStatusPanel14;
  TTntPanel *CameraStatusPanel15;
  TTntPanel *CameraStatusPanel16;
  TTntPanel *CameraShutterSpeedPanel1;
  TTntPanel *CameraShutterSpeedPanel2;
  TTntPanel *CameraShutterSpeedPanel3;
  TTntPanel *CameraShutterSpeedPanel4;
  TTntPanel *CameraShutterSpeedPanel6;
  TTntPanel *CameraShutterSpeedPanel7;
  TTntPanel *CameraShutterSpeedPanel8;
  TTntPanel *CameraShutterSpeedPanel9;
  TTntPanel *CameraShutterSpeedPanel10;
  TTntPanel *CameraShutterSpeedPanel11;
  TTntPanel *CameraShutterSpeedPanel12;
  TTntPanel *CameraShutterSpeedPanel14;
  TTntPanel *CameraShutterSpeedPanel15;
  TTntPanel *CameraShutterSpeedPanel16;
  TTntPanel *CameraGainPanel1;
  TTntPanel *CameraGainPanel2;
  TTntPanel *CameraGainPanel3;
  TTntPanel *CameraGainPanel4;
  TTntPanel *CameraGainPanel6;
  TTntPanel *CameraGainPanel7;
  TTntPanel *CameraGainPanel8;
  TTntPanel *CameraGainPanel9;
  TTntPanel *CameraGainPanel10;
  TTntPanel *CameraGainPanel11;
  TTntPanel *CameraGainPanel12;
  TTntPanel *CameraGainPanel14;
  TTntPanel *CameraGainPanel15;
  TTntPanel *CameraGainPanel16;
  TTntButton *StartButton;
  TTntButton *CloseButton;
  TTntButton *StopButton;
  TTntGroupBox *GroupBox5;
  TTntLabel *Label17;
  TTntLabel *Label18;
  TTntPanel *Panel2;
  TTntPanel *CameraBrightnessLevelPanel9;
  TTntPanel *CameraBrightnessLevelPanel8;
  TTntPanel *CameraBrightnessLevelPanel7;
  TTntPanel *CameraBrightnessLevelPanel6;
  TTntPanel *CameraBrightnessLevelPanel4;
  TTntPanel *CameraBrightnessLevelPanel3;
  TTntPanel *CameraBrightnessLevelPanel2;
  TTntPanel *CameraBrightnessLevelPanel16;
  TTntPanel *CameraBrightnessLevelPanel15;
  TTntPanel *CameraBrightnessLevelPanel14;
  TTntPanel *CameraBrightnessLevelPanel12;
  TTntPanel *CameraBrightnessLevelPanel11;
  TTntPanel *CameraBrightnessLevelPanel10;
  TTntPanel *CameraBrightnessLevelPanel1;
  TTntButton *Down1;
  TTntButton *Up1;
  TTntButton *Down2;
  TTntButton *Up2;
  TTntPanel *CameraGainForTabletRecognizationPanel;
  TTntPanel *TabletDefaultBrighnessPanel;
  TTimer *helpTimer;
  TTntGroupBox *TntGroupBox1;
  TTntLabel *TntLabel1;
  TTntLabel *TntLabel2;
  TTntEdit *ShutterDelayEdit;
  TTntEdit *LedOnTimeEdit;
  TTntEdit *FrameTimeEdit;
  TTntLabel *TntLabel3;
  TTimer *ImageLoadTimer;
  TProgressBar *ProgressBarCam1;
  TProgressBar *ProgressBarCam9;
  TProgressBar *ProgressBarCam2;
  TProgressBar *ProgressBarCam3;
  TProgressBar *ProgressBarCam4;
  TProgressBar *ProgressBarCam6;
  TProgressBar *ProgressBarCam7;
  TProgressBar *ProgressBarCam8;
  TProgressBar *ProgressBarCam10;
  TProgressBar *ProgressBarCam11;
  TProgressBar *ProgressBarCam12;
  TProgressBar *ProgressBarCam14;
  TProgressBar *ProgressBarCam15;
  TProgressBar *ProgressBarCam16;
  TCheckBox *ViewBgmImageCheckBox;
  TTntLabel *CameraBrightnessValuePanel9;
  TTntLabel *CameraBrightnessValuePanel1;
  TTntLabel *CameraBrightnessValuePanel2;
  TTntLabel *CameraBrightnessValuePanel3;
  TTntLabel *CameraBrightnessValuePanel4;
  TTntLabel *CameraBrightnessValuePanel6;
  TTntLabel *CameraBrightnessValuePanel7;
  TTntLabel *CameraBrightnessValuePanel8;
  TTntLabel *CameraBrightnessValuePanel10;
  TTntLabel *CameraBrightnessValuePanel11;
  TTntLabel *CameraBrightnessValuePanel12;
  TTntLabel *CameraBrightnessValuePanel14;
  TTntLabel *CameraBrightnessValuePanel15;
  TTntLabel *CameraBrightnessValuePanel16;
  TTntLabel *CameraLabel12;
  TCheckBox *SimulationCheckBox;
  TCheckBox *SaveBmpCheckBox;
  TLabel *Label11;
  TEdit *ImageRootEdit;
  TBitBtn *BitBtn1;
  TTntUpDown *TntUpDown2;
  TCheckBox *ViewOptionCheckBox;
  TCheckBox *ApplyAverageValueCheckBox;
  TTntLabel *HelpLabel;
  TTntPanel *MachineControlPanel;
  void __fastcall FormCreate(TObject *Sender);
  void __fastcall CloseButtonClick(TObject *Sender);
  void __fastcall CameraSpeedButton1Click(TObject *Sender);
  void __fastcall CameraSpeedButton2Click(TObject *Sender);
  void __fastcall Up1Click(TObject *Sender);
  void __fastcall Down1Click(TObject *Sender);
  void __fastcall Up2Click(TObject *Sender);
  void __fastcall Down2Click(TObject *Sender);
  void __fastcall StartButtonClick(TObject *Sender);
  void __fastcall StopButtonClick(TObject *Sender);
  void __fastcall helpTimerTimer(TObject *Sender);
  void __fastcall FrameTimeEditClick(TObject *Sender);
  void __fastcall ImageLoadTimerTimer(TObject *Sender);
  void __fastcall GroupBox3DblClick(TObject *Sender);
  void __fastcall HelpPanelDblClick(TObject *Sender);
  void __fastcall BitBtn1Click(TObject *Sender);
  void __fastcall TntUpDown2Click(TObject *Sender, TUDBtnType Button);
private:	// User declarations
  void __fastcall SetActiveComponents(bool bActive);
  void __fastcall InitResultComponent();
  void __fastcall RefeshAcitveCamera();
  bool __fastcall SendSPBCaptureSetup(void);
  void __fastcall RefreshCameraInfo(int cameraIndex);
  void __fastcall RefreshCameraBrightnessParams();
  void __fastcall CaptureStop();
  void __fastcall RefreshEnabledCamera();
  void __fastcall RefreshInactiveCameraComponent();
  void __fastcall MachineControl();
  void __fastcall InitImageBuffer();
  void __fastcall AccBackgroundImage(TTntImage *srcImage, int cameraIndex);
  void __fastcall GetBackgroundImage(int cameraIndex);
  void __fastcall ViewBackgroundImage(TTntImage *DestImage, int cameraIndex);
  void __fastcall SetFrontFaceObjectArea(TTntImage *srcImage, int cameraIndex);
  void __fastcall SetSideFaceObjectArea(TTntImage *srcImage, int cameraIndex);
  int __fastcall LabellingForTabletImage(short *label_Image, unsigned char *smallSizeBinaryImage, int startX, int endX, int startY, int endY, int imageWidth, int imageHeight);
  void __fastcall CheckTabletBrightness(TTntImage *srcImage, int cameraIndex);
  void __fastcall ViewTabletBrightness(TTntImage *srcImage, int cameraIndex);
  void __fastcall SetBrightnessCheckingResult();

  void __fastcall Erode(unsigned char *srcImage, unsigned char *dstImage, int startX, int endX, int startY, int endY, int maskSize);
  void __fastcall Dilate(unsigned char *srcImage, unsigned char *dstImage, int startX, int endX, int startY, int endY, int maskSize);

  int ActiveVerticalCameraIndex;
  int ActiveSideCameraIndex;

  int processingStep;
  bool bGlobalStopSW;

  WideString helpString[MAX_PROCESSING_STEP];
  WideString TextMsgString[20];
  double lastRefreshTime;
  double cameraActiveCheckTime[SYSTEM_TOTAL_CAMERA_COUNT];
  TColor helpColor[2];
  int helpStatus;

  int ShutterSpeedList[SYSTEM_TOTAL_CAMERA_COUNT];
  int DigitalGainList[SYSTEM_TOTAL_CAMERA_COUNT];

  bool globalStudySW;
  bool ImageCaptureActiveCamera[SYSTEM_TOTAL_CAMERA_COUNT];
  bool CameraComponentInitSW[SYSTEM_TOTAL_CAMERA_COUNT];

  unsigned char CaptureData[MAX_IMAGE_WIDTH * MAX_IMAGE_HEIGHT];

  unsigned char smallBinaryImage[(MAX_IMAGE_WIDTH / 2) * (MAX_IMAGE_HEIGHT / 2)];
  short HalfLabelImage[(MAX_IMAGE_WIDTH / 2) * (MAX_IMAGE_HEIGHT / 2)];

  int BackgroundImageStudyCount[SYSTEM_TOTAL_CAMERA_COUNT];
  unsigned int BackgroundImage[SYSTEM_TOTAL_CAMERA_COUNT][MAX_IMAGE_WIDTH * MAX_IMAGE_HEIGHT * 3];
  unsigned char ObjectAreaImage[SYSTEM_TOTAL_CAMERA_COUNT][MAX_IMAGE_WIDTH * MAX_IMAGE_HEIGHT];

  short sideCenterPosData[SYSTEM_TOTAL_CAMERA_COUNT][MAX_IMAGE_WIDTH * 2];
  int sideCenterPosDataCount[SYSTEM_TOTAL_CAMERA_COUNT];

  short ColorRateImageOstArr[MAX_IMAGE_WIDTH * MAX_IMAGE_HEIGHT * 3];
  unsigned char maxRGBFactorSrcArry[MAX_IMAGE_WIDTH * MAX_IMAGE_HEIGHT];
  unsigned char maxRGBFactorOstArry[MAX_IMAGE_WIDTH * MAX_IMAGE_HEIGHT];

  bool fstStep[SYSTEM_TOTAL_CAMERA_COUNT];
  int currentShutterSpeed[SYSTEM_TOTAL_CAMERA_COUNT];
  int currentDigitalGain[SYSTEM_TOTAL_CAMERA_COUNT];

  int MinBrightnessLevel[SYSTEM_TOTAL_CAMERA_COUNT];
  int CameraBrightness[SYSTEM_TOTAL_CAMERA_COUNT];
  int StudyShutterSpeed[SYSTEM_TOTAL_CAMERA_COUNT];
  int StudyDigitalGain[SYSTEM_TOTAL_CAMERA_COUNT];
  int brightnessStudyCompleted[SYSTEM_TOTAL_CAMERA_COUNT];
  bool checkedSW[SYSTEM_TOTAL_CAMERA_COUNT];

  int stdCount[SYSTEM_TOTAL_CAMERA_COUNT];

  int objStartNum[SYSTEM_TOTAL_CAMERA_COUNT];
  int objEndNum[SYSTEM_TOTAL_CAMERA_COUNT];

  int continuousBrightnessOverCount[SYSTEM_TOTAL_CAMERA_COUNT];

public:		// User declarations
  __fastcall TAutoBrightnessSettingForm(TComponent* Owner);

  bool bExecutionBrightnessStudy;
};
//---------------------------------------------------------------------------
extern PACKAGE TAutoBrightnessSettingForm *AutoBrightnessSettingForm;
//---------------------------------------------------------------------------
#endif
