//---------------------------------------------------------------------------
// For SELMA200, 20180227, moon, Ϸ(Ȯ)
//   ̹ Կ ϸ鼭 Image Container  Ȯغʿ
//---------------------------------------------------------------------------

#include <vcl.h>
#include <inifiles.hpp>
#pragma hdrstop

#include "Calibration_Form.h"
#include "Message_Form.h"
#include "Bayer.h"

#include "Capture_Form.h"
#include "Waiting_Form.h"
#include "Keyboard_Form.h"
#include "Calibration3D_Form.h"
#include "CameraSetting3D_Form.h"
#include "ThreeDImageViewer_Form.h"
#include "MultiLanguage.h"
#include "SpeedControl_Form.h"
#include "StudySpeedControl_Form.h"
#include "AutoBrightnessSetting_Form.h"
#include "ComputerSystemSetting_Form.h"
#include "Environment.h"
#include <windows.h>
#include <process.h>
#include <io.h>
#include <conio.h>
//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma link "CGAUGES"
#pragma link "TntButtons"
#pragma link "TntComCtrls"
#pragma link "TntExtCtrls"
#pragma link "TntStdCtrls"
#pragma link "CGAUGES"
#pragma link "TntButtons"
#pragma link "TntComCtrls"
#pragma link "TntExtCtrls"
#pragma link "TntStdCtrls"
#pragma resource "*.dfm"

static int ImageSelect;
TCalibrationForm* CalibrationForm;
//---------------------------------------------------------------------------  Լ
DWORD ThreadDword = 0;
HANDLE ImageSaveThreadHandle;
HANDLE ImageViewThreadHandle;
//---------------------------------------------------------------------------- ̹ ó
unsigned int WINAPI ImageConvertSaveThread(PVOID pData)
{
	TCalibrationForm* CalibForm = (TCalibrationForm*)pData;
	TFileStream* ImgStream;
	unsigned char* captureData = new char[(CalibForm->CaptureWidth + 1) * (CalibForm->CaptureHeight + 1)];     // bayer    д.
	AnsiString filename;
	AnsiString Savefilename;
	while (CalibForm->ImgSaveThreadController)
	{
		if (CalibForm->ImgSaveDataCount == 100) break;

		for (int ImageIndex = 0; ImageIndex < 100; ++ImageIndex)
		{
			CalibForm->CaptureFileContainer[ImageIndex]->Create(GetProductImagePath() + "\\Image" + IntToStr(ImageIndex + 1) + ".FAC", 16);
			for (int CameraIndex = 0; CameraIndex < 16; ++CameraIndex)
			{
				filename = GetProductImagePath() + "\\Image" + IntToStr(ImageIndex + 1) + "_";
				filename += IntToStr(CameraIndex + 1) + ".fbm";
				Savefilename = "Image" + IntToStr(ImageIndex + 1) + "_" + IntToStr(CameraIndex + 1) + ".fbm";
				try
				{
					if (CameraMapInfo[CameraIndex].CameraInspectPosition < CAMERA_POSITION_DISCONNECT && SystemLinkCameraInfo[CameraIndex] != 0)
					{
						ImgStream = new TFileStream(filename, fmOpenRead);
						if (ImgStream)
						{
							ImgStream->Read(captureData, sizeof(unsigned char) * ((CalibForm->CaptureWidth + 1) * (CalibForm->CaptureHeight + 1)));
							if (CameraMapInfo[CameraIndex].CameraInspectPosition == CAMERA_POSITION_3D)
							{
								CalibForm->CaptureFileContainer[ImageIndex]->SaveBitmapData(Savefilename, ECM_ZIP, captureData, CalibForm->CaptureWidth_3D, CalibForm->CaptureHeight_3D, 8, CameraIndex, EBK_3D);
							}
							else
							{
								CalibForm->CaptureFileContainer[ImageIndex]->SaveBitmapData(Savefilename, ECM_ZIP, captureData, CalibForm->CaptureWidth, CalibForm->CaptureHeight, 8, CameraIndex);
							}

							delete ImgStream;
						}
					}
				}
				catch (...)
				{
				}
			}
			CalibForm->CaptureFileContainer[ImageIndex]->Close();

			AnsiString Path = GetProductImagePath() + "\\Image" + IntToStr(ImageIndex + 1) + ".FAC";
			int Size = -1;
			//int ss[100] = {0};
			//int Count = 0;
			while (true)
			{
				std::ifstream ifs(Path.c_str(), std::ios::in | std::ios::binary);
				int size = 0;
				if (ifs.is_open() == 0)
				{
				}
				else
				{
					ifs.seekg(0, std::ios::end);
					size = ifs.tellg();
					if (Size != size)
					{
						//ss[Count] = size;
						Size = size;
					}
					else
						break;
				}
			}

			CalibForm->ImgSaveDataCount++;
			Sleep(1);
		}
	}

	_endthreadex(0);
	return true;
}
//---------------------------------------------------------------------------- ̹ ó
unsigned int WINAPI ImageViewThread(PVOID pData)
{
	TCalibrationForm* CalibForm = (TCalibrationForm*)pData;
	TTntImage* DestImg;
	CalibForm->CurrentImgViewCount = 1;
	Graphics::TBitmap* SrcImg = new Graphics::TBitmap;
	while (CalibForm->ImgViewThreadController)
	{
		if (CalibForm->ImgSaveDataCount < 20) continue;
		if (CalibForm->CurrentImgViewCount >= 100) break;
		if (CalibForm->ImgSaveDataCount < CalibForm->CurrentImgViewCount) continue;

		for (int i = 0; i < 16; ++i)
		{
			//Graphics::TBitmap *SrcImg= new Graphics::TBitmap;
			SrcImg->Width = CalibForm->CaptureWidth;
			SrcImg->Height = CalibForm->CaptureHeight;
			if (CameraMapInfo[i].CameraInspectPosition == CAMERA_POSITION_3D)
			{
				SrcImg->PixelFormat = pf8bit;
			}
			else
			{
				SrcImg->PixelFormat = pf24bit;
			}

			DestImg = CalibForm->GetImagePanelPointer(i);

			if (ExtractImage(SrcImg, CalibForm->CurrentImgViewCount, i + 1, SystemImageOffsetSWCal[i], SystemOffsetImage[i], ProductData.SubSamplingMode))
			{
				if (CameraMapInfo[i].CameraInspectPosition == CAMERA_POSITION_3D)
				{
					Set3DPalette(DestImg->Picture->Bitmap);
					DestImg->Picture->Assign(SrcImg);
					Set3DPalette(DestImg->Picture->Bitmap);
					//DestImg->Picture->Bitmap->FreeImage();
					for (int y = 0; y < DestImg->Picture->Bitmap->Height; y++)
					{
						byte* pSrc = (byte*)SrcImg->ScanLine[y];
						byte* pDst = (byte*)DestImg->Picture->Bitmap->ScanLine[y];
						memset(pDst, 0, DestImg->Picture->Bitmap->Width);
						for (int x = 4; x < DestImg->Picture->Bitmap->Width - 4; x++)
						{
							// 3d conv
							pDst[x] = pSrc[x];
						}

						byte* pTemp = new byte[DestImg->Picture->Bitmap->Width];
						memcpy(pTemp, pDst, DestImg->Picture->Bitmap->Width);
						for (int x = DestImg->Picture->Bitmap->Width - 2; x >= 2; x--)
						{
							if (pTemp[x] == 0)
							{
								if (pDst[x - 1] == 0)
								{
									pTemp[x] = pDst[x + 1];
								}
								else
								{
									pTemp[x] = min(pDst[x - 1], pDst[x + 1]);
								}
							}
						}
						memcpy(pDst, pTemp, DestImg->Picture->Bitmap->Width);
						delete[] pTemp;
					}
					DestImg->Update();
					Sleep(10);
					//CalibForm->AssinForm3DImage(SrcImg,DestImg);
				}
				else
				{
					//DestImg->Picture->Bitmap->Assign(SrcImg);
					CalibForm->AssinFormImage(SrcImg, i);
					CalibForm->RepaintFormImage(i);
					Sleep(10);
				}
			}

		}

		CalibForm->CurrentImgViewCount++;
	}

	_endthreadex(0);
	return true;
}
void __fastcall TCalibrationForm::AssinForm3DImage(Graphics::TBitmap* SrcImg, TTntImage* DestImg)
{
	for (int y = 0; y < DestImg->Picture->Bitmap->Height; y++)
	{
		byte* pSrc = (byte*)SrcImg->ScanLine[y];
		byte* pDst = (byte*)DestImg->Picture->Bitmap->ScanLine[y];
		memset(pDst, 0, DestImg->Picture->Bitmap->Width);
		for (int x = 4; x < DestImg->Picture->Bitmap->Width - 4; x++)
		{
			// 3d conv
			pDst[x] = pSrc[x];
		}

		byte* pTemp = new byte[DestImg->Picture->Bitmap->Width];
		memcpy(pTemp, pDst, DestImg->Picture->Bitmap->Width);
		for (int x = DestImg->Picture->Bitmap->Width - 2; x >= 2; x--)
		{
			if (pTemp[x] == 0)
			{
				if (pDst[x - 1] == 0)
				{
					pTemp[x] = pDst[x + 1];
				}
				else
				{
					pTemp[x] = min(pDst[x - 1], pDst[x + 1]);
				}
			}
		}
		memcpy(pDst, pTemp, DestImg->Picture->Bitmap->Width);
		delete[] pTemp;
	}

}
void __fastcall TCalibrationForm::AssinFormImage(Graphics::TBitmap* NewImg, int Cameraindex)
{
	TTntImage* pImg = (TTntImage*)FindComponent("CaptureImage" + IntToStr(Cameraindex + 1));
	pImg->Picture->Bitmap->Assign(NewImg);
}
void __fastcall TCalibrationForm::RepaintFormImage(int Cameraindex)
{
	TTntImage* pImg = (TTntImage*)FindComponent("CaptureImage" + IntToStr(Cameraindex + 1));
	pImg->Update();
}
//----------------------------------------------------------------------------------------
__fastcall TCalibrationForm::TCalibrationForm(TComponent* Owner)
	: TTntForm(Owner)
{
	if (DefaultLCID == 1028 || DefaultLCID == 2052 || DefaultLCID == 3076 || DefaultLCID == 4100)
		ComponentSetFontName(this, "SimSun");
	else if (DefaultLCID == 1041)
		ComponentSetFontName(this, "Meiryo UI");
  else if(DefaultLCID == 3082)
  {
    ComponentSetFontName(this, "Segoe UI");
    ComponentSetMultiLine(this);
  }

	GetDefaultString();

	if (ProductData.SubSamplingMode == 0)
	{
		CaptureWidth = SYSTEM_CAMERA_WIDTH;
		CaptureHeight = SYSTEM_CAMERA_HEIGHT;
		CaptureImgWidth = SYSTEM_CAMERA_WIDTH / 2;
		CaptureImgHeight = SYSTEM_CAMERA_HEIGHT / 2;
	}
	else
	{
		CaptureWidth = SYSTEM_CAMERA_HD_WIDTH;
		CaptureHeight = SYSTEM_CAMERA_HD_HEIGHT;
		CaptureImgWidth = SYSTEM_CAMERA_HD_WIDTH / 4;
		CaptureImgHeight = SYSTEM_CAMERA_HD_HEIGHT / 4;
	}

	CaptureData = NULL;

	CaptureWidth_3D = SYSTEM_CAMERA_WIDTH_3D;
	CaptureHeight_3D = SYSTEM_CAMERA_HEIGHT_3D;

	DestImage = CaptureImage1;

	// 3D Image Panel
	CaptureImage5->Width = IMAGE_WIDTH_3D * 2 / 2;
	CaptureImage5->Height = IMAGE_HEIGHT_3D / 2;
	CaptureImage5->Picture->Bitmap->Width = IMAGE_WIDTH_3D;
	CaptureImage5->Picture->Bitmap->Height = IMAGE_HEIGHT_3D;
	CaptureImage5->Picture->Bitmap->PixelFormat = pf8bit;
	Set3DPalette(CaptureImage5->Picture->Bitmap);

	CaptureImage13->Width = IMAGE_WIDTH_3D * 2 / 2;
	CaptureImage13->Height = IMAGE_HEIGHT_3D / 2;
	CaptureImage13->Picture->Bitmap->Width = IMAGE_WIDTH_3D;
	CaptureImage13->Picture->Bitmap->Height = IMAGE_HEIGHT_3D;
	CaptureImage13->Picture->Bitmap->PixelFormat = pf8bit;
	Set3DPalette(CaptureImage13->Picture->Bitmap);

	// 2D Front Face Image Panel
	CaptureImage1->Width = CaptureImgWidth;
	CaptureImage1->Height = CaptureImgHeight;
	CaptureImage1->Picture->Bitmap->Width = CaptureWidth;
	CaptureImage1->Picture->Bitmap->Height = CaptureHeight;
	CaptureImage1->Picture->Bitmap->PixelFormat = pf24bit;

	CaptureImage1_Option->Width = CaptureImgWidth;
	CaptureImage1_Option->Height = CaptureImgHeight;
	CaptureImage1_Option->Picture->Bitmap->Width = CaptureWidth;
	CaptureImage1_Option->Picture->Bitmap->Height = CaptureHeight;
	CaptureImage1_Option->Picture->Bitmap->PixelFormat = pf24bit;

	CaptureImage9->Width = CaptureImgWidth;
	CaptureImage9->Height = CaptureImgHeight;
	CaptureImage9->Picture->Bitmap->Width = CaptureWidth;
	CaptureImage9->Picture->Bitmap->Height = CaptureHeight;
	CaptureImage9->Picture->Bitmap->PixelFormat = pf24bit;

	CaptureImage9_Option->Width = CaptureImgWidth;
	CaptureImage9_Option->Height = CaptureImgHeight;
	CaptureImage9_Option->Picture->Bitmap->Width = CaptureWidth;
	CaptureImage9_Option->Picture->Bitmap->Height = CaptureHeight;
	CaptureImage9_Option->Picture->Bitmap->PixelFormat = pf24bit;

	// 2D Side Face Image Panel
	CaptureImage2->Width = CaptureImgWidth;
	CaptureImage2->Height = CaptureImgHeight;
	CaptureImage2->Picture->Bitmap->Width = CaptureWidth;
	CaptureImage2->Picture->Bitmap->Height = CaptureHeight;
	CaptureImage2->Picture->Bitmap->PixelFormat = pf24bit;

	CaptureImage3->Width = CaptureImgWidth;
	CaptureImage3->Height = CaptureImgHeight;
	CaptureImage3->Picture->Bitmap->Width = CaptureWidth;
	CaptureImage3->Picture->Bitmap->Height = CaptureHeight;
	CaptureImage3->Picture->Bitmap->PixelFormat = pf24bit;

	CaptureImage4->Width = CaptureImgWidth;
	CaptureImage4->Height = CaptureImgHeight;
	CaptureImage4->Picture->Bitmap->Width = CaptureWidth;
	CaptureImage4->Picture->Bitmap->Height = CaptureHeight;
	CaptureImage4->Picture->Bitmap->PixelFormat = pf24bit;

	CaptureImage6->Width = CaptureImgWidth;
	CaptureImage6->Height = CaptureImgHeight;
	CaptureImage6->Picture->Bitmap->Width = CaptureWidth;
	CaptureImage6->Picture->Bitmap->Height = CaptureHeight;
	CaptureImage6->Picture->Bitmap->PixelFormat = pf24bit;

	CaptureImage7->Width = CaptureImgWidth;
	CaptureImage7->Height = CaptureImgHeight;
	CaptureImage7->Picture->Bitmap->Width = CaptureWidth;
	CaptureImage7->Picture->Bitmap->Height = CaptureHeight;
	CaptureImage7->Picture->Bitmap->PixelFormat = pf24bit;

	CaptureImage8->Width = CaptureImgWidth;
	CaptureImage8->Height = CaptureImgHeight;
	CaptureImage8->Picture->Bitmap->Width = CaptureWidth;
	CaptureImage8->Picture->Bitmap->Height = CaptureHeight;
	CaptureImage8->Picture->Bitmap->PixelFormat = pf24bit;

	CaptureImage10->Width = CaptureImgWidth;
	CaptureImage10->Height = CaptureImgHeight;
	CaptureImage10->Picture->Bitmap->Width = CaptureWidth;
	CaptureImage10->Picture->Bitmap->Height = CaptureHeight;
	CaptureImage10->Picture->Bitmap->PixelFormat = pf24bit;

	CaptureImage11->Width = CaptureImgWidth;
	CaptureImage11->Height = CaptureImgHeight;
	CaptureImage11->Picture->Bitmap->Width = CaptureWidth;
	CaptureImage11->Picture->Bitmap->Height = CaptureHeight;
	CaptureImage11->Picture->Bitmap->PixelFormat = pf24bit;

	CaptureImage12->Width = CaptureImgWidth;
	CaptureImage12->Height = CaptureImgHeight;
	CaptureImage12->Picture->Bitmap->Width = CaptureWidth;
	CaptureImage12->Picture->Bitmap->Height = CaptureHeight;
	CaptureImage12->Picture->Bitmap->PixelFormat = pf24bit;

	CaptureImage14->Width = CaptureImgWidth;
	CaptureImage14->Height = CaptureImgHeight;
	CaptureImage14->Picture->Bitmap->Width = CaptureWidth;
	CaptureImage14->Picture->Bitmap->Height = CaptureHeight;
	CaptureImage14->Picture->Bitmap->PixelFormat = pf24bit;

	CaptureImage15->Width = CaptureImgWidth;
	CaptureImage15->Height = CaptureImgHeight;
	CaptureImage15->Picture->Bitmap->Width = CaptureWidth;
	CaptureImage15->Picture->Bitmap->Height = CaptureHeight;
	CaptureImage15->Picture->Bitmap->PixelFormat = pf24bit;

	CaptureImage16->Width = CaptureImgWidth;
	CaptureImage16->Height = CaptureImgHeight;
	CaptureImage16->Picture->Bitmap->Width = CaptureWidth;
	CaptureImage16->Picture->Bitmap->Height = CaptureHeight;
	CaptureImage16->Picture->Bitmap->PixelFormat = pf24bit;


	CaptureBitmap = new Graphics::TBitmap;
	CaptureBitmap->Width = CaptureWidth;
	CaptureBitmap->Height = CaptureHeight;
	CaptureBitmap->PixelFormat = pf24bit;

	if (CaptureData != NULL)
	{
		delete[] CaptureData;
	}
	CaptureData = new char[(CaptureWidth + 1) * (CaptureHeight + 1)];     // bayer    д.

	ImageNumberUpDown->Max = MAX_CAPTURE_IMAGE_COUNT;

	for (int globalCameraIndex = 0; globalCameraIndex < SYSTEM_TOTAL_CAMERA_COUNT; globalCameraIndex++)
	{
		BoundaryArea[globalCameraIndex].left = 0;
		BoundaryArea[globalCameraIndex].right = SYSTEM_CAMERA_WIDTH;
		BoundaryArea[globalCameraIndex].top = 0;
		BoundaryArea[globalCameraIndex].bottom = SYSTEM_CAMERA_HEIGHT;
		DiscCenterPos[globalCameraIndex].x = 0;
		DiscCenterPos[globalCameraIndex].y = 0;
	}

	for (int globalCameraIndex = 0; globalCameraIndex < SYSTEM_TOTAL_CAMERA_COUNT; globalCameraIndex++)
	{
		CameraShutterSpeedList[globalCameraIndex] = ProductData.ShutterSpeed[globalCameraIndex];
		CameraGainList[globalCameraIndex] = ProductData.DigitalGainV[globalCameraIndex];
	}

	ActivePanel = NULL;
	ImagePanel->DoubleBuffered = true;
	IsBoundarySettingMode = false;
	CaptureState = ECS_NONE;

	for (int imageIndex = 0; imageIndex < MAX_CAPTURE_IMAGE_COUNT; imageIndex++)
	{
		//		CaptureFileContainer[imageIndex] = new TFileContainer(SYSTEM_TOTAL_CAMERA_COUNT + 2);		// 10 cameras + 2 optional capture
		CaptureFileContainer[imageIndex] = new TFileContainer;
	}

	//	TempCaptureFileContainer = new TFileContainer(MAX_CAPTURE_IMAGE_COUNT * (SYSTEM_TOTAL_CAMERA_COUNT + 2));
	TempCaptureFileContainer = new TFileContainer;

	SensorIntervalImage1->Picture->Bitmap->Width = SensorIntervalImage1->Width;
	SensorIntervalImage1->Picture->Bitmap->Height = SensorIntervalImage1->Height;
	SensorIntervalImage1->Picture->Bitmap->PixelFormat = pf24bit;

	SensorIntervalImage2->Picture->Bitmap->Width = SensorIntervalImage2->Width;
	SensorIntervalImage2->Picture->Bitmap->Height = SensorIntervalImage2->Height;
	SensorIntervalImage2->Picture->Bitmap->PixelFormat = pf24bit;

	SensorLengthImage1->Picture->Bitmap->Width = SensorLengthImage1->Width;
	SensorLengthImage1->Picture->Bitmap->Height = SensorLengthImage1->Height;
	SensorLengthImage1->Picture->Bitmap->PixelFormat = pf24bit;

	SensorLengthImage2->Picture->Bitmap->Width = SensorLengthImage2->Width;
	SensorLengthImage2->Picture->Bitmap->Height = SensorLengthImage2->Height;
	SensorLengthImage2->Picture->Bitmap->PixelFormat = pf24bit;

	SensorLengthImage3->Picture->Bitmap->Width = SensorLengthImage3->Width;
	SensorLengthImage3->Picture->Bitmap->Height = SensorLengthImage3->Height;
	SensorLengthImage3->Picture->Bitmap->PixelFormat = pf24bit;

	if (MachineSetupData.SimpleSpeedControlOption)
	{
		TStudySpeedControlForm* studyspeedControlForm = new TStudySpeedControlForm(this);
		studyspeedControlForm->ApplyMachineSpeedButton->Click();
		delete studyspeedControlForm;
	}
}
void __fastcall TCalibrationForm::ThreadTEST(void* arg)
{
	int a = 0;
}
//---------------------------------------------------------------------------
void __fastcall TCalibrationForm::GetDefaultString()
{
	Calibration3DButton->Caption = CALIBRATIONFORM_BUTTON_CAPTION_01;
	ShutterSpeedSettingButton->Caption = CALIBRATIONFORM_BUTTON_CAPTION_02;
	AutoShutterSpeedSettingButton->Caption = CALIBRATIONFORM_BUTTON_CAPTION_10;
	BoundarySettingButton->Caption = CALIBRATIONFORM_BUTTON_CAPTION_03;
	BoundaryCloseButton->Caption = CALIBRATIONFORM_BUTTON_CAPTION_04;
	CameraResolutionButton->Caption = CALIBRATIONFORM_BUTTON_CAPTION_05;
	CaptureStartButton->Caption = CALIBRATIONFORM_BUTTON_CAPTION_06;
	this->Caption = CALIBRATIONFORM_BUTTON_CAPTION_06;
	CaptureStopButton->Caption = CALIBRATIONFORM_BUTTON_CAPTION_07;
	SaveButton->Caption = CALIBRATIONFORM_BUTTON_CAPTION_08;
	CameraSettingButton->Caption = CALIBRATIONFORM_BUTTON_CAPTION_09;
	GroupBox2->Caption = CALIBRATIONFORM_GROUPBOX_CAPTION_01;
	GroupBox6->Caption = CALIBRATIONFORM_GROUPBOX_CAPTION_01;
	GroupBox1->Caption = CALIBRATIONFORM_GROUPBOX_CAPTION_02;
	GroupBox3->Caption = CALIBRATIONFORM_GROUPBOX_CAPTION_03;
	GroupBox4->Caption = CALIBRATIONFORM_GROUPBOX_CAPTION_03;
	GroupBox5->Caption = CALIBRATIONFORM_GROUPBOX_CAPTION_03;
	GroupBox1->Caption = CALIBRATIONFORM_GROUPBOX_CAPTION_02;

	Label33->Caption = CALIBRATIONFORM_LABEL_CAPTION_01;
	Label55->Caption = CALIBRATIONFORM_LABEL_CAPTION_01;
	Label39->Caption = CALIBRATIONFORM_LABEL_CAPTION_01;
	Label42->Caption = CALIBRATIONFORM_LABEL_CAPTION_01;
	Label46->Caption = CALIBRATIONFORM_LABEL_CAPTION_01;

	Label32->Caption = CALIBRATIONFORM_LABEL_CAPTION_02;

	Label30->Caption = CALIBRATIONFORM_LABEL_CAPTION_03;
	Label52->Caption = CALIBRATIONFORM_LABEL_CAPTION_05;
	Label36->Caption = CALIBRATIONFORM_LABEL_CAPTION_09;
	Label37->Caption = CALIBRATIONFORM_LABEL_CAPTION_03;
	Label44->Caption = CALIBRATIONFORM_LABEL_CAPTION_04;

	Label54->Caption = CALIBRATIONFORM_LABEL_CAPTION_02;
	Label38->Caption = CALIBRATIONFORM_LABEL_CAPTION_02;
	Label41->Caption = CALIBRATIONFORM_LABEL_CAPTION_02;
	Label45->Caption = CALIBRATIONFORM_LABEL_CAPTION_02;
	Label37->Caption = CALIBRATIONFORM_LABEL_CAPTION_03;

	CaptureMessageLabel->Caption = CALIBRATIONFORM_LABEL_CAPTION_07;

	Label31->Caption = CALIBRATIONFORM_LABEL_CAPTION_08;
	Label53->Caption = CALIBRATIONFORM_LABEL_CAPTION_08;

	Label34->Caption = CALIBRATIONFORM_LABEL_CAPTION_10;
	Label56->Caption = CALIBRATIONFORM_LABEL_CAPTION_10;
	Label40->Caption = CALIBRATIONFORM_LABEL_CAPTION_10;
	Label43->Caption = CALIBRATIONFORM_LABEL_CAPTION_10;
	Label47->Caption = CALIBRATIONFORM_LABEL_CAPTION_10;

	//add
	ShutterSpeedSaveButton->Caption = CALIBRATIONFORM_BUTTON_CAPTION_08;
	ShutterSpeedCloseButton->Caption = CALIBRATIONFORM_BUTTON_CAPTION_04;
	CameraResSaveButton->Caption = CALIBRATIONFORM_BUTTON_CAPTION_08;
	CameraResCloseButton->Caption = CALIBRATIONFORM_BUTTON_CAPTION_04;
	SpeedControlBtn->Caption = INSPECTIONFORM_BUTTON_CAPTION_08;

	ShutterSpeedAllChangeCheckbox->Caption = CALIBRATIONFORM_LABEL_CAPTION_13;
	GainAllChangeCheckbox->Caption = CALIBRATIONFORM_LABEL_CAPTION_14;

	ProccessAlarmPanel->Caption = CALIBRATIONFORM_LABEL_CAPTION_07;

	Label20->Caption = CALIBRATIONFORM_LABEL_CAPTION_18;
	Label3->Caption = CALIBRATIONFORM_LABEL_CAPTION_20;

	SensorInfoControlBtn->Caption = CALIBRATIONFORM_LABEL_CAPTION_17;
	MachineControlPanel->Caption = CALIBRATIONFORM_LABEL_CAPTION_21;

    Label1->Caption	= CALIBRATIONFORM_LABEL_CAPTION_22;
    Label13->Caption	= CALIBRATIONFORM_LABEL_CAPTION_23;
    Label15->Caption	= CALIBRATIONFORM_LABEL_CAPTION_24;
    Label17->Caption	= CALIBRATIONFORM_LABEL_CAPTION_25;
    Label14->Caption	= CALIBRATIONFORM_LABEL_CAPTION_26;
    Label16->Caption	= CALIBRATIONFORM_LABEL_CAPTION_27;
    Label18->Caption	= CALIBRATIONFORM_LABEL_CAPTION_28;

    CloseButton->Caption = CALIBRATIONFORM_BUTTON_CAPTION_11;
}
//---------------------------------------------------------------------------
void __fastcall TCalibrationForm::CloseButtonClick(TObject* Sender)
{
	this->Close();
}
//---------------------------------------------------------------------------

void __fastcall TCalibrationForm::CaptureStartButtonClick(TObject* Sender)
{
	// check machine interlock
	if (MachineSetupData.CompanyID == INTERNATIONAL_MACHINE1)
	{
    if(MachineSetupData.InterlockInfo.ACdomesticMode)
    {
      if (MachineSetupData.InterlockInfo.DoorInterlockEnabled)
      {
        if (!Machine.InterlockCheck())
        {
          ShowMessageFA(Machine.GetInterlockMessage());
          return;
        }
      }
    }
    else
    {
      if (!Machine.InterlockCheck())
      {
        ShowMessageFA(Machine.GetInterlockMessage());
        return;
      }
    }
	}
	else
	{
		if (MachineSetupData.InterlockInfo.DoorInterlockEnabled)
		{
			if (!Machine.InterlockCheck())
			{
				ShowMessageFA(Machine.GetInterlockMessage());
				return;
			}
		}
	}

	if (!Machine.CanCaptureStart(ProductData.LampKind))
	{
		ShowMessageFA(Machine.GetCaptureStartFailMessage(ProductData.LampKind));
		return;
	}

	if (Machine.Status.OperationState != MACHINE_STATE_STOP &&
		Machine.Status.OperationState != MACHINE_STATE_CLEANING &&
		Machine.Status.OperationState != MACHINE_STATE_ATTACHING &&
		Machine.Status.OperationState != MACHINE_STATE_DETACHING)
	{
		Machine.MachineStop();
		ShowMessageFA(INSPECTIONFORM_MSG_23);
		return;
	}

	bool bError = false;

	WritingContainerIndex = 0;

	AnsiString tempFileName = ProgramPath.Temp + "\\TempImage.FAC";
	if (FileExists(tempFileName)) DeleteFile(tempFileName);
	TempCaptureFileContainer->Open(ProgramPath.Temp + "\\TempImage.FAC", true, MAX_CAPTURE_IMAGE_COUNT * (SYSTEM_TOTAL_CAMERA_COUNT + 2));

	InitImageComponents();

	IntervalStudyCount1 = 0;
	IntervalStudyCount2 = 0;

	SensorTimingPanel->Visible = true;
	SensorTimingPanel->Left = 0;

	unsigned int camMask = 0;
	for (int globalCameraIndex = 0; globalCameraIndex < SYSTEM_TOTAL_CAMERA_COUNT; globalCameraIndex++)
	{
		if ((CameraMapInfo[globalCameraIndex].CameraInspectPosition < CAMERA_POSITION_DISCONNECT) && (SystemLinkCameraInfo[globalCameraIndex] != 0))
		{
			camMask |= (0x0001 << globalCameraIndex);
		}
	}

	try
	{
		AnsiString imageDir = GetProductImagePath();
		if (!DirectoryExists(imageDir))
		{
			ForceDirectories(imageDir);
		}

		AnsiString bgImgDir = GetProductImagePath() + "\\Background";
		if (!DirectoryExists(bgImgDir))
		{
			ForceDirectories(bgImgDir);
		}

		float tabletHalfLength = ProductData.TabletLength / 2;

		// Camera Shutter Speed 
		for (int globalCameraIndex = 0; globalCameraIndex < SYSTEM_TOTAL_CAMERA_COUNT; globalCameraIndex++)
		{
			int spbIndex = CameraMapInfo[globalCameraIndex].SPBIndex;
			if (!Comm_IsConnected(COMM_SPB + spbIndex)) continue;

			if (CameraMapInfo[globalCameraIndex].CameraInspectPosition < CAMERA_POSITION_DISCONNECT && SystemLinkCameraInfo[globalCameraIndex] != 0)
			{
				RefreshCameraInfo(globalCameraIndex, 1.0);
				Application->ProcessMessages();
				this->Refresh();
			}
		}

		ReadSystemCameraOffsetImage(ProductData.DigitalGainV);

		if (0) //MachineSetupData.LasercomplexerInfo.Laser_complexer_Enable)
		{
			if ((camMask & (0x0001 << (SD1_3D_FRONT_FACE_CAMERA_INDEX - 1))) == 0)
			{
				Set3DCamera_CaptureParameter(SD1_3D_FRONT_FACE_CAMERA_INDEX - 1, ThreeDCameraDefaultInformation[SD1_3D_FRONT_FACE_CAMERA_INDEX - 1].AnalogCameraGain, ThreeDCameraDefaultInformation[SD1_3D_FRONT_FACE_CAMERA_INDEX - 1].ExposureTime);
			}

			if ((camMask & (0x0001 << (SD2_3D_FRONT_FACE_CAMERA_INDEX - 1))) == 0)
			{
				Set3DCamera_CaptureParameter(SD2_3D_FRONT_FACE_CAMERA_INDEX - 1, ThreeDCameraDefaultInformation[SD2_3D_FRONT_FACE_CAMERA_INDEX - 1].AnalogCameraGain, ThreeDCameraDefaultInformation[SD2_3D_FRONT_FACE_CAMERA_INDEX - 1].ExposureTime);
			}
		}

    int maxBufferingCount = 48;
    
		// second capture - object
		SendSPBCaptureSetup_Multi(&ProductData, camMask, tabletHalfLength, ProductData.ShutterSpeed,
			ProductData.StudyMotorSpeedList[SD1_MOTOR_INDEX][0], MachineSetupData.ServoMotorData[SD1_MOTOR_INDEX].BaseSpeed,
			ProductData.StudyMotorSpeedList[SD2_MOTOR_INDEX][0], MachineSetupData.ServoMotorData[SD2_MOTOR_INDEX].BaseSpeed,
			ProductData.SubSamplingMode, false, maxBufferingCount);

		for (int globalCameraIndex = 0; globalCameraIndex < SYSTEM_TOTAL_CAMERA_COUNT; globalCameraIndex++)
		{
			CurrentCamImageIndex[globalCameraIndex] = 0;
		}

		CaptureState = ECS_ON_CAPTURE;

		ImgSaveDataCount = 0;
		CaptureEndFlag = false;
		ImgViewThreadController = true;
		ImgSaveThreadController = true;
		ImgViewThreadInitFlag = false;

		ProccessAlarmPanel->Visible = true;

		CaptureCheckTimer->Enabled = true;
		SensorIntervalTimer->Enabled = true;

		InitImageComponents();

		TMachineCaptureSetupData machineCaptureSetupData;
		memcpy(machineCaptureSetupData.IlluminatorMask, MachineSetupData.MachineCaptureInfo.IlluminatorMask, SYSTEM_MACHINE_CAPTURE_COUNT * sizeof(int));
		machineCaptureSetupData.CaptureOption = 0;
		machineCaptureSetupData.TabletLength = ProductData.TabletLength;
		machineCaptureSetupData.TabletSideThick = ProductData.TabletSideThick * 10;
		machineCaptureSetupData.SuctionDiskSpeed = ProductData.StudyMotorSpeedList[0][0]; /// studyspeed khs
		machineCaptureSetupData.StudiedTabletSensorLength = ProductData.StudiedSensor1Length;
		if (!Comm_Request(COMM_HCB, CMD_MACHINE_CAPTURE, &machineCaptureSetupData, sizeof(TMachineCaptureSetupData),
			NULL, 0))
		{
			throw Exception("");
		}

		int motorSpeedList[MAX_SERVO_MOTOR_COUNT];
		for (int motorIndex = 0; motorIndex < MAX_SERVO_MOTOR_COUNT; motorIndex++)
		{
			motorSpeedList[motorIndex] = ProductData.StudyMotorSpeedList[motorIndex][0]; // studyspeed khs
		}

		if (!Machine.MachineRun(PROCEDURE_MODE_CAPTURE, &ProductData.MachineRunOption,
			ProductData.NCMotorPos, motorSpeedList))
		{
			throw Exception("");
		}

		CaptureMessageLabel->Caption = CALIBRATIONFORM_LABEL_CAPTION_07;
		CaptureStopButton->Enabled = true;
		CaptureStartButton->Enabled = false;
		CaptureProgressPanel->Visible = true;
		CloseButton->Enabled = false;
		ShutterSpeedSettingButton->Enabled = false;
		AutoShutterSpeedSettingButton->Enabled = false;
		SpeedControlBtn->Enabled = false;
		BoundarySettingButton->Enabled = false;
		Calibration3DButton->Enabled = false;
		CameraSettingButton->Enabled = false;
		CameraResolutionButton->Enabled = false;

		CaptureProcessGauge->Progress = 0;
		CaptureProcessGauge->MaxValue = MAX_CAPTURE_IMAGE_COUNT;
		CaptureProcessGauge->BackColor = clWhite;
		CaptureProcessGauge->ForeColor = clBlue;
		CaptureProgressLabel->Caption = IntToStr(CaptureProcessGauge->Progress) + "/" + IntToStr(CaptureProcessGauge->MaxValue);
		AddCSVActionLog(ECSV_ACTION_IMAGE_CAPTURE_START, UserInfo.Name, ProductData.ProductName, NULL, 0);
	}
	catch (...)
	{

	}
}
//---------------------------------------------------------------------------

void __fastcall TCalibrationForm::CaptureCheckTimerTimer(TObject* Sender)
{
	bool bCaptureExist;
	// check capture exists
	char cameraIndex;
	unsigned int data[2];
	unsigned int receivedData[2];
  int BufferingImageCount[SYSTEM_TOTAL_CAMERA_COUNT];

	bool timerEnabled = CaptureCheckTimer->Enabled;
	CaptureCheckTimer->Enabled = false;

  memset(BufferingImageCount, 0, sizeof(int) * SYSTEM_TOTAL_CAMERA_COUNT);

	for (int globalCameraIndex = 0; globalCameraIndex < SYSTEM_TOTAL_CAMERA_COUNT; globalCameraIndex++)
	{
		ImagePath = GetProductImagePath();

		int spbIndex = CameraMapInfo[globalCameraIndex].SPBIndex;
		int camIndex = CameraMapInfo[globalCameraIndex].CamIndex;
		data[0] = camIndex;

		if (CameraMapInfo[globalCameraIndex].CameraInspectPosition == CAMERA_POSITION_DISCONNECT || SystemLinkCameraInfo[globalCameraIndex] == 0)
		{
			CurrentCamImageIndex[globalCameraIndex] = MAX_CAPTURE_IMAGE_COUNT;
			continue;
		}

		if (!Comm_IsConnected(COMM_SPB + spbIndex))
		{
			CurrentCamImageIndex[globalCameraIndex] = MAX_CAPTURE_IMAGE_COUNT;
			continue;
		}
		try
		{
			if (!Comm_Request(COMM_SPB + spbIndex, CMD_CAPTURE_EXIST, data, sizeof(unsigned int),
				receivedData, sizeof(unsigned int) * 2))
			{
				throw Exception("");
			}

			BufferingImageCount[globalCameraIndex] = receivedData[0];

			if (BufferingImageCount[globalCameraIndex] > 0 && CurrentCamImageIndex[globalCameraIndex] < MAX_CAPTURE_IMAGE_COUNT)
			{
				bCaptureExist = true;
			}
			else
			{
				bCaptureExist = false;
			}
			if (bCaptureExist)
			{
				if (CameraMapInfo[globalCameraIndex].CameraInspectPosition == CAMERA_POSITION_3D)
				{
					data[1] = CaptureWidth_3D * CaptureHeight_3D;
					if (!Comm_Request(COMM_SPB + spbIndex, CMD_CAPTURE_UPLOAD, data, 2 * sizeof(unsigned int),
						CaptureData, CaptureWidth_3D * CaptureHeight_3D))
					{
						throw Exception("");
					}
				}
				else
				{
					data[1] = CaptureWidth * CaptureHeight;
					if (!Comm_Request(COMM_SPB + spbIndex, CMD_CAPTURE_UPLOAD, data, 2 * sizeof(unsigned int),
						CaptureData, CaptureWidth * CaptureHeight))
					{
						throw Exception("");
					}
				}

				ImagePath += "\\Image" + IntToStr(CurrentCamImageIndex[globalCameraIndex] + 1) + "_" + IntToStr(globalCameraIndex + 1) + ".fbm";
				ImageFileStream = new TFileStream(ImagePath, fmCreate);
				if (ImageFileStream)
				{
					ImageFileStream->Write(CaptureData, sizeof(unsigned char) * ((CaptureWidth + 1) * (CaptureHeight + 1)));
					delete ImageFileStream;
				}

				CurrentCamImageIndex[globalCameraIndex]++;
			}
		}
		catch (Exception& ec)
		{
			timerEnabled = false;
			if (ec.Message != "")
			{
				ShowMessageFA(ec.Message);
			}
		}
	}

  int minImageUploadCount = MAX_CAPTURE_IMAGE_COUNT;
  for (int globalCameraIndex = 0; globalCameraIndex < SYSTEM_TOTAL_CAMERA_COUNT; globalCameraIndex++)
  {
    if (CameraMapInfo[globalCameraIndex].CameraInspectPosition != CAMERA_POSITION_DISCONNECT && SystemLinkCameraInfo[globalCameraIndex])
    {
      if(minImageUploadCount >= CurrentCamImageIndex[globalCameraIndex])
      {
        minImageUploadCount = CurrentCamImageIndex[globalCameraIndex];
      }
    }
  }

	CaptureProcessGauge->Progress = minImageUploadCount;
	CaptureProgressLabel->Caption = IntToStr(CaptureProcessGauge->Progress) + "/" + IntToStr(CaptureProcessGauge->MaxValue);

	if (FlipGage > 300)
	{
		FlipGage = 0;
		FlipColor();
	}
	else
	{
		FlipGage++;
	}

  bool bMachinStop = true;
  for (int globalCameraIndex = 0; globalCameraIndex < SYSTEM_TOTAL_CAMERA_COUNT; globalCameraIndex++)
  {
    if (CameraMapInfo[globalCameraIndex].CameraInspectPosition != CAMERA_POSITION_DISCONNECT && SystemLinkCameraInfo[globalCameraIndex])
    {
      if(BufferingImageCount[globalCameraIndex] + CurrentCamImageIndex[globalCameraIndex] < MAX_CAPTURE_IMAGE_COUNT)
      {
        bMachinStop = false;
        break;
      }
    }
  }

  if (bMachinStop)		// system all captured
  {
    Machine.MachineStop();
  }

  for(int globalCameraIndex = 0; globalCameraIndex < 16; globalCameraIndex++)
	{
		StringGrid1->Cells[0][globalCameraIndex] = IntToStr(CurrentCamImageIndex[globalCameraIndex]) +  " / " + IntToStr(BufferingImageCount[globalCameraIndex] + CurrentCamImageIndex[globalCameraIndex]);
	}

	if (minImageUploadCount == MAX_CAPTURE_IMAGE_COUNT)
	{
    Comm_Request(COMM_HCB, CMD_MACHINE_CAPTURE_STOP);
  
		timerEnabled = false;
		CaptureCheckTimer->Enabled = timerEnabled;
		CaptureEndFlag = true;
		ProccessAlarmPanel->Visible = false;

		ImageSaveThreadHandle = (HANDLE)_beginthreadex(NULL, NULL, ImageConvertSaveThread, this, 0, (unsigned int*)&ThreadDword);
		ImageViewThreadHandle = (HANDLE)_beginthreadex(NULL, NULL, ImageViewThread, this, 0, (unsigned int*)&ThreadDword);
		CaptureImageViewProcess();
	}

	CaptureCheckTimer->Enabled = timerEnabled;
}
//---------------------------------------------------------------------------
void __fastcall TCalibrationForm::FlipColor()
{
	if (ProccessAlarmPanel->Color == clBlack)
	{
		ProccessAlarmPanel->Color = clGreen;
	}
	else
	{
		ProccessAlarmPanel->Color = clBlack;
	}
}
//---------------------------------------------------------------------------
void __fastcall TCalibrationForm::CaptureImageViewProcess()
{
	try
	{
		CaptureStopButton->Enabled = false;
		int Loop = true;
		while (Loop)
		{
			Application->ProcessMessages();
			if (CaptureEndFlag)
			{
				if (ImgSaveDataCount < 100)
				{
					CaptureMessageLabel->Caption = CALIBRATIONFORM_LABEL_CAPTION_11;
					CaptureProcessGauge->Progress = ImgSaveDataCount;
				}
				else
				{
					CaptureMessageLabel->Caption = CALIBRATIONFORM_LABEL_CAPTION_15;
					CaptureProcessGauge->Progress = 100;

					AnsiString ImagePath = GetProductImagePath() + "\\*.fbm";
					AnsiString TempPath;
					_finddata_t fd;
					long handle;
					int result = 1;
					handle = _findfirst(ImagePath.c_str(), &fd);

					if (handle == -1)
					{
						return;
					}

					while (result != -1)
					{
						AnsiString  FName = fd.name;
						TempPath = GetProductImagePath() + "\\" + FName;

						DeleteFileA(TempPath.c_str());
						result = _findnext(handle, &fd);
					}

					_findclose(handle);
					Loop = false;
				}
			}
		}

		Loop = true;
		//ImageViewThreadHandle= (HANDLE)_beginthreadex(NULL,NULL,ImageViewThread,this,0,(unsigned int*)&ThreadDword);

		while (Loop)
		{
			Application->ProcessMessages();
			if (CurrentImgViewCount < 100)
			{
				CaptureProcessGauge->Progress = CurrentImgViewCount;
			}
			else
			{
				Loop = false;
				CaptureMessageLabel->Caption = CALIBRATIONFORM_LABEL_CAPTION_12;
				CaptureProcessGauge->Progress = 100;
			}
		}


		Application->ProcessMessages();


		CaptureState = ECS_NONE;

		// study sensor length info
		StudySensorLengthInfo();
		if (ProductData.ProcessingStep < TABLET_PROCESSING_STEP_EXTRACT_CHARACTER_REQUIRED)
		{
			ProductData.ProcessingStep = TABLET_PROCESSING_STEP_EXTRACT_CHARACTER_REQUIRED;
		}
		AnsiString fileName = GetProductDataFileName(ProductData.ProductCode);
		WriteProductData(fileName, ProductData);
		AddCSVActionLog(ECSV_ACTION_IMAGE_CAPTURE_COMPLETE, UserInfo.Name, ProductData.ProductName, NULL, 0);

		ShowMessageFA(CALIBRATIONFORM_MSG_08);
		CaptureMessageLabel->Caption = CALIBRATIONFORM_LABEL_CAPTION_06;
		CaptureStopButton->Enabled = false;
		CaptureStartButton->Enabled = true;
		CloseButton->Enabled = true;
		ShutterSpeedSettingButton->Enabled = true;
		AutoShutterSpeedSettingButton->Enabled = true;
		SpeedControlBtn->Enabled = true;
		BoundarySettingButton->Enabled = true;
		Calibration3DButton->Enabled = true;
		CameraSettingButton->Enabled = true;
		CameraResolutionButton->Enabled = true;
	}
	catch (...)
	{
		ShowMessage("Error");
	}
}
//--------------------------------------------------------------------------
void __fastcall TCalibrationForm::CaptureStopButtonClick(TObject* Sender)
{
	if (bBackgroundCaptureSW)
	{
		for (int globalCameraIndex = 0; globalCameraIndex < SYSTEM_TOTAL_CAMERA_COUNT; globalCameraIndex++)
		{
			int spbIndex = CameraMapInfo[globalCameraIndex].SPBIndex;
			int camIndex = CameraMapInfo[globalCameraIndex].CamIndex;

			if (Comm_IsConnected(COMM_SPB + spbIndex))
			{
				Comm_Request(COMM_SPB + spbIndex, CMD_CAPTURE_STOP, &camIndex, sizeof(int));
			}
		}

		captureCommandParam_HCB.Action = 0;
		Comm_Request(COMM_HCB, CMD_TABLET_CAPTURE, &captureCommandParam_HCB, sizeof(TCaptureCommandParam_HCB), NULL, 0);

		BackgroundImageUploadTimer->Enabled = false;
		bCaptureStopSW = true;
		bCaptureCompleteBGI = false;
	}
	else
	{
		ImgViewThreadController = false;
		CaptureEndFlag = false;
		CaptureCheckTimer->Enabled = false;
		SensorIntervalTimer->Enabled = false;

		ImgSaveThreadController = false;
		ProccessAlarmPanel->Visible = false;

		for (int globalCameraIndex = 0; globalCameraIndex < SYSTEM_TOTAL_CAMERA_COUNT; globalCameraIndex++)
		{
			TTntLabel* Label = (TTntLabel*)FindComponent("PercentLabel" + IntToStr(globalCameraIndex + 1));
			Label->Visible = false;
		}

		Comm_Request(COMM_HCB, CMD_MACHINE_CAPTURE_STOP);

		if (Machine.MachineStop())
		{
			WaitingForm->WaitingMachineStop();
		}

		CaptureStartButton->Enabled = true;
		CaptureStopButton->Enabled = false;
		CloseButton->Enabled = true;
		ShutterSpeedSettingButton->Enabled = true;
		AutoShutterSpeedSettingButton->Enabled = true;
		SpeedControlBtn->Enabled = true;
		BoundarySettingButton->Enabled = true;
		Calibration3DButton->Enabled = true;
		CameraSettingButton->Enabled = true;
		CameraResolutionButton->Enabled = true;

		int captureCount[2];
		if (CaptureState == ECS_OPTIONAL_CAPTURE)
		{
			captureCount[0] = MAX_CAPTURE_IMAGE_COUNT;
			captureCount[1] = CaptureProcessGauge->Progress;
		}
		else
		{
			captureCount[0] = CaptureProcessGauge->Progress;
			captureCount[1] = 0;
		}

		AddCSVActionLog(ECSV_ACTION_IMAGE_CAPTURE_STOP, UserInfo.Name, ProductData.ProductName, (unsigned char*)captureCount, 2 * sizeof(int));
	}
}
//-----------------------------------------------------------------------------
void __fastcall TCalibrationForm::ImageNumberUpDownClick(TObject* Sender,
	TUDBtnType Button)
{
	CurrentCheckImageNumber = ImageNumberUpDown->Position;
	ImageNumberEdit->Text = IntToStr(CurrentCheckImageNumber);
	ShowBoundaryImage();
}
//---------------------------------------------------------------------------

void __fastcall TCalibrationForm::BoundarySettingButtonClick(TObject* Sender)
{
	CaptureImage1->Visible = true;
	CaptureImage1_Option->Visible = false;
	CaptureImage2->Visible = false;
	CaptureImage3->Visible = false;
	CaptureImage4->Visible = false;
	CaptureImage5->Visible = false;
	CaptureImage6->Visible = false;
	CaptureImage7->Visible = false;
	CaptureImage8->Visible = false;
	CaptureImage9->Visible = false;
	CaptureImage9_Option->Visible = false;
	CaptureImage10->Visible = false;
	CaptureImage11->Visible = false;
	CaptureImage12->Visible = false;
	CaptureImage13->Visible = false;
	CaptureImage14->Visible = false;
	CaptureImage15->Visible = false;
	CaptureImage16->Visible = false;

	CameraIndexLabel1->Visible = false;
	CameraIndexLabel1Option->Visible = false;
	CameraIndexLabel2->Visible = false;
	CameraIndexLabel3->Visible = false;
	CameraIndexLabel4->Visible = false;
	CameraIndexLabel5->Visible = false;
	CameraIndexLabel6->Visible = false;
	CameraIndexLabel7->Visible = false;
	CameraIndexLabel8->Visible = false;
	CameraIndexLabel9->Visible = false;
	CameraIndexLabel9Option->Visible = false;
	CameraIndexLabel10->Visible = false;
	CameraIndexLabel11->Visible = false;
	CameraIndexLabel12->Visible = false;
	CameraIndexLabel13->Visible = false;
	CameraIndexLabel14->Visible = false;
	CameraIndexLabel15->Visible = false;
	CameraIndexLabel16->Visible = false;
	SensorTimingPanel->Visible = false;

	if (ActivePanel) ActivePanel->Visible = false;
	BoundarySettingPanel->Visible = true;
	ActivePanel = BoundarySettingPanel;

	CurrentCheckCameraIndex = SD1_2D_FRONT_FACE_CAMERA_INDEX - 1;
	CurrentCheckImageNumber = 1;
	ImageNumberEdit->Text = IntToStr(CurrentCheckImageNumber);
	ImageNumberUpDown->Position = 1;
	AreaKind = 0;
	AreaKindSpeedButton1->Down = true;
	IsBoundarySettingMode = true;
	ShowBoundaryImage();
}
//---------------------------------------------------------------------------
void __fastcall TCalibrationForm::ShowBoundaryImage(void)
{
	if (ExtractImage(CaptureBitmap, CurrentCheckImageNumber, CurrentCheckCameraIndex + 1, SystemImageOffsetSWCal[CurrentCheckCameraIndex], SystemOffsetImage[CurrentCheckCameraIndex], ProductData.SubSamplingMode))
	{
		if (CameraMapInfo[CurrentCheckCameraIndex].CameraInspectPosition == CAMERA_POSITION_3D)
		{
			DestImage->Picture->Bitmap->Width = CaptureBitmap->Width;
			DestImage->Picture->Bitmap->Height = CaptureBitmap->Height;
			DestImage->Width = DestImage->Picture->Bitmap->Width * 2;
			DestImage->Height = DestImage->Picture->Bitmap->Height;
			DestImage->Picture->Bitmap->PixelFormat = pf8bit;

			Set3DPalette(DestImage->Picture->Bitmap);

			for (int y = 0; y < DestImage->Picture->Bitmap->Height; y++)
			{
				byte* pSrc = (byte*)CaptureBitmap->ScanLine[y];
				byte* pDst = (byte*)DestImage->Picture->Bitmap->ScanLine[y];
				memset(pDst, 0, DestImage->Picture->Bitmap->Width);
				for (int x = 4; x < DestImage->Picture->Bitmap->Width - 4; x++)
				{
					// 3d conv
					pDst[x] = pSrc[x];
				}

				byte* pTemp = new byte[DestImage->Picture->Bitmap->Width];
				memcpy(pTemp, pDst, DestImage->Picture->Bitmap->Width);
				for (int x = DestImage->Picture->Bitmap->Width - 2; x >= 2; x--)
				{
					if (pTemp[x] == 0)
					{
						if (pDst[x - 1] == 0)
						{
							pTemp[x] = pDst[x + 1];
						}
						else
						{
							pTemp[x] = min(pDst[x - 1], pDst[x + 1]);
						}
					}
				}
				memcpy(pDst, pTemp, DestImage->Picture->Bitmap->Width);
				delete[] pTemp;
			}
		}
		else
		{
			if (ProductData.SubSamplingMode == IMAGE_FULL_SCALE_MODE)
			{
				ReductionImageScale(CaptureBitmap);
			}

			DestImage->Picture->Bitmap->Width = CaptureBitmap->Width;
			DestImage->Picture->Bitmap->Height = CaptureBitmap->Height;
			DestImage->Picture->Bitmap->PixelFormat = pf24bit;
			DestImage->Picture->Bitmap->Assign(CaptureBitmap);
			DestImage->Width = DestImage->Picture->Bitmap->Width;
			DestImage->Height = DestImage->Picture->Bitmap->Height;
		}

		DestImage->Repaint();

		DestImage->Canvas->Brush->Style = bsClear;
		DestImage->Canvas->Pen->Color = clLime;
		if (CameraMapInfo[CurrentCheckCameraIndex].CameraInspectPosition == CAMERA_POSITION_3D)
		{
			DestImage->Canvas->Rectangle(Rect(BoundaryArea[CurrentCheckCameraIndex].left / 2,
				BoundaryArea[CurrentCheckCameraIndex].top,
				BoundaryArea[CurrentCheckCameraIndex].right / 2,
				BoundaryArea[CurrentCheckCameraIndex].bottom));
		}
		else
		{
			DestImage->Canvas->Rectangle(BoundaryArea[CurrentCheckCameraIndex]);
		}

		LeftLabel->Caption = IntToStr(BoundaryArea[CurrentCheckCameraIndex].left);
		TopLabel->Caption = IntToStr(BoundaryArea[CurrentCheckCameraIndex].top);
		RightLabel->Caption = IntToStr(BoundaryArea[CurrentCheckCameraIndex].right);
		BottomLabel->Caption = IntToStr(BoundaryArea[CurrentCheckCameraIndex].bottom);
		WidthLabel->Caption = IntToStr(BoundaryArea[CurrentCheckCameraIndex].Width());
		HeightLabel->Caption = IntToStr(BoundaryArea[CurrentCheckCameraIndex].Height());

		if (CurrentCheckCameraIndex == SD1_2D_SIDE_FACE_P45_CAMERA_INDEX - 1 ||
			CurrentCheckCameraIndex == SD1_2D_SIDE_FACE_00_CAMERA_INDEX - 1 ||
			CurrentCheckCameraIndex == SD1_2D_SIDE_FACE_M45_CAMERA_INDEX - 1 ||
			CurrentCheckCameraIndex == SD1_2D_OTHER_SIDE_FACE_P45_CAMERA_INDEX - 1 ||
			CurrentCheckCameraIndex == SD1_2D_OTHER_SIDE_FACE_00_CAMERA_INDEX - 1 ||
			CurrentCheckCameraIndex == SD1_2D_OTHER_SIDE_FACE_M45_CAMERA_INDEX - 1 ||
			CurrentCheckCameraIndex == SD2_2D_SIDE_FACE_P45_CAMERA_INDEX - 1 ||
			CurrentCheckCameraIndex == SD2_2D_SIDE_FACE_00_CAMERA_INDEX - 1 ||
			CurrentCheckCameraIndex == SD2_2D_SIDE_FACE_M45_CAMERA_INDEX - 1 ||
			CurrentCheckCameraIndex == SD2_2D_OTHER_SIDE_FACE_P45_CAMERA_INDEX - 1 ||
			CurrentCheckCameraIndex == SD2_2D_OTHER_SIDE_FACE_00_CAMERA_INDEX - 1 ||
			CurrentCheckCameraIndex == SD2_2D_OTHER_SIDE_FACE_M45_CAMERA_INDEX - 1)
		{
			DestImage->Canvas->Pen->Color = clRed;
			DestImage->Canvas->MoveTo(0, DiscCenterPos[CurrentCheckCameraIndex].y);
			DestImage->Canvas->LineTo(CaptureWidth, DiscCenterPos[CurrentCheckCameraIndex].y);
		}
	}
	else
	{
		ShowMessageFA(CALIBRATIONFORM_MSG_09);
	}

	/*
	unsigned char BayerImage[640*480];
	ExtractBayerImage(BayerImage, CurrentCheckImageNumber, CurrentCheckCameraIndex + 1);
	int x, y;
	byte *ptr;

	for (y = 0; y < 480; y++)
	{
		ptr = (byte*) DestImage->Picture->Bitmap->ScanLine[y];
		for(x = 0; x < 640; x++)
		{
			ptr[3*x + 0]  = BayerImage[640 * y + x];
			ptr[3*x + 1]  = BayerImage[640 * y + x];
			ptr[3*x + 2]  = BayerImage[640 * y + x];

		}
	}
	*/
}
//---------------------------------------------------------------------------

void __fastcall TCalibrationForm::CamSpeedButtonClick(TObject* Sender)
{
	TTntSpeedButton* theSpeedButton = (TTntSpeedButton*)Sender;
	CurrentCheckCameraIndex = theSpeedButton->Tag;
	CurrentCheckImageNumber = 1;
	ImageNumberEdit->Text = IntToStr(CurrentCheckImageNumber);
	ImageNumberUpDown->Position = 1;
	ShowBoundaryImage();
}
//---------------------------------------------------------------------------

void __fastcall TCalibrationForm::AreaKindSpeedButtonClick(
	TObject* Sender)
{
	TTntSpeedButton* theSpeedButton = (TTntSpeedButton*)Sender;
	AreaKind = theSpeedButton->Tag;
}
//---------------------------------------------------------------------------
void __fastcall TCalibrationForm::CaptureImage1MouseUp(TObject* Sender,
	TMouseButton Button, TShiftState Shift, int X, int Y)
{
	if (IsBoundarySettingMode)
	{
		if (AreaKind == 0 || AreaKind == 2)
		{
			if (CameraMapInfo[CurrentCheckCameraIndex].CameraInspectPosition == CAMERA_POSITION_3D)
			{
				BoundaryArea[CurrentCheckCameraIndex].left = X / 4 * 4;
			}
			else
			{
				BoundaryArea[CurrentCheckCameraIndex].left = X / 4 * 4;
			}
		}
		else if (AreaKind != 4)
		{
			if (CameraMapInfo[CurrentCheckCameraIndex].CameraInspectPosition == CAMERA_POSITION_3D)
			{
				BoundaryArea[CurrentCheckCameraIndex].right = X / 4 * 4;
			}
			else
			{
				BoundaryArea[CurrentCheckCameraIndex].right = X / 4 * 4;
			}
		}
		if (AreaKind == 0 || AreaKind == 1)
		{
			BoundaryArea[CurrentCheckCameraIndex].top = Y / 4 * 4;
		}
		else if (AreaKind != 4)
		{
			BoundaryArea[CurrentCheckCameraIndex].bottom = Y / 4 * 4;
		}

		if (AreaKind == 4)
		{
			if (CameraMapInfo[CurrentCheckCameraIndex].CameraInspectPosition == CAMERA_POSITION_3D)
			{
				DiscCenterPos[CurrentCheckCameraIndex].x = X;
			}
			else
			{
				DiscCenterPos[CurrentCheckCameraIndex].x = X;
			}
			DiscCenterPos[CurrentCheckCameraIndex].y = Y / 4 * 4;
		}

		ShowBoundaryImage();
	}
}
//---------------------------------------------------------------------------
void __fastcall TCalibrationForm::SaveBoundaryData(void)
{
	for (int globalCameraIndex = 0; globalCameraIndex < SYSTEM_TOTAL_CAMERA_COUNT; globalCameraIndex++)
	{
		ProductData.BoundaryLeft[globalCameraIndex] = BoundaryArea[globalCameraIndex].left;
		ProductData.BoundaryTop[globalCameraIndex] = BoundaryArea[globalCameraIndex].top;
		ProductData.BoundaryRight[globalCameraIndex] = BoundaryArea[globalCameraIndex].right;
		ProductData.BoundaryBottom[globalCameraIndex] = BoundaryArea[globalCameraIndex].bottom;
	}
	AnsiString fileName = GetProductDataFileName(ProductData.ProductCode);
	if (WriteProductData(fileName, ProductData))
	{
		ShowMessageFA(CALIBRATIONFORM_MSG_10);
	}
	else
	{
		ShowMessageFA(CALIBRATIONFORM_MSG_11);
	}
}
//---------------------------------------------------------------------------
void __fastcall TCalibrationForm::LoadBoundaryData(void)
{
	for (int globalCameraIndex = 0; globalCameraIndex < SYSTEM_TOTAL_CAMERA_COUNT; globalCameraIndex++)
	{
		BoundaryArea[globalCameraIndex].left = ProductData.BoundaryLeft[globalCameraIndex];
		BoundaryArea[globalCameraIndex].top = ProductData.BoundaryTop[globalCameraIndex];
		BoundaryArea[globalCameraIndex].right = ProductData.BoundaryRight[globalCameraIndex];
		BoundaryArea[globalCameraIndex].bottom = ProductData.BoundaryBottom[globalCameraIndex];
	}
}
//---------------------------------------------------------------------------
void __fastcall TCalibrationForm::SaveButtonClick(TObject* Sender)
{
	// check boundary condition
	/*
	for (int globalCameraIndex = 0; globalCameraIndex < SYSTEM_TOTAL_CAMERA_COUNT; globalCameraIndex++)
	{
		if (BoundaryArea[globalCameraIndex].left > BoundaryArea[globalCameraIndex].right)
		{
			int temp = BoundaryArea[globalCameraIndex].left;
			BoundaryArea[globalCameraIndex].left = BoundaryArea[globalCameraIndex].right;
			BoundaryArea[globalCameraIndex].right = temp;
		}
		if (BoundaryArea[globalCameraIndex].top > BoundaryArea[globalCameraIndex].bottom)
		{
			int temp = BoundaryArea[globalCameraIndex].top;
			BoundaryArea[globalCameraIndex].top = BoundaryArea[globalCameraIndex].bottom;
			BoundaryArea[globalCameraIndex].bottom = temp;
		}

		if (BoundaryArea[globalCameraIndex].Width() < 100 ||
			BoundaryArea[globalCameraIndex].Height() < 60)
		{
			WCHAR TempString[100];
			wsprintfW(TempString, CALIBRATIONFORM_MSG_01, globalCameraIndex + 1);
			ShowMessageFA(TempString);
			return;
		}
	}
	*/

	SaveBoundaryData();
	for (int globalCameraIndex = 0; globalCameraIndex < SYSTEM_TOTAL_CAMERA_COUNT; globalCameraIndex++)
	{
		MachineParams.DiscCenterPos[globalCameraIndex] = DiscCenterPos[globalCameraIndex].y;
	}

	WriteMachineParams(ProgramPath.Env + "\\MachineInfor.ini", MachineParams);
	CPBSetupInfo.StudySetupDataValid = false;
	CPBSetupInfo.InspectionSetupDataValid = false;

	if (ActivePanel) ActivePanel->Visible = false;
	ActivePanel = NULL;
	IsBoundarySettingMode = false;
}
//---------------------------------------------------------------------------

void __fastcall TCalibrationForm::FormCreate(TObject* Sender)
{
	LoadBoundaryData();
	for (int globalCameraIndex = 0; globalCameraIndex < SYSTEM_TOTAL_CAMERA_COUNT; globalCameraIndex++)
	{
		DiscCenterPos[globalCameraIndex].x = 0;
		DiscCenterPos[globalCameraIndex].y = MachineParams.DiscCenterPos[globalCameraIndex];
		TTntEdit* cameraResEdit = (TTntEdit*)FindComponent("CameraResEdit" + IntToStr(globalCameraIndex + 1));
		if (cameraResEdit)
		{
			cameraResEdit->Text = IntToStr(MachineParams.CameraResolution[globalCameraIndex]);
		}
	}

	OnUserChange();

	CaptureImage1->Canvas->Brush->Color = clBlue;
	CaptureImage1->Canvas->Brush->Style = bsSolid;
	CaptureImage1->Canvas->FillRect(Rect(0, 0, CaptureImage1->Picture->Bitmap->Width, CaptureImage1->Picture->Bitmap->Height));

	CaptureImage1_Option->Canvas->Brush->Color = clBlue;
	CaptureImage1_Option->Canvas->Brush->Style = bsSolid;
	CaptureImage1_Option->Canvas->FillRect(Rect(0, 0, CaptureImage1_Option->Picture->Bitmap->Width, CaptureImage1_Option->Picture->Bitmap->Height));

	CaptureImage2->Canvas->Brush->Color = clBlue;
	CaptureImage2->Canvas->Brush->Style = bsSolid;
	CaptureImage2->Canvas->FillRect(Rect(0, 0, CaptureImage2->Picture->Bitmap->Width, CaptureImage2->Picture->Bitmap->Height));

	CaptureImage3->Canvas->Brush->Color = clBlue;
	CaptureImage3->Canvas->Brush->Style = bsSolid;
	CaptureImage3->Canvas->FillRect(Rect(0, 0, CaptureImage3->Picture->Bitmap->Width, CaptureImage3->Picture->Bitmap->Height));

	CaptureImage4->Canvas->Brush->Color = clBlue;
	CaptureImage4->Canvas->Brush->Style = bsSolid;
	CaptureImage4->Canvas->FillRect(Rect(0, 0, CaptureImage4->Picture->Bitmap->Width, CaptureImage4->Picture->Bitmap->Height));

	CaptureImage5->Canvas->Brush->Color = clBlue;
	CaptureImage5->Canvas->Brush->Style = bsSolid;
	CaptureImage5->Canvas->FillRect(Rect(0, 0, CaptureImage5->Picture->Bitmap->Width, CaptureImage5->Picture->Bitmap->Height));

	CaptureImage6->Canvas->Brush->Color = clBlue;
	CaptureImage6->Canvas->Brush->Style = bsSolid;
	CaptureImage6->Canvas->FillRect(Rect(0, 0, CaptureImage6->Picture->Bitmap->Width, CaptureImage6->Picture->Bitmap->Height));

	CaptureImage7->Canvas->Brush->Color = clBlue;
	CaptureImage7->Canvas->Brush->Style = bsSolid;
	CaptureImage7->Canvas->FillRect(Rect(0, 0, CaptureImage7->Picture->Bitmap->Width, CaptureImage7->Picture->Bitmap->Height));

	CaptureImage8->Canvas->Brush->Color = clBlue;
	CaptureImage8->Canvas->Brush->Style = bsSolid;
	CaptureImage8->Canvas->FillRect(Rect(0, 0, CaptureImage8->Picture->Bitmap->Width, CaptureImage8->Picture->Bitmap->Height));

	CaptureImage9->Canvas->Brush->Color = clBlue;
	CaptureImage9->Canvas->Brush->Style = bsSolid;
	CaptureImage9->Canvas->FillRect(Rect(0, 0, CaptureImage9->Picture->Bitmap->Width, CaptureImage9->Picture->Bitmap->Height));

	CaptureImage9_Option->Canvas->Brush->Color = clBlue;
	CaptureImage9_Option->Canvas->Brush->Style = bsSolid;
	CaptureImage9_Option->Canvas->FillRect(Rect(0, 0, CaptureImage9_Option->Picture->Bitmap->Width, CaptureImage9_Option->Picture->Bitmap->Height));

	CaptureImage10->Canvas->Brush->Color = clBlue;
	CaptureImage10->Canvas->Brush->Style = bsSolid;
	CaptureImage10->Canvas->FillRect(Rect(0, 0, CaptureImage10->Picture->Bitmap->Width, CaptureImage10->Picture->Bitmap->Height));

	CaptureImage11->Canvas->Brush->Color = clBlue;
	CaptureImage11->Canvas->Brush->Style = bsSolid;
	CaptureImage11->Canvas->FillRect(Rect(0, 0, CaptureImage11->Picture->Bitmap->Width, CaptureImage11->Picture->Bitmap->Height));

	CaptureImage12->Canvas->Brush->Color = clBlue;
	CaptureImage12->Canvas->Brush->Style = bsSolid;
	CaptureImage12->Canvas->FillRect(Rect(0, 0, CaptureImage12->Picture->Bitmap->Width, CaptureImage12->Picture->Bitmap->Height));

	CaptureImage13->Canvas->Brush->Color = clBlue;
	CaptureImage13->Canvas->Brush->Style = bsSolid;
	CaptureImage13->Canvas->FillRect(Rect(0, 0, CaptureImage13->Picture->Bitmap->Width, CaptureImage13->Picture->Bitmap->Height));

	CaptureImage14->Canvas->Brush->Color = clBlue;
	CaptureImage14->Canvas->Brush->Style = bsSolid;
	CaptureImage14->Canvas->FillRect(Rect(0, 0, CaptureImage14->Picture->Bitmap->Width, CaptureImage14->Picture->Bitmap->Height));

	CaptureImage15->Canvas->Brush->Color = clBlue;
	CaptureImage15->Canvas->Brush->Style = bsSolid;
	CaptureImage15->Canvas->FillRect(Rect(0, 0, CaptureImage15->Picture->Bitmap->Width, CaptureImage15->Picture->Bitmap->Height));

	CaptureImage16->Canvas->Brush->Color = clBlue;
	CaptureImage16->Canvas->Brush->Style = bsSolid;
	CaptureImage16->Canvas->FillRect(Rect(0, 0, CaptureImage16->Picture->Bitmap->Width, CaptureImage16->Picture->Bitmap->Height));

	bCaptureStopSW = false;
	bBackgroundCaptureSW = false;
	bCaptureCompleteBGI = false;


	for (int globalCameraIndex = 0; globalCameraIndex < SYSTEM_TOTAL_CAMERA_COUNT; globalCameraIndex++)
	{
		AnsiString ConvertString;
		if (SystemLinkCameraInfo[globalCameraIndex] != 0)
		{
			TTntLabel* CameraIndexLabel = (TTntLabel*)FindComponent("CameraIndexLabel" + IntToStr(globalCameraIndex + 1));
			TTntLabel* ShutterSpeedCameraLabel = (TTntLabel*)FindComponent("ShutterSpeedCameraLabel" + IntToStr(globalCameraIndex + 1));
			TTntLabel* ResolutionCam = (TTntLabel*)FindComponent("ResolutionCam" + IntToStr(globalCameraIndex + 1));
			TTntSpeedButton* CamSpeedButton = (TTntSpeedButton*)FindComponent("CamSpeedButton" + IntToStr(globalCameraIndex + 1));

			ConvertString = ConvertCameraIndex(globalCameraIndex);
			CameraIndexLabel->Caption = ConvertString;
			ShutterSpeedCameraLabel->Caption = ConvertString;
			ResolutionCam->Caption = ConvertString;
			CamSpeedButton->Caption = ConvertString;
		}
	}

	if (GlobalProgramID == PROGRAM_ID_150P)
	{
		int MoveD = ComponentReposition(1, 0, 0, CaptureImage3->Width);
		int MoveD1 = ComponentReposition(2, ShutterSpeedCameraLabel3->Left, CameraDigitalGainEdit3->Left, CameraDigitalGainEdit3->Width);
		int MoveD2 = ComponentReposition(2, ResolutionCam3->Left, CameraResEdit3->Left, CameraResEdit3->Width);
		int MoveD3 = ComponentReposition(1, 0, 0, CamSpeedButton3->Width);
		// SELMA150P
		for (int globalCameraIndex = 0; globalCameraIndex < SYSTEM_TOTAL_CAMERA_COUNT; globalCameraIndex++)
		{

			//̹ г
			TTntImage* CaptureImage = (TTntImage*)FindComponent("CaptureImage" + IntToStr(globalCameraIndex + 1));
			TTntLabel* CameraIndexLabel = (TTntLabel*)FindComponent("CameraIndexLabel" + IntToStr(globalCameraIndex + 1));
			TTntLabel* PercentLabel = (TTntLabel*)FindComponent("PercentLabel" + IntToStr(globalCameraIndex + 1));

			// SutterSpeed, Gain г
			TTntLabel* ShutterSpeedCameraLabel = (TTntLabel*)FindComponent("ShutterSpeedCameraLabel" + IntToStr(globalCameraIndex + 1));
			TTntEdit* ShutterSpeedEdit = (TTntEdit*)FindComponent("ShutterSpeedEdit" + IntToStr(globalCameraIndex + 1));
			TTntEdit* CameraDigitalGainEdit = (TTntEdit*)FindComponent("CameraDigitalGainEdit" + IntToStr(globalCameraIndex + 1));

			// Resolution г
			TTntLabel* ResolutionCam = (TTntLabel*)FindComponent("ResolutionCam" + IntToStr(globalCameraIndex + 1));
			TTntEdit* CameraResEdit = (TTntEdit*)FindComponent("CameraResEdit" + IntToStr(globalCameraIndex + 1));

			// ˻翵 
			TTntSpeedButton* CamSpeedButton = (TTntSpeedButton*)FindComponent("CamSpeedButton" + IntToStr(globalCameraIndex + 1));

			if (SystemLinkCameraInfo[globalCameraIndex] == 0)
			{

				CaptureImage->Visible = false;
				CameraIndexLabel->Visible = false;
				PercentLabel->Visible = false;
				ShutterSpeedCameraLabel->Visible = false;
				ShutterSpeedEdit->Visible = false;
				CameraDigitalGainEdit->Visible = false;
				ResolutionCam->Visible = false;
				CameraResEdit->Visible = false;
				CamSpeedButton->Visible = false;
			}
			else
			{
				//̹ г
				CaptureImage->Left += MoveD;
				CameraIndexLabel->Left += MoveD;
				PercentLabel->Left += MoveD;

				// SutterSpeed, Gain г
				ShutterSpeedCameraLabel->Left += MoveD1;
				ShutterSpeedEdit->Left += MoveD1;
				if (globalCameraIndex != SD1_3D_FRONT_FACE_CAMERA_INDEX - 1 && globalCameraIndex != SD2_3D_FRONT_FACE_CAMERA_INDEX - 1)
				{
					CameraDigitalGainEdit->Left += MoveD1;
				}
				else
				{
					ThresholdEdit5->Left += MoveD1 / 2;
					ThresholdEdit13->Left += MoveD1 / 2;
				}

				// Resolution г
				int MoveD2 = ComponentReposition(2, ResolutionCam3->Left, CameraResEdit3->Left, CameraResEdit3->Width);
				ResolutionCam->Left += MoveD2;
				CameraResEdit->Left += MoveD2;

				// ˻翵 
				CamSpeedButton->Left += MoveD3;
			}
		}
	}
	else if (ProductData.TabletType == TABLET_TYPE_SUGAR_COATED)
	{
		// Sugar coat
		for (int globalCameraIndex = 0; globalCameraIndex < SYSTEM_TOTAL_CAMERA_COUNT; globalCameraIndex++)
		{
			if (globalCameraIndex == SD1_2D_SIDE_FACE_00_CAMERA_INDEX - 1 ||
				globalCameraIndex == SD1_2D_OTHER_SIDE_FACE_00_CAMERA_INDEX - 1 ||
				globalCameraIndex == SD2_2D_SIDE_FACE_00_CAMERA_INDEX - 1 ||
				globalCameraIndex == SD2_2D_OTHER_SIDE_FACE_00_CAMERA_INDEX - 1)
			{
				//̹ г
				TTntImage* CaptureImage = (TTntImage*)FindComponent("CaptureImage" + IntToStr(globalCameraIndex + 1));
				TTntLabel* CameraIndexLabel = (TTntLabel*)FindComponent("CameraIndexLabel" + IntToStr(globalCameraIndex + 1));
				TTntLabel* PercentLabel = (TTntLabel*)FindComponent("PercentLabel" + IntToStr(globalCameraIndex + 1));

				// SutterSpeed, Gain г
				TTntLabel* ShutterSpeedCameraLabel = (TTntLabel*)FindComponent("ShutterSpeedCameraLabel" + IntToStr(globalCameraIndex + 1));
				TTntEdit* ShutterSpeedEdit = (TTntEdit*)FindComponent("ShutterSpeedEdit" + IntToStr(globalCameraIndex + 1));
				TTntEdit* CameraDigitalGainEdit = (TTntEdit*)FindComponent("CameraDigitalGainEdit" + IntToStr(globalCameraIndex + 1));

				// Resolution г
				TTntLabel* ResolutionCam = (TTntLabel*)FindComponent("ResolutionCam" + IntToStr(globalCameraIndex + 1));
				TTntEdit* CameraResEdit = (TTntEdit*)FindComponent("CameraResEdit" + IntToStr(globalCameraIndex + 1));

				// ˻翵 
				TTntSpeedButton* CamSpeedButton = (TTntSpeedButton*)FindComponent("CamSpeedButton" + IntToStr(globalCameraIndex + 1));

				if (CaptureImage)
				{
					CaptureImage->Visible = false;
				}

				if (CameraIndexLabel)
				{
					CameraIndexLabel->Visible = false;
				}

				if (PercentLabel)
				{
					PercentLabel->Visible = false;
				}

				if (ShutterSpeedCameraLabel)
				{
					ShutterSpeedCameraLabel->Visible = false;
				}

				if (ShutterSpeedEdit)
				{
					ShutterSpeedEdit->Visible = false;
				}

				if (CameraDigitalGainEdit)
				{
					CameraDigitalGainEdit->Visible = false;
				}

				if (ResolutionCam)
				{
					ResolutionCam->Visible = false;
				}

				if (CameraResEdit)
				{
					CameraResEdit->Visible = false;
				}

				if (CamSpeedButton)
				{
					CamSpeedButton->Visible = false;
				}
			}
		}
	}
}
//---------------------------------------------------------------------------

void __fastcall TCalibrationForm::CameraResSaveButtonClick(TObject* Sender)
{
	for (int globalCameraIndex = 0; globalCameraIndex < SYSTEM_TOTAL_CAMERA_COUNT; globalCameraIndex++)
	{
		TTntEdit* cameraResEdit = (TTntEdit*)FindComponent("CameraResEdit" + IntToStr(globalCameraIndex + 1));
		if (cameraResEdit)
		{
			MachineParams.CameraResolution[globalCameraIndex] = StrToInt(cameraResEdit->Text);
		}
	}
	WriteMachineParams(ProgramPath.Env + "\\MachineInfor.ini", MachineParams);
	CPBSetupInfo.StudySetupDataValid = false;
	CPBSetupInfo.InspectionSetupDataValid = false;
	if (ActivePanel) ActivePanel->Visible = false;
	ActivePanel = NULL;
}
//---------------------------------------------------------------------------

void __fastcall TCalibrationForm::CameraResolutionButtonClick(
	TObject* Sender)
{
	if (ActivePanel) ActivePanel->Visible = false;
	CameraResolutionPanel->Visible = true;
	ActivePanel = CameraResolutionPanel;
}
//---------------------------------------------------------------------------

void __fastcall TCalibrationForm::CameraResCloseButtonClick(
	TObject* Sender)
{
	if (ActivePanel) ActivePanel->Visible = false;
	ActivePanel = NULL;
}
//---------------------------------------------------------------------------

void __fastcall TCalibrationForm::BoundaryCloseButtonClick(TObject* Sender)
{
	if (ActivePanel) ActivePanel->Visible = false;
	ActivePanel = NULL;
	LoadBoundaryData();
	IsBoundarySettingMode = false;
}
//---------------------------------------------------------------------------


void __fastcall TCalibrationForm::ShutterSpeedSettingButtonClick(
	TObject* Sender)
{
	for (int globalCameraIndex = 0; globalCameraIndex < SYSTEM_TOTAL_CAMERA_COUNT; globalCameraIndex++)
	{
		TTntEdit* shutterSpeedEdit = (TTntEdit*)FindComponent("ShutterSpeedEdit" + IntToStr(globalCameraIndex + 1));
		shutterSpeedEdit->Text = IntToStr(ProductData.ShutterSpeed[globalCameraIndex]);

		if (globalCameraIndex == SD1_3D_FRONT_FACE_CAMERA_INDEX - 1 ||
			globalCameraIndex == SD2_3D_FRONT_FACE_CAMERA_INDEX - 1)
		{
			int ThreedCamIndex;
			TTntEdit* thresholdEdit = (TTntEdit*)FindComponent("ThresholdEdit" + IntToStr(globalCameraIndex + 1));

			if (globalCameraIndex == SD1_3D_FRONT_FACE_CAMERA_INDEX - 1) ThreedCamIndex = 0;
			else ThreedCamIndex = 1;

			if (ProductData.ExposureTime3D[ThreedCamIndex] != -1)
			{
				thresholdEdit->Text = IntToStr(ProductData.AnalogGain3D[ThreedCamIndex]);
				shutterSpeedEdit->Text = IntToStr(ProductData.ExposureTime3D[ThreedCamIndex]);
			}
			else
			{
				thresholdEdit->Text = IntToStr(ThreeDCameraDefaultInformation[globalCameraIndex].AnalogCameraGain);
				shutterSpeedEdit->Text = IntToStr(ThreeDCameraDefaultInformation[globalCameraIndex].ExposureTime);
			}
		}
		else
		{
			TTntEdit* DigitalGainEdit = (TTntEdit*)FindComponent("CameraDigitalGainEdit" + IntToStr(globalCameraIndex + 1));
			DigitalGainEdit->Text = IntToStr(ProductData.DigitalGainV[globalCameraIndex]);
		}
	}

	if (ActivePanel) ActivePanel->Visible = false;
	ShutterSpeedPanel->Visible = true;

	ActivePanel = ShutterSpeedPanel;
}
//---------------------------------------------------------------------------

void __fastcall TCalibrationForm::ShutterSpeedSaveButtonClick(
	TObject* Sender)
{
	for (int globalCameraIndex = 0; globalCameraIndex < SYSTEM_TOTAL_CAMERA_COUNT; globalCameraIndex++)
	{
		TTntEdit* shutterSpeedEdit = (TTntEdit*)FindComponent("ShutterSpeedEdit" + IntToStr(globalCameraIndex + 1));
		ProductData.ShutterSpeed[globalCameraIndex] = StrToInt(shutterSpeedEdit->Text);

		if (globalCameraIndex == SD1_3D_FRONT_FACE_CAMERA_INDEX - 1 ||
			globalCameraIndex == SD2_3D_FRONT_FACE_CAMERA_INDEX - 1)
		{
			TTntEdit* thresholdEdit = (TTntEdit*)FindComponent("ThresholdEdit" + IntToStr(globalCameraIndex + 1));
			ProductData.ThresholdFor3D[globalCameraIndex] = StrToInt(thresholdEdit->Text);
		}
		else
		{
			ProductData.ThresholdFor3D[globalCameraIndex] = 0;

			CameraGainList[globalCameraIndex] = StrToInt(((TTntEdit*)FindComponent("CameraDigitalGainEdit" + IntToStr(globalCameraIndex + 1)))->Text);
			ProductData.DigitalGainV[globalCameraIndex] = CameraGainList[globalCameraIndex];
		}
	}

	AnsiString fileName = GetProductDataFileName(ProductData.ProductCode);
	if (WriteProductData(fileName, ProductData))
	{
		ShowMessageFA(CALIBRATIONFORM_MSG_10);
	}
	else
	{
		ShowMessageFA(CALIBRATIONFORM_MSG_11);
	}
	if (ActivePanel) ActivePanel->Visible = false;
	ActivePanel = NULL;
}
//---------------------------------------------------------------------------

void __fastcall TCalibrationForm::CameraSettingButtonClick(TObject* Sender)
{
	TCaptureForm* captureForm = new TCaptureForm(this);
	captureForm->ShowModal();
	delete captureForm;

	if ((CameraMapInfo[SD1_3D_FRONT_FACE_CAMERA_INDEX - 1].CameraInspectPosition == CAMERA_POSITION_DISCONNECT &&
		CameraMapInfo[SD2_3D_FRONT_FACE_CAMERA_INDEX - 1].CameraInspectPosition == CAMERA_POSITION_DISCONNECT) ||
		(SystemLinkCameraInfo[SD1_3D_FRONT_FACE_CAMERA_INDEX - 1] == 0 &&
			SystemLinkCameraInfo[SD2_3D_FRONT_FACE_CAMERA_INDEX - 1] == 0))
	{
		Calibration3DButton->Enabled = false;
	}
	else
	{
		Calibration3DButton->Enabled = true;
	}

	for (int globalCameraIndex = 0; globalCameraIndex < SYSTEM_TOTAL_CAMERA_COUNT; globalCameraIndex++)
	{
		CameraShutterSpeedList[globalCameraIndex] = ProductData.ShutterSpeed[globalCameraIndex];
		CameraGainList[globalCameraIndex] = ProductData.DigitalGainV[globalCameraIndex];
	}
}
//---------------------------------------------------------------------------

void __fastcall TCalibrationForm::FormDestroy(TObject* Sender)
{
	delete CaptureBitmap;
	delete CaptureData;
	for (int imageIndex = 0; imageIndex < MAX_CAPTURE_IMAGE_COUNT; imageIndex++)
	{
		if (CaptureFileContainer[imageIndex]) delete CaptureFileContainer[imageIndex];
	}

	if (TempCaptureFileContainer) delete TempCaptureFileContainer;
}
//---------------------------------------------------------------------------
void __fastcall TCalibrationForm::NumEditClick(TObject* Sender)
{
	TTntEdit* theEdit = (TTntEdit*)Sender;
	KeyboardForm->Text = theEdit->Text;
	if (KeyboardForm->ShowKeypad() == mrOk)
	{
		if (theEdit->Tag == 98 && ShutterSpeedAllChangeCheckbox->Checked == true)
		{
			for (int i = 0; i < SYSTEM_TOTAL_CAMERA_COUNT; ++i)
			{
				if (CameraMapInfo[i].CameraInspectPosition != CAMERA_POSITION_3D)
				{
					TTntEdit* EditText = (TTntEdit*)FindComponent("ShutterSpeedEdit" + IntToStr(i + 1));
					if (i != SD1_3D_FRONT_FACE_CAMERA_INDEX - 1 && i != SD2_3D_FRONT_FACE_CAMERA_INDEX - 1)
					{
						EditText->Text = KeyboardForm->Text;
					}
				}
			}
		}
		else if (theEdit->Tag == 99 && GainAllChangeCheckbox->Checked == true)
		{
			for (int i = 0; i < SYSTEM_TOTAL_CAMERA_COUNT; ++i)
			{
				if (CameraMapInfo[i].CameraInspectPosition != CAMERA_POSITION_3D)
				{
					TTntEdit* EditText = (TTntEdit*)FindComponent("CameraDigitalGainEdit" + IntToStr(i + 1));
					if (EditText != NULL)
					{
						EditText->Text = KeyboardForm->Text;
					}
				}
			}
		}
		else
			theEdit->Text = KeyboardForm->Text;
	}
}
//---------------------------------------------------------------------------
void __fastcall TCalibrationForm::ProceedToOptionalCapture(void)
{
	//OptionalCaptureCheckTimer->Enabled = true;
	//CaptureState = ECS_OPTIONAL_CAPTURE;

	{
		//timerEnabled = false;
		CaptureState = ECS_NONE;

		// study sensor length info
		StudySensorLengthInfo();
		if (ProductData.ProcessingStep < TABLET_PROCESSING_STEP_EXTRACT_CHARACTER_REQUIRED)
		{
			ProductData.ProcessingStep = TABLET_PROCESSING_STEP_EXTRACT_CHARACTER_REQUIRED;
		}
		AnsiString fileName = GetProductDataFileName(ProductData.ProductCode);
		WriteProductData(fileName, ProductData);
		AddCSVActionLog(ECSV_ACTION_IMAGE_CAPTURE_COMPLETE, UserInfo.Name, ProductData.ProductName, NULL, 0);

		ShowMessageFA(CALIBRATIONFORM_MSG_08);
		CaptureMessageLabel->Caption = CALIBRATIONFORM_LABEL_CAPTION_06;
		CaptureStopButton->Enabled = false;
		CaptureStartButton->Enabled = true;
		CloseButton->Enabled = true;
		ShutterSpeedSettingButton->Enabled = true;
		AutoShutterSpeedSettingButton->Enabled = true;
		SpeedControlBtn->Enabled = true;
		BoundarySettingButton->Enabled = true;
		Calibration3DButton->Enabled = true;
		CameraSettingButton->Enabled = true;
		CameraResolutionButton->Enabled = true;
	}



}
//---------------------------------------------------------------------------


void __fastcall TCalibrationForm::Calibration3DButtonClick(TObject* Sender)
{
	if (ActivePanel == ShutterSpeedPanel)
	{
		ActivePanel = NULL;
		ShutterSpeedPanel->Visible = false;
	}
	TCalibration3DForm* calibration3DForm = new TCalibration3DForm(this);

	if (calibration3DForm->ShowModal() == mrOk)
	{
		ProductData.ShutterSpeed[SD1_3D_FRONT_FACE_CAMERA_INDEX - 1] = ProductData.ExposureTime3D[0];
		ProductData.ShutterSpeed[SD2_3D_FRONT_FACE_CAMERA_INDEX - 1] = ProductData.ExposureTime3D[1];

		AnsiString fileName = GetProductDataFileName(ProductData.ProductCode);
		if (!WriteProductData(fileName, ProductData))
		{
			ShowMessageFA(CALIBRATIONFORM_MSG_11);
		}
	}
	delete calibration3DForm;
}
//---------------------------------------------------------------------------
void __fastcall TCalibrationForm::OnUserChange(void)
{
	if (!ProgramAccessAuthorityData.ProgramAccessAuthorityTable[UserInfo.AccessLevel][ACCESS_PGM_EVT_MAINFORM_CAPTURE])
	{
		this->Close();
	}

	if (ProgramAccessAuthorityData.ProgramAccessAuthorityTable[UserInfo.AccessLevel][ACCESS_PGM_EVT_CALIBRATIONFORM_CAMERA_SETUP])
		CameraSettingButton->Visible = true;
	else
		CameraSettingButton->Visible = false;

	if (ProgramAccessAuthorityData.ProgramAccessAuthorityTable[UserInfo.AccessLevel][ACCESS_PGM_EVT_CALIBRATIONFORM_RESOLUTION_SETUP])
		CameraResolutionButton->Visible = true;
	else
		CameraResolutionButton->Visible = false;

	if (ProgramAccessAuthorityData.ProgramAccessAuthorityTable[UserInfo.AccessLevel][ACCESS_PGM_EVT_CALIBRATIONFORM_AREA_SETUP])
		AreaKindSpeedButton5->Visible = true;
	else
		AreaKindSpeedButton5->Visible = false;

	if (ProgramAccessAuthorityData.ProgramAccessAuthorityTable[UserInfo.AccessLevel][ACCESS_PGM_EVT_CALIBRATIONFORM_AREA_SETUP])
		BoundarySettingButton->Visible = true;
	else
		BoundarySettingButton->Visible = false;

	if (ProgramAccessAuthorityData.ProgramAccessAuthorityTable[UserInfo.AccessLevel][ACCESS_PGM_EVT_CALIBRATIONFORM_3D_CAMERA_SETUP])
		Calibration3DButton->Visible = true;
	else
		Calibration3DButton->Visible = false;

	if (ProgramAccessAuthorityData.ProgramAccessAuthorityTable[UserInfo.AccessLevel][ACCESS_PGM_EVT_CALIBRATIONFORM_BRIGHTNESS_SETUP])
	{
		ShutterSpeedSettingButton->Visible = true;
		AutoShutterSpeedSettingButton->Visible = true;
	}
	else
	{
		ShutterSpeedSettingButton->Visible = false;
		AutoShutterSpeedSettingButton->Visible = false;
	}

	if (ProgramAccessAuthorityData.ProgramAccessAuthorityTable[UserInfo.AccessLevel][ACCESS_PGM_EVT_CALIBRATIONFORM_SPEED_CONTROL])
		SpeedControlBtn->Visible = true;
	else
		SpeedControlBtn->Visible = false;

	if (ProgramAccessAuthorityData.ProgramAccessAuthorityTable[UserInfo.AccessLevel][ACCESS_PGM_EVT_CALIBRATIONFORM_CAPTURE_STOP])
		CaptureStopButton->Visible = true;
	else
		CaptureStopButton->Visible = false;

	if (ProgramAccessAuthorityData.ProgramAccessAuthorityTable[UserInfo.AccessLevel][ACCESS_PGM_EVT_CALIBRATIONFORM_CAPTURE_START])
		CaptureStartButton->Visible = true;
	else
		CaptureStartButton->Visible = false;
}
//---------------------------------------------------------------------------
void __fastcall TCalibrationForm::StudySensorLengthInfo(void)
{
	int requestNum = 1;
	TTabletInfo HCBTabletInfo;
	Comm_Request(COMM_HCB, CMD_TABLET_PROCESS_INFO, &requestNum, sizeof(int), &HCBTabletInfo, sizeof(TTabletInfo));
	int SensorLengthList[2][100];
	int SensorLengthCount[2];

	//============ Sensor 1 ==================
	SensorLengthCount[0] = 0;
	for (int listIndex = 0; listIndex < HCB_TABLET_LIST_COUNT; listIndex++)
	{
		if (HCBTabletInfo.Disk1TabletList[listIndex].State == TABLET_STATE_CAPTURE_1_COMPLETE)
		{
			SensorLengthList[0][SensorLengthCount[0]] = HCBTabletInfo.Disk1TabletList[listIndex].Sensor1Length;
			SensorLengthCount[0]++;
			if (SensorLengthCount[0] == 100) break;
		}
	}
	// sort sensor length list

	for (int i = 0; i < SensorLengthCount[0]; i++)
	{
		for (int j = i + 1; j < SensorLengthCount[0]; j++)
		{
			if (SensorLengthList[0][i] > SensorLengthList[0][j])
			{
				int temp = SensorLengthList[0][i];
				SensorLengthList[0][i] = SensorLengthList[0][j];
				SensorLengthList[0][j] = temp;
			}
		}
	}
	int median = SensorLengthList[0][SensorLengthCount[0] / 2];
	int validLengthSum = 0;
	int validLengthCount = 0;
	for (int lengthIndex = 0; lengthIndex < SensorLengthCount[0]; lengthIndex++)
	{
		if (abs(median - SensorLengthList[0][lengthIndex]) < 20)	// 1ms ̳ 
		{
			validLengthSum += SensorLengthList[0][lengthIndex];
			validLengthCount++;
		}
	}

	if (validLengthCount >= 10)	// ּ 10
	{
		ProductData.StudiedSensor1Length = (validLengthSum + (validLengthCount / 2))
			* MachineSetupData.ServoMotorData[SD1_MOTOR_INDEX].BaseSpeed
			/ validLengthCount / ProductData.StudyMotorSpeedList[SD1_MOTOR_INDEX][0];   /// studyspeed khs
	}

	//=============Sensor 2 ==================
	SensorLengthCount[1] = 0;
	for (int listIndex = 0; listIndex < HCB_TABLET_LIST_COUNT; listIndex++)
	{
		if (HCBTabletInfo.Disk2TabletList[listIndex].State == TABLET_STATE_COMPLETE)
		{
			SensorLengthList[1][SensorLengthCount[1]] = HCBTabletInfo.Disk2TabletList[listIndex].Sensor2Length;
			SensorLengthCount[1]++;
			if (SensorLengthCount[1] == 100) break;
		}
	}
	// sort sensor length list

	for (int i = 0; i < SensorLengthCount[1]; i++)
	{
		for (int j = i + 1; j < SensorLengthCount[1]; j++)
		{
			if (SensorLengthList[1][i] > SensorLengthList[1][j])
			{
				int temp = SensorLengthList[1][i];
				SensorLengthList[1][i] = SensorLengthList[1][j];
				SensorLengthList[1][j] = temp;
			}
		}
	}
	median = SensorLengthList[1][SensorLengthCount[1] / 2];
	validLengthSum = 0;
	validLengthCount = 0;
	for (int lengthIndex = 0; lengthIndex < SensorLengthCount[1]; lengthIndex++)
	{
		if (abs(median - SensorLengthList[1][lengthIndex]) < 20)	// 1ms ̳ 
		{
			validLengthSum += SensorLengthList[1][lengthIndex];
			validLengthCount++;
		}
	}

	if (validLengthCount >= 10)	// ּ 10
	{
		ProductData.StudiedSensor2Length = (validLengthSum + (validLengthCount / 2))
			* MachineSetupData.ServoMotorData[SD2_MOTOR_INDEX].BaseSpeed
			/ validLengthCount / ProductData.StudyMotorSpeedList[SD2_MOTOR_INDEX][0];   /// studyspeed khs
	}

	//sjm Add 
	//================Sensor 3 ====================
	SensorLengthCount[2] = 0;
	for (int listIndex = 0; listIndex < HCB_TABLET_LIST_COUNT; listIndex++)
	{
		if (HCBTabletInfo.Disk2TabletList[listIndex].State == TABLET_STATE_COMPLETE)
		{
			//SensorLengthList[2][SensorLengthCount[2]] = HCBTabletInfo.Disk2TabletList[listIndex].Sensor3Length;
			SensorLengthList[2][SensorLengthCount[2]] = HCBTabletInfo.CounterTabletList[listIndex].Sensor3Length;
			SensorLengthCount[2]++;
			if (SensorLengthCount[2] == 100) break;
		}
	}

	for (int i = 0; i < SensorLengthCount[2]; i++)
	{
		for (int j = i + 1; j < SensorLengthCount[2]; j++)
		{
			if (SensorLengthList[2][i] > SensorLengthList[2][j])
			{
				int temp = SensorLengthList[2][i];
				SensorLengthList[2][i] = SensorLengthList[2][j];
				SensorLengthList[2][j] = temp;
			}
		}
	}
	median = SensorLengthList[2][SensorLengthCount[2] / 2];
	validLengthSum = 0;
	validLengthCount = 0;
	for (int lengthIndex = 0; lengthIndex < SensorLengthCount[2]; lengthIndex++)
	{
		if (abs(median - SensorLengthList[2][lengthIndex]) < 20)	// 1ms ̳ 
		{
			validLengthSum += SensorLengthList[2][lengthIndex];
			validLengthCount++;
		}
	}

	if (validLengthCount >= 10)	// ּ 10
	{
		ProductData.StudiedSensor3Length = (validLengthSum + (validLengthCount / 2))
			* MachineSetupData.ServoMotorData[SD2_MOTOR_INDEX].BaseSpeed
			/ validLengthCount / ProductData.StudyMotorSpeedList[SD2_MOTOR_INDEX][0];
	}
	//ShowMessage("StudySensorLengthInfo");
	//ShowMessage(ProductData.StudiedSensor3Length);
	//=================================================

	if (IntervalStudyCount1 > 0)
	{
		ProductData.StudiedSensorIntervalA = OptimalSensorIntervalA;
	}
	if (IntervalStudyCount2 > 0)
	{
		ProductData.StudiedSensorIntervalB = OptimalSensorIntervalB;
	}
}
//---------------------------------------------------------------------------

void __fastcall TCalibrationForm::SensorIntervalTimerTimer(TObject* Sender)
{
	SensorIntervalTimer->Enabled = false;

	int requestNum = 1;
	TTabletInfo HCBTabletInfo;
	Comm_Request(COMM_HCB, CMD_TABLET_PROCESS_INFO, &requestNum, sizeof(int), &HCBTabletInfo, sizeof(TTabletInfo));
	int SensorTimeList[3][HCB_TABLET_LIST_COUNT];
	int SensorTimeCount[3];
	int SensorLengthList[3][HCB_TABLET_LIST_COUNT];
	int SensorLengthCount[3];
	int IntervalList[2][HCB_TABLET_LIST_COUNT];
	int IntervalCount[2];
	unsigned char IntervalDisplayTable[DISPLAY_SENSOR_INFO_WIDTH];
	unsigned char SensorLengthTable[DISPLAY_SENSOR_INFO_WIDTH];

	int ExpectedSensorIntervalA = MachineSetupData.SensorIntervalA * ProductData.StudyMotorSpeedList[0][0] / MachineSetupData.ServoMotorData[SD1_MOTOR_INDEX].BaseSpeed;  /// studyspeed khs
	int ExpectedSensorIntervalB = MachineSetupData.SensorIntervalB * ProductData.StudyMotorSpeedList[0][0] / MachineSetupData.ServoMotorData[SD1_MOTOR_INDEX].BaseSpeed;

	IntervalCount[0] = 0;
	IntervalCount[1] = 0;
	try
	{
		SensorLengthCount[0] = 0;
		SensorTimeCount[0] = 0;
		for (int listIndex = 0; listIndex < HCB_TABLET_LIST_COUNT; listIndex++)
		{
			if (HCBTabletInfo.Disk1TabletList[listIndex].State == TABLET_STATE_CAPTURE_1_COMPLETE)
			{
				if (SensorLengthCount[0] < 100)
				{
					SensorLengthList[0][SensorLengthCount[0]] = HCBTabletInfo.Disk1TabletList[listIndex].Sensor1Length;
					SensorLengthCount[0]++;
				}
				SensorTimeList[0][SensorTimeCount[0]] = HCBTabletInfo.Disk1TabletList[listIndex].Sensor1Time;
				SensorTimeCount[0]++;
			}
			else
			{
				//break;
			}
		}

		SensorLengthCount[1] = 0;
		SensorTimeCount[1] = 0;
		for (int listIndex = 0; listIndex < HCB_TABLET_LIST_COUNT; listIndex++)
		{
			if (HCBTabletInfo.Disk2TabletList[listIndex].State == TABLET_STATE_COMPLETE)
			{
				if (SensorLengthCount[1] < 100)
				{
					SensorLengthList[1][SensorLengthCount[1]] = HCBTabletInfo.Disk2TabletList[listIndex].Sensor2Length;
					SensorLengthCount[1]++;
				}
				SensorTimeList[1][SensorTimeCount[1]] = HCBTabletInfo.Disk2TabletList[listIndex].Sensor2Time;
				SensorTimeCount[1]++;
			}
		}

		SensorLengthCount[2] = 0;
		SensorTimeCount[2] = 0;

		for (int listIndex = 0; listIndex < HCB_TABLET_LIST_COUNT; listIndex++)
		{
			if (HCBTabletInfo.Disk2TabletList[listIndex].State == TABLET_STATE_COMPLETE)
			{
				if (SensorLengthCount[2] < 100)
				{
					SensorLengthList[2][SensorLengthCount[2]] = HCBTabletInfo.CounterTabletList[listIndex].Sensor3Length;
					SensorLengthCount[2]++;
				}
				SensorTimeList[2][SensorTimeCount[2]] = HCBTabletInfo.CounterTabletList[listIndex].Sensor3Time;
				SensorTimeCount[2]++;
			}
		}

		if (SensorTimeCount[0] == 0 || SensorTimeCount[1] == 0 || SensorTimeCount[2] == 0) throw Exception("Tablet Not Passed");

		int firstSensorTableIndex = 0;
		int secondSensorTableIndex = 0;
		int baseInterval = 0;		//  interval  ´.
		while (true)		// find base interval
		{
			int newInterval = SensorTimeList[1][secondSensorTableIndex] - SensorTimeList[0][firstSensorTableIndex];
			if (newInterval <= ExpectedSensorIntervalA - 400)		// +-20ms  Ѵ.
			{
				secondSensorTableIndex++;
				if (secondSensorTableIndex == SensorTimeCount[1]) break;
			}
			else if (newInterval > ExpectedSensorIntervalA + 400)
			{
				firstSensorTableIndex++;
				if (firstSensorTableIndex == SensorTimeCount[0]) break;
			}
			else
			{
				baseInterval = newInterval;
				break;
			}
		}
		if (baseInterval == 0) throw Exception("Base Interval Can not Detected");

		firstSensorTableIndex = 0;
		secondSensorTableIndex = 0;

		memset(IntervalDisplayTable, 0, DISPLAY_SENSOR_INFO_WIDTH * sizeof(unsigned char));
		while (true)
		{
			int firstInterval, secondInterval;
			if (secondSensorTableIndex >= SensorTimeCount[1] || firstSensorTableIndex >= SensorTimeCount[0] - 1) break;

			firstInterval = SensorTimeList[1][secondSensorTableIndex] - SensorTimeList[0][firstSensorTableIndex];
			secondInterval = SensorTimeList[1][secondSensorTableIndex] - SensorTimeList[0][firstSensorTableIndex + 1];
			if (firstInterval < baseInterval - 200)	// too fast interval
			{
				secondSensorTableIndex++;
			}
			else if (abs(firstInterval - baseInterval) > abs(secondInterval - baseInterval))
			{
				firstSensorTableIndex++;
			}
			else
			{
				IntervalList[0][IntervalCount[0]] = firstInterval;

				/*
				for (int sensorLengthX = -SensorLengthList[1][secondSensorTableIndex] / 2; sensorLengthX < SensorLengthList[1][secondSensorTableIndex] / 2; sensorLengthX += 2)
				{
					int displayValue = (firstInterval - ExpectedSensorIntervalA + sensorLengthX) / 2 + 200;
					if (displayValue >= 0 && displayValue < 400)
					{
						IntervalDisplayTable[displayValue]++;
					}
				}
				*/

				int startValue;
				int endValue;
				startValue = (firstInterval - ExpectedSensorIntervalA + -SensorLengthList[1][secondSensorTableIndex] / 2) / 2 + DISPLAY_SENSOR_INFO_WIDTH / 2;
				endValue = (firstInterval - ExpectedSensorIntervalA + SensorLengthList[1][secondSensorTableIndex] / 2) / 2 + DISPLAY_SENSOR_INFO_WIDTH / 2;

				for (int displayValue = startValue; displayValue < endValue; displayValue++)
				{
					if (displayValue >= 0 && displayValue < DISPLAY_SENSOR_INFO_WIDTH)
					{
						if (IntervalDisplayTable[displayValue] < 100)
						{
							IntervalDisplayTable[displayValue]++;
						}
					}
				}

				firstSensorTableIndex++;
				secondSensorTableIndex++;
				IntervalCount[0]++;
				if (IntervalCount[0] == 99) break;
			}
		}

		if (IntervalCount[0] == 0) throw Exception("Interval Not Matched");

		int intervalSum = 0;
		int minInterval = IntervalList[0][0];
		int maxInterval = IntervalList[0][0];
		// anaylze interval
		for (int intervalIndex = 0; intervalIndex < IntervalCount[0]; intervalIndex++)
		{
			intervalSum += (IntervalList[0][intervalIndex] - ExpectedSensorIntervalA);
			if (minInterval > IntervalList[0][intervalIndex])
			{
				minInterval = IntervalList[0][intervalIndex];
			}
			if (maxInterval < IntervalList[0][intervalIndex])
			{
				maxInterval = IntervalList[0][intervalIndex];
			}
		}

		int averageInterval = intervalSum / IntervalCount[0];

		int intervalMatchingValue = 0;
		for (int intervalIndex = 0; intervalIndex < IntervalCount[0]; intervalIndex++)
		{
			if (abs(IntervalList[0][intervalIndex] - ExpectedSensorIntervalA - averageInterval) <= 100)
			{
				intervalMatchingValue += 2;
			}
			else if (abs(IntervalList[0][intervalIndex] - ExpectedSensorIntervalA - averageInterval) <= 200)
			{
				intervalMatchingValue += 1;
			}
		}

		// display matching image
		int tempCount;
		int IntervalCenterPos;

		IntervalCenterPos = tempCount = 0;
		for (int y = 0; y < SensorIntervalImage1->Height; y++)
		{
			byte* pBitmap = (byte*)SensorIntervalImage1->Picture->Bitmap->ScanLine[y];
			for (int x = 0; x < DISPLAY_SENSOR_INFO_WIDTH; x++)
			{
				pBitmap[3 * x + 0] = (100 - IntervalDisplayTable[x]) * 255 / 100;
				pBitmap[3 * x + 1] = IntervalDisplayTable[x] * 255 / 100;
				pBitmap[3 * x + 2] = 0;

				if (!(pBitmap[3 * x + 0] == 255 && pBitmap[3 * x + 1] == 0 && pBitmap[3 * x + 2] == 0))
				{
					IntervalCenterPos += x;
					tempCount++;
				}
			}
		}

		if (tempCount)
		{
			IntervalCenterPos /= tempCount;
		}
		else
		{
			IntervalCenterPos = DISPLAY_SENSOR_INFO_WIDTH / 2;
		}

		SensorIntervalImage1->Repaint();

		if (IntervalCount[0] > 0)
		{
			WCHAR TempString[100];

			wsprintfW(TempString, L"%S\%", FloatToStrF((float)IntervalCount[0] * 100 / 99, ffFixed, 10, 2));
			IntervalCheckRatioLabel1->Caption = TempString;

			wsprintfW(TempString, L"%S\%", FloatToStrF(intervalMatchingValue * 100 / 2.0 / IntervalCount[0], ffFixed, 10, 2));
			IntervalMatchingRatioLabel1->Caption = TempString;

			wsprintfW(TempString, L"%Sms", FloatToStrF((ExpectedSensorIntervalA + averageInterval) / 20.0, ffFixed, 10, 2));
			OptimalTimingLabel1->Caption = TempString;

			wsprintfW(TempString, L"%Sms", FloatToStrF((maxInterval - ExpectedSensorIntervalA - averageInterval) / 20.0, ffFixed, 10, 2));
			MaxIntervalLabel1->Caption = TempString;

			wsprintfW(TempString, L"%Sms", FloatToStrF((minInterval - ExpectedSensorIntervalA - averageInterval) / 20.0, ffFixed, 10, 2));
			MinIntervalLabel1->Caption = TempString;

			AverageIntervalShape1->Left = SensorIntervalImage1->Left + IntervalCenterPos;
			OptimalTimingLabel1->Left = SensorIntervalImage1->Left + IntervalCenterPos - OptimalTimingLabel1->Width / 2;

			AverageIntervalShape1->Visible = true;
			OptimalTimingLabel1->Visible = true;

			IntervalStudyCount1 = IntervalCount[0];
			OptimalSensorIntervalA = (ExpectedSensorIntervalA + averageInterval) *
				MachineSetupData.ServoMotorData[SD1_MOTOR_INDEX].BaseSpeed / ProductData.StudyMotorSpeedList[0][0];  /// studyspeed khs
		}
		else
		{
			IntervalCheckRatioLabel1->Caption = "0%";
			IntervalMatchingRatioLabel1->Caption = "0%";

			WCHAR TempString[100];
			wsprintfW(TempString, L"%Sms", FloatToStrF(ExpectedSensorIntervalA / 20.0, ffFixed, 10, 2));
			OptimalTimingLabel1->Caption = TempString;

			wsprintfW(TempString, L"%Sms", FloatToStrF((0) / 20.0, ffFixed, 10, 2));
			MaxIntervalLabel1->Caption = TempString;

			wsprintfW(TempString, L"%Sms", FloatToStrF((0) / 20.0, ffFixed, 10, 2));
			MinIntervalLabel1->Caption = TempString;

			AverageIntervalShape1->Visible = false;
			OptimalTimingLabel1->Visible = false;
		}

		firstSensorTableIndex = 0;
		secondSensorTableIndex = 0;
		baseInterval = 0;		//  interval  ´.
		while (true)		// find base interval
		{
			int newInterval = SensorTimeList[2][secondSensorTableIndex] - SensorTimeList[1][firstSensorTableIndex];
			if (newInterval <= ExpectedSensorIntervalB - 400)		// +-20ms  Ѵ.
			{
				secondSensorTableIndex++;
				if (secondSensorTableIndex == SensorTimeCount[2]) break;
			}
			else if (newInterval > ExpectedSensorIntervalB + 400)
			{
				firstSensorTableIndex++;
				if (firstSensorTableIndex == SensorTimeCount[1]) break;
			}
			else
			{
				baseInterval = newInterval;
				break;
			}
		}
		if (baseInterval == 0) throw Exception("Base Interval Can not Detected");

		firstSensorTableIndex = 0;
		secondSensorTableIndex = 0;

		memset(IntervalDisplayTable, 0, DISPLAY_SENSOR_INFO_WIDTH * sizeof(unsigned char));
		while (true)
		{
			int firstInterval, secondInterval;
			if (secondSensorTableIndex >= SensorTimeCount[2] || firstSensorTableIndex >= SensorTimeCount[1] - 1) break;

			firstInterval = SensorTimeList[2][secondSensorTableIndex] - SensorTimeList[1][firstSensorTableIndex];
			secondInterval = SensorTimeList[2][secondSensorTableIndex] - SensorTimeList[1][firstSensorTableIndex + 1];
			if (firstInterval < baseInterval - 200)	// too fast interval
			{
				secondSensorTableIndex++;
			}
			else if (abs(firstInterval - baseInterval) > abs(secondInterval - baseInterval))
			{
				firstSensorTableIndex++;
			}
			else
			{
				IntervalList[1][IntervalCount[1]] = firstInterval;

				/*
				for (int sensorLengthX = -SensorLengthList[2][secondSensorTableIndex] / 2; sensorLengthX < SensorLengthList[2][secondSensorTableIndex] / 2; sensorLengthX += 2)
				{
					int displayValue = (firstInterval - ExpectedSensorIntervalB + sensorLengthX) / 2 + 200;
					if (displayValue >= 0 && displayValue < 400)
					{
						IntervalDisplayTable[displayValue]++;
					}
				}
				*/

				int startValue;
				int endValue;
				startValue = (firstInterval - ExpectedSensorIntervalB + -SensorLengthList[2][secondSensorTableIndex] / 2) / 2 + DISPLAY_SENSOR_INFO_WIDTH / 2;
				endValue = (firstInterval - ExpectedSensorIntervalB + SensorLengthList[2][secondSensorTableIndex] / 2) / 2 + DISPLAY_SENSOR_INFO_WIDTH / 2;

				for (int displayValue = startValue; displayValue < endValue; displayValue++)
				{
					if (displayValue >= 0 && displayValue < DISPLAY_SENSOR_INFO_WIDTH)
					{
						if (IntervalDisplayTable[displayValue] < 100)
						{
							IntervalDisplayTable[displayValue]++;
						}
					}
				}

				firstSensorTableIndex++;
				secondSensorTableIndex++;
				IntervalCount[1]++;
				if (IntervalCount[1] == 99) break;
			}
		}

		if (IntervalCount[1] == 0) throw Exception("Interval Not Matched");

		intervalSum = 0;
		minInterval = IntervalList[1][0];
		maxInterval = IntervalList[1][0];
		// anaylze interval
		for (int intervalIndex = 0; intervalIndex < IntervalCount[1]; intervalIndex++)
		{
			intervalSum += (IntervalList[1][intervalIndex] - ExpectedSensorIntervalB);
			if (minInterval > IntervalList[1][intervalIndex])
			{
				minInterval = IntervalList[1][intervalIndex];
			}
			if (maxInterval < IntervalList[1][intervalIndex])
			{
				maxInterval = IntervalList[1][intervalIndex];
			}
		}

		averageInterval = intervalSum / IntervalCount[1];

		intervalMatchingValue = 0;
		for (int intervalIndex = 0; intervalIndex < IntervalCount[1]; intervalIndex++)
		{
			if (abs(IntervalList[1][intervalIndex] - ExpectedSensorIntervalB - averageInterval) <= 100)
			{
				intervalMatchingValue += 2;
			}
			else if (abs(IntervalList[1][intervalIndex] - ExpectedSensorIntervalB - averageInterval) <= 200)
			{
				intervalMatchingValue += 1;
			}
		}

		// display matching image
		IntervalCenterPos = tempCount = 0;
		for (int y = 0; y < SensorIntervalImage2->Height; y++)
		{
			byte* pBitmap = (byte*)SensorIntervalImage2->Picture->Bitmap->ScanLine[y];
			for (int x = 0; x < DISPLAY_SENSOR_INFO_WIDTH; x++)
			{
				pBitmap[3 * x + 0] = (100 - IntervalDisplayTable[x]) * 255 / 100;
				pBitmap[3 * x + 1] = IntervalDisplayTable[x] * 255 / 100;
				pBitmap[3 * x + 2] = 0;

				if (!(pBitmap[3 * x + 0] == 255 && pBitmap[3 * x + 1] == 0 && pBitmap[3 * x + 2] == 0))
				{
					IntervalCenterPos += x;
					tempCount++;
				}
			}
		}

		if (tempCount)
		{
			IntervalCenterPos /= tempCount;
		}
		else
		{
			IntervalCenterPos = DISPLAY_SENSOR_INFO_WIDTH / 2;
		}

		SensorIntervalImage2->Repaint();

		if (IntervalCount[1] > 0)
		{
			WCHAR TempString[100];
			wsprintfW(TempString, L"%S\%", FloatToStrF((float)IntervalCount[1] * 100 / 99, ffFixed, 10, 2));
			IntervalCheckRatioLabel2->Caption = TempString;

			wsprintfW(TempString, L"%S\%", FloatToStrF(intervalMatchingValue * 100 / 2.0 / IntervalCount[1], ffFixed, 10, 2));
			IntervalMatchingRatioLabel2->Caption = TempString;

			wsprintfW(TempString, L"%Sms", FloatToStrF((ExpectedSensorIntervalB + averageInterval) / 20.0, ffFixed, 10, 2));
			OptimalTimingLabel2->Caption = TempString;

			wsprintfW(TempString, L"%Sms", FloatToStrF((maxInterval - ExpectedSensorIntervalB - averageInterval) / 20.0, ffFixed, 10, 2));
			MaxIntervalLabel2->Caption = TempString;

			wsprintfW(TempString, L"%Sms", FloatToStrF((minInterval - ExpectedSensorIntervalB - averageInterval) / 20.0, ffFixed, 10, 2));
			MinIntervalLabel2->Caption = TempString;

			AverageIntervalShape2->Left = SensorIntervalImage2->Left + IntervalCenterPos;
			OptimalTimingLabel2->Left = SensorIntervalImage2->Left + IntervalCenterPos - OptimalTimingLabel2->Width / 2;

			AverageIntervalShape2->Visible = true;
			OptimalTimingLabel2->Visible = true;

			IntervalStudyCount2 = IntervalCount[1];
			OptimalSensorIntervalB = (ExpectedSensorIntervalB + averageInterval) *
				MachineSetupData.ServoMotorData[SD1_MOTOR_INDEX].BaseSpeed / ProductData.StudyMotorSpeedList[0][0];    /// studyspeed khs
		}
		else
		{
			IntervalCheckRatioLabel2->Caption = "0%";
			IntervalMatchingRatioLabel2->Caption = "0%";

			WCHAR TempString[100];

			wsprintfW(TempString, L"%Sms", FloatToStrF(ExpectedSensorIntervalB / 20.0, ffFixed, 10, 2));
			OptimalTimingLabel2->Caption = TempString;

			wsprintfW(TempString, L"%Sms", FloatToStrF((0) / 20.0, ffFixed, 10, 2));
			MaxIntervalLabel2->Caption = TempString;

			wsprintfW(TempString, L"%Sms", FloatToStrF((0) / 20.0, ffFixed, 10, 2));
			MinIntervalLabel2->Caption = TempString;

			AverageIntervalShape2->Visible = false;
			OptimalTimingLabel2->Visible = false;
		}
	}
	catch (...)
	{
		for (int y = 0; y < SensorIntervalImage1->Height; y++)
		{
			byte* pBitmap = (byte*)SensorIntervalImage1->Picture->Bitmap->ScanLine[y];
			for (int x = 0; x < DISPLAY_SENSOR_INFO_WIDTH; x++)
			{
				pBitmap[3 * x + 0] = 0xFF;
				pBitmap[3 * x + 1] = 0;
				pBitmap[3 * x + 2] = 0;
			}
		}

		for (int y = 0; y < SensorIntervalImage2->Height; y++)
		{
			byte* pBitmap = (byte*)SensorIntervalImage2->Picture->Bitmap->ScanLine[y];
			for (int x = 0; x < DISPLAY_SENSOR_INFO_WIDTH; x++)
			{
				pBitmap[3 * x + 0] = 0xFF;
				pBitmap[3 * x + 1] = 0;
				pBitmap[3 * x + 2] = 0;
			}
		}

		IntervalCheckRatioLabel1->Caption = "0%";
		IntervalMatchingRatioLabel1->Caption = "0%";

		WCHAR TempString[100];

		wsprintfW(TempString, L"%Sms", FloatToStrF(ExpectedSensorIntervalA / 20.0, ffFixed, 10, 2));
		OptimalTimingLabel1->Caption = TempString;


		wsprintfW(TempString, L"%Sms", FloatToStrF((0) / 20.0, ffFixed, 10, 2));
		MaxIntervalLabel1->Caption = TempString;


		wsprintfW(TempString, L"%Sms", FloatToStrF((0) / 20.0, ffFixed, 10, 2));
		MinIntervalLabel1->Caption = TempString;

		AverageIntervalShape1->Visible = false;
		OptimalTimingLabel1->Visible = false;

		IntervalCheckRatioLabel2->Caption = "0%";
		IntervalMatchingRatioLabel2->Caption = "0%";

		wsprintfW(TempString, L"%Sms", FloatToStrF(ExpectedSensorIntervalB / 20.0, ffFixed, 10, 2));
		OptimalTimingLabel2->Caption = TempString;

		wsprintfW(TempString, L"%Sms", FloatToStrF((0) / 20.0, ffFixed, 10, 2));
		MaxIntervalLabel2->Caption = TempString;

		wsprintfW(TempString, L"%Sms", FloatToStrF((0) / 20.0, ffFixed, 10, 2));
		MinIntervalLabel2->Caption = TempString;

		AverageIntervalShape2->Visible = false;
		OptimalTimingLabel2->Visible = false;
	}

	// display sensor length
	if (SensorLengthCount[0] > 0)
	{
		int lengthSum = 0;
		int minLength = SensorLengthList[0][0];
		int maxLength = SensorLengthList[0][0];

		memset(SensorLengthTable, 0, DISPLAY_SENSOR_INFO_WIDTH * sizeof(unsigned char));
		for (int listIndex = 0; listIndex < SensorLengthCount[0]; listIndex++)
		{
			lengthSum += SensorLengthList[0][listIndex];
			if (minLength > SensorLengthList[0][listIndex])
			{
				minLength = SensorLengthList[0][listIndex];
			}
			if (maxLength < SensorLengthList[0][listIndex])
			{
				maxLength = SensorLengthList[0][listIndex];
			}

			for (int x = SensorLengthList[0][listIndex] / 2 - 5; x < SensorLengthList[0][listIndex] / 2 + 5; x++)
			{
				if (x >= 0 && x < DISPLAY_SENSOR_INFO_WIDTH)
				{
					SensorLengthTable[x]++;
				}
			}
		}

		int averageLength = lengthSum / SensorLengthCount[0];

		int minLengthPos;
		int maxLengthPos;
		bool reportSensorLengthSW;

		minLengthPos = DISPLAY_SENSOR_INFO_WIDTH;
		maxLengthPos = 0;
		reportSensorLengthSW = false;
		for (int y = 0; y < SensorLengthImage1->Height; y++)
		{
			byte* pBitmap = (byte*)SensorLengthImage1->Picture->Bitmap->ScanLine[y];
			for (int x = 0; x < DISPLAY_SENSOR_INFO_WIDTH; x++)
			{
				pBitmap[3 * x + 0] = (SensorLengthCount[0] - SensorLengthTable[x]) * 255 / SensorLengthCount[0];
				pBitmap[3 * x + 1] = SensorLengthTable[x] * 255 / SensorLengthCount[0];
				pBitmap[3 * x + 2] = 0;

				if (!(pBitmap[3 * x + 0] == 255 && pBitmap[3 * x + 1] == 0 && pBitmap[3 * x + 2] == 0))
				{
					if (minLengthPos >= x) minLengthPos = x;
					if (maxLengthPos <= x) maxLengthPos = x;

					reportSensorLengthSW = true;
				}
			}
		}

		if (reportSensorLengthSW)
		{
			if (minLengthPos + 3 < DISPLAY_SENSOR_INFO_WIDTH)
			{
				for (int y = 0; y < SensorLengthImage1->Height; y++)
				{
					byte* pBitmap = (byte*)SensorLengthImage1->Picture->Bitmap->ScanLine[y];
					pBitmap[3 * (minLengthPos + 3) + 0] = 0;
					pBitmap[3 * (minLengthPos + 3) + 1] = 0;
					pBitmap[3 * (minLengthPos + 3) + 2] = 0xFF;
				}
			}

			if (maxLengthPos - 2 > 0)
			{
				for (int y = 0; y < SensorLengthImage1->Height; y++)
				{
					byte* pBitmap = (byte*)SensorLengthImage1->Picture->Bitmap->ScanLine[y];
					pBitmap[3 * (maxLengthPos - 2) + 0] = 0;
					pBitmap[3 * (maxLengthPos - 2) + 1] = 0;
					pBitmap[3 * (maxLengthPos - 2) + 2] = 0xFF;
				}
			}
		}

		SensorLengthImage1->Repaint();

		WCHAR TempString[100];

		wsprintfW(TempString, L"%S\%", FloatToStrF((float)SensorLengthCount[0], ffFixed, 10, 2));
		LengthCheckRatioLabel1->Caption = TempString;

		wsprintfW(TempString, L"%d", averageLength);
		OptimalLengthLabel1->Caption = TempString;

		wsprintfW(TempString, L"%Sms", FloatToStrF((maxLength - averageLength) / 20.0, ffFixed, 10, 2));
		MaxLengthLabel1->Caption = TempString;

		wsprintfW(TempString, L"%Sms", FloatToStrF((minLength - averageLength) / 20.0, ffFixed, 10, 2));
		MinLengthLabel1->Caption = TempString;

		AverageLengthShape1->Left = SensorLengthImage1->Left + (averageLength) / 2;
		OptimalLengthLabel1->Left = SensorLengthImage1->Left + (averageLength) / 2 - OptimalLengthLabel1->Width / 2;
		AverageLengthShape1->Visible = true;
		OptimalLengthLabel1->Visible = true;
	}
	else
	{
		LengthCheckRatioLabel1->Caption = "0%";
		WCHAR TempString[100];

		wsprintfW(TempString, L"%d", 0);
		OptimalLengthLabel1->Caption = TempString;

		wsprintfW(TempString, L"%Sms", FloatToStrF((0) / 20.0, ffFixed, 10, 2));
		MaxLengthLabel1->Caption = TempString;

		wsprintfW(TempString, L"%Sms", FloatToStrF((0) / 20.0, ffFixed, 10, 2));
		MinLengthLabel1->Caption = TempString;

		AverageLengthShape1->Visible = false;
		OptimalLengthLabel1->Visible = false;
	}


	if (SensorLengthCount[1] > 0)
	{
		int lengthSum = 0;
		int minLength = SensorLengthList[1][0];
		int maxLength = SensorLengthList[1][0];

		memset(SensorLengthTable, 0, DISPLAY_SENSOR_INFO_WIDTH * sizeof(unsigned char));
		for (int listIndex = 0; listIndex < SensorLengthCount[1]; listIndex++)
		{
			lengthSum += SensorLengthList[1][listIndex];
			if (minLength > SensorLengthList[1][listIndex])
			{
				minLength = SensorLengthList[1][listIndex];
			}
			if (maxLength < SensorLengthList[1][listIndex])
			{
				maxLength = SensorLengthList[1][listIndex];
			}


			for (int x = SensorLengthList[1][listIndex] / 2 - 5; x < SensorLengthList[1][listIndex] / 2 + 5; x++)
			{
				if (x >= 0 && x < DISPLAY_SENSOR_INFO_WIDTH)
				{
					SensorLengthTable[x]++;
				}
			}
		}

		int averageLength = lengthSum / SensorLengthCount[1];

		int minLengthPos;
		int maxLengthPos;
		bool reportSensorLengthSW;

		minLengthPos = DISPLAY_SENSOR_INFO_WIDTH;
		maxLengthPos = 0;
		reportSensorLengthSW = false;
		for (int y = 0; y < SensorLengthImage2->Height; y++)
		{
			byte* pBitmap = (byte*)SensorLengthImage2->Picture->Bitmap->ScanLine[y];
			for (int x = 0; x < DISPLAY_SENSOR_INFO_WIDTH; x++)
			{
				pBitmap[3 * x + 0] = (SensorLengthCount[1] - SensorLengthTable[x]) * 255 / SensorLengthCount[1];
				pBitmap[3 * x + 1] = SensorLengthTable[x] * 255 / SensorLengthCount[1];
				pBitmap[3 * x + 2] = 0;

				if (!(pBitmap[3 * x + 0] == 255 && pBitmap[3 * x + 1] == 0 && pBitmap[3 * x + 2] == 0))
				{
					if (minLengthPos >= x) minLengthPos = x;
					if (maxLengthPos <= x) maxLengthPos = x;

					reportSensorLengthSW = true;
				}
			}
		}

		if (reportSensorLengthSW)
		{
			if (minLengthPos + 3 < DISPLAY_SENSOR_INFO_WIDTH)
			{
				for (int y = 0; y < SensorLengthImage2->Height; y++)
				{
					byte* pBitmap = (byte*)SensorLengthImage2->Picture->Bitmap->ScanLine[y];
					pBitmap[3 * (minLengthPos + 3) + 0] = 0;
					pBitmap[3 * (minLengthPos + 3) + 1] = 0;
					pBitmap[3 * (minLengthPos + 3) + 2] = 0xFF;
				}
			}

			if (maxLengthPos - 2 > 0)
			{
				for (int y = 0; y < SensorLengthImage2->Height; y++)
				{
					byte* pBitmap = (byte*)SensorLengthImage2->Picture->Bitmap->ScanLine[y];
					pBitmap[3 * (maxLengthPos - 2) + 0] = 0;
					pBitmap[3 * (maxLengthPos - 2) + 1] = 0;
					pBitmap[3 * (maxLengthPos - 2) + 2] = 0xFF;
				}
			}
		}

		SensorLengthImage2->Repaint();

		WCHAR TempString[100];

		wsprintfW(TempString, L"%S\%", FloatToStrF((float)SensorLengthCount[1], ffFixed, 10, 2));
		LengthCheckRatioLabel2->Caption = TempString;

		wsprintfW(TempString, L"%d", averageLength);
		OptimalLengthLabel2->Caption = TempString;

		wsprintfW(TempString, L"%Sms", FloatToStrF((maxLength - averageLength) / 20.0, ffFixed, 10, 2));
		MaxLengthLabel2->Caption = TempString;

		wsprintfW(TempString, L"%Sms", FloatToStrF((minLength - averageLength) / 20.0, ffFixed, 10, 2));
		MinLengthLabel2->Caption = TempString;

		AverageLengthShape2->Left = SensorLengthImage2->Left + (averageLength) / 2;
		OptimalLengthLabel2->Left = SensorLengthImage2->Left + (averageLength) / 2 - OptimalLengthLabel2->Width / 2;
		AverageLengthShape2->Visible = true;
		OptimalLengthLabel2->Visible = true;
	}
	else
	{
		LengthCheckRatioLabel2->Caption = "0%";

		WCHAR TempString[100];

		wsprintfW(TempString, L"%d", 0);
		OptimalLengthLabel2->Caption = TempString;

		wsprintfW(TempString, L"%Sms", FloatToStrF((0) / 20.0, ffFixed, 10, 2));
		MaxLengthLabel2->Caption = TempString;

		wsprintfW(TempString, L"%Sms", FloatToStrF((0) / 20.0, ffFixed, 10, 2));
		MinLengthLabel2->Caption = TempString;

		AverageLengthShape2->Visible = false;
		OptimalLengthLabel2->Visible = false;
	}


	if (SensorLengthCount[2] > 0)
	{
		int lengthSum = 0;
		int minLength = SensorLengthList[2][0];
		int maxLength = SensorLengthList[2][0];

		memset(SensorLengthTable, 0, DISPLAY_SENSOR_INFO_WIDTH * sizeof(unsigned char));
		for (int listIndex = 0; listIndex < SensorLengthCount[2]; listIndex++)
		{
			lengthSum += SensorLengthList[2][listIndex];
			if (minLength > SensorLengthList[2][listIndex])
			{
				minLength = SensorLengthList[2][listIndex];
			}
			if (maxLength < SensorLengthList[2][listIndex])
			{
				maxLength = SensorLengthList[2][listIndex];
			}


			for (int x = SensorLengthList[2][listIndex] / 2 - 5; x < SensorLengthList[2][listIndex] / 2 + 5; x++)
			{
				if (x >= 0 && x < DISPLAY_SENSOR_INFO_WIDTH)
				{
					SensorLengthTable[x]++;
				}
			}
		}

		int averageLength = lengthSum / SensorLengthCount[2];

		int minLengthPos;
		int maxLengthPos;
		bool reportSensorLengthSW;

		minLengthPos = DISPLAY_SENSOR_INFO_WIDTH;
		maxLengthPos = 0;
		reportSensorLengthSW = false;
		for (int y = 0; y < SensorLengthImage3->Height; y++)
		{
			byte* pBitmap = (byte*)SensorLengthImage3->Picture->Bitmap->ScanLine[y];
			for (int x = 0; x < DISPLAY_SENSOR_INFO_WIDTH; x++)
			{
				pBitmap[3 * x + 0] = (SensorLengthCount[2] - SensorLengthTable[x]) * 255 / SensorLengthCount[2];
				pBitmap[3 * x + 1] = SensorLengthTable[x] * 255 / SensorLengthCount[2];
				pBitmap[3 * x + 2] = 0;

				if (!(pBitmap[3 * x + 0] == 255 && pBitmap[3 * x + 1] == 0 && pBitmap[3 * x + 2] == 0))
				{
					if (minLengthPos >= x) minLengthPos = x;
					if (maxLengthPos <= x) maxLengthPos = x;

					reportSensorLengthSW = true;
				}
			}
		}

		if (reportSensorLengthSW)
		{
			if (minLengthPos + 3 < DISPLAY_SENSOR_INFO_WIDTH)
			{
				for (int y = 0; y < SensorLengthImage3->Height; y++)
				{
					byte* pBitmap = (byte*)SensorLengthImage3->Picture->Bitmap->ScanLine[y];
					pBitmap[3 * (minLengthPos + 3) + 0] = 0;
					pBitmap[3 * (minLengthPos + 3) + 1] = 0;
					pBitmap[3 * (minLengthPos + 3) + 2] = 0xFF;
				}
			}

			if (maxLengthPos - 2 > 0)
			{
				for (int y = 0; y < SensorLengthImage3->Height; y++)
				{
					byte* pBitmap = (byte*)SensorLengthImage3->Picture->Bitmap->ScanLine[y];
					pBitmap[3 * (maxLengthPos - 2) + 0] = 0;
					pBitmap[3 * (maxLengthPos - 2) + 1] = 0;
					pBitmap[3 * (maxLengthPos - 2) + 2] = 0xFF;
				}
			}
		}

		SensorLengthImage3->Repaint();

		WCHAR TempString[100];

		wsprintfW(TempString, L"%S\%", FloatToStrF((float)SensorLengthCount[2], ffFixed, 10, 2));
		LengthCheckRatioLabel3->Caption = TempString;

		wsprintfW(TempString, L"%d", averageLength);
		OptimalLengthLabel3->Caption = TempString;

		wsprintfW(TempString, L"%Sms", FloatToStrF((maxLength - averageLength) / 20.0, ffFixed, 10, 2));
		MaxLengthLabel3->Caption = TempString;

		wsprintfW(TempString, L"%Sms", FloatToStrF((minLength - averageLength) / 20.0, ffFixed, 10, 2));
		MinLengthLabel3->Caption = TempString;

		AverageLengthShape3->Left = SensorLengthImage3->Left + (averageLength) / 2;
		OptimalLengthLabel3->Left = SensorLengthImage3->Left + (averageLength) / 2 - OptimalLengthLabel3->Width / 2;
		AverageLengthShape3->Visible = true;
		OptimalLengthLabel3->Visible = true;
	}
	else
	{
		LengthCheckRatioLabel3->Caption = "0%";

		WCHAR TempString[100];

		wsprintfW(TempString, L"%d", 0);
		OptimalLengthLabel3->Caption = TempString;

		wsprintfW(TempString, L"%Sms", FloatToStrF((0) / 20.0, ffFixed, 10, 2));
		MaxLengthLabel3->Caption = TempString;

		wsprintfW(TempString, L"%Sms", FloatToStrF((0) / 20.0, ffFixed, 10, 2));
		MinLengthLabel3->Caption = TempString;

		AverageLengthShape3->Visible = false;
		OptimalLengthLabel3->Visible = false;
	}

	if (IntervalCount[0] >= 99 && IntervalCount[1] >= 99)
	{
		SensorIntervalTimer->Enabled = false;
	}
	else
	{
		SensorIntervalTimer->Enabled = true;
	}
}
//---------------------------------------------------------------------------

void __fastcall TCalibrationForm::SpeedControlBtnClick(TObject* Sender)
{
	TStudySpeedControlForm* studyspeedControlForm = new TStudySpeedControlForm(this);
	studyspeedControlForm->ShowModal();
	delete studyspeedControlForm;
}
//---------------------------------------------------------------------------

void __fastcall TCalibrationForm::RefreshCameraInfo(int camIndex, float m)
{
	int ShutterSpeed = 0;
	int Threshold = 0;
	int WriteMask = 0;

	// Shutter 
	ShutterSpeed = ProductData.ShutterSpeed[camIndex] * m;

	if (CameraMapInfo[camIndex].CameraInspectPosition == CAMERA_POSITION_3D)
		WriteMask |= CAMERA_WRITE_MASK_3D_SH;
	else
		WriteMask |= CAMERA_WRITE_MASK_2D_SH;

	// Threshold 3D ī޶󿡸 
	if (CameraMapInfo[camIndex].CameraInspectPosition == CAMERA_POSITION_3D)
	{
		Threshold = ProductData.ThresholdFor3D[camIndex];
		WriteMask |= CAMERA_WRITE_MASK_TH;
	}

	TROIInfo DefaultROIInfo, ApplyROIInfo;
	AnsiString filePath;
	int DiskBaseHeight;
	int tempStartY, tempEndY, tempRowCount;
	filePath = ProgramPath.Env + "\\NFACameraInformation.ini";
	DefaultROIInfo = ReadCameraInformation(filePath, camIndex);

	if (CameraMapInfo[camIndex].CameraInspectPosition != CAMERA_POSITION_3D)
	{
		memcpy(&ApplyROIInfo, &DefaultROIInfo, sizeof(TROIInfo));
		WriteMask |= CAMERA_WRITE_MASK_2D_ROI;
	}
	else
	{
		ApplyROIInfo = SetThreeDCameraROI(DefaultROIInfo, &ProductData);
		WriteMask |= CAMERA_WRITE_MASK_3D_ROI;
	}

	if (CameraMapInfo[camIndex].CameraInspectPosition != CAMERA_POSITION_3D)
	{
		WriteMask |= CAMERA_WRITE_MASK_2D_SUBSAMPLING_MODE;
	}

	if (CameraMapInfo[camIndex].CameraInspectPosition != CAMERA_POSITION_3D)
	{
		SetCameraInformation(ApplyROIInfo, ShutterSpeed, Threshold, ProductData.SubSamplingMode, camIndex, WriteMask);
		SetCameraGain(camIndex + 1, SYSTEM_DEFAULT_ANLOG_GAIN, ProductData.DigitalGainV[camIndex], 0);
	}
	else
	{
		WriteMask |= CAMERA_WRITE_MASK_3D_SH;

		int ThreedCameraIndex = 0;
		if (camIndex == SD1_3D_FRONT_FACE_CAMERA_INDEX - 1) ThreedCameraIndex = 0;
		else ThreedCameraIndex = 1;

		if (ProductData.ExposureTime3D[ThreedCameraIndex] != -1)
		{
			Set3DCamera_CaptureParameter(camIndex, ProductData.AnalogGain3D[ThreedCameraIndex], ProductData.ExposureTime3D[ThreedCameraIndex]);
		}
		else
		{

			Set3DCamera_CaptureParameter(camIndex, ThreeDCameraDefaultInformation[camIndex].AnalogCameraGain, ThreeDCameraDefaultInformation[camIndex].ExposureTime);
		}
	}

}
//---------------------------------------------------------------------------
TTntImage* TCalibrationForm::GetImagePanelPointer(int Cameraindex)
{
	/* if(CameraMapInfo[Cameraindex].CameraInspectPosition == CAMERA_POSITION_3D)
	 {
		 TTntImage * test = (TTntImage *)FindComponent("CaptureImage" + IntToStr(Cameraindex + 1));
		 Set3DPalette(test->Picture->Bitmap);
		 return test;
	 }
	 else  */
	return (TTntImage*)FindComponent("CaptureImage" + IntToStr(Cameraindex + 1));
}
//---------------------------------------------------------------------------
void __fastcall TCalibrationForm::Button1Click(TObject* Sender)
{
	//ImgSaveThreadController = true;
	//ImageSaveThreadHandle= (HANDLE)_beginthreadex(NULL,NULL,ImageConvertSaveThread,this,0,(unsigned int*)&ThreadDword);
	ImgViewThreadController = true;
	ImageViewThreadHandle = (HANDLE)_beginthreadex(NULL, NULL, ImageViewThread, this, 0, (unsigned int*)&ThreadDword);


}
//---------------------------------------------------------------------------
void __fastcall TCalibrationForm::SensorInfoControlBtnClick(
	TObject* Sender)
{
	if (SensorTimingPanel->Visible == true)
	{
		SensorInfoControlBtn->Caption = CALIBRATIONFORM_LABEL_CAPTION_16;
		SensorTimingPanel->Visible = false;
	}
	else
	{
		SensorInfoControlBtn->Caption = CALIBRATIONFORM_LABEL_CAPTION_17;
		SensorTimingPanel->Visible = true;
	}
}
//---------------------------------------------------------------------------

void __fastcall TCalibrationForm::Button2Click(TObject* Sender)
{
	ImgViewThreadController = false;
}
//---------------------------------------------------------------------------

void __fastcall TCalibrationForm::AutoShutterSpeedSettingButtonClick(
	TObject* Sender)
{
	TAutoBrightnessSettingForm* pAutoBrightnessSettingForm = new TAutoBrightnessSettingForm(this);
	pAutoBrightnessSettingForm->ShowModal();
	delete pAutoBrightnessSettingForm;
}
//---------------------------------------------------------------------------

void __fastcall TCalibrationForm::InitImageComponents()
{
	CaptureImage1->Width = CaptureImgWidth;
	CaptureImage1->Height = CaptureImgHeight;
	CaptureImage1->Picture->Bitmap->Width = CaptureWidth;
	CaptureImage1->Picture->Bitmap->Height = CaptureHeight;
	CaptureImage1->Picture->Bitmap->PixelFormat = pf24bit;

	CaptureImage1->Canvas->Brush->Color = clBlue;
	CaptureImage1->Canvas->Brush->Style = bsSolid;
	CaptureImage1->Canvas->FillRect(Rect(0, 0, CaptureImage1->Picture->Bitmap->Width, CaptureImage1->Picture->Bitmap->Height));
	CaptureImage1_Option->Canvas->Brush->Color = clBlue;
	CaptureImage1_Option->Canvas->Brush->Style = bsSolid;
	CaptureImage1_Option->Canvas->FillRect(Rect(0, 0, CaptureImage1_Option->Picture->Bitmap->Width, CaptureImage1_Option->Picture->Bitmap->Height));
	CaptureImage2->Canvas->Brush->Color = clBlue;
	CaptureImage2->Canvas->Brush->Style = bsSolid;
	CaptureImage2->Canvas->FillRect(Rect(0, 0, CaptureImage2->Picture->Bitmap->Width, CaptureImage2->Picture->Bitmap->Height));
	CaptureImage3->Canvas->Brush->Color = clBlue;
	CaptureImage3->Canvas->Brush->Style = bsSolid;
	CaptureImage3->Canvas->FillRect(Rect(0, 0, CaptureImage3->Picture->Bitmap->Width, CaptureImage3->Picture->Bitmap->Height));
	CaptureImage4->Canvas->Brush->Color = clBlue;
	CaptureImage4->Canvas->Brush->Style = bsSolid;
	CaptureImage4->Canvas->FillRect(Rect(0, 0, CaptureImage4->Picture->Bitmap->Width, CaptureImage4->Picture->Bitmap->Height));
	CaptureImage5->Canvas->Brush->Color = clBlue;
	CaptureImage5->Canvas->Brush->Style = bsSolid;
	CaptureImage5->Canvas->FillRect(Rect(0, 0, CaptureImage5->Picture->Bitmap->Width, CaptureImage5->Picture->Bitmap->Height));
	CaptureImage6->Canvas->Brush->Color = clBlue;
	CaptureImage6->Canvas->Brush->Style = bsSolid;
	CaptureImage6->Canvas->FillRect(Rect(0, 0, CaptureImage6->Picture->Bitmap->Width, CaptureImage6->Picture->Bitmap->Height));
	CaptureImage7->Canvas->Brush->Color = clBlue;
	CaptureImage7->Canvas->Brush->Style = bsSolid;
	CaptureImage7->Canvas->FillRect(Rect(0, 0, CaptureImage7->Picture->Bitmap->Width, CaptureImage7->Picture->Bitmap->Height));
	CaptureImage8->Canvas->Brush->Color = clBlue;
	CaptureImage8->Canvas->Brush->Style = bsSolid;
	CaptureImage8->Canvas->FillRect(Rect(0, 0, CaptureImage8->Picture->Bitmap->Width, CaptureImage8->Picture->Bitmap->Height));
	CaptureImage9->Canvas->Brush->Color = clBlue;
	CaptureImage9->Canvas->Brush->Style = bsSolid;
	CaptureImage9->Canvas->FillRect(Rect(0, 0, CaptureImage9->Picture->Bitmap->Width, CaptureImage9->Picture->Bitmap->Height));
	CaptureImage9_Option->Canvas->Brush->Color = clBlue;
	CaptureImage9_Option->Canvas->Brush->Style = bsSolid;
	CaptureImage9_Option->Canvas->FillRect(Rect(0, 0, CaptureImage9_Option->Picture->Bitmap->Width, CaptureImage9_Option->Picture->Bitmap->Height));
	CaptureImage10->Canvas->Brush->Color = clBlue;
	CaptureImage10->Canvas->Brush->Style = bsSolid;
	CaptureImage10->Canvas->FillRect(Rect(0, 0, CaptureImage10->Picture->Bitmap->Width, CaptureImage10->Picture->Bitmap->Height));
	CaptureImage11->Canvas->Brush->Color = clBlue;
	CaptureImage11->Canvas->Brush->Style = bsSolid;
	CaptureImage11->Canvas->FillRect(Rect(0, 0, CaptureImage11->Picture->Bitmap->Width, CaptureImage11->Picture->Bitmap->Height));
	CaptureImage12->Canvas->Brush->Color = clBlue;
	CaptureImage12->Canvas->Brush->Style = bsSolid;
	CaptureImage12->Canvas->FillRect(Rect(0, 0, CaptureImage12->Picture->Bitmap->Width, CaptureImage12->Picture->Bitmap->Height));
	CaptureImage13->Canvas->Brush->Color = clBlue;
	CaptureImage13->Canvas->Brush->Style = bsSolid;
	CaptureImage13->Canvas->FillRect(Rect(0, 0, CaptureImage13->Picture->Bitmap->Width, CaptureImage13->Picture->Bitmap->Height));
	CaptureImage14->Canvas->Brush->Color = clBlue;
	CaptureImage14->Canvas->Brush->Style = bsSolid;
	CaptureImage14->Canvas->FillRect(Rect(0, 0, CaptureImage14->Picture->Bitmap->Width, CaptureImage14->Picture->Bitmap->Height));
	CaptureImage15->Canvas->Brush->Color = clBlue;
	CaptureImage15->Canvas->Brush->Style = bsSolid;
	CaptureImage15->Canvas->FillRect(Rect(0, 0, CaptureImage15->Picture->Bitmap->Width, CaptureImage15->Picture->Bitmap->Height));
	CaptureImage16->Canvas->Brush->Color = clBlue;
	CaptureImage16->Canvas->Brush->Style = bsSolid;
	CaptureImage16->Canvas->FillRect(Rect(0, 0, CaptureImage16->Picture->Bitmap->Width, CaptureImage16->Picture->Bitmap->Height));

	CaptureImage1->Visible = true;
	CaptureImage2->Visible = true;
	CaptureImage3->Visible = true;
	CaptureImage4->Visible = true;
	CaptureImage5->Visible = true;
	CaptureImage6->Visible = true;
	CaptureImage7->Visible = true;
	CaptureImage8->Visible = true;
	CaptureImage9->Visible = true;
	CaptureImage10->Visible = true;
	CaptureImage11->Visible = true;
	CaptureImage12->Visible = true;
	CaptureImage13->Visible = true;
	CaptureImage14->Visible = true;
	CaptureImage15->Visible = true;
	CaptureImage16->Visible = true;

	CameraIndexLabel1->Visible = true;
	CameraIndexLabel2->Visible = true;
	CameraIndexLabel3->Visible = true;
	CameraIndexLabel4->Visible = true;
	CameraIndexLabel5->Visible = true;
	CameraIndexLabel6->Visible = true;
	CameraIndexLabel7->Visible = true;
	CameraIndexLabel8->Visible = true;
	CameraIndexLabel9->Visible = true;
	CameraIndexLabel10->Visible = true;
	CameraIndexLabel11->Visible = true;
	CameraIndexLabel12->Visible = true;
	CameraIndexLabel13->Visible = true;
	CameraIndexLabel14->Visible = true;
	CameraIndexLabel15->Visible = true;
	CameraIndexLabel16->Visible = true;

	if (GlobalProgramID == PROGRAM_ID_150P)
	{
		// ̹г
		CaptureImage3->Visible = false;
		CameraIndexLabel3->Visible = false;
		PercentLabel3->Visible = false;

		CaptureImage7->Visible = false;
		CameraIndexLabel7->Visible = false;
		PercentLabel7->Visible = false;

		CaptureImage11->Visible = false;
		CameraIndexLabel11->Visible = false;
		PercentLabel11->Visible = false;

		CaptureImage15->Visible = false;
		CameraIndexLabel15->Visible = false;
		PercentLabel15->Visible = false;
	}
	else if (ProductData.TabletType == TABLET_TYPE_SUGAR_COATED)
	{
		// ̹г
		CaptureImage3->Visible = false;
		CameraIndexLabel3->Visible = false;
		PercentLabel3->Visible = false;

		CaptureImage7->Visible = false;
		CameraIndexLabel7->Visible = false;
		PercentLabel7->Visible = false;

		CaptureImage11->Visible = false;
		CameraIndexLabel11->Visible = false;
		PercentLabel11->Visible = false;

		CaptureImage15->Visible = false;
		CameraIndexLabel15->Visible = false;
		PercentLabel15->Visible = false;
	}
}
//---------------------------------------------------------------------------
void __fastcall TCalibrationForm::MachineControlForBackground(bool Active, int Disk1StudySpeed, int Disk1BaseSpeed, int Disk2StudySpeed, int Disk2BaseSpeed)
{
	if (Active)
	{
		int motorIndex;
		int baseSpeed;
		int targetSpeed;
		int accTime;
		int dir;

		// DISK1
		motorIndex = 0;
		baseSpeed = Disk1BaseSpeed;
		targetSpeed = Disk1StudySpeed;
		accTime = MachineSetupData.ServoMotorData[motorIndex].AccTime;
		dir = 0;

		if (MachineSetupData.ServoMotorData[motorIndex].Dir)
		{
			dir = 1;
		}
		else
		{
			dir = 0;
		}
		Machine.ServoMotorRun(motorIndex, baseSpeed, targetSpeed, accTime, dir);

		// DISK2
		motorIndex = 1;
		baseSpeed = Disk2BaseSpeed;
		targetSpeed = Disk2StudySpeed;
		accTime = MachineSetupData.ServoMotorData[motorIndex].AccTime;
		dir = 0;

		if (MachineSetupData.ServoMotorData[motorIndex].Dir)
		{
			dir = 1;
		}
		else
		{
			dir = 0;
		}
		Machine.ServoMotorRun(motorIndex, baseSpeed, targetSpeed, accTime, dir);
	}
	else
	{
		// motor stop
		int decTime;
		decTime = MachineSetupData.ServoMotorData[0].DecTime;
		Machine.ServoMotorStop(0, decTime);
		decTime = MachineSetupData.ServoMotorData[1].DecTime;
		Machine.ServoMotorStop(1, decTime);

		double motorRunTime = Now().Val;

		MachineControlPanel->BringToFront();
		MachineControlPanel->Visible = true;
		CaptureStopButton->Enabled = false;

		while (1)
		{
			Application->ProcessMessages();

			float Disk1RealRPM = Machine.GetServoMotorRPM(0);
			float Disk2RealRPM = Machine.GetServoMotorRPM(1);

			double currentTime = Now().Val;

			if (((currentTime - motorRunTime) * 24 * 3600 > MAX_SERVO_MOTOR_STOPPING_TIME)
				|| (Disk1RealRPM < 0.1 && Disk2RealRPM < 0.1))
			{
				MachineControlPanel->Visible = false;
				CaptureStopButton->Enabled = true;

				ImgViewThreadController = false;
				CaptureEndFlag = false;
				CaptureCheckTimer->Enabled = false;
				SensorIntervalTimer->Enabled = false;

				ImgSaveThreadController = false;
				ProccessAlarmPanel->Visible = false;

				CaptureStartButton->Enabled = true;
				CaptureStopButton->Enabled = false;
				CloseButton->Enabled = true;
				ShutterSpeedSettingButton->Enabled = true;
				AutoShutterSpeedSettingButton->Enabled = true;
				SpeedControlBtn->Enabled = true;
				BoundarySettingButton->Enabled = true;
				Calibration3DButton->Enabled = true;
				CameraSettingButton->Enabled = true;
				CameraResolutionButton->Enabled = true;

				bBackgroundCaptureSW = false;
				bCaptureCompleteBGI = false;
				bCaptureStopSW = false;

				int captureCount[2];
				if (CaptureState == ECS_OPTIONAL_CAPTURE)
				{
					captureCount[0] = MAX_CAPTURE_IMAGE_COUNT;
					captureCount[1] = CaptureProcessGauge->Progress;
				}
				else
				{
					captureCount[0] = CaptureProcessGauge->Progress;
					captureCount[1] = 0;
				}
				break;
			}
		}
	}
}
//---------------------------------------------------------------------------
void __fastcall TCalibrationForm::BackgroundImageUploadTimerTimer(
	TObject* Sender)
{
	bool timerEnabled = BackgroundImageUploadTimer->Enabled;
	BackgroundImageUploadTimer->Enabled = false;
	bool bCaptureExist;
	unsigned int data[2];
	unsigned int receivedData[2];

	for (int globalCameraIndex = 0; globalCameraIndex < SYSTEM_TOTAL_CAMERA_COUNT; globalCameraIndex++)
	{
		if (CameraMapInfo[globalCameraIndex].CameraInspectPosition != CAMERA_POSITION_DISCONNECT &&
			CameraMapInfo[globalCameraIndex].CameraInspectPosition != CAMERA_POSITION_3D && SystemLinkCameraInfo[globalCameraIndex] != 0)
		{
			if (CurrentCamImageIndex[globalCameraIndex] < MAX_BACKGROUND_IMAGE_COUNT)
			{
				int spbIndex = CameraMapInfo[globalCameraIndex].SPBIndex;
				int camIndex = CameraMapInfo[globalCameraIndex].CamIndex;
				data[0] = camIndex;

				try
				{
					if (Comm_IsConnected(COMM_SPB + spbIndex))
					{
						if (!Comm_Request(COMM_SPB + spbIndex, CMD_CAPTURE_EXIST, data, sizeof(unsigned int),
							receivedData, sizeof(unsigned int) * 2))
						{

						}

						if (receivedData[0])
						{
							bCaptureExist = true;
						}
						else
						{
							bCaptureExist = false;
						}

						if (bCaptureExist)
						{
							data[1] = MAX_IMAGE_WIDTH * MAX_IMAGE_HEIGHT;
							if (!Comm_Request(COMM_SPB + spbIndex, CMD_CAPTURE_UPLOAD, data, 2 * sizeof(unsigned int),
								CaptureData, MAX_IMAGE_WIDTH * MAX_IMAGE_HEIGHT))
							{

							}

							for (int y = 0; y < SYSTEM_CAMERA_HEIGHT; y++)
							{
								for (int x = 0; x < SYSTEM_CAMERA_WIDTH; x++)
								{
									int tempAddress = SYSTEM_CAMERA_WIDTH * y + x;
									BackgroundImage[globalCameraIndex][tempAddress] += CaptureData[tempAddress];
								}
							}

							TTntImage* DestImage;
							DestImage = (TTntImage*)FindComponent("CaptureImage" + IntToStr(globalCameraIndex + 1));

							GetNFACamera2DColorImage(DestImage->Picture->Bitmap, CaptureData, MAX_IMAGE_WIDTH, MAX_IMAGE_HEIGHT, globalCameraIndex, SystemImageOffsetSWCal[globalCameraIndex], SystemOffsetImage[globalCameraIndex], ProductData.SubSamplingMode);

							// For SELMA200,    
							if (globalCameraIndex == SD2_2D_SIDE_FACE_P45_CAMERA_INDEX - 1 ||
								globalCameraIndex == SD2_2D_SIDE_FACE_M45_CAMERA_INDEX - 1)
							{
								byte* pTempLine = new byte[DestImage->Picture->Bitmap->Width * 3];
								for (int y = 0; y < (DestImage->Picture->Bitmap->Height); y++)
								{
									byte* pBitmap = (byte*)DestImage->Picture->Bitmap->ScanLine[y];

									for (int x = 0; x < DestImage->Picture->Bitmap->Width; x++)
									{
										pTempLine[x * 3 + 0] = pBitmap[(DestImage->Picture->Bitmap->Width - 1 - x) * 3 + 0];
										pTempLine[x * 3 + 1] = pBitmap[(DestImage->Picture->Bitmap->Width - 1 - x) * 3 + 1];
										pTempLine[x * 3 + 2] = pBitmap[(DestImage->Picture->Bitmap->Width - 1 - x) * 3 + 2];
									}
									memcpy(pBitmap, pTempLine, DestImage->Picture->Bitmap->Width * 3);
								}
								delete[] pTempLine;
							}
							else if (globalCameraIndex == SD1_2D_FRONT_FACE_CAMERA_INDEX - 1 ||
								globalCameraIndex == SD2_2D_FRONT_FACE_CAMERA_INDEX - 1 ||
								globalCameraIndex == SD1_2D_SIDE_FACE_00_CAMERA_INDEX - 1 ||
								globalCameraIndex == SD1_2D_OTHER_SIDE_FACE_00_CAMERA_INDEX - 1 ||
								globalCameraIndex == SD1_2D_SIDE_FACE_P45_CAMERA_INDEX - 1 ||
								globalCameraIndex == SD1_2D_OTHER_SIDE_FACE_P45_CAMERA_INDEX - 1 ||
								globalCameraIndex == SD1_2D_SIDE_FACE_M45_CAMERA_INDEX - 1 ||
								globalCameraIndex == SD1_2D_OTHER_SIDE_FACE_M45_CAMERA_INDEX - 1)
							{
								byte* pTempLineT = new byte[DestImage->Picture->Bitmap->Width * 3];
								byte* pTempLineB = new byte[DestImage->Picture->Bitmap->Width * 3];
								for (int y = 0; y < (DestImage->Picture->Bitmap->Height + 1) / 2; y++)
								{
									byte* pBitmapT = (byte*)DestImage->Picture->Bitmap->ScanLine[y];
									byte* pBitmapB = (byte*)DestImage->Picture->Bitmap->ScanLine[DestImage->Picture->Bitmap->Height - 1 - y];

									memcpy(pTempLineT, pBitmapB, DestImage->Picture->Bitmap->Width * 3);
									memcpy(pTempLineB, pBitmapT, DestImage->Picture->Bitmap->Width * 3);
									memcpy(pBitmapT, pTempLineT, DestImage->Picture->Bitmap->Width * 3);
									memcpy(pBitmapB, pTempLineB, DestImage->Picture->Bitmap->Width * 3);
								}
								delete[] pTempLineT;
								delete[] pTempLineB;
							}

							DestImage->Repaint();

							CurrentCamImageIndex[globalCameraIndex]++;
						}
					}
				}
				catch (...)
				{
					timerEnabled = false;
				}
			}
		}
	}

	bool bGettingImageComplete = true;
	int minValue = MAX_BACKGROUND_IMAGE_COUNT;
	for (int globalCameraIndex = 0; globalCameraIndex < SYSTEM_TOTAL_CAMERA_COUNT; globalCameraIndex++)
	{
		if (CameraMapInfo[globalCameraIndex].CameraInspectPosition != CAMERA_POSITION_DISCONNECT &&
			CameraMapInfo[globalCameraIndex].CameraInspectPosition != CAMERA_POSITION_3D && SystemLinkCameraInfo[globalCameraIndex] != 0)
		{
			if (CurrentCamImageIndex[globalCameraIndex] < MAX_BACKGROUND_IMAGE_COUNT)
			{
				bGettingImageComplete = false;

				if (minValue > CurrentCamImageIndex[globalCameraIndex])
				{
					minValue = CurrentCamImageIndex[globalCameraIndex];
				}
			}
		}
	}

	CaptureProcessGauge->Progress = minValue;
	CaptureProgressLabel->Caption = IntToStr(CaptureProcessGauge->Progress) + "/" + IntToStr(CaptureProcessGauge->MaxValue);

	if (bGettingImageComplete)
	{
		bCaptureCompleteBGI = true;
		timerEnabled = false;

		for (int globalCameraIndex = 0; globalCameraIndex < SYSTEM_TOTAL_CAMERA_COUNT; globalCameraIndex++)
		{
			int spbIndex = CameraMapInfo[globalCameraIndex].SPBIndex;
			int camIndex = CameraMapInfo[globalCameraIndex].CamIndex;

			if (Comm_IsConnected(COMM_SPB + spbIndex))
			{
				Comm_Request(COMM_SPB + spbIndex, CMD_CAPTURE_STOP, &camIndex, sizeof(int));
			}
		}

		captureCommandParam_HCB.Action = 0;
		Comm_Request(COMM_HCB, CMD_TABLET_CAPTURE, &captureCommandParam_HCB, sizeof(TCaptureCommandParam_HCB), NULL, 0);

		// ̹ 
		Graphics::TBitmap* tempImage = new Graphics::TBitmap;
		tempImage->Width = SYSTEM_CAMERA_WIDTH;
		tempImage->Height = SYSTEM_CAMERA_HEIGHT;
		tempImage->PixelFormat = pf24bit;

		for (int globalCameraIndex = 0; globalCameraIndex < SYSTEM_TOTAL_CAMERA_COUNT; globalCameraIndex++)
		{
			if (CameraMapInfo[globalCameraIndex].CameraInspectPosition != CAMERA_POSITION_DISCONNECT &&
				CameraMapInfo[globalCameraIndex].CameraInspectPosition != CAMERA_POSITION_3D && SystemLinkCameraInfo[globalCameraIndex] != 0)
			{
				memset(AverageBayerImage, 0, SYSTEM_CAMERA_WIDTH * SYSTEM_CAMERA_HEIGHT);
				for (int y = 0; y < SYSTEM_CAMERA_HEIGHT; y++)
				{
					for (int x = 0; x < SYSTEM_CAMERA_WIDTH; x++)
					{
						int tempAddress = SYSTEM_CAMERA_WIDTH * y + x;
						int value = BackgroundImage[globalCameraIndex][tempAddress] / MAX_BACKGROUND_IMAGE_COUNT;

						if (value >= 0 && value <= 255)
						{
							AverageBayerImage[tempAddress] = (unsigned char)value;
						}
						else
						{
							AverageBayerImage[tempAddress] = 0;
						}
					}
				}

				for (int y = 0; y < SYSTEM_CAMERA_HEIGHT; y++)
				{
					Byte* ptr = (Byte*)tempImage->ScanLine[y];
					for (int x = 0; x < SYSTEM_CAMERA_WIDTH; x++)
					{
						int tempAddress = SYSTEM_CAMERA_WIDTH * y + x;
						ptr[3 * x + 0] = AverageBayerImage[tempAddress];
						ptr[3 * x + 1] = AverageBayerImage[tempAddress];
						ptr[3 * x + 2] = AverageBayerImage[tempAddress];
					}
				}

				AnsiString bgImgDir = GetProductImagePath() + "\\Background";
				AnsiString ImageName = bgImgDir + "\\BayerImage_C" + IntToStr(globalCameraIndex + 1) + ".bmp";
				tempImage->SaveToFile(ImageName);

				TTntImage* DestImage;
				DestImage = (TTntImage*)FindComponent("CaptureImage" + IntToStr(globalCameraIndex + 1));

				GetNFACamera2DColorImage(DestImage->Picture->Bitmap, AverageBayerImage, MAX_IMAGE_WIDTH, MAX_IMAGE_HEIGHT, globalCameraIndex, SystemImageOffsetSWCal[globalCameraIndex], SystemOffsetImage[globalCameraIndex], ProductData.SubSamplingMode);

				// For SELMA200,    
				if (globalCameraIndex == SD2_2D_SIDE_FACE_P45_CAMERA_INDEX - 1 ||
					globalCameraIndex == SD2_2D_SIDE_FACE_M45_CAMERA_INDEX - 1)
				{
					byte* pTempLine = new byte[DestImage->Picture->Bitmap->Width * 3];
					for (int y = 0; y < (DestImage->Picture->Bitmap->Height); y++)
					{
						byte* pBitmap = (byte*)DestImage->Picture->Bitmap->ScanLine[y];

						for (int x = 0; x < DestImage->Picture->Bitmap->Width; x++)
						{
							pTempLine[x * 3 + 0] = pBitmap[(DestImage->Picture->Bitmap->Width - 1 - x) * 3 + 0];
							pTempLine[x * 3 + 1] = pBitmap[(DestImage->Picture->Bitmap->Width - 1 - x) * 3 + 1];
							pTempLine[x * 3 + 2] = pBitmap[(DestImage->Picture->Bitmap->Width - 1 - x) * 3 + 2];
						}
						memcpy(pBitmap, pTempLine, DestImage->Picture->Bitmap->Width * 3);
					}
					delete[] pTempLine;
				}
				else if (globalCameraIndex == SD1_2D_FRONT_FACE_CAMERA_INDEX - 1 ||
					globalCameraIndex == SD2_2D_FRONT_FACE_CAMERA_INDEX - 1 ||
					globalCameraIndex == SD1_2D_SIDE_FACE_00_CAMERA_INDEX - 1 ||
					globalCameraIndex == SD1_2D_OTHER_SIDE_FACE_00_CAMERA_INDEX - 1 ||
					globalCameraIndex == SD1_2D_SIDE_FACE_P45_CAMERA_INDEX - 1 ||
					globalCameraIndex == SD1_2D_OTHER_SIDE_FACE_P45_CAMERA_INDEX - 1 ||
					globalCameraIndex == SD1_2D_SIDE_FACE_M45_CAMERA_INDEX - 1 ||
					globalCameraIndex == SD1_2D_OTHER_SIDE_FACE_M45_CAMERA_INDEX - 1)
				{
					byte* pTempLineT = new byte[DestImage->Picture->Bitmap->Width * 3];
					byte* pTempLineB = new byte[DestImage->Picture->Bitmap->Width * 3];
					for (int y = 0; y < (DestImage->Picture->Bitmap->Height + 1) / 2; y++)
					{
						byte* pBitmapT = (byte*)DestImage->Picture->Bitmap->ScanLine[y];
						byte* pBitmapB = (byte*)DestImage->Picture->Bitmap->ScanLine[DestImage->Picture->Bitmap->Height - 1 - y];

						memcpy(pTempLineT, pBitmapB, DestImage->Picture->Bitmap->Width * 3);
						memcpy(pTempLineB, pBitmapT, DestImage->Picture->Bitmap->Width * 3);
						memcpy(pBitmapT, pTempLineT, DestImage->Picture->Bitmap->Width * 3);
						memcpy(pBitmapB, pTempLineB, DestImage->Picture->Bitmap->Width * 3);
					}
					delete[] pTempLineT;
					delete[] pTempLineB;
				}

				DestImage->Repaint();
			}
		}

		delete tempImage;

		Sleep(100);
	}

	if (bCaptureStopSW)
	{
		timerEnabled = false;
	}

	BackgroundImageUploadTimer->Enabled = timerEnabled;
}
//---------------------------------------------------------------------------

bool __fastcall TCalibrationForm::SendSPBCaptureSetupForBGI(void)
{
	bool returnValue = true;

	TCaptureSetupData captureSetupData;

	captureSetupData.CaptureType = CAPTURE_TYPE_SINGLE_CAPTURE;
	captureSetupData.CaptureMode = CAPTURE_MODE_DEFAULT;
	captureSetupData.FrameBufferCount = 3;

	for (int spbIndex = 0; spbIndex < MachineSetupData.IPB_BoardCount; spbIndex++)
	{
		if (Comm_IsConnected(COMM_SPB + spbIndex))
		{
			captureSetupData.CameraMask = 0;
			memset(captureSetupData.ShutterSpeed, 0, sizeof(unsigned short) * SYSTEM_SPB_CAMERA_MAX_COUNT);
			memset(captureSetupData.SubsamplingMode, 0, sizeof(unsigned char) * SYSTEM_SPB_CAMERA_MAX_COUNT);
			memset(captureSetupData.ShutterDelay, 0, sizeof(unsigned short) * SYSTEM_SPB_CAMERA_MAX_COUNT);
			memset(captureSetupData.TriggerFreq, 0, sizeof(unsigned short) * SYSTEM_SPB_CAMERA_MAX_COUNT);

			for (int globalCameraIndex = 0; globalCameraIndex < SYSTEM_TOTAL_CAMERA_COUNT; globalCameraIndex++)
			{
				if (CameraMapInfo[globalCameraIndex].CameraInspectPosition != CAMERA_POSITION_DISCONNECT &&
					CameraMapInfo[globalCameraIndex].CameraInspectPosition != CAMERA_POSITION_3D && SystemLinkCameraInfo[globalCameraIndex] != 0)
				{
					if (spbIndex == CameraMapInfo[globalCameraIndex].SPBIndex)
					{
						int camIndex = CameraMapInfo[globalCameraIndex].CamIndex;
						captureSetupData.CameraMask |= (0x0001 << camIndex);
						captureSetupData.ShutterSpeed[camIndex] = ProductData.ShutterSpeed[globalCameraIndex];
						captureSetupData.SubsamplingMode[camIndex] = RESOLUTION_NORMAL_QUALITY;
						captureSetupData.ShutterDelay[camIndex] = 0;
					}
				}
			}

			captureSetupData.ContainParams = 1;
			captureSetupData.TabletType = 2;
			captureSetupData.SensorLength= 1000;
			if (!Comm_Request(COMM_SPB + spbIndex, CMD_CAPTURE_SETUP, &captureSetupData, sizeof(TCaptureSetupData), NULL, 0))
			{
				returnValue = false;
			}
		}
	}

	return returnValue;
}

//---------------------------------------------------------------------------

void __fastcall TCalibrationForm::TntFormActivate(TObject *Sender)
{
  SetScreenPosition(this);
}
//---------------------------------------------------------------------------

