//---------------------------------------------------------------------------

#ifndef Calibration_FormH
#define Calibration_FormH
//---------------------------------------------------------------------------
#include <Classes.hpp>
#include <Controls.hpp>
#include <StdCtrls.hpp>
#include <Forms.hpp>
#include <ExtCtrls.hpp>
#include "CGAUGES.h"
#include "TntButtons.hpp"
#include "TntComCtrls.hpp"
#include "TntExtCtrls.hpp"
#include "TntStdCtrls.hpp"
#include <Buttons.hpp>
#include <ComCtrls.hpp>
#include <Grids.hpp>

#include <fstream>
using namespace std;

#include "Environment.h"
#include <ComCtrls.hpp>
#include <Buttons.hpp>
#include "CGAUGES.h"
#include "TntButtons.hpp"
#include "TntComCtrls.hpp"
#include "TntExtCtrls.hpp"
#include "TntStdCtrls.hpp"
#include "TntForms.hpp"

#include "common.h"
#include <Grids.hpp> //sjm add

#define DISPLAY_SENSOR_INFO_WIDTH 337
#define MAX_CAPTURE_IMAGE_COUNT			100
#define MAX_BACKGROUND_IMAGE_COUNT  50
//---------------------------------------------------------------------------
typedef enum {ECS_NONE, ECS_ON_CAPTURE, ECS_OPTIONAL_CAPTURE} ECaptureState;
//---------------------------------------------------------------------------
class TCalibrationForm : public TTntForm
{
__published:	// IDE-managed Components
	TTntPanel *Panel1;
	TTntButton *BoundarySettingButton;
	TTntButton *CaptureStartButton;
	TTimer *CaptureCheckTimer;
	TTntButton *CaptureStopButton;
	TTntPanel *BoundarySettingPanel;
	TTntGroupBox *GroupBox1;
	TTntEdit *ImageNumberEdit;
	TTntLabel *Label1;
	TTntUpDown *ImageNumberUpDown;
	TTntSpeedButton *CamSpeedButton1;
	TTntSpeedButton *CamSpeedButton2;
	TTntSpeedButton *CamSpeedButton3;
	TTntSpeedButton *CamSpeedButton4;
	TTntSpeedButton *CamSpeedButton5;
	TTntSpeedButton *CamSpeedButton6;
	TTntSpeedButton *CamSpeedButton7;
	TTntSpeedButton *CamSpeedButton8;
	TTntSpeedButton *CamSpeedButton9;
	TTntSpeedButton *CamSpeedButton10;
	TTntSpeedButton *AreaKindSpeedButton1;
	TTntSpeedButton *AreaKindSpeedButton2;
	TTntSpeedButton *AreaKindSpeedButton3;
	TTntSpeedButton *AreaKindSpeedButton4;
	TTntSpeedButton *AreaKindSpeedButton5;
	TTntButton *SaveButton;
	TTntButton *CameraResolutionButton;
	TTntPanel *CameraResolutionPanel;
  TTntLabel *ResolutionCam1;
	TTntLabel *Label3;
  TTntLabel *ResolutionCam2;
  TTntLabel *ResolutionCam3;
  TTntLabel *ResolutionCam4;
	TTntEdit *CameraResEdit1;
	TTntEdit *CameraResEdit2;
	TTntEdit *CameraResEdit3;
	TTntEdit *CameraResEdit4;
	TTntButton *CameraResSaveButton;
	TTntButton *CameraResCloseButton;
	TTntButton *BoundaryCloseButton;
	TTntLabel *Label13;
	TTntLabel *Label14;
	TTntLabel *Label15;
	TTntLabel *Label16;
	TTntLabel *Label17;
	TTntLabel *Label18;
	TTntLabel *LeftLabel;
	TTntLabel *RightLabel;
	TTntLabel *WidthLabel;
	TTntLabel *TopLabel;
	TTntLabel *BottomLabel;
	TTntLabel *HeightLabel;
	TTntButton *ShutterSpeedSettingButton;
	TTntPanel *ShutterSpeedPanel;
  TTntLabel *ShutterSpeedCameraLabel1;
	TTntLabel *Label20;
  TTntLabel *ShutterSpeedCameraLabel2;
  TTntLabel *ShutterSpeedCameraLabel3;
  TTntLabel *ShutterSpeedCameraLabel4;
  TTntLabel *ShutterSpeedCameraLabel5;
  TTntLabel *ShutterSpeedCameraLabel6;
  TTntLabel *ShutterSpeedCameraLabel7;
  TTntLabel *ShutterSpeedCameraLabel8;
  TTntLabel *ShutterSpeedCameraLabel9;
  TTntLabel *ShutterSpeedCameraLabel10;
	TTntEdit *ShutterSpeedEdit1;
	TTntEdit *ShutterSpeedEdit2;
	TTntEdit *ShutterSpeedEdit3;
	TTntEdit *ShutterSpeedEdit4;
	TTntEdit *ShutterSpeedEdit5;
	TTntEdit *ShutterSpeedEdit6;
	TTntEdit *ShutterSpeedEdit7;
	TTntEdit *ShutterSpeedEdit8;
	TTntEdit *ShutterSpeedEdit9;
	TTntEdit *ShutterSpeedEdit10;
	TTntButton *ShutterSpeedSaveButton;
	TTntButton *ShutterSpeedCloseButton;
	TTntButton *CameraSettingButton;
	TTntPanel *CaptureProgressPanel;
	TTntPanel *Panel3;
	TCGauge *CaptureProcessGauge;
	TTntLabel *CaptureProgressLabel;
	TTntButton *Calibration3DButton;
  TTntEdit *ThresholdEdit5;
  TTntEdit *ThresholdEdit13;
	TTntSpeedButton *SpeedButton1;
	TTntPanel *SensorTimingPanel;
	TTntGroupBox *GroupBox2;
	TTntImage *SensorIntervalImage1;
	TTntShape *AverageIntervalShape1;
	TTntLabel *OptimalTimingLabel1;
	TTntLabel *Label30;
	TTntLabel *Label31;
	TTntLabel *Label32;
	TTntLabel *Label33;
	TTimer *SensorIntervalTimer;
	TTntLabel *Label34;
	TTntLabel *IntervalCheckRatioLabel1;
	TTntLabel *IntervalMatchingRatioLabel1;
	TTntLabel *MaxIntervalLabel1;
	TTntLabel *MinIntervalLabel1;
	TTntGroupBox *GroupBox3;
	TTntImage *SensorLengthImage1;
	TTntShape *AverageLengthShape1;
	TTntLabel *OptimalLengthLabel1;
	TTntLabel *Label36;
	TTntLabel *Label38;
	TTntLabel *Label39;
	TTntLabel *Label40;
	TTntLabel *LengthCheckRatioLabel1;
	TTntLabel *MaxLengthLabel1;
	TTntLabel *MinLengthLabel1;
	TTntGroupBox *GroupBox4;
	TTntImage *SensorLengthImage2;
	TTntShape *AverageLengthShape2;
	TTntLabel *OptimalLengthLabel2;
	TTntLabel *Label37;
	TTntLabel *Label41;
	TTntLabel *Label42;
	TTntLabel *Label43;
	TTntLabel *LengthCheckRatioLabel2;
	TTntLabel *MaxLengthLabel2;
	TTntLabel *MinLengthLabel2;
	TTntGroupBox *GroupBox5;
	TTntImage *SensorLengthImage3;
	TTntShape *AverageLengthShape3;
	TTntLabel *OptimalLengthLabel3;
	TTntLabel *Label44;
	TTntLabel *Label45;
	TTntLabel *Label46;
	TTntLabel *Label47;
	TTntLabel *LengthCheckRatioLabel3;
	TTntLabel *MaxLengthLabel3;
	TTntLabel *MinLengthLabel3;
	TTntGroupBox *GroupBox6;
	TTntImage *SensorIntervalImage2;
	TTntShape *AverageIntervalShape2;
	TTntLabel *OptimalTimingLabel2;
	TTntLabel *Label52;
	TTntLabel *Label53;
	TTntLabel *Label54;
	TTntLabel *Label55;
	TTntLabel *Label56;
	TTntLabel *IntervalCheckRatioLabel2;
	TTntLabel *IntervalMatchingRatioLabel2;
	TTntLabel *MaxIntervalLabel2;
	TTntLabel *MinIntervalLabel2;
  TTntButton *SpeedControlBtn;
  TTntLabel *ShutterSpeedCameraLabel11;
  TTntEdit *ShutterSpeedEdit11;
  TTntLabel *ShutterSpeedCameraLabel12;
  TTntEdit *ShutterSpeedEdit12;
  TTntLabel *ShutterSpeedCameraLabel13;
  TTntEdit *ShutterSpeedEdit13;
  TTntLabel *ShutterSpeedCameraLabel14;
  TTntEdit *ShutterSpeedEdit14;
  TTntLabel *ShutterSpeedCameraLabel15;
  TTntEdit *ShutterSpeedEdit15;
  TTntLabel *ShutterSpeedCameraLabel16;
  TTntEdit *ShutterSpeedEdit16;
  TTntLabel *ResolutionCam5;
  TTntEdit *CameraResEdit5;
  TTntLabel *ResolutionCam6;
  TTntEdit *CameraResEdit6;
  TTntLabel *ResolutionCam7;
  TTntEdit *CameraResEdit7;
  TTntLabel *ResolutionCam8;
  TTntEdit *CameraResEdit8;
  TTntLabel *ResolutionCam9;
  TTntEdit *CameraResEdit9;
  TTntLabel *ResolutionCam10;
  TTntEdit *CameraResEdit10;
  TTntLabel *ResolutionCam11;
  TTntEdit *CameraResEdit11;
  TTntLabel *ResolutionCam12;
  TTntEdit *CameraResEdit12;
  TTntLabel *ResolutionCam13;
  TTntEdit *CameraResEdit13;
  TTntLabel *ResolutionCam14;
  TTntEdit *CameraResEdit14;
  TTntLabel *ResolutionCam15;
  TTntEdit *CameraResEdit15;
  TTntLabel *ResolutionCam16;
  TTntEdit *CameraResEdit16;
  TTntSpeedButton *CamSpeedButton11;
  TTntSpeedButton *CamSpeedButton12;
  TTntSpeedButton *CamSpeedButton13;
  TTntSpeedButton *CamSpeedButton14;
  TTntSpeedButton *CamSpeedButton15;
  TTntSpeedButton *CamSpeedButton16;
  TTntPanel *ImagePanel;
  TTntImage *CaptureImage1;
  TTntImage *CaptureImage2;
  TTntImage *CaptureImage3;
  TTntImage *CaptureImage4;
  TTntImage *CaptureImage5;
  TTntImage *CaptureImage6;
  TTntImage *CaptureImage7;
  TTntImage *CaptureImage8;
  TTntImage *CaptureImage9;
  TTntImage *CaptureImage10;
  TTntImage *CaptureImage11;
  TTntImage *CaptureImage12;
  TTntImage *CaptureImage13;
  TTntImage *CaptureImage14;
  TTntImage *CaptureImage15;
  TTntImage *CaptureImage16;
  TTntImage *CaptureImage1_Option;
  TTntImage *CaptureImage9_Option;
  TTntLabel *CameraIndexLabel1;
  TTntLabel *CameraIndexLabel1Option;
  TTntLabel *CameraIndexLabel5;
  TTntLabel *CameraIndexLabel9;
  TTntLabel *CameraIndexLabel9Option;
  TTntLabel *CameraIndexLabel13;
  TTntLabel *CameraIndexLabel2;
  TTntLabel *CameraIndexLabel3;
  TTntLabel *CameraIndexLabel4;
  TTntLabel *CameraIndexLabel6;
  TTntLabel *CameraIndexLabel7;
  TTntLabel *CameraIndexLabel8;
  TTntLabel *CameraIndexLabel10;
  TTntLabel *CameraIndexLabel11;
  TTntLabel *CameraIndexLabel12;
  TTntLabel *CameraIndexLabel14;
  TTntLabel *CameraIndexLabel15;
  TTntLabel *CameraIndexLabel16;
  TStringGrid *StringGrid1;
  TTntEdit *CameraDigitalGainEdit1;
  TTntEdit *CameraDigitalGainEdit9;
  TTntEdit *CameraDigitalGainEdit2;
  TTntEdit *CameraDigitalGainEdit6;
  TTntEdit *CameraDigitalGainEdit10;
  TTntEdit *CameraDigitalGainEdit14;
  TTntEdit *CameraDigitalGainEdit3;
  TTntEdit *CameraDigitalGainEdit7;
  TTntEdit *CameraDigitalGainEdit11;
  TTntEdit *CameraDigitalGainEdit15;
  TTntEdit *CameraDigitalGainEdit4;
  TTntEdit *CameraDigitalGainEdit8;
  TTntEdit *CameraDigitalGainEdit12;
  TTntEdit *CameraDigitalGainEdit16;
  TTntLabel *CaptureMessageLabel;
  TTntCheckBox *GainAllChangeCheckbox;
  TTntCheckBox *ShutterSpeedAllChangeCheckbox;
  TTntLabel *PercentLabel1;
  TTntLabel *PercentLabel16;
  TTntLabel *PercentLabel15;
  TTntLabel *PercentLabel14;
  TTntLabel *PercentLabel12;
  TTntLabel *PercentLabel11;
  TTntLabel *PercentLabel10;
  TTntLabel *PercentLabel8;
  TTntLabel *PercentLabel7;
  TTntLabel *PercentLabel6;
  TTntLabel *PercentLabel4;
  TTntLabel *PercentLabel3;
  TTntLabel *PercentLabel2;
  TTntLabel *PercentLabel13;
  TTntLabel *PercentLabel5;
  TTntLabel *PercentLabel9;
  TTntPanel *ProccessAlarmPanel;
  TTntButton *SensorInfoControlBtn;
  TTntButton *CloseButton;
  TTntButton *AutoShutterSpeedSettingButton;
  TTimer *BackgroundImageUploadTimer;
  TTntPanel *MachineControlPanel;
	void __fastcall CloseButtonClick(TObject *Sender);
	void __fastcall CaptureStartButtonClick(TObject *Sender);
	void __fastcall CaptureCheckTimerTimer(TObject *Sender);
	void __fastcall CaptureStopButtonClick(TObject *Sender);
	void __fastcall ImageNumberUpDownClick(TObject *Sender,
          TUDBtnType Button);
	void __fastcall BoundarySettingButtonClick(TObject *Sender);
	void __fastcall CamSpeedButtonClick(TObject *Sender);
	void __fastcall AreaKindSpeedButtonClick(TObject *Sender);
	void __fastcall CaptureImage1MouseUp(TObject *Sender, TMouseButton Button,
          TShiftState Shift, int X, int Y);
	void __fastcall SaveButtonClick(TObject *Sender);
	void __fastcall FormCreate(TObject *Sender);
	void __fastcall CameraResSaveButtonClick(TObject *Sender);
	void __fastcall CameraResolutionButtonClick(TObject *Sender);
	void __fastcall CameraResCloseButtonClick(TObject *Sender);
	void __fastcall BoundaryCloseButtonClick(TObject *Sender);
	void __fastcall ShutterSpeedSettingButtonClick(TObject *Sender);
	void __fastcall ShutterSpeedSaveButtonClick(TObject *Sender);
	void __fastcall CameraSettingButtonClick(TObject *Sender);
	void __fastcall FormDestroy(TObject *Sender);
    void __fastcall NumEditClick(TObject *Sender);
	void __fastcall Calibration3DButtonClick(TObject *Sender);
	void __fastcall SensorIntervalTimerTimer(TObject *Sender);
        void __fastcall SpeedControlBtnClick(TObject *Sender);
  void __fastcall Button1Click(TObject *Sender);
  void __fastcall SensorInfoControlBtnClick(TObject *Sender);
  void __fastcall Button2Click(TObject *Sender);
  void __fastcall AutoShutterSpeedSettingButtonClick(TObject *Sender);
  void __fastcall BackgroundImageUploadTimerTimer(TObject *Sender);
  void __fastcall TntFormActivate(TObject *Sender);
private:	// User declarations

	unsigned char *CaptureData;

	int WritingContainerIndex;
  int CurrentCheckImageNumber;
  int CurrentCheckCameraIndex;
  TRect BoundaryArea[SYSTEM_TOTAL_CAMERA_COUNT];
  int AreaKind;
  TTntPanel *ActivePanel;
  TPoint DiscCenterPos[SYSTEM_TOTAL_CAMERA_COUNT];
  bool IsBoundarySettingMode;
	int IntervalStudyCount1, IntervalStudyCount2;
	int OptimalSensorIntervalA, OptimalSensorIntervalB;

  
	ECaptureState CaptureState;

  int CameraShutterSpeedList[SYSTEM_TOTAL_CAMERA_COUNT];
  int CameraGainList[SYSTEM_TOTAL_CAMERA_COUNT];
  
  TSPBFPGAVersion CSPBFPGAVersion[SYSTEM_SPB_MAX_COUNT]; //sjm add

  void __fastcall RefreshCameraInfo(int camIndex, float m);
  void __fastcall ShowBoundaryImage(void);
  void __fastcall SaveBoundaryData(void);
	void __fastcall LoadBoundaryData(void);
	void __fastcall ProceedToOptionalCapture(void);
	void __fastcall StudySensorLengthInfo(void);
  void __fastcall GetDefaultString();
  void __fastcall ThreadTEST(void * arg);
  void __fastcall CaptureImageViewProcess();
  void __fastcall InitImageComponents();
  void __fastcall MachineControlForBackground(bool Active, int Disk1StudySpeed, int Disk1BaseSpeed, int Disk2StudySpeed, int Disk2BaseSpeed);
  bool __fastcall SendSPBCaptureSetupForBGI(void);

  int CurrentCamImageIndex[SYSTEM_TOTAL_CAMERA_COUNT];

  unsigned int BackgroundImage[SYSTEM_TOTAL_CAMERA_COUNT][SYSTEM_CAMERA_WIDTH * SYSTEM_CAMERA_HEIGHT];
  unsigned char AverageBayerImage[SYSTEM_CAMERA_WIDTH * SYSTEM_CAMERA_HEIGHT];

  Graphics::TBitmap *CaptureBitmap;
  TTntImage *DestImage;
  TFileContainer *TempCaptureFileContainer;
  void __fastcall FlipColor();
  int FlipGage;

public:		// User declarations
	__fastcall TCalibrationForm(TComponent* Owner);
	void __fastcall OnUserChange(void);

  TFileContainer *CaptureFileContainer[MAX_CAPTURE_IMAGE_COUNT];
  
  int CaptureWidth, CaptureHeight;
  int CaptureImgWidth , CaptureImgHeight;
	int CaptureWidth_3D, CaptureHeight_3D;
  AnsiString ImagePath;
  ofstream ImageFile;
  TTntImage *  GetImagePanelPointer(int Cameraindex);

  TFileStream *ImageFileStream;

  bool ImgViewThreadController;
  bool ImgSaveThreadController;
  bool CaptureEndFlag;
  bool ImgViewThreadInitFlag;
  bool bCaptureCompleteBGI;
  bool bCaptureStopSW;
  bool bBackgroundCaptureSW;
  int CurrentImgViewCount;
  int ImgSaveDataCount;

  TCaptureCommandParam_HCB captureCommandParam_HCB;

  void __fastcall RepaintFormImage(int Cameraindex);
  void __fastcall AssinFormImage(Graphics::TBitmap * NewImg,int Cameraindex);
  void __fastcall AssinForm3DImage(Graphics::TBitmap *SrcImg,TTntImage *DestImg);

};
//---------------------------------------------------------------------------
extern PACKAGE TCalibrationForm *CalibrationForm;
//---------------------------------------------------------------------------
#endif
