//---------------------------------------------------------------------------
// For SELMA200, 20180220, moon, Ϸ
// ī޶   Ͽ Form Design   Write Process  ̽ ݿϿ Ϻ 
//---------------------------------------------------------------------------

#include <vcl.h>
#include <inifiles.hpp>
#pragma hdrstop

#include "CameraMapping_Form.h"
#include "Environment.h"
#include "SystemSetup.h"
#include "MultiLanguage.h"


//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma link "TntExtCtrls"
#pragma link "TntStdCtrls"
#pragma resource "*.dfm"
TCameraMappingForm *CameraMappingForm;
//---------------------------------------------------------------------------
__fastcall TCameraMappingForm::TCameraMappingForm(TComponent* Owner)
	: TTntForm(Owner)
{
  if(DefaultLCID == 1028 || DefaultLCID == 2052 || DefaultLCID == 3076 || DefaultLCID == 4100)
    ComponentSetFontName(this, "SimSun");
  else if(DefaultLCID == 1041)
    ComponentSetFontName(this, "Meiryo UI");
  else if(DefaultLCID == 3082)
  {
    ComponentSetFontName(this, "Segoe UI");
    ComponentSetMultiLine(this);
  }
}
//---------------------------------------------------------------------------
void __fastcall TCameraMappingForm::FormCreate(TObject *Sender)
{
	memcpy(TempCameraMapInfo, CameraMapInfo, SYSTEM_TOTAL_CAMERA_COUNT * sizeof(TCameraMapInfo));
	for (int spbIndex = 0; spbIndex < MachineSetupData.IPB_BoardCount; spbIndex++)
	{
		for (int camIndex = 0; camIndex < SYSTEM_SPB_CAMERA_COUNT; camIndex++)
		{
			TempCameraHardwarePosition[spbIndex][camIndex] = SPBSystemSetupData[spbIndex].CameraHardwarePosition[camIndex];
		}

	}
	for (int globalCameraIndex = 0; globalCameraIndex < SYSTEM_TOTAL_CAMERA_COUNT; globalCameraIndex++)
	{
		TTntComboBox *spbComboBox = (TTntComboBox *) FindComponent("SPBComboBox" + IntToStr(globalCameraIndex + 1));
		if (spbComboBox)
		{
			for (int spbIndex = 0; spbIndex < MachineSetupData.IPB_BoardCount; spbIndex++)
			{
			spbComboBox->Items->Add("IPB "+IntToStr(spbIndex+1));
			}
		}

	}

  for(int globalCameraIndex = 0; globalCameraIndex < SYSTEM_TOTAL_CAMERA_COUNT; globalCameraIndex++ )
  {
    AnsiString ConvertString;
    if(SystemLinkCameraInfo[globalCameraIndex] != 0)
    {
      TTntLabel *CameraNameLabel = (TTntLabel *)FindComponent("CameraNameLabel" + IntToStr(globalCameraIndex+1));
      ConvertString = ConvertCameraIndex(globalCameraIndex);
      CameraNameLabel->Caption = ConvertString;

    }
  }

  if(GlobalProgramID == PROGRAM_ID_150P)
  {
    // SELMA150P
    int MoveD = ComponentReposition(3,HWLabel2->Top, HWLabel3->Top,0);
    for(int globalCameraIndex = 0; globalCameraIndex < SYSTEM_TOTAL_CAMERA_COUNT; globalCameraIndex++)
    {
      TTntLabel *HWLabel = (TTntLabel *)FindComponent("HWLabel" + IntToStr(globalCameraIndex+1));
      TTntLabel *CameraNameLabel = (TTntLabel *)FindComponent("CameraNameLabel" + IntToStr(globalCameraIndex+1));
      TTntComboBox *SPBComboBox= (TTntComboBox *)FindComponent("SPBComboBox" + IntToStr(globalCameraIndex+1));
      TTntComboBox *CameraComboBox= (TTntComboBox *)FindComponent("CameraComboBox" + IntToStr(globalCameraIndex+1));
      TTntComboBox *CameraLinkComboBox= (TTntComboBox *)FindComponent("CameraLinkComboBox" + IntToStr(globalCameraIndex+1));
      TTntComboBox *CameraTypeComboBox= (TTntComboBox *)FindComponent("CameraTypeComboBox" + IntToStr(globalCameraIndex+1));
      if(SystemLinkCameraInfo[globalCameraIndex] == 0)
      {
        HWLabel->Visible = false;
        CameraNameLabel->Visible = false;
        SPBComboBox->Visible = false;
        CameraComboBox->Visible = false;
        CameraLinkComboBox->Visible = false;
        CameraTypeComboBox->Visible =false;
      }
      else
      {
        if(globalCameraIndex+1 == 1 || globalCameraIndex+1 == 2)
        {
          HWLabel->Top += MoveD*2;
          CameraNameLabel->Top += MoveD*2;
          SPBComboBox->Top += MoveD*2;
          CameraComboBox->Top += MoveD*2;
          CameraLinkComboBox->Top += MoveD*2;
          CameraTypeComboBox->Top += MoveD*2;
        }
        else if(globalCameraIndex+1 == 4 || globalCameraIndex+1 == 5 || globalCameraIndex+1 == 6)
        {
          HWLabel->Top += MoveD;
          CameraNameLabel->Top += MoveD;
          SPBComboBox->Top += MoveD;
          CameraComboBox->Top += MoveD;
          CameraLinkComboBox->Top += MoveD;
          CameraTypeComboBox->Top += MoveD;
        }
        else if(globalCameraIndex+1 == 12 || globalCameraIndex+1 == 13 || globalCameraIndex+1 == 14)
        {
          HWLabel->Top -= MoveD;
          CameraNameLabel->Top -= MoveD;
          SPBComboBox->Top -= MoveD;
          CameraComboBox->Top -= MoveD;
          CameraLinkComboBox->Top -= MoveD;
          CameraTypeComboBox->Top -= MoveD;
        }
        else if(globalCameraIndex+1 == 16)
        {
          HWLabel->Top -= MoveD*2;
          CameraNameLabel->Top -= MoveD*2;
          SPBComboBox->Top -= MoveD*2;
          CameraComboBox->Top -= MoveD*2;
          CameraLinkComboBox->Top -= MoveD*2;
          CameraTypeComboBox->Top -= MoveD*2;
        }
      }
    }
  }

	ShowCameraMappingInfo();





}
//---------------------------------------------------------------------------
void __fastcall TCameraMappingForm::ShowCameraMappingInfo(void)
{
  TColor inputColor;
  int tempSPBIndex, tempCamIndex;
	for (int globalCameraIndex = 0; globalCameraIndex < SYSTEM_TOTAL_CAMERA_COUNT; globalCameraIndex++)
	{
	    if(TempCameraMapInfo[globalCameraIndex].SPBIndex == 0)
	    {
	      inputColor = 0x00FF8000;
	    }
	    else if(TempCameraMapInfo[globalCameraIndex].SPBIndex == 1)
	    {
	      inputColor = clGreen;
	    }
	    else if(TempCameraMapInfo[globalCameraIndex].SPBIndex == 2)
	    {
	      inputColor = clYellow;
	    }
	    else if(TempCameraMapInfo[globalCameraIndex].SPBIndex == 3)
	    {
	      inputColor = clRed;
	    }
	    else if(TempCameraMapInfo[globalCameraIndex].SPBIndex == 4)
	    {
	      inputColor = clPurple;
	    }
	    else
	    {
	      inputColor = clOlive;
	    }

		TTntComboBox *spbComboBox = (TTntComboBox *) FindComponent("SPBComboBox" + IntToStr(globalCameraIndex + 1));
		if (spbComboBox)
		{
			spbComboBox->ItemIndex = TempCameraMapInfo[globalCameraIndex].SPBIndex;
      spbComboBox->Color = inputColor;
		}

		TTntComboBox *cameraComboBox = (TTntComboBox *) FindComponent("CameraComboBox" + IntToStr(globalCameraIndex + 1));
		if (cameraComboBox)
		{
			cameraComboBox->ItemIndex = TempCameraMapInfo[globalCameraIndex].CamIndex;
      cameraComboBox->Color = inputColor;
		}

		TTntComboBox *cameraInspectPosComboBox = (TTntComboBox *) FindComponent("CameraTypeComboBox" + IntToStr(globalCameraIndex + 1));
		if (cameraInspectPosComboBox)
		{
			cameraInspectPosComboBox->ItemIndex = TempCameraMapInfo[globalCameraIndex].CameraInspectPosition;
      cameraInspectPosComboBox->Color = inputColor;
		}

    tempSPBIndex = TempCameraMapInfo[globalCameraIndex].SPBIndex;
    tempCamIndex = TempCameraMapInfo[globalCameraIndex].CamIndex;

    TTntComboBox *cameraLinkComboBox = (TTntComboBox *) FindComponent("CameraLinkComboBox" + IntToStr(globalCameraIndex + 1));
    if(cameraLinkComboBox)
    {
      cameraLinkComboBox->ItemIndex = TempCameraHardwarePosition[tempSPBIndex][tempCamIndex];
      cameraLinkComboBox->Color = inputColor;
    }

	}




}
//---------------------------------------------------------------------------
void __fastcall TCameraMappingForm::SPBComboBoxChange(TObject *Sender)
{ 
	//TempCameraMapInfo[globalCamIndex].SPBIndex = theComboBox->ItemIndex;

  TColor inputColor;
  TTntComboBox *theComboBox = (TTntComboBox *) Sender;
  int globalCamIndex = theComboBox->Tag;

  if(theComboBox->ItemIndex == 0) // SPB Number, SPB ִ  4 (SPB07   3 پ)
  {
    inputColor = 0x00FF8000;
  }
  else if(theComboBox->ItemIndex == 1)
  {
    inputColor = clGreen;
  }
  else if(theComboBox->ItemIndex == 2)
  {
    inputColor = clYellow;
  }
  else if(theComboBox->ItemIndex == 3)
  {
    inputColor = clRed;
  }
  else if(theComboBox->ItemIndex == 4)
  {
    inputColor = clPurple;
  }
  else
  {
    inputColor = clOlive;
  }

  TTntComboBox *spbComboBox = (TTntComboBox *) FindComponent("SPBComboBox" + IntToStr(globalCamIndex + 1));
  if (spbComboBox)
  {
    spbComboBox->Color = inputColor;
  }

  TTntComboBox *cameraComboBox = (TTntComboBox *) FindComponent("CameraComboBox" + IntToStr(globalCamIndex + 1));
  if (cameraComboBox)
  {
    cameraComboBox->Color = inputColor;
  }

  TTntComboBox *cameraInspectPosComboBox = (TTntComboBox *) FindComponent("CameraTypeComboBox" + IntToStr(globalCamIndex + 1));
  if (cameraInspectPosComboBox)
  {
    cameraInspectPosComboBox->Color = inputColor;
  }

  TTntComboBox *cameraLinkComboBox = (TTntComboBox *) FindComponent("CameraLinkComboBox" + IntToStr(globalCamIndex + 1));
  if(cameraLinkComboBox)
  {
    cameraLinkComboBox->Color = inputColor;
  }
}
//---------------------------------------------------------------------------
void __fastcall TCameraMappingForm::CameraComboBoxChange(TObject *Sender)
{
  /*
	TTntComboBox *theComboBox = (TTntComboBox *) Sender;
	int globalCamIndex = theComboBox->Tag;
  TempCameraMapInfo[globalCamIndex].CamIndex = theComboBox->ItemIndex;
  */
}
//---------------------------------------------------------------------------
void __fastcall TCameraMappingForm::CameraLinkComboBox2Change(
	  TObject *Sender)
{
  /*
	TTntComboBox *theComboBox = (TTntComboBox *) Sender;
	int cameraLinkGlobalIndex = theComboBox->Tag;
	int spbIndex = cameraLinkGlobalIndex / SYSTEM_SPB_CAMERA_COUNT;
	int camIndex = cameraLinkGlobalIndex % SYSTEM_SPB_CAMERA_COUNT;
	TempCameraHardwarePosition[spbIndex][camIndex] = theComboBox->ItemIndex;
  */
}
//---------------------------------------------------------------------------
void __fastcall TCameraMappingForm::SetupButtonClick(TObject *Sender)
{
  // read
  int tempSPBIndex, tempCamIndex;

  for (int globalCameraIndex = 0; globalCameraIndex < SYSTEM_TOTAL_CAMERA_COUNT; globalCameraIndex++)
  {
    TempCameraMapInfo[globalCameraIndex].SPBIndex = 0;
    int abc = TempCameraMapInfo[globalCameraIndex].SPBIndex;
    int bcd= 0;

    TTntComboBox *spbComboBox = (TTntComboBox *) FindComponent("SPBComboBox" + IntToStr(globalCameraIndex + 1));
		if (spbComboBox)
		{
			TempCameraMapInfo[globalCameraIndex].SPBIndex = spbComboBox->ItemIndex;
		}

		TTntComboBox *cameraComboBox = (TTntComboBox *) FindComponent("CameraComboBox" + IntToStr(globalCameraIndex + 1));
		if (cameraComboBox)
		{
			TempCameraMapInfo[globalCameraIndex].CamIndex = cameraComboBox->ItemIndex;
		}

		TTntComboBox *cameraInspectPosComboBox = (TTntComboBox *) FindComponent("CameraTypeComboBox" + IntToStr(globalCameraIndex + 1));
		if (cameraInspectPosComboBox)
		{
			TempCameraMapInfo[globalCameraIndex].CameraInspectPosition = cameraInspectPosComboBox->ItemIndex;
		}

    tempSPBIndex = TempCameraMapInfo[globalCameraIndex].SPBIndex;
    tempCamIndex = TempCameraMapInfo[globalCameraIndex].CamIndex;

    TTntComboBox *cameraLinkComboBox = (TTntComboBox *) FindComponent("CameraLinkComboBox" + IntToStr(globalCameraIndex + 1));
    if(cameraLinkComboBox)
    {
      TempCameraHardwarePosition[tempSPBIndex][tempCamIndex] = cameraLinkComboBox->ItemIndex;
    }

  }

  // data check
  // SPB ȣ   ߺ¸ ȮѴ.
  bool bCamIndexError;
  bool bHWLinkIndexError;
  bool breakSW;
  int m;

  int writtenCameraCount[SYSTEM_SPB_CAMERA_MAX_COUNT];
  int writtenHWLinkCount[SYSTEM_SPB_CAMERA_MAX_COUNT];

  WideString ErrorMessage;

  breakSW = false;


  for (int spbIndex = 0; spbIndex < SYSTEM_SPB_MAX_COUNT; spbIndex++)
  {
    memset(writtenCameraCount, 0, sizeof(int) * SYSTEM_SPB_CAMERA_MAX_COUNT);
    memset(writtenHWLinkCount, 0, sizeof(int) * SYSTEM_SPB_CAMERA_MAX_COUNT);

    bCamIndexError = bHWLinkIndexError = false;

    for (int globalCameraIndex = 0; globalCameraIndex < SYSTEM_TOTAL_CAMERA_COUNT; globalCameraIndex++)
    {
      if(TempCameraMapInfo[globalCameraIndex].SPBIndex == spbIndex)
      {
        tempCamIndex = TempCameraMapInfo[globalCameraIndex].CamIndex;

        if(TempCameraMapInfo[globalCameraIndex].CamIndex < 0 ||
            TempCameraMapInfo[globalCameraIndex].CamIndex >= SYSTEM_SPB_CAMERA_MAX_COUNT)
        {
          bCamIndexError = true;

          wsprintfW(ErrorMessage,CAMERAMAPPINGFORM_ERROR_CAPTION_01, globalCameraIndex + 1);
          //ErrorMessage = IntToStr(globalCameraIndex + 1) + " ī޶  SPB  Camera ȣ  ° ùٸ ʽϴ.";
          breakSW = true;
          break;
        }
        writtenCameraCount[TempCameraMapInfo[globalCameraIndex].CamIndex]++;

        if(writtenCameraCount[TempCameraMapInfo[globalCameraIndex].CamIndex] > 1) // ߺ
        {
          bCamIndexError = true;
          wsprintfW(ErrorMessage,CAMERAMAPPINGFORM_ERROR_CAPTION_02, globalCameraIndex + 1);
          //ErrorMessage = IntToStr(globalCameraIndex + 1) + " ī޶  SPB  Camera ȣ  ° ߺ ˴ϴ. ȮϿ ֽʽÿ.";
          breakSW = true;
          break;
        }

        if(TempCameraHardwarePosition[spbIndex][tempCamIndex] < 0 ||
            TempCameraHardwarePosition[spbIndex][tempCamIndex] >= SYSTEM_SPB_CAMERA_MAX_COUNT)
        {
          bHWLinkIndexError = true;
          wsprintfW(ErrorMessage,CAMERAMAPPINGFORM_ERROR_CAPTION_03,globalCameraIndex + 1);
          //ErrorMessage = IntToStr(globalCameraIndex + 1) + " ī޶  SPB  HW Link ȣ  ° ùٸ ʽϴ.";
          breakSW = true;
          break;
        }
        writtenHWLinkCount[TempCameraHardwarePosition[spbIndex][tempCamIndex]]++;

        if(writtenHWLinkCount[TempCameraHardwarePosition[spbIndex][tempCamIndex]] > 1)
        {
          bHWLinkIndexError = true;
          ErrorMessage = IntToStr(globalCameraIndex + 1) + " ī޶  SPB  HW Link ȣ  ° ߺ ˴ϴ. ȮϿ ֽʽÿ.";
          breakSW = true;
          break;
        }
      }
    }

    if(breakSW)
    {
      break;
    }
  }

  if(bCamIndexError || bHWLinkIndexError)
  {
    if(MessageDlgFA(ErrorMessage, mtConfirmation, TMsgDlgButtons() << mbOK))
    return;
  }

  // write
  SetupButton->Enabled = false;
  ExitButton->Enabled = false;

	memcpy(CameraMapInfo, TempCameraMapInfo, SYSTEM_TOTAL_CAMERA_COUNT * sizeof(TCameraMapInfo));

	for (int spbIndex = 0; spbIndex < SYSTEM_SPB_MAX_COUNT; spbIndex++)
	{
		memcpy(SPBSystemSetupData[spbIndex].CameraMapInfo, CameraMapInfo, SYSTEM_TOTAL_CAMERA_COUNT * sizeof(TCameraMapInfo));
		SPBSystemSetupData[spbIndex].CamMask = 0;

		for (int camIndex = 0; camIndex < SYSTEM_SPB_CAMERA_COUNT; camIndex++)
		{
			SPBSystemSetupData[spbIndex].CameraHardwarePosition[camIndex] = TempCameraHardwarePosition[spbIndex][camIndex];
		}
	}

  // init
  for (int spbIndex = 0; spbIndex < SYSTEM_SPB_MAX_COUNT; spbIndex++)
  {
    for (int camIndex = 0; camIndex < SYSTEM_SPB_CAMERA_COUNT; camIndex++)
    {
      SPBSystemSetupData[spbIndex].GlobalCameraIndex[camIndex] = 0;
      SPBSystemSetupData[spbIndex].InspectPosition[camIndex] = CAMERA_POSITION_DISCONNECT;
    }
  }
  
	for (int globalCameraIndex = 0; globalCameraIndex < SYSTEM_TOTAL_CAMERA_COUNT; globalCameraIndex++)
	{
		int spbIndex = CameraMapInfo[globalCameraIndex].SPBIndex;
		int camIndex = CameraMapInfo[globalCameraIndex].CamIndex;

		SPBSystemSetupData[spbIndex].GlobalCameraIndex[camIndex] = globalCameraIndex;
		SPBSystemSetupData[spbIndex].InspectPosition[camIndex] = CameraMapInfo[globalCameraIndex].CameraInspectPosition;

    if(SPBSystemSetupData[spbIndex].InspectPosition[camIndex] != CAMERA_POSITION_DISCONNECT && SystemLinkCameraInfo[globalCameraIndex] != 0)
    {
		  SPBSystemSetupData[spbIndex].CamMask |= (0x0001 << camIndex);
    }
	}

	WriteCameraMapData(ProgramPath.Env + "\\SystemInfor.ini", CameraMapInfo);
	WriteSPBSystemSetupData(ProgramPath.Env + "\\SystemInfor.ini", SPBSystemSetupData);
	SendSystemSetupData();

  MessageDlgFA("Complete", mtConfirmation, TMsgDlgButtons() << mbOK);

  SetupButton->Enabled = true;
  ExitButton->Enabled = true;
}
//---------------------------------------------------------------------------
void __fastcall TCameraMappingForm::CameraTypeComboBoxChange(
      TObject *Sender)
{
  /*
	TTntComboBox *theComboBox = (TTntComboBox *) Sender;
	int globalCamIndex = theComboBox->Tag;
	TempCameraMapInfo[globalCamIndex].CameraInspectPosition = theComboBox->ItemIndex;
  */
}
//---------------------------------------------------------------------------



