//---------------------------------------------------------------------------

#ifndef CameraTest_FormH
#define CameraTest_FormH
//---------------------------------------------------------------------------
#include <Classes.hpp>
#include <Controls.hpp>
#include <StdCtrls.hpp>
#include <Forms.hpp>
#include "TntExtCtrls.hpp"
#include "TntStdCtrls.hpp"
#include <ExtCtrls.hpp>
#include <ComCtrls.hpp>

#include "Processing.h"
#include "cpb_module.h"
#include "Environment.h"

//---------------------------------------------------------------------------
typedef struct
{
  int ErrorRate;
  int AllowableLevel;
  int CheckingCount;
  int AllowableFailCount;
}TCameraCheckOption;

typedef struct
{
  int CheckSW;
  int FailCount;
  float AverageErrorRate;
  float MinErrorRate;
  float MaxErrorRate;

  int AverageColor[3];
  int MinDiffBrightnessColor[3];
  int MaxDiffBrightnessColor[3];
}TCameraTestResultData;
//---------------------------------------------------------------------------
class TCameraTestForm : public TTntForm
{
__published:	// IDE-managed Components
  TTntPanel *MainMenuPanel;
  TTntButton *StartButton;
  TTntButton *SpeedControlButton;
  TTntButton *ExitButton;
  TTntButton *OptionButton;
  TTntPanel *CameraDataPanel;
  TTntGroupBox *GroupBox4;
  TTntPanel *CameraResulrMenuPanel;
  TTntPanel *TntPanel2;
  TTntPanel *TntPanel3;
  TTntPanel *Panel7;
  TTntPanel *CameraNamePanel1;
  TTntPanel *CameraNamePanel2;
  TTntPanel *CameraNamePanel3;
  TTntPanel *CameraNamePanel4;
  TTntPanel *CameraNamePanel6;
  TTntPanel *CameraNamePanel7;
  TTntPanel *CameraNamePanel9;
  TTntPanel *CameraNamePanel8;
  TTntPanel *CameraNamePanel10;
  TTntPanel *CameraNamePanel11;
  TTntPanel *CameraNamePanel12;
  TTntPanel *CameraNamePanel16;
  TTntPanel *CameraNamePanel15;
  TTntPanel *CameraNamePanel14;
  TTntPanel *Panel22;
  TTntPanel *Panel23;
  TTntPanel *Panel24;
  TTntPanel *Panel25;
  TTntPanel *Panel26;
  TTntPanel *Panel27;
  TTntPanel *Panel28;
  TTntPanel *Panel29;
  TTntPanel *Panel30;
  TTntPanel *Panel31;
  TTntPanel *Panel32;
  TTntPanel *Panel33;
  TTntPanel *Panel34;
  TTntPanel *CameraStatusPanel1;
  TTntPanel *CameraStatusPanel2;
  TTntPanel *CameraStatusPanel3;
  TTntPanel *CameraStatusPanel4;
  TTntPanel *CameraStatusPanel6;
  TTntPanel *CameraStatusPanel7;
  TTntPanel *CameraStatusPanel8;
  TTntPanel *CameraStatusPanel9;
  TTntPanel *CameraStatusPanel10;
  TTntPanel *CameraStatusPanel11;
  TTntPanel *CameraStatusPanel12;
  TTntPanel *CameraStatusPanel14;
  TTntPanel *CameraStatusPanel15;
  TTntPanel *CameraStatusPanel16;
  TTntPanel *CameraShutterSpeedPanel1;
  TTntPanel *CameraShutterSpeedPanel2;
  TTntPanel *CameraShutterSpeedPanel3;
  TTntPanel *CameraShutterSpeedPanel4;
  TTntPanel *CameraShutterSpeedPanel6;
  TTntPanel *CameraShutterSpeedPanel7;
  TTntPanel *CameraShutterSpeedPanel8;
  TTntPanel *CameraShutterSpeedPanel9;
  TTntPanel *CameraShutterSpeedPanel10;
  TTntPanel *CameraShutterSpeedPanel11;
  TTntPanel *CameraShutterSpeedPanel12;
  TTntPanel *CameraShutterSpeedPanel14;
  TTntPanel *CameraShutterSpeedPanel15;
  TTntPanel *CameraShutterSpeedPanel16;
  TTntPanel *CameraGainPanel1;
  TTntPanel *CameraGainPanel2;
  TTntPanel *CameraGainPanel3;
  TTntPanel *CameraGainPanel4;
  TTntPanel *CameraGainPanel6;
  TTntPanel *CameraGainPanel7;
  TTntPanel *CameraGainPanel8;
  TTntPanel *CameraGainPanel9;
  TTntPanel *CameraGainPanel10;
  TTntPanel *CameraGainPanel11;
  TTntPanel *CameraGainPanel12;
  TTntPanel *CameraGainPanel14;
  TTntPanel *CameraGainPanel15;
  TTntPanel *CameraGainPanel16;
  TTntPanel *TntPanel4;
  TTntPanel *TntPanel6;
  TTntPanel *TntPanel7;
  TTntPanel *CurrentCameraShutterSpeedPanel15;
  TTntPanel *CurrentCameraShutterSpeedPanel2;
  TTntPanel *CurrentCameraShutterSpeedPanel3;
  TTntPanel *CurrentCameraShutterSpeedPanel6;
  TTntPanel *CurrentCameraShutterSpeedPanel8;
  TTntPanel *CurrentCameraShutterSpeedPanel9;
  TTntPanel *CurrentCameraShutterSpeedPanel7;
  TTntPanel *CurrentCameraShutterSpeedPanel4;
  TTntPanel *CurrentCameraShutterSpeedPanel16;
  TTntPanel *CurrentCameraShutterSpeedPanel14;
  TTntPanel *CurrentCameraShutterSpeedPanel12;
  TTntPanel *CurrentCameraShutterSpeedPanel11;
  TTntPanel *CurrentCameraShutterSpeedPanel10;
  TTntPanel *CurrentCameraShutterSpeedPanel1;
  TTntPanel *CurrentCameraGainPanel9;
  TTntPanel *CurrentCameraGainPanel8;
  TTntPanel *CurrentCameraGainPanel7;
  TTntPanel *CurrentCameraGainPanel6;
  TTntPanel *CurrentCameraGainPanel4;
  TTntPanel *CurrentCameraGainPanel3;
  TTntPanel *CurrentCameraGainPanel2;
  TTntPanel *CurrentCameraGainPanel16;
  TTntPanel *CurrentCameraGainPanel15;
  TTntPanel *CurrentCameraGainPanel14;
  TTntPanel *CurrentCameraGainPanel12;
  TTntPanel *CurrentCameraGainPanel11;
  TTntPanel *CurrentCameraGainPanel10;
  TTntPanel *CurrentCameraGainPanel1;
  TTntPanel *TntPanel8;
  TTntPanel *CameraNamePanel5;
  TTntPanel *CameraStatusPanel5;
  TTntPanel *CameraShutterSpeedPanel5;
  TTntPanel *CameraGainPanel5;
  TTntPanel *CurrentCameraShutterSpeedPanel5;
  TTntPanel *CurrentCameraGainPanel5;
  TTntPanel *TntPanel15;
  TTntPanel *CameraNamePanel13;
  TTntPanel *CameraStatusPanel13;
  TTntPanel *CameraShutterSpeedPanel13;
  TTntPanel *CameraGainPanel13;
  TTntPanel *CurrentCameraShutterSpeedPanel13;
  TTntPanel *CurrentCameraGainPanel13;
  TTntGroupBox *TntGroupBox1;
  TTntPanel *StudyTabletColorPanel1;
  TTntPanel *StudyTabletColorPanel2;
  TTntPanel *StudyTabletColorPanel4;
  TTntPanel *StudyTabletColorPanel3;
  TTntPanel *StudyTabletColorPanel5;
  TTntPanel *StudyTabletColorPanel7;
  TTntPanel *StudyTabletColorPanel8;
  TTntPanel *StudyTabletColorPanel6;
  TTntPanel *StudyTabletColorPanel13;
  TTntPanel *StudyTabletColorPanel15;
  TTntPanel *StudyTabletColorPanel16;
  TTntPanel *StudyTabletColorPanel14;
  TTntPanel *StudyTabletColorPanel11;
  TTntPanel *StudyTabletColorPanel12;
  TTntPanel *StudyTabletColorPanel10;
  TTntPanel *StudyTabletColorPanel9;
  TTntPanel *CameraCheckingPanel;
  TTntGroupBox *TntGroupBox2;
  TTntPanel *CameraProgressLabel1;
  TTntPanel *CameraProgressLabel2;
  TTntPanel *CameraProgressLabel4;
  TTntPanel *CameraProgressLabel3;
  TTntPanel *CameraProgressLabel5;
  TTntPanel *CameraProgressLabel6;
  TTntPanel *CameraProgressLabel8;
  TTntPanel *CameraProgressLabel7;
  TTntPanel *CameraProgressLabel9;
  TTntPanel *CameraProgressLabel10;
  TTntPanel *CameraProgressLabel12;
  TTntPanel *CameraProgressLabel11;
  TTntPanel *CameraProgressLabel13;
  TTntPanel *CameraProgressLabel14;
  TTntPanel *CameraProgressLabel16;
  TTntPanel *CameraProgressLabel15;
  TProgressBar *CameraProgressBar1;
  TProgressBar *CameraProgressBar2;
  TProgressBar *CameraProgressBar4;
  TProgressBar *CameraProgressBar3;
  TProgressBar *CameraProgressBar5;
  TProgressBar *CameraProgressBar6;
  TProgressBar *CameraProgressBar8;
  TProgressBar *CameraProgressBar7;
  TProgressBar *CameraProgressBar9;
  TProgressBar *CameraProgressBar10;
  TProgressBar *CameraProgressBar12;
  TProgressBar *CameraProgressBar11;
  TProgressBar *CameraProgressBar13;
  TProgressBar *CameraProgressBar14;
  TProgressBar *CameraProgressBar16;
  TProgressBar *CameraProgressBar15;
  TTntButton *StopButton;
  TTntPanel *CameraResultPanel;
  TTntGroupBox *TntGroupBox3;
  TTntPanel *ResultPanel1;
  TTntPanel *ResultPanel2;
  TTntPanel *ResultPanel4;
  TTntPanel *ResultPanel3;
  TTntPanel *ResultPanel5;
  TTntPanel *ResultPanel6;
  TTntPanel *ResultPanel8;
  TTntPanel *ResultPanel7;
  TTntPanel *ResultPanel9;
  TTntPanel *ResultPanel10;
  TTntPanel *ResultPanel12;
  TTntPanel *ResultPanel11;
  TTntPanel *ResultPanel13;
  TTntPanel *ResultPanel14;
  TTntPanel *ResultPanel16;
  TTntPanel *ResultPanel15;
  TTntImage *CurrentImage;
  TTntPanel *Panel1;
  TTntPanel *Panel2;
  TTntPanel *Panel3;
  TTntImage *MinBrightnessResultImage;
  TTntImage *MaxBrightnessResultImage;
  TTntPanel *Panel4;
  TTntImage *GaugeImage1;
  TTntPanel *GaugePanel1;
  TTntPanel *GaugePanel2;
  TTntPanel *GaugePanel3;
  TTntImage *GaugeImage2;
  TTntImage *GaugeImage3;
  TTntPanel *TntPanel11;
  TTntPanel *CurrentCameraBrightnessPanel;
  TTntPanel *TntPanel12;
  TTntPanel *CurrentCameraMinDiffBrightnessPanel;
  TTntPanel *TntPanel13;
  TTntPanel *CurrentCameraMaxDiffBrightnessPanel;
  TTntPanel *TntPanel14;
  TTntPanel *CurrentFailCountPanel;
  TTntPanel *TntPanel17;
  TTntPanel *CurrentErrorRatePanel;
  TTntPanel *TntPanel19;
  TTntPanel *CurrentStatusPanel;
  TTntGroupBox *MeasuringResultGroupBox;
  TPanel *OptionSettingPanel;
  TTntPanel *TntPanel1;
  TTntPanel *TntPanel5;
  TTntPanel *TntPanel9;
  TTntPanel *TntPanel10;
  TTntPanel *TntPanel21;
  TTntButton *SetupButton;
  TTntEdit *TestCountEdit;
  TTntEdit *FailCountEdit;
  TTntEdit *ErrorRateEdit;
  TTntEdit *AllowableRangeEdit;
  TTimer *MeasuringTimer;
  TCheckBox *SimulationCheckBox;
  void __fastcall FormCreate(TObject *Sender);
  void __fastcall ExitButtonClick(TObject *Sender);
  void __fastcall SpeedControlButtonClick(TObject *Sender);
  void __fastcall OptionButtonClick(TObject *Sender);
  void __fastcall SetupButtonClick(TObject *Sender);
  void __fastcall TestCountEditKeyPress(TObject *Sender, char &Key);
  void __fastcall TestCountEditClick(TObject *Sender);
  void __fastcall AllowableRangeEditClick(TObject *Sender);
  void __fastcall ErrorRateEditClick(TObject *Sender);
  void __fastcall FailCountEditClick(TObject *Sender);
  void __fastcall StartButtonClick(TObject *Sender);
  void __fastcall MeasuringTimerTimer(TObject *Sender);
  void __fastcall ResultPanel9Click(TObject *Sender);
  void __fastcall StopButtonClick(TObject *Sender);
  void __fastcall MinBrightnessResultImageDblClick(TObject *Sender);
  void __fastcall MaxBrightnessResultImageDblClick(TObject *Sender);
  void __fastcall FormActivate(TObject *Sender);
private:	// User declarations
  void __fastcall InitComponent();
  void __fastcall SetCameraID();
  void __fastcall HideCameraComponent();
  void __fastcall SetCameraParams();
  void __fastcall SetStudyResultColor();
  void __fastcall SetMeasuredResultComponent();
  void __fastcall SetProgressBar();
  void __fastcall InitImageComponent(TTntImage *srcImage, int width, int height);
  void __fastcall ReadCameraTestOptions();
  void __fastcall WriteCameraTestOptions();
  void __fastcall SetGaugeRange(int cameraIndex);
  void __fastcall InitMeasureValue();
  bool __fastcall CaptureSetup();
  void __fastcall RefreshCameraInfo(int camIndex, float m);
  bool __fastcall ReadSetupData(TTabletSetupData *tabletSetupData);
  void __fastcall DoProcessing(int cameraIndex);
  bool __fastcall Read3DSetupData(TTablet3DSetupData *tablet3DSetupData);
  void __fastcall Setup(int cameraIndex);
  void __fastcall LoadRealtimeResult(int cameraIndex);
  void __fastcall LoadFinalResultData(int cameraIndex);
  bool __fastcall CheckCameraParams();
  void __fastcall GetDefaultString();

  TTabletStudyResultData lastStudyResultData;
  TCameraCheckOption CameraCheckOption;

  int CameraStudyLevel[SYSTEM_TOTAL_CAMERA_COUNT][3];
  int CurrentTargetCameraIndex;
  int TimerCheckingCameraIndex;
  int globalCameraCheckingCount;
  int globalCameraFailCount;
  int Sim_ImageIndex;

  int ImageWidth[2];
  int ImageHeight[2];

  unsigned char CaptureData[SYSTEM_CAMERA_HD_WIDTH * SYSTEM_CAMERA_HD_HEIGHT];
  TSideData tempSideData[SYSTEM_TOTAL_CAMERA_COUNT - 4];
  unsigned char PCBackgroundImageBuffer[MAX_INBOARD_PROCESSING_CAMERA_COUNT][MAX_IMAGE_WIDTH * MAX_IMAGE_HEIGHT * 3];
  short PCColorRateImageBuffer[MAX_INBOARD_PROCESSING_CAMERA_COUNT][MAX_IMAGE_WIDTH * MAX_IMAGE_HEIGHT * 3];
  unsigned char PCRGBFactorArrayBuffer[MAX_INBOARD_PROCESSING_CAMERA_COUNT][MAX_IMAGE_WIDTH * MAX_IMAGE_HEIGHT];

  int AccColor[3];
  int MinDiffColor[3];
  int MinDiffLevel;
  int MaxDiffColor[3];
  int MaxDiffLevel;
  int StudyResultData[SYSTEM_TOTAL_CAMERA_COUNT][3][256];
  bool bStop;

  TCameraTestResultData CameraTestResultData[SYSTEM_TOTAL_CAMERA_COUNT];
  unsigned char minBrightnessImage[SYSTEM_TOTAL_CAMERA_COUNT][SYSTEM_CAMERA_HD_WIDTH * SYSTEM_CAMERA_HD_HEIGHT * 3];
  unsigned char maxBrightnessImage[SYSTEM_TOTAL_CAMERA_COUNT][SYSTEM_CAMERA_HD_WIDTH * SYSTEM_CAMERA_HD_HEIGHT * 3];

public:		// User declarations
  __fastcall TCameraTestForm(TComponent* Owner);

  bool AbnormalSW;
};
//---------------------------------------------------------------------------
extern PACKAGE TCameraTestForm *CameraTestForm;
//---------------------------------------------------------------------------
#endif
