//---------------------------------------------------------------------------
#ifndef DefectInfo_FormH
#define DefectInfo_FormH
//---------------------------------------------------------------------------
#include <Classes.hpp>
#include <Controls.hpp>
#include <StdCtrls.hpp>
#include <Forms.hpp>
#include <ExtCtrls.hpp>
#include <Grids.hpp>

#include "CPB_Module.h"
#include "CPB_Module_Main.h"
#include "common_PC.h"
#include "Processing.h"
#include "FileContainer.h"
#include "TntExtCtrls.hpp"
#include "TntGrids.hpp"
#include "TntStdCtrls.hpp"
#include "TntForms.hpp"
#include <Dialogs.hpp>
#include <ExtDlgs.hpp>
#include <Graphics.hpp>
#include <ComCtrls.hpp>
//---------------------------------------------------------------------------
#define THREED_NONE_STEP              0
#define THREED_INSPECTION_RESULT_STEP 1
#define THREED_ORIGIN_IMAGE_STEP      2

#define MAX_ZOOM_W_PIXEL 400
#define MAX_ZOOM_H_PIXEL 400

#define ZOOM_IMAGE_SHIFT  1
#define ZOOM_IMAGE_DEFECT 2

#define PROTO_STUDY_COUNT 50

#define FULL_SIZE_IMAGE_LOADING_TIME  1.0f

#define LIMIT_NOT_INSPECTION_DEFECT_COUNT 5000
#define LIMIT_INSPECTION_DEFECT_COUNT 100

#define SCROLL_UP   1
#define SCROLL_DOWN 2
//---------------------------------------------------------------------------
typedef struct
{
	int DefectIndex;
	TDefectData_PC DefectData;
} TDefectDataUnit;
//---------------------------------------------------------------------------
typedef struct
{
	int TabletNumber;
  int DefectImageCount;
  int DefectSeries;
  int MajorCamIndex;
	bool DefectDataExist[SYSTEM_TOTAL_CAMERA_COUNT];
	char CameraInspectPosition[SYSTEM_TOTAL_CAMERA_COUNT];
  int DefectDataIndex[SYSTEM_TOTAL_CAMERA_COUNT];
} TDefectViewUnit;
//---------------------------------------------------------------------------
int __fastcall SortDefectDataByTabletNumber_Ascending(void *firstUnit, void *secondUnit);
int __fastcall SortDefectDataByTabletNumber_Descending(void *firstUnit, void *secondUnit);
int __fastcall SortDefectDataByDefectSize_Ascending(void *firstUnit, void *secondUnit);
int __fastcall SortDefectDataByDefectSize_Descending(void *firstUnit, void *secondUnit);
int __fastcall SortDefectDataByCamera_Ascending(void *firstUnit, void *secondUnit);
int __fastcall SortDefectDataByCamera_Descending(void *firstUnit, void *secondUnit);
//---------------------------------------------------------------------------
class TDefectInfoForm : public TTntForm
{
__published:	// IDE-managed Components
	TTntStringGrid *DefectListStringGrid;
	TTntPanel *Panel1;
	TTntPanel *Panel2;
	TTntPanel *Panel5;
	TTntPanel *Panel6;
	TTntGroupBox *GroupBox2;
	TTntPanel *Panel17;
	TTntPanel *FilterCameraAllPanel;
	TTntPanel *FilterCameraFrontPanel;
	TTntPanel *FilterCameraSidePanel;
	TTntGroupBox *GroupBox3;
	TTntPanel *FilterSeriesPanel1;
	TTntPanel *FilterSeriesPanel2;
	TTntPanel *FilterSeriesPanel3;
	TTntPanel *FilterSeriesPanel4;
	TTntPanel *FilterSeriesPanel5;
	TTntPanel *FilterSeriesPanel6;
	TTntPanel *FilterSeriesPanel7;
	TTntPanel *Panel30;
	TTntPanel *FilterSeriesAllPanel;
	TTntGroupBox *ScrollGroupBox;
	TTntImage *ScrollImage;
	TTimer *ScrollTimer;
	TTntPanel *Panel29;
	TTntButton *RefreshButton;
	TTntPanel *SortByTimePanel;
	TTntPanel *SortBySizePanel;
  TTntPanel *FilterCameraOptionPanel;
	TTntPanel *FilterSeriesPanel8;
	TTntPanel *SortByCameraPanel;
  TPanel *Panel3;
  TTntPanel *Panel4;
  TTntGroupBox *GroupBox5;
  TTntStringGrid *DefectStringGrid;
  TTntPanel *DefectImagePanel;
  TTntImage *SavedDefectImage;
  TTntImage *DefectImage1;
  TTntImage *DefectImage2;
  TTntImage *DefectImage3;
  TTntImage *DefectImage4;
  TTntImage *DefectImage5;
  TTntImage *DefectImage6;
  TTntImage *DefectImage7;
  TTntImage *DefectImage8;
  TTntImage *DefectImage9;
  TTntImage *DefectImage10;
  TTntImage *tempSavedDefectImage;
  TSavePictureDialog *SavePictureDialog1;
  TImage *SPBThreeDImage;
  TTntGroupBox *DebuggingGroupBox;
  TTntLabel *Label8;
  TTntLabel *Label6;
  TTntButton *ReadDataButton2;
  TTntButton *ReadDataButton1;
  TTntEdit *SPBIndexEdit;
  TTntEdit *CPBIndexEdit;
  TTntButton *ReadTabletInfoButton;
  TGroupBox *GroupBox1;
  TImage *ZoomInImage;
  TImage *zoomInOutImage;
  TPanel *Panel7;
  TImage *ZoomInBtn;
  TPanel *Panel8;
  TImage *ZoomOutBtn;
  TLabel *ZoomSizeLabel;
  TTntImage *upImage;
  TTntImage *downImage;
  TTntImage *DefectImage11;
  TTntImage *DefectImage12;
  TTntImage *DefectImage13;
  TTntImage *DefectImage14;
  TTntImage *DefectImage15;
  TTntImage *DefectImage16;
  TTimer *FullSizeImageLoadTimer;
  TProgressBar *ProgressBar1;
  TPanel *Panel9;
  TTntEdit *CurrentViewStepEdit;
  TTntLabel *DefectViewLimitCountEdit;
  TTntButton *TntButton1;
  TTntButton *TntButton2;
  TTntPanel *TntPanel1;
  TTntPanel *DefectViewStepControlPanel;
  TButton *Button1;
  TCheckBox *ThreeDLaserInfoViewerCheckBox;
  TLabel *ThreeDResultLabel1;
  TLabel *ThreeDResultLabel2;
  TLabel *ThreeDResultLabel3;
  TScrollBox *ThreeDDebugInfoPanel;
  TImage *ThreeDDebug_OriginalImage;
  TLabel *Label23;
  TImage *ThreeDDebug_MaxLabelingImage;
  TLabel *Label24;
  TImage *ThreeDDebug_BasicTabletAreaImage;
  TLabel *Label25;
  TLabel *Label28;
  TImage *ThreeDDebug_ApplyOverlapRemoveImage;
  TImage *ThreeDDebug_OverlapAreaImage;
  TLabel *Label27;
  TImage *ThreeDDebug_ScaleDownImage;
  TLabel *Label26;
  TImage *ThreeDDebug_RemoveNoiseImage;
  TLabel *Label29;
  TImage *ThreeDDebug_COGResultImage;
  TLabel *Label30;
  TImage *ThreeDDebug_RotationImage;
  TLabel *Label31;
  TLabel *Label34;
  TImage *ThreeDDebug_DentedImage;
  TImage *ThreeDDebug_SaturationArea;
  TLabel *Label35;
  TImage *ThreeDDebug_PrintMatchingResult;
  TLabel *Label41;
  TImage *ThreeDDebug_BeforeRotationResult;
  TLabel *Label38;
  TImage *ThreeDDebug_ThreeDShellImage;
  TLabel *Label44;
  TButton *ThreeDDebugButton;
  TImage *ThreeDDebug_ExpecteDefectArea;
  TLabel *Label1;
  TTntImage *DepthRefImage;
  TImage *ExtractedPrintInfoImage;
  TTntPanel *PrintInfoPanel;
  TPanel *Panel10;
  TTntLabel *TntLabel1;
  TTntLabel *TntLabel2;
  TTntPanel *TntPanel2;
	void __fastcall ReadDataButton1Click(TObject *Sender);
	void __fastcall FormCreate(TObject *Sender);
	void __fastcall ReadDataButton2Click(TObject *Sender);
	void __fastcall FormDestroy(TObject *Sender);
	void __fastcall DefectListStringGridClick(TObject *Sender);
	void __fastcall SubDefectImageClick(TObject *Sender);
	void __fastcall ReadTabletInfoButtonClick(TObject *Sender);
	void __fastcall RefreshButtonClick(TObject *Sender);
	void __fastcall FilterCameraAllPanelClick(TObject *Sender);
	void __fastcall FilterCameraFrontPanelClick(TObject *Sender);
	void __fastcall FilterCameraSidePanelClick(TObject *Sender);
	void __fastcall FilterSeriesPanelClick(TObject *Sender);
	void __fastcall ScrollImageMouseDown(TObject *Sender, TMouseButton Button,
          TShiftState Shift, int X, int Y);
	void __fastcall ScrollImageMouseMove(TObject *Sender, TShiftState Shift,
          int X, int Y);
	void __fastcall ScrollImageMouseUp(TObject *Sender, TMouseButton Button,
          TShiftState Shift, int X, int Y);
	void __fastcall ScrollTimerTimer(TObject *Sender);
	void __fastcall SortByTimePanelClick(TObject *Sender);
	void __fastcall SortBySizePanelClick(TObject *Sender);
	void __fastcall NumberEditClick(TObject *Sender);
    void __fastcall FilterCameraOptionPanelClick(TObject *Sender);
	void __fastcall SortByCameraPanelClick(TObject *Sender);
	void __fastcall Panel2Resize(TObject *Sender);
  void __fastcall ZoomInBtnClick(TObject *Sender);
  void __fastcall ZoomOutBtnClick(TObject *Sender);
  void __fastcall zoomInOutImageMouseDown(TObject *Sender,
          TMouseButton Button, TShiftState Shift, int X, int Y);
  void __fastcall zoomInOutImageMouseUp(TObject *Sender,
          TMouseButton Button, TShiftState Shift, int X, int Y);
  void __fastcall zoomInOutImageMouseMove(TObject *Sender,
          TShiftState Shift, int X, int Y);
  void __fastcall upImageClick(TObject *Sender);
  void __fastcall downImageClick(TObject *Sender);
  void __fastcall Panel9DblClick(TObject *Sender);
  void __fastcall Panel17DblClick(TObject *Sender);
  void __fastcall SavedDefectImageMouseUp(TObject *Sender,
          TMouseButton Button, TShiftState Shift, int X, int Y);
  void __fastcall SavedDefectImageMouseDown(TObject *Sender,
          TMouseButton Button, TShiftState Shift, int X, int Y);
  void __fastcall FullSizeImageLoadTimerTimer(TObject *Sender);
  void __fastcall SavedDefectImageDblClick(TObject *Sender);
  void __fastcall TntButton1Click(TObject *Sender);
  void __fastcall Button1Click(TObject *Sender);
  void __fastcall ThreeDLaserInfoViewerCheckBoxClick(TObject *Sender);
  void __fastcall ThreeDDebugButtonClick(TObject *Sender);
  void __fastcall GroupBox1DblClick(TObject *Sender);
  void __fastcall TntPanel2Click(TObject *Sender);
private:	// User declarations
	int SavedDefectIndex;
  unsigned char CPBImage[SYSTEM_CAMERA_WIDTH * SYSTEM_CAMERA_HEIGHT * 5];
	TDefectData_PC SavedDefectData;
  void __fastcall ShowDefectInfo(void);
	void __fastcall RefreshStringGrid(void);
	TList *DefectDataList;

  TList *DefectViewList;
  int CurrentViewIndex;
  int CurrentImageIndex;
  int FilterCameraMask;
  int FilterDefectSeriesMask;
  int SortMethod;

  int CurrentDefectStX;
  int CurrentDefectEdX;
  int CurrentDefectStY;
  int CurrentDefectEdY;

  WideString ProductCode;
  WideString LOTName;

  TPoint ScrollImageMouseDownPos;
  TPoint ScrollImageMouseMovePos;
  bool IsScrollImageMouseDown;
  int StringGridMouseDownPos;
	unsigned int LastScrollTime;

  int zoomInOutShiftX;
  int zoomInOutShiftY;
  int zoomInOutSize;
  int zoomImageNavigateFlag;
  int navigateStdX;
  int navigateStdY;
  int zoomROIX1, zoomROIY1, zoomROIX2, zoomROIY2;
  int tempStdX, tempStdY;
  unsigned char extensionColorSourceImage[MAX_ZOOM_W_PIXEL * MAX_ZOOM_H_PIXEL * 3];
  unsigned char originalColorSourceImage[HD_IMAGE_WIDTH * HD_IMAGE_HEIGHT * 3];

	TFileContainer *DefectImageContainer;
	Graphics::TBitmap *Current3DBitmap;
  int InspectionOrStudy;
  int InspectionKind;
  int GlobalCameraIndex;

  bool ProcessingPCSIM;
  int threeDProcessingStep;

  bool bEngraveDefect;

  int SourceImageWidth[2];
  int SourceImageHeight[2];
  int rate[2];
  int FontSizeAdjust[2];

  bool bMouseDown;
  double MouseDownStartTime;

  TTntImage *SrcImage;

  TSideData tempSideData[SYSTEM_TOTAL_CAMERA_COUNT - 4];

  unsigned char PCBackgroundImageBuffer[MAX_INBOARD_PROCESSING_CAMERA_COUNT][MAX_IMAGE_WIDTH * MAX_IMAGE_HEIGHT * 3];
  short PCColorRateImageBuffer[MAX_INBOARD_PROCESSING_CAMERA_COUNT][MAX_IMAGE_WIDTH * MAX_IMAGE_HEIGHT * 3];
  unsigned char PCRGBFactorArrayBuffer[MAX_INBOARD_PROCESSING_CAMERA_COUNT][MAX_IMAGE_WIDTH * MAX_IMAGE_HEIGHT];

  Graphics::TBitmap *CurrentDisplayImage;

  void __fastcall DoProcessing(int cameraIndex);
  void __fastcall DoProcessingFor3D(int cameraIndex);
  void __fastcall ImageLoad(int cameraIndex, int threeDImage);
  void __fastcall ProcessingResultDisplay(int cameraIndex);
  void __fastcall ProcessingResultDisplayFor3D(int cameraIndex);
  void __fastcall RestoreOriginalImg();
  bool __fastcall ReadStudyData(TTabletStudyData *tabletStudyData);

	void __fastcall Remake3DDefectImage(TTntImage *anImage);
	void __fastcall Remake3DDefectImage_24bit(TTntImage *anImage);
	void __fastcall Remake3DSubDefectImage(TTntImage *anImage);
	void __fastcall Remake3DSubDefectImage_24bit(TTntImage *anImage);
	AnsiString __fastcall GetDefectContainerFileName(int defectIndex);
	bool __fastcall ReadSetupData(TTabletSetupData *tabletSetupData);
  bool __fastcall Read3DSetupData(TTablet3DSetupData *tablet3DSetupData);
  void __fastcall GetDefaultString();
  void __fastcall setPosSetupData(TTabletSetupData *pTabletSetupData);
  void __fastcall WriteSetupData(TTabletSetupData *tabletSetupData);
  void __fastcall LoadZoomInOutNavigationImage(int Mode, int dX, int dY);
  void __fastcall refreshZoomInTabletImage();
  int __fastcall GetSideFaceCameraIndex(int cameraIndex);
  void __fastcall LoadFrontFace3DDebugData();
  TColor __fastcall ThreeDDepth(int srcValue, int maxValue);
  TColor __fastcall SetDepthbar();

  bool InspectionSataus;
  int MaxLimitViewStepCount;
  int CurrentViewStepCount;
  void __fastcall ScrollPageChange(int Direction); // 1 : Up , 2 : Down
  bool EnableScroll;
  double RecentRealImageLoad_Percent;

  bool bViewThreeDPositionInfo;
public:		// User declarations
	__fastcall TDefectInfoForm(TComponent* Owner);
	void __fastcall ResetDefectData(void);
	void __fastcall InitDefectInfo(WideString productCode, WideString lotName , int shiftstep = 0,bool Inspectionstatus = false );
  void __fastcall RefreshInspectionSetupData();
  void __fastcall CheckTPB_BoardExist(void);

  int DefectSeriesCount[MAX_DEFECT_SERIES_COUNT + 1];
  WideString ErrorMsg[10];

};
//---------------------------------------------------------------------------
extern PACKAGE TDefectInfoForm *DefectInfoForm;
//---------------------------------------------------------------------------
#endif
