#include <vcl.h>
#include <FileCtrl.hpp>
#include <inifiles.hpp>
#pragma hdrstop

#include <math.h>
#include "First_Study.h"
#include "Environment.h"
#include "Message_Form.h"
#include "MultiLanguage.h"
#include "Keyboard_Form.h"
#include "Waiting_Form.h"

//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma link "CSPIN"
#pragma link "TntButtons"
#pragma link "TntComCtrls"
#pragma link "TntExtCtrls"
#pragma link "TntStdCtrls"
#pragma resource "*.dfm"
TFirstStudy *FirstStudy;

typedef struct
{
	int Left_Position[SYSTEM_TOTAL_CAMERA_COUNT][640];
	int Right_Position[SYSTEM_TOTAL_CAMERA_COUNT][640];
	int Top_Position[SYSTEM_TOTAL_CAMERA_COUNT][480];
	int Bottom_Position[SYSTEM_TOTAL_CAMERA_COUNT][480];

	int camera1_Print1_DiscriminationMarkPositionAdjust[41][2];
	int camera1_Print2_DiscriminationMarkPositionAdjust[41][2];
	int camera1_Print3_DiscriminationMarkPositionAdjust[41][2];
	int camera1_Print4_DiscriminationMarkPositionAdjust[41][2];

	int camera5_Print1_DiscriminationMarkPositionAdjust[41][2];
	int camera5_Print2_DiscriminationMarkPositionAdjust[41][2];
	int camera5_Print3_DiscriminationMarkPositionAdjust[41][2];
	int camera5_Print4_DiscriminationMarkPositionAdjust[41][2];

	int camera9_Print1_DiscriminationMarkPositionAdjust[41][2];
	int camera9_Print2_DiscriminationMarkPositionAdjust[41][2];
	int camera9_Print3_DiscriminationMarkPositionAdjust[41][2];
	int camera9_Print4_DiscriminationMarkPositionAdjust[41][2];

	int camera13_Print1_DiscriminationMarkPositionAdjust[41][2];
	int camera13_Print2_DiscriminationMarkPositionAdjust[41][2];
	int camera13_Print3_DiscriminationMarkPositionAdjust[41][2];
	int camera13_Print4_DiscriminationMarkPositionAdjust[41][2];

	int Shape_Yshift[SYSTEM_TOTAL_CAMERA_COUNT][41];

	int camera5_threeD_HeightDiff[30];
	int camera5_threeD_HeightDiffCount;

  int camera5_OneSide_threeD_HeightDiff[30];
	int camera5_OneSide_threeD_HeightDiffCount;
  int camera5_OtherSide_threeD_HeightDiff[30];
	int camera5_OtherSide_threeD_HeightDiffCount;

	int camera13_threeD_HeightDiff[30];
	int camera13_threeD_HeightDiffCount;

  int camera13_OneSide_threeD_HeightDiff[30];
	int camera13_OneSide_threeD_HeightDiffCount;
  int camera13_OtherSide_threeD_HeightDiff[30];
	int camera13_OtherSide_threeD_HeightDiffCount;
}TFirstStudyResult;

TFirstStudyResult FirstStudyResult;

//---------------------------------------------------------------------------
__fastcall TFirstStudy::TFirstStudy(TComponent* Owner)
	: TTntForm(Owner)
{
	if (DefaultLCID == 1028 || DefaultLCID == 2052 || DefaultLCID == 3076 || DefaultLCID == 4100)
		ComponentSetFontName(this, "SimSun");
	else if (DefaultLCID == 1041)
		ComponentSetFontName(this, "Meiryo UI");
  else if(DefaultLCID == 3082)
  {
    ComponentSetFontName(this, "Segoe UI");
    ComponentSetMultiLine(this);
  }

	GetDefaultString();
	ImageHeight = 480;
	ImageWidth = 640;

#ifdef PC_SIM
	ShowHintByName(this);
#endif
}
//---------------------------------------------------------------------------
void __fastcall TFirstStudy::GetDefaultString()
{
	BitBtn2->Caption = FIRSTSTUDYFORM_BITBTN_CAPTION_01;
	GroupBox12->Caption = FIRSTSTUDYFORM_GROUPBOX_CAPTION_01;
	Label11->Caption = FIRSTSTUDYFORM_LABEL_CAPTION_01;
	Label5->Caption = FIRSTSTUDYFORM_LABEL_CAPTION_02;
	Label6->Caption = FIRSTSTUDYFORM_LABEL_CAPTION_03;
	Label2->Caption = FIRSTSTUDYFORM_LABEL_CAPTION_04;
	Label3->Caption = FIRSTSTUDYFORM_LABEL_CAPTION_05;
	GroupBox11->Caption = FIRSTSTUDYFORM_LABEL_CAPTION_04;

	//add
	Label1->Caption = FIRSTSTUDYFORM_UNKNOWN_01;
  BitBtn1->Caption = FIRSTSTUDYFORM_BITBTN_CAPTION_08;

	if (DefaultLCID == 1042)
	{
		CameraInfo[0] = "2D ";
		CameraInfo[1] = "2D ";
		CameraInfo[2] = "2D ";
		CameraInfo[3] = "2D ";
		CameraInfo[4] = "3D ";
		CameraInfo[5] = "2D ";
		CameraInfo[6] = "2D ";
		CameraInfo[7] = "2D ";
		CameraInfo[8] = "2D ";
		CameraInfo[9] = "2D ";
		CameraInfo[10] = "2D ";
		CameraInfo[11] = "2D ";
		CameraInfo[12] = "3D ";
		CameraInfo[13] = "2D ";
		CameraInfo[14] = "2D ";
		CameraInfo[15] = "2D ";
	}
	else
	{
		CameraInfo[0] = "Top 2D Front";
		CameraInfo[1] = "Top Lower Side";
		CameraInfo[2] = "Top Side";
		CameraInfo[3] = "Top Upper Side";
		CameraInfo[4] = "Top 3D Front";
		CameraInfo[5] = "Top Lower Side";
		CameraInfo[6] = "Top Side";
		CameraInfo[7] = "Top Upper Side";
		CameraInfo[8] = "Bottom 2D Front";
		CameraInfo[9] = "Bottom Lower Side";
		CameraInfo[10] = "Bottom Side";
		CameraInfo[11] = "Bottom Upper Side";
		CameraInfo[12] = "Bottom 3D Front";
		CameraInfo[13] = "Bottom Lower Side";
		CameraInfo[14] = "Bottom Side";
		CameraInfo[15] = "Bottom Upper Side";

		Panel3->Caption = "Side Area 3D Matching distribution";
		Panel4->Caption = "Side Area Matching Result";
	}

    GroupBox1->Caption = FIRSTSTUDYFORM_GROUPBOX_CAPTION_02;
    Panel3->Caption = FIRSTSTUDYFORM_PANEL_CAPTION_01;
    Panel4->Caption = FIRSTSTUDYFORM_PANEL_CAPTION_02;

    /*
    SideFaceShiftXMatchingResult1->Caption	= FIRSTSTUDYFORM_LABEL_CAPTION_10;
    SideFaceShiftXMatchingResult2->Caption	= FIRSTSTUDYFORM_LABEL_CAPTION_10;
    SideFaceShiftXMatchingResult3->Caption	= FIRSTSTUDYFORM_LABEL_CAPTION_10;

    SideFaceShiftYMatchingResult1->Caption	= FIRSTSTUDYFORM_LABEL_CAPTION_11;
    SideFaceShiftYMatchingResult2->Caption	= FIRSTSTUDYFORM_LABEL_CAPTION_11;
    SideFaceShiftYMatchingResult3->Caption	= FIRSTSTUDYFORM_LABEL_CAPTION_11;

    SideFaceResolution1->Caption	= FIRSTSTUDYFORM_LABEL_CAPTION_12;
    SideFaceResolution2->Caption	= FIRSTSTUDYFORM_LABEL_CAPTION_12;
    SideFaceResolution3->Caption	= FIRSTSTUDYFORM_LABEL_CAPTION_12;

    SideFaceXAngleMatchingResult1->Caption	= FIRSTSTUDYFORM_LABEL_CAPTION_13;
    SideFaceXAngleMatchingResult2->Caption	= FIRSTSTUDYFORM_LABEL_CAPTION_13;
    SideFaceXAngleMatchingResult3->Caption	= FIRSTSTUDYFORM_LABEL_CAPTION_13;

    SideFaceYAngleMatchingResult1->Caption	= FIRSTSTUDYFORM_LABEL_CAPTION_14;
    SideFaceYAngleMatchingResult2->Caption	= FIRSTSTUDYFORM_LABEL_CAPTION_14;
    SideFaceYAngleMatchingResult3->Caption	= FIRSTSTUDYFORM_LABEL_CAPTION_14;

    SideFaceZAngleMatchingResult1->Caption	= FIRSTSTUDYFORM_LABEL_CAPTION_15;
	SideFaceZAngleMatchingResult2->Caption	= FIRSTSTUDYFORM_LABEL_CAPTION_15;
    SideFaceZAngleMatchingResult3->Caption	= FIRSTSTUDYFORM_LABEL_CAPTION_15;
    */
    
    XAngleMatchingResultChart->Title->Text->Strings[0]	= FIRSTSTUDYFORM_LABEL_CAPTION_13;
    YAngleMatchingResultChart->Title->Text->Strings[0]	= FIRSTSTUDYFORM_LABEL_CAPTION_14;
    ZAngleMatchingResultChart->Title->Text->Strings[0]	= FIRSTSTUDYFORM_LABEL_CAPTION_15;

}

//---------------------------------------------------------------------------
void __fastcall TFirstStudy::ImageLoad(int imageIndex, int cameraIndex)
{
	int x, y;
	int rgb;
	rgb = 1;
	int selectedImageNumber;
	selectedImageNumber = imageIndex;
	Graphics::TBitmap *img1;
	img1 = new Graphics::TBitmap();
	Graphics::TBitmap *img2;
	img2 = new Graphics::TBitmap();
	AnsiString fileName;

	if (cameraIndex != SD1_3D_FRONT_FACE_CAMERA_INDEX &&
		    cameraIndex != SD2_3D_FRONT_FACE_CAMERA_INDEX)
	{
    ExtractBayerImage(BayerImage, selectedImageNumber, cameraIndex); 
	}
	else
	{
		if (ExtractImage(img1, selectedImageNumber, cameraIndex, TabletSetupData.ImageOffSetSW[cameraIndex - 1], TabletSetupData.referenceImageForOffset[cameraIndex - 1], ProductData.SubSamplingMode))
		{
      if (CameraMapInfo[cameraIndex - 1].CameraInspectPosition != CAMERA_POSITION_3D && ProductData.SubSamplingMode == IMAGE_FULL_SCALE_MODE)
      {
        ReductionImageScale(img1);
      }
      
			img2->Assign(img1);
			img2->Width = img1->Width * 2;

			Byte *ptr;
			Byte *tr;
			ExtractBayerImage(BayerImage, selectedImageNumber, cameraIndex);

			for (y = 0; y < ImageHeight; y++)
			{
				ptr = (byte*)img1->ScanLine[y];
				tr = (byte*)img2->ScanLine[y];
				for (x = 0; x < img1->Width * 2; x++)
				{
					tr[x] = ptr[x / 2];
				}
			}
			Image59->Picture->Bitmap->Assign(img2);
			Image59->Canvas->Pen->Width = 1;
			Image59->Canvas->Pen->Color = clGray;
			Image59->Canvas->Brush->Style = bsClear;
			Image59->Canvas->Rectangle(TabletSetupData.ImageCutStartX[cameraIndex - 1], TabletSetupData.ImageCutStartY[cameraIndex - 1],
				TabletSetupData.ImageCutEndX[cameraIndex - 1], TabletSetupData.ImageCutEndY[cameraIndex - 1]);
			Image59->Refresh();
		}
		else
		{
			ShowMessageW(FIRSTSTUDYFORM_MSG_03);
		}
	}

  delete(img1);
  delete(img2);
}

//---------------------------------------------------------------------------
void __fastcall TFirstStudy::MakeTabletSetupData(TTabletCharacter *tabletCharacter)
{
	for (int globalCameraIndex = 0; globalCameraIndex < SYSTEM_TOTAL_CAMERA_COUNT; globalCameraIndex++)
	{
		TabletSetupData.DiskBaseHeightPosition[globalCameraIndex] = MachineParams.DiscCenterPos[globalCameraIndex] / 4 * 4;
	}

	for (int globalCameraIndex = 1; globalCameraIndex <= SYSTEM_TOTAL_CAMERA_COUNT; globalCameraIndex++)
	{
		if (globalCameraIndex != SD1_2D_FRONT_FACE_CAMERA_INDEX &&
			globalCameraIndex != SD1_2D_FRONT_FACE_CAMERA_INDEX &&
			globalCameraIndex != SD1_3D_FRONT_FACE_CAMERA_INDEX &&
			globalCameraIndex != SD2_3D_FRONT_FACE_CAMERA_INDEX)
		{
			TiltingTabletHeight[globalCameraIndex - 1] = GetTabletAreaInfo(globalCameraIndex);
		}
	}

	for (int globalCameraIndex = 0; globalCameraIndex < SYSTEM_TOTAL_CAMERA_COUNT; globalCameraIndex++)
	{

		TabletSetupData.ImageCutStartX[globalCameraIndex] = MAX_IMAGE_WIDTH / 2 - tabletCharacter->length;
		TabletSetupData.ImageCutEndX[globalCameraIndex] = MAX_IMAGE_WIDTH / 2 + tabletCharacter->length;
		TabletSetupData.ImageCutStartY[globalCameraIndex] = 10;
		TabletSetupData.ImageCutEndY[globalCameraIndex] = MAX_IMAGE_HEIGHT - 10;

		switch (globalCameraIndex + 1)
		{
		case SD1_2D_SIDE_FACE_P45_CAMERA_INDEX:
		case SD1_2D_SIDE_FACE_00_CAMERA_INDEX:
		case SD1_2D_SIDE_FACE_M45_CAMERA_INDEX:
		case SD1_2D_OTHER_SIDE_FACE_P45_CAMERA_INDEX:
		case SD1_2D_OTHER_SIDE_FACE_00_CAMERA_INDEX:
		case SD1_2D_OTHER_SIDE_FACE_M45_CAMERA_INDEX:
		case SD2_2D_SIDE_FACE_P45_CAMERA_INDEX:
		case SD2_2D_SIDE_FACE_00_CAMERA_INDEX:
		case SD2_2D_SIDE_FACE_M45_CAMERA_INDEX:
		case SD2_2D_OTHER_SIDE_FACE_P45_CAMERA_INDEX:
		case SD2_2D_OTHER_SIDE_FACE_00_CAMERA_INDEX:
		case SD2_2D_OTHER_SIDE_FACE_M45_CAMERA_INDEX:

			int adjustMiddleHeight = TabletCharacter.middle_height * TabletSetupData.cameraZoom[0] / TabletSetupData.cameraZoom[globalCameraIndex];

			TabletSetupData.ImageCutStartY[globalCameraIndex] = max(10, TabletSetupData.DiskBaseHeightPosition[globalCameraIndex] - TiltingTabletHeight[globalCameraIndex] - 80);
			TabletSetupData.ImageCutEndY[globalCameraIndex] = min(MAX_IMAGE_HEIGHT - 30, TabletSetupData.DiskBaseHeightPosition[globalCameraIndex] + 10);
			break;
		}

		if (TabletSetupData.ImageCutStartX[globalCameraIndex] < 10) TabletSetupData.ImageCutStartX[globalCameraIndex] = 10;
		if (TabletSetupData.ImageCutStartY[globalCameraIndex] < 10) TabletSetupData.ImageCutStartY[globalCameraIndex] = 10;
		if (TabletSetupData.ImageCutEndX[globalCameraIndex] >= MAX_IMAGE_WIDTH - 10) TabletSetupData.ImageCutEndX[globalCameraIndex] = MAX_IMAGE_WIDTH - 10;
		if (TabletSetupData.ImageCutEndY[globalCameraIndex] >= MAX_IMAGE_HEIGHT - 10) TabletSetupData.ImageCutEndY[globalCameraIndex] = MAX_IMAGE_HEIGHT - 10;
	}

	//////////////////////⺻ //////////////////////////////
	TabletStudyData.Print1_IsOrNotThreshold_ForCamera1 = 150;
	TabletStudyData.Print1_IsOrNotThreshold_ForCamera5 = 150;
	TabletStudyData.Print1_IsOrNotThreshold_ForCamera9 = 150;
	TabletStudyData.Print1_IsOrNotThreshold_ForCamera13 = 150;

	TabletStudyData.tabletColorR_ForCamera1 = 100;
	TabletStudyData.tabletColorG_ForCamera1 = 100;
	TabletStudyData.tabletColorB_ForCamera1 = 100;
	TabletStudyData.tabletColorR_ForCamera9 = 100;
	TabletStudyData.tabletColorG_ForCamera9 = 100;
	TabletStudyData.tabletColorB_ForCamera9 = 100;

	TabletGradeData.frontShapeEdgeNeighborRange = 21;
	//////////////////////////////////////////////////////////////

	TabletGradeData.front_stain_Intensity = 5;
	TabletGradeData.front_stain_Size = 30;
	TabletGradeData.front_edge_Intensity = 5;
	TabletGradeData.front_edge_Size = 30;
	TabletGradeData.front_edge_dirty_Intensity = 3;
	TabletGradeData.front_edge_dirty_Size = 13;
	TabletGradeData.front_dirty_Intensity = 2;
	TabletGradeData.front_dirty_Size = 12;
	TabletGradeData.front_color_Intensity = 4;
	TabletGradeData.frontBorderIsSW = 0;
	TabletGradeData.frontShaepEdgeSaturationEraseSW = 0;
	TabletGradeData.frontSmallSizeGrade = 4;
	/////////////////////////////////////////////////////////////////
	/////////////////////////////////////////////////////////////////
	TabletGradeData.option_front_edgeBreaking_Intensity_Type1 = 60;
	TabletGradeData.option_front_edgeBreaking_Size_Type1 = 100;

	TabletGradeData.option_front_edgeBreaking_Intensity_Type2 = 60;
	TabletGradeData.option_front_edgeBreaking_Size_Type2 = 100;

	TabletGradeData.option_Breaking_Intensity = 22;
	TabletGradeData.option_PrintMark_Intensity = 20;
	TabletGradeData.option_Breaking_Size = 90;
	////////////////////////////////////////////////////////
	TabletGradeData.front_Color_Dirty_Intensity = 6;

	TabletGradeData.side_Edge_Color_Dirty_Intensity = 6;
	TabletGradeData.side_Edge_Color_Dirty_Size = 35;

	TabletGradeData.front_unInspectionIntensity_ForPrint = 0;
	TabletGradeData.front_unInspectionIntensity_ForEdge = 0;
	TabletGradeData.front_unInspectionIntensity_ForOptionPrint = 0;
	TabletGradeData.front_unInspectionIntensity_ForOptionEdge = 0;
	TabletGradeData.side_Edge_Top_Neighbor_Intensity = 0;
	TabletGradeData.side_Edge_Bottom_Neighbor_Intensity = 2;
	////////////////////////////////////////////////////////
	TabletGradeData.SideFaceEdgeAreaSize = 6;
	TabletGradeData.SideFaceEdgeUnInsAreaSize = 2;

	TabletGradeData.rear_stain_Intensity = 5;
	TabletGradeData.rear_stain_Size = 35;
	TabletGradeData.rear_dirty_Intensity = 2;
	TabletGradeData.rear_dirty_Size = 13;
	TabletGradeData.rear_edge_dirty_Intensity = 2;
	TabletGradeData.rear_edge_dirty_Size = 10;
	TabletGradeData.rear_edge_Intensity = 5;
	TabletGradeData.rear_edge_Size = 40;
	TabletGradeData.rear_Color_Dirty_Intensity = 2;
	TabletGradeData.rear_Color_Dirty_Size = 35;
	TabletGradeData.rear_print_dirty_Inetensity = 3;
	////////////////////////////////////////////////////////////////
	////////////////////////////////////////////////////////////////
	TabletGradeData.side_stain_Intensity = 4;
	TabletGradeData.side_stain_Size = 25;
	TabletGradeData.side_dirty_Intensity = 4;
	TabletGradeData.side_dirty_Size = 12;
	TabletGradeData.sideShapeEdgeMaskRange = 1;
	TabletGradeData.side_height_Intensity = 2;
	/////////////////////////////////////////////////////////
	TabletGradeData.FrontEdgeAreaExtendSW = 0;
	TabletGradeData.CoatedTablet_SideInspectionAreaSize = 10;
	TabletGradeData.front_print_erase_Intensity = 3;
	TabletGradeData.front_print_spread_Intensity = 3;

	TabletGradeData.threeD_Height_Plus_Limit = 7;
	TabletGradeData.threeD_Height_Minus_Limit = 7;
	TabletGradeData.Saturation_Erase_SW = 0;

	TabletGradeData.ETC_Side_None_Horizontality_Tablet = 0;
	TabletGradeData.ETC_Side_Split_Line_UnInspection_Area_Setting = 0;

	TabletGradeData.EngraveDistinguishGrade = 2;
	TabletGradeData.EngraveDistinguishGradeFor3D = 2;

	TabletGradeData.Side_Edge_Neighbor_Intensity = 4;
	TabletGradeData.Side_Edge_Neighbor_Defect_Size = 20;

	TabletGradeData.Side_Edge_Dark_Intensity = 5;
	TabletGradeData.Side_Edge_Dark_Defect_Size = 60;

	TabletGradeData.Side_Edge_Bright_Intensity = 5;
	TabletGradeData.Side_Edge_Bright_Defect_Size = 20;

	TabletGradeData.Side_Edge_Neighbor_Break_Intensity = 5;
	TabletGradeData.Side_Edge_Neighbor_Break_Size = 40;
	TabletGradeData.Side_Edge_Neighbor_Min_Break_Depth_Size = 3;

	TabletGradeData.DirtyGradeSensitivity = GRADE_SENSITIVITY_NORMAL;

	TabletGradeData.SplitLineMatchingSWForPrintTablet = 0;
	TabletGradeData.SplitLineMatchingThreshold = 10;

	TabletGradeData.ETC_ApplyColorDirtyIgnoreAlgorithm = 0; //  
	TabletGradeData.ETC_InterestedColor = 2; // RED Color
	TabletGradeData.ETC_ColorDirtyIgnoreLevel = 20;
	TabletGradeData.ETC_AdjustPrintAreaSW = 0;
	TabletGradeData.ETC_ColorDirtySize = 75;
	TabletGradeData.ETC_ThreeDCenterSize = 0;

	TabletGradeData.dummy[0] = 0;

	TabletGradeData.ETC_FrontFaceEdgeInspectionSW = 0;

	TabletGradeData.ETC_Partial3DPrintCheckSW = 0;

	TabletGradeData.ETC_RemoveBrightDotSW = 0;
	TabletGradeData.ETC_ApplyTiltTabletAlgorithm = 0;
	TabletGradeData.ETC_SideFaceMultiTabletUnInspectionSize = 0;

	TabletGradeData.DarkSpotDefectIntensityGradeForMarvelingTablet = 4;
	TabletGradeData.DarkSpotDefectSizeGradeForMarvelingTablet = 100;
	TabletGradeData.BrightSpotDefectIntensityGradeForMarvelingTablet = 4;
	TabletGradeData.BrightSpotDefectSizeGradeForMarvelingTablet = 100;

	TabletGradeData.DarkStainDefectIntensityGradeForMarvelingTablet = 6;
	TabletGradeData.DarkStainDefectSizeGradeForMarvelingTablet = 250;
	TabletGradeData.BrightStainDefectIntensityGradeForMarvelingTablet = 6;
	TabletGradeData.BrightStainDefectSizeGradeForMarvelingTablet = 250;

	TabletGradeData.DirtyDefectCheckSWInNeighborPrint = 0;
	TabletGradeData.ETC_EngraveWhiteDefectCheckAlgorithm = 0;
	TabletGradeData.ETC_EnforcementStainDefectCheckAlgorithm = 0;

	TabletGradeData.ETC_ApplyWhiteEngraveAlgorithm = 0;

	TabletGradeData.ETC_AdjustUnalignedTabletAlgorithm = 0;

	TabletGradeData.FrontFaceEngraveColorGrade = 10;

	TabletGradeData.FrontFaceEngraveWhiteSpotIntensity = 10;
	TabletGradeData.FrontFaceEngraveWhiteSpotSize = 100;

	TabletGradeData.EnforcementStainDefectInspectionAreaSize = 50;
	TabletGradeData.EnforcementStainDefectThreshold = 10;
	TabletGradeData.EnforcementStainDefectMaxLabelSize = 100;
	TabletGradeData.EnforcementStainDefectAllGroupSize = 200;

	TabletGradeData.ETC_EngraveMatchingOption_ReflectedTabletShape = 0;
	TabletGradeData.ETC_EngraveMatchingOption_LightEngrave = 0;

	TabletGradeData.ETC_ThreeD_DiffShapeTabletSW = 0;
	TabletGradeData.ETC_PrintPositionDefectIntensity = 0;
	TabletGradeData.ETC_PrintPositionRotationDefectIntensity = 0;

	TabletGradeData.LaserAllowX =	0;
	TabletGradeData.LaserAllowY = 	0;
	TabletGradeData.LaserAllowDegree =	0; 

	TabletGradeData.ThreeD_CoatedTablet_ShapeError_Height = 40;
	TabletGradeData.ThreeD_CoatedTablet_ShapeError_Size = 200;

	TabletGradeData.ETC_CoatedTablet_ShapeCheck = 0;

	TabletGradeData.front_print_dirty_Inetensity = 6;
	TabletGradeData.front_print_dirty_Inetensity2 = 15;

	TabletGradeData.ETC_PartialThreeDStampDefectIntensity = 2;
	TabletGradeData.ETC_PartialThreeDStampDefectSize = 200;

	TabletGradeData.ETC_ActiveSideEdgeDefectCheck = 0;
	TabletGradeData.ETC_SideEdgeDefectIntensity = 40;
	TabletGradeData.ETC_SideEdgeDefectSize = 200;

	TabletGradeData.EngraveMatchingOrNotValue = 0;
	TabletGradeData.ETC_TabletFrontFaceThreshold = 0;

	TabletGradeData.LIMA_ThreeD_Side_EraseLevel = 0;
	TabletGradeData.LIMA_ThreeD_MaxHeight = 0;
	TabletGradeData.LIMA_ThreeD_OverHeightSize = 40;

}
//---------------------------------------------------------------------------
bool __fastcall TFirstStudy::Read3DSetupData(TTablet3DSetupData *tablet3DSetupData)
{
	AnsiString setupDataFileName = ProgramPath.Product + "\\" + ProductData.ProductCode + "\\" + ProductData.ProductCode + ".sdt_3D";
	if (FileExists(setupDataFileName))
	{
		TFileStream *fileStream = new TFileStream(setupDataFileName, fmOpenRead);
		if (fileStream)
		{
			fileStream->Read(tablet3DSetupData, sizeof(TTablet3DSetupData));
			delete fileStream;
			return true;
		}
		else
		{
			return false;
		}
	}
	else
	{
		return false;
	}
}

//---------------------------------------------------------------------------
bool __fastcall TFirstStudy::ReadSetupData(TTabletSetupData *tabletSetupData)
{
	AnsiString setupDataFileName = ProgramPath.Product + "\\" + ProductData.ProductCode + "\\" + ProductData.ProductCode + ".sdt";
	if (FileExists(setupDataFileName))
	{
		TFileStream *fileStream = new TFileStream(setupDataFileName, fmOpenRead);
		if (fileStream)
		{
			memset(tabletSetupData, 0, sizeof(TTabletSetupData));
			fileStream->Read(tabletSetupData, fileStream->Size);
			delete fileStream;
			return true;
		}
		else
		{
			return false;
		}
	}
	else
	{
		return false;
	}
}
//---------------------------------------------------------------------------

void __fastcall TFirstStudy::FirstStudyDataCalculate(void)
{
	int tempCountLeft[SYSTEM_TOTAL_CAMERA_COUNT];
	int tempCountRight[SYSTEM_TOTAL_CAMERA_COUNT];
	int tempCountTop[SYSTEM_TOTAL_CAMERA_COUNT];
	int tempCountBottom[SYSTEM_TOTAL_CAMERA_COUNT];
	int printShiftValueCount[SYSTEM_TOTAL_CAMERA_COUNT][4][2];
	int baseAdjustValueCount[SYSTEM_TOTAL_CAMERA_COUNT];

	for (int m = 0; m < SYSTEM_TOTAL_CAMERA_COUNT; m++)
	{
		BoundaryLeft[m] = 0;
		BoundaryRight[m] = 0;
		BoundaryTop[m] = 0;
		BoundaryBottom[m] = 0;

		tempCountLeft[m] = 0;
		tempCountRight[m] = 0;
		tempCountTop[m] = 0;
		tempCountBottom[m] = 0;
	}

	for (int globalCameraIndex = 0; globalCameraIndex < SYSTEM_TOTAL_CAMERA_COUNT; globalCameraIndex++)
	{
		for (int m = 0; m < 480; m++)
		{
			BoundaryTop[globalCameraIndex] += FirstStudyResult.Top_Position[globalCameraIndex][m] * m;
			BoundaryBottom[globalCameraIndex] += FirstStudyResult.Bottom_Position[globalCameraIndex][m] * m;
			tempCountTop[globalCameraIndex] += FirstStudyResult.Top_Position[globalCameraIndex][m];
			tempCountBottom[globalCameraIndex] += FirstStudyResult.Bottom_Position[globalCameraIndex][m];
		}
	}

	for (int globalCameraIndex = 0; globalCameraIndex < SYSTEM_TOTAL_CAMERA_COUNT; globalCameraIndex++)
	{
		for (int m = 0; m < 640; m++)
		{
			BoundaryLeft[globalCameraIndex] += FirstStudyResult.Left_Position[globalCameraIndex][m] * m;
			BoundaryRight[globalCameraIndex] += FirstStudyResult.Right_Position[globalCameraIndex][m] * m;
			tempCountLeft[globalCameraIndex] += FirstStudyResult.Left_Position[globalCameraIndex][m];
			tempCountRight[globalCameraIndex] += FirstStudyResult.Right_Position[globalCameraIndex][m];
		}
	}

	for (int m = 0; m < SYSTEM_TOTAL_CAMERA_COUNT; m++)
	{
		if (tempCountLeft[m]) BoundaryLeft[m] /= tempCountLeft[m];
		if (tempCountRight[m]) BoundaryRight[m] /= tempCountRight[m];
		if (tempCountTop[m]) BoundaryTop[m] /= tempCountTop[m];
		if (tempCountBottom[m]) BoundaryBottom[m] /= tempCountBottom[m];
	}

	if (TabletCharacter.shape == ETC)
	{
		BoundaryTop[SD1_2D_FRONT_FACE_CAMERA_INDEX - 1] = BoundaryTop[SD1_2D_FRONT_FACE_CAMERA_INDEX - 1] - 50;
		if (BoundaryTop[SD1_2D_FRONT_FACE_CAMERA_INDEX - 1] < 10) BoundaryTop[SD1_2D_FRONT_FACE_CAMERA_INDEX - 1] = 10;

		BoundaryTop[SD1_3D_FRONT_FACE_CAMERA_INDEX - 1] = BoundaryTop[SD1_3D_FRONT_FACE_CAMERA_INDEX - 1] - 50;
		if (BoundaryTop[SD1_3D_FRONT_FACE_CAMERA_INDEX - 1] < 10) BoundaryTop[SD1_3D_FRONT_FACE_CAMERA_INDEX - 1] = 10;

		BoundaryBottom[SD2_2D_FRONT_FACE_CAMERA_INDEX - 1] = BoundaryBottom[SD2_2D_FRONT_FACE_CAMERA_INDEX - 1] + 50;
		if (BoundaryBottom[SD2_2D_FRONT_FACE_CAMERA_INDEX - 1] > 470) BoundaryBottom[SD2_2D_FRONT_FACE_CAMERA_INDEX - 1] = 470;

		BoundaryBottom[SD2_3D_FRONT_FACE_CAMERA_INDEX - 1] = BoundaryBottom[SD2_3D_FRONT_FACE_CAMERA_INDEX - 1] + 50;
		if (BoundaryBottom[SD2_3D_FRONT_FACE_CAMERA_INDEX - 1] > 470) BoundaryBottom[SD2_3D_FRONT_FACE_CAMERA_INDEX - 1] = 470;


		BoundaryLeft[SD1_2D_SIDE_FACE_P45_CAMERA_INDEX - 1] -= 30;
		BoundaryRight[SD1_2D_SIDE_FACE_P45_CAMERA_INDEX - 1] += 30;
		BoundaryLeft[SD1_2D_SIDE_FACE_00_CAMERA_INDEX - 1] -= 30;
		BoundaryRight[SD1_2D_SIDE_FACE_00_CAMERA_INDEX - 1] += 30;
		BoundaryLeft[SD1_2D_SIDE_FACE_M45_CAMERA_INDEX - 1] -= 30;
		BoundaryRight[SD1_2D_SIDE_FACE_M45_CAMERA_INDEX - 1] += 30;

		BoundaryLeft[SD1_2D_OTHER_SIDE_FACE_P45_CAMERA_INDEX - 1] -= 30;
		BoundaryRight[SD1_2D_OTHER_SIDE_FACE_P45_CAMERA_INDEX - 1] += 30;
		BoundaryLeft[SD1_2D_OTHER_SIDE_FACE_00_CAMERA_INDEX - 1] -= 30;
		BoundaryRight[SD1_2D_OTHER_SIDE_FACE_00_CAMERA_INDEX - 1] += 30;
		BoundaryLeft[SD1_2D_OTHER_SIDE_FACE_M45_CAMERA_INDEX - 1] -= 30;
		BoundaryRight[SD1_2D_OTHER_SIDE_FACE_M45_CAMERA_INDEX - 1] += 30;

		BoundaryLeft[SD2_2D_SIDE_FACE_P45_CAMERA_INDEX - 1] -= 30;
		BoundaryRight[SD2_2D_SIDE_FACE_P45_CAMERA_INDEX - 1] += 30;
		BoundaryLeft[SD2_2D_SIDE_FACE_00_CAMERA_INDEX - 1] -= 30;
		BoundaryRight[SD2_2D_SIDE_FACE_00_CAMERA_INDEX - 1] += 30;
		BoundaryLeft[SD2_2D_SIDE_FACE_M45_CAMERA_INDEX - 1] -= 30;
		BoundaryRight[SD2_2D_SIDE_FACE_M45_CAMERA_INDEX - 1] += 30;

		BoundaryLeft[SD2_2D_OTHER_SIDE_FACE_P45_CAMERA_INDEX - 1] -= 30;
		BoundaryRight[SD2_2D_OTHER_SIDE_FACE_P45_CAMERA_INDEX - 1] += 30;
		BoundaryLeft[SD2_2D_OTHER_SIDE_FACE_00_CAMERA_INDEX - 1] -= 30;
		BoundaryRight[SD2_2D_OTHER_SIDE_FACE_00_CAMERA_INDEX - 1] += 30;
		BoundaryLeft[SD2_2D_OTHER_SIDE_FACE_M45_CAMERA_INDEX - 1] -= 30;
		BoundaryRight[SD2_2D_OTHER_SIDE_FACE_M45_CAMERA_INDEX - 1] += 30;
	}

	for (int m = 0; m < SYSTEM_TOTAL_CAMERA_COUNT; m++)
	{
		BaseAdjustValue[m] = 0;
		baseAdjustValueCount[m] = 0;
	}

	for (int globalCameraIndex = 0; globalCameraIndex < SYSTEM_TOTAL_CAMERA_COUNT; globalCameraIndex++)
	{
		for (int m = 0; m < 41; m++)
		{
			switch (globalCameraIndex + 1)
			{
			case SD1_2D_SIDE_FACE_P45_CAMERA_INDEX:
			case SD1_2D_SIDE_FACE_00_CAMERA_INDEX:
			case SD1_2D_SIDE_FACE_M45_CAMERA_INDEX:
			case SD1_2D_OTHER_SIDE_FACE_P45_CAMERA_INDEX:
			case SD1_2D_OTHER_SIDE_FACE_00_CAMERA_INDEX:
			case SD1_2D_OTHER_SIDE_FACE_M45_CAMERA_INDEX:
			case SD2_2D_SIDE_FACE_P45_CAMERA_INDEX:
			case SD2_2D_SIDE_FACE_00_CAMERA_INDEX:
			case SD2_2D_SIDE_FACE_M45_CAMERA_INDEX:
			case SD2_2D_OTHER_SIDE_FACE_P45_CAMERA_INDEX:
			case SD2_2D_OTHER_SIDE_FACE_00_CAMERA_INDEX:
			case SD2_2D_OTHER_SIDE_FACE_M45_CAMERA_INDEX:
				BaseAdjustValue[globalCameraIndex] += FirstStudyResult.Shape_Yshift[globalCameraIndex][m] * m;
				baseAdjustValueCount[globalCameraIndex] += FirstStudyResult.Shape_Yshift[globalCameraIndex][m];
				break;
			}
		}
	}

	for (int m = 0; m < SYSTEM_TOTAL_CAMERA_COUNT; m++)
	{
		if (baseAdjustValueCount[m])
			BaseAdjustValue[m] /= baseAdjustValueCount[m];
	}

	for (int n = 0; n < SYSTEM_TOTAL_CAMERA_COUNT; n++)
	{
		for (int m = 0; m < 4; m++)
		{
			PrintShiftValue[n][m][0] = 0;
			printShiftValueCount[n][m][0] = 0;

			PrintShiftValue[n][m][1] = 0;
			printShiftValueCount[n][m][1] = 0;
		}
	}

	for (int m = 0; m < 41; m++)
	{
		PrintShiftValue[SD1_2D_FRONT_FACE_CAMERA_INDEX - 1][0][0] += FirstStudyResult.camera1_Print1_DiscriminationMarkPositionAdjust[m][0] * m;
		printShiftValueCount[SD1_2D_FRONT_FACE_CAMERA_INDEX - 1][0][0] += FirstStudyResult.camera1_Print1_DiscriminationMarkPositionAdjust[m][0];
		PrintShiftValue[SD1_2D_FRONT_FACE_CAMERA_INDEX - 1][1][0] += FirstStudyResult.camera1_Print2_DiscriminationMarkPositionAdjust[m][0] * m;
		printShiftValueCount[SD1_2D_FRONT_FACE_CAMERA_INDEX - 1][1][0] += FirstStudyResult.camera1_Print2_DiscriminationMarkPositionAdjust[m][0];
		PrintShiftValue[SD1_2D_FRONT_FACE_CAMERA_INDEX - 1][2][0] += FirstStudyResult.camera1_Print3_DiscriminationMarkPositionAdjust[m][0] * m;
		printShiftValueCount[SD1_2D_FRONT_FACE_CAMERA_INDEX - 1][2][0] += FirstStudyResult.camera1_Print3_DiscriminationMarkPositionAdjust[m][0];
		PrintShiftValue[SD1_2D_FRONT_FACE_CAMERA_INDEX - 1][3][0] += FirstStudyResult.camera1_Print4_DiscriminationMarkPositionAdjust[m][0] * m;
		printShiftValueCount[SD1_2D_FRONT_FACE_CAMERA_INDEX - 1][3][0] += FirstStudyResult.camera1_Print4_DiscriminationMarkPositionAdjust[m][0];

		PrintShiftValue[SD1_2D_FRONT_FACE_CAMERA_INDEX - 1][0][1] += FirstStudyResult.camera1_Print1_DiscriminationMarkPositionAdjust[m][1] * m;
		printShiftValueCount[SD1_2D_FRONT_FACE_CAMERA_INDEX - 1][0][1] += FirstStudyResult.camera1_Print1_DiscriminationMarkPositionAdjust[m][1];
		PrintShiftValue[SD1_2D_FRONT_FACE_CAMERA_INDEX - 1][1][1] += FirstStudyResult.camera1_Print2_DiscriminationMarkPositionAdjust[m][1] * m;
		printShiftValueCount[SD1_2D_FRONT_FACE_CAMERA_INDEX - 1][1][1] += FirstStudyResult.camera1_Print2_DiscriminationMarkPositionAdjust[m][1];
		PrintShiftValue[SD1_2D_FRONT_FACE_CAMERA_INDEX - 1][2][1] += FirstStudyResult.camera1_Print3_DiscriminationMarkPositionAdjust[m][1] * m;
		printShiftValueCount[SD1_2D_FRONT_FACE_CAMERA_INDEX - 1][2][1] += FirstStudyResult.camera1_Print3_DiscriminationMarkPositionAdjust[m][1];
		PrintShiftValue[SD1_2D_FRONT_FACE_CAMERA_INDEX - 1][3][1] += FirstStudyResult.camera1_Print4_DiscriminationMarkPositionAdjust[m][1] * m;
		printShiftValueCount[SD1_2D_FRONT_FACE_CAMERA_INDEX - 1][3][1] += FirstStudyResult.camera1_Print4_DiscriminationMarkPositionAdjust[m][1];


		PrintShiftValue[SD1_3D_FRONT_FACE_CAMERA_INDEX - 1][0][0] += FirstStudyResult.camera5_Print1_DiscriminationMarkPositionAdjust[m][0] * m;
		printShiftValueCount[SD1_3D_FRONT_FACE_CAMERA_INDEX - 1][0][0] += FirstStudyResult.camera5_Print1_DiscriminationMarkPositionAdjust[m][0];
		PrintShiftValue[SD1_3D_FRONT_FACE_CAMERA_INDEX - 1][1][0] += FirstStudyResult.camera5_Print2_DiscriminationMarkPositionAdjust[m][0] * m;
		printShiftValueCount[SD1_3D_FRONT_FACE_CAMERA_INDEX - 1][1][0] += FirstStudyResult.camera5_Print2_DiscriminationMarkPositionAdjust[m][0];
		PrintShiftValue[SD1_3D_FRONT_FACE_CAMERA_INDEX - 1][2][0] += FirstStudyResult.camera5_Print3_DiscriminationMarkPositionAdjust[m][0] * m;
		printShiftValueCount[SD1_3D_FRONT_FACE_CAMERA_INDEX - 1][2][0] += FirstStudyResult.camera5_Print3_DiscriminationMarkPositionAdjust[m][0];
		PrintShiftValue[SD1_3D_FRONT_FACE_CAMERA_INDEX - 1][3][0] += FirstStudyResult.camera5_Print4_DiscriminationMarkPositionAdjust[m][0] * m;
		printShiftValueCount[SD1_3D_FRONT_FACE_CAMERA_INDEX - 1][3][0] += FirstStudyResult.camera5_Print4_DiscriminationMarkPositionAdjust[m][0];

		PrintShiftValue[SD1_3D_FRONT_FACE_CAMERA_INDEX - 1][0][1] += FirstStudyResult.camera5_Print1_DiscriminationMarkPositionAdjust[m][1] * m;
		printShiftValueCount[SD1_3D_FRONT_FACE_CAMERA_INDEX - 1][0][1] += FirstStudyResult.camera5_Print1_DiscriminationMarkPositionAdjust[m][1];
		PrintShiftValue[SD1_3D_FRONT_FACE_CAMERA_INDEX - 1][1][1] += FirstStudyResult.camera5_Print2_DiscriminationMarkPositionAdjust[m][1] * m;
		printShiftValueCount[SD1_3D_FRONT_FACE_CAMERA_INDEX - 1][1][1] += FirstStudyResult.camera5_Print2_DiscriminationMarkPositionAdjust[m][1];
		PrintShiftValue[SD1_3D_FRONT_FACE_CAMERA_INDEX - 1][2][1] += FirstStudyResult.camera5_Print3_DiscriminationMarkPositionAdjust[m][1] * m;
		printShiftValueCount[SD1_3D_FRONT_FACE_CAMERA_INDEX - 1][2][1] += FirstStudyResult.camera5_Print3_DiscriminationMarkPositionAdjust[m][1];
		PrintShiftValue[SD1_3D_FRONT_FACE_CAMERA_INDEX - 1][3][1] += FirstStudyResult.camera5_Print4_DiscriminationMarkPositionAdjust[m][1] * m;
		printShiftValueCount[SD1_3D_FRONT_FACE_CAMERA_INDEX - 1][3][1] += FirstStudyResult.camera5_Print4_DiscriminationMarkPositionAdjust[m][1];


		PrintShiftValue[SD2_2D_FRONT_FACE_CAMERA_INDEX - 1][0][0] += FirstStudyResult.camera9_Print1_DiscriminationMarkPositionAdjust[m][0] * m;
		printShiftValueCount[SD2_2D_FRONT_FACE_CAMERA_INDEX - 1][0][0] += FirstStudyResult.camera9_Print1_DiscriminationMarkPositionAdjust[m][0];
		PrintShiftValue[SD2_2D_FRONT_FACE_CAMERA_INDEX - 1][1][0] += FirstStudyResult.camera9_Print2_DiscriminationMarkPositionAdjust[m][0] * m;
		printShiftValueCount[SD2_2D_FRONT_FACE_CAMERA_INDEX - 1][1][0] += FirstStudyResult.camera9_Print2_DiscriminationMarkPositionAdjust[m][0];
		PrintShiftValue[SD2_2D_FRONT_FACE_CAMERA_INDEX - 1][2][0] += FirstStudyResult.camera9_Print3_DiscriminationMarkPositionAdjust[m][0] * m;
		printShiftValueCount[SD2_2D_FRONT_FACE_CAMERA_INDEX - 1][2][0] += FirstStudyResult.camera9_Print3_DiscriminationMarkPositionAdjust[m][0];
		PrintShiftValue[SD2_2D_FRONT_FACE_CAMERA_INDEX - 1][3][0] += FirstStudyResult.camera9_Print4_DiscriminationMarkPositionAdjust[m][0] * m;
		printShiftValueCount[SD2_2D_FRONT_FACE_CAMERA_INDEX - 1][3][0] += FirstStudyResult.camera9_Print4_DiscriminationMarkPositionAdjust[m][0];

		PrintShiftValue[SD2_2D_FRONT_FACE_CAMERA_INDEX - 1][0][1] += FirstStudyResult.camera9_Print1_DiscriminationMarkPositionAdjust[m][1] * m;
		printShiftValueCount[SD2_2D_FRONT_FACE_CAMERA_INDEX - 1][0][1] += FirstStudyResult.camera9_Print1_DiscriminationMarkPositionAdjust[m][1];
		PrintShiftValue[SD2_2D_FRONT_FACE_CAMERA_INDEX - 1][1][1] += FirstStudyResult.camera9_Print2_DiscriminationMarkPositionAdjust[m][1] * m;
		printShiftValueCount[SD2_2D_FRONT_FACE_CAMERA_INDEX - 1][1][1] += FirstStudyResult.camera9_Print2_DiscriminationMarkPositionAdjust[m][1];
		PrintShiftValue[SD2_2D_FRONT_FACE_CAMERA_INDEX - 1][2][1] += FirstStudyResult.camera9_Print3_DiscriminationMarkPositionAdjust[m][1] * m;
		printShiftValueCount[SD2_2D_FRONT_FACE_CAMERA_INDEX - 1][2][1] += FirstStudyResult.camera9_Print3_DiscriminationMarkPositionAdjust[m][1];
		PrintShiftValue[SD2_2D_FRONT_FACE_CAMERA_INDEX - 1][3][1] += FirstStudyResult.camera9_Print4_DiscriminationMarkPositionAdjust[m][1] * m;
		printShiftValueCount[SD2_2D_FRONT_FACE_CAMERA_INDEX - 1][3][1] += FirstStudyResult.camera9_Print4_DiscriminationMarkPositionAdjust[m][1];


		PrintShiftValue[SD2_3D_FRONT_FACE_CAMERA_INDEX - 1][0][0] += FirstStudyResult.camera13_Print1_DiscriminationMarkPositionAdjust[m][0] * m;
		printShiftValueCount[SD2_3D_FRONT_FACE_CAMERA_INDEX - 1][0][0] += FirstStudyResult.camera13_Print1_DiscriminationMarkPositionAdjust[m][0];
		PrintShiftValue[SD2_3D_FRONT_FACE_CAMERA_INDEX - 1][1][0] += FirstStudyResult.camera13_Print2_DiscriminationMarkPositionAdjust[m][0] * m;
		printShiftValueCount[SD2_3D_FRONT_FACE_CAMERA_INDEX - 1][1][0] += FirstStudyResult.camera13_Print2_DiscriminationMarkPositionAdjust[m][0];
		PrintShiftValue[SD2_3D_FRONT_FACE_CAMERA_INDEX - 1][2][0] += FirstStudyResult.camera13_Print3_DiscriminationMarkPositionAdjust[m][0] * m;
		printShiftValueCount[SD2_3D_FRONT_FACE_CAMERA_INDEX - 1][2][0] += FirstStudyResult.camera13_Print3_DiscriminationMarkPositionAdjust[m][0];
		PrintShiftValue[SD2_3D_FRONT_FACE_CAMERA_INDEX - 1][3][0] += FirstStudyResult.camera13_Print4_DiscriminationMarkPositionAdjust[m][0] * m;
		printShiftValueCount[SD2_3D_FRONT_FACE_CAMERA_INDEX - 1][3][0] += FirstStudyResult.camera13_Print4_DiscriminationMarkPositionAdjust[m][0];

		PrintShiftValue[SD2_3D_FRONT_FACE_CAMERA_INDEX - 1][0][1] += FirstStudyResult.camera13_Print1_DiscriminationMarkPositionAdjust[m][1] * m;
		printShiftValueCount[SD2_3D_FRONT_FACE_CAMERA_INDEX - 1][0][1] += FirstStudyResult.camera13_Print1_DiscriminationMarkPositionAdjust[m][1];
		PrintShiftValue[SD2_3D_FRONT_FACE_CAMERA_INDEX - 1][1][1] += FirstStudyResult.camera13_Print2_DiscriminationMarkPositionAdjust[m][1] * m;
		printShiftValueCount[SD2_3D_FRONT_FACE_CAMERA_INDEX - 1][1][1] += FirstStudyResult.camera13_Print2_DiscriminationMarkPositionAdjust[m][1];
		PrintShiftValue[SD2_3D_FRONT_FACE_CAMERA_INDEX - 1][2][1] += FirstStudyResult.camera13_Print3_DiscriminationMarkPositionAdjust[m][1] * m;
		printShiftValueCount[SD2_3D_FRONT_FACE_CAMERA_INDEX - 1][2][1] += FirstStudyResult.camera13_Print3_DiscriminationMarkPositionAdjust[m][1];
		PrintShiftValue[SD2_3D_FRONT_FACE_CAMERA_INDEX - 1][3][1] += FirstStudyResult.camera13_Print4_DiscriminationMarkPositionAdjust[m][1] * m;
		printShiftValueCount[SD2_3D_FRONT_FACE_CAMERA_INDEX - 1][3][1] += FirstStudyResult.camera13_Print4_DiscriminationMarkPositionAdjust[m][1];
	}

	for (int n = 0; n < SYSTEM_TOTAL_CAMERA_COUNT; n++)
	{
		for (int m = 0; m < 4; m++)
		{
			if (printShiftValueCount[n][m][0])
			{
				PrintShiftValue[n][m][0] /= printShiftValueCount[n][m][0];
			}

			if (printShiftValueCount[n][m][1])
			{
				PrintShiftValue[n][m][1] /= printShiftValueCount[n][m][1];
			}
		}
	}


	//////////////////////////////result Display///////////////////////////////////////////////////////////
	TTntImage *tempImage;
	for (int globalCameraIndex = 0; globalCameraIndex < SYSTEM_TOTAL_CAMERA_COUNT; globalCameraIndex++)
	{
		tempImage = ((TTntImage *)FindComponent("BoundarySetResultImage" + IntToStr(globalCameraIndex + 1)));

		if (tempImage)
		{
			tempImage->Canvas->Font->Color = clWhite;
			tempImage->Canvas->Pen->Color = clRed;
			tempImage->Canvas->Pen->Width = 2;
			tempImage->Canvas->MoveTo(BoundaryLeft[globalCameraIndex] / 2, 0);
			tempImage->Canvas->LineTo(BoundaryLeft[globalCameraIndex] / 2, tempImage->Height);
			tempImage->Canvas->TextOutW(BoundaryLeft[globalCameraIndex] / 2, tempImage->Height / 2, "LEFT: " + IntToStr(BoundaryLeft[globalCameraIndex]));
			tempImage->Canvas->MoveTo(BoundaryRight[globalCameraIndex] / 2, 0);
			tempImage->Canvas->LineTo(BoundaryRight[globalCameraIndex] / 2, tempImage->Height);
			tempImage->Canvas->TextOutW(BoundaryRight[globalCameraIndex] / 2, tempImage->Height / 2, "RIGHT: " + IntToStr(BoundaryRight[globalCameraIndex]));

			switch (globalCameraIndex + 1)
			{
			case SD1_2D_SIDE_FACE_P45_CAMERA_INDEX:
			case SD1_2D_SIDE_FACE_00_CAMERA_INDEX:
			case SD1_2D_SIDE_FACE_M45_CAMERA_INDEX:
			case SD1_2D_OTHER_SIDE_FACE_P45_CAMERA_INDEX:
			case SD1_2D_OTHER_SIDE_FACE_00_CAMERA_INDEX:
			case SD1_2D_OTHER_SIDE_FACE_M45_CAMERA_INDEX:
			case SD2_2D_SIDE_FACE_P45_CAMERA_INDEX:
			case SD2_2D_SIDE_FACE_00_CAMERA_INDEX:
			case SD2_2D_SIDE_FACE_M45_CAMERA_INDEX:
			case SD2_2D_OTHER_SIDE_FACE_P45_CAMERA_INDEX:
			case SD2_2D_OTHER_SIDE_FACE_00_CAMERA_INDEX:
			case SD2_2D_OTHER_SIDE_FACE_M45_CAMERA_INDEX:

				tempImage->Canvas->Pen->Color = clWhite;
				tempImage->Canvas->Pen->Width = 3;
				tempImage->Canvas->MoveTo(BaseAdjustValue[globalCameraIndex] * 5, 0);
				tempImage->Canvas->LineTo(BaseAdjustValue[globalCameraIndex] * 5, tempImage->Height);
				tempImage->Canvas->Font->Color = clWhite;
				tempImage->Canvas->TextOutW(tempImage->Width / 2, tempImage->Height / 2, "SHIFT: " + IntToStr(BaseAdjustValue[globalCameraIndex] - 20));

				break;
			}
		}
	}

	for (int globalCameraIndex = 0; globalCameraIndex < SYSTEM_TOTAL_CAMERA_COUNT; globalCameraIndex++)
	{
		switch (globalCameraIndex + 1)
		{
		case SD1_2D_FRONT_FACE_CAMERA_INDEX:
		case SD1_3D_FRONT_FACE_CAMERA_INDEX:
		case SD2_2D_FRONT_FACE_CAMERA_INDEX:
		case SD2_3D_FRONT_FACE_CAMERA_INDEX:

			tempImage = ((TTntImage *)FindComponent("subBoundarySetResultImage" + IntToStr(globalCameraIndex + 1)));

			if (tempImage)
			{
				tempImage->Canvas->Font->Color = clWhite;
				tempImage->Canvas->Pen->Color = clRed;
				tempImage->Canvas->Pen->Width = 2;
				tempImage->Canvas->MoveTo(BoundaryTop[globalCameraIndex] / 2, 0);
				tempImage->Canvas->LineTo(BoundaryTop[globalCameraIndex] / 2, tempImage->Height);
				tempImage->Canvas->TextOutW(BoundaryTop[globalCameraIndex] / 2, tempImage->Height / 2, "TOP: " + IntToStr(BoundaryTop[globalCameraIndex]));
				tempImage->Canvas->MoveTo(BoundaryBottom[globalCameraIndex] / 2, 0);
				tempImage->Canvas->LineTo(BoundaryBottom[globalCameraIndex] / 2, tempImage->Height);
				tempImage->Canvas->TextOutW(BoundaryBottom[globalCameraIndex] / 2, tempImage->Height / 2, "BOTTOM: " + IntToStr(BoundaryBottom[globalCameraIndex]));
			}

			break;
		}
	}
}
//---------------------------------------------------------------------------
void __fastcall TFirstStudy::ResultDataAccumulate(int cameraIndex, int option, int imageCount)
{
	int left, right, top, bottom;
	int sideShapeShiftY;
	int printShiftX, printShiftY;

	if (cameraIndex == SD1_2D_FRONT_FACE_CAMERA_INDEX || cameraIndex == SD2_2D_FRONT_FACE_CAMERA_INDEX)
	{
		if (TabletCharacter.shape == ETC && TabletCharacter.symmetric_line_count == 2)
		{
			left = TabletMatchingResult.AdjustCenterXInImage - TabletCharacter.length / 2 - Front_XSPACE;
			right = TabletMatchingResult.AdjustCenterXInImage + TabletCharacter.length / 2 + Front_XSPACE;
			top = TabletMatchingResult.AdjustCenterYInImage - TabletCharacter.width / 2 - YSPACE;
			bottom = TabletMatchingResult.AdjustCenterYInImage + TabletCharacter.length / 2 + YSPACE + 10;
		}
		else
		{
			left = TabletMatchingResult.AdjustCenterXInImage - TabletCharacter.length / 2 - Front_XSPACE;
			right = TabletMatchingResult.AdjustCenterXInImage + TabletCharacter.length / 2 + Front_XSPACE;
			top = TabletMatchingResult.AdjustCenterYInImage - TabletCharacter.width / 2 - YSPACE;
			bottom = TabletMatchingResult.AdjustCenterYInImage + TabletCharacter.width / 2 + YSPACE;
		}

		if (left < 0) left = 10;
		if (right >= MAX_IMAGE_WIDTH) right = MAX_IMAGE_WIDTH - 10;
		if (top < 0) top = 10;
		if (bottom >= MAX_IMAGE_HEIGHT) bottom = MAX_IMAGE_HEIGHT - 10;

		FirstStudyResult.Left_Position[cameraIndex - 1][left]++;
		FirstStudyResult.Right_Position[cameraIndex - 1][right]++;
		FirstStudyResult.Top_Position[cameraIndex - 1][top]++;
		FirstStudyResult.Bottom_Position[cameraIndex - 1][bottom]++;

		printShiftX = PrintMatchingResult.PrintShiftX;
		printShiftY = PrintMatchingResult.PrintShiftY;
		if (printShiftX >= 20) printShiftX = 20;
		if (printShiftX <= -20) printShiftX = -20;
		if (printShiftY >= 20) printShiftY = 20;
		if (printShiftY <= -20) printShiftY = -20;

		if (cameraIndex == SD1_2D_FRONT_FACE_CAMERA_INDEX)
		{
			if (PrintMatchingResult.dataNumberWithMaxValue == 0)
			{
				FirstStudyResult.camera1_Print1_DiscriminationMarkPositionAdjust[20 + printShiftX][0]++;
				FirstStudyResult.camera1_Print1_DiscriminationMarkPositionAdjust[20 + printShiftY][1]++;
			}
			else if (PrintMatchingResult.dataNumberWithMaxValue == 1)
			{
				FirstStudyResult.camera1_Print2_DiscriminationMarkPositionAdjust[20 + printShiftX][0]++;
				FirstStudyResult.camera1_Print2_DiscriminationMarkPositionAdjust[20 + printShiftY][1]++;
			}
			else if (PrintMatchingResult.dataNumberWithMaxValue == 2)
			{
				FirstStudyResult.camera1_Print3_DiscriminationMarkPositionAdjust[20 + printShiftX][0]++;
				FirstStudyResult.camera1_Print3_DiscriminationMarkPositionAdjust[20 + printShiftY][1]++;
			}
			else if (PrintMatchingResult.dataNumberWithMaxValue == 3)
			{
				FirstStudyResult.camera1_Print4_DiscriminationMarkPositionAdjust[20 + printShiftX][0]++;
				FirstStudyResult.camera1_Print4_DiscriminationMarkPositionAdjust[20 + printShiftY][1]++;
			}
		}
		else
		{
			if (PrintMatchingResult.dataNumberWithMaxValue == 0)
			{
				FirstStudyResult.camera9_Print1_DiscriminationMarkPositionAdjust[20 + printShiftX][0]++;
				FirstStudyResult.camera9_Print1_DiscriminationMarkPositionAdjust[20 + printShiftY][1]++;
			}
			else if (PrintMatchingResult.dataNumberWithMaxValue == 1)
			{
				FirstStudyResult.camera9_Print2_DiscriminationMarkPositionAdjust[20 + printShiftX][0]++;
				FirstStudyResult.camera9_Print2_DiscriminationMarkPositionAdjust[20 + printShiftY][1]++;
			}
			else if (PrintMatchingResult.dataNumberWithMaxValue == 2)
			{
				FirstStudyResult.camera9_Print3_DiscriminationMarkPositionAdjust[20 + printShiftX][0]++;
				FirstStudyResult.camera9_Print3_DiscriminationMarkPositionAdjust[20 + printShiftY][1]++;
			}
			else if (PrintMatchingResult.dataNumberWithMaxValue == 3)
			{
				FirstStudyResult.camera9_Print4_DiscriminationMarkPositionAdjust[20 + printShiftX][0]++;
				FirstStudyResult.camera9_Print4_DiscriminationMarkPositionAdjust[20 + printShiftY][1]++;
			}
		}
	}
	else if ((cameraIndex == SD1_3D_FRONT_FACE_CAMERA_INDEX || cameraIndex == SD2_3D_FRONT_FACE_CAMERA_INDEX) && option == THREED)
	{
		if (cameraIndex == SD1_3D_FRONT_FACE_CAMERA_INDEX)
		{
			if (TabletCharacter.shape == ETC && TabletCharacter.symmetric_line_count == 2)
			{
				left = TabletMatchingResult.AdjustCenterXInImage - TabletCharacter.length / 2 - Front_XSPACE;
				right = TabletMatchingResult.AdjustCenterXInImage + TabletCharacter.length / 2 + Front_XSPACE;
				top = TabletMatchingResult.AdjustCenterYInImage - TabletCharacter.width / 2 - YSPACE;
				bottom = TabletMatchingResult.AdjustCenterYInImage + TabletCharacter.length / 2 + YSPACE + 10;
			}
			else
			{
				left = TabletMatchingResult.AdjustCenterXInImage - TabletCharacter.length / 2 - Front_XSPACE;
				right = TabletMatchingResult.AdjustCenterXInImage + TabletCharacter.length / 2 + Front_XSPACE;
				top = TabletMatchingResult.AdjustCenterYInImage - TabletCharacter.width / 2 - YSPACE;
				bottom = TabletMatchingResult.AdjustCenterYInImage + TabletCharacter.width / 2 + YSPACE;
			}
		}
		else
		{
			if (TabletCharacter.shape == ETC && TabletCharacter.symmetric_line_count == 2)
			{
				left = TabletMatchingResult.AdjustCenterXInImage - TabletCharacter.length / 2 - Front_XSPACE;
				right = TabletMatchingResult.AdjustCenterXInImage + TabletCharacter.length / 2 + Front_XSPACE;
				top = TabletMatchingResult.AdjustCenterYInImage - TabletCharacter.length / 2 - YSPACE - 10;
				bottom = TabletMatchingResult.AdjustCenterYInImage + TabletCharacter.width / 2 + YSPACE;
			}
			else
			{
				left = TabletMatchingResult.AdjustCenterXInImage - TabletCharacter.length / 2 - Front_XSPACE;
				right = TabletMatchingResult.AdjustCenterXInImage + TabletCharacter.length / 2 + Front_XSPACE;
				top = TabletMatchingResult.AdjustCenterYInImage - TabletCharacter.width / 2 - YSPACE;
				bottom = TabletMatchingResult.AdjustCenterYInImage + TabletCharacter.width / 2 + YSPACE;
			}
		}


		if (left < 0) left = 10;
		if (right >= MAX_IMAGE_WIDTH) right = MAX_IMAGE_WIDTH - 10;
		if (top < 0) top = 10;
		if (bottom >= MAX_IMAGE_HEIGHT) bottom = MAX_IMAGE_HEIGHT - 10;

		FirstStudyResult.Left_Position[cameraIndex - 1][left]++;
		FirstStudyResult.Right_Position[cameraIndex - 1][right]++;
		FirstStudyResult.Top_Position[cameraIndex - 1][top]++;
		FirstStudyResult.Bottom_Position[cameraIndex - 1][bottom]++;

		printShiftX = PrintMatchingResult.PrintShiftX;
		printShiftY = PrintMatchingResult.PrintShiftY;
		if (printShiftX >= 20) printShiftX = 20;
		if (printShiftX <= -20) printShiftX = -20;
		if (printShiftY >= 20) printShiftY = 20;
		if (printShiftY <= -20) printShiftY = -20;

		if (cameraIndex == SD1_3D_FRONT_FACE_CAMERA_INDEX)
		{
			if (PrintMatchingResult.dataNumberWithMaxValue == 0)
			{
				FirstStudyResult.camera5_Print1_DiscriminationMarkPositionAdjust[20 + printShiftX][0]++;
				FirstStudyResult.camera5_Print1_DiscriminationMarkPositionAdjust[20 + printShiftY][1]++;
			}
			else if (PrintMatchingResult.dataNumberWithMaxValue == 1)
			{
				FirstStudyResult.camera5_Print2_DiscriminationMarkPositionAdjust[20 + printShiftX][0]++;
				FirstStudyResult.camera5_Print2_DiscriminationMarkPositionAdjust[20 + printShiftY][1]++;
			}
			else if (PrintMatchingResult.dataNumberWithMaxValue == 2)
			{
				FirstStudyResult.camera5_Print3_DiscriminationMarkPositionAdjust[20 + printShiftX][0]++;
				FirstStudyResult.camera5_Print3_DiscriminationMarkPositionAdjust[20 + printShiftY][1]++;
			}
			else if (PrintMatchingResult.dataNumberWithMaxValue == 3)
			{
				FirstStudyResult.camera5_Print4_DiscriminationMarkPositionAdjust[20 + printShiftX][0]++;
				FirstStudyResult.camera5_Print4_DiscriminationMarkPositionAdjust[20 + printShiftY][1]++;
			}
		}
		else
		{
			if (PrintMatchingResult.dataNumberWithMaxValue == 0)
			{
				FirstStudyResult.camera13_Print1_DiscriminationMarkPositionAdjust[20 + printShiftX][0]++;
				FirstStudyResult.camera13_Print1_DiscriminationMarkPositionAdjust[20 + printShiftY][1]++;
			}
			else if (PrintMatchingResult.dataNumberWithMaxValue == 1)
			{
				FirstStudyResult.camera13_Print2_DiscriminationMarkPositionAdjust[20 + printShiftX][0]++;
				FirstStudyResult.camera13_Print2_DiscriminationMarkPositionAdjust[20 + printShiftY][1]++;
			}
			else if (PrintMatchingResult.dataNumberWithMaxValue == 2)
			{
				FirstStudyResult.camera13_Print3_DiscriminationMarkPositionAdjust[20 + printShiftX][0]++;
				FirstStudyResult.camera13_Print3_DiscriminationMarkPositionAdjust[20 + printShiftY][1]++;
			}
			else if (PrintMatchingResult.dataNumberWithMaxValue == 3)
			{
				FirstStudyResult.camera13_Print4_DiscriminationMarkPositionAdjust[20 + printShiftX][0]++;
				FirstStudyResult.camera13_Print4_DiscriminationMarkPositionAdjust[20 + printShiftY][1]++;
			}
		}

		Graphics::TBitmap *img1;
		img1 = new Graphics::TBitmap();
		img1->Width = 640;
		img1->Height = 480;
		img1->PixelFormat = pf24bit;
		int tempLabel;
		Byte *ptr;

		for (int y = 0; y < ImageHeight; y++)
		{
			ptr = (byte*)img1->ScanLine[y];
			for (int x = 0; x < ImageWidth; x++)
			{
				tempLabel = TempImage[MAX_IMAGE_WIDTH*y + x];
				if (tempLabel)
				{
					ptr[3 * x] = tempLabel * 123 % 255;
					ptr[3 * x + 1] = tempLabel * 64 % 255;
					ptr[3 * x + 2] = tempLabel * 31 % 255;
				}
				else
				{
					ptr[3 * x] = 255;
					ptr[3 * x + 1] = 255;
					ptr[3 * x + 2] = 255;
				}
			}
		}
		((TTntImage *)FindComponent("Image" + IntToStr(56)))->Picture->Bitmap->Assign(img1);
		((TTntImage *)FindComponent("Image" + IntToStr(56)))->Repaint();

		if (PrintMatchingResult.dataNumberWithMaxValue == 0)
		{
			for (int y = 0; y < ImageHeight; y++)
			{
				for (int x = 0; x < ImageWidth; x++)
				{
					tempLabel = TempImage[MAX_IMAGE_WIDTH*y + x];
					if (tempLabel <= THREED_PRINT_MAX_LABEL_COUNT && tempLabel > 0)
						AccumualteImage1[MAX_IMAGE_WIDTH*y + x][tempLabel - 1]++;
				}
			}
		}
		else if (PrintMatchingResult.dataNumberWithMaxValue == 1)
		{
			for (int y = 0; y < ImageHeight; y++)
			{
				for (int x = 0; x < ImageWidth; x++)
				{
					tempLabel = TempImage[MAX_IMAGE_WIDTH*y + x];
					if (tempLabel <= THREED_PRINT_MAX_LABEL_COUNT && tempLabel > 0)
						AccumualteImage1[MAX_IMAGE_WIDTH*(ImageHeight - y) + ImageWidth - x][tempLabel - 1]++;
				}
			}
		}
		else if (PrintMatchingResult.dataNumberWithMaxValue == 2)
		{
			for (int y = 0; y < ImageHeight; y++)
			{
				for (int x = 0; x < ImageWidth; x++)
				{
					tempLabel = TempImage[MAX_IMAGE_WIDTH*y + x];
					if (tempLabel <= THREED_PRINT_MAX_LABEL_COUNT && tempLabel > 0)
						AccumualteImage2[MAX_IMAGE_WIDTH*y + x][tempLabel - 1]++;

				}
			}
		}
		else if (PrintMatchingResult.dataNumberWithMaxValue == 3)
		{
			for (int y = 0; y < ImageHeight; y++)
			{
				for (int x = 0; x < ImageWidth; x++)
				{
					tempLabel = TempImage[MAX_IMAGE_WIDTH*y + x];
					if (tempLabel <= THREED_PRINT_MAX_LABEL_COUNT && tempLabel > 0)
						AccumualteImage2[MAX_IMAGE_WIDTH*(ImageHeight - y) + ImageWidth - x][tempLabel - 1]++;
				}
			}
		}

		for (int y = 0; y < ImageHeight; y++)
		{
			ptr = (byte*)img1->ScanLine[y];
			for (int x = 0; x < ImageWidth; x++)
			{
				ptr[3 * x] = 0;
				ptr[3 * x + 1] = 0;
				ptr[3 * x + 2] = 0;
			}
		}

		int tempImageCount;
		int diskNumber;

		if (cameraIndex == SD1_3D_FRONT_FACE_CAMERA_INDEX)
		{
			if (PrintMatchingResult.dataNumberWithMaxValue == 0 || PrintMatchingResult.dataNumberWithMaxValue == 1)
			{
				Disk1Print1ImageCount++;
				tempImageCount = Disk1Print1ImageCount;
			}
			else if (PrintMatchingResult.dataNumberWithMaxValue == 2 || PrintMatchingResult.dataNumberWithMaxValue == 3)
			{
				Disk1Print2ImageCount++;
				tempImageCount = Disk1Print2ImageCount;
			}

			diskNumber = 0;
		}
		else
		{
			if (PrintMatchingResult.dataNumberWithMaxValue == 0 || PrintMatchingResult.dataNumberWithMaxValue == 1)
			{
				Disk2Print1ImageCount++;
				tempImageCount = Disk2Print1ImageCount;
			}
			else if (PrintMatchingResult.dataNumberWithMaxValue == 2 || PrintMatchingResult.dataNumberWithMaxValue == 3)
			{
				Disk2Print2ImageCount++;
				tempImageCount = Disk2Print2ImageCount;
			}

			diskNumber = 1;
		}

		int tempX, tempY;
		int printNumber;

		if (PrintMatchingResult.dataNumberWithMaxValue == 0 || PrintMatchingResult.dataNumberWithMaxValue == 1)
			printNumber = 0;
		else
			printNumber = 1;

		if (PrintMatchingResult.dataNumberWithMaxValue == 0 || PrintMatchingResult.dataNumberWithMaxValue == 1)
		{
			for (int y = 0; y < ImageHeight; y++)
			{
				ptr = (byte*)img1->ScanLine[y];
				for (int x = 0; x < ImageWidth; x++)
				{
					for (int n = 0; n < THREED_PRINT_MAX_LABEL_COUNT; n++)
					{
						if (tempImageCount)
						{
							ptr[3 * x] = 0;
							ptr[3 * x + 1] = 0;
							ptr[3 * x + 2] = 255 * AccumualteImage1[MAX_IMAGE_WIDTH*y + x][n] / tempImageCount;
						}
					}
				}
			}

			for (int n = 0; n < Tablet3DSetupData.printLabelCount[diskNumber][printNumber]; n++)
			{
				for (int m = 0; m < Tablet3DSetupData.printLabelDataCnt[diskNumber][printNumber][n]; m++)
				{
					tempX = Tablet3DSetupData.printLabelData[diskNumber][printNumber][n][m][0];
					tempY = Tablet3DSetupData.printLabelData[diskNumber][printNumber][n][m][1];
					for (int i = tempY - 1; i <= tempY + 1; i++)
					{
						for (int j = tempX - 1; j <= tempX + 1; j++)
						{
							ptr = (byte*)img1->ScanLine[i];
							ptr[3 * j] = 0;
							ptr[3 * j + 1] = 255;
							ptr[3 * j + 2] = 255;
						}
					}
				}
			}
			((TTntImage *)FindComponent("Image" + IntToStr(57)))->Picture->Bitmap->Assign(img1);
			((TTntImage *)FindComponent("Image" + IntToStr(57)))->Repaint();
		}
		else
		{
			for (int y = 0; y < ImageHeight; y++)
			{
				ptr = (byte*)img1->ScanLine[y];
				for (int x = 0; x < ImageWidth; x++)
				{
					for (int n = 0; n < THREED_PRINT_MAX_LABEL_COUNT; n++)
					{
						if (tempImageCount)
						{
							ptr[3 * x] = 0;
							ptr[3 * x + 1] = 0;
							ptr[3 * x + 2] = 255 * AccumualteImage2[MAX_IMAGE_WIDTH*y + x][n] / tempImageCount;
						}
					}
				}
			}
			for (int n = 0; n < Tablet3DSetupData.printLabelCount[diskNumber][printNumber]; n++)
			{
				for (int m = 0; m < Tablet3DSetupData.printLabelDataCnt[diskNumber][printNumber][n]; m++)
				{
					tempX = Tablet3DSetupData.printLabelData[diskNumber][printNumber][n][m][0];
					tempY = Tablet3DSetupData.printLabelData[diskNumber][printNumber][n][m][1];
					for (int i = tempY - 1; i <= tempY + 1; i++)
					{
						for (int j = tempX - 1; j <= tempX + 1; j++)
						{
							ptr = (byte*)img1->ScanLine[i];
							ptr[3 * j] = 0;
							ptr[3 * j + 1] = 255;
							ptr[3 * j + 2] = 255;
						}
					}
				}
			}
			((TTntImage *)FindComponent("Image" + IntToStr(58)))->Picture->Bitmap->Assign(img1);
			((TTntImage *)FindComponent("Image" + IntToStr(58)))->Repaint();
		}

		delete(img1);
	}
}
//---------------------------------------------------------------------------
void __fastcall TFirstStudy::ProgressDisplay(int cameraIndex, int imageCount, int maxStudyCount)
{
  TTntProgressBar *tempProgressbar = ((TTntProgressBar *)FindComponent("StudyProcessingBar"+IntToStr(cameraIndex)));
  TTntLabel *tempLabel = ((TTntLabel *)FindComponent("StudyProcessingLabel"+IntToStr(cameraIndex)));

  if(tempProgressbar)
  {
    tempProgressbar->Max = maxStudyCount;
    tempProgressbar->Position = maxStudyCount*imageCount/maxStudyCount;
  }

  if(tempLabel)
  {
    if(imageCount == maxStudyCount)
    {
      tempLabel->Font->Color =  clWhite;
      tempLabel->Font->Size = 9;
      tempLabel->Caption = FIRSTSTUDYFORM_TEXT_CAPTION_12;
    }
    else
    {
      tempLabel->Font->Color =  clBlue;
      tempLabel->Font->Size = 9;
      tempLabel->Caption = FIRSTSTUDYFORM_TEXT_CAPTION_13;
    }
  }
}
//---------------------------------------------------------------------------
void __fastcall TFirstStudy::ProcessingResultDisplay(int cameraIndex, int option)
{
	if (cameraIndex != SD1_3D_FRONT_FACE_CAMERA_INDEX && cameraIndex != SD2_3D_FRONT_FACE_CAMERA_INDEX)
	{
    Graphics::TBitmap *img1;
    img1 = new Graphics::TBitmap();
    img1->Width = MAX_IMAGE_WIDTH;
    img1->Height = MAX_IMAGE_HEIGHT;
    img1->PixelFormat = pf24bit;

    int x, y;
    int tempAddress;
    Byte *ptr;

    for(y = 0; y < MAX_IMAGE_HEIGHT; y++)
    {
      ptr = (Byte*) img1->ScanLine[y];
      for(x = 0; x < MAX_IMAGE_WIDTH ; x++)
      {
        tempAddress = MAX_IMAGE_WIDTH * y + x;

        ptr[3*x + 0] = ColorSourceImage[tempAddress * 3 + 0];
        ptr[3*x + 1] = ColorSourceImage[tempAddress * 3 + 1];
        ptr[3*x + 2] = ColorSourceImage[tempAddress * 3 + 2];
      }
    }

    Image1->Picture->Bitmap->Assign(img1);
    Image1->Canvas->Pen->Width = 2;
    Image1->Canvas->Pen->Color = clBlue;
    Image1->Canvas->Brush->Style = bsClear;
    Image1->Canvas->Rectangle(TabletSetupData.ImageCutStartX[cameraIndex - 1], TabletSetupData.ImageCutStartY[cameraIndex - 1], TabletSetupData.ImageCutEndX[cameraIndex - 1], TabletSetupData.ImageCutEndY[cameraIndex - 1]);
    Image1->Refresh();

    delete img1;   
  }
}
//---------------------------------------------------------------------------
void __fastcall TFirstStudy::BitBtn1Click(TObject *Sender)
{
	AnsiString stringCamIndex2D, stringCamIndex3D;

	AddCSVActionLog(ECSV_ACTION_STUDY_START, UserInfo.Name, ProductData.ProductName, NULL, 0);

	BitBtn1->Visible = false;
	BitBtn2->Visible = false;

	WaitingForm->SetMessage(MAINFORM_MSG_13);
	WaitingForm->Show();
	Application->ProcessMessages();

	if (!ReadSetupData(&TabletSetupData))
	{
		ShowMessageW(FIRSTSTUDYFORM_MSG_01);
	}

	if (!Read3DSetupData(&Tablet3DSetupData))
	{
		ShowMessageW(FIRSTSTUDYFORM_MSG_01);
	}

	CPBCommonVariableInitial();

	MakeTabletCharacterData(&ProductData, &TabletCharacter, &MachineParams);
	MakeTabletSetupData(&TabletCharacter);

	SideFaceSetUpDataTransForm_For_PCSIM(tempSideData);

	WaitingForm->Hide();

	PrintPixelCntCam1 = 0;
	PrintPixelCntCam9 = 0;
	addCount1 = 0;
	addCount2 = 0;

	Acc_ProtoEngraveDistinguishV_Cam1 = 0;
	Acc_ProtoEngraveDistinguishV_Cam9 = 0;
	EngraveMatchingCount1 = 0;
	EngraveMatchingCount2 = 0;

	memset(AccInspectionAreaStX, 0, sizeof(int) * SYSTEM_TOTAL_CAMERA_COUNT);
	memset(AccInspectionAreaEdX, 0, sizeof(int) * SYSTEM_TOTAL_CAMERA_COUNT);
	memset(InspectionAreaMinY, 0, sizeof(int) * SYSTEM_TOTAL_CAMERA_COUNT);
	memset(InspectionAreaMaxY, 0, sizeof(int) * SYSTEM_TOTAL_CAMERA_COUNT);

  for (int globalCameraIndex = 0; globalCameraIndex < SYSTEM_TOTAL_CAMERA_COUNT; globalCameraIndex++)
  {
    StudyFailInfo[globalCameraIndex] = false;
  }

	Setup3DNeeded = false;
	for (int globalCameraIndex = 0; globalCameraIndex < SYSTEM_TOTAL_CAMERA_COUNT; globalCameraIndex++)
	{
		if (CameraMapInfo[globalCameraIndex].CameraInspectPosition == CAMERA_POSITION_3D)
		{
			Setup3DNeeded = true;
			break;
		}
	}

	Panel1->Visible = true;
	GroupBox12->Visible = false;
	GroupBox11->Visible = false;

	for (int globalCameraIndex = 1; globalCameraIndex <= SYSTEM_TOTAL_CAMERA_COUNT; globalCameraIndex++)
	{
		TTntProgressBar *tempProgressbar = ((TTntProgressBar *)FindComponent("StudyProcessingBar" + IntToStr(globalCameraIndex)));
		TTntLabel *tempLabel = ((TTntLabel *)FindComponent("StudyProcessingLabel" + IntToStr(globalCameraIndex)));

		if (tempProgressbar)
		{
			tempProgressbar->Position = 0;
		}

		if (tempLabel)
		{
			tempLabel->Caption = FIRSTSTUDYFORM_TEXT_CAPTION_11;
		}
	}

	InspectionOrStudy = FIRST_STUDY_MODE;
	FirstStudyExcuteSW = 1;

	memset(&FirstStudyResult, 0, sizeof(TFirstStudyResult));

  int goodImageCount;
  Disk1ThreeDImageCenterXForLaser = Disk1ThreeDImageCenterYForLaser = Disk2ThreeDImageCenterXForLaser = Disk2ThreeDImageCenterYForLaser = Disk1ThreeDImageLengthForLaser = Disk2ThreeDImageLengthForLaser = 0;

	for (int globalCameraIndex = 1; globalCameraIndex <= SYSTEM_TOTAL_CAMERA_COUNT; globalCameraIndex++)
	{
    	stringCamIndex2D = FIRSTSTUDYFORM_GROUPBOX_CAPTION_02 + " CAM " +IntToStr(globalCameraIndex) + " ";
    	GroupBox1->Caption = stringCamIndex2D;

        stringCamIndex3D = FIRSTSTUDYFORM_GROUPBOX_CAPTION_01 + " CAM " +IntToStr(globalCameraIndex) + " ";
       	GroupBox12->Caption = stringCamIndex3D;

		CurrentProgressBar->Position = 0;
		if (globalCameraIndex == SD1_2D_FRONT_FACE_CAMERA_INDEX || globalCameraIndex == SD2_2D_FRONT_FACE_CAMERA_INDEX)
		{      
      CurrentProgressBar->Max = FIRST_STUDY_N;
      SideFaceProcessingResultPanel->Visible = false;
			if (CameraMapInfo[globalCameraIndex - 1].CameraInspectPosition < CAMERA_POSITION_DISCONNECT && SystemLinkCameraInfo[globalCameraIndex - 1] != 0)
			{
        int SDNum;
				if (globalCameraIndex == SD1_2D_FRONT_FACE_CAMERA_INDEX)
					SDNum = SUCTION_DISK_NUM1;
				else
					SDNum = SUCTION_DISK_NUM2;

				FrontFaceSetUpDataTransForm(FRONT_FACE, SDNum);

				SideFaceProcessingResultPanel->Visible = false;
				for (int imageCount = 1; imageCount <= FIRST_STUDY_N; imageCount++)
				{
					ImageLoad(imageCount, globalCameraIndex);
					InspectionKind = FRONT_FACE;
					ProcessingStartForFrontFace(InspectionOrStudy, globalCameraIndex, 0);

          if(DefectSW == 0)
          {
            ResultDataAccumulate(globalCameraIndex, NOT_THREED, imageCount);
            ProcessingResultDisplay(globalCameraIndex, NOT_THREED);
            ProgressDisplay(globalCameraIndex, imageCount, FIRST_STUDY_N);

            if (globalCameraIndex == SD1_2D_FRONT_FACE_CAMERA_INDEX)
            {
              if (CurrentPrintPixelCnt != 0)
              {
                PrintPixelCntCam1 += CurrentPrintPixelCnt;
                addCount1++;
              }

              if (ProtoEngraveDistinguishV_Cam1 > 6)
              {
                Acc_ProtoEngraveDistinguishV_Cam1 += ProtoEngraveDistinguishV_Cam1;
                EngraveMatchingCount1++;
              }
            }
            else
            {
              if (CurrentPrintPixelCnt != 0)
              {
                PrintPixelCntCam9 += CurrentPrintPixelCnt;
                addCount2++;
              }

              if (ProtoEngraveDistinguishV_Cam9 > 6)  // 6 ̸  ǥ鿡 ƹ͵ ų  ̹ ִ ¶ 
              {
                Acc_ProtoEngraveDistinguishV_Cam9 += ProtoEngraveDistinguishV_Cam9;
                EngraveMatchingCount2++;
              }
            }
          }

					Sleep(10);
					CurrentProgressBar->Position++;
					Application->ProcessMessages();
				}
			}
		}
		else if (globalCameraIndex == SD1_3D_FRONT_FACE_CAMERA_INDEX || globalCameraIndex == SD2_3D_FRONT_FACE_CAMERA_INDEX)
		{
      CurrentProgressBar->Max = FIRST_STUDY_N;
			SideFaceProcessingResultPanel->Visible = false;
			if (CameraMapInfo[globalCameraIndex - 1].CameraInspectPosition < CAMERA_POSITION_DISCONNECT && SystemLinkCameraInfo[globalCameraIndex - 1] != 0)
			{
				Panel1->Left = 1450;
				Application->ProcessMessages();
				GroupBox12->Visible = true;
				GroupBox1->Visible = false;

				int SDNum;
				if (globalCameraIndex == SD1_3D_FRONT_FACE_CAMERA_INDEX)
					SDNum = SUCTION_DISK_NUM1;
				else
					SDNum = SUCTION_DISK_NUM2;

				SetUpDataTransFormForThreeD(FRONT_FACE_SPECIAL, SDNum);

				if (globalCameraIndex == SD1_3D_FRONT_FACE_CAMERA_INDEX)
				{
					Disk1Print1ImageCount = 0;
					Disk1Print2ImageCount = 0;
					memset(&AccumualteImage1[0][0], 0, MAX_IMAGE_WIDTH*MAX_IMAGE_HEIGHT * THREED_PRINT_MAX_LABEL_COUNT);
					memset(&AccumualteImage2[0][0], 0, MAX_IMAGE_WIDTH*MAX_IMAGE_HEIGHT * THREED_PRINT_MAX_LABEL_COUNT);
				}
				else
				{
					Disk2Print1ImageCount = 0;
					Disk2Print2ImageCount = 0;
					memset(&AccumualteImage1[0][0], 0, MAX_IMAGE_WIDTH*MAX_IMAGE_HEIGHT * THREED_PRINT_MAX_LABEL_COUNT);
					memset(&AccumualteImage2[0][0], 0, MAX_IMAGE_WIDTH*MAX_IMAGE_HEIGHT * THREED_PRINT_MAX_LABEL_COUNT);
				}

        goodImageCount = 0;
				for (int imageCount = 1; imageCount <= FIRST_STUDY_N; imageCount++)
				{
					ImageLoad(imageCount, globalCameraIndex);
					InspectionKind = FRONT_FACE_SPECIAL;
					ProcessingStartForFrontFace_3D(InspectionOrStudy, globalCameraIndex, 0x01); // For SELMA200, ׽Ʈ   0x00  ؾ

          if(DefectSW == 0)
          {
					  ResultDataAccumulate(globalCameraIndex, THREED, imageCount);
					  ProcessingResultDisplay(globalCameraIndex, THREED);
					  ProgressDisplay(globalCameraIndex, imageCount, FIRST_STUDY_N);

            if(globalCameraIndex == SD1_3D_FRONT_FACE_CAMERA_INDEX)
            {
              Disk1ThreeDImageCenterXForLaser += ThreeDRealCenterX;
              Disk1ThreeDImageCenterYForLaser += ThreeDRealCenterY;
              Disk1ThreeDImageLengthForLaser += ThreeDRealLength;
            }
            else
            {
              Disk2ThreeDImageCenterXForLaser += ThreeDRealCenterX;
              Disk2ThreeDImageCenterYForLaser += ThreeDRealCenterY;
              Disk2ThreeDImageLengthForLaser += ThreeDRealLength;
            }

            goodImageCount++;
          }
          
					Sleep(10);
					CurrentProgressBar->Position++;
					Application->ProcessMessages();
				}

        if(goodImageCount)
        {
          if(globalCameraIndex == SD1_3D_FRONT_FACE_CAMERA_INDEX)
          {
            Disk1ThreeDImageCenterXForLaser /= goodImageCount;
            Disk1ThreeDImageCenterYForLaser /= goodImageCount;
            Disk1ThreeDImageLengthForLaser /= goodImageCount;
          }
          else
          {
            Disk2ThreeDImageCenterXForLaser /= goodImageCount;
            Disk2ThreeDImageCenterYForLaser /= goodImageCount;
            Disk2ThreeDImageLengthForLaser /= goodImageCount;
          }
        }

				Store3DSetupData(globalCameraIndex);
				GroupBox12->Visible = false;
				GroupBox1->Visible = true;
				Panel1->Left = 3;
				Application->ProcessMessages();
			}
		}
		else
		{
      if(TabletCharacter.kind != SUGARCOATING)
      {
        SideFaceProcessingResultPanel->BringToFront();
        SideFaceProcessingResultPanel->Visible = true;
        InitialSideFaceProcessingDebugData();
      }
      else
      {
        if(globalCameraIndex == SD1_2D_SIDE_FACE_00_CAMERA_INDEX ||
            globalCameraIndex == SD1_2D_OTHER_SIDE_FACE_00_CAMERA_INDEX ||
            globalCameraIndex == SD2_2D_SIDE_FACE_00_CAMERA_INDEX ||
            globalCameraIndex == SD2_2D_OTHER_SIDE_FACE_00_CAMERA_INDEX)
        {
          // skip
          continue;
        }

        SideFaceProcessingResultPanel->Visible = false;
      }

      CurrentProgressBar->Max = FIRST_STUDY_N;

      if (CameraMapInfo[globalCameraIndex - 1].CameraInspectPosition < CAMERA_POSITION_DISCONNECT && SystemLinkCameraInfo[globalCameraIndex - 1] != 0)
      {
        InspectionAreaMinY[globalCameraIndex - 1] = MAX_IMAGE_HEIGHT;
        InspectionAreaMaxY[globalCameraIndex - 1] = 0;

        SideFaceMatchingCount = 0;

        SetSideFaceDataAddress(&tempSideData[0]);

        for(int imageCount = 1; imageCount <= FIRST_STUDY_N; imageCount++)
        {
          ImageLoad(imageCount, globalCameraIndex);

          if(globalCameraIndex == SD1_2D_SIDE_FACE_P45_CAMERA_INDEX ||
              globalCameraIndex == SD1_2D_OTHER_SIDE_FACE_P45_CAMERA_INDEX ||
              globalCameraIndex == SD2_2D_SIDE_FACE_P45_CAMERA_INDEX ||
              globalCameraIndex == SD2_2D_OTHER_SIDE_FACE_P45_CAMERA_INDEX)
          {
            InspectionKind = SIDE_FACE_P45;
            ProcessingStartForSideFace_P45(InspectionOrStudy, globalCameraIndex, 0);
          }
          else if(globalCameraIndex == SD1_2D_SIDE_FACE_00_CAMERA_INDEX ||
                  globalCameraIndex == SD1_2D_OTHER_SIDE_FACE_00_CAMERA_INDEX ||
                  globalCameraIndex == SD2_2D_SIDE_FACE_00_CAMERA_INDEX ||
                  globalCameraIndex == SD2_2D_OTHER_SIDE_FACE_00_CAMERA_INDEX)
          {
            InspectionKind = SIDE_FACE_0;
            ProcessingStartForSideFace_0(InspectionOrStudy, globalCameraIndex, 0);
          }
          else if(globalCameraIndex == SD1_2D_SIDE_FACE_M45_CAMERA_INDEX ||
                  globalCameraIndex == SD1_2D_OTHER_SIDE_FACE_M45_CAMERA_INDEX ||
                  globalCameraIndex == SD2_2D_SIDE_FACE_M45_CAMERA_INDEX ||
                  globalCameraIndex == SD2_2D_OTHER_SIDE_FACE_M45_CAMERA_INDEX)
          {
            InspectionKind = SIDE_FACE_M45;
            ProcessingStartForSideFace_M45(InspectionOrStudy, globalCameraIndex, 0);
          }

          if(DefectSW == 0)
          {
            ResultDataAccumulate(globalCameraIndex, NOT_THREED, imageCount);
            ProcessingResultDisplay(globalCameraIndex, NOT_THREED);
            ProgressDisplay(globalCameraIndex, imageCount, FIRST_STUDY_N);

            SetSideFaceProcessingDebugData(imageCount, globalCameraIndex);

            AccumulateAreaInformation(globalCameraIndex);
          }
          
          Sleep(10);
          CurrentProgressBar->Position++;
          Application->ProcessMessages();
        }

        if(SideFaceMatchingCount)
        {
          AccInspectionAreaStX[globalCameraIndex - 1] /= SideFaceMatchingCount;
          AccInspectionAreaEdX[globalCameraIndex - 1] /= SideFaceMatchingCount;
        }

        if(SideFaceMatchingCount < FIRST_STUDY_N / 2)
        {
          StudyFailInfo[globalCameraIndex - 1] = true;
        }
      }

      Sleep(2000);
    }
	}

	FirstStudyDataCalculate();

	BitBtn1->Visible = true;
	BitBtn2->Visible = true;
	GroupBox11->Visible = true;
	Panel1->Visible = false;
	SideFaceProcessingResultPanel->Visible = false;

	TTntImage* tempImage;
	for (int i = 1; i <= SYSTEM_TOTAL_CAMERA_COUNT; i++)
	{
    if(SystemLinkCameraInfo[i-1] != 0 )
    {
		  tempImage = ((TTntImage *)FindComponent("ResultImage" + IntToStr(i)));

		  if (tempImage)
		  {
			  tempImage->Canvas->Brush->Style = bsSolid;
			  tempImage->Canvas->Brush->Color = 0x121244;
			  tempImage->Canvas->Pen->Color = clBlack;
			  tempImage->Canvas->Rectangle(0, 0, tempImage->Width, tempImage->Height);
			  tempImage->Canvas->Font->Size = 18;
			  tempImage->Canvas->Font->Color = clWhite;

		    //	tempImage->Canvas->TextOutW(30, 65, "CAMERA" + IntToStr(i));
        AnsiString ConvertString = ConvertCameraIndex(i-1);
        tempImage->Canvas->TextOutW(30, 65, ConvertString);

			  tempImage->Canvas->TextOutW(30, 105, CameraInfo[i - 1]);
      }
		}
	}
}
//---------------------------------------------------------------------------
void __fastcall TFirstStudy::Store3DSetupData(int cameraIndex)
{
	int tempCount;
	if (cameraIndex == SD1_3D_FRONT_FACE_CAMERA_INDEX)
	{
		//DISK1
		for (int m = 0; m < 30; m++)
		{
			Tablet3DSetupData.disk1EdgeHeightDiff[m] = 0;
		}

    if (TabletCharacter.discriminationDisplay_kind == STAMP)
    {
      //   3D   ٴ 
      for (int m = 0; m < 30; m++)
      {
        Tablet3DSetupData.disk1OneSideEdgeHeightDiff[m] = 0;
      }

      for (int m = 0; m < 30; m++)
      {
        Tablet3DSetupData.disk1OtherSideEdgeHeightDiff[m] = 0;
      }
    }

		for (int n = 0; n < Tablet3DSetupData.printLabelCount[0][0]; n++)
		{
			tempCount = 0;
			for (int y = 0; y < MAX_IMAGE_HEIGHT; y++)
			{
				for (int x = 0; x < MAX_IMAGE_WIDTH; x++)
				{
					if (Disk1Print1ImageCount)
					{
						if (AccumualteImage1[MAX_IMAGE_WIDTH*y + x][n] * 100 / Disk1Print1ImageCount > EXPAND_PRINT_PROBABLITY)
						{
							if (tempCount < PRINT_EXPAND_MASKING_DATA_SIZE)
							{
								Tablet3DSetupData.printLabelDataForExpandMasking[0][0][n][tempCount][0] = x;
								Tablet3DSetupData.printLabelDataForExpandMasking[0][0][n][tempCount][1] = y;
								tempCount++;
							}
						}
					}
				}
			}
			Tablet3DSetupData.printLabelDataCntForExpandMasking[0][0][n] = tempCount;
		}

		for (int n = 0; n < Tablet3DSetupData.printLabelCount[0][1]; n++)
		{
			tempCount = 0;
			for (int y = 0; y < MAX_IMAGE_HEIGHT; y++)
			{
				for (int x = 0; x < MAX_IMAGE_WIDTH; x++)
				{
					if (Disk1Print2ImageCount)
					{
						if (AccumualteImage2[MAX_IMAGE_WIDTH*y + x][n] * 100 / Disk1Print2ImageCount > EXPAND_PRINT_PROBABLITY)
						{
							if (tempCount < PRINT_EXPAND_MASKING_DATA_SIZE)
							{
								Tablet3DSetupData.printLabelDataForExpandMasking[0][1][n][tempCount][0] = x;
								Tablet3DSetupData.printLabelDataForExpandMasking[0][1][n][tempCount][1] = y;
								tempCount++;
							}
						}
					}
				}
			}
			Tablet3DSetupData.printLabelDataCntForExpandMasking[0][1][n] = tempCount;
		}
	}
	else if (cameraIndex == SD2_3D_FRONT_FACE_CAMERA_INDEX)
	{
		//Disk2
		for (int m = 0; m < 30; m++)
		{
			Tablet3DSetupData.disk2EdgeHeightDiff[m] = 0;
		}

    if (TabletCharacter.discriminationDisplay_kind == STAMP)
    {
      for (int m = 0; m < 30; m++)
      {
        Tablet3DSetupData.disk2OneSideEdgeHeightDiff[m] = 0;
      }

      for (int m = 0; m < 30; m++)
      {
        Tablet3DSetupData.disk2OtherSideEdgeHeightDiff[m] = 0;
      }
    }

		for (int n = 0; n < Tablet3DSetupData.printLabelCount[1][0]; n++)
		{
			tempCount = 0;
			for (int y = 0; y < MAX_IMAGE_HEIGHT; y++)
			{
				for (int x = 0; x < MAX_IMAGE_WIDTH; x++)
				{
					if (Disk2Print1ImageCount)
					{
						if (AccumualteImage1[MAX_IMAGE_WIDTH*y + x][n] * 100 / Disk2Print1ImageCount > EXPAND_PRINT_PROBABLITY)
						{
							Tablet3DSetupData.printLabelDataForExpandMasking[1][0][n][tempCount][0] = x;
							Tablet3DSetupData.printLabelDataForExpandMasking[1][0][n][tempCount][1] = y;
							tempCount++;
						}
					}
				}
			}
			Tablet3DSetupData.printLabelDataCntForExpandMasking[1][0][n] = tempCount;
		}
		for (int n = 0; n < Tablet3DSetupData.printLabelCount[1][1]; n++)
		{
			tempCount = 0;
			for (int y = 0; y < MAX_IMAGE_HEIGHT; y++)
			{
				for (int x = 0; x < MAX_IMAGE_WIDTH; x++)
				{
					if (Disk2Print2ImageCount)
					{
						if (AccumualteImage2[MAX_IMAGE_WIDTH*y + x][n] * 100 / Disk2Print2ImageCount > EXPAND_PRINT_PROBABLITY)
						{
							Tablet3DSetupData.printLabelDataForExpandMasking[1][1][n][tempCount][0] = x;
							Tablet3DSetupData.printLabelDataForExpandMasking[1][1][n][tempCount][1] = y;
							tempCount++;
						}
					}
				}
			}
			Tablet3DSetupData.printLabelDataCntForExpandMasking[1][1][n] = tempCount;
		}
	}
}
//---------------------------------------------------------------------------
void __fastcall TFirstStudy::BitBtn2Click(TObject *Sender)
{
	if (FirstStudyExcuteSW)
	{
    bool existError = false;
    AnsiString ErrorCameraString = "";

    int errorCameraCount = 0;
    for (int globalCameraIndex = 0; globalCameraIndex < SYSTEM_TOTAL_CAMERA_COUNT; globalCameraIndex++)
    {
      if(SystemLinkCameraInfo[globalCameraIndex - 1])
      {
        if(ProductData.TabletType == TABLET_TYPE_SUGAR_COATED)
        {
          if(!(globalCameraIndex == SD1_2D_SIDE_FACE_00_CAMERA_INDEX - 1 ||
              globalCameraIndex == SD1_2D_OTHER_SIDE_FACE_00_CAMERA_INDEX - 1 ||
              globalCameraIndex == SD2_2D_SIDE_FACE_00_CAMERA_INDEX - 1 ||
              globalCameraIndex == SD2_2D_OTHER_SIDE_FACE_00_CAMERA_INDEX - 1))
          {
            if(StudyFailInfo[globalCameraIndex])
            {
              existError = true;
              errorCameraCount++;
            }
          }
        }
        else
        {
          if(StudyFailInfo[globalCameraIndex])
          {
            existError = true;
            errorCameraCount++;
          }
        }
      }
    }
    
    for (int globalCameraIndex = 0; globalCameraIndex < SYSTEM_TOTAL_CAMERA_COUNT; globalCameraIndex++)
    {
      if(SystemLinkCameraInfo[globalCameraIndex - 1])
      {
        if(ProductData.TabletType == TABLET_TYPE_SUGAR_COATED)
        {
          if(!(globalCameraIndex == SD1_2D_SIDE_FACE_00_CAMERA_INDEX - 1 ||
              globalCameraIndex == SD1_2D_OTHER_SIDE_FACE_00_CAMERA_INDEX - 1 ||
              globalCameraIndex == SD2_2D_SIDE_FACE_00_CAMERA_INDEX - 1 ||
              globalCameraIndex == SD2_2D_OTHER_SIDE_FACE_00_CAMERA_INDEX - 1))
          {
            if(StudyFailInfo[globalCameraIndex])
            {
              ErrorCameraString += "Camera" + IntToStr(globalCameraIndex + 1);

              errorCameraCount--;
              if(errorCameraCount)
              {
                ErrorCameraString += ", ";
              }
            }
          }
        }
        else
        {
          if(StudyFailInfo[globalCameraIndex])
          {
            ErrorCameraString += "Camera" + IntToStr(globalCameraIndex + 1);

            errorCameraCount--;
            if(errorCameraCount)
            {
              ErrorCameraString += ", ";
            }
          }
        }
      }
    }

    if(existError)
    {
      if (MessageDlgFA(FIRSTSTUDYFORM_MSG_04 + " [" + ErrorCameraString + "]" , mtConfirmation, TMsgDlgButtons() << mbOK << mbCancel) != mrOk)
      {
        MessageDlgFA(FIRSTSTUDYFORM_MSG_05 , mtConfirmation, TMsgDlgButtons() << mbOK);
        
        ModalResult = mrCancel;
			  Close();
        return;
      }
    }

    if(MachineSetupData.LasercomplexerInfo.Laser_complexer_Enable)
    {
      if(Disk1ThreeDImageCenterXForLaser == 0 ||
          Disk1ThreeDImageCenterYForLaser == 0 ||
          Disk2ThreeDImageCenterXForLaser == 0 ||
          Disk2ThreeDImageCenterYForLaser == 0 ||
          Disk1ThreeDImageLengthForLaser == 0 ||
          Disk2ThreeDImageLengthForLaser == 0)
      {
        if (MessageDlgFA("Invalid Value : 3D Image Position Infomation" , mtConfirmation, TMsgDlgButtons() << mbOK))
        {
          ModalResult = mrCancel;
          Close();
          return;
        }
      }
    }
    
		if (MessageDlgFA(FIRSTSTUDYFORM_MSG_02, mtConfirmation, TMsgDlgButtons() << mbOK << mbCancel) == mrOk)
		{
			ReadSetupData(&TabletSetupData);

			int diskPos;
			for (int globalCameraIndex = 0; globalCameraIndex < SYSTEM_TOTAL_CAMERA_COUNT; globalCameraIndex++)
			{
				TabletSetupData.DiskBaseHeightPosition[globalCameraIndex] = MachineParams.DiscCenterPos[globalCameraIndex] / 4 * 4;

				TabletSetupData.ImageCutStartX[globalCameraIndex] = BoundaryLeft[globalCameraIndex] / 4 * 4;
				TabletSetupData.ImageCutEndX[globalCameraIndex] = BoundaryRight[globalCameraIndex] / 4 * 4;
				TabletSetupData.ImageCutStartY[globalCameraIndex] = BoundaryTop[globalCameraIndex] / 4 * 4;
				TabletSetupData.ImageCutEndY[globalCameraIndex] = BoundaryBottom[globalCameraIndex] / 4 * 4;

				switch (globalCameraIndex + 1)
				{
				case SD1_2D_SIDE_FACE_P45_CAMERA_INDEX:
				case SD1_2D_SIDE_FACE_00_CAMERA_INDEX:
				case SD1_2D_SIDE_FACE_M45_CAMERA_INDEX:
				case SD1_2D_OTHER_SIDE_FACE_P45_CAMERA_INDEX:
				case SD1_2D_OTHER_SIDE_FACE_00_CAMERA_INDEX:
				case SD1_2D_OTHER_SIDE_FACE_M45_CAMERA_INDEX:
				case SD2_2D_SIDE_FACE_P45_CAMERA_INDEX:
				case SD2_2D_SIDE_FACE_00_CAMERA_INDEX:
				case SD2_2D_SIDE_FACE_M45_CAMERA_INDEX:
				case SD2_2D_OTHER_SIDE_FACE_P45_CAMERA_INDEX:
				case SD2_2D_OTHER_SIDE_FACE_00_CAMERA_INDEX:
				case SD2_2D_OTHER_SIDE_FACE_M45_CAMERA_INDEX:

					if (AccInspectionAreaStX[globalCameraIndex] &&
						AccInspectionAreaEdX[globalCameraIndex])
					{
						TabletSetupData.ImageCutStartX[globalCameraIndex] = max(5, AccInspectionAreaStX[globalCameraIndex] - 40);
						TabletSetupData.ImageCutEndX[globalCameraIndex] = min(MAX_IMAGE_WIDTH - 5, AccInspectionAreaEdX[globalCameraIndex] + 40);
					}
          else
          {
            TabletSetupData.ImageCutStartX[globalCameraIndex] = 5;
						TabletSetupData.ImageCutEndX[globalCameraIndex] = MAX_IMAGE_WIDTH - 5;
          }

					diskPos = MachineParams.DiscCenterPos[globalCameraIndex];

          if(StudyFailInfo[globalCameraIndex] == false)
          {
					  TabletSetupData.ImageCutStartY[globalCameraIndex] = max(20, InspectionAreaMinY[globalCameraIndex] - 40);
					  TabletSetupData.ImageCutEndY[globalCameraIndex] = max(InspectionAreaMaxY[globalCameraIndex], diskPos + 4);
          }
          else
          {
            TabletSetupData.ImageCutStartY[globalCameraIndex] = max(10, diskPos - TiltingTabletHeight[globalCameraIndex] - 80);
			      TabletSetupData.ImageCutEndY[globalCameraIndex] = min(MAX_IMAGE_HEIGHT - 30, diskPos + 10);
          }

					break;
				}
			}

      for (int globalCameraIndex = 0; globalCameraIndex < SYSTEM_TOTAL_CAMERA_COUNT; globalCameraIndex++)
			{
        /*
				if(globalCameraIndex == SD1_2D_FRONT_FACE_CAMERA_INDEX - 1 ||
            globalCameraIndex == SD2_2D_FRONT_FACE_CAMERA_INDEX - 1 ||
            globalCameraIndex == SD1_3D_FRONT_FACE_CAMERA_INDEX - 1 ||
            globalCameraIndex == SD2_3D_FRONT_FACE_CAMERA_INDEX - 1)
        {
          TabletSetupData.ImageCutStartY[globalCameraIndex] = max(TabletSetupData.ImageCutStartY[globalCameraIndex] - 20, 20);
				  TabletSetupData.ImageCutEndY[globalCameraIndex] = min(TabletSetupData.ImageCutEndY[globalCameraIndex] + 20, MAX_IMAGE_HEIGHT - 20);
        }
        */

        // 21-07-19
        // ũ ӵ  ¿ ˻   ߻ (ĸ Ÿ̹ ߻ Ѱ )
        // +-20  Ȯ

        TabletSetupData.ImageCutStartX[globalCameraIndex] = max(TabletSetupData.ImageCutStartX[globalCameraIndex] - 20, 20);
				TabletSetupData.ImageCutEndX[globalCameraIndex] = min(TabletSetupData.ImageCutEndX[globalCameraIndex] + 20, MAX_IMAGE_WIDTH - 20);
      }

			if (ProductData.EngravePos == ENGRAVE_POS_ONESIDE)
			{
				if (EngraveMatchingCount1 != 0)
					Acc_ProtoEngraveDistinguishV_Cam1 /= EngraveMatchingCount1;
				else
					Acc_ProtoEngraveDistinguishV_Cam1 = 30;

				if (EngraveMatchingCount2 != 0)
					Acc_ProtoEngraveDistinguishV_Cam9 /= EngraveMatchingCount2;
				else
					Acc_ProtoEngraveDistinguishV_Cam9 = 30;

				TabletSetupData.ProtoEngraveDistinguishV_Cam1 = Acc_ProtoEngraveDistinguishV_Cam1;
				TabletSetupData.ProtoEngraveDistinguishV_Cam9 = Acc_ProtoEngraveDistinguishV_Cam9;
			}

			AnsiString setupDataFileName = ProgramPath.Product + "\\" + ProductData.ProductCode + "\\" + ProductData.ProductCode + ".sdt";
			TFileStream *fileStream = new TFileStream(setupDataFileName, fmCreate);
			fileStream->Write(&TabletSetupData, sizeof(TTabletSetupData));
			delete fileStream;

			AnsiString threeDsetupDataFileName = ProgramPath.Product + "\\" + ProductData.ProductCode + "\\" + ProductData.ProductCode + ".sdt_3D";
			TFileStream *fileStream1 = new TFileStream(threeDsetupDataFileName, fmCreate);
			fileStream1->Write(&Tablet3DSetupData, sizeof(TTablet3DSetupData));
			delete fileStream1;

			for (int globalCameraIndex = 0; globalCameraIndex < SYSTEM_TOTAL_CAMERA_COUNT; globalCameraIndex++)
			{
				ProductData.BoundaryLeft[globalCameraIndex] = TabletSetupData.ImageCutStartX[globalCameraIndex];
				ProductData.BoundaryTop[globalCameraIndex] = TabletSetupData.ImageCutStartY[globalCameraIndex];
				ProductData.BoundaryRight[globalCameraIndex] = TabletSetupData.ImageCutEndX[globalCameraIndex];
				ProductData.BoundaryBottom[globalCameraIndex] = TabletSetupData.ImageCutEndY[globalCameraIndex];
			}

      ProductData.ProcessingStep = TABLET_PROCESSING_STEP_STUDY_REQUIRED;

      if(MachineSetupData.LasercomplexerInfo.Laser_complexer_Enable)
      {
        ProductData.Disk1ThreeDImageCenterXForLaser = Disk1ThreeDImageCenterXForLaser;
        ProductData.Disk1ThreeDImageCenterYForLaser = Disk1ThreeDImageCenterYForLaser;
        ProductData.Disk2ThreeDImageCenterXForLaser = Disk2ThreeDImageCenterXForLaser;
        ProductData.Disk2ThreeDImageCenterYForLaser = Disk2ThreeDImageCenterYForLaser;

        ProductData.Disk1ThreeDImageLengthForLaser = Disk1ThreeDImageLengthForLaser;
        ProductData.Disk2ThreeDImageLengthForLaser = Disk2ThreeDImageLengthForLaser;
      }
      else
      {
        ProductData.Disk1ThreeDImageCenterXForLaser = 0;
        ProductData.Disk1ThreeDImageCenterYForLaser = 0;
        ProductData.Disk2ThreeDImageCenterXForLaser = 0;
        ProductData.Disk2ThreeDImageCenterYForLaser = 0;

        ProductData.Disk1ThreeDImageLengthForLaser = 0;
        ProductData.Disk2ThreeDImageLengthForLaser = 0;
      }

			AnsiString fileName = GetProductDataFileName(ProductData.ProductCode);
			WriteProductData(fileName, ProductData);

			AddCSVActionLog(ECSV_ACTION_FIRST_STUDY, UserInfo.Name, ProductData.ProductName, NULL, 0);
			ModalResult = mrOk;
			Close();
		}
		else
		{
			ModalResult = mrCancel;
			Close();
		}
	}
	else
	{
		ModalResult = mrCancel;
		Close();
	}
}
//---------------------------------------------------------------------------

void __fastcall TFirstStudy::rmActivate(TObject *Sender)
{
  SetScreenPosition(this);
  
	Side_XSPACE = 55;
	Front_XSPACE = 50;

	MakeTabletCharacterData(&ProductData, &TabletCharacter, &MachineParams);
	if (TabletCharacter.shape == TRIANGLE)
		Front_XSPACE = (float)TabletCharacter.length*1.731 / 3.0*0.717;

	if (TabletCharacter.shape == OBLONG || TabletCharacter.shape == OVAL)
		Front_XSPACE = (float)TabletCharacter.width / 2.0*0.414 + 10;
	else
		Front_XSPACE = (float)TabletCharacter.width / 2.0*0.414 + 10;

	GroupBox2->Visible = false;
	GroupBox11->Visible = false;
	Panel1->Visible = false;
}
//---------------------------------------------------------------------------

void __fastcall TFirstStudy::FormCreate(TObject *Sender)
{
	FirstStudyExcuteSW = 0;
	GroupBox12->Visible = false;

	GroupBox1->DoubleBuffered = true;
	GroupBox12->DoubleBuffered = true;
	SideFaceProcessingResultPanel->DoubleBuffered = true;

	Image1->Canvas->Brush->Color = clBlue;
	Image1->Canvas->Brush->Style = bsSolid;
	Image1->Canvas->FillRect(Rect(0, 0, Image1->Picture->Bitmap->Width, Image1->Picture->Bitmap->Height));
  for(int globalCameraIndex = 0; globalCameraIndex < SYSTEM_TOTAL_CAMERA_COUNT; globalCameraIndex++)
  {
    AnsiString ConvertString;
    if(SystemLinkCameraInfo[globalCameraIndex] != 0)
    {
      TTntStaticText *CameraStatic = (TTntStaticText *)FindComponent("CameraStatic" + IntToStr(globalCameraIndex+1));

      ConvertString = ConvertCameraIndex(globalCameraIndex);
      CameraStatic->Caption = ConvertString;
    }
  }

  if(GlobalProgramID == PROGRAM_ID_150P)
  {
    int MoveD = ComponentReposition(3,CameraStatic1->Top, CameraStatic2->Top, 0);
    int MoveD1 = ComponentReposition(1,0,0,ResultImage3->Width);
    for(int globalCameraIndex = 0; globalCameraIndex < SYSTEM_TOTAL_CAMERA_COUNT; globalCameraIndex++)
    {
      TTntStaticText *CameraStatic = (TTntStaticText *)FindComponent("CameraStatic" + IntToStr(globalCameraIndex+1));
      TTntStaticText *StudyProcessingLabel = (TTntStaticText *)FindComponent("StudyProcessingLabel" + IntToStr(globalCameraIndex+1));
      TTntProgressBar *StudyProcessingBar = (TTntProgressBar *)FindComponent("StudyProcessingBar" + IntToStr(globalCameraIndex+1));
      TTntImage *ResultImage = (TTntImage *)FindComponent("ResultImage" + IntToStr(globalCameraIndex+1));

      if(SystemLinkCameraInfo[globalCameraIndex] == 0)
      {
        CameraStatic->Visible = false;
        StudyProcessingLabel->Visible = false;
        StudyProcessingBar->Visible = false;
        ResultImage->Visible = false;

      }
      else
      {
        if(globalCameraIndex+1 == 1 || globalCameraIndex+1 == 2 || globalCameraIndex+1 == 4 ||
        globalCameraIndex+1 == 9 || globalCameraIndex+1 == 10 || globalCameraIndex+1 == 12  )
        {
          CameraStatic->Top += MoveD;
          StudyProcessingLabel->Top += MoveD;
          StudyProcessingBar->Top += MoveD;
        }
        ResultImage->Left += MoveD1;
      }
    }
  }
  else if(ProductData.TabletType == TABLET_TYPE_SUGAR_COATED)
  {
    for(int globalCameraIndex = 0; globalCameraIndex < SYSTEM_TOTAL_CAMERA_COUNT; globalCameraIndex++)
    {
      if(globalCameraIndex == SD1_2D_SIDE_FACE_00_CAMERA_INDEX - 1 ||
          globalCameraIndex == SD1_2D_OTHER_SIDE_FACE_00_CAMERA_INDEX - 1 ||
          globalCameraIndex == SD2_2D_SIDE_FACE_00_CAMERA_INDEX - 1 ||
          globalCameraIndex == SD2_2D_OTHER_SIDE_FACE_00_CAMERA_INDEX - 1)
      {
        TTntStaticText *CameraStatic = (TTntStaticText *)FindComponent("CameraStatic" + IntToStr(globalCameraIndex+1));
        TTntStaticText *StudyProcessingLabel = (TTntStaticText *)FindComponent("StudyProcessingLabel" + IntToStr(globalCameraIndex+1));
        TTntProgressBar *StudyProcessingBar = (TTntProgressBar *)FindComponent("StudyProcessingBar" + IntToStr(globalCameraIndex+1));
        TTntImage *ResultImage = (TTntImage *)FindComponent("ResultImage" + IntToStr(globalCameraIndex+1));

        if(CameraStatic)
        {
          CameraStatic->Visible = false;
        }

        if(StudyProcessingLabel)
        {
          StudyProcessingLabel->Visible = false;
        }

        if(StudyProcessingBar)
        {
          StudyProcessingBar->Visible = false;
        }

        if(ResultImage)
        {
          ResultImage->Visible = false;
        }
      }
    }
  }
}
//---------------------------------------------------------------------------

void __fastcall TFirstStudy::AccumulateAreaInformation(int cameraIndex)
{
	if (DefectSW == 0 || DefectSW == 1)
	{
		int x, y;
		int tempAddress;
		int minY, maxY;
		int minX, maxX;

		minY = MAX_IMAGE_HEIGHT;
		maxY = 0;
		for (y = 10; y < MAX_IMAGE_HEIGHT - 10; y++)
		{
			for (x = 10; x < MAX_IMAGE_WIDTH - 10; x++)
			{
				tempAddress = MAX_IMAGE_WIDTH * y + x;

				if (ShapeBinaryImage[tempAddress])
				{
					if (minY > y) minY = y;
					if (maxY < y) maxY = y;
				}
			}
		}

		if (InspectionAreaMinY[cameraIndex - 1] > minY) InspectionAreaMinY[cameraIndex - 1] = minY;
		if (InspectionAreaMaxY[cameraIndex - 1] < maxY) InspectionAreaMaxY[cameraIndex - 1] = maxY;

		if (minY < maxY)
		{
			minX = MAX_IMAGE_WIDTH;
			maxX = 0;
			for (y = minY; y < maxY; y++)
			{
				for (x = 10; x < MAX_IMAGE_WIDTH - 10; x++)
				{
					tempAddress = MAX_IMAGE_WIDTH * y + x;

					if (ShapeBinaryImage[tempAddress])
					{
						if (minX > x) minX = x;
						if (maxX < x) maxX = x;
					}
				}
			}

			AccInspectionAreaStX[cameraIndex - 1] += minX;
			AccInspectionAreaEdX[cameraIndex - 1] += maxX;
			SideFaceMatchingCount++;
		}
	}
}
//---------------------------------------------------------------------------
void __fastcall TFirstStudy::ResultImageClick(TObject *Sender)
{
	TTntImage* selectedImage;
	selectedImage = (TTntImage*)Sender;

	int cameraIndex = selectedImage->Tag + 1;

	Graphics::TBitmap *img1;
	img1 = new Graphics::TBitmap();
	for (int imageCount = 1; imageCount <= FIRST_STUDY_N; imageCount++)
	{
		if (ExtractImage(img1, imageCount, cameraIndex, TabletSetupData.ImageOffSetSW[cameraIndex - 1], TabletSetupData.referenceImageForOffset[cameraIndex - 1], ProductData.SubSamplingMode))
		{
      if (CameraMapInfo[cameraIndex - 1].CameraInspectPosition != CAMERA_POSITION_3D && ProductData.SubSamplingMode == IMAGE_FULL_SCALE_MODE)
      {
        ReductionImageScale(img1);
      }
      
			if (selectedImage)
			{
				selectedImage->Stretch = true;
				selectedImage->Picture->Bitmap->Assign(img1);
				selectedImage->Canvas->Brush->Style = bsClear;
				selectedImage->Canvas->Pen->Color = clRed;
				selectedImage->Canvas->Pen->Width = 3;
				selectedImage->Canvas->Rectangle(BoundaryLeft[cameraIndex - 1], BoundaryTop[cameraIndex - 1], BoundaryRight[cameraIndex - 1], BoundaryBottom[cameraIndex - 1]);
				selectedImage->Repaint();
			}
		}
		Sleep(10);
	}

	selectedImage->Stretch = false;

	delete img1;

	TTntImage *tempImage;
	for (int i = 1; i <= SYSTEM_TOTAL_CAMERA_COUNT; i++)
	{
    if(SystemLinkCameraInfo[i-1] != 0)
    {
		  tempImage = ((TTntImage *)FindComponent("ResultImage" + IntToStr(i)));

		  if (tempImage)
		  {
			  tempImage->Canvas->Brush->Style = bsSolid;
			  tempImage->Canvas->Brush->Color = 0x121244;
			  tempImage->Canvas->Pen->Color = clBlack;
			  tempImage->Canvas->Rectangle(0, 0, tempImage->Width, tempImage->Height);
			  tempImage->Canvas->Font->Size = 18;
			  tempImage->Canvas->Font->Color = clWhite;


		    //	tempImage->Canvas->TextOutW(30, 65, "CAMERA" + IntToStr(i));
        AnsiString ConvertString = ConvertCameraIndex(i-1);
        tempImage->Canvas->TextOutW(30, 65, ConvertString);
			  tempImage->Canvas->TextOutW(30, 105, CameraInfo[i - 1]);
      }

		}
	}
}
//---------------------------------------------------------------------------

void __fastcall TFirstStudy::Result3DImageClick(TObject *Sender)
{
	TTntImage* selectedImage;
	selectedImage = (TTntImage*)Sender;

	int cameraIndex = selectedImage->Tag + 1;

	Graphics::TBitmap *img1;
	img1 = new Graphics::TBitmap();
	Graphics::TBitmap *img2;
	img2 = new Graphics::TBitmap();
	for (int imageCount = 1; imageCount <= FIRST_STUDY_N; imageCount++)
	{
		if (ExtractImage(img1, imageCount, cameraIndex, TabletSetupData.ImageOffSetSW[cameraIndex - 1], TabletSetupData.referenceImageForOffset[cameraIndex - 1], ProductData.SubSamplingMode))
		{
      if (CameraMapInfo[cameraIndex - 1].CameraInspectPosition != CAMERA_POSITION_3D && ProductData.SubSamplingMode == IMAGE_FULL_SCALE_MODE)
      {
        ReductionImageScale(img1);
      }

			img2->Assign(img1);
			img2->Width = img1->Width * 2;

			Byte *ptr;
			Byte *tr;

			for (int y = 0; y < ImageHeight; y++)
			{
				ptr = (byte*)img1->ScanLine[y];
				tr = (byte*)img2->ScanLine[y];
				for (int x = 0; x < img1->Width * 2; x++)
				{
					tr[x] = ptr[x / 2];
				}
			}

			selectedImage->Stretch = true;
			selectedImage->Picture->Bitmap->Assign(img2);
			selectedImage->Canvas->Brush->Style = bsClear;
			selectedImage->Canvas->Pen->Color = clRed;
			selectedImage->Canvas->Pen->Width = 3;
			selectedImage->Canvas->Rectangle(BoundaryLeft[cameraIndex - 1], BoundaryTop[cameraIndex - 1], BoundaryRight[cameraIndex - 1], BoundaryBottom[cameraIndex - 1]);
			selectedImage->Repaint();
		}
		Sleep(10);
	}

	selectedImage->Stretch = false;

	delete(img1);
	delete(img2);

	TTntImage *tempImage;
	for (int i = 1; i <= SYSTEM_TOTAL_CAMERA_COUNT; i++)
	{
		tempImage = ((TTntImage *)FindComponent("ResultImage" + IntToStr(i)));

		if (tempImage)
		{
			tempImage->Canvas->Brush->Style = bsSolid;
			tempImage->Canvas->Brush->Color = 0x121244;
			tempImage->Canvas->Pen->Color = clBlack;
			tempImage->Canvas->Rectangle(0, 0, tempImage->Width, tempImage->Height);
			tempImage->Canvas->Font->Size = 18;
			tempImage->Canvas->Font->Color = clWhite;
			tempImage->Canvas->TextOutW(30, 65, "CAMERA" + IntToStr(i));
			tempImage->Canvas->TextOutW(30, 105, CameraInfo[i - 1]);
		}
	}
}
//---------------------------------------------------------------------------

void __fastcall TFirstStudy::LoadDebugResult(int cameraIndex)
{
}

//---------------------------------------------------------------------------

void __fastcall TFirstStudy::CameraResEdit9Click(TObject *Sender)
{
	TTntEdit *theEdit = (TTntEdit *)Sender;
	KeyboardForm->Text = theEdit->Text;
	if (KeyboardForm->ShowKeypad() == mrOk)
	{
		theEdit->Text = KeyboardForm->Text;
	}
}
//---------------------------------------------------------------------------

void __fastcall TFirstStudy::MakeDebugComponent()
{
	TImage *srcImage;
	TLabel *srcLabel1;
	TLabel *srcLabel2;
	TLabel *srcLabel3;
	TLabel *srcLabel4;
	TGroupBox *srcGrBox;

	int srcIndex;
	const int makedComponentIndex = 6;

	int rowCount;
	for (int ImageIndex = 7; ImageIndex <= FIRST_STUDY_N; ImageIndex++)
	{
		srcIndex = (ImageIndex - 1) % makedComponentIndex + 1;
		rowCount = (ImageIndex - 1) / makedComponentIndex;

		srcImage = ((TImage*)FindComponent("SideImage" + IntToStr(srcIndex)));
		srcLabel1 = ((TLabel*)FindComponent("AngleXMatchingResultLabel" + IntToStr(srcIndex)));
		srcLabel2 = ((TLabel*)FindComponent("AngleYMatchingResultLabel" + IntToStr(srcIndex)));
		srcLabel3 = ((TLabel*)FindComponent("AngleZMatchingResultLabel" + IntToStr(srcIndex)));
		srcLabel4 = ((TLabel*)FindComponent("ResMatchingResultLabel" + IntToStr(srcIndex)));
		srcGrBox = ((TGroupBox*)FindComponent("DataGroupBox" + IntToStr(srcIndex)));

		TImage *tempImage = new TImage(this);
		tempImage->Parent = DebugPanel;
		tempImage->Name = "SideImage" + IntToStr(ImageIndex);
		tempImage->Align = alNone;
		tempImage->Width = srcImage->Width;
		tempImage->Height = srcImage->Height;
		tempImage->Left = srcImage->Left;
		tempImage->Top = 128 + (8 + srcImage->Height) * rowCount;
		tempImage->OnDblClick = srcImage->OnDblClick;
		tempImage->Stretch = srcImage->Stretch;

		TGroupBox *tempGrBox = new TGroupBox(this);
		tempGrBox->Parent = DebugPanel;
		tempGrBox->Name = "DataGroupBox" + IntToStr(ImageIndex);
		tempGrBox->Align = alNone;
		tempGrBox->Width = srcGrBox->Width;
		tempGrBox->Height = srcGrBox->Height;
		tempGrBox->Left = srcGrBox->Left;
		tempGrBox->Top = 128 + (8 + srcGrBox->Height) * rowCount;
		tempGrBox->Caption = IntToStr(ImageIndex);

		TLabel *tempLabel1 = new TLabel(this);
		tempLabel1->Parent = ((TGroupBox*)FindComponent("DataGroupBox" + IntToStr(ImageIndex)));
		tempLabel1->Name = "AngleXMatchingResultLabel" + IntToStr(ImageIndex);
		tempLabel1->Align = alNone;
		tempLabel1->Width = srcLabel1->Width;
		tempLabel1->Height = srcLabel1->Height;
		tempLabel1->Left = srcLabel1->Left;
		tempLabel1->Top = srcLabel1->Top;
		tempLabel1->Caption = "X : 0";
		tempLabel1->Font = srcLabel1->Font;

		TLabel *tempLabel2 = new TLabel(this);
		tempLabel2->Parent = ((TGroupBox*)FindComponent("DataGroupBox" + IntToStr(ImageIndex)));
		tempLabel2->Name = "AngleYMatchingResultLabel" + IntToStr(ImageIndex);
		tempLabel2->Align = alNone;
		tempLabel2->Width = srcLabel2->Width;
		tempLabel2->Height = srcLabel2->Height;
		tempLabel2->Left = srcLabel2->Left;
		tempLabel2->Top = srcLabel2->Top;
		tempLabel2->Caption = "Y : 0";
		tempLabel2->Font = srcLabel2->Font;

		TLabel *tempLabel3 = new TLabel(this);
		tempLabel3->Parent = ((TGroupBox*)FindComponent("DataGroupBox" + IntToStr(ImageIndex)));
		tempLabel3->Name = "AngleZMatchingResultLabel" + IntToStr(ImageIndex);
		tempLabel3->Align = alNone;
		tempLabel3->Width = srcLabel3->Width;
		tempLabel3->Height = srcLabel3->Height;
		tempLabel3->Left = srcLabel3->Left;
		tempLabel3->Top = srcLabel3->Top;
		tempLabel3->Caption = "Z : 0";
		tempLabel3->Font = srcLabel4->Font;

		TLabel *tempLabel4 = new TLabel(this);
		tempLabel4->Parent = ((TGroupBox*)FindComponent("DataGroupBox" + IntToStr(ImageIndex)));;
		tempLabel4->Name = "ResMatchingResultLabel" + IntToStr(ImageIndex);
		tempLabel4->Align = alNone;
		tempLabel4->Width = srcLabel4->Width;
		tempLabel4->Height = srcLabel4->Height;
		tempLabel4->Left = srcLabel4->Left;
		tempLabel4->Top = srcLabel4->Top;
		tempLabel4->Caption = "RES :";
		tempLabel4->Font = srcLabel4->Font;
	}
}

//---------------------------------------------------------------------------
void __fastcall TFirstStudy::DeleteDebugComponent()
{
	TImage *srcImage;
	TLabel *srcLabel1;
	TLabel *srcLabel2;
	TLabel *srcLabel3;
	TLabel *srcLabel4;
	TGroupBox *srcGrBox;

	for (int ImageIndex = 7; ImageIndex <= FIRST_STUDY_N; ImageIndex++)
	{
		srcImage = ((TImage*)FindComponent("SideImage" + IntToStr(ImageIndex)));
		srcLabel1 = ((TLabel*)FindComponent("AngleXMatchingResultLabel" + IntToStr(ImageIndex)));
		srcLabel2 = ((TLabel*)FindComponent("AngleYMatchingResultLabel" + IntToStr(ImageIndex)));
		srcLabel3 = ((TLabel*)FindComponent("AngleZMatchingResultLabel" + IntToStr(ImageIndex)));
		srcLabel4 = ((TLabel*)FindComponent("ResMatchingResultLabel" + IntToStr(ImageIndex)));
		srcGrBox = ((TGroupBox*)FindComponent("DataGroupBox" + IntToStr(ImageIndex)));

		if (srcImage)
			delete srcImage;

		if (srcLabel1)
			delete srcLabel1;

		if (srcLabel2)
			delete srcLabel2;

		if (srcLabel3)
			delete srcLabel3;

		if (srcLabel4)
			delete srcLabel4;

		if (srcGrBox)
			delete srcGrBox;
	}
}

//---------------------------------------------------------------------------
void __fastcall TFirstStudy::Button2Click(TObject *Sender)
{
	BitBtn1->Visible = true;
	BitBtn2->Visible = true;

	DebugPanel->Visible = false;
}
//---------------------------------------------------------------------------

void __fastcall TFirstStudy::SideImage1DblClick(TObject *Sender)
{
	TImage *tempImage = (TImage*)Sender;

	Image1->Picture->Bitmap->Assign(tempImage->Picture->Bitmap);
	Image1->Refresh();
}
//---------------------------------------------------------------------------

void __fastcall TFirstStudy::InitialSideFaceProcessingDebugData()
{
	const int MAX_DEBUG_DATA_INDEX = 3;

	memset(XAngleMatchingResultData, 0, sizeof(int) * (MAX_ANGLE1_RANGE * 2 + 1));
	memset(YAngleMatchingResultData, 0, sizeof(int) * (MAX_ANGLE2_RANGE * 2 + 1));
	memset(ZAngleMatchingResultData, 0, sizeof(int) * (MAX_ANGLE3_RANGE * 2 + 1));

	XAngleMatchingResultChart->BottomAxis->Maximum = MAX_ANGLE1_RANGE * 2 + 1;
	YAngleMatchingResultChart->BottomAxis->Maximum = MAX_ANGLE2_RANGE * 2 + 1;
	ZAngleMatchingResultChart->BottomAxis->Maximum = MAX_ANGLE3_RANGE * 2 + 1;

	for (int dataIndex = 1; dataIndex <= MAX_DEBUG_DATA_INDEX; dataIndex++)
	{
		TLabel *ImageIndexLabel = (TLabel *)FindComponent("SideFaceImageIndexLabel" + IntToStr(dataIndex));

		if (ImageIndexLabel)
		{
			ImageIndexLabel->Caption = "#" + IntToStr(dataIndex) + " Image";
            //ImageIndexLabel->Caption = "#" + IntToStr(dataIndex) + FIRSTSTUDYFORM_LABEL_CAPTION_09;
		}
	}

	for (int dataIndex = 1; dataIndex <= MAX_DEBUG_DATA_INDEX; dataIndex++)
	{
		TImage *dstImage = (TImage *)FindComponent("SideFaceGradientImage" + IntToStr(dataIndex));

		if (dstImage)
		{
			dstImage->Canvas->Brush->Color = clBlue;
			dstImage->Canvas->Brush->Style = bsSolid;
			dstImage->Canvas->FillRect(Rect(0, 0, dstImage->Picture->Bitmap->Width, dstImage->Picture->Bitmap->Height));
		}
	}

	for (int dataIndex = 1; dataIndex <= MAX_DEBUG_DATA_INDEX; dataIndex++)
	{
		TImage *dstImage = (TImage *)FindComponent("SideFaceBinaryImage" + IntToStr(dataIndex));

		if (dstImage)
		{
			dstImage->Canvas->Brush->Color = clBlue;
			dstImage->Canvas->Brush->Style = bsSolid;
			dstImage->Canvas->FillRect(Rect(0, 0, dstImage->Picture->Bitmap->Width, dstImage->Picture->Bitmap->Height));
		}
	}

	for (int dataIndex = 1; dataIndex <= MAX_DEBUG_DATA_INDEX; dataIndex++)
	{
		TLabel *tempLabel = (TLabel *)FindComponent("SideFaceXAngleMatchingResult" + IntToStr(dataIndex));

		if (tempLabel)
		{
			//tempLabel->Caption = "Result X Angle : ";
            tempLabel->Caption = FIRSTSTUDYFORM_LABEL_CAPTION_13;
		}
	}

	for (int dataIndex = 1; dataIndex <= MAX_DEBUG_DATA_INDEX; dataIndex++)
	{
		TLabel *tempLabel = (TLabel *)FindComponent("SideFaceYAngleMatchingResult" + IntToStr(dataIndex));

		if (tempLabel)
		{
			//tempLabel->Caption = "Result Y Angle : ";
            tempLabel->Caption = FIRSTSTUDYFORM_LABEL_CAPTION_14;
		}
	}

	for (int dataIndex = 1; dataIndex <= MAX_DEBUG_DATA_INDEX; dataIndex++)
	{
		TLabel *tempLabel = (TLabel *)FindComponent("SideFaceZAngleMatchingResult" + IntToStr(dataIndex));

		if (tempLabel)
		{
			//tempLabel->Caption = "Result Z Angle : ";
            tempLabel->Caption = FIRSTSTUDYFORM_LABEL_CAPTION_15;
		}
	}

	for (int dataIndex = 1; dataIndex <= MAX_DEBUG_DATA_INDEX; dataIndex++)
	{
		TLabel *tempLabel = (TLabel *)FindComponent("SideFaceShiftXMatchingResult" + IntToStr(dataIndex));

		if (tempLabel)
		{
			//tempLabel->Caption = "Result X : ";
            tempLabel->Caption = FIRSTSTUDYFORM_LABEL_CAPTION_10;
		}
	}

	for (int dataIndex = 1; dataIndex <= MAX_DEBUG_DATA_INDEX; dataIndex++)
	{
		TLabel *tempLabel = (TLabel *)FindComponent("SideFaceShiftYMatchingResult" + IntToStr(dataIndex));

		if (tempLabel)
		{
			//tempLabel->Caption = "Result Y : ";
            tempLabel->Caption = FIRSTSTUDYFORM_LABEL_CAPTION_11;
		}
	}

	for (int dataIndex = 1; dataIndex <= MAX_DEBUG_DATA_INDEX; dataIndex++)
	{
		TLabel *tempLabel = (TLabel *)FindComponent("SideFaceResolution" + IntToStr(dataIndex));

		if (tempLabel)
		{
			//tempLabel->Caption = "Resolution : ";
            tempLabel->Caption = FIRSTSTUDYFORM_LABEL_CAPTION_12;
		}
	}


  if(!(TabletCharacter.shape == ROUND || TabletCharacter.shape == OBLONG || TabletCharacter.shape == OVAL))
  {
    Panel3->Visible = false;
    XAngleMatchingResultChart->Visible = false;
    YAngleMatchingResultChart->Visible = false;
    ZAngleMatchingResultChart->Visible = false;

    SideFaceXAngleMatchingResult1->Visible = false;
    SideFaceXAngleMatchingResult2->Visible = false;
    SideFaceXAngleMatchingResult3->Visible = false;

    SideFaceYAngleMatchingResult1->Visible = false;
    SideFaceYAngleMatchingResult2->Visible = false;
    SideFaceYAngleMatchingResult3->Visible = false;

    SideFaceZAngleMatchingResult1->Visible = false;
    SideFaceZAngleMatchingResult2->Visible = false;
    SideFaceZAngleMatchingResult3->Visible = false;

    SideFaceProcessingResultPanel->Height = 910;
  }
}


//---------------------------------------------------------------------------

void __fastcall TFirstStudy::SetSideFaceProcessingDebugData(int ImageIndex, int cameraIndex)
{
	if(TabletCharacter.kind == SUGARCOATING)
  {
    Graphics::TBitmap *ResultImage = new Graphics::TBitmap;
    ResultImage->Width = MAX_IMAGE_WIDTH;
    ResultImage->Height = MAX_IMAGE_HEIGHT;
    ResultImage->PixelFormat = pf24bit;

    int tempAddress;
    int x, y;
    Byte *ptr, *ptr2;

    for(y = 0; y < MAX_IMAGE_HEIGHT; y++)
    {
      ptr = (Byte*)ResultImage->ScanLine[y];
      ptr2 = (Byte*)Image1->Picture->Bitmap->ScanLine[y];
      for(x = 0; x < MAX_IMAGE_WIDTH; x++)
      {
        tempAddress = MAX_IMAGE_WIDTH * y + x;

        if(ShapeBinaryImage[tempAddress])
        {
          ptr[3*x + 0] = min(255, ptr2[3*x + 0] * 2);
          ptr[3*x + 1] = min(255, ptr2[3*x + 1] * 2);
          ptr[3*x + 2] = min(255, ptr2[3*x + 2] * 2);
        }
        else
        {
          ptr[3*x + 0] = ptr2[3*x + 0];
          ptr[3*x + 1] = ptr2[3*x + 1];
          ptr[3*x + 2] = ptr2[3*x + 2];
        }
      }
    }

    Image1->Picture->Bitmap->Assign(ResultImage);
    Image1->Refresh();

    delete ResultImage;
  }
  else
  {
    if(TabletCharacter.shape == ROUND || TabletCharacter.shape == OBLONG || TabletCharacter.shape == OVAL)
    {
      XAngleMatchingResultData[TabletMatchingResult.TabletSideShapeXTotion]++;
      YAngleMatchingResultData[TabletMatchingResult.TabletSideShapeYTotion]++;
      ZAngleMatchingResultData[TabletMatchingResult.TabletSideShapeZTotion]++;

      XAngleMatchingResultChart->Series[0]->Clear();
      XAngleMatchingResultChart->Series[1]->Clear();

      YAngleMatchingResultChart->Series[0]->Clear();
      YAngleMatchingResultChart->Series[1]->Clear();

      ZAngleMatchingResultChart->Series[0]->Clear();
      ZAngleMatchingResultChart->Series[1]->Clear();

      for(int dataIndex = 0; dataIndex <= MAX_ANGLE1_RANGE * 2; dataIndex++)
      {
        XAngleMatchingResultChart->Series[0]->Add(XAngleMatchingResultData[dataIndex]);
      }
      XAngleMatchingResultChart->Repaint();

      for(int dataIndex = 0; dataIndex <= MAX_ANGLE2_RANGE * 2; dataIndex++)
      {
        YAngleMatchingResultChart->Series[0]->Add(YAngleMatchingResultData[dataIndex]);
      }
      YAngleMatchingResultChart->Repaint();

      for(int dataIndex = 0; dataIndex <= MAX_ANGLE3_RANGE * 2; dataIndex++)
      {
        ZAngleMatchingResultChart->Series[0]->Add(ZAngleMatchingResultData[dataIndex]);
      }
      ZAngleMatchingResultChart->Repaint();


      int m;
      int tempX, tempY;
      int tempAddress;
      for(m = 0; m < finalMatchingShapeData.SideShapeEdgePointCountLeft; m++)
      {
        tempX = finalMatchingShapeData.SideShapeEdgePointLeft[m*2] + TabletMatchingResult.TabletSideShapeShiftX;
        tempY = finalMatchingShapeData.SideShapeEdgePointLeft[m*2+1] + TabletMatchingResult.TabletSideShapeShiftY;

        if(tempX > 0 && tempX < MAX_IMAGE_WIDTH && tempY > 0 && tempY < MAX_IMAGE_HEIGHT)
        {
          tempAddress = tempY * MAX_IMAGE_WIDTH + tempX;

          GradientImage[tempAddress] = 255;
          GradientImage[tempAddress-1] = 255;
          GradientImage[tempAddress+1] = 255;
          GradientImage[tempAddress-MAX_IMAGE_WIDTH] = 255;
          GradientImage[tempAddress+MAX_IMAGE_WIDTH] = 255;
        }
      }

      for(m = 0; m < finalMatchingShapeData.SideShapeEdgePointCountRight; m++)
      {
        tempX = finalMatchingShapeData.SideShapeEdgePointRight[m*2] + TabletMatchingResult.TabletSideShapeShiftX;
        tempY = finalMatchingShapeData.SideShapeEdgePointRight[m*2+1] + TabletMatchingResult.TabletSideShapeShiftY;

        if(tempX > 0 && tempX < MAX_IMAGE_WIDTH && tempY > 0 && tempY < MAX_IMAGE_HEIGHT)
        {
          tempAddress = tempY * MAX_IMAGE_WIDTH + tempX;

          GradientImage[tempAddress] = 255;
          GradientImage[tempAddress-1] = 255;
          GradientImage[tempAddress+1] = 255;
          GradientImage[tempAddress-MAX_IMAGE_WIDTH] = 255;
          GradientImage[tempAddress+MAX_IMAGE_WIDTH] = 255;
        }
      }

      for(m = 0; m < finalMatchingShapeData.SideShapeEdgePointCountBottom; m++)
      {
        tempX = finalMatchingShapeData.SideShapeEdgePointBottom[m*2] + TabletMatchingResult.TabletSideShapeShiftX;
        tempY = finalMatchingShapeData.SideShapeEdgePointBottom[m*2+1] + TabletMatchingResult.TabletSideShapeShiftY;

        if(tempX > 0 && tempX < MAX_IMAGE_WIDTH && tempY > 0 && tempY < MAX_IMAGE_HEIGHT)
        {
          tempAddress = tempY * MAX_IMAGE_WIDTH + tempX;

          GradientImage[tempAddress] = 255;
          GradientImage[tempAddress-1] = 255;
          GradientImage[tempAddress+1] = 255;
          GradientImage[tempAddress-MAX_IMAGE_WIDTH] = 255;
          GradientImage[tempAddress+MAX_IMAGE_WIDTH] = 255;
        }
      }

      for(m = 0; m < finalMatchingShapeData.SideShapeEdgePointCountBottom; m++)
      {
        tempX = finalMatchingShapeData.SideShapeEdgePointBottom[m*2] + TabletMatchingResult.TabletSideShapeShiftX + TabletMatchingResult.TabletSideShapeTopLineShiftX;
        tempY = finalMatchingShapeData.SideShapeEdgePointBottom[m*2+1] + TabletMatchingResult.TabletSideShapeShiftY + TabletMatchingResult.TabletSideShapeTopLineShiftY;

        if(tempX > 0 && tempX < MAX_IMAGE_WIDTH && tempY > 0 && tempY < MAX_IMAGE_HEIGHT)
        {
          tempAddress = tempY * MAX_IMAGE_WIDTH + tempX;

          GradientImage[tempAddress] = 255;
          GradientImage[tempAddress-1] = 255;
          GradientImage[tempAddress+1] = 255;
          GradientImage[tempAddress-MAX_IMAGE_WIDTH] = 255;
          GradientImage[tempAddress+MAX_IMAGE_WIDTH] = 255;
        }
      }

      int DestDataIndex = (ImageIndex - 1) % 3 + 1;
      TLabel *tempLabel;
      TImage *dstImage;

      Graphics::TBitmap *ResultImage = new Graphics::TBitmap;
      ResultImage->Width = MAX_IMAGE_WIDTH;
      ResultImage->Height = MAX_IMAGE_HEIGHT;
      ResultImage->PixelFormat = pf24bit;

      int x, y;
      Byte *ptr;


      tempLabel = (TLabel *)FindComponent("SideFaceImageIndexLabel" + IntToStr(DestDataIndex));
      if(tempLabel)
      {
        tempLabel->Caption = "#" + IntToStr(ImageIndex) + " Image";
      }

      dstImage = (TImage *)FindComponent("SideFaceGradientImage" + IntToStr(DestDataIndex));
      if(dstImage)
      {
        for(y = 0; y < MAX_IMAGE_HEIGHT; y++)
        {
          ptr = (Byte*)ResultImage->ScanLine[y];
          for(x = 0; x < MAX_IMAGE_WIDTH; x++)
          {
            tempAddress = MAX_IMAGE_WIDTH * y + x;

            ptr[3*x + 0] = GradientImage[tempAddress];
            ptr[3*x + 1] = GradientImage[tempAddress];
            ptr[3*x + 2] = GradientImage[tempAddress];
          }
        }

        dstImage->Picture->Bitmap->Assign(ResultImage);
        dstImage->Canvas->Pen->Width = 3;
        dstImage->Canvas->Pen->Color = clWhite;
        dstImage->Canvas->Brush->Style = bsClear;
        dstImage->Canvas->Rectangle(0, 0, MAX_IMAGE_WIDTH, MAX_IMAGE_HEIGHT);
        dstImage->Refresh();
      }

      dstImage = (TImage *)FindComponent("SideFaceBinaryImage" + IntToStr(DestDataIndex));
      if(dstImage)
      {
        for(y = 0; y < MAX_IMAGE_HEIGHT; y++)
        {
          ptr = (Byte*)ResultImage->ScanLine[y];
          for(x = 0; x < MAX_IMAGE_WIDTH; x++)
          {
            tempAddress = MAX_IMAGE_WIDTH * y + x;

            if(ShapeBinaryImage[tempAddress])
            {
              ptr[3*x + 0] = min(255, ColorSourceImage[tempAddress * 3 + 0] * 2);
              ptr[3*x + 1] = min(255, ColorSourceImage[tempAddress * 3 + 1] * 2);
              ptr[3*x + 2] = min(255, ColorSourceImage[tempAddress * 3 + 2] * 2);
            }
            else
            {
              ptr[3*x + 0] = 0;
              ptr[3*x + 1] = 0;
              ptr[3*x + 2] = 0;
            }
          }
        }

        dstImage->Picture->Bitmap->Assign(ResultImage);
        dstImage->Canvas->Pen->Width = 3;
        dstImage->Canvas->Pen->Color = clWhite;
        dstImage->Canvas->Brush->Style = bsClear;
        dstImage->Canvas->Rectangle(0, 0, MAX_IMAGE_WIDTH, MAX_IMAGE_HEIGHT);
        dstImage->Refresh();
      }

      tempLabel = (TLabel *)FindComponent("SideFaceXAngleMatchingResult" + IntToStr(DestDataIndex));
      if(tempLabel)
      {
        tempLabel->Caption = FIRSTSTUDYFORM_LABEL_CAPTION_13 + IntToStr(TabletMatchingResult.TabletSideShapeXTotion);
      }

      tempLabel = (TLabel *)FindComponent("SideFaceYAngleMatchingResult" + IntToStr(DestDataIndex));
      if(tempLabel)
      {
        tempLabel->Caption = FIRSTSTUDYFORM_LABEL_CAPTION_14 + IntToStr(TabletMatchingResult.TabletSideShapeYTotion);
      }

      tempLabel = (TLabel *)FindComponent("SideFaceZAngleMatchingResult" + IntToStr(DestDataIndex));
      if(tempLabel)
      {
        tempLabel->Caption = FIRSTSTUDYFORM_LABEL_CAPTION_15 + IntToStr(TabletMatchingResult.TabletSideShapeZTotion);
      }

      tempLabel = (TLabel *)FindComponent("SideFaceShiftXMatchingResult" + IntToStr(DestDataIndex));
      if(tempLabel)
      {
        tempLabel->Caption = FIRSTSTUDYFORM_LABEL_CAPTION_10 + IntToStr(TabletMatchingResult.TabletSideShapeShiftX);
      }

      tempLabel = (TLabel *)FindComponent("SideFaceShiftYMatchingResult" + IntToStr(DestDataIndex));
      if(tempLabel)
      {
        tempLabel->Caption = FIRSTSTUDYFORM_LABEL_CAPTION_11 + IntToStr(TabletMatchingResult.TabletSideShapeShiftY);
      }

      tempLabel = (TLabel *)FindComponent("SideFaceResolution" + IntToStr(DestDataIndex));
      if(tempLabel)
      {
        tempLabel->Caption = FIRSTSTUDYFORM_LABEL_CAPTION_12 + IntToStr(TabletSetupData.cameraZoom[cameraIndex - 1]);
      }

      delete ResultImage;
    }
    else
    {
      int m;
      int tempX, tempY;
      int tempAddress;
      for(m = 0; m < TabletETCMatchingResult.tabletShapeLeftLineCount; m++)
      {
        tempX = TabletETCMatchingResult.tabletShapeLeftLine[m * 2 + 0];
        tempY = TabletETCMatchingResult.tabletShapeLeftLine[m * 2 + 1];

        if(tempX > 0 && tempX < MAX_IMAGE_WIDTH && tempY > 0 && tempY < MAX_IMAGE_HEIGHT)
        {
          tempAddress = tempY * MAX_IMAGE_WIDTH + tempX;

          GradientImageForFstStudy[tempAddress] = 255;
          GradientImageForFstStudy[tempAddress-1] = 255;
          GradientImageForFstStudy[tempAddress+1] = 255;
          GradientImageForFstStudy[tempAddress-MAX_IMAGE_WIDTH] = 255;
          GradientImageForFstStudy[tempAddress+MAX_IMAGE_WIDTH] = 255;
        }
      }

      for(m = 0; m < TabletETCMatchingResult.tabletShapeRightLineCount; m++)
      {
        tempX = TabletETCMatchingResult.tabletShapeRightLine[m * 2 + 0];
        tempY = TabletETCMatchingResult.tabletShapeRightLine[m * 2 + 1];

        if(tempX > 0 && tempX < MAX_IMAGE_WIDTH && tempY > 0 && tempY < MAX_IMAGE_HEIGHT)
        {
          tempAddress = tempY * MAX_IMAGE_WIDTH + tempX;

          GradientImageForFstStudy[tempAddress] = 255;
          GradientImageForFstStudy[tempAddress-1] = 255;
          GradientImageForFstStudy[tempAddress+1] = 255;
          GradientImageForFstStudy[tempAddress-MAX_IMAGE_WIDTH] = 255;
          GradientImageForFstStudy[tempAddress+MAX_IMAGE_WIDTH] = 255;
        }
      }

      for(m = 0; m < TabletETCMatchingResult.tabletShapeBottomLineCount; m++)
      {
        tempX = TabletETCMatchingResult.tabletShapeBottomLine[m * 2 + 0];
        tempY = TabletETCMatchingResult.tabletShapeBottomLine[m * 2 + 1];

        if(tempX > 0 && tempX < MAX_IMAGE_WIDTH && tempY > 0 && tempY < MAX_IMAGE_HEIGHT)
        {
          tempAddress = tempY * MAX_IMAGE_WIDTH + tempX;

          GradientImageForFstStudy[tempAddress] = 255;
          GradientImageForFstStudy[tempAddress-1] = 255;
          GradientImageForFstStudy[tempAddress+1] = 255;
          GradientImageForFstStudy[tempAddress-MAX_IMAGE_WIDTH] = 255;
          GradientImageForFstStudy[tempAddress+MAX_IMAGE_WIDTH] = 255;
        }
      }

      for(m = 0; m < TabletETCMatchingResult.tabletShapeTopLineCount; m++)
      {
        tempX = TabletETCMatchingResult.tabletShapeTopLine[m * 2 + 0];
        tempY = TabletETCMatchingResult.tabletShapeTopLine[m * 2 + 1];

        if(tempX > 0 && tempX < MAX_IMAGE_WIDTH && tempY > 0 && tempY < MAX_IMAGE_HEIGHT)
        {
          tempAddress = tempY * MAX_IMAGE_WIDTH + tempX;

          GradientImageForFstStudy[tempAddress] = 255;
          GradientImageForFstStudy[tempAddress-1] = 255;
          GradientImageForFstStudy[tempAddress+1] = 255;
          GradientImageForFstStudy[tempAddress-MAX_IMAGE_WIDTH] = 255;
          GradientImageForFstStudy[tempAddress+MAX_IMAGE_WIDTH] = 255;
        }
      }

      int DestDataIndex = (ImageIndex - 1) % 3 + 1;
      TLabel *tempLabel;
      TImage *dstImage;

      Graphics::TBitmap *ResultImage = new Graphics::TBitmap;
      ResultImage->Width = MAX_IMAGE_WIDTH;
      ResultImage->Height = MAX_IMAGE_HEIGHT;
      ResultImage->PixelFormat = pf24bit;

      int x, y;
      Byte *ptr;

      tempLabel = (TLabel *)FindComponent("SideFaceImageIndexLabel" + IntToStr(DestDataIndex));
      if(tempLabel)
      {
        tempLabel->Caption = "#" + IntToStr(ImageIndex) + " Image";
      }

      dstImage = (TImage *)FindComponent("SideFaceGradientImage" + IntToStr(DestDataIndex));
      if(dstImage)
      {
        for(y = 0; y < MAX_IMAGE_HEIGHT; y++)
        {
          ptr = (Byte*)ResultImage->ScanLine[y];
          for(x = 0; x < MAX_IMAGE_WIDTH; x++)
          {
            tempAddress = MAX_IMAGE_WIDTH * y + x;

            ptr[3*x + 0] = GradientImageForFstStudy[tempAddress];
            ptr[3*x + 1] = GradientImageForFstStudy[tempAddress];
            ptr[3*x + 2] = GradientImageForFstStudy[tempAddress];
          }
        }

        dstImage->Picture->Bitmap->Assign(ResultImage);
        dstImage->Canvas->Pen->Width = 3;
        dstImage->Canvas->Pen->Color = clWhite;
        dstImage->Canvas->Brush->Style = bsClear;
        dstImage->Canvas->Rectangle(0, 0, MAX_IMAGE_WIDTH, MAX_IMAGE_HEIGHT);
        dstImage->Refresh();
      }

      dstImage = (TImage *)FindComponent("SideFaceBinaryImage" + IntToStr(DestDataIndex));
      if(dstImage)
      {
        for(y = 0; y < MAX_IMAGE_HEIGHT; y++)
        {
          ptr = (Byte*)ResultImage->ScanLine[y];
          for(x = 0; x < MAX_IMAGE_WIDTH; x++)
          {
            tempAddress = MAX_IMAGE_WIDTH * y + x;

            if(ShapeBinaryImage[tempAddress])
            {
              ptr[3*x + 0] = min(255, ColorSourceImage[tempAddress * 3 + 0] * 2);
              ptr[3*x + 1] = min(255, ColorSourceImage[tempAddress * 3 + 1] * 2);
              ptr[3*x + 2] = min(255, ColorSourceImage[tempAddress * 3 + 2] * 2);
            }
            else
            {
              ptr[3*x + 0] = 0;
              ptr[3*x + 1] = 0;
              ptr[3*x + 2] = 0;
            }
          }
        }

        dstImage->Picture->Bitmap->Assign(ResultImage);
        dstImage->Canvas->Pen->Width = 3;
        dstImage->Canvas->Pen->Color = clWhite;
        dstImage->Canvas->Brush->Style = bsClear;
        dstImage->Canvas->Rectangle(0, 0, MAX_IMAGE_WIDTH, MAX_IMAGE_HEIGHT);
        dstImage->Refresh();
      }

      tempLabel = (TLabel *)FindComponent("SideFaceShiftXMatchingResult" + IntToStr(DestDataIndex));
      if(tempLabel)
      {
        tempLabel->Caption = FIRSTSTUDYFORM_LABEL_CAPTION_10 + IntToStr(TabletETCMatchingResult.tabletCenterX);
      }

      tempLabel = (TLabel *)FindComponent("SideFaceShiftYMatchingResult" + IntToStr(DestDataIndex));
      if(tempLabel)
      {
        tempLabel->Caption = FIRSTSTUDYFORM_LABEL_CAPTION_11 + IntToStr(TabletETCMatchingResult.tabletCenterY);
      }

      tempLabel = (TLabel *)FindComponent("SideFaceResolution" + IntToStr(DestDataIndex));
      if(tempLabel)
      {
        tempLabel->Caption = FIRSTSTUDYFORM_LABEL_CAPTION_12 + IntToStr(TabletSetupData.cameraZoom[cameraIndex - 1]);
      }

      delete ResultImage;
    }
  }
}
//---------------------------------------------------------------------------

void __fastcall TFirstStudy::TntFormClose(TObject *Sender,
	TCloseAction &Action)
{
	DeleteDebugComponent();
}
//---------------------------------------------------------------------------

int __fastcall TFirstStudy::GetTabletAreaInfo(int cameraIndex)
{
	int m, x, y;
	unsigned short sizeTransform[2000][2];

	unsigned short firstTransformForFace1[2000][3];
	unsigned short firstTransformForFace2[2000][3];

	unsigned short SecondTransformForFace1[2000][3];
	unsigned short SecondTransformForFace2[2000][3];

	unsigned short transfarentEdgeDataPoint[2000][3];
	unsigned short transfarentEdgeDataPoint2[2000][3];
	unsigned char unVisibleEdgeLineCheck[2000];
	unsigned char weightCheck[2000];

	int tempX, tempY;
	int tabletCenterX, tabletCenterY, tabletCenterZ;
	int startX1, startY1, endX1, endY1;
	int startX2, startY2, endX2, endY2;
	int start_Number, end_Number;
	int face1Height, face2Height;
	int weightValue;
	unsigned short tempRotationCheckPosition[2000][2];
	int sysCameraIndex;
	int diffColor[3];
	int shiftMinX, shiftMaxX;
	int dataLength;
	int edgeMinX, edgeMaxX, edgeMinY;
	int tShiftX;
	int sX;
	int shiftLimit;
	int tempIndex;
	int shapeEndY;

	// For SELMA200, Rev by moon. (20180209) Camera Index
	const int HALF_CAMERA_INDEX = 9;
	const int MODULE1_2D_CAM_INDEX = 1;
	const int MODULE1_3D_CAM_INDEX = 5;
	const int MODULE2_2D_CAM_INDEX = 9;
	const int MODULE2_3D_CAM_INDEX = 13;

	int FrontFaceCameraResolution;
	int SideFaceCameraResolution;
	int adjustMiddleHeight;
	int adjustTabletHeight;
	int tempCount1, tempCount2;
	int tempShiftX, tempShiftY;
	int gradSum;
	int maxValue;
	int i, j;
	int startX, endX, startY, endY;
	int tempAddress;
	int tempTabletMatchingRes;
	int tempTabletMatchingShiftX;
	int tempTabletMatchingShiftY;
	int tempTabletMatchingTopLineShiftX;
	int tempTabletMatchingTopLineShiftY;
	int tempTabletMatchingTotionX;
	int tempTabletMatchingTotionY;
	int tempTabletMatchingTotionZ;
	int k, q;
	int gradSum2;
	int gradSum3;
	int topLineShiftSize;
	int matchingCount;
	int maxValue2;
	int maxGradValue;

	int XZeroPos = 60 + MAX_ANGLE1_RANGE * 2;

	int convCamIndex;

	topLineShiftSize = 10;

	startX = 10;
	endX = MAX_IMAGE_WIDTH - 10;
	startY = 10;
	endY = MAX_IMAGE_HEIGHT - 10;

	if (TabletCharacter.middle_height != 0)
	{
		if (cameraIndex < HALF_CAMERA_INDEX) // SELMA200....
		{
			if (cameraIndex < MODULE1_3D_CAM_INDEX)
			{
				tempIndex = 2;
			}
			else
			{
				tempIndex = 3;
			}
		}
		else
		{
			if (cameraIndex < MODULE2_3D_CAM_INDEX)
			{
				tempIndex = 4;
			}
			else
			{
				tempIndex = 5;
			}
		}

		memset(firstTransformForFace1, 0, sizeof(unsigned short) * 2000 * 3);
		memset(firstTransformForFace2, 0, sizeof(unsigned short) * 2000 * 3);

		memset(SecondTransformForFace1, 0, sizeof(unsigned short) * 2000 * 3);
		memset(SecondTransformForFace2, 0, sizeof(unsigned short) * 2000 * 3);

		memset(transfarentEdgeDataPoint, 0, sizeof(unsigned short) * 2000 * 3);
		memset(transfarentEdgeDataPoint2, 0, sizeof(unsigned short) * 2000 * 3);

		maxValue = 0;

		convCamIndex = (cameraIndex - 1) % 4 + 1;

		FrontFaceCameraResolution = TabletSetupData.cameraZoom[0];
		SideFaceCameraResolution = TabletSetupData.cameraZoom[convCamIndex - 1];

		for (m = 0; m < TabletSetupData.FrontShapeEdgePointCount; m++)
		{
			sizeTransform[m][0] = (TabletSetupData.FrontShapeEdgePoint[m][0] - MAX_IMAGE_WIDTH / 2) * FrontFaceCameraResolution / SideFaceCameraResolution + MAX_IMAGE_WIDTH / 2;
			sizeTransform[m][1] = (TabletSetupData.FrontShapeEdgePoint[m][1] - MAX_IMAGE_WIDTH / 2) * FrontFaceCameraResolution / SideFaceCameraResolution + MAX_IMAGE_WIDTH / 2;
		}

		adjustMiddleHeight = TabletCharacter.middle_height * FrontFaceCameraResolution / SideFaceCameraResolution;
		adjustTabletHeight = TabletCharacter.height * FrontFaceCameraResolution / SideFaceCameraResolution;

		memset(RotationEdgeImage, 0, MAX_IMAGE_WIDTH*MAX_IMAGE_WIDTH * 2);
		memset(unVisibleEdgeLineCheck, 0, 2000);
		memset(tempRotationCheckPosition, 0, 2000 * 2 * 2);

		startX1 = 1000;
		endX1 = -1;
		for (m = 0; m < TabletSetupData.FrontShapeEdgePointCount; m++)
		{
			// For SELMA200, Rev by moon. (20180209) Camera Index
			if (cameraIndex == SD1_2D_SIDE_FACE_M45_CAMERA_INDEX ||
				cameraIndex == SD2_2D_SIDE_FACE_M45_CAMERA_INDEX ||
				cameraIndex == SD1_2D_OTHER_SIDE_FACE_M45_CAMERA_INDEX ||
				cameraIndex == SD2_2D_OTHER_SIDE_FACE_M45_CAMERA_INDEX)
			{
				tempX = ((sizeTransform[m][0] - MAX_IMAGE_WIDTH / 2)*CosData[SIDE_CAMERA_ANGLE * 2] + (sizeTransform[m][1] - MAX_IMAGE_WIDTH / 2)*SinData[SIDE_CAMERA_ANGLE * 2]) / 1024 + MAX_IMAGE_WIDTH / 2;
				tempY = (-(sizeTransform[m][0] - MAX_IMAGE_WIDTH / 2)*SinData[SIDE_CAMERA_ANGLE * 2] + (sizeTransform[m][1] - MAX_IMAGE_WIDTH / 2)*CosData[SIDE_CAMERA_ANGLE * 2]) / 1024 + MAX_IMAGE_WIDTH / 2;
			}
			else if (cameraIndex == SD1_2D_SIDE_FACE_00_CAMERA_INDEX ||
				cameraIndex == SD2_2D_SIDE_FACE_00_CAMERA_INDEX ||
				cameraIndex == SD1_2D_OTHER_SIDE_FACE_00_CAMERA_INDEX ||
				cameraIndex == SD2_2D_OTHER_SIDE_FACE_00_CAMERA_INDEX)
			{
				tempX = ((sizeTransform[m][0] - MAX_IMAGE_WIDTH / 2)*CosData[0] - (sizeTransform[m][1] - MAX_IMAGE_WIDTH / 2)*SinData[0]) / 1024 + MAX_IMAGE_WIDTH / 2;
				tempY = ((sizeTransform[m][0] - MAX_IMAGE_WIDTH / 2)*SinData[0] + (sizeTransform[m][1] - MAX_IMAGE_WIDTH / 2)*CosData[0]) / 1024 + MAX_IMAGE_WIDTH / 2;
			}
			else if (cameraIndex == SD1_2D_SIDE_FACE_P45_CAMERA_INDEX ||
				cameraIndex == SD2_2D_SIDE_FACE_P45_CAMERA_INDEX ||
				cameraIndex == SD1_2D_OTHER_SIDE_FACE_P45_CAMERA_INDEX ||
				cameraIndex == SD2_2D_OTHER_SIDE_FACE_P45_CAMERA_INDEX)
			{
				tempX = ((sizeTransform[m][0] - MAX_IMAGE_WIDTH / 2)*CosData[SIDE_CAMERA_ANGLE * 2] - (sizeTransform[m][1] - MAX_IMAGE_WIDTH / 2)*SinData[SIDE_CAMERA_ANGLE * 2]) / 1024 + MAX_IMAGE_WIDTH / 2;
				tempY = ((sizeTransform[m][0] - MAX_IMAGE_WIDTH / 2)*SinData[SIDE_CAMERA_ANGLE * 2] + (sizeTransform[m][1] - MAX_IMAGE_WIDTH / 2)*CosData[SIDE_CAMERA_ANGLE * 2]) / 1024 + MAX_IMAGE_WIDTH / 2;
			}

			if (startX1 > tempX)
			{
				start_Number = m;
				startX1 = tempX;
				startY1 = tempY;
			}
			else if (startX1 == tempX)
			{
				if (startY1 > tempY)
				{
					start_Number = m;
					startX1 = tempX;
					startY1 = tempY;
				}
			}
			if (endX1 <= tempX)
			{
				end_Number = m;
				endX1 = tempX;
				endY1 = tempY;
			}
			else if (endX1 == tempX)
			{
				if (endY1 > tempY)
				{
					start_Number = m;
					endX1 = tempX;
					endY1 = tempY;
				}
			}

			if (tempX > 0 && tempX < MAX_IMAGE_WIDTH && tempY > 0 && tempY < MAX_IMAGE_WIDTH)
			{
				RotationEdgeImage[tempY*MAX_IMAGE_WIDTH + tempX] = m;
				tempRotationCheckPosition[m][0] = tempX;
				tempRotationCheckPosition[m][1] = tempY;
			}
		}

		for (x = 1; x < MAX_IMAGE_WIDTH - 1; x++)
		{
			for (y = MAX_IMAGE_WIDTH - 1; y >= 1; y--)
			{

				if (RotationEdgeImage[y * 640 + x])
				{
					unVisibleEdgeLineCheck[RotationEdgeImage[y*MAX_IMAGE_WIDTH + x]] = 1;
					break;
				}
				if (RotationEdgeImage[y * 640 + x - 1])
				{
					unVisibleEdgeLineCheck[RotationEdgeImage[y*MAX_IMAGE_WIDTH + x - 1]] = 1;
					break;
				}
				if (RotationEdgeImage[y * 640 + x + 1])
				{
					unVisibleEdgeLineCheck[RotationEdgeImage[y*MAX_IMAGE_WIDTH + x + 1]] = 1;
					break;
				}
			}
		}

		for (m = 0; m < TabletSetupData.FrontShapeEdgePointCount; m++)
		{
			tempX = tempRotationCheckPosition[m][0];
			tempY = tempRotationCheckPosition[m][1];
			RotationEdgeImage[tempY*MAX_IMAGE_WIDTH + tempX] = 0;
		}

		for (y = 0; y < MAX_IMAGE_WIDTH; y++)
		{
			for (x = startX1 - 20; x <= startX1 + 20; x++)
			{
				if (x >= 0 && x < MAX_IMAGE_WIDTH && y >= 0 && y < MAX_IMAGE_WIDTH)
				{
					RotationEdgeImage[y*MAX_IMAGE_WIDTH + x] = 1;
				}
			}
		}

		for (y = 0; y < MAX_IMAGE_WIDTH; y++)
		{
			for (x = startX1 - 20; x <= startX1 + 20; x++)
			{
				if (x >= 0 && x < MAX_IMAGE_WIDTH && y >= 0 && y < MAX_IMAGE_WIDTH)
				{
					RotationEdgeImage[y*MAX_IMAGE_WIDTH + x] = 0;
				}
			}
		}

		for (y = 0; y < MAX_IMAGE_WIDTH; y++)
		{
			for (x = endX1 - 20; x <= endX1 + 20; x++)
			{
				if (x >= 0 && x < MAX_IMAGE_WIDTH && y >= 0 && y < MAX_IMAGE_WIDTH)
				{
					RotationEdgeImage[y*MAX_IMAGE_WIDTH + x] = 1;
				}
			}
		}

		for (y = 0; y < MAX_IMAGE_WIDTH; y++)
		{
			for (x = endX1 - 20; x <= endX1 + 20; x++)
			{
				if (x >= 0 && x < MAX_IMAGE_WIDTH && y >= 0 && y < MAX_IMAGE_WIDTH)
				{
					RotationEdgeImage[y*MAX_IMAGE_WIDTH + x] = 0;
				}
			}
		}

		tabletCenterX = 320;
		tabletCenterY = 240;
		tabletCenterZ = 360;//TabletSetupData.DiskBaseHeightPosition[cameraIndex - 1];

		face1Height = tabletCenterZ - adjustMiddleHeight;// - (adjustTabletHeight - adjustMiddleHeight) / 2;
		face2Height = tabletCenterZ;// - (adjustTabletHeight - adjustMiddleHeight) / 2;

		for (m = 0; m < TabletSetupData.FrontShapeEdgePointCount; m++)
		{
			firstTransformForFace1[m][0] = sizeTransform[m][0];
			firstTransformForFace1[m][1] = ((sizeTransform[m][1] - tabletCenterY)*CosData[XZeroPos] - (face1Height - tabletCenterZ)*SinData[XZeroPos]) / 1024 + tabletCenterY;
			firstTransformForFace1[m][2] = ((sizeTransform[m][1] - tabletCenterY)*SinData[XZeroPos] + (face1Height - tabletCenterZ)*CosData[XZeroPos]) / 1024 + tabletCenterZ;
		}

		for (m = 0; m < TabletSetupData.FrontShapeEdgePointCount; m++)
		{
			firstTransformForFace2[m][0] = sizeTransform[m][0];
			firstTransformForFace2[m][1] = ((sizeTransform[m][1] - tabletCenterY)*CosData[XZeroPos] - (face2Height - tabletCenterZ)*SinData[XZeroPos]) / 1024 + tabletCenterY;
			firstTransformForFace2[m][2] = ((sizeTransform[m][1] - tabletCenterY)*SinData[XZeroPos] + (face2Height - tabletCenterZ)*CosData[XZeroPos]) / 1024 + tabletCenterZ;
		}

		for (m = 0; m < TabletSetupData.FrontShapeEdgePointCount; m++)
		{
			SecondTransformForFace1[m][1] = firstTransformForFace1[m][1];
			SecondTransformForFace1[m][0] = ((firstTransformForFace1[m][0] - tabletCenterX)*CosData[0] - (firstTransformForFace1[m][2] - tabletCenterZ)*SinData[0]) / 1024 + tabletCenterX;
			SecondTransformForFace1[m][2] = ((firstTransformForFace1[m][0] - tabletCenterX)*SinData[0] + (firstTransformForFace1[m][2] - tabletCenterZ)*CosData[0]) / 1024 + tabletCenterZ;
		}

		for (m = 0; m < TabletSetupData.FrontShapeEdgePointCount; m++)
		{
			SecondTransformForFace2[m][1] = firstTransformForFace2[m][1];
			SecondTransformForFace2[m][0] = ((firstTransformForFace2[m][0] - tabletCenterX)*CosData[0] - (firstTransformForFace2[m][2] - tabletCenterZ)*SinData[0]) / 1024 + tabletCenterX;
			SecondTransformForFace2[m][2] = ((firstTransformForFace2[m][0] - tabletCenterX)*SinData[0] + (firstTransformForFace2[m][2] - tabletCenterZ)*CosData[0]) / 1024 + tabletCenterZ;
		}

		// For SELMA200, Rev by moon. (20180209) Camera Index
		if (cameraIndex == SD1_2D_SIDE_FACE_M45_CAMERA_INDEX ||
			cameraIndex == SD2_2D_SIDE_FACE_M45_CAMERA_INDEX ||
			cameraIndex == SD1_2D_OTHER_SIDE_FACE_M45_CAMERA_INDEX ||
			cameraIndex == SD2_2D_OTHER_SIDE_FACE_M45_CAMERA_INDEX)
		{
			for (m = 0; m < TabletSetupData.FrontShapeEdgePointCount; m++)
			{
				transfarentEdgeDataPoint[m][0] = ((SecondTransformForFace1[m][0] - tabletCenterX)*CosData[SIDE_CAMERA_ANGLE * 2] + (SecondTransformForFace1[m][1] - tabletCenterY)*SinData[SIDE_CAMERA_ANGLE * 2]) / 1024 + tabletCenterX;
				transfarentEdgeDataPoint[m][1] = (-(SecondTransformForFace1[m][0] - tabletCenterX)*SinData[SIDE_CAMERA_ANGLE * 2] + (SecondTransformForFace1[m][1] - tabletCenterY)*CosData[SIDE_CAMERA_ANGLE * 2]) / 1024 + tabletCenterY;
				transfarentEdgeDataPoint[m][2] = SecondTransformForFace1[m][2];
			}
			for (m = 0; m < TabletSetupData.FrontShapeEdgePointCount; m++)
			{
				transfarentEdgeDataPoint2[m][0] = ((SecondTransformForFace2[m][0] - tabletCenterX)*CosData[SIDE_CAMERA_ANGLE * 2] + (SecondTransformForFace2[m][1] - tabletCenterY)*SinData[SIDE_CAMERA_ANGLE * 2]) / 1024 + tabletCenterX;
				transfarentEdgeDataPoint2[m][1] = (-(SecondTransformForFace2[m][0] - tabletCenterX)*SinData[SIDE_CAMERA_ANGLE * 2] + (SecondTransformForFace2[m][1] - tabletCenterY)*CosData[SIDE_CAMERA_ANGLE * 2]) / 1024 + tabletCenterY;
				transfarentEdgeDataPoint2[m][2] = SecondTransformForFace2[m][2];
			}
		}
		else if (cameraIndex == SD1_2D_SIDE_FACE_00_CAMERA_INDEX ||
			cameraIndex == SD2_2D_SIDE_FACE_00_CAMERA_INDEX ||
			cameraIndex == SD1_2D_OTHER_SIDE_FACE_00_CAMERA_INDEX ||
			cameraIndex == SD2_2D_OTHER_SIDE_FACE_00_CAMERA_INDEX)
		{
			for (m = 0; m < TabletSetupData.FrontShapeEdgePointCount; m++)
			{
				transfarentEdgeDataPoint[m][0] = ((SecondTransformForFace1[m][0] - tabletCenterX)*CosData[0] - (SecondTransformForFace1[m][1] - tabletCenterY)*SinData[0]) / 1024 + tabletCenterX;
				transfarentEdgeDataPoint[m][1] = ((SecondTransformForFace1[m][0] - tabletCenterX)*SinData[0] + (SecondTransformForFace1[m][1] - tabletCenterY)*CosData[0]) / 1024 + tabletCenterY;
				transfarentEdgeDataPoint[m][2] = SecondTransformForFace1[m][2];
			}
			for (m = 0; m < TabletSetupData.FrontShapeEdgePointCount; m++)
			{
				transfarentEdgeDataPoint2[m][0] = ((SecondTransformForFace2[m][0] - tabletCenterX)*CosData[0] - (SecondTransformForFace2[m][1] - tabletCenterY)*SinData[0]) / 1024 + tabletCenterX;
				transfarentEdgeDataPoint2[m][1] = ((SecondTransformForFace2[m][0] - tabletCenterX)*SinData[0] + (SecondTransformForFace2[m][1] - tabletCenterY)*CosData[0]) / 1024 + tabletCenterY;
				transfarentEdgeDataPoint2[m][2] = SecondTransformForFace2[m][2];
			}
		}
		else if (cameraIndex == SD1_2D_SIDE_FACE_P45_CAMERA_INDEX ||
			cameraIndex == SD2_2D_SIDE_FACE_P45_CAMERA_INDEX ||
			cameraIndex == SD1_2D_OTHER_SIDE_FACE_P45_CAMERA_INDEX ||
			cameraIndex == SD2_2D_OTHER_SIDE_FACE_P45_CAMERA_INDEX)
		{
			for (m = 0; m < TabletSetupData.FrontShapeEdgePointCount; m++)
			{
				transfarentEdgeDataPoint[m][0] = ((SecondTransformForFace1[m][0] - tabletCenterX)*CosData[SIDE_CAMERA_ANGLE * 2] - (SecondTransformForFace1[m][1] - tabletCenterY)*SinData[SIDE_CAMERA_ANGLE * 2]) / 1024 + tabletCenterX;
				transfarentEdgeDataPoint[m][1] = ((SecondTransformForFace1[m][0] - tabletCenterX)*SinData[SIDE_CAMERA_ANGLE * 2] + (SecondTransformForFace1[m][1] - tabletCenterY)*CosData[SIDE_CAMERA_ANGLE * 2]) / 1024 + tabletCenterY;
				transfarentEdgeDataPoint[m][2] = SecondTransformForFace1[m][2];
			}
			for (m = 0; m < TabletSetupData.FrontShapeEdgePointCount; m++)
			{
				transfarentEdgeDataPoint2[m][0] = ((SecondTransformForFace2[m][0] - tabletCenterX)*CosData[SIDE_CAMERA_ANGLE * 2] - (SecondTransformForFace2[m][1] - tabletCenterY)*SinData[SIDE_CAMERA_ANGLE * 2]) / 1024 + tabletCenterX;
				transfarentEdgeDataPoint2[m][1] = ((SecondTransformForFace2[m][0] - tabletCenterX)*SinData[SIDE_CAMERA_ANGLE * 2] + (SecondTransformForFace2[m][1] - tabletCenterY)*CosData[SIDE_CAMERA_ANGLE * 2]) / 1024 + tabletCenterY;
				transfarentEdgeDataPoint2[m][2] = SecondTransformForFace2[m][2];
			}
		}

		startX1 = transfarentEdgeDataPoint[start_Number][0];
		startY1 = transfarentEdgeDataPoint[start_Number][2];
		startX2 = transfarentEdgeDataPoint2[start_Number][0];
		startY2 = transfarentEdgeDataPoint2[start_Number][2];

		endX1 = transfarentEdgeDataPoint[end_Number][0];
		endY1 = transfarentEdgeDataPoint[end_Number][2];
		endX2 = transfarentEdgeDataPoint2[end_Number][0];
		endY2 = transfarentEdgeDataPoint2[end_Number][2];

		shapeEndY = 0;

		memset(TempImage, 0, MAX_IMAGE_WIDTH * MAX_IMAGE_HEIGHT);
		for (m = 0; m < TabletSetupData.FrontShapeEdgePointCount; m++)
		{
			tempX = transfarentEdgeDataPoint[m][0];
			tempY = transfarentEdgeDataPoint[m][2];

			tempAddress = MAX_IMAGE_WIDTH * tempY + tempX;
			TempImage[tempAddress] = 1;
		}

		for (y = startY1; y <= startY2; y++)
		{
			if ((startY1 - startY2))
			{
				tempX = (startX1 - startX2)*(y - startY1) / (startY1 - startY2) + startX1;

				tempAddress = MAX_IMAGE_WIDTH * y + tempX;
				TempImage[tempAddress] = 3;
			}
		}
		for (y = endY1; y <= endY2; y++)
		{
			if ((endY1 - endY2))
			{
				tempX = (endX1 - endX2)*(y - endY1) / (endY1 - endY2) + endX1;

				tempAddress = MAX_IMAGE_WIDTH * y + tempX;
				TempImage[tempAddress] = 4;
			}
		}

		int maxY, minY;
		minY = MAX_IMAGE_HEIGHT;
		maxY = 0;
		for (y = 0; y < MAX_IMAGE_HEIGHT; y++)
		{
			for (x = 0; x < MAX_IMAGE_WIDTH; x++)
			{
				if (TempImage[MAX_IMAGE_WIDTH * y + x])
				{
					if (minY > y) minY = y;
					if (maxY < y) maxY = y;
				}
			}
		}

		return abs(minY - maxY);
	}

	return 200;
}
//---------------------------------------------------------------------------

