//---------------------------------------------------------------------------
// For SELMA200, 20180223, moon, Ϸ
// CameraIndex  Ϸ
//---------------------------------------------------------------------------

#include <vcl.h>
#pragma hdrstop

#include "InspectionAreaRevision_Form.h"
#include "MultiLanguage.h"
#include "Environment.h"

#include <inifiles.hpp>

//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma link "TntButtons"
#pragma link "TntExtCtrls"
#pragma link "TntGrids"
#pragma link "TntStdCtrls"
#pragma resource "*.dfm"
TInspectionAreaRevisionForm *InspectionAreaRevisionForm;
//---------------------------------------------------------------------------
__fastcall TInspectionAreaRevisionForm::TInspectionAreaRevisionForm(TComponent* Owner)
  : TTntForm(Owner)
{
  if(ProductData.SubSamplingMode == 0)
  {
    CAM_Widht =  SYSTEM_CAMERA_WIDTH;
    CAM_Height =  SYSTEM_CAMERA_HEIGHT;
  }
  else
  {
    CAM_Widht =  SYSTEM_CAMERA_HD_WIDTH;
    CAM_Height =  SYSTEM_CAMERA_HD_HEIGHT;
  }
}
//---------------------------------------------------------------------------
void __fastcall TInspectionAreaRevisionForm::cameraBtnClick(
      TObject *Sender)
{
  if(!IsBoundarySettingMode)
    IsBoundarySettingMode = true;

  TTntSpeedButton *theSpeedButton = (TTntSpeedButton *) Sender;
  currentCameraIndex = theSpeedButton->Tag + 1;
  currentImageNumber = 1;
  ImageNumberEdit->Text = IntToStr(currentImageNumber);
  ImageNumberUpDown->Position = 1;
  ShowBoundaryImage();
}
//---------------------------------------------------------------------------
void __fastcall TInspectionAreaRevisionForm::ShowBoundaryImage(void)
{
  Graphics::TBitmap *CaptureBitmap = new Graphics::TBitmap;

  if (ExtractImage(CaptureBitmap, currentImageNumber, currentCameraIndex, TabletSetupData.ImageOffSetSW[currentCameraIndex - 1], TabletSetupData.referenceImageForOffset[currentCameraIndex - 1], ProductData.SubSamplingMode))
	{
		if (CameraMapInfo[currentCameraIndex - 1].CameraInspectPosition == CAMERA_POSITION_3D)
		{
			DestImage->Picture->Bitmap->Width = CaptureBitmap->Width;
			DestImage->Picture->Bitmap->Height = CaptureBitmap->Height;
			DestImage->Width = DestImage->Picture->Bitmap->Width * 2;
			DestImage->Height = DestImage->Picture->Bitmap->Height;
			DestImage->Picture->Bitmap->PixelFormat = pf8bit;

      Set3DPalette(DestImage->Picture->Bitmap);

			for (int y = 0; y < DestImage->Picture->Bitmap->Height; y++)
			{
				byte *pSrc = (byte *)CaptureBitmap->ScanLine[y];
				byte *pDst = (byte *)DestImage->Picture->Bitmap->ScanLine[y];
				memset(pDst, 0, DestImage->Picture->Bitmap->Width);
				for (int x = 4; x < DestImage->Picture->Bitmap->Width - 4; x++)
				{
          pDst[x] = pSrc[x];
				}

				byte *pTemp = new byte[DestImage->Picture->Bitmap->Width];
				memcpy(pTemp, pDst, DestImage->Picture->Bitmap->Width);
				for (int x = DestImage->Picture->Bitmap->Width - 2; x >= 2; x--)
				{
					if (pTemp[x] == 0)
					{
						if (pDst[x - 1] == 0)
						{
							pTemp[x] = pDst[x + 1];
						}
						else
						{
							pTemp[x] = min(pDst[x - 1], pDst[x + 1]);
						} 
					}
				}
				memcpy(pDst, pTemp, DestImage->Picture->Bitmap->Width);
				delete[] pTemp;
			}
		}
		else
		{
      if (ProductData.SubSamplingMode == IMAGE_FULL_SCALE_MODE)
      {
        ReductionImageScale(CaptureBitmap);
      } 

			DestImage->Picture->Bitmap->Width = CaptureBitmap->Width;
			DestImage->Picture->Bitmap->Height = CaptureBitmap->Height;
			DestImage->Picture->Bitmap->PixelFormat = pf24bit;
			DestImage->Picture->Bitmap->Assign(CaptureBitmap);
			DestImage->Width = DestImage->Picture->Bitmap->Width;
			DestImage->Height = DestImage->Picture->Bitmap->Height;
		}

		DestImage->Repaint();

		DestImage->Canvas->Brush->Style = bsClear;
		DestImage->Canvas->Pen->Color = clLime;
		if (CameraMapInfo[currentCameraIndex - 1].CameraInspectPosition == CAMERA_POSITION_3D)
		{
			DestImage->Canvas->Rectangle(Rect(BoundaryArea[currentCameraIndex - 1].left / 2,
                                            BoundaryArea[currentCameraIndex - 1].top,
                                            BoundaryArea[currentCameraIndex - 1].right / 2,
                                            BoundaryArea[currentCameraIndex - 1].bottom));
		}
		else
		{
			DestImage->Canvas->Rectangle(BoundaryArea[currentCameraIndex - 1]);
		}

    if(currentCameraIndex == SD1_2D_SIDE_FACE_P45_CAMERA_INDEX ||
        currentCameraIndex == SD2_2D_SIDE_FACE_P45_CAMERA_INDEX ||
        currentCameraIndex == SD1_2D_OTHER_SIDE_FACE_P45_CAMERA_INDEX ||
        currentCameraIndex == SD2_2D_OTHER_SIDE_FACE_P45_CAMERA_INDEX ||
        currentCameraIndex == SD1_2D_SIDE_FACE_M45_CAMERA_INDEX ||
        currentCameraIndex == SD2_2D_SIDE_FACE_M45_CAMERA_INDEX ||
        currentCameraIndex == SD1_2D_OTHER_SIDE_FACE_M45_CAMERA_INDEX ||
        currentCameraIndex == SD2_2D_OTHER_SIDE_FACE_M45_CAMERA_INDEX ||
        currentCameraIndex == SD1_2D_SIDE_FACE_00_CAMERA_INDEX ||
        currentCameraIndex == SD2_2D_SIDE_FACE_00_CAMERA_INDEX ||
        currentCameraIndex == SD1_2D_OTHER_SIDE_FACE_00_CAMERA_INDEX ||
        currentCameraIndex == SD2_2D_OTHER_SIDE_FACE_00_CAMERA_INDEX)
    {
      DestImage->Canvas->Pen->Color = clRed;
      DestImage->Canvas->MoveTo(0, DiscCenterPos[currentCameraIndex - 1].y);
      DestImage->Canvas->LineTo(CAM_Widht, DiscCenterPos[currentCameraIndex - 1].y);
    }

    int width, height;

    width = BoundaryArea[currentCameraIndex - 1].right - BoundaryArea[currentCameraIndex - 1].left;
    height = BoundaryArea[currentCameraIndex - 1].bottom - BoundaryArea[currentCameraIndex - 1].top;
    
    WidthLabel->Caption = "Width : " + IntToStr(width);
    HeightLabel->Caption = "Height : " + IntToStr(height);    
  }
  else
  {
		ShowMessageFA(CALIBRATIONFORM_MSG_09);
  }

  delete CaptureBitmap;
}
//---------------------------------------------------------------------------
void __fastcall TInspectionAreaRevisionForm::FormActivate(TObject *Sender)
{
  if(mode)
    memcpy(&dstTabletSetupData, srcTabletSetupData, sizeof(TTabletSetupData));
  
  for (int globalCameraIndex = 0; globalCameraIndex < SYSTEM_TOTAL_CAMERA_COUNT; globalCameraIndex++)
  {
    BoundaryArea[globalCameraIndex].left = dstTabletSetupData.ImageCutStartX[globalCameraIndex];
    BoundaryArea[globalCameraIndex].right = dstTabletSetupData.ImageCutEndX[globalCameraIndex];
    BoundaryArea[globalCameraIndex].top = dstTabletSetupData.ImageCutStartY[globalCameraIndex];
    BoundaryArea[globalCameraIndex].bottom = dstTabletSetupData.ImageCutEndY[globalCameraIndex];

		DiscCenterPos[globalCameraIndex].x = 0;
		DiscCenterPos[globalCameraIndex].y = MachineParams.DiscCenterPos[globalCameraIndex];
  }

  IsBoundarySettingMode = false;
  AreaKind = 5; // default(none)
  saveFlag = false;

  if(mode == 0)
  {
    for (int i = 1; i <= SYSTEM_TOTAL_CAMERA_COUNT; i++)
		{
			TSpeedButton *tempBtn = ((TSpeedButton *)FindComponent("BitBtn" + IntToStr(i)));

      if(tempBtn)
      {
        tempBtn->Enabled = false;
      }
		}

    BitBtn1->Enabled = true;
  }


}
//---------------------------------------------------------------------------

void __fastcall TInspectionAreaRevisionForm::DestImageMouseDown(
      TObject *Sender, TMouseButton Button, TShiftState Shift, int X,
      int Y)
{
  if (IsBoundarySettingMode)
  {
    if (AreaKind == 0 || AreaKind == 2)
    {
      BoundaryArea[currentCameraIndex - 1].left = X / 4 * 4;
    }
    else if (AreaKind != 4)
    {
      BoundaryArea[currentCameraIndex - 1].right = X / 4 * 4;
    }
    if (AreaKind == 0 || AreaKind == 1)
    {
      BoundaryArea[currentCameraIndex - 1].top = Y / 4 * 4;
    }
    else if (AreaKind != 4)
    {
      BoundaryArea[currentCameraIndex - 1].bottom = Y / 4 * 4;
    }

    if (AreaKind == 4)
		{
			DiscCenterPos[currentCameraIndex - 1].x = X;
			DiscCenterPos[currentCameraIndex - 1].y = Y / 4 * 4;
		}

    ShowBoundaryImage();
  }
}
//---------------------------------------------------------------------------

void __fastcall TInspectionAreaRevisionForm::areaKindSelect(
      TObject *Sender)
{
  TTntSpeedButton *theSpeedButton = (TTntSpeedButton *) Sender;
  AreaKind = theSpeedButton->Tag;  
}
//---------------------------------------------------------------------------

void __fastcall TInspectionAreaRevisionForm::ImageNumberUpDownClick(
      TObject *Sender, TUDBtnType Button)
{
  currentImageNumber = ImageNumberUpDown->Position;
  ImageNumberEdit->Text = IntToStr(currentImageNumber);
  ShowBoundaryImage();  
}
//---------------------------------------------------------------------------

void __fastcall TInspectionAreaRevisionForm::BitBtn18Click(TObject *Sender)
{
  saveFlag = false;
  this->Close();
}
//---------------------------------------------------------------------------

void __fastcall TInspectionAreaRevisionForm::BitBtn17Click(TObject *Sender)
{
  for (int globalCameraIndex = 0; globalCameraIndex < SYSTEM_TOTAL_CAMERA_COUNT; globalCameraIndex++)
  {
    dstTabletSetupData.ImageCutStartX[globalCameraIndex] = BoundaryArea[globalCameraIndex].left;
    dstTabletSetupData.ImageCutEndX[globalCameraIndex] = BoundaryArea[globalCameraIndex].right;
    dstTabletSetupData.ImageCutStartY[globalCameraIndex] = BoundaryArea[globalCameraIndex].top;
    dstTabletSetupData.ImageCutEndY[globalCameraIndex] = BoundaryArea[globalCameraIndex].bottom;
  }

  if(mode)
  {
    // modify disk base height position
    for (int globalCameraIndex = 0; globalCameraIndex < SYSTEM_TOTAL_CAMERA_COUNT; globalCameraIndex++)
    {
      MachineParams.DiscCenterPos[globalCameraIndex] = DiscCenterPos[globalCameraIndex].y;

      dstTabletSetupData.DiskBaseHeightPosition[globalCameraIndex] = MachineParams.DiscCenterPos[globalCameraIndex];
    }

    AnsiString MachineParamsPath;
    MachineParamsPath = ProgramPath.Env + "\\MachineInfor.ini";

    TIniFile *iniFile = new TIniFile(MachineParamsPath);
    if (iniFile)
    {
      for (int globalCameraIndex = 0; globalCameraIndex < SYSTEM_TOTAL_CAMERA_COUNT; globalCameraIndex++)
      {
        iniFile->WriteInteger("Disc Center Pos", IntToStr(globalCameraIndex + 1), MachineParams.DiscCenterPos[globalCameraIndex]);
      }
    }

    delete iniFile;

    saveFlag = true;
  }

  this->Close();
}
//---------------------------------------------------------------------------

void __fastcall TInspectionAreaRevisionForm::FormCreate(TObject *Sender)
{
  if(DefaultLCID == 1028 || DefaultLCID == 2052 || DefaultLCID == 3076 || DefaultLCID == 4100)
		ComponentSetFontName(this, "SimSun");
  else if(DefaultLCID == 1041)
    ComponentSetFontName(this, "Meiryo UI");
  else if(DefaultLCID == 3082)
  {
    ComponentSetFontName(this, "Segoe UI");
    ComponentSetMultiLine(this);
  }

  BitBtn18->Caption = V6_ISN_AREA_SETTING_FORM_BTN_01;
  BitBtn17->Caption = V6_ISN_AREA_SETTING_FORM_BTN_02;
  for(int globalCameraIndex = 0; globalCameraIndex < SYSTEM_TOTAL_CAMERA_COUNT; globalCameraIndex++)
  {
    AnsiString ConvertString;
    if(SystemLinkCameraInfo[globalCameraIndex] != 0)
    {
      TSpeedButton *BitBtn = (TSpeedButton *)FindComponent("BitBtn" + IntToStr(globalCameraIndex+1));

      ConvertString = ConvertCameraIndex(globalCameraIndex);
      BitBtn->Caption = ConvertString;
    }
  }


  if(GlobalProgramID == PROGRAM_ID_150P)
  {
    //SElMA150TP
    int MoveD = ComponentReposition(1,0,0,BitBtn3->Width);
    for(int globalCameraIndex = 0; globalCameraIndex < SYSTEM_TOTAL_CAMERA_COUNT; globalCameraIndex++)
    {
      TSpeedButton *BitBtn = (TSpeedButton *)FindComponent("BitBtn" + IntToStr(globalCameraIndex+1));
      if(SystemLinkCameraInfo[globalCameraIndex] == 0)
      {
        BitBtn->Visible = false;
      }
      else
      {
        BitBtn->Left += MoveD;
      }
    }
  }
  else if(ProductData.TabletType == TABLET_TYPE_SUGAR_COATED)
  {
    for(int globalCameraIndex = 0; globalCameraIndex < SYSTEM_TOTAL_CAMERA_COUNT; globalCameraIndex++)
    {
      if(globalCameraIndex == SD1_2D_SIDE_FACE_00_CAMERA_INDEX - 1 ||
          globalCameraIndex == SD1_2D_OTHER_SIDE_FACE_00_CAMERA_INDEX - 1 ||
          globalCameraIndex == SD2_2D_SIDE_FACE_00_CAMERA_INDEX - 1 ||
          globalCameraIndex == SD2_2D_OTHER_SIDE_FACE_00_CAMERA_INDEX - 1)
      {
        TSpeedButton *BitBtn = (TSpeedButton *)FindComponent("BitBtn" + IntToStr(globalCameraIndex+1));
        if(BitBtn)
        {
          BitBtn->Visible = false;
        }
      }
    }
  }
}
//---------------------------------------------------------------------------



