//---------------------------------------------------------------------------
// For SELMA200, 20180223, moon, Ϸ
// CameraIndex   Ϸ
//---------------------------------------------------------------------------

#include <vcl.h>
#include <inifiles.hpp>
#pragma hdrstop

#include "InspectionSetup_Form.h"
#include "Environment.h"
#include "Message_Form.h"
#include "Keyboard_Form.h"
#include "MultiLanguage.h"
#include "SpecialIns_Form.h"
#include "HR_SpecialForm.h"

//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma link "TntButtons"
#pragma link "TntExtCtrls"
#pragma link "TntStdCtrls"
#pragma resource "*.dfm"

TInspectionSetupForm *InspectionSetupForm;
//---------------------------------------------------------------------------
__fastcall TInspectionSetupForm::TInspectionSetupForm(TComponent* Owner)
	: TTntForm(Owner)
{
  if(DefaultLCID == 1028 || DefaultLCID == 2052 || DefaultLCID == 3076 || DefaultLCID == 4100)
    ComponentSetFontName(this, "SimSun");
  else if(DefaultLCID == 1041)
    ComponentSetFontName(this, "Meiryo UI");
  else if(DefaultLCID == 3082)
  {
    ComponentSetFontName(this, "Segoe UI");
    ComponentSetMultiLine(this);
  }

  GetDefaultString();
  if(MachineSetupData.CompanyID == INTERNATIONAL_MACHINE2)
  {
    TestModeCheckBox->Visible = true;
    Label13->Visible = false;
    ProductionCountEdit->Width = 164;
    recentLOTGroupBox->Visible = false;
  }
}
//---------------------------------------------------------------------------
void __fastcall TInspectionSetupForm::GetDefaultString()
{
  CancelBitBtn->Caption = INSPECTIONSETUPFORM_BITBTN_CAPTION_01;
  OkBitBtn->Caption = INSPECTIONSETUPFORM_BITBTN_CAPTION_02;
  UnsaveDefectImageCheckBox->Caption = INSPECTIONSETUPFORM_CHECKBOX_CAPTION_01;
  this->Caption = INSPECTIONSETUPFORM_FORM_CAPTION_01;
  GroupBox6->Caption = INSPECTIONSETUPFORM_GROUPBOX_CAPTION_01;
  GroupBox3->Caption = INSPECTIONSETUPFORM_GROUPBOX_CAPTION_02;
  GroupBox5->Caption = INSPECTIONSETUPFORM_GROUPBOX_CAPTION_03;
  GroupBox4->Caption = INSPECTIONSETUPFORM_GROUPBOX_CAPTION_04;
  GroupBox1->Caption = INSPECTIONSETUPFORM_GROUPBOX_CAPTION_05;
  TntGroupBox1->Caption = INSPECTIONSETUPFORM_GROUPBOX_CAPTION_06;
  TntGroupBox2->Caption = INSPECTIONSETUPFORM_GROUPBOX_CAPTION_07;
  Label4->Caption = INSPECTIONSETUPFORM_LABEL_CAPTION_01;
  Label5->Caption = INSPECTIONSETUPFORM_LABEL_CAPTION_01;
  Label6->Caption = INSPECTIONSETUPFORM_LABEL_CAPTION_02;
  if(MachineSetupData.CompanyID == INTERNATIONAL_MACHINE2)
  {
    Label1->Caption = "Batch";
    Label12->Caption = "Batch Size";
  }
  else
  {
    Label1->Caption = INSPECTIONSETUPFORM_LABEL_CAPTION_03;
    Label12->Caption = INSPECTIONSETUPFORM_LABEL_CAPTION_07;
  }

   Label3->Caption = INSPECTIONSETUPFORM_LABEL_CAPTION_04;
  Label2->Caption = INSPECTIONSETUPFORM_LABEL_CAPTION_05;
  Label13->Caption = INSPECTIONSETUPFORM_LABEL_CAPTION_06;
  Label10->Caption = INSPECTIONSETUPFORM_LABEL_CAPTION_08;
  GroupBox7->Caption = INSPECTIONSETUPFORM_LABEL_CAPTION_09;
  GroupBox2->Caption = INSPECTIONSETUPFORM_LABEL_CAPTION_10;
  Label8->Caption = INSPECTIONSETUPFORM_LABEL_CAPTION_11;
  Label9->Caption = INSPECTIONSETUPFORM_LABEL_CAPTION_12;
  MotorSpeedPanel2->Caption = INSPECTIONSETUPFORM_PANEL_CAPTION_01;
  MotorSpeedPanel1->Caption = INSPECTIONSETUPFORM_PANEL_CAPTION_02;
  MachineStopDeactivatePanel->Caption = INSPECTIONSETUPFORM_PANEL_CAPTION_03;

      ReInspectionTypeRadioGroup->Items->Strings[0] = INSPECTIONSETUPFORM_RADIOGROUP_ITEM_03;
    ReInspectionTypeRadioGroup->Items->Strings[1] = INSPECTIONSETUPFORM_PANEL_CAPTION_04;
    ReInspectionTypeRadioGroup->Items->Strings[2] = INSPECTIONSETUPFORM_RADIOGROUP_ITEM_01;
    ReInspectionTypeRadioGroup->Items->Strings[3] = INSPECTIONSETUPFORM_RADIOGROUP_CAPTION_01;
    
  MotorSpeedPanel3->Caption = INSPECTIONSETUPFORM_PANEL_CAPTION_05;
  MachineStopActivatePanel->Caption = INSPECTIONSETUPFORM_PANEL_CAPTION_06;
  InfiniteCountRadioButton->Caption = INSPECTIONSETUPFORM_RADIOBTN_CAPTION_01;
  InfiniteDPCountRadioButton->Caption = INSPECTIONSETUPFORM_RADIOBTN_CAPTION_01;
  InfiniteUPCountRadioButton->Caption = INSPECTIONSETUPFORM_RADIOBTN_CAPTION_01;
  QInfiniteDischargeActiveCountRadioButton->Caption = INSPECTIONSETUPFORM_RADIOBTN_CAPTION_01;
  QInfiniteMisejectActiveCountRadioButton->Caption = INSPECTIONSETUPFORM_RADIOBTN_CAPTION_01;

  FiniteCountRadioButton->Caption = INSPECTIONSETUPFORM_RADIOBTN_CAPTION_02;
  RadioButton4->Caption = INSPECTIONSETUPFORM_RADIOBTN_CAPTION_02;
  RadioButton2->Caption = INSPECTIONSETUPFORM_RADIOBTN_CAPTION_02;
  QFInfiniteMisejectActiveCountRadioButton->Caption = INSPECTIONSETUPFORM_RADIOBTN_CAPTION_02;
  QFInfiniteDischargeActiveCountButton->Caption = INSPECTIONSETUPFORM_RADIOBTN_CAPTION_02;


  ReInspectionTypeRadioGroup->Caption = INSPECTIONSETUPFORM_RADIOGROUP_ITEM_02;



  GoodLabel->Caption = INSPECTIONFORM_PANEL_CAPTION_31;
  DefectLabel->Caption = INSPECTIONFORM_PANEL_CAPTION_19;
  QtyLabel->Caption = INSPECTIONFORM_PANEL_CAPTION_29;
  LOTSelectionBtn->Caption = NEW_ADD_STRING_57;
  InspectionEndTimeLabel->Caption = INSPECTIONREPORTFORM_STRGRID_CELL_03;
  recentLOTGroupBox->Caption = NEW_ADD_STRING_58;
	if(MachineSetupData.MachineType < 2)
	{
		Label9->Caption = INSPECTIONSETUPFORM_LABEL_CAPTION_12;
		TntLabel1->Caption = "ȸũ ";
		TntLabel1->Visible = false;
		BFODOutSpeedLabel->Visible = false;
	}
	else
	{
		Label9->Caption = "ȸ̵ ";
		TntLabel1->Caption = "ȸũ ";
		TntLabel1->Visible = true;
		BFODOutSpeedLabel->Visible = true;	
	}
}
//---------------------------------------------------------------------------
void __fastcall TInspectionSetupForm::GetInspectionOption(TInspectionOption &inspectionOption)
{
	inspectionOption = InspectionOption;
}
//---------------------------------------------------------------------------
void __fastcall TInspectionSetupForm::SetInspectionOption(TInspectionOption &inspectionOption)
{
	InspectionOption = inspectionOption;
  if (InspectionResultExists(ProductData.LOTName))
	{
    if(MachineSetupData.CompanyID == INTERNATIONAL_MACHINE2)
  		ReInspectionPanel->Visible = false;
    else
      ReInspectionPanel->Visible = true;

		InspectionOption.IsReInspection = true;
		if (PCProgramOption.InspectionResetOnRestart)
		{
			ReInspectionTypeRadioGroup->ItemIndex = 0;
			InspectionOption.ReInspectionType = RE_INSPECTION_TYPE_NEW;
		}
		else
		{
			ReInspectionTypeRadioGroup->ItemIndex = 1;
			InspectionOption.ReInspectionType = RE_INSPECTION_TYPE_CONTINUE;
		}
  }
  else
	{
		ReInspectionPanel->Visible = false;
    InspectionOption.IsReInspection = false;
    InspectionOption.ReInspectionType = RE_INSPECTION_TYPE_NEW;
	}

	this->ClientHeight = BottomMenuPanel->Top + BottomMenuPanel->Height;
  ApplyInspectionOption(1);
}
//---------------------------------------------------------------------------
void __fastcall TInspectionSetupForm::OkBitBtnClick(TObject *Sender)
{
	bool bError = false;

  if(MachineSetupData.CompanyID == INTERNATIONAL_MACHINE1)
  {
    if(!Machine.PortStatus.IPStatus[OP_SAFETY_CIRCUIT_SELECT])
    {
      if (!Machine.InterlockCheck())
      {
        ShowMessageFA(Machine.GetInterlockMessage());
        return;
      }
    }
  }

  if(MachineSetupData.CompanyID == INTERNATIONAL_MACHINE1)
  {
    if(AcrociaCommandStartProcess) // Acrocia Start Command Default Data
    {
      UserLOTSelectCheck = true; // same lot number alarm disable
      LOTNameEdit->Text = "Test";
      ProductionCountEdit->Text = "0";

      ReInspectionTypeRadioGroup->ItemIndex = 0;
      InspectionOption.ReInspectionType = RE_INSPECTION_TYPE_NEW;

      InfiniteCountRadioButton->Checked = true;
      InfiniteDPCountRadioButton->Checked = true;
      InfiniteUPCountRadioButton->Checked = true;
      QInfiniteDischargeActiveCountRadioButton->Checked = true;
      QInfiniteMisejectActiveCountRadioButton->Checked = true;

      InspectionOption.MachineStopActivated = false;
    }
  }

	WideString lotName = LOTNameEdit->Text;
  WideString Word;
  AnsiString gradeFileName = ProgramPath.Product + "\\" + ProductData.ProductCode + "\\" + ProductData.ProductCode + ".grd";
  LoadGradeData(gradeFileName, TabletGradeData);

	if (lotName.IsEmpty())
	{
    if(MachineSetupData.CompanyID == INTERNATIONAL_MACHINE2)
      Word = "Please Enter A Batch";
    else
      Word = INSPECTIONSETUPFORM_MSG_02;
      
		MessageDlgFA(Word, mtError, TMsgDlgButtons() << mbOK);
		bError = true;

    return;
	}
	else if (lotName.Pos("/") != 0 ||
		lotName.Pos("\\") != 0 ||
		lotName.Pos("*") != 0 ||
		lotName.Pos("?") != 0 ||
		lotName.Pos(":") != 0 ||
		lotName.Pos("\"") != 0 ||
		lotName.Pos("|") != 0 ||
		lotName.Pos("<") != 0 ||
		lotName.Pos(">") != 0 ||
		lotName.Pos("[") != 0 ||
		lotName.Pos("]") != 0)
	{
    if(MachineSetupData.CompanyID == INTERNATIONAL_MACHINE2)
      Word = "Can Not Use /, \\, *,,:?, \ \", |, <,>, [,] For Lot Name";
    else
      Word = INSPECTIONSETUPFORM_MSG_01;

		ShowMessageFA(Word);
		bError = true;
    return;
	}

  int RecentEndFlag = 0;
  WideString RecentLot = "";
  WideString RecentProduct = "";
  bool FindData = false;


  if(!UserLOTSelectCheck)
  {

    if(MachineSetupData.CompanyID == INTERNATIONAL_MACHINE2)
    {
       TIniFile *iniFile = new TIniFile(ProgramPath.Env + "\\UserSetting.ini");
       RecentLot = iniFile->ReadString("Quick Start", "Recent Lot", "");
       RecentProduct = iniFile->ReadString("Quick Start", "Recent Product", "");
       RecentEndFlag = iniFile->ReadInteger("Quick Start", "Batch End", 1);
       delete iniFile;
    }

    //AcrociaCommandStartProcess = true;
    for(int itemIndex = 0; itemIndex < inspectedLOTCount; itemIndex++)
    {
      if(InspectedLOTInformation[itemIndex].LOTName == NULL) continue;
      WideString ResultLotName = InspectedLOTInformation[itemIndex].LOTName;
      WideString InputLotName  = lotName;
      if(_tcscmp(_tcslwr(ResultLotName), _tcslwr(InputLotName)) == 0)
      {
        if(MachineSetupData.CompanyID == INTERNATIONAL_MACHINE2)
        {
          FindData = true;
          if(InspectedLOTInformation[itemIndex].LotEndFlag == 1)  // RecentEndFlag == 1  ,  ̸ ִ .
          {
            ShowMessageFA("Software not allow to continue with same Batch No");
            AjantaReturnCode = true;
            return;
          }

        }
        else
        {
          if(MachineSetupData.CompanyID == INTERNATIONAL_MACHINE1)
          {
            if(!AcrociaCommandStartProcess) // MES COMMAND START
            {
              if(MessageDlgFA(INSPECTIONFORM_WARNING_CAPTION_01,mtConfirmation,TMsgDlgButtons() << mbOK << mbCancel) == mrCancel)
                return;
            }
          }
          else
          {
            if(MessageDlgFA(INSPECTIONFORM_WARNING_CAPTION_01,mtConfirmation,TMsgDlgButtons() << mbOK << mbCancel) == mrCancel)
              return;
          }

        }


        //}
      }
    }
  }

  if(MachineSetupData.CompanyID == INTERNATIONAL_MACHINE2)
  {
    if(RecentEndFlag == 0 && FindData == false)
    {
      ShowMessageFA("There is an inspection that has not been terminated.[" + RecentProduct +" , " + RecentLot + "]"); // Lot  ġ ̸  ؾߵ
      AjantaReturnCode = true;
      return;
    }
  }

	if (!bError)
	{
		try
		{
      int TotalCount = StrToInt(ProductionCountEdit->Text);
      if(ProductionCountEdit->Text.c_bstr() == "" || TotalCount == 0 )
      {
        if(MachineSetupData.CompanyID == INTERNATIONAL_MACHINE2)
        {
          ShowMessageFA("Please enter the Batch Size of the inspection.");
          return;
        }
        else
          InspectionOption.MachineStopTotalCount = -1;
      }
      else
      {
        if(MachineSetupData.CompanyID == INTERNATIONAL_MACHINE2)
          InspectionOption.MachineStopTotalCount = StrToInt(ProductionCountEdit->Text);
        else
          InspectionOption.MachineStopTotalCount = StrToInt(ProductionCountEdit->Text)*10000;
      }

			if (InfiniteCountRadioButton->Checked)
			{
				InspectionOption.DesiredInspectionCount = -1;
        InspectionOption.DesiredInspectionLimitCountActive = 0;
			}
			else
			{
				InspectionOption.DesiredInspectionCount = StrToInt(InspectionCountEdit->Text);
        InspectionOption.DesiredInspectionLimitCountActive = 1;
			}
			if (InfiniteDPCountRadioButton->Checked)
			{
				InspectionOption.MachineStopDPCount = -1;
        InspectionOption.MachineStopDPLimitCountActive = 0;
			}
			else
			{
				InspectionOption.MachineStopDPCount = StrToInt(MachineStopDPCountEdit->Text);
        InspectionOption.MachineStopDPLimitCountActive = 1;
			}
			if (InfiniteUPCountRadioButton->Checked)
			{
				InspectionOption.MachineStopUPCount = -1;
        InspectionOption.MachineStopUPLimitCountActive = 0;
			}
			else
			{
				InspectionOption.MachineStopUPCount = StrToInt(MachineStopUPCountEdit->Text);
        InspectionOption.MachineStopUPLimitCountActive = 1;
			}

      if (QInfiniteDischargeActiveCountRadioButton->Checked)
			{
				InspectionOption.QMachineDischargeActiveCount = -1;
        InspectionOption.QMachineDischargeActive = 0;
        if(ProductData.DischargeCountSetValue != 0)
          ProductData.LastDischargeCountSetValue = ProductData.DischargeCountSetValue;
        ProductData.DischargeCountSetValue = 0;
			}
			else
			{
				InspectionOption.QMachineDischargeActiveCount = StrToInt(QDischargeCountEdit->Text);
        InspectionOption.QMachineDischargeActive = 1;
        ProductData.DischargeCountSetValue = InspectionOption.QMachineDischargeActiveCount;
			}

      if (QInfiniteMisejectActiveCountRadioButton->Checked)
			{
				InspectionOption.QMachineMisejectActiveLimitCount = -1;
        InspectionOption.QMachineMisejectActive = 0;
			}
			else
			{
				InspectionOption.QMachineMisejectActiveLimitCount = StrToInt(QMisejectCountEdit->Text);
        InspectionOption.QMachineMisejectActive = 1;
        ProductData.MisejectActiveLimitCount = InspectionOption.QMachineMisejectActiveLimitCount;
			}

			InspectionOption.SpeedIndex = CurrentMotorSpeedIndex;

			InspectionOption.UnsaveDefectImage = UnsaveDefectImageCheckBox->Checked;

      if(MachineSetupData.LasercomplexerInfo.Laser_complexer_Enable)
      {
        if(NFALaserinfo.LaserMachineStatus == LaserMachineStatus_Run)
        {
          InspectionOption.LaserActiveMode = 1;
        }
        else
        {
          InspectionOption.LaserActiveMode = 0;
        }
      }
      else
      {
        InspectionOption.LaserActiveMode = 0;
      }

      InspectionOption.CheckUnPrint = TabletGradeData.EngravePositionDefectCheckSW; // grade  ¸ HCB 

      bool bCameraEnabled = true;
      for(int globalCameraIndex = 0; globalCameraIndex < SYSTEM_TOTAL_CAMERA_COUNT; globalCameraIndex++)
      {
        if(ProductData.TabletType == TABLET_TYPE_SUGAR_COATED)
        {
          if(!(globalCameraIndex == SD1_2D_SIDE_FACE_00_CAMERA_INDEX - 1 ||
                globalCameraIndex == SD1_2D_OTHER_SIDE_FACE_00_CAMERA_INDEX - 1 ||
                globalCameraIndex == SD2_2D_SIDE_FACE_00_CAMERA_INDEX - 1 ||
                globalCameraIndex == SD2_2D_OTHER_SIDE_FACE_00_CAMERA_INDEX - 1))
          {
            if(SystemLinkCameraInfo[globalCameraIndex])
            {
              if(InspectionOption.CameraEnabled[globalCameraIndex] == false)
              {
                bCameraEnabled = false;
              }
            }
          }
        }
        else
        {
          if(SystemLinkCameraInfo[globalCameraIndex])
          {
            if(InspectionOption.CameraEnabled[globalCameraIndex] == false)
            {
              bCameraEnabled = false;
            }
          }
        }
      }

      if(!bCameraEnabled)
      {
        InspectionOption.CheckUnPrint = false;
      }

      ///// Daehwa /////
      if(SpecialInsDAEHWAcheckbox->Checked)
      {
        InspectionOption.SpecialInsCheckbox = SpecialInsDAEHWAcheckbox->Checked;
        for(int i =0; i < 6 ; i++)
        {
          InspectionOption.SpecialInsCount[i] = ProductData.SpecialInsCount[i];
        }
      }
      else
      {
        InspectionOption.SpecialInsCheckbox = SpecialInsDAEHWAcheckbox->Checked;
        /*for(int i =0; i < 6 ; i++)
        {
          ProductData.SpecialInsCount[i] = 0 ;
          InspectionOption.SpecialInsCount[i] = ProductData.SpecialInsCount[i];
        }*/
      }
      ///// end /////
		}
		catch (Exception &ec)
		{
			MessageDlgFA(INSPECTIONSETUPFORM_MSG_04, mtError, TMsgDlgButtons() << mbOK);
      if(MachineSetupData.CompanyID == INTERNATIONAL_MACHINE1 && AcrociaCommandStartProcess)
      {
        ModalResult = mrCancel;
      }
			bError = true;
		}
	}

	if (!bError)
	{
		if (InspectionOption.IsReInspection)
		{
			if (InspectionOption.ReInspectionType == RE_INSPECTION_TYPE_NEW)
			{
        if(MachineSetupData.CompanyID == INTERNATIONAL_MACHINE1)
        {
          if(!AcrociaCommandStartProcess) // MES COMMAND START
          {
            if (MessageDlgFA(INSPECTIONSETUPFORM_MSG_03, mtConfirmation, TMsgDlgButtons() << mbOK << mbCancel) == mrOk)
            {
              //
            }
            else
            {
              return;
            }
          }
        }
        else
        {
          if (MessageDlgFA(INSPECTIONSETUPFORM_MSG_03, mtConfirmation, TMsgDlgButtons() << mbOK << mbCancel) == mrOk)
          {
            //
          }
          else
          {
            return;
          }
        }

			}
		}
		if (InspectionOption.UnsaveDefectImage)
		{
      if(MachineSetupData.CompanyID == INTERNATIONAL_MACHINE1)
      {
        if(!AcrociaCommandStartProcess) // MES COMMAND START
        {
          if (MessageDlgFA(INSPECTIONSETUPFORM_MSG_03, mtConfirmation, TMsgDlgButtons() << mbOK << mbCancel) == mrOk)
          {
            //
          }
          else
          {
            return;
          }
        }
      }
      else
      {
        if (MessageDlgFA(INSPECTIONSETUPFORM_MSG_05, mtConfirmation, TMsgDlgButtons() << mbOK << mbCancel) == mrOk)
        {
          //
        }
        else
        {
          return;
        }
      }
		}

    TIniFile *iniFile = new TIniFile(ProgramPath.Env + "\\UserSetting.ini");
    if (iniFile)
    {
      iniFile->WriteBool("Inspection Option", "Is Single Disc Mode", InspectionOption.IsSingleDiscMode);

      iniFile->WriteInteger("Inspection Option", "Desired Inspection Count", InspectionOption.DesiredInspectionCount);
      iniFile->WriteInteger("Inspection Option", "Defect Limit Count", InspectionOption.MachineStopDPCount);
      iniFile->WriteInteger("Inspection Option", "UnInspection Limit Count", InspectionOption.MachineStopUPCount);
      iniFile->WriteInteger("Inspection Option", "QDischarge Count", InspectionOption.QMachineDischargeActiveCount);

      iniFile->WriteInteger("Inspection Option", "Desired Inspection Active", InspectionOption.DesiredInspectionLimitCountActive);
      iniFile->WriteInteger("Inspection Option", "Defect Limit Active", InspectionOption.MachineStopDPLimitCountActive);
      iniFile->WriteInteger("Inspection Option", "UnInspection Limit Active", InspectionOption.MachineStopUPLimitCountActive);
      iniFile->WriteInteger("Inspection Option", "QDischarge Active", InspectionOption.QMachineDischargeActive);
      iniFile->WriteInteger("Inspection Option", "QMiseject Limit Active", InspectionOption.QMachineMisejectActive);

      for (int globalCameraIndex = 0; globalCameraIndex < SYSTEM_TOTAL_CAMERA_COUNT; globalCameraIndex++)
      {
        iniFile->WriteBool("Inspection Option", "Camera Enabled " + IntToStr(globalCameraIndex + 1), InspectionOption.CameraEnabled[globalCameraIndex]);
      }
      iniFile->WriteBool("Inspection Option", "Machine Stop Activated", InspectionOption.MachineStopActivated);
      iniFile->WriteInteger("Inspection Option", "Machine Stop Defect Ratio", InspectionOption.MachineStopDefectRatio);
      iniFile->WriteInteger("Inspection Option", "Machine Stop UnInspect Ratio", InspectionOption.MachineStopUnInsRatio);
      iniFile->WriteInteger("Inspection Option", "Machine Run Speed", InspectionOption.SpeedIndex);
      iniFile->WriteBool("Inspection Option", "Inspection NC As Defect", InspectionOption.NCAsDefect);
      iniFile->WriteBool("Inspection Option", "Unsave Defect Image", InspectionOption.UnsaveDefectImage);
      iniFile->WriteBool("Inspection Option", "Distributor Action", InspectionOption.SpecialInsCheckbox);
      
      delete iniFile;
    }
    MachineOperationInfo.SpeedIndex = InspectionOption.SpeedIndex;
    ProductData.LOTName = lotName;

    if(MachineSetupData.CompanyID == INTERNATIONAL_MACHINE2)
     ProductData.ProductionCount = StrToInt(ProductionCountEdit->Text);
    else
      ProductData.ProductionCount = StrToFloat(ProductionCountEdit->Text)* 10000;
      
    AnsiString fileName = GetProductDataFileName(ProductData.ProductCode);
    WriteProductData(fileName, ProductData);


    ModalResult = mrOk;
  }
}
//---------------------------------------------------------------------------
void __fastcall TInspectionSetupForm::FormCreate(TObject *Sender)
{
  if(ProgramAccessAuthorityData.ProgramAccessAuthorityTable[UserInfo.AccessLevel][ACCESS_PGM_EVT_INSPECTIONFORM_CAMERA_SETUP])
  {
    GroupBox2->Visible = true;
  }
  else
  {
    GroupBox2->Visible = false;
  }
    
  InspectionEndTimeLabel2->Caption = "";

	CurrentMotorSpeedIndex = MachineOperationInfo.SpeedIndex;
	LOTNameEdit->Text = ProductData.LOTName;

  if(MachineSetupData.CompanyID == INTERNATIONAL_MACHINE2)
    ProductionCountEdit->Text = IntToStr(ProductData.ProductionCount);
  else
  {
    if(ProductData.ProductionCount != 0)
      ProductionCountEdit->Text = FloatToStr(ProductData.ProductionCount / 10000.0);
    else
      ProductionCountEdit->Text ="0";
  }

  if (InspectionResultExists(ProductData.LOTName))
	{
    if(MachineSetupData.CompanyID == INTERNATIONAL_MACHINE2)
      ReInspectionPanel->Visible = false;
    else
		  ReInspectionPanel->Visible = true;
      
		InspectionOption.IsReInspection = true;
		if (PCProgramOption.InspectionResetOnRestart)
		{
			ReInspectionTypeRadioGroup->ItemIndex = 0;
			InspectionOption.ReInspectionType = RE_INSPECTION_TYPE_NEW;
		}
		else
		{
			ReInspectionTypeRadioGroup->ItemIndex = 1;
			InspectionOption.ReInspectionType = RE_INSPECTION_TYPE_CONTINUE;
		}
	}
	else
	{
		ReInspectionPanel->Visible = false;
		InspectionOption.IsReInspection = false;
		InspectionOption.ReInspectionType = RE_INSPECTION_TYPE_NEW;
	}
	this->Top = 30;
	this->Left = (Screen->Width - this->Width) / 2;
	this->ClientHeight = BottomMenuPanel->Top + BottomMenuPanel->Height;
  InitInspectionOption(InspectionOption);
	ApplyInspectionOption(0);

  SpecialInsDAEHWAcheckbox->Checked = InspectionOption.SpecialInsCheckbox;

  inspectedLOTCount = 0;
  SetLOTInformation();

  //////// DAEHWA PROGRAM ////////
  if(PCProgramOption.DHprogram)
  {
    Panel5->Visible = true;
  }
  else
  {
    Panel5->Visible = false;
    SpecialInsDAEHWAcheckbox->Checked = false;
  }
  //////// END ///////////////////

  for(int globalCameraIndex = 0; globalCameraIndex < SYSTEM_TOTAL_CAMERA_COUNT; globalCameraIndex++)
  {
    AnsiString ConvertString;
    if(SystemLinkCameraInfo[globalCameraIndex] != 0)
    {
      TTntPanel *CamEnabledPanel = (TTntPanel *)FindComponent("CamEnabledPanel" + IntToStr(globalCameraIndex+1));

      ConvertString = ConvertCameraIndex(globalCameraIndex);
      CamEnabledPanel->Caption = ConvertString;
    }
  }

  if(GlobalProgramID == PROGRAM_ID_150P)
  {
    //SELMA150P
    int MoveD = ComponentReposition(1,0,0,CamEnabledPanel3->Width);
    for(int globalCameraIndex = 0; globalCameraIndex < SYSTEM_TOTAL_CAMERA_COUNT; globalCameraIndex++)
    {
      TTntPanel *CamEnabledPanel = (TTntPanel *)FindComponent("CamEnabledPanel" + IntToStr(globalCameraIndex+1));
      if(SystemLinkCameraInfo[globalCameraIndex] == 0)
      {
        CamEnabledPanel->Visible= false;
      }
      else
      {
        CamEnabledPanel->Left += MoveD;
      }
    }
  }
  else if(ProductData.TabletType == TABLET_TYPE_SUGAR_COATED)
  {
    //Sugar coat
    int MoveD = ComponentReposition(1,0,0,CamEnabledPanel3->Width);
    for(int globalCameraIndex = 0; globalCameraIndex < SYSTEM_TOTAL_CAMERA_COUNT; globalCameraIndex++)
    {
      TTntPanel *CamEnabledPanel = (TTntPanel *)FindComponent("CamEnabledPanel" + IntToStr(globalCameraIndex+1));

      if(globalCameraIndex == SD1_2D_SIDE_FACE_00_CAMERA_INDEX - 1 ||
          globalCameraIndex == SD1_2D_OTHER_SIDE_FACE_00_CAMERA_INDEX - 1 ||
          globalCameraIndex == SD2_2D_SIDE_FACE_00_CAMERA_INDEX - 1 ||
          globalCameraIndex == SD2_2D_OTHER_SIDE_FACE_00_CAMERA_INDEX - 1)
      {
        CamEnabledPanel->Visible= false;
      }
      else
      {
        CamEnabledPanel->Left += MoveD;
      }
    }
  }
}
//---------------------------------------------------------------------------
void __fastcall TInspectionSetupForm::ApplyInspectionOption(int option)
{
  for (int globalCameraIndex = 0; globalCameraIndex < SYSTEM_TOTAL_CAMERA_COUNT; globalCameraIndex++)
  {
    TTntPanel *thePanel = (TTntPanel *) FindComponent("CamEnabledPanel" + IntToStr(globalCameraIndex + 1));

      if (InspectionOption.CameraEnabled[globalCameraIndex])
      {
        thePanel->Color = clLime;
      }
      else
      {
        thePanel->Color = clRed;
      }
   

	}

  if(option)
  {
    if(InspectionOption.DesiredInspectionLimitCountActive == 0)
    {
      InfiniteCountRadioButton->Checked = true;
    }
    else
    {
      FiniteCountRadioButton->Checked = true;
      InspectionCountEdit->Text = IntToStr(InspectionOption.DesiredInspectionCount);
    }

    if(InspectionOption.MachineStopDPLimitCountActive == 0)
    {
      InfiniteDPCountRadioButton->Checked = true;
    }
    else
    {
      RadioButton2->Checked = true;
      MachineStopDPCountEdit->Text = IntToStr(InspectionOption.MachineStopDPCount);
    }

    if(InspectionOption.MachineStopUPLimitCountActive == 0)
    {
      InfiniteUPCountRadioButton->Checked = true;
    }
    else
    {
      RadioButton4->Checked = true;
      MachineStopUPCountEdit->Text = IntToStr(InspectionOption.MachineStopUPCount);
    }

    if(MachineSetupData.CompanyID == INTERNATIONAL_MACHINE1)
    {
      if(!PCProgramOption.UVLaserDownstreamEnabled)
      {
        QInfiniteDischargeActiveCountRadioButton->Checked = true;
        QInfiniteDischargeActiveCountRadioButton->Enabled = false;
        QFInfiniteDischargeActiveCountButton->Enabled = false;
        QDischargeCountEdit->Enabled = false;
      }
      else
      {
        if(InspectionOption.QMachineDischargeActive == 0)
        {
          QInfiniteDischargeActiveCountRadioButton->Checked = true;
        }
        else
        {
          QFInfiniteDischargeActiveCountButton->Checked = true;
        }
      }
      if(ProductData.DischargeCountSetValue == 0)
        QDischargeCountEdit->Text = IntToStr(ProductData.LastDischargeCountSetValue);
      else
        QDischargeCountEdit->Text = IntToStr(ProductData.DischargeCountSetValue);

      if(!MachineSetupData.EjectorInfo.MisejectActive)
      {
        QInfiniteMisejectActiveCountRadioButton->Checked = true;
        QInfiniteMisejectActiveCountRadioButton->Enabled = false;
        QFInfiniteMisejectActiveCountRadioButton->Enabled = false;
        QMisejectCountEdit->Enabled = false;
      }
      else
      {
        if(InspectionOption.QMachineMisejectActive == 0)
        {
          QInfiniteMisejectActiveCountRadioButton->Checked = true;
        }
        else
        {
          QFInfiniteMisejectActiveCountRadioButton->Checked = true;
        }
      }

      QMisejectCountEdit->Text = IntToStr(ProductData.MisejectActiveLimitCount);
    }
  }

  ReInspectionTypeRadioGroup->ItemIndex = InspectionOption.ReInspectionType;

  if (InspectionOption.MachineStopActivated)
  {
    MachineStopActivatePanel->Color = clBlue;
    MachineStopActivatePanel->Font->Color = clWhite;

    MachineStopDeactivatePanel->Color = clWhite;
    MachineStopDeactivatePanel->Font->Color = clBlack;
  }
  else
  {
    MachineStopActivatePanel->Color = clWhite;
    MachineStopActivatePanel->Font->Color = clBlack;

    MachineStopDeactivatePanel->Color = clBlue;
    MachineStopDeactivatePanel->Font->Color = clWhite;
  }

  MachineStopDefectRatioEdit->Text = IntToStr(InspectionOption.MachineStopDefectRatio);
	MachineStopUnInsRatioEdit->Text = IntToStr(InspectionOption.MachineStopUnInsRatio);

	for (int speedControlIndex = 0; speedControlIndex < MOTOR_SPEED_STEP_COUNT_FOR_PRODUCT; speedControlIndex++)
  {
		TTntPanel *motorSpeedPanel = (TTntPanel *)FindComponent("MotorSpeedPanel" + IntToStr(speedControlIndex + 1));
    if (speedControlIndex == CurrentMotorSpeedIndex)
    {
	motorSpeedPanel->Color = clBlue;
	motorSpeedPanel->Font->Color = clWhite;
	BFIDSpeedLabel->Caption = IntToStr(MachineSetupData.ServoMotorData[BF_ID_MOTOR_INDEX].BaseSpeed * 60 / ProductData.MotorSpeedList[BF_ID_MOTOR_INDEX][speedControlIndex]) + "RPM (" + IntToStr(MachineSetupData.ServoMotorData[BF_ID_MOTOR_INDEX].BaseSpeed * 100 / ProductData.MotorSpeedList[BF_ID_MOTOR_INDEX][speedControlIndex]) + "%)";
	BFODInSpeedLabel->Caption = IntToStr(MachineSetupData.ServoMotorData[BF_OD_IN_MOTOR_INDEX].BaseSpeed * 36 / ProductData.MotorSpeedList[BF_OD_IN_MOTOR_INDEX][speedControlIndex]) + "RPM (" + IntToStr(MachineSetupData.ServoMotorData[BF_OD_IN_MOTOR_INDEX].BaseSpeed * 100 / ProductData.MotorSpeedList[BF_OD_IN_MOTOR_INDEX][speedControlIndex]) + "%)";
	if(MachineSetupData.MachineType == MACHINE_TYPE_SELMA_ADVANCED || MachineSetupData.MachineType == MACHINE_TYPE_LIMA_ADVANCED)
	{
		BFODOutSpeedLabel->Caption = IntToStr(MachineSetupData.ServoMotorData[BF_OD_OUT_MOTOR_INDEX].BaseSpeed * 36 / ProductData.MotorSpeedList[BF_OD_OUT_MOTOR_INDEX][speedControlIndex]) + "RPM (" + IntToStr(MachineSetupData.ServoMotorData[BF_OD_OUT_MOTOR_INDEX].BaseSpeed * 100 / ProductData.MotorSpeedList[BF_OD_OUT_MOTOR_INDEX][speedControlIndex]) + "%)";
	}
	VDSpeedLabel->Caption = IntToStr((int)(MachineSetupData.ServoMotorData[SD1_MOTOR_INDEX].BaseSpeed * SUCTION_DISK_100P_RPM / ProductData.MotorSpeedList[SD1_MOTOR_INDEX][speedControlIndex])) + "RPM (" + IntToStr(MachineSetupData.ServoMotorData[SD1_MOTOR_INDEX].BaseSpeed * 100 / ProductData.MotorSpeedList[SD1_MOTOR_INDEX][speedControlIndex]) + "%)";
    }
    else
    {
	motorSpeedPanel->Color = clWhite;
	motorSpeedPanel->Font->Color = clBlack;
    }
  }

	if (InspectionOption.UnsaveDefectImage)
	{
		UnsaveDefectImageCheckBox->Checked = true;
	}
	else
	{
		UnsaveDefectImageCheckBox->Checked = false;
	}
}
//---------------------------------------------------------------------------
void __fastcall TInspectionSetupForm::NumberEditClick(
      TObject *Sender)
{
	TTntEdit *theEdit = (TTntEdit *) Sender;

	KeyboardForm->Text = theEdit->Text;
  if (KeyboardForm->ShowKeypad() == mrOk)
  {
    if(StrToInt(KeyboardForm->Text) == 0)
    {
      if(theEdit->Name != "ProductionCountEdit")
      {
        KeyboardForm->Text = "1";
      }
    }

    if(MachineSetupData.CompanyID == INTERNATIONAL_MACHINE2)
    {
      theEdit->Text = IntToStr(StrToInt(KeyboardForm->Text));
    }
    else
      theEdit->Text = KeyboardForm->Text;
  }
}
//---------------------------------------------------------------------------
void __fastcall InitInspectionOption(TInspectionOption &inspectionOption)
{
	TIniFile *iniFile = new TIniFile(ProgramPath.Env + "\\UserSetting.ini");
  if (iniFile)
  {
		inspectionOption.IsSingleDiscMode = iniFile->ReadBool("Inspection Option", "Is Single Disc Mode", false);

		inspectionOption.DesiredInspectionCount = iniFile->ReadInteger("Inspection Option", "Desired Inspection Count", -1);
    inspectionOption.MachineStopDPCount = iniFile->ReadInteger("Inspection Option", "Defect Limit Count", -1);
    inspectionOption.MachineStopUPCount = iniFile->ReadInteger("Inspection Option", "UnInspection Limit Count", -1);
    inspectionOption.QMachineDischargeActiveCount = iniFile->ReadInteger("Inspection Option", "QDischarge Count", -1);

    inspectionOption.DesiredInspectionLimitCountActive =iniFile->ReadInteger("Inspection Option", "Desired Inspection Active", 0);
    inspectionOption.MachineStopDPLimitCountActive =iniFile->ReadInteger("Inspection Option", "Defect Limit Active", 0);
    inspectionOption.MachineStopUPLimitCountActive =iniFile->ReadInteger("Inspection Option", "UnInspection Limit Active", 0);
    inspectionOption.QMachineDischargeActive = iniFile->ReadInteger("Inspection Option", "QDischarge Active", 0);
    inspectionOption.QMachineMisejectActive= iniFile->ReadInteger("Inspection Option", "QMiseject Limit Active", 0);

		for (int globalCameraIndex = 0; globalCameraIndex < SYSTEM_TOTAL_CAMERA_COUNT; globalCameraIndex++)
		{
			inspectionOption.CameraEnabled[globalCameraIndex] = iniFile->ReadBool("Inspection Option", "Camera Enabled " + IntToStr(globalCameraIndex + 1), true);
		}
    
		inspectionOption.MachineStopActivated = iniFile->ReadBool("Inspection Option", "Machine Stop Activated", true);
		inspectionOption.MachineStopDefectRatio = iniFile->ReadInteger("Inspection Option", "Machine Stop Defect Ratio", 20);
		inspectionOption.MachineStopUnInsRatio = iniFile->ReadInteger("Inspection Option", "Machine Stop UnInspect Ratio", 20);
		inspectionOption.SpeedIndex = iniFile->ReadInteger("Inspection Option", "Machine Run Speed", 0);
		inspectionOption.NCAsDefect = iniFile->ReadBool("Inspection Option", "Inspection NC As Defect", false);
		inspectionOption.UnsaveDefectImage = iniFile->ReadBool("Inspection Option", "Unsave Defect Image", false);
    inspectionOption.SpecialInsCheckbox = iniFile->ReadBool("Inspection Option", "Distributor Action", false);
		delete iniFile;
	}
	else
	{
		inspectionOption.IsSingleDiscMode = false;
		inspectionOption.DesiredInspectionCount = -1;
    inspectionOption.MachineStopDPCount = -1;
    inspectionOption.MachineStopUPCount = -1;
    inspectionOption.QMachineDischargeActive = -1;
    inspectionOption.QMachineMisejectActive = -1;

    inspectionOption.QMachineDischargeActiveCount = 0;
    inspectionOption.DesiredInspectionLimitCountActive = 0;
    inspectionOption.MachineStopDPLimitCountActive = 0;
    inspectionOption.MachineStopUPLimitCountActive = 0;

		for (int globalCameraIndex = 0; globalCameraIndex < SYSTEM_TOTAL_CAMERA_COUNT; globalCameraIndex++)
		{
			inspectionOption.CameraEnabled[globalCameraIndex] = true;
		}

		inspectionOption.MachineStopActivated = true;
		inspectionOption.MachineStopDefectRatio = 20;
		inspectionOption.MachineStopUnInsRatio = 20;
		inspectionOption.SpeedIndex = 0;
		inspectionOption.NCAsDefect = false;
		inspectionOption.UnsaveDefectImage = false;
  }

  if(GlobalProgramID == PROGRAM_ID_150P)
  {
    //SELMA 150TP
    // ϵڵ Ͽ, CameraMapping  ValidStatus  ϱ
    for(int globalCameraIndex = 0; globalCameraIndex < SYSTEM_TOTAL_CAMERA_COUNT; globalCameraIndex++)
    {
      if(SystemLinkCameraInfo[globalCameraIndex] == 0)
      {
        inspectionOption.CameraEnabled[globalCameraIndex] = false;
      }
      else
      {
        inspectionOption.CameraEnabled[globalCameraIndex] = true;
      }
    }
  }
  else if(ProductData.TabletType == TABLET_TYPE_SUGAR_COATED)
  {
    // sugar coat
    for(int globalCameraIndex = 0; globalCameraIndex < SYSTEM_TOTAL_CAMERA_COUNT; globalCameraIndex++)
    {
      if(globalCameraIndex == SD1_2D_SIDE_FACE_00_CAMERA_INDEX - 1 ||
          globalCameraIndex == SD1_2D_OTHER_SIDE_FACE_00_CAMERA_INDEX - 1 ||
          globalCameraIndex == SD2_2D_SIDE_FACE_00_CAMERA_INDEX - 1 ||
          globalCameraIndex == SD2_2D_OTHER_SIDE_FACE_00_CAMERA_INDEX - 1)
      {
        inspectionOption.CameraEnabled[globalCameraIndex] = false;
      }
      else
      {
        inspectionOption.CameraEnabled[globalCameraIndex] = true;
      }
    }
  }
}
//---------------------------------------------------------------------------
void __fastcall TInspectionSetupForm::MachineStopActivatePanelClick(
      TObject *Sender)
{
	MachineStopActivatePanel->Color = clBlue;
  MachineStopActivatePanel->Font->Color = clWhite;

	MachineStopDeactivatePanel->Color = clWhite;
  MachineStopDeactivatePanel->Font->Color = clBlack;

  InspectionOption.MachineStopActivated = true;
}
//---------------------------------------------------------------------------
void __fastcall TInspectionSetupForm::MachineStopDeactivatePanelClick(
      TObject *Sender)
{
	MachineStopActivatePanel->Color = clWhite;
  MachineStopActivatePanel->Font->Color = clBlack;

	MachineStopDeactivatePanel->Color = clBlue;
  MachineStopDeactivatePanel->Font->Color = clWhite;

  InspectionOption.MachineStopActivated = false;
}
//---------------------------------------------------------------------------
void __fastcall TInspectionSetupForm::LOTNameEditClick(TObject *Sender)
{
	TTntEdit *theEdit = (TTntEdit *) Sender;

	KeyboardForm->Text = theEdit->Text;
  if (KeyboardForm->ShowKeyboard() == mrOk)
  {
		theEdit->Text = KeyboardForm->Text;
  }
}
//---------------------------------------------------------------------------
void __fastcall TInspectionSetupForm::LOTNameEditChange(TObject *Sender)
{
  LOTNameEdit->Text = Trim(LOTNameEdit->Text);
	AnsiString lotName = LOTNameEdit->Text;

  if(lotName == "123456_7891011")
  {
    if(TestModeCheckBox->Checked == false)
    {
      LOTNameEdit->Text = "";
    }
  }

  if (InspectionResultExists(lotName))
	{

    if(MachineSetupData.CompanyID == INTERNATIONAL_MACHINE2)
    {
      ReInspectionPanel->Visible = false;
    }
    else
    {
    	ReInspectionPanel->Visible = true;
  		InspectionOption.IsReInspection = true;
    }

		if (PCProgramOption.InspectionResetOnRestart)
		{
			ReInspectionTypeRadioGroup->ItemIndex = 0;
			InspectionOption.ReInspectionType = RE_INSPECTION_TYPE_NEW;
		}
		else
		{
			ReInspectionTypeRadioGroup->ItemIndex = 1;
			InspectionOption.ReInspectionType = RE_INSPECTION_TYPE_CONTINUE;
		}		
	}
	else
	{
		ReInspectionPanel->Visible = false;
    InspectionOption.IsReInspection = false;
    InspectionOption.ReInspectionType = RE_INSPECTION_TYPE_NEW;
    OkBitBtn->Visible = true;
	}
	this->ClientHeight = BottomMenuPanel->Top + BottomMenuPanel->Height;
}
//---------------------------------------------------------------------------
bool __fastcall TInspectionSetupForm::InspectionResultExists(WideString lotName)
{
	AnsiString resultDir = ProgramPath.Product + "\\" + ProductData.ProductCode + "\\Result";
  AnsiString resultFileName = resultDir + "\\" + lotName + ".dat";

	return FileExists(resultFileName);
}
//---------------------------------------------------------------------------
void __fastcall TInspectionSetupForm::MotorSpeedPanelClick(
      TObject *Sender)
{
	TTntPanel *thePanel = (TTntPanel *) Sender;
	CurrentMotorSpeedIndex = thePanel->Tag;
  ApplyInspectionOption(0);
}
//---------------------------------------------------------------------------
void __fastcall TInspectionSetupForm::CamEnabledPanelClick(
      TObject *Sender)
{
	TTntPanel *thePanel = (TTntPanel *) Sender;
  int globalCameraIndex = thePanel->Tag;

  InspectionOption.CameraEnabled[globalCameraIndex] = !InspectionOption.CameraEnabled[globalCameraIndex];
  ApplyInspectionOption(0);


}
//---------------------------------------------------------------------------
void __fastcall TInspectionSetupForm::MachineStopDefectRatioEditChange(
      TObject *Sender)
{
	try
  {
		int value = StrToInt(MachineStopDefectRatioEdit->Text);
		InspectionOption.MachineStopDefectRatio = value;
  }
  catch (...)
  {

  }
  ApplyInspectionOption(0);
}
//---------------------------------------------------------------------------
void __fastcall TInspectionSetupForm::MachineStopUnInsRatioEditChange(
      TObject *Sender)
{
	try
	{
		int value = StrToInt(MachineStopUnInsRatioEdit->Text);
		InspectionOption.MachineStopUnInsRatio = value;
	}
	catch(...)
	{

	}
	ApplyInspectionOption(0);
}
//---------------------------------------------------------------------------

void __fastcall TInspectionSetupForm::ReInspectionTypeRadioGroupClick(
	  TObject *Sender)
{
	InspectionOption.ReInspectionType = ReInspectionTypeRadioGroup->ItemIndex;
	ApplyInspectionOption(0);
}
//---------------------------------------------------------------------------

void __fastcall TInspectionSetupForm::SetLOTInformation()
{
  memset(InspectedLOTInformation, 0, sizeof(TInspectedLOTInformation) * 2000);

  TSearchRec sr, sr2;
  int iAttributes = faAnyFile;

  AnsiString resultDir = ProgramPath.Product + "\\" + ProductData.ProductCode + "\\Result";
  if (FindFirst(resultDir + "\\*.dat", iAttributes, sr) == 0)
  {
    do
    {
      inspectedLOTCount++;
    }while (FindNext(sr) == 0);

    FindClose(sr);
  }

  if(inspectedLOTCount > 2000)
    inspectedLOTCount = 2000;

  if(inspectedLOTCount)
  {
    if (FindFirst(resultDir + "\\*.dat", iAttributes, sr2) == 0)
    {
      int lotIndex;
      lotIndex = 0;

      do
      {
        AnsiString inspectionReportFileName = resultDir + "\\" + sr2.Name;

        NFA_INSPECTION_REPORT_STRUCT Report;
        bool Result = Read_InspectionReportData(inspectionReportFileName,Report);
        if(Result == false)
        {
          inspectedLOTCount-=1;
          continue;
        }
        /*TFileStream *fileStream = new TFileStream(inspectionReportFileName, fmOpenRead);
        TTabletInspectReport tabletInspectReport;
        TTabletInspectReportSub tabletInspectReportSub;
        TTabletInspectGradeData Temp_GradeData;
        int DefectSeriesCount[MAX_DEFECT_SERIES_COUNT + 1]={0};
        memset(&tabletInspectReportSub,0,sizeof(TTabletInspectReportSub));
        fileStream->Read(&tabletInspectReport, sizeof(TTabletInspectReport));
        fileStream->Read(&Temp_GradeData, sizeof(TTabletInspectGradeData));
        fileStream->Read(DefectSeriesCount, (MAX_DEFECT_SERIES_COUNT + 1) * sizeof(int));
        fileStream->Read(&tabletInspectReportSub,sizeof(TTabletInspectReportSub));
        delete fileStream;*/

        if(sr2.Name.SubString(0, sr2.Name.Length() - 4) == "123456_7891011") continue;

        InspectedLOTInformation[lotIndex].LOTName = sr2.Name.SubString(0, sr2.Name.Length() - 4);
        InspectedLOTInformation[lotIndex].InspectionEndTime.Val = Report.Data.InspectionEndTime;
        InspectedLOTInformation[lotIndex].goodProductCount = Report.Data.GoodTabletCount;
        InspectedLOTInformation[lotIndex].defectProductCount = Report.Data.DefectTabletCount;

        if(Report.SubData.BatchEndFlag[0] == NULL || Report.SubData.BatchEndFlag[0] == 0)
          InspectedLOTInformation[lotIndex].LotEndFlag = 0;
        else
          InspectedLOTInformation[lotIndex].LotEndFlag =1;

        if(Report.Data.TotalTabletCount > 0 && (Report.Data.TotalTabletCount - Report.Data.UnInsTabletCount) > 0)
          InspectedLOTInformation[lotIndex].ProductionDefectRatio = Report.Data.GoodTabletCount * 100.0 / (Report.Data.TotalTabletCount - Report.Data.UnInsTabletCount);
        else
          InspectedLOTInformation[lotIndex].ProductionDefectRatio = 0;

        lotIndex++;

      }while (FindNext(sr2) == 0);

      // Item ֱ ˻  迭

      TInspectedLOTInformation rearrangeInformation;
      for(int i = 0; i < inspectedLOTCount - 1; i++)
      {
        for(int j = i + 1; j < inspectedLOTCount; j++)
        {
          if(InspectedLOTInformation[i].InspectionEndTime.Val < InspectedLOTInformation[j].InspectionEndTime.Val)
          {
            rearrangeInformation.LOTName = InspectedLOTInformation[i].LOTName;
            rearrangeInformation.InspectionEndTime.Val = InspectedLOTInformation[i].InspectionEndTime.Val;
            rearrangeInformation.goodProductCount = InspectedLOTInformation[i].goodProductCount;
            rearrangeInformation.defectProductCount = InspectedLOTInformation[i].defectProductCount;
            rearrangeInformation.ProductionDefectRatio = InspectedLOTInformation[i].ProductionDefectRatio;
            rearrangeInformation.LotEndFlag = InspectedLOTInformation[i].LotEndFlag;

            InspectedLOTInformation[i].LOTName = InspectedLOTInformation[j].LOTName;
            InspectedLOTInformation[i].InspectionEndTime.Val = InspectedLOTInformation[j].InspectionEndTime.Val;
            InspectedLOTInformation[i].goodProductCount = InspectedLOTInformation[j].goodProductCount;
            InspectedLOTInformation[i].defectProductCount = InspectedLOTInformation[j].defectProductCount;
            InspectedLOTInformation[i].ProductionDefectRatio = InspectedLOTInformation[j].ProductionDefectRatio;
            InspectedLOTInformation[i].LotEndFlag = InspectedLOTInformation[j].LotEndFlag;

            InspectedLOTInformation[j].LOTName = rearrangeInformation.LOTName;
            InspectedLOTInformation[j].InspectionEndTime.Val = rearrangeInformation.InspectionEndTime.Val;
            InspectedLOTInformation[j].goodProductCount = rearrangeInformation.goodProductCount;
            InspectedLOTInformation[j].defectProductCount = rearrangeInformation.defectProductCount;
            InspectedLOTInformation[j].ProductionDefectRatio = rearrangeInformation.ProductionDefectRatio;
            InspectedLOTInformation[j].LotEndFlag = rearrangeInformation.LotEndFlag;
          }
        }
      }

      // 迭 ͸ comboBox  
      LOTComboBox1->Items->Clear();
      for(int itemIndex = 0; itemIndex < inspectedLOTCount; itemIndex++)
      {
        LOTComboBox1->Items->Add(InspectedLOTInformation[itemIndex].LOTName);
      }

      // default   ȭ鿡 ǥ
      GoodLabel2->Caption = IntToStr(InspectedLOTInformation[0].goodProductCount) + " T";
      DefectLabel2->Caption = IntToStr(InspectedLOTInformation[0].defectProductCount) + " T";
      QtyLabel2->Caption = FloatToStrF((double)InspectedLOTInformation[0].ProductionDefectRatio, ffGeneral, 4, 2) + " %"; 
      InspectionEndTimeLabel2->Caption = InspectedLOTInformation[0].InspectionEndTime.DateTimeString();

      
      LOTComboBox1->ItemIndex = 0;
    }
  }
}
//---------------------------------------------------------------------------

void __fastcall TInspectionSetupForm::LOTComboBox1Select(TObject *Sender)
{
  int itemIndex;
  itemIndex = LOTComboBox1->ItemIndex;

  GoodLabel2->Caption = IntToStr(InspectedLOTInformation[itemIndex].goodProductCount) + " T";
  DefectLabel2->Caption = IntToStr(InspectedLOTInformation[itemIndex].defectProductCount) + " T";
  QtyLabel2->Caption = FloatToStrF((double)InspectedLOTInformation[itemIndex].ProductionDefectRatio, ffGeneral, 4, 2) + " %";
  InspectionEndTimeLabel2->Caption = InspectedLOTInformation[itemIndex].InspectionEndTime.DateTimeString();
}
//---------------------------------------------------------------------------

void __fastcall TInspectionSetupForm::LOTSelectionBtnClick(TObject *Sender)
{
  int itemIndex;
  itemIndex = LOTComboBox1->ItemIndex;

  LOTNameEdit->Text = InspectedLOTInformation[itemIndex].LOTName;
  UserLOTSelectCheck = true;
}
//---------------------------------------------------------------------------

void __fastcall TInspectionSetupForm::LOTComboBox1Click(TObject *Sender)
{
  //LOTComboBox1->DroppedDown = true;
}
//---------------------------------------------------------------------------

void __fastcall TInspectionSetupForm::AdvancedOptionButtonClick(
      TObject *Sender)
{
  if(PCProgramOption.DistributorType3 == 1 || PCProgramOption.DistributorType4 == 1)
  {
    THR_SpecialInsForm *hrspecialinsform = new THR_SpecialInsForm(this);
    hrspecialinsform->ShowModal();
    delete hrspecialinsform;
  }
  else
  {
    TSpecialInsForm *specialinsform = new TSpecialInsForm(this);
    specialinsform->ShowModal();
    delete specialinsform;
  }

}
//---------------------------------------------------------------------------

void __fastcall TInspectionSetupForm::SpecialInsDAEHWAcheckboxClick(
      TObject *Sender)
{
  if(SpecialInsDAEHWAcheckbox->Checked)
  {
     AdvancedOptionButton->Enabled = true;
     //ProductData.SpecialInsCheckbox = SpecialInsDAEHWAcheckbox->Checked;
  }
  else
  {
     AdvancedOptionButton->Enabled = false;
     //ProductData.SpecialInsCheckbox = SpecialInsDAEHWAcheckbox->Checked;
  }
}
//---------------------------------------------------------------------------
void __fastcall TInspectionSetupForm::TestModeCheckBoxClick(
      TObject *Sender)
{
  if(TestModeCheckBox->Checked)
  {
    LOTNameEdit->Text = "123456_7891011";
    LOTNameEdit->Enabled = false;
    InspectionOption.ReInspectionType = 0;
  	ApplyInspectionOption(0);
    UnsaveDefectImageCheckBox->Visible = false;
    TestMode = 1;
    OkBitBtn->Visible = true;
  }
  else
  {
    LOTNameEdit->Text = "";
    LOTNameEdit->Enabled = true;
    UnsaveDefectImageCheckBox->Visible = true;
    TestMode = 0;
  }  
}

bool __fastcall TInspectionSetupForm::GetTestModeOption() 
{
   return TestMode;
}
bool __fastcall TInspectionSetupForm::GetReturnCode()
{
   return AjantaReturnCode;
}
//---------------------------------------------------------------------------
void __fastcall TInspectionSetupForm::TntFormActivate(TObject *Sender)
{
  if(MachineSetupData.CompanyID == INTERNATIONAL_MACHINE1)
  {
    Panel4->Height = 378;
    GroupBox6->Height = 362;
    GroupBox3->Top = 248;
  }
  else
  {
    GroupBox6->Height = 252;
    GroupBox3->Top = 136;
    Panel4->Height = 272;
  }
  this->ClientHeight = BottomMenuPanel->Top + BottomMenuPanel->Height;
}
//---------------------------------------------------------------------------
void __fastcall TInspectionSetupForm::SetAcrociaStartCommandStatus(bool Status)
{
  AcrociaCommandStartProcess = Status;
}
//---------------------------------------------------------------------------

