//---------------------------------------------------------------------------

#ifndef InspectionSetup_FormH
#define InspectionSetup_FormH
//---------------------------------------------------------------------------
#include <Classes.hpp>
#include <Controls.hpp>
#include <StdCtrls.hpp>
#include <Forms.hpp>
#include <ExtCtrls.hpp>
#include <Buttons.hpp>

#include "processing.h"

#include "common.h"
#include "TntButtons.hpp"
#include "TntExtCtrls.hpp"
#include "TntStdCtrls.hpp"
#include "TntForms.hpp"

#define	RE_INSPECTION_TYPE_NEW			0
#define	RE_INSPECTION_TYPE_CONTINUE		1
#define RE_INSPECTION_TYPE_REINS1		2
#define RE_INSPECTION_TYPE_REINS2		3

typedef struct
{
	bool IsReInspection;
	int DesiredInspectionCount;
	int MachineStopDPCount;
	int MachineStopUPCount;
  int QMachineDischargeActiveCount;
  int QMachineMisejectActiveLimitCount;

  int DesiredInspectionLimitCountActive;
	int MachineStopDPLimitCountActive;
	int MachineStopUPLimitCountActive;
  int QMachineDischargeActive;
  int QMachineMisejectActive;

	int ReInspectionType;
	bool IsSingleDiscMode;
	bool CameraEnabled[SYSTEM_TOTAL_CAMERA_COUNT];
	bool MachineStopActivated;
  int MachineStopDefectRatio;
  int MachineStopUnInsRatio;
	bool NCAsDefect;
	int SpeedIndex;
	bool UnsaveDefectImage;
  int CheckUnPrint;

  int SpecialInsCheckbox;
  int SpecialInsCount[6];

  int MachineStopTotalCount;

  int LaserActiveMode;
} TInspectionOption;

typedef struct
{
	WideString LOTName;
  TDateTime InspectionEndTime;
  int goodProductCount;
  int defectProductCount;
  double ProductionDefectRatio;
  bool LotEndFlag; // Ajanta ܵ û 
}TInspectedLOTInformation;

//---------------------------------------------------------------------------
class TInspectionSetupForm : public TTntForm
{
__published:	// IDE-managed Components
	TTntPanel *Panel2;
	TTntLabel *Label1;
	TTntEdit *LOTNameEdit;
	TTntPanel *BottomMenuPanel;
	TTntBitBtn *CancelBitBtn;
	TTntBitBtn *OkBitBtn;
	TTntPanel *Panel4;
	TTntPanel *Panel5;
	TTntButton *AdvancedOptionButton;
	TTntPanel *Panel15;
    TTntLabel *Label12;
    TTntEdit *ProductionCountEdit;
    TTntLabel *Label13;
	TTntPanel *ReInspectionPanel;
	TTntRadioGroup *ReInspectionTypeRadioGroup;
	TTntGroupBox *GroupBox6;
	TTntGroupBox *GroupBox1;
	TTntRadioButton *InfiniteCountRadioButton;
	TTntRadioButton *FiniteCountRadioButton;
	TTntEdit *InspectionCountEdit;
	TTntGroupBox *GroupBox4;
	TTntRadioButton *InfiniteDPCountRadioButton;
	TTntRadioButton *RadioButton2;
	TTntEdit *MachineStopDPCountEdit;
	TTntGroupBox *GroupBox5;
	TTntRadioButton *InfiniteUPCountRadioButton;
	TTntRadioButton *RadioButton4;
	TTntEdit *MachineStopUPCountEdit;
	TTntGroupBox *GroupBox3;
	TTntLabel *Label2;
	TTntLabel *Label3;
	TTntLabel *Label4;
	TTntLabel *Label5;
	TTntLabel *Label6;
	TTntEdit *MachineStopUnInsRatioEdit;
	TTntEdit *MachineStopDefectRatioEdit;
	TTntPanel *MachineStopActivatePanel;
	TTntPanel *MachineStopDeactivatePanel;
	TTntCheckBox *UnsaveDefectImageCheckBox;
  TGroupBox *recentLOTGroupBox;
  TLabel *InspectionEndTimeLabel;
  TLabel *GoodLabel;
  TLabel *DefectLabel;
  TLabel *QtyLabel;
  TLabel *GoodLabel2;
  TLabel *DefectLabel2;
  TLabel *QtyLabel2;
  TLabel *InspectionEndTimeLabel2;
  TTntComboBox *LOTComboBox1;
  TTntCheckBox *SpecialInsDAEHWAcheckbox;
  TTntPanel *CamEnabledPanel1;
  TTntPanel *CamEnabledPanel2;
  TTntPanel *CamEnabledPanel3;
  TTntPanel *CamEnabledPanel4;
  TTntPanel *CamEnabledPanel5;
  TTntPanel *CamEnabledPanel6;
  TTntPanel *CamEnabledPanel7;
  TTntPanel *CamEnabledPanel8;
  TTntPanel *CamEnabledPanel9;
  TTntPanel *CamEnabledPanel10;
  TTntPanel *CamEnabledPanel11;
  TTntPanel *CamEnabledPanel12;
  TTntPanel *CamEnabledPanel13;
  TTntPanel *CamEnabledPanel14;
  TTntPanel *CamEnabledPanel15;
  TTntPanel *CamEnabledPanel16;
  TTntPanel *MotorSpeedPanel1;
  TTntPanel *MotorSpeedPanel2;
  TTntPanel *MotorSpeedPanel3;
  TTntLabel *Label8;
  TTntLabel *BFIDSpeedLabel;
  TTntLabel *Label10;
  TTntLabel *VDSpeedLabel;
  TTntLabel *Label9;
	TTntLabel *BFODInSpeedLabel;
  TTntCheckBox *TestModeCheckBox;
  TTntGroupBox *GroupBox2;
  TTntGroupBox *GroupBox7;
  TTntButton *LOTSelectionBtn;
  TTntGroupBox *TntGroupBox1;
  TTntRadioButton *QInfiniteDischargeActiveCountRadioButton;
  TTntRadioButton *QFInfiniteDischargeActiveCountButton;
  TTntEdit *QDischargeCountEdit;
  TTntGroupBox *TntGroupBox2;
  TTntRadioButton *QInfiniteMisejectActiveCountRadioButton;
  TTntRadioButton *QFInfiniteMisejectActiveCountRadioButton;
  TTntEdit *QMisejectCountEdit;
	TTntLabel *TntLabel1;
	TTntLabel *BFODOutSpeedLabel;
	void __fastcall OkBitBtnClick(TObject *Sender);
	void __fastcall FormCreate(TObject *Sender);
	void __fastcall NumberEditClick(TObject *Sender);
	void __fastcall MachineStopActivatePanelClick(TObject *Sender);
	void __fastcall MachineStopDeactivatePanelClick(TObject *Sender);
	void __fastcall LOTNameEditClick(TObject *Sender);
	void __fastcall LOTNameEditChange(TObject *Sender);
	void __fastcall MotorSpeedPanelClick(TObject *Sender);
	void __fastcall CamEnabledPanelClick(TObject *Sender);
	void __fastcall MachineStopDefectRatioEditChange(TObject *Sender);
	void __fastcall MachineStopUnInsRatioEditChange(TObject *Sender);
	void __fastcall ReInspectionTypeRadioGroupClick(TObject *Sender);
  void __fastcall LOTComboBox1Select(TObject *Sender);
  void __fastcall LOTSelectionBtnClick(TObject *Sender);
  void __fastcall LOTComboBox1Click(TObject *Sender);
  void __fastcall AdvancedOptionButtonClick(TObject *Sender);
  void __fastcall SpecialInsDAEHWAcheckboxClick(TObject *Sender);
  void __fastcall TestModeCheckBoxClick(TObject *Sender);
  void __fastcall TntFormActivate(TObject *Sender);
private:	// User declarations
	TInspectionOption InspectionOption;
  TTabletGradeData TabletGradeData;
    int CurrentMotorSpeedIndex;
    int inspectedLOTCount;
    bool UserLOTSelectCheck;
    TInspectedLOTInformation InspectedLOTInformation[2000];
    bool TestMode;
    bool AjantaReturnCode;
    bool AcrociaCommandStartProcess; // Acrocia dll Command Start
    void __fastcall ApplyInspectionOption(int option);
    bool __fastcall InspectionResultExists(WideString lotName);
    void __fastcall GetDefaultString();
    void __fastcall SetLOTInformation();
public:		// User declarations
	__fastcall TInspectionSetupForm(TComponent* Owner);
    void __fastcall GetInspectionOption(TInspectionOption &inspectionOption);
    void __fastcall SetInspectionOption(TInspectionOption &inspectionOption);
    bool __fastcall GetTestModeOption(); // Ajanta
    bool __fastcall GetReturnCode();
    void __fastcall SetAcrociaStartCommandStatus(bool Status);
};
//---------------------------------------------------------------------------
void __fastcall InitInspectionOption(TInspectionOption &inspectionOption);
//---------------------------------------------------------------------------
extern PACKAGE TInspectionSetupForm *InspectionSetupForm;
//---------------------------------------------------------------------------
#endif
