//---------------------------------------------------------------------------

#ifndef Inspection_FormH
#define Inspection_FormH
//---------------------------------------------------------------------------
#include <Classes.hpp>
#include <Controls.hpp>
#include <StdCtrls.hpp>
#include <Forms.hpp>
#include <Buttons.hpp>
#include <ExtCtrls.hpp>
#include <Chart.hpp>
#include <Series.hpp>
#include <TeEngine.hpp>
#include <TeeProcs.hpp>
#include <Grids.hpp>
#include <list.h>

#include "client.h"

#include "DefectInfo_Form.h"
#include "Processing.h"
#include "Environment.h"
//#include "InspectionSetting_Form.h"
#include "InspectionSetup_Form.h"
#include <ComCtrls.hpp>
#include "TntButtons.hpp"
#include "TntComCtrls.hpp"
#include "TntExtCtrls.hpp"
#include "TntGrids.hpp"
#include "TntStdCtrls.hpp"
#include "TntForms.hpp"
#include "cpb_module.h"
#include "Calibration_Form.h"

#define THROUGHPUT_FILE_VERSION			100
#define THROUGHPUT_CHART_DEFAULT_SIZE	360		// 1 hour
#define RATIO_CHART_COUNT		    	101
#define DEFECT_INFO_LIST_COUNT			1024
#define DEFECT_INFO_LIST_MASK			1023
//#define MAX_CPB_DEFECT_SERIES_COUNT		38
//#define MAX_DEFECT_SERIES_COUNT			(MAX_CPB_DEFECT_SERIES_COUNT + 2)

#define INSPECTION_STATE_STOP					0
#define INSPECTION_STATE_START					1
#define INSPECTION_STATE_SUSPEND				2
#define INSPECTION_STATE_STOPPING				3
#define INSPECTION_STATE_MACHINE_STOP			4
#define INSPECTION_STATE_WAIT_STOP1     5
#define INSPECTION_STATE_WAIT_STOP2     6
#define INSPECTION_STATE_WAIT_STOP_RESUME 7

#define INSPECTION_STOP_OPTION_NONE				0
#define INSPECTION_STOP_OPTION_MACHINE_STOP		1
#define INSPECTION_STOP_OPTION_INSPECTION_STOP	2

#define	DEFECT_IMAGE_KIND_DEFECT				0
#define	DEFECT_IMAGE_KIND_CLOSED				1
#define	DEFECT_IMAGE_KIND_UNINS					2
#define	DEFECT_IMAGE_KIND_UNPRINTED			3
#define	DEFECT_IMAGE_KIND_POSITION			4

#define DEFECT_SERIES_HEAP_SIZE					256
#define DEFECT_SERIES_HEAP_MASK					255

#define EJECT_NORMAL_MODE      0
#define EJECT_SPECIAL_MODE     1

#define EJECT_INFO_DEFAULT_INTERVAL 120
#define EJECT_INFO_DEFAULT_START_POS  35
#define EJECT_INFO_DEFAULT_END_POS    20

#define EJECT_INFO_STD_LENGTH 19 // 19mm 

#define ERROR_CODE_CAPTURE_TIMEOUT_RATIO 50.0f

#define REALTIME_CAMERA_WIDTH       SYSTEM_CAMERA_WIDTH / 4
#define REALTIME_CAMERA_HEIGHT      SYSTEM_CAMERA_HEIGHT / 4
#define REALTIME_IMAGE_SIZE         REALTIME_CAMERA_WIDTH * REALTIME_CAMERA_HEIGHT
#define MAX_RT_IMAGE_BUFFER_SIZE    (48 * 1024 * 1024) / (REALTIME_IMAGE_SIZE)

#define MILLIMETER_PER_PIXEL  46.86f // 30mm FOV

#define HCB_MONITORING_DATA_COUNT 1000
//---------------------------------------------------------------------------
typedef struct
{
	unsigned int TabletNumber;
	char DefectSeries;
} TDefectSeriesInfo;

typedef struct
{
	unsigned int TabletNumber;
	char DefectSeries;
	char MajorCamera;
} TDefectTabletInfo;

typedef struct
{
	int EjectMode;
  int BlowInterval;
  int BlowStart;
  int BlowLength;
  int UnInsBlowCheck;
  int SPGoodTabletCollectCount1;     //Q Special mode Eject Count
  int SPGoodTabletCollectCount2;
  int DistributorGoodTabletCount1;  //ѱݸ 3й Count
  int DistributorGoodTabletCount2;
  int DistributorGoodTabletCount3;
  double MisejectActiveTime;
}TEjectorSettingInfo;

typedef struct
{
	int DefectTabletNumber;
	int DefectImageKind;
} TDefectTabletListUnit;

//---------------------------------------------------------------------------
class TInspectionForm : public TTntForm
{
__published:	// IDE-managed Components
	TTntPanel *Panel1; // ߰
  TTntPanel *Panel12; // ߰
	TTntPanel *InspetionInfoPanel;
	TTimer *InspectionInfoTimer;
	TTntPanel *ClientPanel;
	TTntPanel *Panel17;
	TTntPanel *Panel18;
	TTntBitBtn *CloseBitBtn;
	TTntButton *ShowImageButton;
	TTntButton *InspectionStartButton;
	TTntButton *InspectionStopButton;
	TTntButton *GradeSettingButton;
	TTntButton *SpeedControlButton;
	TTntPanel *Panel11;
	TTntPanel *ThroughputPanel;
	TTntPanel *Panel7;
	TChart *ThroughputChart;
	TLineSeries *Series3;
	TTntPanel *DefectRatioPanel;
	TTntPanel *Panel10;
  TChart *InspectionRatioChart;
	TLineSeries *LineSeries1;
	TTntPanel *Panel15;
	TTntPanel *InspectChartPanel;
	TChart *InspectionChart;
	TTntPanel *Panel9;
	TTntLabel *Label1;
	TTntLabel *TotalTabletCountLabel;
	TTntLabel *Label2;
	TTntLabel *GoodTabletCountLabel;
	TTntLabel *Label5;
	TTntLabel *DefectTabletCountLabel;
	TTntLabel *Label7;
	TTntLabel *UnInsTabletCountLabel;
	TTntShape *Shape1;
	TTntShape *Shape2;
	TTntShape *Shape3;
  TTntLabel *SectionRatioLabel;
	TTntLabel *Label25;
  TTntLabel *TotalRatioChartLabel;
	TTntLabel *Label26;
	TBarSeries *Series1;
	TTntLabel *Label18;
	TTntLabel *TPHLabel;
	TTntLabel *Label20;
	TTntLabel *Label21;
	TTntLabel *Label22;
	TTntLabel *TotalTPHLabel;
	TTntLabel *ElapsedTimeLabel;
	TTntPanel *Panel5;
	TTntPanel *Panel6;
	TTntSpeedButton *ThroughPutChartSpeedButton;
	TTntSpeedButton *DefectRatioChartSpeedButton;
	TTntSpeedButton *InspectChartSpeedButton;
  TTntSpeedButton *CountCheckSpeedButton;
	TTntPanel *Panel2;
	TTntPanel *Panel16;
	TTntPanel *Panel19;
	TTntPanel *ProductNamePanel;
	TTntPanel *Panel22;
	TTntPanel *Panel23;
	TTntPanel *LOTNamePanel;
	TTntPanel *Panel21;
	TTntPanel *Panel25;
	TTntPanel *TotalTabletCountPanel;
	TTntPanel *Panel27;
	TTntPanel *Panel28;
	TTntPanel *ProductRatioPanel;
	TTntPanel *Panel38;
	TTntPanel *Panel39;
	TTntPanel *Panel40;
	TTntPanel *Panel41;
	TTntPanel *TPHPanel;
	TTntPanel *Panel43;
	TTntPanel *Panel44;
	TTntPanel *TotalTPHPanel;
	TTntPanel *Panel49;
	TTntPanel *Panel3;
	TTntPanel *Panel50;
	TTntStringGrid *DefectInfoStringGrid;
	TTntPanel *Panel8;
	TTntButton *InspectionRestartButton;
	TTntPanel *Panel24;
	TTntPanel *Panel20;
	TTimer *SystemTimeTimer;
	TTntPanel *Panel34;
	TTntPanel *Panel51;
	TTntPanel *Panel29;
  TTntPanel *GradePanel;
	TTntPanel *OptionalInfoPanel;
	TTntPanel *Panel30;
	TTntPanel *Panel31;
	TTntPanel *Panel32;
	TTntPanel *Panel33;
	TTntPanel *GoodProductCountPanel;
	TTntPanel *Panel35;
	TTntPanel *Panel36;
	TTntPanel *DefectProductCountPanel;
	TTntPanel *Panel46;
	TTntPanel *Panel47;
	TTntPanel *UnInsProductCountPanel;
	TTntPanel *Panel37;
	TTntPanel *Panel42;
	TTntPanel *Panel48;
	TTntPanel *Panel52;
	TTntPanel *Panel53;

	TTntImage *CurrentDefectImage;
	TTntPanel *Panel54;
	TTntPanel *DefectDataInfoPanel;
	TTntStringGrid *DefectDataStringGrid;
	TTntPanel *GradeInfoPanel;
  TTntPanel *Panel62;
  TTntPanel *Panel60;
  TTntPanel *Panel63;
  TTntPanel *Panel61;
  TTntPanel *Panel64;
	TTntStringGrid *FrontStainGradeInfoStringGrid;
  TTntPanel *Panel65;
  TTntStringGrid *SideGradeInfoStringGrid;
	TTimer *DefectCheckTimer;
  TTntPanel *InspectionResultPanel;
  TTntImage *InspectionResultImage;
  TTimer *ProcessingCheckTimer;
  TTimer *InspectionResultTimer;
  TTntSpeedButton *VibratorInfoSpeedButton;
  TTntPanel *VibratorInfoPanel;
  TChart *VibratorInfoChart;
  TLineSeries *LineSeries2;
  TLineSeries *Series2;
  TLineSeries *Series4;
  TTimer *VibratorInfoTimer;
  TLineSeries *Series5;
  TTntPanel *Panel66;
  TTntPanel *Panel73;
  TTntPanel *Panel77;
	TTntStringGrid *ThreeDCameraGradeInfoStringGrid;
  TLineSeries *Series6;
  TLineSeries *Series7;
	TTntPanel *Panel26;
	TTntPanel *Panel78;
	TTntPanel *Panel79;
	TTntStringGrid *FrontDirtyGradeInfoStringGrid;
	TTntPanel *Panel80;
	TTntPanel *Panel81;
	TTntStringGrid *PrintGradeInfoStringGrid;
	TTntPanel *Panel68;
	TTntStringGrid *ColorGradeInfoStringGrid;
	TTntPanel *Panel69;
	TTntPanel *Panel70;
	TTntPanel *Panel71;
	TTntPanel *Panel74;
	TTntPanel *Panel13;
	
	TTntPanel *MachineStopUPCountPanel;
	TTntPanel *Panel75;
	TTntPanel *Panel83;
	TTntPanel *MachineStopDPCountPanel;
	TTntPanel *Panel45;
	TTntPanel *MachineStopDefectRatioPanel;
	TTntPanel *Panel85;
	TTntPanel *MachineStopUnInsRatioPanel;
	TTntLabel *Label36;
	TTntUpDown *VFSpeedControlUpDown;
	TTntEdit *VFSpeedControlEdit;
	TTntButton *VibrationStopButton;
	TTntButton *NCControlButton;
	TTntSpeedButton *MisejectSpeedButton;
	TTntPanel *MisejectInfoPanel;
	TTntGroupBox *GroupBox8;
	TTntLabel *Label16;
	TTntLabel *MisejectActiveCountLabel;
	TTntLabel *Label51;
	TTntLabel *MisejectUnInsTabletCountLabel;
	TTntLabel *Label56;
	TTntLabel *MisejectDefectTabletCountLabel;
	TTntLabel *Label58;
	TTntLabel *MisejectTabletInsertCountLabel;
	TTntLabel *Label60;
	TTntLabel *GoodTabletLostCountLabel;
	TTntPanel *MachineInfoPanel;
	TTntPanel *Panel56;
	TTntPanel *Panel76;
	TTntPanel *Panel82;
	TTntPanel *BFODMotorRPMPanel;
	TTntPanel *Panel59;
	TTntPanel *Panel86;
	TTntPanel *BFIDMotorRPMPanel;
	TTntPanel *Panel88;
	TTntPanel *Panel89;
	TTntPanel *SDMotorRPMPanel;
	TTntPanel *Panel91;
	TTntPanel *Panel95;
	TTntPanel *Panel96;
	TTntPanel *BFEmptySensorRatioPanel;
	TTntPanel *Panel98;
	TTntPanel *Panel99;
	TTntPanel *VFSpeedPanel;
	TTntPanel *Panel101;
	TTntPanel *Panel102;
	TTntPanel *BFFullSensorRatioPanel;
	TTntPanel *Panel92;
	TTntButton *CleaningButton;
	TTntPanel *Panel93;
	TTntPanel *Panel94;
	TTntPanel *TemperatuePanel3;
	TTntPanel *Panel105;
	TTntPanel *Panel106;
  TTntPanel *InverterSpeedPanel3;
	TTntPanel *Panel108;
	TTntPanel *Panel109;
  TTntPanel *InverterSpeedPanel2;
	TTntPanel *Panel111;
	TTntPanel *Panel112;
	TTntPanel *PressurePanel3;
	TTntPanel *Panel114;
	TTntPanel *Panel115;
	TTntPanel *PressurePanel2;
	TTntPanel *Panel117;
	TTntPanel *Panel118;
	TTntPanel *TemperatuePanel2;
	TTntPanel *Panel120;
	TTntPanel *Panel121;
	TTntPanel *TemperatuePanel1;
	TTntPanel *Panel123;
	TTntPanel *Panel124;
	TTntPanel *PressurePanel1;
	TTntPanel *Panel126;
	TTimer *SystemMonitoringTimer;
	TTntPanel *CounterSensorPanel;
	TTntLabel *Label6;
	TTntLabel *CountedTabletCountLabel;
	TTntShape *Shape14;
	TTntSpeedButton *InspectionResultSpeedButton;
	TTntPanel *TabletInfoPanel;
	TTntPanel *Panel84;
	TTntPanel *Panel100;
	TTntPanel *Panel103;
	TTntPanel *TabletShapePanel;
	TTntPanel *Panel107;
	TTntPanel *Panel110;
	TTntPanel *TabletKindPanel;
	TTntPanel *Panel116;
	TTntPanel *Panel119;
	TTntPanel *Panel122;
	TTntPanel *TabletThickPanel;
	TTntPanel *Panel127;
	TTntPanel *Panel128;
	TTntPanel *TabletWidthPanel;
	TTntPanel *Panel130;
	TTntPanel *Panel131;
	TTntPanel *TabletSideThickPanel;
	TTntPanel *Panel143;
	TTntPanel *Panel144;
	TTntPanel *TabletEngravePosPanel;
	TTntPanel *Panel146;
	TTntPanel *Panel147;
	TTntPanel *TabletEngraveKindPanel;
	TTntPanel *Panel158;
	TTntPanel *Panel87;
	TTntPanel *Panel90;
	TTntPanel *TabletLengthPanel;
	TTntPanel *Panel55;
	TTntButton *UnmanedOperationButton;
	TTntPanel *VFAutoModePanel;
	TTntLabel *Label27;
	TTntLabel *AutoModeSensor1OnRatioLabel;
	TTntLabel *Label31;
	TTntLabel *AutoModeSensor2OnRatioLabel;
	TTntLabel *Label35;
	TTntLabel *SetRatio1_Label;
	TTntLabel *Label39;
	TTntLabel *SetRatio2_Label;
	TTntLabel *Label43;
	TTntLabel *Label29;
	TTntLabel *NowSpeed_Label;
	TLineSeries *Series9;
	TTntPanel *VFManualModePanel;
	TTntLabel *Label19;
	TTntLabel *ManualModeSensor1OnRatioLabel;
	TTntLabel *Label33;
	TTntLabel *ManualModeSensor2OnRatioLabel;
	TTntLabel *Label41;
	TTntLabel *VibratorManualSensorIndexLabel;
	TTntLabel *Label49;
	TTntLabel *VibratorManualSensorRatioLabel;
	TTntLabel *Label57;
	TTntLabel *Label59;
	TTntLabel *VibratorCurrentSpeedLabel;
	TTntPanel *VFManualModeControlPanel;
  TTimer *AppUpdateTimer2;
  TTntSpeedButton *APP;
  TTntPanel *DateTimeLabel;
  TTntPanel *InspectionTimeLabel;
  TTntPanel *Label32;
  TTntPanel *TntPanel1;
  TTntSpeedButton *EjectorSettingSpeedButton;
  TTntPanel *EjectorSettingPanel;
  TGroupBox *GroupBox9;
  TTntLabel *EjectorLabel5;
  TTntLabel *EjectorLabel6;
  TTntLabel *EjectorLabel7;
  TRadioButton *EjectorMode1RB;
  TRadioButton *EjectorMode2RB;
  TTntPanel *EjectorPanel1;
  TTntLabel *EjectorLabel1;
  TEdit *EjectorEdit1;
  TEdit *EjectorEdit2;
  TEdit *EjectorEdit3;
  TCheckBox *EjectorCB1;
  TButton *ApplyDefaultEjectInfoBtn;
  TTntPanel *StopInfoPanel;
  TTimer *TcpSndTimer1;
  TGroupBox *GroupBox10;
  TTntLabel *TntLabel1;
  TTntLabel *TntLabel2;
	TTntPanel *TntDistributorPanel2;
	TTntPanel *TntDistributorPanel1;
  TTntLabel *Label23;
  TEdit *GoodCollect1Edit;
  TTntLabel *Label30;
  TTntLabel *Label37;
  TEdit *GoodCollect2Edit;
  TTntPanel *TntPanel2;
  TTntPanel *TntPanel3;
  TTntPanel *InverterSpeedPanel1;
	TTntPanel *DistributorTntPanel;
	TTntLabel *TntLabel3;
	TTntLabel *TntLabel4;
	TTntLabel *TntLabel5;
	TTntLabel *TntLabel6;
	TTntEdit *DistributorGoodCollect1Edit;
	TTntEdit *DistributorGoodCollect2Edit;
	TTntEdit *DistributorGoodCollect3Edit;
	TTntPanel *TntDistributorPanel3;
	TTntLabel *TntLabel7;
  TTimer *UVLinkTimer;
  TTimer *AlarmTimer;
  TTntPanel *MachineStopGPCountPanel;
  TTntPanel *TntPanel12;
  TTntPanel *TntPanel13;
  TTntPanel *MachineStopTotalCountPanel;
  TTntPanel *QDischargeCountNamePanel;
  TTntPanel *QDischargeCountPanel;
  TTntPanel *TntPanel15;
  TTntPanel *QMisejectCountMainPanel;
  TTntPanel *QMisejectCountNamePanel;
  TTntPanel *QMisejectCountPanel;
  TTntPanel *TntPanel20;
  TTntButton *QDischargeResetBtn;
  TTntButton *QMisejectResetbtn;
  TTntPanel *QDischargeCountMainPanel;
  TTntEdit *MisejectTimeEdit;
  TTntLabel *MisejectActiveTimeLabel;
  TTntEdit *DumperUsalActiveTimeEdit;
  TTntLabel *TntLabel8;
  TTntPanel *UnPrintPanel;
  TTntLabel *TntLabel9;
  TTntLabel *UnPrintCountLabel;
  TTntShape *TntShape1;
  TTntPanel *LaserStatusInfoPanel;
  TGroupBox *CPBStatusGroupBox;
  TTntShape *CPBStatusShape1;
  TTntLabel *TntLabel10;
  TTntShape *CPBStatusShape2;
  TTntShape *CPBStatusShape3;
  TTntShape *CPBStatusShape4;
  TTntShape *CPBStatusShape5;
  TTntShape *CPBStatusShape6;
  TTntShape *CPBStatusShape7;
  TTntShape *CPBStatusShape8;
  TTntLabel *TntLabel11;
  TTntShape *CPBStatusShape9;
  TTntShape *CPBStatusShape10;
  TTntShape *CPBStatusShape11;
  TTntShape *CPBStatusShape12;
  TTntShape *CPBStatusShape13;
  TTntShape *CPBStatusShape14;
  TTntShape *CPBStatusShape15;
  TTntShape *CPBStatusShape16;
  TTntShape *CPBStatusShape25;
  TTntShape *CPBStatusShape24;
  TTntShape *CPBStatusShape23;
  TTntShape *CPBStatusShape17;
  TTntShape *CPBStatusShape22;
  TTntShape *CPBStatusShape21;
  TTntShape *CPBStatusShape20;
  TTntShape *CPBStatusShape19;
  TTntShape *CPBStatusShape18;
  TTntShape *CPBStatusShape32;
  TTntShape *CPBStatusShape31;
  TTntShape *CPBStatusShape30;
  TTntShape *CPBStatusShape29;
  TTntShape *CPBStatusShape28;
  TTntShape *CPBStatusShape27;
  TTntShape *CPBStatusShape26;
  TTntLabel *TntLabel12;
  TTntLabel *TntLabel13;
  TTimer *CPBStatusCheckTimer;
  TTimer *UploadRealtimeCapturedImageTimer;
  TGroupBox *LaserMonitoringGroupBox;
  TTntLabel *TntLabel14;
  TProgressBar *RT2DBuffering;
  TProgressBar *RT3DBuffering;
  TTntLabel *TntLabel15;
  TTntStringGrid *LaserMonitoringStringGrid;
  TTntLabel *TntLabel16;
  TTntLabel *TntLabel17;
  TTntPanel *MarkingInfoPagePanel;
  TTntLabel *MaxMarkingInfoPageCount;
  TTntButton *Decrease;
  TTntEdit *CurrentMarkingInfoPageCount;
  TTntButton *TntButton2;
  TGroupBox *GroupBox11;
  TTntLabel *TntLabel18;
  TTntLabel *AverageBrightnessLabel;
  TTntLabel *TntLabel23;
  TTntLabel *AverageThetaLabel;
  TTntLabel *TntLabel21;
  TTntLabel *TntLabel22;
  TTntLabel *AverageYLabel;
  TTntLabel *AverageXLabel;
  TTimer *HCBMonitoringTimer;
  TButton *HCBMonitoringButton;
  TTntPanel *InspectionCountInfoPanel;
  TTntPanel *UnInsCountPanel;
  TTntPanel *Panel58;
  TTntSpeedButton *UnInsCountCheckingBtn;
  TTntSpeedButton *DefectCountCheckingBtn;
  TTntPanel *DefectCountPanel;
  TTntPanel *Panel4;
  TTntPanel *ChartSelectionLabel;
  TTntPanel *CPBDefectCountInfoPanel;
  TTntPanel *CPBDefectCountTitlePanel;
  TTntPanel *Panel72;
  TChart *DefectChart;
  TPieSeries *Series8;
  TTntPanel *Panel14;
  TTntLabel *DefectNameLabel1;
  TTntLabel *DefectCountLabel1;
  TTntLabel *DefectNameLabel2;
  TTntLabel *DefectCountLabel2;
  TTntLabel *DefectNameLabel3;
  TTntLabel *DefectCountLabel3;
  TTntShape *DefectSeriesShape1;
  TTntShape *DefectSeriesShape2;
  TTntShape *DefectSeriesShape3;
  TTntLabel *DefectNameLabel4;
  TTntLabel *DefectCountLabel4;
  TTntLabel *DefectNameLabel5;
  TTntLabel *DefectCountLabel5;
  TTntShape *DefectSeriesShape4;
  TTntShape *DefectSeriesShape5;
  TTntLabel *DefectNameLabel6;
  TTntLabel *DefectCountLabel6;
  TTntLabel *DefectNameLabel7;
  TTntLabel *DefectCountLabel7;
  TTntLabel *DefectNameLabel8;
  TTntLabel *DefectCountLabel8;
  TTntShape *DefectSeriesShape6;
  TTntShape *DefectSeriesShape7;
  TTntShape *DefectSeriesShape8;
  TTntLabel *DefectNameLabel9;
  TTntLabel *DefectCountLabel9;
  TTntLabel *DefectNameLabel10;
  TTntLabel *DefectCountLabel10;
  TTntShape *DefectSeriesShape9;
  TTntShape *DefectSeriesShape10;
  TTntPanel *HCBDefectCountInfoPanel;
  TTntPanel *HCBDefectCountTitlePanel;
  TTntPanel *Panel104;
  TTntLabel *Label14;
  TTntLabel *SPBPNCCountLabel;
  TTntLabel *NozzErrorDefectTabletCountLabel;
  TTntLabel *Label12;
  TTntLabel *FRMismatchDefectLabel;
  TTntLabel *FRMismatchTabletCountLabel;
  TTntLabel *UnPrintDefectLabel;
  TTntLabel *UnPrintTabletCountLabel;
  TTntPanel *Panel97;
  TTntPanel *DefectTotalCountPanel;
  TTntPanel *SimulationPanel;
  TGroupBox *TestSimulBox;
  TTntGroupBox *TestLaserMcBsp;
  TTntLabel *Label62;
  TTntLabel *Label61;
  TEdit *LMCPeriodEdit;
  TButton *LaserMcbsp_Stop;
  TButton *LaserMcbap_Start;
  TEdit *DataPeriodEdit;
  TTntGroupBox *LaserTestMode;
  TButton *TrigOnBtn;
  TTntCheckBox *EnableLaserTest;
  TGroupBox *GroupBox1;
  TTntGroupBox *TestSimulation;
  TTntLabel *Label45;
  TTntLabel *Label55;
  TTntLabel *Label63;
  TBitBtn *BitBtn2;
  TCheckBox *SimulationInspectionCheckBox;
  TEdit *Edit2;
  TEdit *Edit1;
  TBitBtn *BitBtn1;
  TTntSpeedButton *SimulationButton;
  TTntPanel *Panel67;
  TTntPanel *Panel113;
  TTntPanel *Panel125;
  TTntLabel *Label11;
  TTntLabel *DisappearedTabletCountLabel;
  TTntLabel *Label13;
  TTntLabel *InsertedTabletCountLabel;
  TTntLabel *Label15;
        TTntLabel *ClosedTabletUninsCountLabel;
  TTntLabel *Label71;
  TTntLabel *Label53;
  TTntLabel *Label47;
  TTntLabel *NozzErrorUnInsTabletCountLabel;
  TTntLabel *MissFeedingTabletCountLabel;
  TTntLabel *MultiTabletCountLabel;
  TTntPanel *Panel129;
  TTntPanel *Panel132;
  TTntPanel *Panel133;
  TTntLabel *Label10;
  TTntLabel *Label4;
  TTntLabel *UnInsTabletPositionCountLabel;
  TTntLabel *ClosedTabletCountLabel;
  TTntPanel *Panel134;
  TTntPanel *Panel135;
  TTntLabel *Label42;
  TTntLabel *Label46;
  TTntLabel *Label52;
  TTntLabel *BufferFullTabletCountLabel;
  TTntLabel *CaptureTimeoutTabletCountLabel;
  TTntLabel *CaptureNotReadyTabletCountLabel;
  TTntPanel *Panel136;
  TTntPanel *Panel137;
  TTntPanel *Panel138;
  TTntPanel *Panel139;
  TTntPanel *Panel140;
  TTntLabel *Label8;
  TTntLabel *Label28;
  TTntLabel *Label54;
  TTntLabel *SPBTOCountLabel;
  TTntLabel *WrongNumberTabletCountLabel;
  TTntLabel *NumberUndefTabletCountLabel;
  TTntLabel *Label34;
  TTntLabel *Label44;
  TTntLabel *UnInsBrightnessDropCountLabel;
  TTntLabel *UnInsBrightnessChaseCountLabel;
  TTntPanel *Panel141;
  TTntPanel *Panel142;
  TTntPanel *Panel145;
  TTntPanel *Panel148;
  TTntPanel *TotalUnInsCountLabel;
  TTntLabel *Label48;
  TTntLabel *Label50;
  TTntLabel *Label40;
  TTntLabel *ProcErrorTabletCountLabel;
  TTntLabel *CPBFullTabletCountLabel;
  TTntLabel *ProcessingTimeoutTabletCountLabel;
  TTntLabel *TotalUnInsCountLabel2;
  TTntLabel *Label17;
        TTntLabel *ClosedTabletDefectCountLabel;
  TTntButton *CameraTestButton;
  TTntPanel *TntPanel4;
  TTntPanel *TntPanel5;
  TTntPanel *TntPanel6;
  TTntPanel *TntPanel7;
  TTntLabel *Label24;
  TTntLabel *InspectChartLabel;
  TTntLabel *CountCheckLabel;
  TTntLabel *EjectorSettingLabel;
  TTntLabel *ThroughPutChartLabel;
  TTntLabel *DefectRatioChartLabel;
  TTntLabel *VibratorInfoLabel;
  TCheckBox *TPBActiveCheckBox;
  TButton *ShowTPBButton;
  TTimer *MachineStopCheckTimer;
  TTntLabel *ProductNameLabel;
	TTntButton *DistributorMonitorButton;
	TTntPanel *DistributorMonitorPanel;
	TTntMemo *DistributorMonitorMemo;
	TTntButton *TntButton1;
	TTimer *DistributorTimer;
	void __fastcall InspectionStartButtonClick(TObject *Sender);
  void __fastcall InspectionInfoTimerTimer(TObject *Sender);
	void __fastcall GradeSettingButtonClick(TObject *Sender);
	void __fastcall SpeedControlButtonClick(TObject *Sender);
	void __fastcall FormCreate(TObject *Sender);
	void __fastcall InspectionStopButtonClick(TObject *Sender);
	void __fastcall FormDestroy(TObject *Sender);
	void __fastcall ShowImageButtonClick(TObject *Sender);
	void __fastcall ThroughPutChartSpeedButtonClick(TObject *Sender);
	void __fastcall DefectRatioChartSpeedButtonClick(TObject *Sender);
	void __fastcall InspectChartSpeedButtonClick(TObject *Sender);
	void __fastcall CountCheckSpeedButtonClick(TObject *Sender);
	void __fastcall CloseBitBtnClick(TObject *Sender);
	void __fastcall InspectionRestartButtonClick(TObject *Sender);
	void __fastcall SystemTimeTimerTimer(TObject *Sender);
	void __fastcall Panel5DblClick(TObject *Sender);
	void __fastcall DefectDataInfoPanelResize(TObject *Sender);
  void __fastcall DefectCheckTimerTimer(TObject *Sender);
  void __fastcall InspectionResultSpeedButtonClick(TObject *Sender);
  void __fastcall ProcessingCheckStartButtonClick(TObject *Sender);
  void __fastcall ProcessingCheckStopButtonClick(TObject *Sender);
  void __fastcall ProcessingCheckTimerTimer(TObject *Sender);
  void __fastcall ProcessingInfoSPBSpeedButtonClick(TObject *Sender);
  void __fastcall ProcessingInfoCamSpeedButtonClick(TObject *Sender);
  void __fastcall InspectionResultTimerTimer(TObject *Sender);
  void __fastcall VibratorInfoSpeedButtonClick(TObject *Sender);
  void __fastcall VibratorInfoTimerTimer(TObject *Sender);
	void __fastcall VFSpeedControlUpDownClick(TObject *Sender,
          TUDBtnType Button);
	void __fastcall VFSpeedControlEditClick(TObject *Sender);
	void __fastcall VibrationStopButtonClick(TObject *Sender);
	void __fastcall ChartSelectionLabelDblClick(TObject *Sender);
	void __fastcall NCControlButtonClick(TObject *Sender);
	void __fastcall MisejectSpeedButtonClick(TObject *Sender);
	void __fastcall CleaningButtonClick(TObject *Sender);
	void __fastcall OptionalInfoPanelDblClick(TObject *Sender);
	void __fastcall SystemMonitoringTimerTimer(TObject *Sender);
	void __fastcall UnmanedOperationButtonClick(TObject *Sender);
	void __fastcall ThroughputChartMouseDown(TObject *Sender,
          TMouseButton Button, TShiftState Shift, int X, int Y);
	void __fastcall ThroughputChartMouseUp(TObject *Sender,
          TMouseButton Button, TShiftState Shift, int X, int Y);
	void __fastcall ThroughputChartMouseMove(TObject *Sender,
          TShiftState Shift, int X, int Y);
	void __fastcall ThroughputChartDblClick(TObject *Sender);
  void __fastcall Panel37DblClick(TObject *Sender);
  void __fastcall AppUpdateTimer2Timer(TObject *Sender);
  void __fastcall APPClick(TObject *Sender);
  void __fastcall EjectorSettingSpeedButtonClick(TObject *Sender);
  void __fastcall EjectorMode2RBClick(TObject *Sender);
  void __fastcall EjectorEdit1Click(TObject *Sender);
  void __fastcall ApplyDefaultEjectInfoBtnClick(TObject *Sender);
  void __fastcall EjectorLabel5Click(TObject *Sender);
  void __fastcall EjectorLabel6Click(TObject *Sender);
  void __fastcall TntFormClose(TObject *Sender, TCloseAction &Action);
  void __fastcall TntFormActivate(TObject *Sender);
  void __fastcall TcpSndTimer1Timer(TObject *Sender);
  void __fastcall BitBtn1Click(TObject *Sender);
  void __fastcall BitBtn2Click(TObject *Sender);
	void __fastcall DistributorGoodCollect1EditClick(TObject *Sender);
	void __fastcall DistributorGoodCollect2EditClick(TObject *Sender);
	void __fastcall DistributorGoodCollect3EditClick(TObject *Sender);
  void __fastcall UVLinkTimerTimer(TObject *Sender);
  void __fastcall AlarmTimerTimer(TObject *Sender);
  void __fastcall QDischargeResetBtnClick(TObject *Sender);
  void __fastcall TntFormShow(TObject *Sender);
  void __fastcall LaserMcbap_StartClick(TObject *Sender);
  void __fastcall LaserMcbsp_StopClick(TObject *Sender);
  void __fastcall DataPeriodEditChange(TObject *Sender);
  void __fastcall LMCPeriodEditChange(TObject *Sender);
        void __fastcall TrigOnBtnClick(TObject *Sender);
        void __fastcall EnableLaserTestClick(TObject *Sender);
  void __fastcall CPBStatusCheckTimerTimer(TObject *Sender);
  void __fastcall UploadRealtimeCapturedImageTimerTimer(TObject *Sender);
  void __fastcall ChangeMarkingInfoPage(TObject *Sender);
  void __fastcall HCBMonitoringTimerTimer(TObject *Sender);
  void __fastcall HCBMonitoringButtonClick(TObject *Sender);
  void __fastcall LaserMonitoringStringGridDblClick(TObject *Sender);
  void __fastcall UnInsCountCheckingBtnClick(TObject *Sender);
  void __fastcall DefectCountCheckingBtnClick(TObject *Sender);
  void __fastcall SimulationButtonClick(TObject *Sender);
  void __fastcall CameraTestButtonClick(TObject *Sender);
  void __fastcall Panel39DblClick(TObject *Sender);
  void __fastcall Panel70DblClick(TObject *Sender);
  void __fastcall InspectChartLabelClick(TObject *Sender);
  void __fastcall ThroughPutChartLabelClick(TObject *Sender);
  void __fastcall ShowTPBButtonClick(TObject *Sender);
  void __fastcall MachineStopCheckTimerTimer(TObject *Sender);
	void __fastcall DistributorTimerTimer(TObject *Sender);
	void __fastcall TntButton1Click(TObject *Sender);
	void __fastcall DistributorMonitorButtonClick(TObject *Sender);
private:	// User declarations
	TTntStringList *AlarmStringList;
	unsigned char DefectImage[SYSTEM_CAMERA_HD_WIDTH * SYSTEM_CAMERA_HD_HEIGHT];
 	unsigned char RealDefectBayerImage[SYSTEM_CAMERA_HD_WIDTH * SYSTEM_CAMERA_HD_HEIGHT];
	unsigned char DefectRawImage_3D[SYSTEM_CAMERA_WIDTH_3D * SYSTEM_CAMERA_HEIGHT_3D];
	
	TDefectInfoForm *SubDefectInfoForm;
  bool IsChartView;
  int RatioCheckTimerCount;
  int RatioCheckTimerInterval;

  int InspectState;
  int InspectionStopOption;
  TInspectionOption InspectionOption;
  TInspectionOption tempInspectionOption;
  THCBInspectionOption HCBInspectionOption;
  TDefectData_PC CurrentDefectData;

  TTabletInspectInfo TabletInspectInfo_Begin;
  TTabletInspectInfo TabletInspectInfo;
  TTabletInspectInfo prevTabletInspectInfo;


  TInspectionAdditionalInfo InspectInfo_Additional;
  double *ThroughputChartList;
  int ThroughputChartListSize;
  int ThroughputChartCount;
  int ThroughputChartDownX;
  bool ThroughputChartAutoScroll;

  int CheckTPCount;
  int CheckGPCount;
  int CheckDPCount;
  int CheckUPCount;
  double GPRatioChartList[RATIO_CHART_COUNT];
  double DPRatioChartList[RATIO_CHART_COUNT];
  double UPRatioChartList[RATIO_CHART_COUNT];
  int InspectionRatioChartCount;

  int DefectReportList[DEFECT_INFO_LIST_COUNT];
  int DefectReportStartPos;
  int DefectReportEndPos;
  unsigned int CountedTabletNumber;
  int DefectSeriesCount[MAX_DEFECT_SERIES_COUNT + 1];
  unsigned int AutoSaveInterval;
  //cik add
  int DefectTalbetNumList[512][3];    //0 : ȣ , 1 : ҷ  , 2 : ̰˿
  int DefectTabletNumIndex;
  
  list<TDefectTabletInfo> GlobalDefectDataList;
  TDateTime InspectionStartTime;
  TDateTime InspectionCompleteTime;

  TInspectionResultTable InspectionResultTable;
  int LastCheckedTabletNumber;
  list<TDefectTabletListUnit> DefectedTabletList;

  TProcessingTime ProcessingTimeList[SYSTEM_SPB_MAX_COUNT][SPB_TABLET_LIST_COUNT];
  TVibratorInfo VibratorInfo;

  int OptionalDisplayKind;

  double LastCheckedTime;
  double ElapsedTime;

  double LastTPHCheckedTime;
  int TPHCheckTabletCount;
  int CurrentTPH;

  int VFSpeedMode;
  bool bCalledWriteFunc;
  bool bSuspendCheck;

  AnsiString StartOperName;
  AnsiString EndOperName;

  int SourceImageWidth[2];
  int SourceImageHeight[2];
  int rate[2];
  

  TEjectorSettingInfo EjectorSettingInfo;

	int DefectTabletNumberHeap[SYSTEM_TOTAL_CAMERA_COUNT][DEFECT_SERIES_HEAP_SIZE];
	int DefectSeriesHeap[SYSTEM_TOTAL_CAMERA_COUNT][DEFECT_SERIES_HEAP_SIZE];
	int LastDefectSeriesCheckedTabletNumber;
	Graphics::TBitmap *Current3DBitmap;
	
	int __fastcall SaveDefectInfo(void);
	void __fastcall InspectionMachineStop(void);
	void __fastcall InspectionStop(void);
	void __fastcall InspectionPause(void);
	void __fastcall InspectionResume(void);
	void __fastcall InspectionRestart(void);
	void __fastcall DeleteInspectResult(bool bDefectReIns);
	void __fastcall ClearDefectInfoList(void);
	void __fastcall SaveInspectResult(void);
	void __fastcall LoadInspectResult(void);
	void __fastcall ConfirmSuspendStatus(void);
	void __fastcall DisplayGradeInfo(void);
	void __fastcall RefreshProcessingInfo(void);
	void __fastcall Repaint3DImage();
	int __fastcall GetInspectionID(void);
	void __fastcall ChangeVFSpeed(int speed);
	void __fastcall SendInspectionReadyCommand(int disk1TargetSpeed, int disk1BaseSpeed, int disk2TargetSpeed, int disk2BaseSpeed,
		bool *cameraEnabled = NULL);
	void __fastcall CheckMachineState(void);
	void __fastcall RefreshDefectsInfo(void);
	void __fastcall DisplayInspectionOption(void);
	void __fastcall ClearDefectTabletCount(void);
	void __fastcall ClearUninspectedTabletCount(void);
	void __fastcall ClearInspectionStatistics(bool NewInspection=false);
	void __fastcall DisplayTabletInspectionInfo(void);
	void __fastcall UpdateThroughputChart(void);
	void __fastcall UpdateInspectionRatioChart(void);
	void __fastcall CheckMachineSuspend(void);
	void __fastcall DisplayInspectionResultTable(void);
	void __fastcall MakeHCBInspectionOption(int suctionDiskSpeed);
	void __fastcall SPBInspectionSetup(void);
	bool __fastcall HCBInspectionSetup(void);
	void __fastcall ClearDefectInfoHeap(void);
	void __fastcall ProcessDefectSeries(bool processAllData);
	bool __fastcall ReadSetupData(TTabletSetupData *tabletSetupData);
	void __fastcall RefreshVibratorInfo(void);
  void __fastcall GetDefaultString();
  void __fastcall setEjectInformation();
  void __fastcall readEjectInformation(AnsiString FileName);
  void __fastcall DefaultEjectInformation();
  void __fastcall writeEjectInformation();
  void __fastcall setEjectComponent();
  void __fastcall getEjectInformation();
  void __fastcall CheckMachineAlarmStatus();
  void __fastcall SetSPBVirtualInspectionImage();
  void __fastcall CheckLinkBoard();
  void __fastcall LinkSignalInit(bool Clear = true); // ܼ Ŭ  ̴ϼ 
  void __fastcall ConvertMESData();
  void __fastcall InspectionWaitStop(int type);
  WideString __fastcall GetUninspectReason(void);
  void __fastcall ClearLaserMonitoringData();
  void __fastcall RemoveWholeDir(AnsiString folderName);
  bool __fastcall ReadStudyData(TTabletStudyData *tabletStudyData);
  void __fastcall StandbyHCBMonitoring();
  void __fastcall WriteHCBMonitoringData(bool bFinish);

  int ThreeDParamSetSatus[2];
  double prevtimeForUninsCheck;
  bool bSetPrevCount;
  bool bUninsMachineStopSW;
  void AcrociaInspectDataClearCommandFunc();
  bool ExternalWriteInspectionResult;
  TCPBStatus CPBStatus[SYSTEM_CPB_COUNT];

  unsigned char RealtimeUploadImage[REALTIME_CAMERA_WIDTH * REALTIME_CAMERA_HEIGHT];

  int meanTabletColor;
  int PrintMinColor;

  unsigned int RTTabletMinNumber;
  unsigned int RTTabletMaxNumber;

  int prev2DImageControlInterval;
  int prev3DImageControlInterval;
  int prevPageIndex;

  int AverageBrightness;
  int AverageThetaResult;
  int AverageXResult;
  int AverageYResult;
  int AverageResultCount;

  AnsiString HCBMonitoringFilePath;

  bool bExecuteTPB;
  int LastDistributorDisStep;
  TDistributorMonitor DistributorMonitor;

  int LastCheckHCBListIndex;
  vector<THCBDisk2TabletUnit> HCBTabletUnitList;

  void __fastcall RefreshMarkingInfomationData(int page);
public:		// User declarations
	__fastcall TInspectionForm(TComponent* Owner);
	void __fastcall OnUserChange(void);
  int SPGoodTabletDropIndex;     //SELMA100  TabletDropIndex  ϰ ִ.
  bool InspectionStopAlarm; // ε Ajanta û : ˻  ˶ ޶
  bool TestMode; // AJanta
  int LaserLinkIntervalTime;
  bool SuccessRun;
  bool AjantaFormInitCheck;
  bool AcrociaStartCommandFlag;
  int NewInsepctionDataSetFlag; // Q Laser : kolma     ʿ
  bool ClearInspectionRatioChart ;

 TDefectData_PC tempDefectData;
};
//---------------------------------------------------------------------------
extern PACKAGE TInspectionForm *InspectionForm;
extern int AppOnOffFlag;
extern int BtnOnOffFlag;
//extern TUVLaserStatus UVLaser;
//---------------------------------------------------------------------------
#endif
