//---------------------------------------------------------------------------
// For SELMA200, 20180223, moon, Ϸ
// Camera Index  Ϻ 
//---------------------------------------------------------------------------

#include <vcl.h>
#pragma hdrstop

#include "MachineSettingTest_Form.h"
#include "Keyboard_Form.h"
#include "Message_Form.h"
#include "Bayer.h"
#include "NCControl_Form.h"
#include "MachineControl.h"
#include "MultiLanguage.h"

//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma link "TntButtons"
#pragma link "TntExtCtrls"
#pragma link "TntGrids"
#pragma link "TntStdCtrls"
#pragma resource "*.dfm"

TMachineSettingTestForm *MachineSettingTestForm;
//---------------------------------------------------------------------------
__fastcall TMachineSettingTestForm::TMachineSettingTestForm(TComponent* Owner)
		: TTntForm(Owner)
{
	if (DefaultLCID == 1028 || DefaultLCID == 2052 || DefaultLCID == 3076 || DefaultLCID == 4100)
		ComponentSetFontName(this, "SimSun");
	else if (DefaultLCID == 1041)
		ComponentSetFontName(this, "Meiryo UI");
	else if (DefaultLCID == 3082)
	{
		ComponentSetFontName(this, "Segoe UI");
		ComponentSetMultiLine(this);
	}

	GetDefaultString();

	CaptureWidth = 0;
	CaptureHeight = 0;
	DestImage = NULL;

	OnCapture = false;
	CaptureImage[0] = CaptureImage1;
	CaptureImage[1] = CaptureImage2;

	BufferImage[0] = BufferImage1;
	BufferImage[1] = BufferImage2;

	UploadingCameraIndex[0] = SD1_2D_FRONT_FACE_CAMERA_INDEX - 1;
	UploadingCameraIndex[1] = SD2_2D_FRONT_FACE_CAMERA_INDEX - 1;

	if (ProductData.SubSamplingMode == IMAGE_FULL_SCALE_MODE)
	{
		SourceImageWidth = SYSTEM_CAMERA_HD_WIDTH;
		SourceImageHeight = SYSTEM_CAMERA_HD_HEIGHT;
	}
	else
	{
		SourceImageWidth = SYSTEM_CAMERA_WIDTH;
		SourceImageHeight = SYSTEM_CAMERA_HEIGHT;
	}

	CaptureImage[0]->Picture->Bitmap->Width = SourceImageWidth;
	CaptureImage[0]->Picture->Bitmap->Height = SourceImageHeight;
	CaptureImage[1]->Picture->Bitmap->Width = SourceImageWidth;
	CaptureImage[1]->Picture->Bitmap->Height = SourceImageHeight;


	CaptureImage[0]->Picture->Bitmap->PixelFormat = pf24bit;
	CaptureImage[1]->Picture->Bitmap->PixelFormat = pf24bit;

	Panel2->DoubleBuffered = true;
	CurrentMotorSpeedIndex = 0;

	ScrollSuction->Picture->Bitmap->Width = ScrollSuction->Width;
	ScrollSuction->Picture->Bitmap->Height = ScrollSuction->Height;
	ScrollSuction->Picture->Bitmap->PixelFormat = pf24bit;

	ScrollInnerDisk->Picture->Bitmap->Width = ScrollInnerDisk->Width;
	ScrollInnerDisk->Picture->Bitmap->Height = ScrollInnerDisk->Height;
	ScrollInnerDisk->Picture->Bitmap->PixelFormat = pf24bit;

	ScrollOutDisk1->Picture->Bitmap->Width = ScrollOutDisk1->Width;
	ScrollOutDisk1->Picture->Bitmap->Height = ScrollOutDisk1->Height;
	ScrollOutDisk1->Picture->Bitmap->PixelFormat = pf24bit;

	ScrollOutDisk2->Picture->Bitmap->Width = ScrollOutDisk2->Width;
	ScrollOutDisk2->Picture->Bitmap->Height = ScrollOutDisk2->Height;
	ScrollOutDisk2->Picture->Bitmap->PixelFormat = pf24bit;

	for (int y = 0; y < ScrollSuction->Height; y++)
	{
		byte *pBitmap = (byte *)ScrollSuction->Picture->Bitmap->ScanLine[y];
		for (int x = 0; x < ScrollSuction->Width; x++)
		{
			byte colorB = 0xFF - abs(x - ScrollSuction->Width / 2) * 0x4F / (ScrollSuction->Width / 2);
			byte colorG = 0x3F - abs(x - ScrollSuction->Width / 2) * 0x1F / (ScrollSuction->Width / 2);
			byte colorR = 0x4F - abs(x - ScrollSuction->Width / 2) * 0x1F / (ScrollSuction->Width / 2);
			if (x % 10 < 2)
			{
				colorB = colorG = colorR = 0;
			}
			pBitmap[x * 3] = colorB;
			pBitmap[x * 3 + 1] = colorG;
			pBitmap[x * 3 + 2] = colorR;
		}
	}

	for (int y = 0; y < ScrollInnerDisk->Height; y++)
	{
		byte *pBitmap = (byte *)ScrollInnerDisk->Picture->Bitmap->ScanLine[y];
		for (int x = 0; x < ScrollInnerDisk->Width; x++)
		{
			byte colorB = 0xFF - abs(x - ScrollInnerDisk->Width / 2) * 0x4F / (ScrollInnerDisk->Width / 2);
			byte colorG = 0x3F - abs(x - ScrollInnerDisk->Width / 2) * 0x1F / (ScrollInnerDisk->Width / 2);
			byte colorR = 0x4F - abs(x - ScrollInnerDisk->Width / 2) * 0x1F / (ScrollInnerDisk->Width / 2);
			if (x % 10 < 2)
			{
				colorB = colorG = colorR = 0;
			}
			pBitmap[x * 3] = colorB;
			pBitmap[x * 3 + 1] = colorG;
			pBitmap[x * 3 + 2] = colorR;

		}
	}

	for (int y = 0; y < ScrollOutDisk1->Height; y++)
	{
		byte *pBitmap = (byte *)ScrollOutDisk1->Picture->Bitmap->ScanLine[y];
		for (int x = 0; x < ScrollOutDisk1->Width; x++)
		{
			byte colorB = 0xFF - abs(x - ScrollOutDisk1->Width / 2) * 0x4F / (ScrollOutDisk1->Width / 2);
			byte colorG = 0x3F - abs(x - ScrollOutDisk1->Width / 2) * 0x1F / (ScrollOutDisk1->Width / 2);
			byte colorR = 0x4F - abs(x - ScrollOutDisk1->Width / 2) * 0x1F / (ScrollOutDisk1->Width / 2);
			if (x % 10 < 2)
			{
				colorB = colorG = colorR = 0;
			}
			pBitmap[x * 3] = colorB;
			pBitmap[x * 3 + 1] = colorG;
			pBitmap[x * 3 + 2] = colorR;

		}
	}

		for (int y = 0; y < ScrollOutDisk2->Height; y++)
	{
		byte *pBitmap = (byte *)ScrollOutDisk2->Picture->Bitmap->ScanLine[y];
		for (int x = 0; x < ScrollOutDisk2->Width; x++)
		{
			byte colorB = 0xFF - abs(x - ScrollOutDisk2->Width / 2) * 0x4F / (ScrollOutDisk2->Width / 2);
			byte colorG = 0x3F - abs(x - ScrollOutDisk2->Width / 2) * 0x1F / (ScrollOutDisk2->Width / 2);
			byte colorR = 0x4F - abs(x - ScrollOutDisk2->Width / 2) * 0x1F / (ScrollOutDisk2->Width / 2);
			if (x % 10 < 2)
			{
				colorB = colorG = colorR = 0;
			}
			pBitmap[x * 3] = colorB;
			pBitmap[x * 3 + 1] = colorG;
			pBitmap[x * 3 + 2] = colorR;

		}
	}
	isScrollSuctionMouseDown= false;
	isScrollInnerDiskMouseDown= false;
	isScrollOutDisk1MouseDown= false;
	isScrollOutDisk2MouseDown= false;

	for (int speedControlIndex = 0; speedControlIndex < MOTOR_SPEED_STEP_COUNT_FOR_PRODUCT; speedControlIndex++)
	{
		for (int motorIndex = 0; motorIndex < MAX_SERVO_MOTOR_COUNT; motorIndex++)
		{
			CurrentMotorSpeedList[motorIndex][speedControlIndex] = ProductData.MotorSpeedList[motorIndex][speedControlIndex];
			OldMotorSpeedList[motorIndex][speedControlIndex] = ProductData.MotorSpeedList[motorIndex][speedControlIndex];
		}
	}

	for (int speedControlIndex = 0; speedControlIndex < MOTOR_SPEED_STEP_COUNT_FOR_PRODUCT; speedControlIndex++)
	{
		CurrentMotorSpeedRatioList[SD1_MOTOR_INDEX][speedControlIndex] = MachineSetupData.ServoMotorData[SD1_MOTOR_INDEX].BaseSpeed * 100 / CurrentMotorSpeedList[SD1_MOTOR_INDEX][speedControlIndex];
		CurrentMotorSpeedRatioList[SD2_MOTOR_INDEX][speedControlIndex] = MachineSetupData.ServoMotorData[SD2_MOTOR_INDEX].BaseSpeed * 100 / CurrentMotorSpeedList[SD2_MOTOR_INDEX][speedControlIndex];
		CurrentMotorSpeedRatioList[BF_ID_MOTOR_INDEX][speedControlIndex] = MachineSetupData.ServoMotorData[BF_ID_MOTOR_INDEX].BaseSpeed * 100 / CurrentMotorSpeedList[BF_ID_MOTOR_INDEX][speedControlIndex];
		CurrentMotorSpeedRatioList[BF_OD_IN_MOTOR_INDEX][speedControlIndex] = MachineSetupData.ServoMotorData[BF_OD_IN_MOTOR_INDEX].BaseSpeed * 100 / CurrentMotorSpeedList[BF_OD_IN_MOTOR_INDEX][speedControlIndex];
		if(MachineSetupData.MachineType == MACHINE_TYPE_SELMA_ADVANCED || MachineSetupData.MachineType == MACHINE_TYPE_LIMA_ADVANCED)
		{
			CurrentMotorSpeedRatioList[BF_OD_OUT_MOTOR_INDEX][speedControlIndex] = MachineSetupData.ServoMotorData[BF_OD_OUT_MOTOR_INDEX].BaseSpeed * 100 / CurrentMotorSpeedList[BF_OD_OUT_MOTOR_INDEX][speedControlIndex];
		}
	}
}


//---------------------------------------------------------------------------
void __fastcall TMachineSettingTestForm::GetDefaultString()
{
  VFStopSpeedButton->Caption = MACHINESETTINGTESTFORM_BUTTON_CAPTION_01;
  AirKnifeOffSpeedButton->Caption = MACHINESETTINGTESTFORM_BUTTON_CAPTION_01;
  MainControlReadyButton->Caption = MACHINESETTINGTESTFORM_BUTTON_CAPTION_04;
  NCControlButton->Caption = MACHINESETTINGTESTFORM_BUTTON_CAPTION_06;
  MainControlRunButton->Caption = MACHINESETTINGTESTFORM_BUTTON_CAPTION_07;
  VDRunSpeedButton->Caption = MACHINESETTINGTESTFORM_BUTTON_CAPTION_07;
  CaptureStartSpeedButton->Caption = MACHINESETTINGTESTFORM_BUTTON_CAPTION_07;
  VFAutoSpeedButton->Caption = MACHINESETTINGTESTFORM_BUTTON_CAPTION_11;
  MainControlStopButton->Caption = MACHINESETTINGTESTFORM_BUTTON_CAPTION_13;
  VDStopSpeedButton->Caption = MACHINESETTINGTESTFORM_BUTTON_CAPTION_13;

  InnerDiskRunButton->Caption = MACHINESETTINGTESTFORM_BUTTON_CAPTION_07;
  InnerDiskStopButton->Caption = MACHINESETTINGTESTFORM_BUTTON_CAPTION_13;
  OutDisk1RunButton->Caption = MACHINESETTINGTESTFORM_BUTTON_CAPTION_07;
  OutDisk1StopButton->Caption = MACHINESETTINGTESTFORM_BUTTON_CAPTION_13;
  OutDisk2RunButton->Caption = MACHINESETTINGTESTFORM_BUTTON_CAPTION_07;
  OutDisk2StopButton->Caption = MACHINESETTINGTESTFORM_BUTTON_CAPTION_13;
  
  CloseButton->Caption = MACHINESETTINGTESTFORM_BUTTON_CAPTION_16;
  CaptureStopSpeedButton->Caption = MACHINESETTINGTESTFORM_BUTTON_CAPTION_13;
  CounterResetSpeedButton->Caption = MACHINESETTINGTESTFORM_BUTTON_CAPTION_18;
  MainControlCleaningButton->Caption = MACHINESETTINGTESTFORM_BUTTON_CAPTION_19;
  VFRunSpeedButton->Caption = MACHINESETTINGTESTFORM_BUTTON_CAPTION_20;
  GroupBox13->Caption = MACHINESETTINGTESTFORM_GROUP_CAPTION_01;
  GroupBox8->Caption = MACHINESETTINGTESTFORM_GROUP_CAPTION_02;
  GroupBox5->Caption = MACHINESETTINGTESTFORM_GROUP_CAPTION_04;
  GroupBox3->Caption = MACHINESETTINGTESTFORM_GROUP_CAPTION_05;
  Label3->Caption = MACHINESETTINGTESTFORM_GROUP_CAPTION_05;
  GroupBox2->Caption = MACHINESETTINGTESTFORM_GROUP_CAPTION_07;
  GroupBox1->Caption = MACHINESETTINGTESTFORM_GROUP_CAPTION_08;
  Label6->Caption = MACHINESETTINGTESTFORM_LABEL_CAPTION_01;
  Label13->Caption = MACHINESETTINGTESTFORM_LABEL_CAPTION_02;
  GroupBox4->Caption = MACHINESETTINGTESTFORM_LABEL_CAPTION_03;
  Label4->Caption = MACHINESETTINGTESTFORM_LABEL_CAPTION_04;
//  Label2->Caption = MACHINESETTINGTESTFORM_LABEL_CAPTION_05;
  Label1->Caption = MACHINESETTINGTESTFORM_LABEL_CAPTION_06;

  Label7->Caption = TABLETCHARACTEREXTRACTFORM_TEXT_CAPTION_04;
  Label5->Caption = TABLETCHARACTEREXTRACTFORM_TEXT_CAPTION_04;
//  Label8->Caption = TABLETCHARACTEREXTRACTFORM_TEXT_CAPTION_04;

  AirKnifeOnSpeedButton->Caption = MACHINESETTINGTESTFORM_BUTTON_CAPTION_21; 

	if(MachineSetupData.MachineType < 2)
	{
		GroupBox7->Caption = MACHINESETTINGTESTFORM_GROUP_CAPTION_06;
		TntLabel3->Caption= MACHINESETTINGTESTFORM_LABEL_CAPTION_05;
		GroupBox7->Visible = false;
	}
	else
	{
		GroupBox6->Caption = MACHINESETTINGTESTFORM_GROUP_CAPTION_06;
		GroupBox7->Caption = MACHINESETTINGTESTFORM_GROUP_CAPTION_06;
		TntLabel1->Caption	=	MACHINESETTINGTESTFORM_LABEL_CAPTION_07;
		TntLabel3->Caption	=	MACHINESETTINGTESTFORM_LABEL_CAPTION_08;
		GroupBox7->Visible = true;
	}
	
}
//---------------------------------------------------------------------------
void __fastcall TMachineSettingTestForm::MainControlRunButtonClick(
      TObject *Sender)
{
  if (Machine.Status.OperationState != MACHINE_STATE_STOP &&
			Machine.Status.OperationState != MACHINE_STATE_CLEANING &&
			Machine.Status.OperationState != MACHINE_STATE_ATTACHING &&
			Machine.Status.OperationState != MACHINE_STATE_DETACHING)
  {
    Machine.MachineStop();
    ShowMessageFA(INSPECTIONFORM_MSG_23);
    return;
  }
  
	int motorSpeedList[MAX_SERVO_MOTOR_COUNT];
	for (int motorIndex = 0; motorIndex < MAX_SERVO_MOTOR_COUNT; motorIndex++)
	{
		motorSpeedList[motorIndex] = MotorSpeed[motorIndex];
	}

	Machine.MachineRun(PROCEDURE_MODE_CAPTURE, &ProductData.MachineRunOption,
	ProductData.NCMotorPos, motorSpeedList);
}
//---------------------------------------------------------------------------
void __fastcall TMachineSettingTestForm::MainControlStopButtonClick(
      TObject *Sender)
{
	Machine.MachineStop();
}
//---------------------------------------------------------------------------
void __fastcall TMachineSettingTestForm::MainControlCleaningButtonClick(
      TObject *Sender)
{
	Machine.MachineCleaning();
}
//---------------------------------------------------------------------------
void __fastcall TMachineSettingTestForm::MainControlReadyButtonClick(
      TObject *Sender)
{
	Machine.MachineReady();
}
//---------------------------------------------------------------------------
void __fastcall TMachineSettingTestForm::FormCreate(TObject *Sender)
{
	for (int motorIndex = 0; motorIndex < MAX_SERVO_MOTOR_COUNT; motorIndex++)
	{
		MotorSpeed[motorIndex] = ProductData.MotorSpeedList[motorIndex][0];
	}

	CurrentMotorSpeedRatio[SD1_MOTOR_INDEX] = MachineSetupData.ServoMotorData[SD1_MOTOR_INDEX].BaseSpeed * 100 / MotorSpeed[SD1_MOTOR_INDEX];
	CurrentMotorSpeedRatio[SD2_MOTOR_INDEX] = MachineSetupData.ServoMotorData[SD2_MOTOR_INDEX].BaseSpeed * 100 / MotorSpeed[SD2_MOTOR_INDEX];
	CurrentMotorSpeedRatio[BF_ID_MOTOR_INDEX] = MachineSetupData.ServoMotorData[BF_ID_MOTOR_INDEX].BaseSpeed * 100 / MotorSpeed[BF_ID_MOTOR_INDEX];
	CurrentMotorSpeedRatio[BF_OD_IN_MOTOR_INDEX] = MachineSetupData.ServoMotorData[BF_OD_IN_MOTOR_INDEX].BaseSpeed * 100 / MotorSpeed[BF_OD_IN_MOTOR_INDEX];
	if(MachineSetupData.MachineType == MACHINE_TYPE_SELMA_ADVANCED || MachineSetupData.MachineType == MACHINE_TYPE_LIMA_ADVANCED)
	{
		CurrentMotorSpeedRatio[BF_OD_OUT_MOTOR_INDEX] = MachineSetupData.ServoMotorData[BF_OD_OUT_MOTOR_INDEX].BaseSpeed * 100 / MotorSpeed[BF_OD_OUT_MOTOR_INDEX];
	}
  	ApplyMotorSpeed();

	CaptureData = new unsigned char[max(SourceImageWidth * SourceImageHeight, SYSTEM_CAMERA_WIDTH_3D * SYSTEM_CAMERA_HEIGHT_3D)];

  AnsiString fileName = GetProductDataFileName(ProductData.ProductCode);
	ReadProductData(fileName, tempProductData, MachineParams, MachineSetupData);

  // ó  ī޶ = 1, 6, 9
  BrightnessEdit1->Text = IntToStr(tempProductData.ShutterSpeed[UploadingCameraIndex[0]]*5);
  BrightnessEdit2->Text = IntToStr(tempProductData.ShutterSpeed[UploadingCameraIndex[1]]*5);


  for(int globalCameraIndex = 0; globalCameraIndex < SYSTEM_TOTAL_CAMERA_COUNT; globalCameraIndex++)
  {
    AnsiString ConvertString;
    if(SystemLinkCameraInfo[globalCameraIndex] != 0)
    {
      TTntSpeedButton *Img1SpeedButton = (TTntSpeedButton *)FindComponent("Img1SpeedButton" + IntToStr(globalCameraIndex+1));
      TTntSpeedButton *Img2SpeedButton = (TTntSpeedButton *)FindComponent("Img2SpeedButton" + IntToStr(globalCameraIndex+1));
//      TTntSpeedButton *Img3SpeedButton = (TTntSpeedButton *)FindComponent("Img3SpeedButton" + IntToStr(globalCameraIndex+1));

      ConvertString = ConvertCameraIndex(globalCameraIndex);

      Img1SpeedButton->Caption = ConvertString;
      Img2SpeedButton->Caption = ConvertString;
//      Img3SpeedButton->Caption = ConvertString;
    }
  }

  if(GlobalProgramID == PROGRAM_ID_150P)
  {
    //SELMA150P
    int MoveD = ComponentReposition(3,Img1SpeedButton1->Top, Img1SpeedButton2->Top, 0);
    for(int globalCameraIndex = 0; globalCameraIndex < SYSTEM_TOTAL_CAMERA_COUNT; globalCameraIndex++)
    {
      TTntSpeedButton *Img1SpeedButton = (TTntSpeedButton *)FindComponent("Img1SpeedButton" + IntToStr(globalCameraIndex+1));
      TTntSpeedButton *Img2SpeedButton = (TTntSpeedButton *)FindComponent("Img2SpeedButton" + IntToStr(globalCameraIndex+1));
//      TTntSpeedButton *Img3SpeedButton = (TTntSpeedButton *)FindComponent("Img3SpeedButton" + IntToStr(globalCameraIndex+1));
      if(SystemLinkCameraInfo[globalCameraIndex] == 0)
      {
        Img1SpeedButton->Visible = false;
        Img2SpeedButton->Visible = false;
//        Img3SpeedButton->Visible = false;
      }
      else
      {
        if(globalCameraIndex+1 == 1 || globalCameraIndex+1 == 2 || globalCameraIndex+1 == 4 ||
        globalCameraIndex+1 == 9 || globalCameraIndex+1 == 10 || globalCameraIndex+1 == 12  )
        {
          Img1SpeedButton->Top += MoveD;
          Img2SpeedButton->Top += MoveD;
//          Img3SpeedButton->Top += MoveD;
        }
      }
    }
  }
  else if(ProductData.TabletType == TABLET_TYPE_SUGAR_COATED)
  {
    for(int globalCameraIndex = 0; globalCameraIndex < SYSTEM_TOTAL_CAMERA_COUNT; globalCameraIndex++)
    {
      if(globalCameraIndex == SD1_2D_SIDE_FACE_00_CAMERA_INDEX - 1 ||
          globalCameraIndex == SD1_2D_OTHER_SIDE_FACE_00_CAMERA_INDEX - 1 ||
          globalCameraIndex == SD2_2D_SIDE_FACE_00_CAMERA_INDEX - 1 ||
          globalCameraIndex == SD2_2D_OTHER_SIDE_FACE_00_CAMERA_INDEX - 1)
      {
        TTntSpeedButton *Img1SpeedButton = (TTntSpeedButton *)FindComponent("Img1SpeedButton" + IntToStr(globalCameraIndex+1));
        TTntSpeedButton *Img2SpeedButton = (TTntSpeedButton *)FindComponent("Img2SpeedButton" + IntToStr(globalCameraIndex+1));
 //       TTntSpeedButton *Img3SpeedButton = (TTntSpeedButton *)FindComponent("Img3SpeedButton" + IntToStr(globalCameraIndex+1));

        if(Img1SpeedButton)
        {
          Img1SpeedButton->Visible = false;
        }

        if(Img2SpeedButton)
        {
          Img2SpeedButton->Visible = false;
        }

//        if(Img3SpeedButton)
//        {
//          Img3SpeedButton->Visible = false;
//        }
      }
    }
  }
}
//---------------------------------------------------------------------------
void __fastcall TMachineSettingTestForm::VDRunSpeedButtonClick(
      TObject *Sender)
{
	Machine.SuctionDiskRun(MotorSpeed[SD1_MOTOR_INDEX], MotorSpeed[SD2_MOTOR_INDEX],
		ProductData.MachineRunOption.SuctionDisk1InverterSpeed, ProductData.MachineRunOption.SuctionDisk2InverterSpeed);
}
//---------------------------------------------------------------------------
void __fastcall TMachineSettingTestForm::VDStopSpeedButtonClick(
	  TObject *Sender)
{
	Machine.SuctionDiskStop();
}
//---------------------------------------------------------------------------

void __fastcall TMachineSettingTestForm::AirKnifeOnSpeedButtonClick(
      TObject *Sender)
{
	Machine.BowlFeederAKSpeedChange(2);
}
//---------------------------------------------------------------------------
void __fastcall TMachineSettingTestForm::AirKnifeOffSpeedButtonClick(
      TObject *Sender)
{
	Machine.BowlFeederAKSpeedChange(0);
}
//---------------------------------------------------------------------------
void __fastcall TMachineSettingTestForm::NumEditClick(TObject *Sender)
{
	TTntEdit *theEdit = (TTntEdit *) Sender;
	KeyboardForm->Text = theEdit->Text;
  if (KeyboardForm->ShowKeypad() == mrOk)
  {
    theEdit->Text = KeyboardForm->Text;
  }
}
//---------------------------------------------------------------------------
void __fastcall TMachineSettingTestForm::VFRunSpeedButtonClick(
      TObject *Sender)
{
	try
	{
		int bfSpeed = StrToInt(VFSpeedEdit->Text);
		Machine.VFRun(bfSpeed);
	}
	catch (...)
	{

	}
}
//---------------------------------------------------------------------------
void __fastcall TMachineSettingTestForm::VFAutoSpeedButtonClick(
      TObject *Sender)
{
	Machine.VFRun_AutoControl(ProductData.MachineRunOption.MaxSpeedTrainingMode, ProductData.MachineRunOption.ManualMaxSpeed, ProductData.MachineRunOption.ManualModeSensorIndex,
    	ProductData.MachineRunOption.ManualModeSensorActiveRatio, ProductData.MachineRunOption.EmptySensorActiveRatio, ProductData.MachineRunOption.FullSensorActiveRatio);
}
//---------------------------------------------------------------------------
void __fastcall TMachineSettingTestForm::VFStopSpeedButtonClick(
      TObject *Sender)
{
	Machine.VFStop();
}
//---------------------------------------------------------------------------
void __fastcall TMachineSettingTestForm::FeederInnerDiscSpeedUpButtonClick(
      TObject *Sender)
{
	int newSpeedRatio, newSpeed, calculatedSpeedRatio;
  newSpeedRatio = CurrentMotorSpeedRatio[BF_ID_MOTOR_INDEX];

	do
  {
		newSpeedRatio = newSpeedRatio + 1;
		newSpeed = MachineSetupData.ServoMotorData[BF_ID_MOTOR_INDEX].BaseSpeed * 100 / newSpeedRatio;
		calculatedSpeedRatio = MachineSetupData.ServoMotorData[BF_ID_MOTOR_INDEX].BaseSpeed * 100 / newSpeed; 
		 if (newSpeedRatio > 250) return;
  } while (calculatedSpeedRatio == CurrentMotorSpeedRatio[BF_ID_MOTOR_INDEX]);

	CurrentMotorSpeedRatio[BF_ID_MOTOR_INDEX] = calculatedSpeedRatio;
	MotorSpeed[BF_ID_MOTOR_INDEX] = newSpeed;
	ApplyMotorSpeed();
	Machine.MotorSpeedChange(MotorSpeed);
}
//---------------------------------------------------------------------------
void __fastcall TMachineSettingTestForm::FeederInnerDiscSpeedDownButtonClick(
	  TObject *Sender)
{
	int newSpeedRatio, newSpeed, calculatedSpeedRatio;
	newSpeedRatio = CurrentMotorSpeedRatio[BF_ID_MOTOR_INDEX];

	do
	{
		newSpeedRatio = newSpeedRatio - 1;
		newSpeed = MachineSetupData.ServoMotorData[BF_ID_MOTOR_INDEX].BaseSpeed * 100 / newSpeedRatio;
		calculatedSpeedRatio = MachineSetupData.ServoMotorData[BF_ID_MOTOR_INDEX].BaseSpeed * 100 / newSpeed;
		
		if (newSpeedRatio < 20) return;
	} while (calculatedSpeedRatio == CurrentMotorSpeedRatio[BF_ID_MOTOR_INDEX]);

	CurrentMotorSpeedRatio[BF_ID_MOTOR_INDEX] = calculatedSpeedRatio;
	MotorSpeed[BF_ID_MOTOR_INDEX] = newSpeed;
	ApplyMotorSpeed();
	Machine.MotorSpeedChange(MotorSpeed);
}
//---------------------------------------------------------------------------
void __fastcall TMachineSettingTestForm::FeederOuterDisc1SpeedUpButtonClick(
	  TObject *Sender)
{
	int newSpeedRatio, newSpeed, calculatedSpeedRatio;
	newSpeedRatio = CurrentMotorSpeedRatio[BF_OD_IN_MOTOR_INDEX];

	do
	{
		newSpeedRatio = newSpeedRatio + 1;
		newSpeed = MachineSetupData.ServoMotorData[BF_OD_IN_MOTOR_INDEX].BaseSpeed * 100 / newSpeedRatio;
		
		calculatedSpeedRatio = MachineSetupData.ServoMotorData[BF_OD_IN_MOTOR_INDEX].BaseSpeed * 100 / newSpeed;
		if (newSpeedRatio > 250) return;
		
	}	while (calculatedSpeedRatio == CurrentMotorSpeedRatio[BF_OD_IN_MOTOR_INDEX]);
	CurrentMotorSpeedRatio[BF_OD_IN_MOTOR_INDEX] = calculatedSpeedRatio;
	MotorSpeed[BF_OD_IN_MOTOR_INDEX] = newSpeed;
	ApplyMotorSpeed();
	Machine.MotorSpeedChange(MotorSpeed);
}
//---------------------------------------------------------------------------
void __fastcall TMachineSettingTestForm::FeederOuterDisc1SpeedDownButtonClick(
	  TObject *Sender)
{
	int newSpeedRatio, newSpeed, calculatedSpeedRatio;
	newSpeedRatio = CurrentMotorSpeedRatio[BF_OD_IN_MOTOR_INDEX];

	do
	{
		newSpeedRatio = newSpeedRatio - 1;
		newSpeed = MachineSetupData.ServoMotorData[BF_OD_IN_MOTOR_INDEX].BaseSpeed * 100 / newSpeedRatio;
		calculatedSpeedRatio = MachineSetupData.ServoMotorData[BF_OD_IN_MOTOR_INDEX].BaseSpeed * 100 / newSpeed;
		if (newSpeedRatio < 20) return;
	} while (calculatedSpeedRatio == CurrentMotorSpeedRatio[BF_OD_IN_MOTOR_INDEX]);
	CurrentMotorSpeedRatio[BF_OD_IN_MOTOR_INDEX] = calculatedSpeedRatio;
	MotorSpeed[BF_OD_IN_MOTOR_INDEX] = newSpeed;
	ApplyMotorSpeed();
	Machine.MotorSpeedChange(MotorSpeed);
}

//---------------------------------------------------------------------------

void __fastcall TMachineSettingTestForm::FeederOuterDisc2SpeedDownButtonClick(
      TObject *Sender)
{
	int newSpeedRatio, newSpeed, calculatedSpeedRatio;
	newSpeedRatio = CurrentMotorSpeedRatio[BF_OD_OUT_MOTOR_INDEX];

	do
	{
		newSpeedRatio = newSpeedRatio -1;
		newSpeed = MachineSetupData.ServoMotorData[BF_OD_OUT_MOTOR_INDEX].BaseSpeed * 100 / newSpeedRatio;
		calculatedSpeedRatio = MachineSetupData.ServoMotorData[BF_OD_OUT_MOTOR_INDEX].BaseSpeed * 100 / newSpeed;
		if (newSpeedRatio < 20) return;
	}	while (calculatedSpeedRatio == CurrentMotorSpeedRatio[BF_OD_OUT_MOTOR_INDEX]);
	CurrentMotorSpeedRatio[BF_OD_OUT_MOTOR_INDEX] = calculatedSpeedRatio;
	MotorSpeed[BF_OD_OUT_MOTOR_INDEX] = newSpeed;
	ApplyMotorSpeed();
	Machine.MotorSpeedChange(MotorSpeed);
}
//---------------------------------------------------------------------------

void __fastcall TMachineSettingTestForm::FeederOuterDisc2SpeedUpButtonClick(
      TObject *Sender)
{
	int newSpeedRatio, newSpeed, calculatedSpeedRatio;
	newSpeedRatio = CurrentMotorSpeedRatio[BF_OD_OUT_MOTOR_INDEX];

	do
	{
		newSpeedRatio = newSpeedRatio + 1;
		newSpeed = MachineSetupData.ServoMotorData[BF_OD_OUT_MOTOR_INDEX].BaseSpeed * 100 / newSpeedRatio;
		calculatedSpeedRatio = MachineSetupData.ServoMotorData[BF_OD_OUT_MOTOR_INDEX].BaseSpeed * 100 / newSpeed;
		if (newSpeedRatio > 250) return;
	} while (calculatedSpeedRatio == CurrentMotorSpeedRatio[BF_OD_OUT_MOTOR_INDEX]);
	CurrentMotorSpeedRatio[BF_OD_OUT_MOTOR_INDEX] = calculatedSpeedRatio;
	MotorSpeed[BF_OD_OUT_MOTOR_INDEX] = newSpeed;
	ApplyMotorSpeed();
	Machine.MotorSpeedChange(MotorSpeed);
}
//---------------------------------------------------------------------------
void __fastcall TMachineSettingTestForm::SuctionDiskSpeedUpButtonClick(
	  TObject *Sender)
{
	int newSpeedRatio, newSpeed1, newSpeed2;
	int calculatedSpeedRatio1, calculatedSpeedRatio2;
	newSpeedRatio = CurrentMotorSpeedRatio[SD1_MOTOR_INDEX];

	do
	{
		newSpeedRatio = newSpeedRatio + 1;
		newSpeed1 = MachineSetupData.ServoMotorData[SD1_MOTOR_INDEX].BaseSpeed * 100 / newSpeedRatio;
		newSpeed2 = newSpeed1;
		if (newSpeed1 == 0 || newSpeed2 == 0) return;
		calculatedSpeedRatio1 = MachineSetupData.ServoMotorData[SD1_MOTOR_INDEX].BaseSpeed * 100 / newSpeed1;
		calculatedSpeedRatio2 = MachineSetupData.ServoMotorData[SD2_MOTOR_INDEX].BaseSpeed * 100 / newSpeed2;
		if (newSpeedRatio > 250) return;
	}	while (calculatedSpeedRatio1 == CurrentMotorSpeedRatio[SD1_MOTOR_INDEX]);
	CurrentMotorSpeedRatio[SD1_MOTOR_INDEX] = calculatedSpeedRatio1;
	CurrentMotorSpeedRatio[SD2_MOTOR_INDEX] = calculatedSpeedRatio2;
	MotorSpeed[SD1_MOTOR_INDEX] = newSpeed1;
	MotorSpeed[SD2_MOTOR_INDEX] = newSpeed2;
	ApplyMotorSpeed();
	Machine.MotorSpeedChange(MotorSpeed);
}
//---------------------------------------------------------------------------
void __fastcall TMachineSettingTestForm::SuctionDiskSpeedDownButtonClick(
	  TObject *Sender)
{
	int newSpeedRatio, newSpeed1, newSpeed2;
	int calculatedSpeedRatio1, calculatedSpeedRatio2;
	newSpeedRatio = CurrentMotorSpeedRatio[SD1_MOTOR_INDEX];

	do
	{
		newSpeedRatio = newSpeedRatio - 1;
		if (newSpeedRatio <= 0) return;
		newSpeed1 = MachineSetupData.ServoMotorData[SD1_MOTOR_INDEX].BaseSpeed * 100 / newSpeedRatio;
		newSpeed2 = newSpeed1;
		calculatedSpeedRatio1 = MachineSetupData.ServoMotorData[SD1_MOTOR_INDEX].BaseSpeed * 100 / newSpeed1;
		calculatedSpeedRatio2 = MachineSetupData.ServoMotorData[SD2_MOTOR_INDEX].BaseSpeed * 100 / newSpeed2;
		if (newSpeedRatio < 20) return;
	} while (calculatedSpeedRatio1 == CurrentMotorSpeedRatio[SD1_MOTOR_INDEX]);
	CurrentMotorSpeedRatio[SD1_MOTOR_INDEX] = calculatedSpeedRatio1;
	CurrentMotorSpeedRatio[SD2_MOTOR_INDEX] = calculatedSpeedRatio2;
	MotorSpeed[SD1_MOTOR_INDEX] = newSpeed1;
	MotorSpeed[SD2_MOTOR_INDEX] = newSpeed2;
	ApplyMotorSpeed();
	Machine.MotorSpeedChange(MotorSpeed);
}
//---------------------------------------------------------------------------
void __fastcall TMachineSettingTestForm::ApplyMotorSpeed(void)
{
	VDSpeedLabel->Caption = IntToStr((int)(MachineSetupData.ServoMotorData[SD1_MOTOR_INDEX].BaseSpeed * SUCTION_DISK_100P_RPM / MotorSpeed[SD1_MOTOR_INDEX])) + "RPM (" +
		IntToStr(MachineSetupData.ServoMotorData[SD1_MOTOR_INDEX].BaseSpeed * 100 / MotorSpeed[SD1_MOTOR_INDEX]) + "%)";
	BFIDSpeedLabel->Caption = IntToStr(MachineSetupData.ServoMotorData[BF_ID_MOTOR_INDEX].BaseSpeed * 60 / MotorSpeed[BF_ID_MOTOR_INDEX]) + "RPM (" +
		IntToStr(MachineSetupData.ServoMotorData[BF_ID_MOTOR_INDEX].BaseSpeed * 100 / MotorSpeed[BF_ID_MOTOR_INDEX]) + "%)";
	BFODSpeedLabel1->Caption = IntToStr(MachineSetupData.ServoMotorData[BF_OD_IN_MOTOR_INDEX].BaseSpeed * 36 / MotorSpeed[BF_OD_IN_MOTOR_INDEX]) + "RPM (" +
		IntToStr(MachineSetupData.ServoMotorData[BF_OD_IN_MOTOR_INDEX].BaseSpeed * 100 / MotorSpeed[BF_OD_IN_MOTOR_INDEX]) + "%)";
	
	if(MachineSetupData.MachineType == MACHINE_TYPE_SELMA_ADVANCED || MachineSetupData.MachineType == MACHINE_TYPE_LIMA_ADVANCED)
	{
		BFODSpeedLabel2->Caption = IntToStr(MachineSetupData.ServoMotorData[BF_OD_OUT_MOTOR_INDEX].BaseSpeed * 36 / MotorSpeed[BF_OD_OUT_MOTOR_INDEX]) + "RPM (" +
			IntToStr(MachineSetupData.ServoMotorData[BF_OD_OUT_MOTOR_INDEX].BaseSpeed * 100 / MotorSpeed[BF_OD_OUT_MOTOR_INDEX]) + "%)";
	}
}
//--------------------------------------------------
void __fastcall TMachineSettingTestForm::CaptureStartSpeedButtonClick(
    TObject *Sender)
{
	unsigned int camMask = 0;

	AnsiString fileName;
	fileName = ProgramPath.Env + "\\WhiteBalanceInfo.ini";

	for (int globalCameraIndex = 0; globalCameraIndex < SYSTEM_TOTAL_CAMERA_COUNT; globalCameraIndex++)
	{
		// Load White Balance
		ReadCameraWhiteBalanceColorInfo(fileName, globalCameraIndex);
	}

	for (int globalCameraIndex = 0; globalCameraIndex < SYSTEM_TOTAL_CAMERA_COUNT; globalCameraIndex++)
	{
		if ( (globalCameraIndex == UploadingCameraIndex[0] ||
		        globalCameraIndex == UploadingCameraIndex[1]) && (SystemLinkCameraInfo[globalCameraIndex] != 0) )
		{
			camMask |= (0x0001 << globalCameraIndex);

			// Camera Shutter Speed 
			RefreshCameraInfo(globalCameraIndex);
		}
	}

	if (0) //(MachineSetupData.LasercomplexerInfo.Laser_complexer_Enable)
	{
		if ((camMask & (0x0001 << (SD1_3D_FRONT_FACE_CAMERA_INDEX - 1))) == 0)
		{
			Set3DCamera_CaptureParameter(SD1_3D_FRONT_FACE_CAMERA_INDEX - 1, ThreeDCameraDefaultInformation[SD1_3D_FRONT_FACE_CAMERA_INDEX - 1].AnalogCameraGain, ThreeDCameraDefaultInformation[SD1_3D_FRONT_FACE_CAMERA_INDEX - 1].ExposureTime);
		}

		if ((camMask & (0x0001 << (SD2_3D_FRONT_FACE_CAMERA_INDEX - 1))) == 0)
		{
			Set3DCamera_CaptureParameter(SD2_3D_FRONT_FACE_CAMERA_INDEX - 1, ThreeDCameraDefaultInformation[SD2_3D_FRONT_FACE_CAMERA_INDEX - 1].AnalogCameraGain, ThreeDCameraDefaultInformation[SD2_3D_FRONT_FACE_CAMERA_INDEX - 1].ExposureTime);
		}
	}

	float tabletHalfLength = ProductData.TabletLength / 2;

	try
	{
		// 2018-02-19, For SELMA200
		// ̹ Կ    ȮεǾ  Ͽ, SELMA100 ؾ
		if (!SendSPBCaptureSetup_Multi(&ProductData, camMask, tabletHalfLength, tempProductData.ShutterSpeed,
		                               MotorSpeed[SD1_MOTOR_INDEX], MachineSetupData.ServoMotorData[SD1_MOTOR_INDEX].BaseSpeed,
		                               MotorSpeed[SD2_MOTOR_INDEX], MachineSetupData.ServoMotorData[SD2_MOTOR_INDEX].BaseSpeed,
		                               ProductData.SubSamplingMode, false, 3)) //captureMode
		{
			throw Exception("");
		}
		else
		{
			for (int i = 0; i < VISUAL_IMAGE_COUNT ; ++i)
			{
				if (CameraMapInfo[UploadingCameraIndex[i]].CameraInspectPosition == CAMERA_POSITION_3D) // 3d camera
				{
					SetCaptureProperty(IMAGE_WIDTH_3D * 2, IMAGE_HEIGHT_3D, CaptureImage[i], pf8bit);
				}
				else
				{
					SetCaptureProperty(SourceImageWidth, SourceImageHeight, CaptureImage[i], pf24bit);
				}
			}

			CaptureCheckTimer->Enabled = true;
			OnCapture = true;

			TabletCountTimer->Enabled = true;
		}

		TMachineCaptureSetupData machineCaptureSetupData;

		memcpy(machineCaptureSetupData.IlluminatorMask, MachineSetupData.MachineCaptureInfo.IlluminatorMask, SYSTEM_MACHINE_CAPTURE_COUNT * sizeof(int));

		machineCaptureSetupData.TabletLength = ProductData.TabletLength;
		machineCaptureSetupData.TabletSideThick = ProductData.TabletSideThick * 10;
		machineCaptureSetupData.SuctionDiskSpeed = MotorSpeed[SD1_MOTOR_INDEX];
		machineCaptureSetupData.StudiedTabletSensorLength = ProductData.TabletLength / MOTOR_SPEED_TO_LENGTH_CONSTANT_DISC_1 * 20.0 * 1000;
		machineCaptureSetupData.CaptureOption = 2;

		if (!Comm_Request(COMM_HCB, CMD_MACHINE_CAPTURE, &machineCaptureSetupData, sizeof(TMachineCaptureSetupData),
		                  NULL, 0))
		{
			CaptureStopSpeedButton->Click();
			throw Exception("");
		}
	}
	catch (...)
	{}
}


//---------------------------------------------------------------------------
void __fastcall TMachineSettingTestForm::CaptureStopSpeedButtonClick(
      TObject *Sender)
{
	Comm_Request(COMM_HCB, CMD_MACHINE_CAPTURE_STOP);
	CaptureCheckTimer->Enabled = false;
	OnCapture = false;

	TabletCountTimer->Enabled = false;
}
//---------------------------------------------------------------------------
void __fastcall TMachineSettingTestForm::CaptureCheckTimerTimer(
      TObject *Sender)
{
	bool bCaptureExist;
	// check capture exists
	char cameraIndex;
	unsigned int data[2];
	unsigned int receivedData[2];

	int spbCameraMap[SYSTEM_SPB_MAX_COUNT][SYSTEM_SPB_CAMERA_COUNT];

	for (int spbIndex = 0; spbIndex < MachineSetupData.IPB_BoardCount; spbIndex++)
	{
		for (int camIndex = 0; camIndex < SYSTEM_SPB_CAMERA_COUNT; camIndex++)
		{
			spbCameraMap[spbIndex][camIndex] = -1;
		}
	}

	for (int globalCameraIndex = 0; globalCameraIndex < SYSTEM_TOTAL_CAMERA_COUNT; globalCameraIndex++)
	{
		int spbIndex = CameraMapInfo[globalCameraIndex].SPBIndex;
		int camIndex = CameraMapInfo[globalCameraIndex].CamIndex;
    if(SystemLinkCameraInfo[globalCameraIndex] != 0)
    {
		  spbCameraMap[spbIndex][camIndex] = globalCameraIndex;
    }
	}

	for (int imageIndex = 0; imageIndex < VISUAL_IMAGE_COUNT; imageIndex++)
	{
		BufferImage[imageIndex]->Canvas->Brush->Color = clBlack;
		BufferImage[imageIndex]->Canvas->FillRect(Rect(0, 0, BufferImage[imageIndex]->Width, BufferImage[imageIndex]->Height));
	}

	try
	{
		for (int spbIndex = 0; spbIndex < MachineSetupData.IPB_BoardCount; spbIndex++)
		{
			for (int camIndex = 0; camIndex < SYSTEM_SPB_CAMERA_COUNT; camIndex++)
			{
				bool imageExist = false;
				for (int imageIndex = 0; imageIndex < VISUAL_IMAGE_COUNT; imageIndex++)
				{
					if (UploadingCameraIndex[imageIndex] == spbCameraMap[spbIndex][camIndex])
					{
						imageExist = true;
						break;
					}
				}
				if (!imageExist) continue;

				data[0] = camIndex;
				if (!Comm_Request(COMM_SPB + spbIndex, CMD_CAPTURE_EXIST, data, sizeof(unsigned int),
					receivedData, sizeof(unsigned int) * 2))
				{
					throw Exception("");
				}

				int filledBufferCount = receivedData[0];
				int bufferSize = receivedData[1];
				if (receivedData[0])
				{
					bCaptureExist = true;
				}
				else
				{
					bCaptureExist = false;
				}

				if (bCaptureExist)
				{
					for (int imageIndex = 0; imageIndex < VISUAL_IMAGE_COUNT; imageIndex++)
					{
						if (UploadingCameraIndex[imageIndex] == spbCameraMap[spbIndex][camIndex])
						{
							BufferImage[imageIndex]->Canvas->Brush->Color = clLime;
							BufferImage[imageIndex]->Canvas->FillRect(Rect(0, BufferImage[imageIndex]->Height - BufferImage[imageIndex]->Height * receivedData[0] / receivedData[1], BufferImage[imageIndex]->Width, BufferImage[imageIndex]->Height));
						}
					}
					
					if (CameraMapInfo[spbCameraMap[spbIndex][camIndex]].CameraInspectPosition == CAMERA_POSITION_3D)
					{
						data[1] = SYSTEM_CAMERA_WIDTH_3D * SYSTEM_CAMERA_HEIGHT_3D;
						if (!Comm_Request(COMM_SPB + spbIndex, CMD_CAPTURE_UPLOAD, data, 2 * sizeof(unsigned int),
							CaptureData, SYSTEM_CAMERA_WIDTH_3D * SYSTEM_CAMERA_HEIGHT_3D))
						{
							throw Exception("");
						}

						Graphics::TBitmap *tempBitmap = new Graphics::TBitmap;
						tempBitmap->Width = IMAGE_WIDTH_3D;
						tempBitmap->Height = IMAGE_HEIGHT_3D;
						tempBitmap->PixelFormat = pf8bit;
						SetGrayPalette(tempBitmap);

            ImageConversion_3D(tempBitmap, IMAGE_WIDTH_3D, IMAGE_HEIGHT_3D, CaptureData, SYSTEM_CAMERA_WIDTH_3D, SYSTEM_CAMERA_HEIGHT_3D);


						for (int imageIndex = 0; imageIndex < VISUAL_IMAGE_COUNT; imageIndex++)
						{
							if (UploadingCameraIndex[imageIndex] == spbCameraMap[spbIndex][camIndex])
							{
								for (int y = 1; y < IMAGE_HEIGHT_3D - 1; y++)
								{
									byte *pBitmap = (byte *)CaptureImage[imageIndex]->Picture->Bitmap->ScanLine[y];

									byte *pSrc1 = (byte *)tempBitmap->ScanLine[y - 1];
									byte *pSrc2 = (byte *)tempBitmap->ScanLine[y    ];
									byte *pSrc3 = (byte *)tempBitmap->ScanLine[y + 1];

									for (int x = IMAGE_WIDTH_3D * 2 - 1; x >= 0; x--)
									{
										if (x & 2)
										{
											pBitmap[x] = pSrc2[x / 2];
										}
										else
										{
											pBitmap[x] = pSrc2[x / 2];
										}
									}
								}
								CaptureImage[imageIndex]->Repaint();
							}
						}
						delete tempBitmap;
					}
					else
					{
						data[1] = SourceImageWidth * SourceImageHeight;
						if (!Comm_Request(COMM_SPB + spbIndex, CMD_CAPTURE_UPLOAD, data, 2 * sizeof(unsigned int),
							CaptureData, SourceImageWidth * SourceImageHeight))
						{
							throw Exception("");
						}


						for (int imageIndex = 0; imageIndex < VISUAL_IMAGE_COUNT; imageIndex++)
						{
							if (UploadingCameraIndex[imageIndex] == spbCameraMap[spbIndex][camIndex])
							{
                CaptureImage[imageIndex]->Width = 640;
                CaptureImage[imageIndex]->Height = 480;
                CaptureImage[imageIndex]->Picture->Bitmap->PixelFormat = pf24bit;

                
                GetNFACamera2DColorImage(CaptureImage[imageIndex]->Picture->Bitmap, CaptureData, CaptureWidth, CaptureHeight, UploadingCameraIndex[imageIndex], SystemImageOffsetSWCal[UploadingCameraIndex[imageIndex] - 1], SystemOffsetImage[UploadingCameraIndex[imageIndex] - 1], ProductData.SubSamplingMode );
                

                // For SELMA200,    
                if (UploadingCameraIndex[imageIndex] == SD2_2D_SIDE_FACE_P45_CAMERA_INDEX - 1 ||
                    UploadingCameraIndex[imageIndex] == SD2_2D_SIDE_FACE_M45_CAMERA_INDEX - 1)
								{
                  byte *pTempLine = new byte[CaptureImage[imageIndex]->Picture->Bitmap->Width * 3];
                  for (int y = 0; y < (CaptureImage[imageIndex]->Picture->Bitmap->Height); y++)
                  {
                    byte *pBitmap = (byte *)CaptureImage[imageIndex]->Picture->Bitmap->ScanLine[y];

                    for (int x = 0; x < CaptureImage[imageIndex]->Picture->Bitmap->Width; x++)
                    {
                      pTempLine[x * 3 + 0] = pBitmap[(CaptureImage[imageIndex]->Picture->Bitmap->Width - 1 - x) * 3 + 0];
                      pTempLine[x * 3 + 1] = pBitmap[(CaptureImage[imageIndex]->Picture->Bitmap->Width - 1 - x) * 3 + 1];
                      pTempLine[x * 3 + 2] = pBitmap[(CaptureImage[imageIndex]->Picture->Bitmap->Width - 1 - x) * 3 + 2];
                    }
                    memcpy(pBitmap, pTempLine, CaptureImage[imageIndex]->Picture->Bitmap->Width * 3);
                  }
                  delete[] pTempLine;
								}
								else if (UploadingCameraIndex[imageIndex] == SD1_2D_FRONT_FACE_CAMERA_INDEX - 1 ||
                         UploadingCameraIndex[imageIndex]== SD2_2D_FRONT_FACE_CAMERA_INDEX - 1 ||
                         UploadingCameraIndex[imageIndex]== SD1_2D_SIDE_FACE_00_CAMERA_INDEX - 1 ||
                         UploadingCameraIndex[imageIndex]== SD1_2D_OTHER_SIDE_FACE_00_CAMERA_INDEX - 1 ||
                         UploadingCameraIndex[imageIndex] == SD1_2D_SIDE_FACE_P45_CAMERA_INDEX - 1 ||
                         UploadingCameraIndex[imageIndex]== SD1_2D_OTHER_SIDE_FACE_P45_CAMERA_INDEX - 1 ||
                         UploadingCameraIndex[imageIndex] == SD1_2D_SIDE_FACE_M45_CAMERA_INDEX - 1 ||
                         UploadingCameraIndex[imageIndex] == SD1_2D_OTHER_SIDE_FACE_M45_CAMERA_INDEX - 1)
								{
									byte *pTempLineT = new byte[CaptureImage[imageIndex]->Picture->Bitmap->Width * 3];
									byte *pTempLineB = new byte[CaptureImage[imageIndex]->Picture->Bitmap->Width * 3];
									for (int y = 0; y < (CaptureImage[imageIndex]->Picture->Bitmap->Height + 1) / 2; y++)
									{
										byte *pBitmapT = (byte *)CaptureImage[imageIndex]->Picture->Bitmap->ScanLine[y];
										byte *pBitmapB = (byte *)CaptureImage[imageIndex]->Picture->Bitmap->ScanLine[CaptureImage[imageIndex]->Picture->Bitmap->Height - 1 - y];

										memcpy(pTempLineT, pBitmapB, CaptureImage[imageIndex]->Picture->Bitmap->Width * 3);
										memcpy(pTempLineB, pBitmapT, CaptureImage[imageIndex]->Picture->Bitmap->Width * 3);
										memcpy(pBitmapT, pTempLineT, CaptureImage[imageIndex]->Picture->Bitmap->Width * 3);
										memcpy(pBitmapB, pTempLineB, CaptureImage[imageIndex]->Picture->Bitmap->Width * 3);
									}
									delete[] pTempLineT;
									delete[] pTempLineB;
								}

								CaptureImage[imageIndex]->Repaint();
							}
						}
					}
				}
			}
		}
	}
	catch (...)
	{

	}
}
//---------------------------------------------------------------------------
void __fastcall TMachineSettingTestForm::FormDestroy(TObject *Sender)
{
	delete[] CaptureData;
}
//---------------------------------------------------------------------------
void __fastcall TMachineSettingTestForm::Img1CameraSpeedButtonClick(TObject *Sender)
{
	TTntSpeedButton *theSpeedButton = (TTntSpeedButton *) Sender;
	if (theSpeedButton->Down)
	{
		UploadingCameraIndex[0] = theSpeedButton->Tag;
		if (CameraMapInfo[UploadingCameraIndex[0]].CameraInspectPosition == CAMERA_POSITION_3D)
		{
			CaptureImage[0]->Picture->Bitmap->PixelFormat = pf8bit;
			SetGrayPalette(CaptureImage[0]->Picture->Bitmap);
		}
		else
		{
			CaptureImage[0]->Picture->Bitmap->PixelFormat = pf24bit;
		}
		CaptureImage[0]->Picture->Bitmap->Canvas->Brush->Color = clBlack;
		CaptureImage[0]->Picture->Bitmap->Canvas->FillRect(Rect(0, 0, CaptureImage[0]->Picture->Bitmap->Width, CaptureImage[0]->Picture->Bitmap->Height));

    BrightnessEdit1->Text = IntToStr(tempProductData.ShutterSpeed[UploadingCameraIndex[0]]*5);
	}
	else
	{
		UploadingCameraIndex[0] = -1;
	}
}
//---------------------------------------------------------------------------
void __fastcall TMachineSettingTestForm::Img2CameraSpeedButtonClick(
	  TObject *Sender)
{
	TTntSpeedButton *theSpeedButton = (TTntSpeedButton *) Sender;
	if (theSpeedButton->Down)
	{
		UploadingCameraIndex[1] = theSpeedButton->Tag;
		if (CameraMapInfo[UploadingCameraIndex[1]].CameraInspectPosition == CAMERA_POSITION_3D)
		{
			CaptureImage[1]->Picture->Bitmap->PixelFormat = pf8bit;
			SetGrayPalette(CaptureImage[1]->Picture->Bitmap);
		}
		else
		{
			CaptureImage[1]->Picture->Bitmap->PixelFormat = pf24bit;
		}
		CaptureImage[1]->Picture->Bitmap->Canvas->Brush->Color = clBlack;
		CaptureImage[1]->Picture->Bitmap->Canvas->FillRect(Rect(0, 0, CaptureImage[1]->Picture->Bitmap->Width, CaptureImage[1]->Picture->Bitmap->Height));

    BrightnessEdit2->Text = IntToStr(tempProductData.ShutterSpeed[UploadingCameraIndex[0]]*5);
	}
	else
	{
		UploadingCameraIndex[1] = -1;
	}
}

void __fastcall TMachineSettingTestForm::CloseButtonClick(TObject *Sender)
{
	
	if (OnCapture)
	{
		Comm_Request(COMM_HCB, CMD_MACHINE_CAPTURE_STOP);
		CaptureCheckTimer->Enabled = false;
	}

	Machine.MachineStop();	
	// count reset
	int func = 0;
	Comm_Request(COMM_HCB, CMD_TABLET_COUNTER, &func, sizeof(int));
}
//---------------------------------------------------------------------------
void __fastcall TMachineSettingTestForm::NCControlButtonClick(
      TObject *Sender)
{
	NCControlForm->IsMEMode = false;
	NCControlForm->ShowModal();	
}
//---------------------------------------------------------------------------

void __fastcall TMachineSettingTestForm::BrightnessEditClick(
      TObject *Sender)
{
  TTntEdit *theEdit = (TTntEdit *) Sender;
	KeyboardForm->Text = theEdit->Text;
  if (KeyboardForm->ShowKeypad() == mrOk)
  {
    theEdit->Text = KeyboardForm->Text;
  }

  try
  {
    tempProductData.ShutterSpeed[UploadingCameraIndex[0]] = StrToInt(BrightnessEdit1->Text);
    tempProductData.ShutterSpeed[UploadingCameraIndex[1]] = StrToInt(BrightnessEdit2->Text);

    for (int globalCameraIndex = 0; globalCameraIndex < SYSTEM_TOTAL_CAMERA_COUNT; globalCameraIndex++)
    {
      if(globalCameraIndex == UploadingCameraIndex[0] ||
          globalCameraIndex == UploadingCameraIndex[1])
      {
        // Camera Shutter Speed 
        RefreshCameraInfo(globalCameraIndex);
      }
    }
  }
  catch(...)
  {
    
  }
}
//---------------------------------------------------------------------------

void __fastcall TMachineSettingTestForm::RefreshCameraInfo(int camIndex)
{
  int ShutterSpeed = 0;
  int Threshold = 0;
  int WriteMask = 0;

  // Shutter 
  ShutterSpeed = tempProductData.ShutterSpeed[camIndex];

  if(CameraMapInfo[camIndex].CameraInspectPosition == CAMERA_POSITION_3D)
    WriteMask |= CAMERA_WRITE_MASK_3D_SH;
  else
    WriteMask |= CAMERA_WRITE_MASK_2D_SH;

  // Threshold 3D ī޶󿡸 
  if(CameraMapInfo[camIndex].CameraInspectPosition == CAMERA_POSITION_3D)
  {
    Threshold = ProductData.ThresholdFor3D[camIndex];
    WriteMask |= CAMERA_WRITE_MASK_TH;
  }

  TROIInfo DefaultROIInfo, ApplyROIInfo;
  AnsiString filePath;
  int DiskBaseHeight;
  int tempStartY, tempEndY, tempRowCount;
  filePath = ProgramPath.Env + "\\NFACameraInformation.ini";
  DefaultROIInfo = ReadCameraInformation(filePath, camIndex);

  if(CameraMapInfo[camIndex].CameraInspectPosition != CAMERA_POSITION_3D)
  {
    memcpy(&ApplyROIInfo, &DefaultROIInfo, sizeof(TROIInfo));
    WriteMask |= CAMERA_WRITE_MASK_2D_ROI;
  }
  else
  {
    ApplyROIInfo = SetThreeDCameraROI(DefaultROIInfo, &ProductData);
    WriteMask |= CAMERA_WRITE_MASK_3D_ROI;
  }

  if(CameraMapInfo[camIndex].CameraInspectPosition != CAMERA_POSITION_3D)
  {
     WriteMask |= CAMERA_WRITE_MASK_2D_SUBSAMPLING_MODE;
  }

  if(CameraMapInfo[camIndex].CameraInspectPosition != CAMERA_POSITION_3D)
  {
    SetCameraInformation(ApplyROIInfo, ShutterSpeed, Threshold,ProductData.SubSamplingMode, camIndex, WriteMask);
    SetCameraGain(camIndex + 1, SYSTEM_DEFAULT_ANLOG_GAIN, ProductData.DigitalGainV[camIndex], 0);
  }
  else
  {
    int ThreedCameraIndex = 0;
    if(camIndex == SD1_3D_FRONT_FACE_CAMERA_INDEX-1) ThreedCameraIndex = 0;
    else ThreedCameraIndex = 1;

    if(ProductData.ExposureTime3D[ThreedCameraIndex] != -1)
    {
      Set3DCamera_CaptureParameter(camIndex,ProductData.AnalogGain3D[ThreedCameraIndex],ProductData.ExposureTime3D[ThreedCameraIndex]);
    }
    else
    {
      Set3DCamera_CaptureParameter(camIndex,ThreeDCameraDefaultInformation[camIndex].AnalogCameraGain,ThreeDCameraDefaultInformation[camIndex].ExposureTime);
    }
  }


}

//---------------------------------------------------------------------------
void __fastcall TMachineSettingTestForm::SetCaptureProperty(int captureWidth, int captureHeight, TTntImage *destImage, TPixelFormat pixelFormat)
{
	CaptureWidth = captureWidth;
	CaptureHeight = captureHeight;
	DestImage = destImage;
	DestImage->Width = CaptureWidth;
	DestImage->Height = CaptureHeight;
	DestImage->Picture->Bitmap->Width = CaptureWidth;
	DestImage->Picture->Bitmap->Height = CaptureHeight;
	DestImage->Picture->Bitmap->PixelFormat = pixelFormat;
	DestImage->Picture->Bitmap->Canvas->Brush->Color = clBlack;
	if (pixelFormat == pf8bit)
	{
		SetGrayPalette(DestImage->Picture->Bitmap);
	}
	if (CaptureData != NULL)
	{
		delete[] CaptureData;
	}
	CaptureData = new char[(CaptureWidth + 1) * (CaptureHeight + 1)];     // bayer    д.
}
//-----------------------------------------------------------------------------

void __fastcall TMachineSettingTestForm::TntFormActivate(TObject *Sender)
{
  SetScreenPosition(this);  
}
//---------------------------------------------------------------------------
void __fastcall TMachineSettingTestForm::ScrollSuctionMouseDown(
      TObject *Sender, TMouseButton Button, TShiftState Shift, int X,
      int Y)
{
	if (!isScrollSuctionMouseDown)
	{
		ScrollSuctionMouseMovePos.x = X;
		ScrollSuctionMouseMovePos.y = Y;
		ScrollSuctionMouseDownPos.x = X;
		ScrollSuctionMouseDownPos.y = Y;
		isScrollSuctionMouseDown = true;
	}
}
//---------------------------------------------------------------------------
	
void __fastcall TMachineSettingTestForm::ScrollSuctionMouseMove(
      TObject *Sender, TShiftState Shift, int X, int Y)
{
	int temp_speed = 0;
	if (X < 0 || X >= ScrollSuction->Width) return;
	if (isScrollSuctionMouseDown)
	{
		ScrollSuctionMouseMovePos.x = X;
		ScrollSuctionMouseMovePos.y = Y;
		int scrollCount = (X - ScrollSuctionMouseDownPos.x) / 10;
		int newRow = CurrentMotorSpeedRatio[SD1_MOTOR_INDEX] + scrollCount/10;
		if (newRow < 20) 
		{
			newRow = 20;
		}
		else if(newRow > 250)
		{
			newRow = 250;
		}
		
		if (newRow !=CurrentMotorSpeedRatio[SD1_MOTOR_INDEX]) 
		{
			temp_speed = MachineSetupData.ServoMotorData[SD1_MOTOR_INDEX].BaseSpeed * 100 / newRow;
			MotorSpeed[SD1_MOTOR_INDEX] = temp_speed;
			MotorSpeed[SD2_MOTOR_INDEX] = temp_speed;			
			CurrentMotorSpeedRatio[SD1_MOTOR_INDEX] = newRow;
			VDSpeedLabel->Caption = IntToStr((int)(MachineSetupData.ServoMotorData[SD1_MOTOR_INDEX].BaseSpeed * SUCTION_DISK_100P_RPM / MotorSpeed[SD1_MOTOR_INDEX])) + "RPM (" +IntToStr(MachineSetupData.ServoMotorData[SD1_MOTOR_INDEX].BaseSpeed * 100 / MotorSpeed[SD1_MOTOR_INDEX]) + "%)";
		}

		if (scrollCount != 0)
		{
			for (int y = 0; y < ScrollSuction->Height; y++)
			{
				byte *pBitmap = (byte *)ScrollSuction->Picture->Bitmap->ScanLine[y];

				for (int x = 0; x < ScrollSuction->Width; x++)
				{
					byte colorB = 0xFF - abs(x - ScrollSuction->Width / 2 - scrollCount * 8) * 0x4F / (ScrollSuction->Width / 2);
					byte colorG = 0x4F - abs(x - ScrollSuction->Width / 2 - scrollCount * 8) * 0x1F / (ScrollSuction->Width / 2);
					byte colorR = 0x5F - abs(x - ScrollSuction->Width / 2 - scrollCount * 8) * 0x1F / (ScrollSuction->Width / 2);
					if (x % 10 < 2)
					{
						colorB = colorG = colorR = 0;
					}				
					pBitmap[x * 3] = colorB;
					pBitmap[x * 3 + 1] = colorG;
					pBitmap[x * 3 + 2] = colorR;
				}
			}
			ScrollSuction->Repaint();
		}
	}

}
//---------------------------------------------------------------------------

void __fastcall TMachineSettingTestForm::ScrollSuctionMouseUp(
      TObject *Sender, TMouseButton Button, TShiftState Shift, int X,
      int Y)
{
	isScrollSuctionMouseDown = false;

	for (int y = 0; y < ScrollSuction->Height; y++)
	{
		byte *pBitmap = (byte *)ScrollSuction->Picture->Bitmap->ScanLine[y];

		for (int x = 0; x < ScrollSuction->Width; x++)
		{
			byte colorB = 0xFF - abs(x - ScrollSuction->Width / 2) * 0x4F / (ScrollSuction->Width / 2);
			byte colorG = 0x3F - abs(x - ScrollSuction->Width / 2) * 0x1F / (ScrollSuction->Width / 2);
			byte colorR = 0x4F - abs(x - ScrollSuction->Width / 2) * 0x1F / (ScrollSuction->Width / 2);
			if (x % 10 < 2)
			{
				colorB = colorG = colorR = 0;
			}				
			pBitmap[x * 3] = colorB;
			pBitmap[x * 3 + 1] = colorG;
			pBitmap[x * 3 + 2] = colorR;
		}
	}
	ScrollSuction->Repaint();
	Machine.MotorSpeedChange(MotorSpeed);
}
//---------------------------------------------------------------------------

void __fastcall TMachineSettingTestForm::ScrollInnerDiskMouseDown(
      TObject *Sender, TMouseButton Button, TShiftState Shift, int X,
      int Y)
{
	if (!isScrollInnerDiskMouseDown)
	{
		ScrollInnerDiskMouseMovePos.x = X;
		ScrollInnerDiskMouseMovePos.y = Y;
		ScrollInnerDiskMouseDownPos.x = X;
		ScrollInnerDiskMouseDownPos.y = Y;
		isScrollInnerDiskMouseDown = true;
	}
}
//---------------------------------------------------------------------------

void __fastcall TMachineSettingTestForm::ScrollInnerDiskMouseMove(
      TObject *Sender, TShiftState Shift, int X, int Y)
{
	int temp_speed = 0;
	if (X < 0 || X >= ScrollInnerDisk->Width) return;
	if (isScrollInnerDiskMouseDown)
	{
		ScrollInnerDiskMouseMovePos.x = X;
		ScrollInnerDiskMouseMovePos.y = Y;
		int scrollCount = (X - ScrollInnerDiskMouseDownPos.x) / 10;
		int newRow = CurrentMotorSpeedRatio[BF_ID_MOTOR_INDEX] + scrollCount/10;
		if (newRow < 20) 
		{
			newRow = 20;
		}
		else if(newRow > 250)
		{
			newRow = 250;
		}
		
		if (newRow !=CurrentMotorSpeedRatio[BF_ID_MOTOR_INDEX]) 
		{
			temp_speed = MachineSetupData.ServoMotorData[BF_ID_MOTOR_INDEX].BaseSpeed * 100 / newRow;
			MotorSpeed[BF_ID_MOTOR_INDEX] = temp_speed;		
			CurrentMotorSpeedRatio[BF_ID_MOTOR_INDEX] = newRow;
			BFIDSpeedLabel->Caption = IntToStr(MachineSetupData.ServoMotorData[BF_ID_MOTOR_INDEX].BaseSpeed * 60 / MotorSpeed[BF_ID_MOTOR_INDEX]) + "RPM (" +IntToStr(MachineSetupData.ServoMotorData[BF_ID_MOTOR_INDEX].BaseSpeed * 100 / MotorSpeed[BF_ID_MOTOR_INDEX]) + "%)";
			
		}

		if (scrollCount != 0)
		{
			for (int y = 0; y < ScrollInnerDisk->Height; y++)
			{
				byte *pBitmap = (byte *)ScrollInnerDisk->Picture->Bitmap->ScanLine[y];

				for (int x = 0; x < ScrollInnerDisk->Width; x++)
				{
					byte colorB = 0xFF - abs(x - ScrollInnerDisk->Width /2 - scrollCount * 8) * 0x4F / (ScrollInnerDisk->Width / 2);
					byte colorG = 0x4F - abs(x - ScrollInnerDisk->Width /2 - scrollCount * 8) * 0x1F / (ScrollInnerDisk->Width / 2);
					byte colorR = 0x5F - abs(x - ScrollInnerDisk->Width /2 - scrollCount * 8) * 0x1F / (ScrollInnerDisk->Width / 2);
					if (x % 10 < 2)
					{
						colorB = colorG = colorR = 0;
					}				
					pBitmap[x * 3] = colorB;
					pBitmap[x * 3 + 1] = colorG;
					pBitmap[x * 3 + 2] = colorR;
				}
			}
			ScrollInnerDisk->Repaint();
		}
	}
}
//---------------------------------------------------------------------------

void __fastcall TMachineSettingTestForm::ScrollInnerDiskMouseUp(
      TObject *Sender, TMouseButton Button, TShiftState Shift, int X,
      int Y)
{
	isScrollInnerDiskMouseDown = false;

	for (int y = 0; y < ScrollInnerDisk->Height; y++)
	{
		byte *pBitmap = (byte *)ScrollInnerDisk->Picture->Bitmap->ScanLine[y];

		for (int x = 0; x < ScrollInnerDisk->Width; x++)
		{
			byte colorB = 0xFF - abs(x - ScrollInnerDisk->Width / 2) * 0x4F / (ScrollInnerDisk->Width / 2);
			byte colorG = 0x3F - abs(x - ScrollInnerDisk->Width / 2) * 0x1F / (ScrollInnerDisk->Width / 2);
			byte colorR = 0x4F - abs(x - ScrollInnerDisk->Width / 2) * 0x1F / (ScrollInnerDisk->Width / 2);
			if (x % 10 < 2)
			{
				colorB = colorG = colorR = 0;
			}				
			pBitmap[x * 3] = colorB;
			pBitmap[x * 3 + 1] = colorG;
			pBitmap[x * 3 + 2] = colorR;
		}
	}
	ScrollInnerDisk->Repaint();
	Machine.MotorSpeedChange(MotorSpeed);
}
//---------------------------------------------------------------------------

void __fastcall TMachineSettingTestForm::ScrollOutDisk1MouseDown(
      TObject *Sender, TMouseButton Button, TShiftState Shift, int X,
      int Y)
{
	if (!isScrollOutDisk1MouseDown)
	{
		ScrollOutDisk1MouseMovePos.x = X;
		ScrollOutDisk1MouseMovePos.y = Y;
		ScrollOutDisk1MouseDownPos.x = X;
		ScrollOutDisk1MouseDownPos.y = Y;
		isScrollOutDisk1MouseDown = true;
	}
}
//---------------------------------------------------------------------------

void __fastcall TMachineSettingTestForm::ScrollOutDisk1MouseMove(
      TObject *Sender, TShiftState Shift, int X, int Y)
{
	int temp_speed = 0;
	if (X < 0 || X >= ScrollOutDisk1->Width) return;
	if (isScrollOutDisk1MouseDown)
	{
		ScrollOutDisk1MouseMovePos.x = X;
		ScrollOutDisk1MouseMovePos.y = Y;
		int scrollCount = (X - ScrollOutDisk1MouseDownPos.x) / 10;
		int newRow = CurrentMotorSpeedRatio[BF_OD_IN_MOTOR_INDEX] + scrollCount/10;
		if (newRow < 20) 
		{
			newRow = 20;
		}
		else if(newRow > 250)
		{
			newRow = 250;
		}
		
		if (newRow !=CurrentMotorSpeedRatio[BF_OD_IN_MOTOR_INDEX]) 
		{
			temp_speed = MachineSetupData.ServoMotorData[BF_OD_IN_MOTOR_INDEX].BaseSpeed * 100 / newRow;
			MotorSpeed[BF_OD_IN_MOTOR_INDEX] = temp_speed;		
			CurrentMotorSpeedRatio[BF_OD_IN_MOTOR_INDEX] = newRow;
			BFODSpeedLabel1->Caption = IntToStr(MachineSetupData.ServoMotorData[BF_OD_IN_MOTOR_INDEX].BaseSpeed * 36 / MotorSpeed[BF_OD_IN_MOTOR_INDEX]) + "RPM (" + IntToStr(MachineSetupData.ServoMotorData[BF_OD_IN_MOTOR_INDEX].BaseSpeed * 100 / MotorSpeed[BF_OD_IN_MOTOR_INDEX]) + "%)";
		}

		if (scrollCount != 0)
		{
			for (int y = 0; y < ScrollOutDisk1->Height; y++)
			{
				byte *pBitmap = (byte *)ScrollOutDisk1->Picture->Bitmap->ScanLine[y];

				for (int x = 0; x < ScrollOutDisk1->Width; x++)
				{
					byte colorB = 0xFF - abs(x - ScrollOutDisk1->Width / 2 - scrollCount * 8) * 0x4F / (ScrollOutDisk1->Width / 2);
					byte colorG = 0x4F - abs(x - ScrollOutDisk1->Width / 2 - scrollCount * 8) * 0x1F / (ScrollOutDisk1->Width / 2);
					byte colorR = 0x5F - abs(x - ScrollOutDisk1->Width / 2 - scrollCount * 8) * 0x1F / (ScrollOutDisk1->Width / 2);
					if (x % 10 < 2)
					{
						colorB = colorG = colorR = 0;
					}				
					pBitmap[x * 3] = colorB;
					pBitmap[x * 3 + 1] = colorG;
					pBitmap[x * 3 + 2] = colorR;
				}
			}
			ScrollOutDisk1->Repaint();
		}
	}
}
//---------------------------------------------------------------------------

void __fastcall TMachineSettingTestForm::ScrollOutDisk1MouseUp(
      TObject *Sender, TMouseButton Button, TShiftState Shift, int X,
      int Y)
{
	isScrollOutDisk1MouseDown = false;

	for (int y = 0; y < ScrollOutDisk1->Height; y++)
	{
		byte *pBitmap = (byte *)ScrollOutDisk1->Picture->Bitmap->ScanLine[y];

		for (int x = 0; x < ScrollOutDisk1->Width; x++)
		{
			byte colorB = 0xFF - abs(x - ScrollOutDisk1->Width / 2) * 0x4F / (ScrollOutDisk1->Width / 2);
			byte colorG = 0x3F - abs(x - ScrollOutDisk1->Width / 2) * 0x1F / (ScrollOutDisk1->Width / 2);
			byte colorR = 0x4F - abs(x - ScrollOutDisk1->Width / 2) * 0x1F / (ScrollOutDisk1->Width / 2);
			if (x % 10 < 2)
			{
				colorB = colorG = colorR = 0;
			}				
			pBitmap[x * 3] = colorB;
			pBitmap[x * 3 + 1] = colorG;
			pBitmap[x * 3 + 2] = colorR;
		}
	}
	ScrollOutDisk1->Repaint();
	Machine.MotorSpeedChange(MotorSpeed);
}
//---------------------------------------------------------------------------

void __fastcall TMachineSettingTestForm::ScrollOutDisk2MouseDown(
      TObject *Sender, TMouseButton Button, TShiftState Shift, int X,
      int Y)
{
	if (!isScrollOutDisk2MouseDown)
	{
		ScrollOutDisk2MouseMovePos.x = X;
		ScrollOutDisk2MouseMovePos.y = Y;
		ScrollOutDisk2MouseDownPos.x = X;
		ScrollOutDisk2MouseDownPos.y = Y;
		isScrollOutDisk2MouseDown = true;
	}
}
//---------------------------------------------------------------------------

void __fastcall TMachineSettingTestForm::ScrollOutDisk2MouseMove(
      TObject *Sender, TShiftState Shift, int X, int Y)
{
	int temp_speed = 0;
	
	if (X< 0 || X >= ScrollOutDisk2->Width) return;
	if (isScrollOutDisk2MouseDown)
	{
		ScrollOutDisk2MouseMovePos.x = X;
		ScrollOutDisk2MouseMovePos.y = Y;
		int scrollCount = (X - ScrollOutDisk2MouseDownPos.x) / 10;
		int newRow = CurrentMotorSpeedRatio[BF_OD_OUT_MOTOR_INDEX] + scrollCount/10;
		if (newRow < 20) 
		{
			newRow = 20;
		}
		else if(newRow > 250)
		{
			newRow = 250;
		}
		
		if (newRow !=CurrentMotorSpeedRatio[BF_OD_OUT_MOTOR_INDEX]) 
		{
			temp_speed = MachineSetupData.ServoMotorData[BF_OD_OUT_MOTOR_INDEX].BaseSpeed * 100 / newRow;
			MotorSpeed[BF_OD_OUT_MOTOR_INDEX] = temp_speed;	
			CurrentMotorSpeedRatio[BF_OD_OUT_MOTOR_INDEX] = newRow;
			BFODSpeedLabel2->Caption = IntToStr(MachineSetupData.ServoMotorData[BF_OD_OUT_MOTOR_INDEX].BaseSpeed * 36 / MotorSpeed[BF_OD_OUT_MOTOR_INDEX]) + "RPM (" + IntToStr(MachineSetupData.ServoMotorData[BF_OD_OUT_MOTOR_INDEX].BaseSpeed * 100 / MotorSpeed[BF_OD_OUT_MOTOR_INDEX]) + "%)";
		}

		if (scrollCount != 0)
		{
			for (int y = 0; y < ScrollOutDisk2->Height; y++)
			{
				byte *pBitmap = (byte *)ScrollOutDisk2->Picture->Bitmap->ScanLine[y];

				for (int x = 0; x < ScrollOutDisk2->Width; x++)
				{
					byte colorB = 0xFF - abs(x - ScrollOutDisk2->Width / 2 - scrollCount * 8) * 0x4F / (ScrollOutDisk2->Width / 2);
					byte colorG = 0x4F - abs(x - ScrollOutDisk2->Width / 2 - scrollCount * 8) * 0x1F / (ScrollOutDisk2->Width / 2);
					byte colorR = 0x5F - abs(x - ScrollOutDisk2->Width / 2 - scrollCount * 8) * 0x1F / (ScrollOutDisk2->Width / 2);
					if (x % 10 < 2)
					{
						colorB = colorG = colorR = 0;
					}				
					pBitmap[x * 3] = colorB;
					pBitmap[x * 3 + 1] = colorG;
					pBitmap[x * 3 + 2] = colorR;
				}
			}
			ScrollOutDisk2->Repaint();
		}
	}
}
//---------------------------------------------------------------------------

void __fastcall TMachineSettingTestForm::ScrollOutDisk2MouseUp(
      TObject *Sender, TMouseButton Button, TShiftState Shift, int X,
      int Y)
{
	isScrollOutDisk2MouseDown = false;

	for (int y = 0; y < ScrollOutDisk2->Height; y++)
	{
		byte *pBitmap = (byte *)ScrollOutDisk2->Picture->Bitmap->ScanLine[y];

		for (int x = 0; x < ScrollOutDisk2->Width; x++)
		{
			byte colorB = 0xFF - abs(x - ScrollOutDisk2->Width / 2) * 0x4F / (ScrollOutDisk2->Width / 2);
			byte colorG = 0x3F - abs(x - ScrollOutDisk2->Width / 2) * 0x1F / (ScrollOutDisk2->Width / 2);
			byte colorR = 0x4F - abs(x - ScrollOutDisk2->Width / 2) * 0x1F / (ScrollOutDisk2->Width / 2);
			if (x % 10 < 2)
			{
				colorB = colorG = colorR = 0;
			}				
			pBitmap[x * 3] = colorB;
			pBitmap[x * 3 + 1] = colorG;
			pBitmap[x * 3 + 2] = colorR;
		}
	}
	ScrollSuction->Repaint();
	Machine.MotorSpeedChange(MotorSpeed);
}

void __fastcall TMachineSettingTestForm::InnerDiskRunButtonClick(
      TObject *Sender)
{
	Machine.ServoMotorRun(BF_ID_MOTOR_INDEX,MachineSetupData.ServoMotorData[BF_ID_MOTOR_INDEX].BaseSpeed,MotorSpeed[BF_ID_MOTOR_INDEX],MachineSetupData.ServoMotorData[BF_ID_MOTOR_INDEX].AccTime, MachineSetupData.ServoMotorData[BF_ID_MOTOR_INDEX].Dir);
}
//---------------------------------------------------------------------------
void __fastcall TMachineSettingTestForm::InnerDiskStopButtonClick(
      TObject *Sender)
{
	Machine.ServoMotorStop(BF_ID_MOTOR_INDEX,MachineSetupData.ServoMotorData[BF_ID_MOTOR_INDEX].DecTime);
}
//---------------------------------------------------------------------------

void __fastcall TMachineSettingTestForm::OutDisk1RunButtonClick(
      TObject *Sender)
{
	Machine.ServoMotorRun(BF_OD_IN_MOTOR_INDEX,MachineSetupData.ServoMotorData[BF_OD_IN_MOTOR_INDEX].BaseSpeed,MotorSpeed[BF_OD_IN_MOTOR_INDEX],MachineSetupData.ServoMotorData[BF_OD_IN_MOTOR_INDEX].AccTime, MachineSetupData.ServoMotorData[BF_OD_IN_MOTOR_INDEX].Dir);
}
//---------------------------------------------------------------------------

void __fastcall TMachineSettingTestForm::OutDisk1StopButtonClick(
      TObject *Sender)
{
	Machine.ServoMotorStop(BF_OD_IN_MOTOR_INDEX,MachineSetupData.ServoMotorData[BF_OD_IN_MOTOR_INDEX].DecTime);
}
//---------------------------------------------------------------------------

void __fastcall TMachineSettingTestForm::OutDisk2RunButtonClick(
      TObject *Sender)
{
	Machine.ServoMotorRun(BF_OD_OUT_MOTOR_INDEX,MachineSetupData.ServoMotorData[BF_OD_OUT_MOTOR_INDEX].BaseSpeed,MotorSpeed[BF_OD_OUT_MOTOR_INDEX],MachineSetupData.ServoMotorData[BF_OD_OUT_MOTOR_INDEX].AccTime, MachineSetupData.ServoMotorData[BF_OD_OUT_MOTOR_INDEX].Dir);
}
//---------------------------------------------------------------------------

void __fastcall TMachineSettingTestForm::OutDisk2StopButtonClick(
      TObject *Sender)
{
	Machine.ServoMotorStop(BF_OD_OUT_MOTOR_INDEX,MachineSetupData.ServoMotorData[BF_OD_OUT_MOTOR_INDEX].DecTime);
}
//---------------------------------------------------------------------------

