//---------------------------------------------------------------------------

#ifndef MachineSettingTest_FormH
#define MachineSettingTest_FormH
//---------------------------------------------------------------------------
#include <Classes.hpp>
#include <Controls.hpp>
#include <StdCtrls.hpp>
#include <Forms.hpp>
#include <ExtCtrls.hpp>
#include <Buttons.hpp>
#include <Grids.hpp>
#include <vector.h>
#include "Environment.h"
#include "TntButtons.hpp"
#include "TntExtCtrls.hpp"
#include "TntStdCtrls.hpp"
#include "TntForms.hpp"
#include "TntGrids.hpp"

#include "Calibration_Form.h"

#define VISUAL_IMAGE_COUNT		2
//---------------------------------------------------------------------------
class TMachineSettingTestForm : public TTntForm
{
__published:	// IDE-managed Components
	TTntPanel *Panel1;
	TTntPanel *Panel2;
	TTntGroupBox *GroupBox8;
	TTntButton *MainControlRunButton;
	TTntButton *MainControlStopButton;
	TTntButton *MainControlCleaningButton;
	TTntButton *MainControlReadyButton;
	TTntGroupBox *GroupBox13;
	TTntGroupBox *GroupBox3;
	TTntSpeedButton *VDRunSpeedButton;
	TTntSpeedButton *VDStopSpeedButton;
	TTntGroupBox *GroupBox5;
	TTntButton *InnerDiskRunButton;
	TTntButton *InnerDiskStopButton;
	TTntGroupBox *GroupBox2;
	TTntSpeedButton *CaptureStartSpeedButton;
	TTntSpeedButton *CaptureStopSpeedButton;
	TTntButton *CloseButton;
	TTimer *CaptureCheckTimer;
	TTntButton *NCControlButton;
	TTimer *TabletCountTimer;
	TTntLabel *Label4;
	TTntLabel *Label6;
	TTntLabel *TabletCountLabel;
	TTntLabel *CPHLabel;
	TTntSpeedButton *CounterResetSpeedButton;
  TPanel *Panel3;
  TTntImage *CaptureImage1;
  TTntSpeedButton *Img1SpeedButton1;
  TTntSpeedButton *Img1SpeedButton9;
  TTntSpeedButton *Img1SpeedButton10;
  TTntSpeedButton *Img1SpeedButton2;
  TTntSpeedButton *Img1SpeedButton3;
  TTntSpeedButton *Img1SpeedButton11;
  TTntSpeedButton *Img1SpeedButton12;
  TTntSpeedButton *Img1SpeedButton4;
  TTntSpeedButton *Img1SpeedButton5;
  TTntSpeedButton *Img1SpeedButton13;
  TTntSpeedButton *Img1SpeedButton14;
  TTntSpeedButton *Img1SpeedButton6;
  TTntSpeedButton *Img1SpeedButton7;
  TTntSpeedButton *Img1SpeedButton15;
  TTntSpeedButton *Img1SpeedButton16;
  TTntSpeedButton *Img1SpeedButton8;
  TTntImage *BufferImage1;
  TEdit *BrightnessEdit1;
  TPanel *Panel4;
  TTntImage *CaptureImage2;
  TTntSpeedButton *Img2SpeedButton1;
  TTntSpeedButton *Img2SpeedButton9;
  TTntSpeedButton *Img2SpeedButton10;
  TTntSpeedButton *Img2SpeedButton2;
  TTntSpeedButton *Img2SpeedButton3;
  TTntSpeedButton *Img2SpeedButton11;
  TTntSpeedButton *Img2SpeedButton12;
  TTntSpeedButton *Img2SpeedButton4;
  TTntSpeedButton *Img2SpeedButton5;
  TTntSpeedButton *Img2SpeedButton13;
  TTntSpeedButton *Img2SpeedButton14;
  TTntSpeedButton *Img2SpeedButton6;
  TTntSpeedButton *Img2SpeedButton7;
  TTntSpeedButton *Img2SpeedButton15;
  TTntSpeedButton *Img2SpeedButton16;
  TTntSpeedButton *Img2SpeedButton8;
  TTntImage *BufferImage2;
  TEdit *BrightnessEdit2;
  TTntLabel *Label7;
  TTntLabel *Label5;
	TTntGroupBox *GroupBox1;
	TTntSpeedButton *VFRunSpeedButton;
	TTntSpeedButton *VFStopSpeedButton;
	TTntSpeedButton *VFAutoSpeedButton;
	TTntLabel *Label13;
	TTntEdit *VFSpeedEdit;
	TTntButton *SuctionDiskSpeedDownButton;
	TTntLabel *Label3;
	TTntLabel *VDSpeedLabel;
	TTntButton *SuctionDiskSpeedUpButton;
	TTntButton *FeederInnerDiscSpeedDownButton;
	TTntLabel *Label1;
	TTntLabel *BFIDSpeedLabel;
	TTntButton *FeederInnerDiscSpeedUpButton;
	TTntImage *ScrollSuction;
	TGroupBox *GroupBox6;
	TTntSpeedButton *OutDisk1StopButton;
	TTntSpeedButton *OutDisk1RunButton;
	TTntLabel *TntLabel1;
	TTntLabel *BFODSpeedLabel1;
	TTntButton *FeederOuterDisc1SpeedDownButton;
	TTntButton *FeederOuterDisc1SpeedUpButton;
	TGroupBox *GroupBox7;
	TTntSpeedButton *OutDisk2StopButton;
	TTntSpeedButton *OutDisk2RunButton;
	TTntLabel *TntLabel3;
	TTntLabel *BFODSpeedLabel2;
	TTntButton *FeederOuterDisc2SpeedDownButton;
	TTntButton *FeederOuterDisc2SpeedUpButton;
	TTntImage *ScrollInnerDisk;
	TTntImage *ScrollOutDisk1;
	TTntImage *ScrollOutDisk2;
	TGroupBox *GroupBox4;
	TTntSpeedButton *AirKnifeOffSpeedButton;
	TTntSpeedButton *AirKnifeOnSpeedButton;
	void __fastcall MainControlRunButtonClick(TObject *Sender);
	void __fastcall MainControlStopButtonClick(TObject *Sender);
	void __fastcall MainControlCleaningButtonClick(TObject *Sender);
	void __fastcall MainControlReadyButtonClick(TObject *Sender);
	void __fastcall FormCreate(TObject *Sender);
	void __fastcall VDRunSpeedButtonClick(TObject *Sender);
	void __fastcall VDStopSpeedButtonClick(TObject *Sender);
	void __fastcall InnerDiskRunButtonClick(TObject *Sender);
	void __fastcall InnerDiskStopButtonClick(TObject *Sender);
	void __fastcall AirKnifeOnSpeedButtonClick(TObject *Sender);
	void __fastcall AirKnifeOffSpeedButtonClick(TObject *Sender);
	void __fastcall NumEditClick(TObject *Sender);
	void __fastcall VFRunSpeedButtonClick(TObject *Sender);
	void __fastcall VFAutoSpeedButtonClick(TObject *Sender);
	void __fastcall VFStopSpeedButtonClick(TObject *Sender);
	void __fastcall FeederInnerDiscSpeedUpButtonClick(TObject *Sender);
	void __fastcall FeederInnerDiscSpeedDownButtonClick(TObject *Sender);
	void __fastcall FeederOuterDisc1SpeedUpButtonClick(TObject *Sender);
	void __fastcall FeederOuterDisc1SpeedDownButtonClick(TObject *Sender);
	void __fastcall SuctionDiskSpeedUpButtonClick(TObject *Sender);
	void __fastcall SuctionDiskSpeedDownButtonClick(TObject *Sender);
	void __fastcall CaptureStartSpeedButtonClick(TObject *Sender);
	void __fastcall CaptureStopSpeedButtonClick(TObject *Sender);
	void __fastcall CaptureCheckTimerTimer(TObject *Sender);
	void __fastcall Img1CameraSpeedButtonClick(TObject *Sender);
	void __fastcall FormDestroy(TObject *Sender);
	void __fastcall Img2CameraSpeedButtonClick(TObject *Sender);
	void __fastcall CloseButtonClick(TObject *Sender);
	void __fastcall NCControlButtonClick(TObject *Sender);
	void __fastcall BrightnessEditClick(TObject *Sender);
	void __fastcall TntFormActivate(TObject *Sender);
	void __fastcall ScrollSuctionMouseDown(TObject *Sender, TMouseButton Button, TShiftState Shift, int X, int Y);
	void __fastcall ScrollSuctionMouseMove(TObject *Sender, TShiftState Shift, int X, int Y);
	void __fastcall ScrollSuctionMouseUp(TObject *Sender, TMouseButton Button, TShiftState Shift, int X, int Y);
	void __fastcall ScrollInnerDiskMouseDown(TObject *Sender,TMouseButton Button, TShiftState Shift, int X, int Y);
	void __fastcall ScrollInnerDiskMouseMove(TObject *Sender, TShiftState Shift, int X, int Y);
	void __fastcall ScrollInnerDiskMouseUp(TObject *Sender, TMouseButton Button, TShiftState Shift, int X, int Y);
	void __fastcall ScrollOutDisk1MouseDown(TObject *Sender, TMouseButton Button, TShiftState Shift, int X, int Y);
	void __fastcall ScrollOutDisk1MouseMove(TObject *Sender, TShiftState Shift, int X, int Y);
	void __fastcall ScrollOutDisk1MouseUp(TObject *Sender, TMouseButton Button, TShiftState Shift, int X, int Y);
	void __fastcall ScrollOutDisk2MouseDown(TObject *Sender, TMouseButton Button, TShiftState Shift, int X, int Y);
	void __fastcall ScrollOutDisk2MouseMove(TObject *Sender, TShiftState Shift, int X, int Y);
	void __fastcall ScrollOutDisk2MouseUp(TObject *Sender, TMouseButton Button, TShiftState Shift, int X, int Y);
	void __fastcall FeederOuterDisc2SpeedDownButtonClick(TObject *Sender);
	void __fastcall FeederOuterDisc2SpeedUpButtonClick(TObject *Sender);
	void __fastcall OutDisk1RunButtonClick(TObject *Sender);
	void __fastcall OutDisk1StopButtonClick(TObject *Sender);
	void __fastcall OutDisk2RunButtonClick(TObject *Sender);
	void __fastcall OutDisk2StopButtonClick(TObject *Sender);

private:	// User declarations
  TProductData tempProductData;

  int SourceImageWidth;
  int SourceImageHeight;
  
  int CaptureWidth;
	int CaptureHeight;
  TTntImage *DestImage;

	int CurrentMotorSpeedRatio[MAX_SERVO_MOTOR_COUNT];
	int MotorSpeed[MAX_SERVO_MOTOR_COUNT];
	bool OnCapture;
	int UploadingCameraIndex[VISUAL_IMAGE_COUNT];
	TTntImage *CaptureImage[VISUAL_IMAGE_COUNT];
	TTntImage *BufferImage[VISUAL_IMAGE_COUNT];
	unsigned char *CaptureData;
	bool isScrollSuctionMouseDown;
	bool isScrollInnerDiskMouseDown;
	bool isScrollOutDisk1MouseDown;
	bool isScrollOutDisk2MouseDown;

	TPoint ScrollSuctionMouseMovePos;
	TPoint ScrollInnerDiskMouseMovePos;
	TPoint ScrollOutDisk1MouseMovePos;
	TPoint ScrollOutDisk2MouseMovePos;

	TPoint ScrollSuctionMouseDownPos;
	TPoint ScrollInnerDiskMouseDownPos;
	TPoint ScrollOutDisk1MouseDownPos;
	TPoint ScrollOutDisk2MouseDownPos;	
	void __fastcall ApplyMotorSpeed(void);
  void __fastcall GetDefaultString();
  void __fastcall RefreshCameraInfo(int camIndex);
  void __fastcall SetCaptureProperty(int captureWidth, int captureHeight, TTntImage *destImage, TPixelFormat pixelFormat);
  int CurrentMotorSpeedIndex;
  int CurrentMotorSpeedList[MAX_SERVO_MOTOR_COUNT][MOTOR_SPEED_STEP_COUNT_FOR_PRODUCT];
  int CurrentMotorSpeedRatioList[MAX_SERVO_MOTOR_COUNT][MOTOR_SPEED_STEP_COUNT_FOR_PRODUCT];
	int OldMotorSpeedList[MAX_SERVO_MOTOR_COUNT][MOTOR_SPEED_STEP_COUNT_FOR_PRODUCT];
public:		// User declarations
	__fastcall TMachineSettingTestForm(TComponent* Owner);
};
//---------------------------------------------------------------------------
extern PACKAGE TMachineSettingTestForm *MachineSettingTestForm;
//---------------------------------------------------------------------------
#endif
