//---------------------------------------------------------------------------
// For SELMA200, 20180223, moon, 
//---------------------------------------------------------------------------

#include <vcl.h>
#pragma hdrstop

#include "NFA2DCameraSetting_Form.h"
#include "Keyboard_Form.h"
#include "MultiLanguage.h"
//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma link "CSPIN"
#pragma link "TntExtCtrls"
#pragma link "TntStdCtrls"
#pragma resource "*.dfm"
TNFA2DCameraSettingForm *NFA2DCameraSettingForm = NULL;
//---------------------------------------------------------------------------
__fastcall TNFA2DCameraSettingForm::TNFA2DCameraSettingForm(TComponent* Owner)
	: TTntForm(Owner)
{
  if(DefaultLCID == 1028 || DefaultLCID == 2052 || DefaultLCID == 3076 || DefaultLCID == 4100)
    ComponentSetFontName(this, "SimSun");
  else if(DefaultLCID == 1041)
    ComponentSetFontName(this, "Meiryo UI");
  else if(DefaultLCID == 3082)
  {
    ComponentSetFontName(this, "Segoe UI");
    ComponentSetMultiLine(this);
  }

	GlobalCameraIndex = 0;

  ErrorMsg[0] = "Input Error";
  ErrorMsg[1] = "The start position of the ROI must be less than the end position."; // "ROI  ġ  ġ ۾ƾմϴ."
  ErrorMsg[2] = "ROI height cannot exceed 959."; // "ROI ̴ 959   ϴ. (" + IntToStr(abs(tempStY - tempEdY)) + ")"
  ErrorMsg[3] = "Binning Mode Sub Sampling Mode ÿ   ϴ.";

  bETCCamera = false;

  //this->Height = 898;
}
//---------------------------------------------------------------------------
void __fastcall TNFA2DCameraSettingForm::SetGlobalCameraIndex(int cameraIndex)
{
  if(cameraIndex == 0xFF)
  {
    bETCCamera = true;
    lblCameraID->Caption = "User-Selected Camera (B" + IntToStr(SelectedBoardID) + "/C" + IntToStr(SelectedCameraID) + ")";
  }
  else
  {
    bETCCamera = false;
    GlobalCameraIndex = cameraIndex;
    lblCameraID->Caption = "#" + IntToStr(GlobalCameraIndex + 1) + " CAM";
  }

  SetDefaultPacket(9, true, false, NULL);
  SetDefaultPacket(10, false, false, NULL);

  UserSelect = false;
  
  SendPacketLengthEdit->Text = "9";
  ReceivePacketLengthEdit->Text = "10";

  ReadOrWriteBtn1->Down = false;

  None1->Down = true;
  None2->Down = true;
}
//---------------------------------------------------------------------------

bool __fastcall TNFA2DCameraSettingForm::RequestCameraCommand(char *sendData, char *receivedData, unsigned int txDataLength, unsigned int rxDataLength)
{
	int spbIndex;

  if(!bETCCamera)
  {
    spbIndex = CameraMapInfo[GlobalCameraIndex].SPBIndex;
  }
  else
  {
    spbIndex = SelectedBoardID - 1;
  }

  const int MAX_COMM_DATA_LENGTH = 20;
  char tempSendData[MAX_COMM_DATA_LENGTH];
  memcpy(tempSendData + 2, sendData, sizeof(char) * txDataLength);
  *(tempSendData + 0) = txDataLength;
  *(tempSendData + 1) = rxDataLength;
  txDataLength += 2;

  Comm_SetMaxWaitingTime(COMM_SPB + spbIndex, 30000);
  if (!Comm_Request(COMM_SPB + spbIndex, CMD_CAMERA_CONTROL_NORMAL_MODE, tempSendData, txDataLength, receivedData, rxDataLength))
  {
    ShowMessage("Communication Error #" + IntToStr(spbIndex + 1) + " IPB");
    Comm_SetDefaultMaxWaitingTime(COMM_SPB + spbIndex);
    return false;
  }
  else
  {
    // receivedData мؼ Time out ߻  Ȯؾ, SPB ۾ ʿ
    // ShowMessage("Communication Error #" + IntToStr(spbIndex + 1) + " SPB : Camera Timeout.");
     Comm_SetDefaultMaxWaitingTime(COMM_SPB + spbIndex);
    return true;
  }
  Comm_SetDefaultMaxWaitingTime(COMM_SPB + spbIndex);
}
//---------------------------------------------------------------------------
void __fastcall TNFA2DCameraSettingForm::NumSpinEditClick(
      TObject *Sender)
{
	TCSpinEdit *theEdit = (TCSpinEdit *) Sender;
	KeyboardForm->Text = theEdit->Text; 
  
	if (KeyboardForm->ShowKeypad() == mrOk)
	{
    try
    {
		  theEdit->Value = StrToInt(KeyboardForm->Text);
    }
    catch(...)
    {
      ShowMessage(ErrorMsg[0]);
    }
	}
}
//---------------------------------------------------------------------------

void __fastcall TNFA2DCameraSettingForm::SetDefaultButtonClick(
      TObject *Sender)
{
  // Binning mode
  cmdNFACameraData1->ItemIndex = 0;
  cmdNFACameraData2->ItemIndex = 3;

  // 1280 * 1024
  cmdNFACameraData3->Value = 0;
  cmdNFACameraData4->Value = 159;
  cmdNFACameraData5->Value = 0;
  cmdNFACameraData6->Value = 959;

  cmdNFACameraData8->ItemIndex = 0;  //0dB
  cmdNFACameraData9->Value = 2;  //0dB
  cmdNFACameraData10->Value = 0;  //0dB
  
  cmdNFACameraData11->Value = 1; //B
  cmdNFACameraData12->Value = 1; //G
  cmdNFACameraData13->Value = 1; //G
  cmdNFACameraData14->Value = 1; //R

  cmdNFACameraData11_2->Value = 0; //B
  cmdNFACameraData12_2->Value = 0; //G
  cmdNFACameraData13_2->Value = 0; //G
  cmdNFACameraData14_2->Value = 0; //R

  cmdNFACameraData15->ItemIndex = 1; // 1/4 ۼӵ
  cmdNFACameraData16->ItemIndex = 3; //  8bit
  cmdNFACameraData17->ItemIndex = 1; //External Trigger Master

  ShowMessage("Set Default Value");
}
//---------------------------------------------------------------------------

void __fastcall TNFA2DCameraSettingForm::CloseButtonClick(TObject *Sender)
{
	this->Close();	
}
//---------------------------------------------------------------------------

void __fastcall TNFA2DCameraSettingForm::WriteAllButtonClick(
      TObject *Sender)
{
  bool bErrorData = false;
  int ErrorCode = ERROR_CODE_NONE;

  // Data Check
  int tempStX, tempEdX, tempStY, tempEdY;
  int BinningMode, SamplingMode;

  BinningMode = cmdNFACameraData1->ItemIndex;
  SamplingMode = cmdNFACameraData2->ItemIndex;

  tempStX = cmdNFACameraData3->Value;
  tempEdX = cmdNFACameraData4->Value;
  tempStY = cmdNFACameraData5->Value;
  tempEdY = cmdNFACameraData6->Value;

  if(tempStX > tempEdX || tempStY > tempEdY)
  {
    bErrorData = true;
    ErrorCode = ERROR_CODE_ROI1;
  }
  else if(abs(tempStY - tempEdY) > 959)
  {
    bErrorData = true;
    ErrorCode = ERROR_CODE_ROI2;
  }
  else if(BinningMode && SamplingMode)
  {
    bErrorData = true;
    ErrorCode = ERROR_CODE_IMAGE_MODE;
  }

  if(bErrorData)
  {
    if(ErrorCode == ERROR_CODE_ROI1)
    {
      ShowMessage(ErrorMsg[1]);
    }
    else if(ErrorCode == ERROR_CODE_ROI2)
    {
      ShowMessage(ErrorMsg[2]+"(" + IntToStr(abs(tempStY - tempEdY)) + ")");
    }
    else if(ErrorCode == ERROR_CODE_IMAGE_MODE)
    {
      ShowMessage(ErrorMsg[3]);
    }

    ShowMessage("Fail to write");

    return;
  }
  else
  {
    // Set Transmission Data
    for(int dIndex = 0; dIndex < MAX_2D_CAMERA_DATA_INDEX; dIndex++)
    {
      if(dIndex == ECAMERA_PARAM_2D_BINNING_MODE ||
          dIndex == ECAMERA_PARAM_2D_SAMPLING_MODE ||
          dIndex == ECAMERA_PARAM_2D_DATA_TRANSFER_RATE ||
          dIndex == ECAMERA_PARAM_2D_ANALOG_GAIN ||
          dIndex == ECAMERA_PARAM_2D_IMAGE_FORMAT ||
          dIndex == ECAMERA_PARAM_2D_TRIGGER_MODE)
      {
        TTntComboBox *aComboBox = (TTntComboBox *) FindComponent("cmdNFACameraData" + IntToStr(dIndex + 1));

        if(aComboBox)
        {
          Data[dIndex] = aComboBox->ItemIndex;
        }
        else
        {
          Data[dIndex] = -1;
        }
      }
      else if(dIndex == ECAMERA_PARAM_2D_WHITE_BALANCE_B ||
              dIndex == ECAMERA_PARAM_2D_WHITE_BALANCE_G1 ||
              dIndex == ECAMERA_PARAM_2D_WHITE_BALANCE_G2 ||
              dIndex == ECAMERA_PARAM_2D_WHITE_BALANCE_R)
      {
        TCSpinEdit *aEdit1 = (TCSpinEdit *) FindComponent("cmdNFACameraData" + IntToStr(dIndex + 1));
        TCSpinEdit *aEdit2 = (TCSpinEdit *) FindComponent("cmdNFACameraData" + IntToStr(dIndex + 1) + "_2");

        if(aEdit1 && aEdit2)
        {
          Data[dIndex] = aEdit1->Value * 1000 + aEdit2->Value;
        }
        else
        {
          Data[dIndex] = 0;
        }
      }
      else
      {
        TCSpinEdit *aEdit = (TCSpinEdit *) FindComponent("cmdNFACameraData" + IntToStr(dIndex + 1));

        if(aEdit)
        {
          Data[dIndex] = aEdit->Value;
        }
        else
        {
          Data[dIndex] = -1;
        }
      }
    }

    // Data Transfer
    const int MAX_COMM_DATA_LENGTH = 20;
    char TxData[MAX_COMM_DATA_LENGTH];
    char RxData[MAX_COMM_DATA_LENGTH];
    bool bRead = false;
    TCommDataLength CommDataLength;
    bool bBreakSW = false;
    for(int dIndex = 0; dIndex < MAX_2D_CAMERA_DATA_INDEX; dIndex++)
    {

      if((dIndex == ECAMERA_PARAM_2D_BINNING_MODE && !ImageModeRB1->Checked) ||
          (dIndex == ECAMERA_PARAM_2D_SAMPLING_MODE && !ImageModeRB2->Checked))
      {
        // Binning Ȥ SubSampling 带 Write ϸ  尡 ڵ OFF· Ǿ
        continue;
      }

      //if(dIndex == ECAMERA_PARAM_2D_SAMPLING_MODE) continue; //쿡  SubSampling Ŀǵ    check

      if(Data[dIndex] != -1)
      {
        memset(TxData, 0, sizeof(char) * MAX_COMM_DATA_LENGTH);
        memset(RxData, 0, sizeof(char) * MAX_COMM_DATA_LENGTH);

        CommDataLength = MakeCameraDataPacket(TxData, dIndex, bRead);
        if(!RequestCameraCommand(TxData, RxData, CommDataLength.SendDataLength, CommDataLength.ReceivedDataLength))
        {
          bBreakSW = true;
        }

        if(RxData[0] == 'T' && RxData[1] == 'O')
    	  {
    		  bBreakSW = true;
    	  }

        if(bBreakSW)
        {
          bErrorData = true;
          break;
        }

        // Write   н
        if(dIndex == ECAMERA_PARAM_2D_ROI_START_X) dIndex += 3;
        else if(dIndex == ECAMERA_PARAM_2D_DIGIT_GAIN1) dIndex += 1;
        //else if(dIndex == ECAMERA_PARAM_2D_WHITE_BALANCE_B) dIndex += 2;
      }
    }

    if(bErrorData)
    {
      ShowMessage("Fail to write");
    }
    else
    {
      // Write   ini Ϸ 
      if(!bETCCamera)
      {
        VariableCameraInformation[GlobalCameraIndex].ROIStartX =  Data[ECAMERA_PARAM_2D_ROI_START_X];
        VariableCameraInformation[GlobalCameraIndex].ROIStartY =  Data[ECAMERA_PARAM_2D_ROI_START_Y];
        VariableCameraInformation[GlobalCameraIndex].ROIEndX =    Data[ECAMERA_PARAM_2D_ROI_END_X];
        VariableCameraInformation[GlobalCameraIndex].ROIEndY =    Data[ECAMERA_PARAM_2D_ROI_END_Y];

        AnsiString filePath;
        filePath = ProgramPath.Env + "\\NFACameraInformation.ini";

        WriteCameraInformation(filePath, GlobalCameraIndex);

        ShowMessage("Success to write");
      }
    }
  }
}
//---------------------------------------------------------------------------

void __fastcall TNFA2DCameraSettingForm::ReadAllButtonClick(
      TObject *Sender)
{
  const int MAX_COMM_DATA_LENGTH = 20;
  char TxData[MAX_COMM_DATA_LENGTH];
  char RxData[MAX_COMM_DATA_LENGTH];
  bool bRead = true;
  bool bBreakSW = false;
  bool bError = false;
  TCommDataLength CommDataLength;
  for(int dIndex = 0; dIndex < MAX_2D_CAMERA_DATA_INDEX; dIndex++)
  {
    if(Data[dIndex] != -1)
    {
      memset(TxData, 0, sizeof(char) * MAX_COMM_DATA_LENGTH);
      memset(RxData, 0, sizeof(char) * MAX_COMM_DATA_LENGTH);

      CommDataLength = MakeCameraDataPacket(TxData, dIndex, bRead);
      if(!RequestCameraCommand(TxData, RxData, CommDataLength.SendDataLength, CommDataLength.ReceivedDataLength))
      {
        ShowMessage("[Error]IPB Communication");

        bBreakSW = true;
        bError = true;
      }

      if(RxData[0] == 'T' && RxData[1] == 'O')
    	{
        ShowMessage("[Error]Camera Timeout");
        
    		bBreakSW = true;
    		bError = true;
    	}

      if(bBreakSW)
        break;

      for(int m = 0; m < MAX_COMM_DATA_LENGTH; m++)
      {
        RxData[m] = RxData[m] & 0x000000FF; 
      }

      GetCameraValue(RxData, dIndex);

      // Read   н
      if(dIndex == ECAMERA_PARAM_2D_ROI_START_X) dIndex += 3;
      else if(dIndex == ECAMERA_PARAM_2D_DIGIT_GAIN1) dIndex += 1;
      //else if(dIndex == ECAMERA_PARAM_2D_WHITE_BALANCE_B) dIndex += 2;
    }
  }

  // Set Transmission Data
  if(!bError)
  {
    for(int dIndex = 0; dIndex < MAX_2D_CAMERA_DATA_INDEX; dIndex++)
    {
      if(dIndex == ECAMERA_PARAM_2D_BINNING_MODE ||
          dIndex == ECAMERA_PARAM_2D_SAMPLING_MODE ||
          dIndex == ECAMERA_PARAM_2D_DATA_TRANSFER_RATE ||
          dIndex == ECAMERA_PARAM_2D_ANALOG_GAIN ||
          dIndex == ECAMERA_PARAM_2D_IMAGE_FORMAT ||
          dIndex == ECAMERA_PARAM_2D_TRIGGER_MODE)
      {
        TTntComboBox *aComboBox = (TTntComboBox *) FindComponent("cmdNFACameraData" + IntToStr(dIndex + 1));

        if(aComboBox)
        {
          aComboBox->ItemIndex = Data[dIndex];
        }
      }
      else if(dIndex == ECAMERA_PARAM_2D_WHITE_BALANCE_B ||
              dIndex == ECAMERA_PARAM_2D_WHITE_BALANCE_G1 ||
              dIndex == ECAMERA_PARAM_2D_WHITE_BALANCE_G2 ||
              dIndex == ECAMERA_PARAM_2D_WHITE_BALANCE_R)
      {
        TCSpinEdit *aEdit1 = (TCSpinEdit *) FindComponent("cmdNFACameraData" + IntToStr(dIndex + 1));
        TCSpinEdit *aEdit2 = (TCSpinEdit *) FindComponent("cmdNFACameraData" + IntToStr(dIndex + 1) + "_2");

        if(aEdit1 && aEdit2)
        {
          aEdit1->Value = Data[dIndex] / 1000;
          aEdit2->Value = Data[dIndex] % 1000;
        }
      }
      else
      {
        TCSpinEdit *aEdit = (TCSpinEdit *) FindComponent("cmdNFACameraData" + IntToStr(dIndex + 1));

        if(aEdit)
        {
          aEdit->Value = Data[dIndex];
        }
      }
    }

    ShowMessage("Success to read");
  }
}
//---------------------------------------------------------------------------

TCommDataLength __fastcall TNFA2DCameraSettingForm::MakeCameraDataPacket(char *code, int dataIndex, bool bRead)
{
  /*********************************************************************************
    B1      B2      B3      B4      B5      B6      B7      ~Bn     Bn+1      Bn+2
    Header  Length          ID      Cmd             Data            Tail      Chk
  **********************************************************************************/
  TCommDataLength CommDataLength;

  int spbIndex;
  int camIndex;

  if(!bETCCamera)
  {
    spbIndex = CameraMapInfo[GlobalCameraIndex].SPBIndex;
    camIndex = CameraMapInfo[GlobalCameraIndex].CamIndex;
  }
  else
  {
    spbIndex = SelectedBoardID - 1;
    camIndex = SelectedCameraID - 1;
  }

  unsigned int pLength;
  unsigned char LCmd, HCmd; 

  const int HEADER_ST_PTR   = 0;
  const int LENGTH_ST_PTR   = 1;
  const int CAM_INFO_ST_PTR = 3;
  const int CMD_ST_PTR      = 4;
  const int DATA_ST_PTR     = 6;

  const int FIXED_PACKET_LENGTH  = 8;

  if(bRead)
  {
    // Read 忡 rs232 length ⺻ 1  
    // return cmd   length ٸ
    
    if(dataIndex == ECAMERA_PARAM_2D_BINNING_MODE)
    {
      CommDataLength.SendDataLength = 1;
      CommDataLength.ReceivedDataLength = 1;

      LCmd = CAMERA_DATA_CMD_BINNING_MODE_L;
      HCmd = CAMERA_DATA_CMD_BINNING_MODE_H;

      code[DATA_ST_PTR] = 0x00;
    }
    else if(dataIndex == ECAMERA_PARAM_2D_SAMPLING_MODE)
    {
      CommDataLength.SendDataLength = 1;
      CommDataLength.ReceivedDataLength = 1;

      LCmd = CAMERA_DATA_CMD_SUBSAMPLING_MODE_L;
      HCmd = CAMERA_DATA_CMD_SUBSAMPLING_MODE_H;

      code[DATA_ST_PTR] = 0x00;
    }
    else if(dataIndex == ECAMERA_PARAM_2D_ROI_START_X ||
            dataIndex == ECAMERA_PARAM_2D_ROI_END_X ||
            dataIndex == ECAMERA_PARAM_2D_ROI_START_Y ||
            dataIndex == ECAMERA_PARAM_2D_ROI_END_Y)
    {
      CommDataLength.SendDataLength = 1;
      CommDataLength.ReceivedDataLength = 7; 

      LCmd = CAMERA_DATA_CMD_ROI_L;
      HCmd = CAMERA_DATA_CMD_ROI_H;
 
      code[DATA_ST_PTR] = 0x00;
    }
    else if(dataIndex == ECAMERA_PARAM_2D_SHUTTER_TIME)
    {
      // Ȯʿ!!
      CommDataLength.SendDataLength = 1;
      CommDataLength.ReceivedDataLength = 2;

      LCmd = CAMERA_DATA_CMD_SHUTTER_L;
      HCmd = CAMERA_DATA_CMD_SHUTTER_H;

      code[DATA_ST_PTR] = 0x00;
    }
    else if(dataIndex == ECAMERA_PARAM_2D_ANALOG_GAIN)
    {
      CommDataLength.SendDataLength = 1;
      CommDataLength.ReceivedDataLength = 1;

      LCmd = CAMERA_DATA_CMD_A_GAIN_L;
      HCmd = CAMERA_DATA_CMD_A_GAIN_H;

      code[DATA_ST_PTR] = 0x00;
    }
    else if(dataIndex == ECAMERA_PARAM_2D_DIGIT_GAIN1 ||
            dataIndex == ECAMERA_PARAM_2D_DIGIT_GAIN2)
    {
      CommDataLength.SendDataLength = 1;
      CommDataLength.ReceivedDataLength = 2;

      LCmd = CAMERA_DATA_CMD_D_GAIN_L;
      HCmd = CAMERA_DATA_CMD_D_GAIN_H;

      code[DATA_ST_PTR] = 0x00;
    }
    else if(dataIndex == ECAMERA_PARAM_2D_WHITE_BALANCE_R)
    {
      CommDataLength.SendDataLength = 1;
      CommDataLength.ReceivedDataLength = 3;

      LCmd = CAMERA_DATA_CMD_WB_L;
      HCmd = CAMERA_DATA_CMD_WB_H;

      code[DATA_ST_PTR] = 0x00;
    }
    else if(dataIndex == ECAMERA_PARAM_2D_WHITE_BALANCE_G1)
    {
      CommDataLength.SendDataLength = 1;
      CommDataLength.ReceivedDataLength = 3;

      LCmd = CAMERA_DATA_CMD_WB_L;
      HCmd = CAMERA_DATA_CMD_WB_H;

      code[DATA_ST_PTR] = 0x01;
    }
    else if(dataIndex == ECAMERA_PARAM_2D_WHITE_BALANCE_G2)
    {
      CommDataLength.SendDataLength = 1;
      CommDataLength.ReceivedDataLength = 3;

      LCmd = CAMERA_DATA_CMD_WB_L;
      HCmd = CAMERA_DATA_CMD_WB_H;

      code[DATA_ST_PTR] = 0x02;
    }
    else if(dataIndex == ECAMERA_PARAM_2D_WHITE_BALANCE_B)
    {
      CommDataLength.SendDataLength = 1;
      CommDataLength.ReceivedDataLength = 3;

      LCmd = CAMERA_DATA_CMD_WB_L;
      HCmd = CAMERA_DATA_CMD_WB_H;

      code[DATA_ST_PTR] = 0x03;
    }
    else if(dataIndex == ECAMERA_PARAM_2D_DATA_TRANSFER_RATE)
    {
      CommDataLength.SendDataLength = 1;
      CommDataLength.ReceivedDataLength = 1;

      LCmd = CAMERA_DATA_CMD_TR_L;
      HCmd = CAMERA_DATA_CMD_TR_H;

      code[DATA_ST_PTR] = 0x00;
    }
    else if(dataIndex == ECAMERA_PARAM_2D_IMAGE_FORMAT)
    {
      CommDataLength.SendDataLength = 1;
      CommDataLength.ReceivedDataLength = 1;

      LCmd = CAMERA_DATA_CMD_IMG_FORMAT_L;
      HCmd = CAMERA_DATA_CMD_IMG_FORMAT_H;

      code[DATA_ST_PTR] = 0x00;
    }
    else if(dataIndex == ECAMERA_PARAM_2D_TRIGGER_MODE)
    {
      CommDataLength.SendDataLength = 1;
      CommDataLength.ReceivedDataLength = 1;

      LCmd = CAMERA_DATA_CMD_TRIGGER_MODE_L;
      HCmd = CAMERA_DATA_CMD_TRIGGER_MODE_H;

      code[DATA_ST_PTR] = 0x00;
    }

    code[HEADER_ST_PTR] = CAMERA_DATA_HEADER;
    
    code[LENGTH_ST_PTR + 0] = (0x00FF & CommDataLength.SendDataLength);
    code[LENGTH_ST_PTR + 1] = (0xFF00 & CommDataLength.SendDataLength) >> 8;

    code[CMD_ST_PTR + 0] = LCmd;
    code[CMD_ST_PTR + 1] = HCmd + 0x01;

    code[CAM_INFO_ST_PTR + 0] = (camIndex + 1) << 4;

    code[DATA_ST_PTR + CommDataLength.SendDataLength + 0] = 0xAE; // Tail
    code[DATA_ST_PTR + CommDataLength.SendDataLength + 1] = 0x00; // CheckSum
  }
  else
  {
    if(dataIndex == ECAMERA_PARAM_2D_BINNING_MODE)
    {
      CommDataLength.SendDataLength = 1;
      CommDataLength.ReceivedDataLength = 1;

      LCmd = CAMERA_DATA_CMD_BINNING_MODE_L;
      HCmd = CAMERA_DATA_CMD_BINNING_MODE_H;

      code[DATA_ST_PTR] = TxValueInterpreter(dataIndex);
    }
    else if(dataIndex == ECAMERA_PARAM_2D_SAMPLING_MODE)
    {
      CommDataLength.SendDataLength = 1;
      CommDataLength.ReceivedDataLength = 1;

      LCmd = CAMERA_DATA_CMD_SUBSAMPLING_MODE_L;
      HCmd = CAMERA_DATA_CMD_SUBSAMPLING_MODE_H;

      code[DATA_ST_PTR] = TxValueInterpreter(dataIndex);
    }
    else if(dataIndex == ECAMERA_PARAM_2D_ROI_START_X ||
            dataIndex == ECAMERA_PARAM_2D_ROI_END_X ||
            dataIndex == ECAMERA_PARAM_2D_ROI_START_Y ||
            dataIndex == ECAMERA_PARAM_2D_ROI_END_Y)
    {
      CommDataLength.SendDataLength = 7;
      CommDataLength.ReceivedDataLength = 1;

      LCmd = CAMERA_DATA_CMD_ROI_L;
      HCmd = CAMERA_DATA_CMD_ROI_H;
 
      code[DATA_ST_PTR + 0] = 0x00; // CH
      code[DATA_ST_PTR + 1] = Data[dataIndex + 0];
      code[DATA_ST_PTR + 2] = Data[dataIndex + 1];
      code[DATA_ST_PTR + 3] = (0x00FF & Data[dataIndex + 2]);
      code[DATA_ST_PTR + 4] = (0xFF00 & Data[dataIndex + 2]) >> 8;
      code[DATA_ST_PTR + 5] = (0x00FF & Data[dataIndex + 3]);
      code[DATA_ST_PTR + 6] = (0xFF00 & Data[dataIndex + 3]) >> 8;
    }
    else if(dataIndex == ECAMERA_PARAM_2D_SHUTTER_TIME)
    {
      // Ȯʿ!!
      CommDataLength.SendDataLength = 2;
      CommDataLength.ReceivedDataLength = 1;

      LCmd = CAMERA_DATA_CMD_SHUTTER_L;
      HCmd = CAMERA_DATA_CMD_SHUTTER_H;

      code[DATA_ST_PTR + 0] = Data[dataIndex];
      code[DATA_ST_PTR + 1] = Data[dataIndex];
    }
    else if(dataIndex == ECAMERA_PARAM_2D_ANALOG_GAIN)
    {
      CommDataLength.SendDataLength = 1;
      CommDataLength.ReceivedDataLength = 1;

      LCmd = CAMERA_DATA_CMD_A_GAIN_L;
      HCmd = CAMERA_DATA_CMD_A_GAIN_H;

      code[DATA_ST_PTR] = Data[dataIndex + 0] + 1;
    }
    else if(dataIndex == ECAMERA_PARAM_2D_DIGIT_GAIN1 ||
            dataIndex == ECAMERA_PARAM_2D_DIGIT_GAIN2)
    {
      CommDataLength.SendDataLength = 2;
      CommDataLength.ReceivedDataLength = 1;

      LCmd = CAMERA_DATA_CMD_D_GAIN_L;
      HCmd = CAMERA_DATA_CMD_D_GAIN_H;

      code[DATA_ST_PTR + 0] = Data[dataIndex + 0];
      code[DATA_ST_PTR + 1] = Data[dataIndex + 1];
    }
    else if(dataIndex == ECAMERA_PARAM_2D_WHITE_BALANCE_B)
    {
      CommDataLength.SendDataLength = 3;
      CommDataLength.ReceivedDataLength = 1;

      LCmd = CAMERA_DATA_CMD_WB_L;
      HCmd = CAMERA_DATA_CMD_WB_H;

      code[DATA_ST_PTR + 0] = 0x03;
      code[DATA_ST_PTR + 1] = Data[dataIndex + 0] / 1000;
      code[DATA_ST_PTR + 2] = Data[dataIndex + 0] % 1000;
    }
    else if(dataIndex == ECAMERA_PARAM_2D_WHITE_BALANCE_G2)
    {
      CommDataLength.SendDataLength = 3;
      CommDataLength.ReceivedDataLength = 1;

      LCmd = CAMERA_DATA_CMD_WB_L;
      HCmd = CAMERA_DATA_CMD_WB_H;

      code[DATA_ST_PTR + 0] = 0x02;
      code[DATA_ST_PTR + 1] = Data[dataIndex + 0] / 1000;
      code[DATA_ST_PTR + 2] = Data[dataIndex + 0] % 1000;
    }
    else if(dataIndex == ECAMERA_PARAM_2D_WHITE_BALANCE_G1)
    {
      CommDataLength.SendDataLength = 3;
      CommDataLength.ReceivedDataLength = 1;

      LCmd = CAMERA_DATA_CMD_WB_L;
      HCmd = CAMERA_DATA_CMD_WB_H;

      code[DATA_ST_PTR + 0] = 0x01;
      code[DATA_ST_PTR + 1] = Data[dataIndex + 0] / 1000;
      code[DATA_ST_PTR + 2] = Data[dataIndex + 0] % 1000;
    }
    else if(dataIndex == ECAMERA_PARAM_2D_WHITE_BALANCE_R)
    {
      CommDataLength.SendDataLength = 3;
      CommDataLength.ReceivedDataLength = 1;

      LCmd = CAMERA_DATA_CMD_WB_L;
      HCmd = CAMERA_DATA_CMD_WB_H;

      code[DATA_ST_PTR + 0] = 0x00;
      code[DATA_ST_PTR + 1] = Data[dataIndex + 0] / 1000;
      code[DATA_ST_PTR + 2] = Data[dataIndex + 0] % 1000;
    }
    else if(dataIndex == ECAMERA_PARAM_2D_DATA_TRANSFER_RATE)
    {
      CommDataLength.SendDataLength = 1;
      CommDataLength.ReceivedDataLength = 1;

      LCmd = CAMERA_DATA_CMD_TR_L;
      HCmd = CAMERA_DATA_CMD_TR_H;

      code[DATA_ST_PTR] = TxValueInterpreter(dataIndex);
    }
    else if(dataIndex == ECAMERA_PARAM_2D_IMAGE_FORMAT)
    {
      CommDataLength.SendDataLength = 1;
      CommDataLength.ReceivedDataLength = 1;

      LCmd = CAMERA_DATA_CMD_IMG_FORMAT_L;
      HCmd = CAMERA_DATA_CMD_IMG_FORMAT_H;

      code[DATA_ST_PTR] = TxValueInterpreter(dataIndex);
    }
    else if(dataIndex == ECAMERA_PARAM_2D_TRIGGER_MODE)
    {
      CommDataLength.SendDataLength = 1;
      CommDataLength.ReceivedDataLength = 1;

      LCmd = CAMERA_DATA_CMD_TRIGGER_MODE_L;
      HCmd = CAMERA_DATA_CMD_TRIGGER_MODE_H;

      code[DATA_ST_PTR] = TxValueInterpreter(dataIndex);
    }

    code[HEADER_ST_PTR] = CAMERA_DATA_HEADER;

    code[LENGTH_ST_PTR + 0] = (0x00FF & CommDataLength.SendDataLength);
    code[LENGTH_ST_PTR + 1] = (0xFF00 & CommDataLength.SendDataLength) >> 8;

    code[CMD_ST_PTR + 0] = LCmd;
    code[CMD_ST_PTR + 1] = HCmd;

    code[CAM_INFO_ST_PTR + 0] = ((camIndex + 1) << 4) & 0xF0;

    code[DATA_ST_PTR + CommDataLength.SendDataLength + 0] = 0xAE; // Tail
    code[DATA_ST_PTR + CommDataLength.SendDataLength + 1] = 0x00; // CheckSum
  }

  CommDataLength.SendDataLength += FIXED_PACKET_LENGTH;
  CommDataLength.ReceivedDataLength += FIXED_PACKET_LENGTH;

  return CommDataLength; 
}

//---------------------------------------------------------------------------
unsigned char __fastcall TNFA2DCameraSettingForm::TxValueInterpreter(int dIndex)
{
  unsigned char rValue = 0x00;

  if(dIndex == ECAMERA_PARAM_2D_BINNING_MODE)
  {
    rValue = Data[dIndex];
  }
  else if(dIndex == ECAMERA_PARAM_2D_SAMPLING_MODE)
  {
    rValue = Data[dIndex];
  }
  else if(dIndex == ECAMERA_PARAM_2D_ANALOG_GAIN)
  {
    // Ȯ.. ߰ Ȯʿ
    /*
    if(Data[dIndex] == 0)
      rValue = 0xA0;
    else if(Data[dIndex] == 1)
      rValue = 0xA0;
    else if(Data[dIndex] == 2)
      rValue = 0xA0;
    else if(Data[dIndex] == 3)
      rValue = 0xA0;
    */
    rValue = Data[dIndex];
  }
  else if(dIndex == ECAMERA_PARAM_2D_DATA_TRANSFER_RATE)
  {
    if(Data[dIndex] == 0)
      rValue = 0x00;
    else
      rValue = 0x01;    // LDH
  }
  else if(dIndex == ECAMERA_PARAM_2D_IMAGE_FORMAT)
  {
    rValue = Data[dIndex];
  }
  else if(dIndex == ECAMERA_PARAM_2D_TRIGGER_MODE)
  {
    rValue = Data[dIndex];
  }

  return rValue;
}
//---------------------------------------------------------------------------

int __fastcall TNFA2DCameraSettingForm::RxValueInterpreter(char data, int dIndex)
{
  int rValue = 0;

  if(dIndex == ECAMERA_PARAM_2D_BINNING_MODE)
  {
    rValue = data;
  }
  else if(dIndex == ECAMERA_PARAM_2D_SAMPLING_MODE)
  {
    rValue = data;
  }
  else if(dIndex == ECAMERA_PARAM_2D_ANALOG_GAIN)
  {
    // Ȯ..
    if(data == 0xA0)
      rValue = 0;
    else if(data == 0xA0)
      rValue = 1;
    else if(data == 0xA0)
      rValue = 2;
    else if(data == 0xA0)
      rValue = 3;
  }
  else if(dIndex == ECAMERA_PARAM_2D_DATA_TRANSFER_RATE)
  {
    if(data == 0x00)
      rValue = 0;
    else
      rValue = 1;
  }
  else if(dIndex == ECAMERA_PARAM_2D_IMAGE_FORMAT)
  {
    rValue = data;
  }
  else if(dIndex == ECAMERA_PARAM_2D_TRIGGER_MODE)
  {
    rValue = data;
  }

  return rValue;
}

//---------------------------------------------------------------------------
void __fastcall TNFA2DCameraSettingForm::GetCameraValue(char *buff, int dataIndex)
{
  const int DATA_ST_PTR = 6;
  
  if(dataIndex == ECAMERA_PARAM_2D_BINNING_MODE)
  {
    Data[dataIndex + 0] = RxValueInterpreter(buff[DATA_ST_PTR], dataIndex);
  }
  else if(dataIndex == ECAMERA_PARAM_2D_SAMPLING_MODE)
  {
    Data[dataIndex + 0] = RxValueInterpreter(buff[DATA_ST_PTR], dataIndex);
  }
  else if(dataIndex == ECAMERA_PARAM_2D_ROI_START_X ||
          dataIndex == ECAMERA_PARAM_2D_ROI_END_X ||
          dataIndex == ECAMERA_PARAM_2D_ROI_START_Y ||
          dataIndex == ECAMERA_PARAM_2D_ROI_END_Y)
  {
    Data[dataIndex + 0] = (buff[DATA_ST_PTR + 1] & 0x000000FF);
    Data[dataIndex + 1] = (buff[DATA_ST_PTR + 2] & 0x000000FF);
    Data[dataIndex + 2] = (buff[DATA_ST_PTR + 3] & 0x000000FF) | ((buff[DATA_ST_PTR + 4] & 0x000000FF) << 8);
    Data[dataIndex + 3] = (buff[DATA_ST_PTR + 5] & 0x000000FF) | ((buff[DATA_ST_PTR + 6] & 0x000000FF) << 8);
  }
  else if(dataIndex == ECAMERA_PARAM_2D_SHUTTER_TIME)
  {
    //check
    Data[dataIndex] = (buff[DATA_ST_PTR] & 0x000000FF);
  }
  else if(dataIndex == ECAMERA_PARAM_2D_ANALOG_GAIN)
  {
    Data[dataIndex + 0] = buff[DATA_ST_PTR] - 1; //RxValueInterpreter(buff[DATA_ST_PTR], dataIndex);
  }
  else if(dataIndex == ECAMERA_PARAM_2D_DIGIT_GAIN1 ||
          dataIndex == ECAMERA_PARAM_2D_DIGIT_GAIN2)
  {
    Data[dataIndex + 0] = (buff[DATA_ST_PTR + 0] & 0x000000FF);
    Data[dataIndex + 1] = (buff[DATA_ST_PTR + 1] & 0x000000FF);
  }
  else if(dataIndex == ECAMERA_PARAM_2D_WHITE_BALANCE_B ||
          dataIndex == ECAMERA_PARAM_2D_WHITE_BALANCE_G1 ||
          dataIndex == ECAMERA_PARAM_2D_WHITE_BALANCE_G2 ||
          dataIndex == ECAMERA_PARAM_2D_WHITE_BALANCE_R)
  {
    Data[dataIndex + 0] = (buff[DATA_ST_PTR + 1] & 0x000000FF) * 1000 + (buff[DATA_ST_PTR + 2] & 0x000000FF);

    //code[DATA_ST_PTR + 1] = ((Data[dataIndex + 0] & 0x3FF) >> 7);
    //code[DATA_ST_PTR + 2] = (Data[dataIndex + 0] & 0x07F);
  }
  else if(dataIndex == ECAMERA_PARAM_2D_DATA_TRANSFER_RATE)
  {
    Data[dataIndex + 0] = RxValueInterpreter(buff[DATA_ST_PTR], dataIndex);
  }
  else if(dataIndex == ECAMERA_PARAM_2D_IMAGE_FORMAT)
  {
    Data[dataIndex + 0] = RxValueInterpreter(buff[DATA_ST_PTR], dataIndex);
  }
  else if(dataIndex == ECAMERA_PARAM_2D_TRIGGER_MODE)
  {
    Data[dataIndex + 0] = RxValueInterpreter(buff[DATA_ST_PTR], dataIndex);
  }
}
//---------------------------------------------------------------------------
void __fastcall TNFA2DCameraSettingForm::SendPacketLengthEditChange(
      TObject *Sender)
{
  try
  {
    if(UserSelect)
    {
      int SendPacketLength = StrToInt(SendPacketLengthEdit->Text);
      int DataLength = SendPacketLength - 8; // 8  Packet ũ

      if(DataLength > 0 && SendPacketLength <= 20)
      {
        SendPacketStringGrid->RowCount = SendPacketLength;

        SetDefaultPacket(SendPacketLength, true, false, NULL);

        None1->Down = true;
        None2->Down = true;
      }
    }
  }
  catch(...)
  {

  }
}
//---------------------------------------------------------------------------

void __fastcall TNFA2DCameraSettingForm::SetDefaultPacket(int PacketLength, bool bSend, int existDataSW, char *existedData)
{
  if(bSend)
  {
    for(int dIndex = 0; dIndex < PacketLength; dIndex++)
    {
      SendPacketStringGrid->Cells[0][dIndex] = "B" + IntToStr(dIndex + 1);
      SendPacketStringGrid->Cells[1][dIndex] = "";
    }

    int spbIndex;
    int camIndex;

    if(!bETCCamera)
    {
      spbIndex = CameraMapInfo[GlobalCameraIndex].SPBIndex;
      camIndex = CameraMapInfo[GlobalCameraIndex].CamIndex;
    }
    else
    {
      spbIndex = SelectedBoardID - 1;
      camIndex = SelectedCameraID - 1;
    }

    const int HEADER_ST_PTR   = 0;
    const int LENGTH_ST_PTR   = 1;
    const int CAM_INFO_ST_PTR = 3;
    const int CMD_ST_PTR      = 4;
    const int DATA_ST_PTR     = 6;

    const int FIXED_PACKET_LENGTH  = 8;
    int dataLength = PacketLength - FIXED_PACKET_LENGTH;

    char buf;
    AnsiString HexValue;

    if(!existDataSW)
    {
      SendPacketStringGrid->Cells[1][0] = "A1";

      buf = (0x00FF & dataLength);
      HexValue = IntToHex(buf & 0x000000FF, 2);
      SendPacketStringGrid->Cells[1][1] = HexValue;

      buf = (0xFF00 & dataLength) >> 8;
      HexValue = IntToHex(buf & 0x000000FF, 2);
      SendPacketStringGrid->Cells[1][2] = HexValue;

      buf = ((camIndex + 1) << 4) & 0xF0;
      HexValue = IntToHex(buf & 0x000000FF, 2);
      SendPacketStringGrid->Cells[1][CAM_INFO_ST_PTR + 0] = HexValue;

      SendPacketStringGrid->Cells[1][DATA_ST_PTR + dataLength + 0] = "AE";
      SendPacketStringGrid->Cells[1][DATA_ST_PTR + dataLength + 1] = "00";

      SendPacketStringGrid->Cells[1][4] = "6c";
      SendPacketStringGrid->Cells[1][5] = "08";
      SendPacketStringGrid->Cells[1][6] = "00";
    }
    else
    {
      for(int dIndex = 0; dIndex < PacketLength; dIndex++)
      {
        HexValue = IntToHex(existedData[dIndex] & 0x000000FF, 2);
        SendPacketStringGrid->Cells[1][dIndex] = HexValue;
      }
    }
  }
  else
  {
    for(int dIndex = 0; dIndex < PacketLength; dIndex++)
    {
      ReceivePacketStringGrid->Cells[0][dIndex] = "B" + IntToStr(dIndex + 1);
      ReceivePacketStringGrid->Cells[1][dIndex] = "";
    }
  }
}
//---------------------------------------------------------------------------
void __fastcall TNFA2DCameraSettingForm::ReceivePacketLengthEditChange(
      TObject *Sender)
{
  try
  {
    if(UserSelect)
    {
      int ReceivePacketLength = StrToInt(ReceivePacketLengthEdit->Text);
      int DataLength = ReceivePacketLength - 8; // 8  Packet ũ

      if(DataLength > 0 && ReceivePacketLength <= 20)
      {
        ReceivePacketStringGrid->RowCount = ReceivePacketLength;

        SetDefaultPacket(ReceivePacketLength, false, false, NULL);

        None1->Down = true;
        None2->Down = true;
      }
    }
  }
  catch(...)
  {

  }
}
//---------------------------------------------------------------------------

void __fastcall TNFA2DCameraSettingForm::SendPacketLengthEditClick(
      TObject *Sender)
{
  TTntEdit *theEdit = (TTntEdit *) Sender;
	KeyboardForm->Text = theEdit->Text;
  if (KeyboardForm->ShowKeypad() == mrOk)
  {
    char tempBuff[10];
    AnsiString tempString = KeyboardForm->Text;

    if(KeyboardForm->Text.Length() < 0 || KeyboardForm->Text.Length() > 2)
    {
      ShowMessage(ErrorMsg[0]);
      return;
    }

    bool bErrorSW = false;
    strcpy(tempBuff, tempString.c_str());
    for(int k = 0; k < KeyboardForm->Text.Length(); k++)
    {
      if(tempBuff[k] != '0' &&
          tempBuff[k] != '1' &&
          tempBuff[k] != '2' &&
          tempBuff[k] != '3' &&
          tempBuff[k] != '4' &&
          tempBuff[k] != '5' &&
          tempBuff[k] != '6' &&
          tempBuff[k] != '7' &&
          tempBuff[k] != '8' &&
          tempBuff[k] != '9')
      {
        bErrorSW = true;
        break;
      }
    }

    if(bErrorSW)
    {
      ShowMessage(ErrorMsg[0]);
      return;
    }

    UserSelect = true;

		theEdit->Text = tempString;
	}
}
//---------------------------------------------------------------------------

void __fastcall TNFA2DCameraSettingForm::ReceivePacketLengthEditClick(
      TObject *Sender)
{
  TTntEdit *theEdit = (TTntEdit *) Sender;
	KeyboardForm->Text = theEdit->Text;
  if (KeyboardForm->ShowKeypad() == mrOk)
  {
    char tempBuff[10];
    AnsiString tempString = KeyboardForm->Text;

    if(KeyboardForm->Text.Length() < 0 || KeyboardForm->Text.Length() > 2)
    {
      ShowMessage(ErrorMsg[0]);
      return;
    }

    bool bErrorSW = false;
    strcpy(tempBuff, tempString.c_str());
    for(int k = 0; k < KeyboardForm->Text.Length(); k++)
    {
      if(tempBuff[k] != '0' &&
          tempBuff[k] != '1' &&
          tempBuff[k] != '2' &&
          tempBuff[k] != '3' &&
          tempBuff[k] != '4' &&
          tempBuff[k] != '5' &&
          tempBuff[k] != '6' &&
          tempBuff[k] != '7' &&
          tempBuff[k] != '8' &&
          tempBuff[k] != '9')
      {
        bErrorSW = true;
        break;
      }
    }

    if(bErrorSW)
    {
      ShowMessage(ErrorMsg[0]);
      return;
    }

    UserSelect = true;
    
		theEdit->Text = tempString;
	}
}
//---------------------------------------------------------------------------

void __fastcall TNFA2DCameraSettingForm::SendPacketStringGridSelectCell(
      TObject *Sender, int ACol, int ARow, bool &CanSelect)
{
  KeyboardForm->Text = SendPacketStringGrid->Cells[ACol][ARow];
  if (KeyboardForm->ShowKeyboard() == mrOk)
  {
    char tempBuff[10];
    AnsiString tempString = KeyboardForm->Text;

    if(KeyboardForm->Text.Length() < 0 || KeyboardForm->Text.Length() > 2)
    {
      ShowMessage(ErrorMsg[0]);
      return;
    }

    bool bErrorSW = false;
    strcpy(tempBuff, tempString.c_str());
    for(int k = 0; k < KeyboardForm->Text.Length(); k++)
    {
      if(tempBuff[k] != '0' &&
          tempBuff[k] != '1' &&
          tempBuff[k] != '2' &&
          tempBuff[k] != '3' &&
          tempBuff[k] != '4' &&
          tempBuff[k] != '5' &&
          tempBuff[k] != '6' &&
          tempBuff[k] != '7' &&
          tempBuff[k] != '8' &&
          tempBuff[k] != '9' &&
          tempBuff[k] != 'A' &&
          tempBuff[k] != 'a' &&
          tempBuff[k] != 'B' &&
          tempBuff[k] != 'b' &&
          tempBuff[k] != 'C' &&
          tempBuff[k] != 'c' &&
          tempBuff[k] != 'D' &&
          tempBuff[k] != 'd' &&
          tempBuff[k] != 'E' &&
          tempBuff[k] != 'e' &&
          tempBuff[k] != 'F' &&
          tempBuff[k] != 'f')
      {
        bErrorSW = true;
        break;
      }
    }

    if(bErrorSW)
    {
      ShowMessage(ErrorMsg[0]);
      return;
    }

    SendPacketStringGrid->Cells[ACol][ARow] = tempString;
  }
}
//---------------------------------------------------------------------------

void __fastcall TNFA2DCameraSettingForm::SendTestPacketBtnClick(
      TObject *Sender)
{
  WriteAllButton->Enabled = false;
  ReadAllButton->Enabled = false;
  SendTestPacketBtn->Enabled = false;
  try
  {
    bool bError;
    const int MAX_COMM_DATA_LENGTH = 20;
    char TxData[MAX_COMM_DATA_LENGTH];
    char RxData[MAX_COMM_DATA_LENGTH];

    int SendPacketLength = StrToInt(SendPacketLengthEdit->Text);
    int ReceivePacketLength = StrToInt(ReceivePacketLengthEdit->Text);
    int SendDataLength = SendPacketLength - 8;
    int ReceiveDataLnegth = ReceivePacketLength - 8;
    
    if(SendDataLength > 0 && SendPacketLength <= 20 && ReceiveDataLnegth > 0 && ReceivePacketLength <= 20)
    {
      memset(TxData, 0, sizeof(char) * MAX_COMM_DATA_LENGTH);
      memset(RxData, 0, sizeof(char) * MAX_COMM_DATA_LENGTH);

      AnsiString tempData;
      for(int dataIndex = 0; dataIndex < SendPacketLength; dataIndex++)
      {
        if(SendPacketStringGrid->Cells[1][dataIndex] != "")
        {
          tempData = SendPacketStringGrid->Cells[1][dataIndex];
          TxData[dataIndex] = StrToHex(tempData);
        }
        else
        {
          throw Exception("");
        }
      }

      if(!RequestCameraCommand(TxData, RxData, SendPacketLength, ReceivePacketLength))
      {
        ShowMessage("SPB Communication Error");
      }

      if(RxData[0] == 'T' && RxData[1] == 'O')
      {
        ShowMessage("Camera Timeout");
      }
      else
      {
        for(int dataIndex = 0; dataIndex < ReceivePacketLength; dataIndex++)
        {
          char buf;
          AnsiString HexValue;
          buf = RxData[dataIndex];
          HexValue = IntToHex(buf & 0x000000FF, 2);

          ReceivePacketStringGrid->Cells[1][dataIndex] = HexValue;
        }
      }
    }
    else
    {
      ShowMessage("Length Error!");
    }
  }
  catch(...)
  {
    ShowMessage(ErrorMsg[0]);
  }

  SendTestPacketBtn->Enabled = true;
  WriteAllButton->Enabled = true;
  ReadAllButton->Enabled = true;
}
//---------------------------------------------------------------------------

char __fastcall TNFA2DCameraSettingForm::StrToHex(AnsiString aValue)
{
  AnsiString HexFormat = "0x" + aValue;
  return StrToInt(HexFormat);
}

//---------------------------------------------------------------------------
void __fastcall TNFA2DCameraSettingForm::SendPacketLengthEditKeyPress(
      TObject *Sender, char &Key)
{
  Key = NULL;
}
//---------------------------------------------------------------------------

void __fastcall TNFA2DCameraSettingForm::ReceivePacketLengthEditKeyPress(
      TObject *Sender, char &Key)
{
  Key = NULL;
}
//---------------------------------------------------------------------------

void __fastcall TNFA2DCameraSettingForm::Label2DblClick(TObject *Sender)
{
  if(this->Height != 1419)
    this->Height = 1419;
  else
    this->Height = 898;

  this->Position = poMainFormCenter;
}
//---------------------------------------------------------------------------

void __fastcall TNFA2DCameraSettingForm::BitBtn1Click(TObject *Sender)
{
  /*
  TSpeedButton *ReadOrWriteBtn;
  bool bRead;
  for(int k = 1; k <= 2; k++)
  {
    ReadOrWriteBtn = (TSpeedButton *) FindComponent("ReadOrWriteBtn" + IntToStr(k));

    if(ReadOrWriteBtn)
    {
      if(ReadOrWriteBtn->Down)
      {
        bRead = !(k - 1);
        break;
      }
    }
  }

  TSpeedButton *DataIndexBtn;
  int dIndex;
  for(int k = 1; k <= 12; k++)
  {
    DataIndexBtn = (TSpeedButton *) FindComponent("DataIndexBtn" + IntToStr(k));

    if(DataIndexBtn)
    {
      if(DataIndexBtn->Down)
      {
        dIndex = DataIndexBtn->Tag;
        break;
      }
    }
  }

  const int MAX_COMM_DATA_LENGTH = 20;
  char TxData[MAX_COMM_DATA_LENGTH];
  TCommDataLength CommDataLength;

  memset(Data, 0, sizeof(int) * MAX_2D_CAMERA_DATA_INDEX);
  memset(TxData, 0, sizeof(char) * MAX_COMM_DATA_LENGTH);

  CommDataLength = MakeCameraDataPacket(TxData, GlobalCameraIndex, dIndex, bRead);

  SendPacketStringGrid->RowCount = CommDataLength.SendDataLength;
  SetDefaultPacket(CommDataLength.SendDataLength, true, true, TxData);

  ReceivePacketStringGrid->RowCount = CommDataLength.ReceivedDataLength;
  SetDefaultPacket(CommDataLength.ReceivedDataLength, false, false, NULL);

  UserSelect = false;

  SendPacketLengthEdit->Text = IntToStr(CommDataLength.SendDataLength);
  ReceivePacketLengthEdit->Text = IntToStr(CommDataLength.ReceivedDataLength);
  */
}
//---------------------------------------------------------------------------

void __fastcall TNFA2DCameraSettingForm::ReadOrWriteBtn1Click(
      TObject *Sender)
{
  if(None1->Down || None2->Down)
    return;

  TSpeedButton *ReadOrWriteBtn;
  bool bRead;
  for(int k = 1; k <= 2; k++)
  {
    ReadOrWriteBtn = (TSpeedButton *) FindComponent("ReadOrWriteBtn" + IntToStr(k));

    if(ReadOrWriteBtn)
    {
      if(ReadOrWriteBtn->Down)
      {
        bRead = !(k - 1);
        break;
      }
    }
  }

  TSpeedButton *DataIndexBtn;
  int dIndex;
  for(int k = 1; k <= 13; k++)
  {
    DataIndexBtn = (TSpeedButton *) FindComponent("DataIndexBtn" + IntToStr(k));

    if(DataIndexBtn)
    {
      if(DataIndexBtn->Down)
      {
        dIndex = DataIndexBtn->Tag;
        break;
      }
    }
  }

  const int MAX_COMM_DATA_LENGTH = 20;
  char TxData[MAX_COMM_DATA_LENGTH];
  TCommDataLength CommDataLength;

  memset(Data, 0, sizeof(int) * MAX_2D_CAMERA_DATA_INDEX);
  memset(TxData, 0, sizeof(char) * MAX_COMM_DATA_LENGTH);

  CommDataLength = MakeCameraDataPacket(TxData, dIndex, bRead);

  SendPacketStringGrid->RowCount = CommDataLength.SendDataLength;
  SetDefaultPacket(CommDataLength.SendDataLength, true, true, TxData);

  ReceivePacketStringGrid->RowCount = CommDataLength.ReceivedDataLength;
  SetDefaultPacket(CommDataLength.ReceivedDataLength, false, false, NULL);

  UserSelect = false;

  SendPacketLengthEdit->Text = IntToStr(CommDataLength.SendDataLength);
  ReceivePacketLengthEdit->Text = IntToStr(CommDataLength.ReceivedDataLength);  
}
//---------------------------------------------------------------------------

void __fastcall TNFA2DCameraSettingForm::SaveToFlashBtnClick(
      TObject *Sender)
{
  const int MAX_COMM_DATA_LENGTH = 20;
  char TxData[MAX_COMM_DATA_LENGTH];
  char RxData[MAX_COMM_DATA_LENGTH];
  bool bRead = true;
  bool bError = false;
  TCommDataLength CommDataLength;

  int spbIndex;
  int camIndex;

  if(!bETCCamera)
  {
    spbIndex = CameraMapInfo[GlobalCameraIndex].SPBIndex;
    camIndex = CameraMapInfo[GlobalCameraIndex].CamIndex;
  }
  else
  {
    spbIndex = SelectedBoardID - 1;
    camIndex = SelectedCameraID - 1;
  }

  memset(TxData, 0, sizeof(char) * MAX_COMM_DATA_LENGTH);
  memset(RxData, 0, sizeof(char) * MAX_COMM_DATA_LENGTH);

  CommDataLength.SendDataLength = 9;
  CommDataLength.ReceivedDataLength = 9; 

  TxData[0] = 0xA1;
  TxData[1] = 0x01;
  TxData[2] = 0x00;
  TxData[3] = ((camIndex + 1) << 4) & 0xF0;
  TxData[4] = CAMERA_DATA_FLASH_WRITE_L;
  TxData[5] = CAMERA_DATA_FLASH_WRITE_H;
  TxData[6] = 0x01;
  TxData[7] = 0xAE;
  TxData[8] = 0x00;

  if(!RequestCameraCommand(TxData, RxData, CommDataLength.SendDataLength, CommDataLength.ReceivedDataLength))
  {
    ShowMessage("[Error]IPB Communication");

    bError = true;
  }

  if(RxData[0] == 'T' && RxData[1] == 'O')
  {
    ShowMessage("[Error]Camera Timeout");

    bError = true;
  }

  if(!bError)
  {
    ShowMessage("Success to write");
  }
}
//---------------------------------------------------------------------------

