//---------------------------------------------------------------------------

#ifndef OffSetImageExtract_FormH
#define OffSetImageExtract_FormH
//---------------------------------------------------------------------------
#include <Classes.hpp>
#include <Controls.hpp>
#include <StdCtrls.hpp>
#include <Forms.hpp>
#include "TntExtCtrls.hpp"
#include "TntStdCtrls.hpp"
#include <ExtCtrls.hpp>
#include <Graphics.hpp>
#include <Buttons.hpp>
#include <Dialogs.hpp>
#include <ExtDlgs.hpp>
#include <ComCtrls.hpp>
#include <Grids.hpp>

#include "Common.h"
#include "Environment.h"

#define MAX_IMAGE_WIDTH 640
#define MAX_IMAGE_HEIGHT 480
//---------------------------------------------------------------------------
class TOffSetImageExtractForm : public TTntForm
{
__published:	// IDE-managed Components
  TPanel *TitlePanel;
  TPanel *Panel1;
  TPanel *Panel2;
  TTntImage *Image1;
  TTntImage *Image2;
  TTntImage *Image3;
  TTntImage *Image4;
  TTntImage *Image6;
  TTntImage *Image7;
  TTntImage *Image8;
  TTntImage *Image10;
  TTntImage *Image11;
  TTntImage *Image12;
  TTntImage *Image14;
  TTntImage *Image15;
  TTntImage *Image16;
  TTntImage *Image9;
  TTntLabel *CameraIndexLabel9;
  TTntLabel *CameraIndexLabel8;
  TTntLabel *CameraIndexLabel7;
  TTntLabel *CameraIndexLabel6;
  TTntLabel *CameraIndexLabel4;
  TTntLabel *CameraIndexLabel3;
  TTntLabel *CameraIndexLabel2;
  TTntLabel *CameraIndexLabel16;
  TTntLabel *CameraIndexLabel15;
  TTntLabel *CameraIndexLabel14;
  TTntLabel *CameraIndexLabel12;
  TTntLabel *CameraIndexLabel11;
  TTntLabel *CameraIndexLabel10;
  TTntLabel *CameraIndexLabel1;
  TTntButton *CloseButton;
  TTimer *OffSetImageTimer;
  TTntButton *StartButton;
  TButton *stop;
  TTimer *TestTimer;
  TButton *timer5start;
  TGroupBox *TestBox;
  TImage *Image5;
  void __fastcall FormCreate(TObject *Sender);
  void __fastcall CloseButtonClick(TObject *Sender);
  void __fastcall OffSetImageTimerTimer(TObject *Sender);
  void __fastcall StartButtonClick(TObject *Sender);
  void __fastcall stopClick(TObject *Sender);
  void __fastcall TestTimerTimer(TObject *Sender);
  void __fastcall timer5startClick(TObject *Sender);
  void __fastcall Image5Click(TObject *Sender);
  void __fastcall FormActivate(TObject *Sender);
private:	// User declarations
  int CAM_Width;
  int CAM_Height;
  int CaptureWidth, CaptureHeight;
  int ShutterSpeedList[SYSTEM_TOTAL_CAMERA_COUNT];
  int DigitalGainList[SYSTEM_TOTAL_CAMERA_COUNT];
  unsigned char CaptureData[MAX_IMAGE_WIDTH * MAX_IMAGE_HEIGHT];
  unsigned char SubsamplingModeList[SYSTEM_TOTAL_CAMERA_COUNT];
  //unsigned char BinaryImage1[640*480*3];
  unsigned int BinaryImage[640*480];

  void __fastcall InitCaptureComponentOffSetImage();
  void __fastcall RefreshCameraInfoOffSetImage(int cameraIndex, int gainCount);
  int CheckCaptureCount[SYSTEM_TOTAL_CAMERA_COUNT];
public:		// User declarations
  __fastcall TOffSetImageExtractForm(TComponent* Owner);
};
//---------------------------------------------------------------------------
extern PACKAGE TOffSetImageExtractForm *OffSetImageExtractForm;
//---------------------------------------------------------------------------
#endif
