//---------------------------------------------------------------------------

#ifndef PreviewInspection_FormH
#define PreviewInspection_FormH
//---------------------------------------------------------------------------
#include <Classes.hpp>
#include <Controls.hpp>
#include <StdCtrls.hpp>
#include <Forms.hpp>
#include "TntExtCtrls.hpp"
#include <ExtCtrls.hpp>
#include "TntStdCtrls.hpp"

#include "Environment.h"
#include "CPB_Module.h"
#include "FileContainer.h"
#include "Processing.h"
#include <Buttons.hpp>
#include <ComCtrls.hpp>
#include <Chart.hpp>
#include <Series.hpp>
#include <TeEngine.hpp>
#include <TeeProcs.hpp>
#include <Grids.hpp>
#include "TntGrids.hpp"

//---------------------------------------------------------------------------
#define IMAGE_TYPE_NORMAL 0
#define IMAGE_TYPE_DEFECT 1

#define DESIGNED_IMAGE_COMPONENTS_COUNT 2
#define DESIGNED_IMAGE_BOX_HEIGHT 1511

#define DEFECT_LIST_CONTROL_OPTION_CLEAR  0
#define DEFECT_LIST_CONTROL_OPTION_ADD    1

#define MAX_DEFAULT_RESULT_VIEW_COUNT 8

#define MAX_INSPECTION_COUNT 10000

#define MAKE_COMPONENT_QUEUE_MASK 255
#define MAKE_COMPONENT_QUEUE_SIZE 256
//---------------------------------------------------------------------------
typedef struct
{
	WideString LOTName;
  TDateTime InspectionEndTime;
  int goodProductCount;
  int defectProductCount;
  double ProductionDefectRatio;
}TLOTInformation;

typedef struct
{
	int TotalCount;
  int GoodCount;
  int DefectCount;
  int UninsCount;
  int CameraDefectRate[SYSTEM_TOTAL_CAMERA_COUNT];
}TPreviewResultCount;

typedef struct
{
	int Version;
	int dummy[3];
} TDefectDataHeader;

typedef struct
{
	TDefectDataHeader DefectDataHeader;
	TDefectData_PC DefectData;
} TDefectFileData;

typedef struct
{
	int TabletNumber;
  int CameraNumber;
  int DefectSW;
  int DefectSeries;
  int DefectSize;
  TColor Color;
} TResultTable;
//---------------------------------------------------------------------------
class TPreviewInspectionForm : public TTntForm
{
__published:	// IDE-managed Components
  TTntPanel *PreviewOptionPanel;
  TTntButton *PreviewInspectionStartBtn;
  TTntButton *PreviewInspectionStopBtn;
  TTntButton *CloseBtn;
  TTntGroupBox *InspectionImageSettingGroupBox;
  TTntPanel *ImageSelectPanel1;
  TTntPanel *ImageSelectPanel2;
  TTntGroupBox *InspectionLOTSettingGroupBox;
  TTntLabel *Label1;
  TTntComboBox *LOTComboBox1;
  TTntPanel *CurrentLOTNameLabel;
  TTntLabel *Label2;
  TTntLabel *Label3;
  TTntLabel *Label4;
  TTntPanel *CameraEnablePanel1;
  TTntPanel *CameraEnablePanel9;
  TTntPanel *CameraEnablePanel5;
  TTntPanel *CameraEnablePanel13;
  TTntLabel *Label5;
  TTntPanel *CameraEnablePanel2;
  TTntPanel *CameraEnablePanel10;
  TTntPanel *CameraEnablePanel3;
  TTntPanel *CameraEnablePanel11;
  TTntPanel *CameraEnablePanel4;
  TTntPanel *CameraEnablePanel12;
  TTntPanel *CameraEnablePanel6;
  TTntPanel *CameraEnablePanel7;
  TTntPanel *CameraEnablePanel15;
  TTntPanel *CameraEnablePanel14;
  TTntPanel *CameraEnablePanel8;
  TTntPanel *CameraEnablePanel16;
  TTntGroupBox *CameraSettingGroupBox;
  TTntPanel *CameraAllControlPanel;
  TTntPanel *InspectionImagePanel;
  TTntPanel *Panel1;
  TTntImage *ScrollImage;
  TTntPanel *ImageGroupPanel;
  TTntPanel *ProcessingResultPanel1;
  TTntImage *ResultImage1;
  TTntLabel *CameraNumberLabel1;
  TTntLabel *TabletNumberLabel1;
  TTntLabel *InspectionResultLabel1;
  TShape *InspectionResultShape1;
  TTntPanel *ProcessingResultPanel2;
  TTntImage *ResultImage2;
  TTntLabel *CameraNumberLabel2;
  TTntLabel *TabletNumberLabel2;
  TTntLabel *InspectionResultLabel2;
  TShape *InspectionResultShape2;
  TTntPanel *PreviewResultCheckPanel;
  TTntPanel *Panel2;
  TProgressBar *ProgressBar1;
  TTntPanel *ProcessingCountPanel;
  TProgressBar *ProgressBar2;
  TProgressBar *ProgressBar;
  TTntPanel *ResultInfoPanel;
  TTntPanel *GraphInfoPanel;
  TChart *InspectionChart;
  TBarSeries *Series1;
  TTntPanel *DefectListPanel;
  TTntGroupBox *DefectListGroupxBox;
  TTntStringGrid *DefectListStringGrid;
  TPanel *DownListShiftPanel;
  TPanel *UpListShiftPanel;
  TPanel *ListControlPanel;
  TPanel *WaitingPanel;
  TTntPanel *CountInfoPanel;
  TTntShape *Shape1;
  TTntLabel *TntLabel1;
  TTntLabel *TntLabel2;
  TTntShape *Shape2;
  TTntShape *Shape3;
  TTntLabel *Label7;
  TTntLabel *UnInsTabletCountLabel;
  TTntLabel *DefectTabletCountLabel;
  TTntLabel *GoodTabletCountLabel;
  TTntLabel *TotalTabletCountLabel;
  TTntLabel *TntLabel3;
  TChart *DefectChart;
  TPieSeries *Series8;
  TPanel *Panel3;
  TTntShape *DefectCameraShape1;
  TTntLabel *CameraShapeLabel1;
  TTntShape *DefectCameraShape2;
  TTntLabel *CameraShapeLabel2;
  TTntShape *DefectCameraShape3;
  TTntLabel *CameraShapeLabel3;
  TTntShape *DefectCameraShape4;
  TTntLabel *CameraShapeLabel4;
  TTntShape *DefectCameraShape5;
  TTntLabel *CameraShapeLabel5;
  TTntShape *DefectCameraShape6;
  TTntLabel *CameraShapeLabel6;
  TTntShape *DefectCameraShape8;
  TTntLabel *CameraShapeLabel8;
  TTntLabel *CameraShapeLabel7;
  TTntShape *DefectCameraShape7;
  TTntShape *DefectCameraShape14;
  TTntShape *DefectCameraShape13;
  TTntShape *DefectCameraShape12;
  TTntShape *DefectCameraShape11;
  TTntShape *DefectCameraShape10;
  TTntShape *DefectCameraShape15;
  TTntShape *DefectCameraShape16;
  TTntShape *DefectCameraShape9;
  TTntLabel *CameraShapeLabel14;
  TTntLabel *CameraShapeLabel13;
  TTntLabel *CameraShapeLabel12;
  TTntLabel *CameraShapeLabel11;
  TTntLabel *CameraShapeLabel10;
  TTntLabel *CameraShapeLabel9;
  TTntLabel *CameraShapeLabel15;
  TTntLabel *CameraShapeLabel16;
  TTntLabel *TntLabel13;
  void __fastcall FormCreate(TObject *Sender);
  void __fastcall ImageSelectPanel1Click(TObject *Sender);
  void __fastcall CameraEnablePanel1Click(TObject *Sender);
  void __fastcall LOTComboBox1Click(TObject *Sender);
  void __fastcall CloseBtnClick(TObject *Sender);
  void __fastcall CameraAllControlPanelClick(TObject *Sender);
  void __fastcall ScrollImageMouseDown(TObject *Sender,
          TMouseButton Button, TShiftState Shift, int X, int Y);
  void __fastcall ScrollImageMouseMove(TObject *Sender, TShiftState Shift,
          int X, int Y);
  void __fastcall ScrollImageMouseUp(TObject *Sender, TMouseButton Button,
          TShiftState Shift, int X, int Y);
  void __fastcall PreviewInspectionStartBtnClick(TObject *Sender);
  void __fastcall PreviewInspectionStopBtnClick(TObject *Sender);
  void __fastcall DefectListStringGridClick(TObject *Sender);
  void __fastcall UpListShiftPanelMouseDown(TObject *Sender,
          TMouseButton Button, TShiftState Shift, int X, int Y);
  void __fastcall DownListShiftPanelMouseDown(TObject *Sender,
          TMouseButton Button, TShiftState Shift, int X, int Y);
  void __fastcall UpListShiftPanelMouseUp(TObject *Sender,
          TMouseButton Button, TShiftState Shift, int X, int Y);
  void __fastcall DownListShiftPanelMouseUp(TObject *Sender,
          TMouseButton Button, TShiftState Shift, int X, int Y);
  void __fastcall UpListShiftPanelMouseMove(TObject *Sender,
          TShiftState Shift, int X, int Y);
  void __fastcall DownListShiftPanelMouseMove(TObject *Sender,
          TShiftState Shift, int X, int Y);
  void __fastcall FormActivate(TObject *Sender);
private:	// User declarations
  void __fastcall RefreshImageSelectMenu(void);
  void __fastcall RefreshCameraSelectMenu(void);
  void __fastcall RefreshCurrentLOTInfo(void);
  void __fastcall SetLOTInformation();
  void __fastcall RefreshCameraAllSelectMenu(void);
  void __fastcall MakeResultComponents(int makeStartIndex);
  void __fastcall AllRemoveResultComponents(void);
  void __fastcall InitDesignedComponents(void);
  void __fastcall SetPCEnableEvent(void);
  void __fastcall DoProcessing(int cameraIndex);
  bool __fastcall ReadSetupData(TTabletSetupData *tabletSetupData);
  void __fastcall DoProcessingFor3D(int cameraIndex);
  bool __fastcall ReadStudyData(TTabletStudyData *tabletStudyData);
  bool __fastcall ImageLoad(int imageIndex, int cameraIndex);
  bool __fastcall Read3DSetupData(TTablet3DSetupData *tablet3DSetupData);
  void __fastcall setPosSetupData(TTabletSetupData *pTabletSetupData);
  void __fastcall WriteSetupData(TTabletSetupData *tabletSetupData);
  void __fastcall SetProcessingResult(int cameraIndex);
  void __fastcall RefreshResultCountInfo();
  void __fastcall RefreshDefectStringGrid(int option, int tabletNumber, int cameraNumber, int DefectSeries);
  bool __fastcall DefectImageLoad(int dataIndex, int globalCameraIndex);
  void __fastcall RemoveImageComponent(int unusedAll);
  void __fastcall ReleaseComponent(void);
  void __fastcall SetComponentQueue(void);
  void __fastcall GetDefaultString();

  int inspectedLOTCount;
  TLOTInformation LOTInformation[2000];

  WideString PreviewLOTName;
  int InspectionImageType;
  bool bEnabledInspectionCamera[SYSTEM_TOTAL_CAMERA_COUNT];
  bool bEnabledCameraAll;

  TSideData tempSideData[SYSTEM_TOTAL_CAMERA_COUNT - 4];

  unsigned char PCBackgroundImageBuffer[MAX_INBOARD_PROCESSING_CAMERA_COUNT][MAX_IMAGE_WIDTH * MAX_IMAGE_HEIGHT * 3];
  short PCColorRateImageBuffer[MAX_INBOARD_PROCESSING_CAMERA_COUNT][MAX_IMAGE_WIDTH * MAX_IMAGE_HEIGHT * 3];
  unsigned char PCRGBFactorArrayBuffer[MAX_INBOARD_PROCESSING_CAMERA_COUNT][MAX_IMAGE_WIDTH * MAX_IMAGE_HEIGHT];

  int currentImageIndex;
  int InspectionOrStudy;
  int InspectionKind;

  bool bInspectionStart;
  bool bStop;
  int processingCount;
  int prevDefectTabletNumber;

  int ComponentQueueStartIndex;
  int ComponentQueueEndIndex;
  int ComponentTabletNumber[MAKE_COMPONENT_QUEUE_MASK];

  TPoint ScrollImageMouseDownPos;
  TPoint ScrollImageMouseMovePos;
  bool IsScrollImageMouseDown;
  bool IsStringGridMouseDown;
  unsigned int LastStringGridMouseDownTime;

  int lastScrollTabletNumber;
  int recentScrollTabletNumber;

  TResultTable ResultTable[MAX_INSPECTION_COUNT];
  TPreviewResultCount PreviewResultCount;
  TColor defectColorList[SYSTEM_TOTAL_CAMERA_COUNT];
  
public:		// User declarations
  __fastcall TPreviewInspectionForm(TComponent* Owner);

  TTabletGradeData previewSrcGradeData;
};
//---------------------------------------------------------------------------
extern PACKAGE TPreviewInspectionForm *PreviewInspectionForm;
//---------------------------------------------------------------------------
#endif
