//---------------------------------------------------------------------------
// For SELMA200, 20180223, moon, 
//---------------------------------------------------------------------------

#include <vcl.h>
#pragma hdrstop

#include "RangerCameraSetup_Form.h"
#include "CommControl_Form.h"
#include "Environment.h"
#include "MultiLanguage.h"
//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma link "TntDialogs"
#pragma link "TntExtCtrls"
#pragma link "TntStdCtrls"
#pragma resource "*.dfm"

#define CMD_CAMERA_CONTROL_RX        	 			(('C' << 8) + 'Z')
TRangerCameraSetupForm *RangerCameraSetupForm;
//---------------------------------------------------------------------------
__fastcall TRangerCameraSetupForm::TRangerCameraSetupForm(TComponent* Owner)
	: TTntForm(Owner)
{
  if(DefaultLCID == 1028 || DefaultLCID == 2052 || DefaultLCID == 3076 || DefaultLCID == 4100)
    ComponentSetFontName(this, "SimSun");

	PacketID = 0;
	CurrentRXPos = 0;
	PacketStartPos = 0;
	LastReceivedTime = GetTickCount();
	RxStatus = ERS_IDLE;	
}
//---------------------------------------------------------------------------
void __fastcall TRangerCameraSetupForm::SendCommandButtonClick(TObject *Sender)
{
	int txLength = (CommandEdit->Text.Length() + 1 + 8 + 3) / 4 * 4;
	char *txBuf = new char[txLength + 4];
	memset(txBuf, 0, txLength);
	txBuf[8] = 0xFF;
	strcpy(txBuf + 9, CommandEdit->Text.c_str());
	txBuf[9 + CommandEdit->Text.Length()] = '\r';
	txBuf[9 + CommandEdit->Text.Length() + 1] = '\n';
	txBuf[9 + CommandEdit->Text.Length() + 2] = '\0';
//	strcpy(txBuf + 1, CommandEdit->Text.c_str());
//	txBuf[0] = 0x20;
//	txBuf[CommandEdit->Text.Length() + 1] = 0x20;
//	txBuf[CommandEdit->Text.Length() + 2] = '\r';
//  txBuf[CommandEdit->Text.Length() + 3] = '\n';
//	txBuf[CommandEdit->Text.Length() + 4] = '\0';
/*
	txBuf[0] = 0x01;
	txBuf[CommandEdit->Text.Length()] = '\r';
	txBuf[CommandEdit->Text.Length() + 1] = '\n';
	txBuf[CommandEdit->Text.Length() + 2] = 0x03;
*/

	Memo->Lines->Add("Command> " + CommandEdit->Text);

	int commandLength = txLength - 8;
	int spbIndex = CameraMapInfo[GlobalCameraIndex].SPBIndex;
	int camIndex = CameraMapInfo[GlobalCameraIndex].CamIndex;
	memcpy(txBuf, &camIndex, sizeof(int));
	memcpy(txBuf + 4, &commandLength, sizeof(int));

	Comm_Request(COMM_SPB + spbIndex, CMD_CAMERA_CONTROL, txBuf, txLength);
	delete[] txBuf;
}
//---------------------------------------------------------------------------
void __fastcall TRangerCameraSetupForm::Timer1Timer(TObject *Sender)
{
	char *rxBuf = new char[2048 + 1];
	int spbIndex = CameraMapInfo[GlobalCameraIndex].SPBIndex;
	int camIndex = CameraMapInfo[GlobalCameraIndex].CamIndex;
	if (Comm_Request(COMM_SPB + spbIndex, CMD_CAMERA_CONTROL_RX, 0, NULL, rxBuf, 2048))
	{
	if (rxBuf[0] != 0 || rxBuf[1] != 0)
	{
		int rxLength = ((unsigned char)rxBuf[1] << 8) + (unsigned char)rxBuf[0];

		if (CurrentRXPos + rxLength > 65536) // overflow
		{
			CurrentRXPos = 0;
			PacketStartPos = 0;
		}
		memcpy(RxBuf + CurrentRXPos, rxBuf + 2, rxLength);
		CurrentRXPos += rxLength;

		if (RxStatus == ERS_IDLE)
		{
			while (PacketStartPos + 8 <= CurrentRXPos)
			{
				if (RxBuf[PacketStartPos] == 'I' && RxBuf[PacketStartPos + 1] == 'V' &&
					RxBuf[PacketStartPos + 2] == 'P' && RxBuf[PacketStartPos + 3] == 0)
				{
					RxStatus = ERS_HEADER_RECEIVED;
					PacketLength = (unsigned char)RxBuf[PacketStartPos + 4] + ((unsigned char)RxBuf[PacketStartPos + 5] << 8) +
						((unsigned char)RxBuf[PacketStartPos + 6] << 16) + ((unsigned char)RxBuf[PacketStartPos + 7] << 24);
					break;
				}
				PacketStartPos++;
			}
		}

		if (RxStatus == ERS_HEADER_RECEIVED)
		{
			if (CurrentRXPos - PacketStartPos >= PacketLength)
			{
				RxStatus = ERS_RECEIVED;
			}
		}
		LastReceivedTime = GetTickCount();
                                  
/*
		if (rxLength <= 2046)
		{
			for (int i = 0; i < rxLength; i++)
			{
//				if (rxBuf[2 + i] == 0) rxBuf[2 + i] = ' ';
			}
			rxBuf[2 + rxLength] = '\0';
			Memo->Lines->Add(AnsiString(rxBuf + 2));
		}
*/
	}
	}
	delete[] rxBuf;


	if (RxStatus == ERS_HEADER_RECEIVED)
	{
		if (GetTickCount() - LastReceivedTime > 5000)
		{
			LastReceivedTime = GetTickCount();
			CurrentRXPos = 0;
			PacketStartPos = 0;
			PacketLength = 0;
			RxStatus = ERS_IDLE;
		}
	}
	else if (RxStatus == ERS_RECEIVED)
	{
		TRangerPacketHeader RXPacketHeader;
		TRangerPacketHeader TXPacketHeader;
		// interpret packet
		memcpy(&RXPacketHeader, RxBuf + PacketStartPos, sizeof(TRangerPacketHeader));
		if (RXPacketHeader.Error == 1)
		{
			if (RXPacketHeader.Command == 0x0002000C)	// init command
			{
				Memo->Lines->Add("<Command> Init");
				int returnStrLength = RXPacketHeader.Length - sizeof(TRangerPacketHeader);
				char *returnStr = new char[returnStrLength + 1];
				memcpy(returnStr, RxBuf + PacketStartPos + sizeof(TRangerPacketHeader), returnStrLength);
				returnStr[returnStrLength] = 0;
				Memo->Lines->Add(AnsiString(returnStr));
				for (int strPos = 0; strPos < returnStrLength; strPos++)
				{
					if (returnStr[strPos] == 0)
					{
						Memo->Lines->Add(returnStr + strPos + 1);
					}
				}
				delete[] returnStr;
			}
			else if (RXPacketHeader.Command == 0x00020009)	// get avail configs command
			{
				Memo->Lines->Add("<Command> Get Available Configrations");
				int returnStrLength = RXPacketHeader.Length - sizeof(TRangerPacketHeader);
				char *returnStr = new char[returnStrLength + 1];
				memcpy(returnStr, RxBuf + PacketStartPos + sizeof(TRangerPacketHeader), returnStrLength);
				returnStr[returnStrLength] = 0;
				Memo->Lines->Add(AnsiString(returnStr));
				delete[] returnStr;
			}
			else if (RXPacketHeader.Command == 0x00020001)	// Set Activer Configuration
			{
				unsigned int val[2];
				memcpy(val, RxBuf + PacketStartPos + sizeof(TRangerPacketHeader), 2 * sizeof(unsigned int));
				Memo->Lines->Add("<Command> " + IntToStr(val[0]));
				Memo->Lines->Add("Val = " + IntToStr(val[1]));
			}
			else if (RXPacketHeader.Command == 0x0002000A)	// Set Parameter
			{
				Memo->Lines->Add("<Command> Set Parameter");
				unsigned int val[3];
				memcpy(val, RxBuf + PacketStartPos + sizeof(TRangerPacketHeader), 3 * sizeof(unsigned int));
				Memo->Lines->Add("Val1 = " + IntToStr(val[0]));
				Memo->Lines->Add("Val2 = " + IntToStr(val[1]));
				Memo->Lines->Add("Val3 = " + IntToStr(val[2]));
			}
			else if (RXPacketHeader.Command == 0x00020006)	// Get Data Format
			{
				Memo->Lines->Add("<Command> Get Data Format");
				int returnStrLength = RXPacketHeader.Length - sizeof(TRangerPacketHeader);
				char *returnStr = new char[returnStrLength + 1];
				char *parseStr = new char[returnStrLength + 1];
				memcpy(returnStr, RxBuf + PacketStartPos + sizeof(TRangerPacketHeader), returnStrLength);
				int parseStrPos = 0;
				for (int strPos = 0; strPos < returnStrLength; strPos++)
				{
					if (returnStr[strPos] == '\r' || returnStr[strPos] == '\n' || returnStr[strPos] == '\0')
					{
						if (parseStrPos > 0)
						{
							parseStr[parseStrPos] = '\0';
							Memo->Lines->Add(AnsiString(parseStr));
							parseStrPos = 0;
						}
					}
					else
					{
						parseStr[parseStrPos] = returnStr[strPos];
						parseStrPos++;
					}
				}
				if (parseStrPos > 0)
				{
					parseStr[parseStrPos] = '\0';
					Memo->Lines->Add(AnsiString(parseStr));
				}
				//Memo->Lines->Add(AnsiString(RxBuf + PacketStartPos + sizeof(TRangerPacketHeader) + 4));
				delete[] returnStr;
				delete[] parseStr;
			}
			else
			{
				Memo->Lines->Add("Command: Unknown");
				Memo->Lines->Add("Val: " + IntToStr(RXPacketHeader.val1) + " , " + IntToStr(RXPacketHeader.PacketID) + " , " +
					IntToStr(RXPacketHeader.DataLength) + " , " + IntToStr(RXPacketHeader.Command) + " , " + IntToStr(RXPacketHeader.RetPacketID));
			}
		}
		else if (RXPacketHeader.Error == 2)		// message
		{
			Memo->Lines->Add("<Message>");
			Memo->Lines->Add(AnsiString(RxBuf + PacketStartPos + 36));

		}
		if (CurrentRXPos - PacketStartPos > PacketLength)
		{
			memcpy(RxBuf, RxBuf + PacketStartPos + PacketLength, CurrentRXPos - PacketStartPos);
			CurrentRXPos = CurrentRXPos - PacketStartPos + PacketLength;
			PacketStartPos = 0;
			PacketLength = 0;
			RxStatus = ERS_IDLE;

			if (RxStatus == ERS_IDLE)
			{
				while (PacketStartPos + 8 <= CurrentRXPos)
				{
					if (RxBuf[PacketStartPos] == 'I' && RxBuf[PacketStartPos + 1] == 'V' &&
						RxBuf[PacketStartPos + 2] == 'P' && RxBuf[PacketStartPos + 3] == 0)
					{
						RxStatus = ERS_HEADER_RECEIVED;
						PacketLength = (unsigned char)RxBuf[PacketStartPos + 4] + ((unsigned char)RxBuf[PacketStartPos + 5] << 8) +
							((unsigned char)RxBuf[PacketStartPos + 6] << 16) + ((unsigned char)RxBuf[PacketStartPos + 7] << 24);
						break;
					}
					PacketStartPos++;
				}
			}

			if (RxStatus == ERS_HEADER_RECEIVED)
			{
				if (CurrentRXPos - PacketStartPos >= PacketLength)
				{
					RxStatus = ERS_RECEIVED;
				}
			}
			LastReceivedTime = GetTickCount();
		}
		else
		{
			CurrentRXPos = 0;
			PacketStartPos = 0;
			PacketLength = 0;
			RxStatus = ERS_IDLE;
		}
	}
}
//---------------------------------------------------------------------------
void __fastcall TRangerCameraSetupForm::InitButtonClick(TObject *Sender)
{
	char *txBuf = new char[40];
	PacketID++;

	TRangerPacketHeader TXPacketHeader;
	TXPacketHeader.Header = ('P' << 16) | ('V' << 8) | ('I' << 0);
	TXPacketHeader.Length = 40;
	TXPacketHeader.Protocol = 1;
	TXPacketHeader.Error = 1;
	TXPacketHeader.CheckSum = TXPacketHeader.Header ^ TXPacketHeader.Length ^ TXPacketHeader.Protocol ^ TXPacketHeader.Error;
	TXPacketHeader.val1 = 256;
	TXPacketHeader.PacketID = PacketID;
	TXPacketHeader.DataLength = 20;
	TXPacketHeader.Command = 9;
	TXPacketHeader.RetPacketID = PacketID * 2;

	memcpy(txBuf, &TXPacketHeader, sizeof(TRangerPacketHeader));
	SendCameraControl(txBuf, 40);

	delete[] txBuf;
}
//---------------------------------------------------------------------------
void __fastcall TRangerCameraSetupForm::SendCameraControl(char *txBuf, int txCount)
{
	int sendLength = (txCount + 8 + 3) / 4 * 4;
	char *sendData = new char[sendLength];
	memset(sendData, 0, sendLength);
	int commandLength = sendLength - 8;
	int spbIndex = CameraMapInfo[GlobalCameraIndex].SPBIndex;
	int camIndex = CameraMapInfo[GlobalCameraIndex].CamIndex;

	memcpy(sendData, &camIndex, sizeof(int));
	memcpy(sendData + 4, &commandLength, sizeof(int));
//	sendData[8] = 0xFF;
//	sendData[8] = 0;
	memcpy(sendData + 8, txBuf, txCount);

	Comm_Request(COMM_SPB + spbIndex, CMD_CAMERA_CONTROL, sendData, sendLength);
	delete[] sendData;
}
//---------------------------------------------------------------------------

void __fastcall TRangerCameraSetupForm::SendFileButtonClick(TObject *Sender)
{
	if (OpenDialog->Execute())
	{
		AnsiString fileName = OpenDialog->FileName;
		TFileStream *fileStream = new TFileStream(fileName, fmOpenRead);
		if (fileStream)
		{
			char *str = new char[fileStream->Size];
			fileStream->Read(str, fileStream->Size);
			SendCameraControl(str, fileStream->Size);
			/*
			for (int count = 0; count < fileStream->Size; count += 2000)
			{
				if (fileStream->Size - count > 2000)
				{
					SendCameraControl(str + count, 2000);
				}
				else
				{
					SendCameraControl(str + count, fileStream->Size - count);
				}
			}
			*/
			delete[] str;
			delete fileStream;
		}
	}
}
//---------------------------------------------------------------------------
void __fastcall TRangerCameraSetupForm::ClearButtonClick(TObject *Sender)
{
	Memo->Clear();	
}
//---------------------------------------------------------------------------
void __fastcall TRangerCameraSetupForm::GetAvalConfigButtonClick(TObject *Sender)
{
	char *txBuf = new char[40];
	PacketID++;

	TRangerPacketHeader TXPacketHeader;
	TXPacketHeader.Header = ('P' << 16) | ('V' << 8) | ('I' << 0);
	TXPacketHeader.Length = 40;
	TXPacketHeader.Protocol = 1;
	TXPacketHeader.Error = 1;
	TXPacketHeader.CheckSum = TXPacketHeader.Header ^ TXPacketHeader.Length ^ TXPacketHeader.Protocol ^ TXPacketHeader.Error;
	TXPacketHeader.val1 = 256;
	TXPacketHeader.PacketID = PacketID;
	TXPacketHeader.DataLength = 20;
	TXPacketHeader.Command = 7;
	TXPacketHeader.RetPacketID = PacketID * 2;

	memcpy(txBuf, &TXPacketHeader, sizeof(TRangerPacketHeader));
	SendCameraControl(txBuf, 40);
	delete[] txBuf;
}
//---------------------------------------------------------------------------

void __fastcall TRangerCameraSetupForm::SetMeasurementConfigButtonClick(TObject *Sender)
{
	char *txBuf = new char[52];
	PacketID++;

	TRangerPacketHeader TXPacketHeader;
	TXPacketHeader.Header = ('P' << 16) | ('V' << 8) | ('I' << 0);
	TXPacketHeader.Length = 52;
	TXPacketHeader.Protocol = 1;
	TXPacketHeader.Error = 1;
	TXPacketHeader.CheckSum = TXPacketHeader.Header ^ TXPacketHeader.Length ^ TXPacketHeader.Protocol ^ TXPacketHeader.Error;
	TXPacketHeader.val1 = 256;
	TXPacketHeader.PacketID = PacketID;
	TXPacketHeader.DataLength = 32;
	TXPacketHeader.Command = 0x00010001;
	TXPacketHeader.RetPacketID = PacketID * 2;
	AnsiString configName = "Measurement";
	memcpy(txBuf, &TXPacketHeader, sizeof(TRangerPacketHeader));
	strcpy(txBuf + sizeof(TRangerPacketHeader), configName.c_str());
	SendCameraControl(txBuf, 52);
	delete[] txBuf;
}
//---------------------------------------------------------------------------



void __fastcall TRangerCameraSetupForm::StartCameraButtonClick(TObject *Sender)
{
	char *txBuf = new char[40];
	PacketID++;

	TRangerPacketHeader TXPacketHeader;
	TXPacketHeader.Header = ('P' << 16) | ('V' << 8) | ('I' << 0);
	TXPacketHeader.Length = 40;
	TXPacketHeader.Protocol = 1;
	TXPacketHeader.Error = 1;
	TXPacketHeader.CheckSum = TXPacketHeader.Header ^ TXPacketHeader.Length ^ TXPacketHeader.Protocol ^ TXPacketHeader.Error;
	TXPacketHeader.val1 = 256;
	TXPacketHeader.PacketID = PacketID;
	TXPacketHeader.DataLength = 20;
	TXPacketHeader.Command = 5;
	TXPacketHeader.RetPacketID = PacketID * 2;

	memcpy(txBuf, &TXPacketHeader, sizeof(TRangerPacketHeader));
	SendCameraControl(txBuf, 40);
	delete[] txBuf;
}
//---------------------------------------------------------------------------

void __fastcall TRangerCameraSetupForm::StopCameraButtonClick(TObject *Sender)
{
	char *txBuf = new char[40];
	PacketID++;

	TRangerPacketHeader TXPacketHeader;
	TXPacketHeader.Header = ('P' << 16) | ('V' << 8) | ('I' << 0);
	TXPacketHeader.Length = 40;
	TXPacketHeader.Protocol = 1;
	TXPacketHeader.Error = 1;
	TXPacketHeader.CheckSum = TXPacketHeader.Header ^ TXPacketHeader.Length ^ TXPacketHeader.Protocol ^ TXPacketHeader.Error;
	TXPacketHeader.val1 = 256;
	TXPacketHeader.PacketID = PacketID;
	TXPacketHeader.DataLength = 20;
	TXPacketHeader.Command = 6;
	TXPacketHeader.RetPacketID = PacketID * 2;

	memcpy(txBuf, &TXPacketHeader, sizeof(TRangerPacketHeader));
	SendCameraControl(txBuf, 40);
	delete[] txBuf;
}
//---------------------------------------------------------------------------

void __fastcall TRangerCameraSetupForm::DownloadParameterButtonClick(
	  TObject *Sender)
{
	if (OpenDialog->Execute())
	{
		TFileStream *fileStream = new TFileStream(OpenDialog->FileName, fmOpenRead);
		if (fileStream)
		{
			char *txBuf = new char[40 + fileStream->Size];
			PacketID++;


			fileStream->Read(txBuf + 40, fileStream->Size);
			TRangerPacketHeader TXPacketHeader;
			TXPacketHeader.Header = ('P' << 16) | ('V' << 8) | ('I' << 0);
			TXPacketHeader.Length = 40 + fileStream->Size;
			TXPacketHeader.Protocol = 1;
			TXPacketHeader.Error = 1;
			TXPacketHeader.CheckSum = TXPacketHeader.Header ^ TXPacketHeader.Length ^ TXPacketHeader.Protocol ^ TXPacketHeader.Error;
			TXPacketHeader.val1 = 256;
			TXPacketHeader.PacketID = PacketID;
			TXPacketHeader.DataLength = 20 + fileStream->Size;
			TXPacketHeader.Command = 0x00010002;
			TXPacketHeader.RetPacketID = PacketID * 2;

			memcpy(txBuf, &TXPacketHeader, sizeof(TRangerPacketHeader));
			SendCameraControl(txBuf, fileStream->Size + 40);
			/*
			int remainSize = fileStream->Size + 40;
			int currentPos = 0;
			while(remainSize)
			{
				if (remainSize > 2000)
				{
					SendCameraControl(txBuf + currentPos, 2000);
					currentPos += 2000;
					remainSize -= 2000;
				}
				else
				{
					SendCameraControl(txBuf + currentPos, remainSize);
					remainSize = 0;
				}
			}
			*/
			delete[] txBuf;

			delete fileStream;
		}
	}
}
//---------------------------------------------------------------------------


void __fastcall TRangerCameraSetupForm::GetDataFormatButtonClick(TObject *Sender)
{
	char *txBuf = new char[46];
	PacketID++;

	TRangerPacketHeader TXPacketHeader;
	TXPacketHeader.Header = ('P' << 16) | ('V' << 8) | ('I' << 0);
	TXPacketHeader.Length = 40;
	TXPacketHeader.Protocol = 1;
	TXPacketHeader.Error = 1;
	TXPacketHeader.CheckSum = TXPacketHeader.Header ^ TXPacketHeader.Length ^ TXPacketHeader.Protocol ^ TXPacketHeader.Error;
	TXPacketHeader.val1 = 256;
	TXPacketHeader.PacketID = PacketID;
	TXPacketHeader.DataLength = 20;
	TXPacketHeader.Command = 0x00010006;
	TXPacketHeader.RetPacketID = PacketID * 2;

	memcpy(txBuf, &TXPacketHeader, sizeof(TRangerPacketHeader));
	AnsiString msg = "Camera";
	strcpy(txBuf + 40, msg.c_str());
	SendCameraControl(txBuf, 40);
	delete[] txBuf;
}
//---------------------------------------------------------------------------

void __fastcall TRangerCameraSetupForm::SetImageConfigButtonClick(
	  TObject *Sender)
{
	char *txBuf = new char[52];
	PacketID++;

	TRangerPacketHeader TXPacketHeader;
	TXPacketHeader.Header = ('P' << 16) | ('V' << 8) | ('I' << 0);
	TXPacketHeader.Length = 46;
	TXPacketHeader.Protocol = 1;
	TXPacketHeader.Error = 1;
	TXPacketHeader.CheckSum = TXPacketHeader.Header ^ TXPacketHeader.Length ^ TXPacketHeader.Protocol ^ TXPacketHeader.Error;
	TXPacketHeader.val1 = 256;
	TXPacketHeader.PacketID = PacketID;
	TXPacketHeader.DataLength = 26;
	TXPacketHeader.Command = 0x00010001;
	TXPacketHeader.RetPacketID = PacketID * 2;
	AnsiString configName = "Image";
	memcpy(txBuf, &TXPacketHeader, sizeof(TRangerPacketHeader));
	strcpy(txBuf + sizeof(TRangerPacketHeader), configName.c_str());
	SendCameraControl(txBuf, 46);
	delete[] txBuf;
}
//---------------------------------------------------------------------------

void __fastcall TRangerCameraSetupForm::Button3Click(TObject *Sender)
{
	char *txBuf = new char[40];
	PacketID++;

	TRangerPacketHeader TXPacketHeader;
	TXPacketHeader.Header = ('P' << 16) | ('V' << 8) | ('I' << 0);
	TXPacketHeader.Length = 40;
	TXPacketHeader.Protocol = 1;
	TXPacketHeader.Error = 1;
	TXPacketHeader.CheckSum = TXPacketHeader.Header ^ TXPacketHeader.Length ^ TXPacketHeader.Protocol ^ TXPacketHeader.Error;
	TXPacketHeader.val1 = 256;
	TXPacketHeader.PacketID = PacketID;
	TXPacketHeader.DataLength = 20;
	TXPacketHeader.Command = 2;
	TXPacketHeader.RetPacketID = PacketID * 2;

	memcpy(txBuf, &TXPacketHeader, sizeof(TRangerPacketHeader));
	SendCameraControl(txBuf, 40);

	delete[] txBuf;
}
//---------------------------------------------------------------------------
void __fastcall TRangerCameraSetupForm::SetGlobalCameraIndex(int globalCameraIndex)
{
	GlobalCameraIndex = globalCameraIndex;
}
//---------------------------------------------------------------------------

void __fastcall TRangerCameraSetupForm::HWResetButtonClick(TObject *Sender)
{
	struct
	{
		int action;
		int hwCamIndex;
	} cameraResetData;
	if (GlobalCameraIndex == 5)
	{
		cameraResetData.hwCamIndex = 1;
	}
	else
	{
		cameraResetData.hwCamIndex = 0;
	}

	cameraResetData.action = 1;
	Comm_Request(COMM_HCB, CMD_CAMERA_RESET, &cameraResetData, sizeof(cameraResetData));
	Sleep(1000);
	cameraResetData.action = 0;
	Comm_Request(COMM_HCB, CMD_CAMERA_RESET, &cameraResetData, sizeof(cameraResetData));
}
//---------------------------------------------------------------------------

