//---------------------------------------------------------------------------

#ifndef RangerCameraSetup_FormH
#define RangerCameraSetup_FormH
//---------------------------------------------------------------------------
#include <Classes.hpp>
#include <Controls.hpp>
#include <StdCtrls.hpp>
#include <Forms.hpp>
#include <Dialogs.hpp>
#include <ExtCtrls.hpp>
#include "TntDialogs.hpp"
#include "TntExtCtrls.hpp"
#include "TntStdCtrls.hpp"
#include "TntForms.hpp"
//---------------------------------------------------------------------------
typedef enum {ERS_IDLE, ERS_HEADER_RECEIVED, ERS_RECEIVED} ERxStatus;

typedef struct
{
	unsigned int Header;
	unsigned int Length;
	unsigned int Protocol;
	unsigned int Error;
	unsigned int CheckSum;
	unsigned int val1;
	unsigned int PacketID;
	unsigned int DataLength;
	unsigned int Command;
	unsigned int RetPacketID;
} TRangerPacketHeader;
//---------------------------------------------------------------------------
class TRangerCameraSetupForm : public TTntForm
{
__published:	// IDE-managed Components
	TTntButton *ConnectButton;
	TTntMemo *Memo;
	TTntPanel *Panel1;
	TEdit *CommandEdit;
	TTntButton *SendCommandButton;
	TTntButton *SendFileButton;
	TTntButton *Button1;
	TTntButton *Button2;
	TTntButton *InitButton;
	TTntOpenDialog *OpenDialog;
	TTimer *Timer1;
	TTntButton *ClearButton;
	TTntButton *GetAvalConfigButton;
	TTntButton *SetMeasurementConfigButton;
	TTntButton *StartCameraButton;
	TTntButton *StopCameraButton;
	TTntButton *DownloadParameterButton;
	TTntButton *GetDataFormatButton;
	TTntButton *SetImageConfigButton;
	TTntButton *Button3;
	TTntButton *HWResetButton;
	void __fastcall SendCommandButtonClick(TObject *Sender);
	void __fastcall Timer1Timer(TObject *Sender);
	void __fastcall InitButtonClick(TObject *Sender);
	void __fastcall SendFileButtonClick(TObject *Sender);
	void __fastcall ClearButtonClick(TObject *Sender);
	void __fastcall GetAvalConfigButtonClick(TObject *Sender);
	void __fastcall SetMeasurementConfigButtonClick(TObject *Sender);
	void __fastcall StartCameraButtonClick(TObject *Sender);
	void __fastcall StopCameraButtonClick(TObject *Sender);
	void __fastcall DownloadParameterButtonClick(TObject *Sender);
	void __fastcall GetDataFormatButtonClick(TObject *Sender);
	void __fastcall SetImageConfigButtonClick(TObject *Sender);
	void __fastcall Button3Click(TObject *Sender);
	void __fastcall HWResetButtonClick(TObject *Sender);
private:	// User declarations
	char RxBuf[65536];
	ERxStatus RxStatus;
	int CurrentRXPos;
	int PacketStartPos;
	int PacketLength;	
	unsigned int PacketID;
	unsigned int LastReceivedTime;
	int GlobalCameraIndex;
	void __fastcall SendCameraControl(char *txBuf, int txCount);
public:		// User declarations
	__fastcall TRangerCameraSetupForm(TComponent* Owner);
	void __fastcall SetGlobalCameraIndex(int globalCameraIndex);
};
//---------------------------------------------------------------------------
extern PACKAGE TRangerCameraSetupForm *RangerCameraSetupForm;
//---------------------------------------------------------------------------
#endif
