//---------------------------------------------------------------------------

#ifndef Study_FormH
#define Study_FormH
//---------------------------------------------------------------------------
#include <Classes.hpp>
#include <Controls.hpp>
#include <StdCtrls.hpp>
#include <Forms.hpp>
#include <ComCtrls.hpp>
#include <ExtCtrls.hpp>
#include <Chart.hpp>
#include <Series.hpp>
#include <TeEngine.hpp>
#include <TeeProcs.hpp>

#include "Processing.h"
#include <ArrowCha.hpp>
#include <Dialogs.hpp>
#include <ExtDlgs.hpp>
#include "TntComCtrls.hpp"
#include "TntExtCtrls.hpp"
#include "TntStdCtrls.hpp"
#include "TntForms.hpp"

#include "Calibration_Form.h"
                                                                                                                                                                    
#define TEST_CAMERA_1_INDEX		0
#define TEST_CAMERA_9_INDEX		1
#define IMAGE_EVAL_COUNT		5
#define EVAL_VALUE_OK_LOWER_RATIO		  90
#define EVAL_VALUE_OK_HIGHER_RATIO		110

#define TOTAL_CHECKING_CAMERA_COUNT		2
typedef enum {ECTS_NONE, ECTS_CHECKING, ECTS_OK, ECTS_NG} ECameraTestStatus;

//---------------------------------------------------------------------------
class TStudyForm : public TTntForm
{
__published:	// IDE-managed Components
	TTimer *StudyTimer;
	TTntPanel *Panel2;
	TTimer *StudyResultTimer;
	TTntButton *StudyStartButton;
	TTntButton *StudyStopButton;
	TTntLabel *StudyCountSetLabel;
	TTntEdit *StudyCountEdit;
	TTntButton *CloseButton;
  TTntPanel *ProcessingPanel1;
	TTntProgressBar *StudyProgressBar;
    TTntLabel *StudyCountLabel;
	TTntPanel *BrightnessTestPanel;
	TTntPanel *StudyResultPanel;
	TTntPanel *Panel11;
	TTntPanel *Study2MenuPanel;
	TTntPanel *TLMenuPanel;
	TTntButton *StudyEnableButton;
	TTntButton *BrightnessTestButton;
	TTntGroupBox *GroupBox1;
	TTntGroupBox *Disk1CaptureGroupBox;
	TTntImage *CameraImage;
	TTntGroupBox *GroupBox4;
	TTntGroupBox *GroupBox6;
	TTimer *BrightnessTestTimer;
	TTntLabel *Label9;
	TTntLabel *Label10;
	TTntLabel *Camera1BasisValueLabel;
	TTntLabel *Camera1EvalValueLabel;
	TTntButton *SetDiskBasisValueButton;
	TTntPanel *Camera1SelectPanel;
	TTntLabel *Label7;
	TTntLabel *Camera9BasisValueLabel;
	TTntLabel *Label8;
	TTntLabel *Camera9EvalValueLabel;
  TTntPanel *Camera9SelectPanel;
	TTntButton *ImageEvalStartButton;
	TTntGroupBox *GroupBox2;
	TTntLabel *InstructionLabel1;
	TTntLabel *Label6;
	TTntLabel *InformationLabel1;
	TTntLabel *InformationLabel2;
  TTntPanel *SecretPanel;
  TPanel *GRPANEL1;
  TPanel *NoticePaenl2DCameraColorInfo1;
  TPanel *CamNamePanel1;
  TChart *TabletColorChart1;
  TBarSeries *Series2;
  TBarSeries *Series3;
  TBarSeries *Series5;
  TChart *TabletRearColorChart1;
  TBarSeries *BarSeries8;
  TBarSeries *BarSeries9;
  TBarSeries *BarSeries10;
  TPanel *GRPANEL2;
  TPanel *CamPanel3;
  TPanel *CamNamePanel3;
  TChart *TabletColorChartSideCam3;
  TBarSeries *BarSeries14;
  TBarSeries *BarSeries15;
  TBarSeries *BarSeries16;
  TPanel *CamPanel2;
  TChart *TabletColorChartSideCam2;
  TBarSeries *BarSeries17;
  TBarSeries *BarSeries18;
  TBarSeries *BarSeries19;
  TPanel *GRPANEL3;
  TPanel *CamPanel6;
  TPanel *CamNamePanel6;
  TChart *TabletColorChartSideCam6;
  TBarSeries *BarSeries20;
  TBarSeries *BarSeries21;
  TBarSeries *BarSeries22;
  TPanel *CamPanel4;
  TPanel *CamNamePanel4;
  TChart *TabletColorChartSideCam4;
  TBarSeries *BarSeries23;
  TBarSeries *BarSeries24;
  TBarSeries *BarSeries25;
  TPanel *GRPANEL4;
  TPanel *CamPanel8;
  TPanel *CamNamePanel8;
  TChart *TabletColorChartSideCam8;
  TBarSeries *BarSeries26;
  TBarSeries *BarSeries27;
  TBarSeries *BarSeries28;
  TPanel *CamPanel7;
  TPanel *CamNamePanel7;
  TChart *TabletColorChartSideCam7;
  TBarSeries *BarSeries29;
  TBarSeries *BarSeries30;
  TBarSeries *BarSeries31;
  TPanel *NoticePanel3D1;
  TPanel *GRPANEL5;
  TChart *TabletHeightChart1;
  TBarSeries *Series4;
  TBarSeries *Series6;
  TPanel *NoticePanelDisk1Engrave;
  TPanel *GRPANEL6;
  TPanel *NoticePanelDisk1Result;
  TPanel *EngravePaenl5;
  TPanel *ENNamePanel5;
  TPanel *EngravePanel1;
  TChart *TabletEngraveChart1;
  TBarSeries *BarSeries2;
  TBarSeries *Series1;
  TChart *TabletEngraveChart2;
  TBarSeries *BarSeries1;
  TBarSeries *BarSeries3;
  TPanel *Disk1Result;
  TPanel *CamNamePanel5;
  TPanel *ENNamePanel1;
  TPanel *ColorInfoDisk1;
  TPanel *ColorValuePanel1;
  TPanel *ThicknessInfoDisk1;
  TPanel *ThicknessInfoName1;
  TPanel *EngraveInfoDisk1;
  TPanel *EngraveInfoName1;
  TTntGroupBox *ThresholdGroupBox1;
  TTntLabel *ThresholdName1A;
  TTntLabel *ThresholdName5A;
  TTntLabel *ThresholdLabel_ForCam1_A;
  TTntLabel *ThresholdLabel_ForCam5_A;
  TTntGroupBox *ThresholdGroupBox2;
  TTntLabel *ThresholdName1B;
  TTntLabel *ThresholdName5B;
  TTntLabel *ThresholdLabel_ForCam1_B;
  TTntLabel *ThresholdLabel_ForCam5_B;
  TTntGroupBox *HeightGroupBox1;
  TTntLabel *HeightThresholdLabel_Disc1;
  TTntPanel *ProcessingPanel2;
  TPanel *GRPANEL7;
  TPanel *CamNamePanel9;
  TChart *TabletColorChart2;
  TBarSeries *BarSeries32;
  TBarSeries *BarSeries33;
  TBarSeries *BarSeries34;
  TChart *TabletRearColorChart2;
  TBarSeries *BarSeries35;
  TBarSeries *BarSeries36;
  TBarSeries *BarSeries37;
  TPanel *NoticePaenl2DCameraColorInfo2;
  TPanel *GRPANEL8;
  TPanel *CamPanel11;
  TPanel *CamNamePanel11;
  TChart *TabletColorChartSideCam11;
  TBarSeries *BarSeries38;
  TBarSeries *BarSeries39;
  TBarSeries *BarSeries40;
  TPanel *CamPanel10;
  TPanel *CamNamePanel10;
  TChart *TabletColorChartSideCam10;
  TBarSeries *BarSeries41;
  TBarSeries *BarSeries42;
  TBarSeries *BarSeries43;
  TPanel *GRPANEL9;
  TPanel *CamPanel14;
  TPanel *CamNamePanel14;
  TChart *TabletColorChartSideCam14;
  TBarSeries *BarSeries44;
  TBarSeries *BarSeries45;
  TBarSeries *BarSeries46;
  TPanel *CamPanel12;
  TPanel *CamNamePanel12;
  TChart *TabletColorChartSideCam12;
  TBarSeries *BarSeries47;
  TBarSeries *BarSeries48;
  TBarSeries *BarSeries49;
  TPanel *GRPANEL10;
  TPanel *CamPanel16;
  TPanel *CamNamePanel16;
  TChart *TabletColorChartSideCam16;
  TBarSeries *BarSeries50;
  TBarSeries *BarSeries51;
  TBarSeries *BarSeries52;
  TPanel *CamPanel15;
  TPanel *CamNamePanel15;
  TChart *TabletColorChartSideCam15;
  TBarSeries *BarSeries53;
  TBarSeries *BarSeries54;
  TBarSeries *BarSeries55;
  TPanel *NoticePanel3D2;
  TPanel *GRPANEL11;
  TChart *TabletHeightChart2;
  TBarSeries *BarSeries56;
  TBarSeries *BarSeries57;
  TPanel *CamNamePanel13;
  TPanel *NoticePanelDisk2Engrave;
  TPanel *GRPANEL12;
  TPanel *EngravePanel13;
  TPanel *ENNamePanel13;
  TChart *TabletEngraveChart4;
  TBarSeries *BarSeries58;
  TBarSeries *BarSeries59;
  TPanel *EngravePanel9;
  TChart *TabletEngraveChart3;
  TBarSeries *BarSeries60;
  TBarSeries *BarSeries61;
  TPanel *ENNamePanel9;
  TPanel *NoticePanelDisk2Result;
  TPanel *Disk2Result;
  TPanel *ColorInfoDisk2;
  TPanel *ColorValuePanel2;
  TPanel *ThicknessInfoDisk2;
  TPanel *ThicknessInfoName2;
  TTntGroupBox *HeightGroupBox2;
  TTntLabel *HeightThresholdLabel_Disc2;
  TPanel *EngraveInfoDisk2;
  TPanel *EngraveInfoName2;
  TTntGroupBox *ThresholdGroupBox3;
  TTntLabel *ThresholdName9A;
  TTntLabel *ThresholdName13A;
  TTntLabel *ThresholdLabel_ForCam9_A;
  TTntLabel *ThresholdLabel_ForCam13_A;
  TTntGroupBox *ThresholdGroupBox4;
  TTntLabel *ThresholdName9B;
  TTntLabel *ThresholdName13B;
  TTntLabel *ThresholdLabel_ForCam9_B;
  TTntLabel *ThresholdLabel_ForCam13_B;
  TPanel *ColorInfoName1;
  TPanel *ColorInfo3Chart1;
  TPanel *Cam6ColorValuePanel;
  TTntLabel *SideFaceTabletRColorLabelCam6;
  TTntLabel *SideFaceTabletGColorLabelCam6;
  TTntLabel *SideFaceTabletBColorLabelCam6;
  TTntShape *SideColorShapeCam6;
  TPanel *Cam6ColorInfoPanel;
  TPanel *Cam8ColorInfoPanel;
  TPanel *Cam8ColorValuePanel;
  TTntLabel *SideFaceTabletRColorLabelCam7;
  TTntLabel *SideFaceTabletGColorLabelCam7;
  TTntLabel *SideFaceTabletBColorLabelCam7;
  TTntShape *SideColorShapeCam7;
  TPanel *Cam7ColorInfoPanel;
  TPanel *Cam7ColorValuePanel;
  TTntLabel *SideFaceTabletRColorLabelCam8;
  TTntLabel *SideFaceTabletGColorLabelCam8;
  TTntLabel *SideFaceTabletBColorLabelCam8;
  TTntShape *SideColorShapeCam8;
  TPanel *ColorInfo1Chart1;
  TPanel *TwoColorResultGroupBox1;
  TTntLabel *TabletTwoColorFrontLabel_Disk1_R;
  TTntLabel *TabletTwoColorFrontLabel_Disk1_G;
  TTntLabel *TabletTwoColorFrontLabel_Disk1_B;
  TTntShape *TabletTwoColorFrontShape1;
  TTntShape *TabletTwoColorRearShape1;
  TTntLabel *TabletTwoColorRearLabel_Disk1_B;
  TTntLabel *TabletTwoColorRearLabel_Disk1_G;
  TTntLabel *TabletTwoColorRearLabel_Disk1_R;
  TPanel *OneColorResultGroupBox1;
  TTntLabel *TabletOneColorLabel_Disk1_R;
  TTntLabel *TabletOneColorLabel_Disk1_G;
  TTntLabel *TabletOneColorLabel_Disk1_B;
  TTntShape *TabletOneColorShape1;
  TPanel *Cam1ColorInfoPanel;
  TPanel *ColorInfo2Chart1;
  TPanel *Cam2ColorValuePanel;
  TTntLabel *SideFaceTabletRColorLabelCam2;
  TTntLabel *SideFaceTabletGColorLabelCam2;
  TTntLabel *SideFaceTabletBColorLabelCam2;
  TTntShape *SideColorShapeCam2;
  TPanel *Cam2ColorInfoPanel;
  TPanel *Cam4ColorInfoPanel;
  TPanel *Cam4ColorValuePanel;
  TTntLabel *SideFaceTabletRColorLabelCam3;
  TTntLabel *SideFaceTabletGColorLabelCam3;
  TTntLabel *SideFaceTabletBColorLabelCam3;
  TTntShape *SideColorShapeCam3;
  TPanel *Cam3ColorInfoPanel;
  TPanel *Cam3ColorValuePanel;
  TTntLabel *SideFaceTabletRColorLabelCam4;
  TTntLabel *SideFaceTabletGColorLabelCam4;
  TTntLabel *SideFaceTabletBColorLabelCam4;
  TTntShape *SideColorShapeCam4;
  TPanel *ColorInfoName2;
  TPanel *ColorInfo1Chart2;
  TPanel *TwoColorResultGroupBox2;
  TTntLabel *TabletTwoColorFrontLabel_Disk2_R;
  TTntLabel *TabletTwoColorFrontLabel_Disk2_G;
  TTntLabel *TabletTwoColorFrontLabel_Disk2_B;
  TTntShape *TabletTwoColorFrontShape2;
  TTntShape *TabletTwoColorRearShape2;
  TTntLabel *TabletTwoColorRearLabel_Disk2_B;
  TTntLabel *TabletTwoColorRearLabel_Disk2_G;
  TTntLabel *TabletTwoColorRearLabel_Disk2_R;
  TPanel *OneColorResultGroupBox2;
  TTntLabel *TabletOneColorLabel_Disk2_R;
  TTntLabel *TabletOneColorLabel_Disk2_G;
  TTntLabel *TabletOneColorLabel_Disk2_B;
  TTntShape *TabletOneColorShape2;
  TPanel *Cam9ColorInfoPanel;
  TPanel *ColorInfo2Chart2;
  TPanel *Cam10ColorValuePanel;
  TTntLabel *SideFaceTabletRColorLabelCam10;
  TTntLabel *SideFaceTabletGColorLabelCam10;
  TTntLabel *SideFaceTabletBColorLabelCam10;
  TTntShape *SideColorShapeCam10;
  TPanel *Cam10ColorInfoPanel;
  TPanel *Cam12ColorInfoPanel;
  TPanel *Cam12ColorValuePanel;
  TTntLabel *SideFaceTabletRColorLabelCam11;
  TTntLabel *SideFaceTabletGColorLabelCam11;
  TTntLabel *SideFaceTabletBColorLabelCam11;
  TTntShape *SideColorShapeCam11;
  TPanel *Cam11ColorInfoPanel;
  TPanel *Cam11ColorValuePanel;
  TTntLabel *SideFaceTabletRColorLabelCam12;
  TTntLabel *SideFaceTabletGColorLabelCam12;
  TTntLabel *SideFaceTabletBColorLabelCam12;
  TTntShape *SideColorShapeCam12;
  TPanel *ColorInfo3Chart2;
  TPanel *Cam14ColorValuePanel;
  TTntLabel *SideFaceTabletRColorLabelCam14;
  TTntLabel *SideFaceTabletGColorLabelCam14;
  TTntLabel *SideFaceTabletBColorLabelCam14;
  TTntShape *SideColorShapeCam14;
  TPanel *Cam14ColorInfoPanel;
  TPanel *Cam16ColorInfoPanel;
  TPanel *Cam16ColorValuePanel;
  TTntLabel *SideFaceTabletRColorLabelCam15;
  TTntLabel *SideFaceTabletGColorLabelCam15;
  TTntLabel *SideFaceTabletBColorLabelCam15;
  TTntShape *SideColorShapeCam15;
  TPanel *Cam15ColorInfoPanel;
  TPanel *Cam15ColorValuePanel;
  TTntLabel *SideFaceTabletRColorLabelCam16;
  TTntLabel *SideFaceTabletGColorLabelCam16;
  TTntLabel *SideFaceTabletBColorLabelCam16;
  TTntShape *SideColorShapeCam16;
  TTntButton *TntButton1;
  TPanel *Panel143;
  TCheckBox *SimulationInspectionCheckBox;
  TEdit *spbIndexEdit;
  TPanel *CamNamePanel2;
	void __fastcall StudyStartButtonClick(TObject *Sender);
	void __fastcall StudyStopButtonClick(TObject *Sender);
	void __fastcall StudyResultTimerTimer(TObject *Sender);
	void __fastcall StudyCountEditClick(TObject *Sender);
    void __fastcall FormCreate(TObject *Sender);
	void __fastcall BrightnessTestButtonClick(TObject *Sender);
	void __fastcall BrightnessTestTimerTimer(TObject *Sender);
	void __fastcall CameraSelectPanelClick(TObject *Sender);
	void __fastcall StudyEnableButtonClick(TObject *Sender);
	void __fastcall ImageEvalStartButtonClick(TObject *Sender);
	void __fastcall SetDiskBasisValueButtonClick(TObject *Sender);
	void __fastcall FormClose(TObject *Sender, TCloseAction &Action);
	void __fastcall SecretPanelDblClick(TObject *Sender);
	void __fastcall CameraImageDblClick(TObject *Sender);
	void __fastcall CloseButtonClick(TObject *Sender);
	void __fastcall StudyCountSetLabelDblClick(TObject *Sender);
  void __fastcall TLMenuPanelDblClick(TObject *Sender);
  void __fastcall TntFormActivate(TObject *Sender);
private:	// User declarations
  TTabletStudyResultData finalStudyResultData;
  TTabletStudyResultData lastStudyResultData;

	int StudyCount;
	TStudyResultData_SPB FinalStudyResult[SYSTEM_TOTAL_CAMERA_COUNT];
	bool StudyComplete[SYSTEM_TOTAL_CAMERA_COUNT];
	bool IsBrightnessCheckMode;
	ECameraTestStatus CameraTestStatus[TOTAL_CHECKING_CAMERA_COUNT];
	int CameraEvalValue[TOTAL_CHECKING_CAMERA_COUNT];
	int CurrentCamGlobalIndex;
	int CurrentCamListIndex;
	int ImageEvalCount;

  int PastStudyComplete;
  int CurrentStudyComplete;

  int ImageWidth;
  int ImageHeight;

  int SourceImageWidth[2];
  int SourceImageHeight[2];
  int rate[2];

  unsigned int ImageEvalSum;
  bool IsTwoColor;

  bool __fastcall SendStudySetupData(void);
  void __fastcall ProcessStudyResult(void);
	int __fastcall Optimal_Threshold(unsigned short *histo, int st_gray, int end_gray, int *grayMean, int option);
	int __fastcall Mean(unsigned short *data, int st_index, int end_index);

	void __fastcall RefreshBrightnessTestStatus(void);
	void __fastcall CaptureSetup(void);
	bool __fastcall SendSPBCaptureSetup(void);
  void __fastcall SetSPBVirtualInspectionImage();
	unsigned int __fastcall EvalBitmap(Graphics::TBitmap *srcBitmap, int *center);
	void __fastcall SendStudyReadyCommand(int disk1TargetSpeed, int disk1BaseSpeed,
	int disk2TargetSpeed, int disk2BaseSpeed);

  void __fastcall GetDefaultString();

  int ThreeDParamSetSatus[2];
public:		// User declarations
	__fastcall TStudyForm(TComponent* Owner);
};
//---------------------------------------------------------------------------
extern PACKAGE TStudyForm *StudyForm;
//---------------------------------------------------------------------------
#endif
