//---------------------------------------------------------------------------

#ifndef TPBCameraSetting_FormH
#define TPBCameraSetting_FormH
//---------------------------------------------------------------------------
#include <Classes.hpp>
#include <Controls.hpp>
#include <StdCtrls.hpp>
#include <Forms.hpp>
#include "TntStdCtrls.hpp"
#include <ComCtrls.hpp>
#include <ExtCtrls.hpp>
#include "Environment.h"
#include <list.h>
#include <Buttons.hpp>
#include "TntExtCtrls.hpp"
#include "TntGrids.hpp"
#include <Grids.hpp>
#include "TntComCtrls.hpp"
#include "TntButtons.hpp"

#define MAX_BUFFERING_IMAGE_WAITING_TIME  5
#define MAX_CAMERA_FPS  50
#define MAX_IMAGE_RECORD_MINUATE  3
#define MAX_SAVE_IMAGE_COUNT 10000 //(MAX_CAMERA_FPS * MAX_IMAGE_RECORD_MINUATE * 60)

#define FREE_IMG_UPLOAD						0
#define DEFECT_IMG_UPLOAD_ONLY		1	
//---------------------------------------------------------------------------

typedef struct
{
  int ImageIndex;
  double time;
  int ImageWidth;
  int ImageHeight;
}TTPBImageContainerHeader;

typedef struct
{
  TTPBImageContainerHeader Header;
  unsigned char CapturedImage[SYSTEM_CAMERA_WIDTH * SYSTEM_CAMERA_HEIGHT];
}TTPBImageContainer;
//---------------------------------------------------------------------------
class TTPBCameraSettingForm : public TForm
{
__published:	// IDE-managed Components
  TTimer *ParamsInputTimer;
  TTimer *ImageLoadTimer;
  TTimer *ImageViewTimer;
  TPanel *Panel1;
  TGroupBox *GroupBox1;
  TTntLabel *FPSLabel;
  TShape *BoundaryShape1;
  TShape *BoundaryShape2;
  TTntLabel *TntLabel8;
  TTntLabel *TntLabel9;
  TTntLabel *TntLabel10;
  TTntLabel *TntLabel13;
  TTntLabel *TntLabel14;
  TTntLabel *TntLabel15;
  TTntLabel *TntLabel16;
  TTntLabel *TntLabel11;
  TTntLabel *TntLabel12;
  TTntLabel *TntLabel17;
  TTntLabel *TntLabel18;
  TTntLabel *TntLabel19;
  TTntLabel *TntLabel20;
  TTntLabel *TntLabel21;
  TTntLabel *TntLabel22;
  TTntLabel *TntLabel23;
  TTntLabel *TntLabel24;
  TTrackBar *VideoTrackBar;
  TPanel *Panel2;
  TPanel *Panel3;
  TBitBtn *VideoPlayBtn;
  TBitBtn *VideoStopBtn;
  TRadioButton *RadioButton1;
  TRadioButton *RadioButton2;
  TRadioButton *RadioButton3;
  TRadioButton *RadioButton4;
  TRadioButton *RadioButton5;
  TRadioButton *RadioButton6;
  TPanel *Panel4;
  TImage *Image1;
  TGroupBox *GroupBox3;
  TTntButton *CloseButton;
  TGroupBox *GroupBox6;
  TTntLabel *TntLabel1;
  TTntLabel *TntLabel2;
  TTntEdit *BoardIDEdit;
  TTntEdit *CameraIDEdit;
  TCheckBox *IPBTestCheckBox;
  TRadioButton *RadioButton7;
  TTimer *CaptureTriggerTimer;
  TRadioButton *RadioButton8;
  TButton *FrameShiftBtn2;
  TButton *FrameShiftBtn1;
  TPanel *InsAreaSettingPanel;
  TImage *AreaSetImage;
  TGroupBox *InsSettingBox;
  TTntButton *InsAreaSettingButton;
  TTntButton *AreaSetOKButton;
  TSpeedButton *SpeedButton1;
  TSpeedButton *SpeedButton2;
  TSpeedButton *SpeedButton3;
  TSpeedButton *SpeedButton4;
  TTntLabel *TntLabel25;
  TTntLabel *TntLabel26;
  TTntLabel *TntLabel27;
  TTntLabel *TntLabel28;
  TTntLabel *TntLabel29;
  TTntLabel *MinYValue;
  TTntLabel *MinXValue;
  TTntLabel *MaxYValue;
  TTntLabel *MaxXValue;
  TPanel *Panel5;
  TTimer *tmrHCBRead;
  TTntButton *TntButton4;
  TTimer *tmrTPBInsData;
  TTimer *tmrChkCPBProcess;
  TTntPanel *pnTPBProcessInfo;
  TTntPageControl *pcTPBInfo;
  TTntTabSheet *TntTabSheet1;
  TTntPanel *pnMisEject;
  TTntEdit *eReadHCB;
  TTntButton *TntButton1;
  TTntButton *TntButton2;
  TTntEdit *eTest01;
  TTntEdit *eReturnTestVal;
  TTntButton *TntButton3;
  TTntStringGrid *StringGrid1;
  TTntButton *TntButton5;
  TTntButton *TntButton6;
  TTntEdit *eTimerInterval;
  TTntTabSheet *TntTabSheet2;
  TTntPanel *TntPanel1;
  TTntStringGrid *sgCPBProcess;
  TTntButton *btnCPBProcReadOn;
  TTntButton *btnCPBProcReadOff;
  TTntEdit *eTmrChkCPBProcess;
  TTntLabel *TntLabel30;
  TTntLabel *TntLabel31;
  TTntLabel *TntLabel32;
  TTntLabel *TntLabel33;
  TTntLabel *TntLabel34;
  TTntLabel *TntLabel35;
  TTntGroupBox *TntGroupBox1;
  TTntCheckBox *ckbFreeUploadMode;
  TGroupBox *GroupBox10;
  TGroupBox *GroupBox11;
  TLabel *ThresholdLabel;
  TTrackBar *ThresholdTrackBar;
  TButton *Button1;
  TTntTabSheet *TntTabSheet3;
  TTntPanel *TntPanel2;
  TTntGroupBox *TntGroupBox7;
  TTntLabel *TntLabel36;
  TTntLabel *TntLabel37;
  TTntLabel *TntLabel38;
  TTntEdit *eTPB_MisOpenRunTime;
  TTntEdit *eTPB_MisOpenDelayTime;
  TTntCheckBox *ckbTPB_Active;
  TTntEdit *eTPB_MisCmdValidCnt;
  TTntCheckBox *ckbMultiMisejectAction;
  TTntBitBtn *BitBtn1;
  TTntGroupBox *TntGroupBox2;
  TTntEdit *eCaptureDelay_Min;
  TTntEdit *eCaptureDelay_Max;
  TTntLabel *TntLabel39;
  TTntLabel *TntLabel40;
  TGroupBox *GroupBox7;
  TTntButton *MachineControlButton;
  TTntButton *btnTPBSetup;
  TGroupBox *GroupBox4;
  TTntButton *HCBCaptureButton;
  TTntButton *TPBCaptureButton;
  TGroupBox *GroupBox9;
  TRadioButton *ImageScaleRadioButton1;
  TRadioButton *ImageScaleRadioButton2;
  TRadioButton *ImageScaleRadioButton3;
  TGroupBox *GroupBox2;
  TTntLabel *TntLabel3;
  TTntLabel *TntLabel4;
  TTntEdit *ShutterSpeedEdit;
  TTntEdit *CameraGainEdit;
  TGroupBox *GroupBox8;
  TTntLabel *TntLabel5;
  TTntLabel *TntLabel6;
  TTntLabel *TntLabel7;
  TTrackBar *WhiteBalanceBValue;
  TTrackBar *WhiteBalanceGValue;
  TTrackBar *WhiteBalanceRValue;
  TTntEdit *WhiteBalanceBValueEdit;
  TTntEdit *WhiteBalanceGValueEdit;
  TTntEdit *WhiteBalanceRValueEdit;
  TGroupBox *GroupBox5;
  TTntLabel *Label12;
  TTntLabel *Label13;
  TTntEdit *LedOnTimeEdit;
  TTntEdit *FrameTimeEdit;
  TTntPanel *HiddenPanel;
  TTntCheckBox *ckbTPB_MisejectOperationMode;
  TTntButton *TntButton7;
  void __fastcall NumEditClick(TObject *Sender);
  void __fastcall WhiteBalanceRValueEditClick(TObject *Sender);
  void __fastcall WhiteBalanceValueChange(TObject *Sender);
  void __fastcall BoardIDEditKeyPress(TObject *Sender, char &Key);
  void __fastcall ParamsInputTimerTimer(TObject *Sender);
  void __fastcall MachineControlButtonClick(TObject *Sender);
  void __fastcall HCBCaptureButtonClick(TObject *Sender);
  void __fastcall CloseButtonClick(TObject *Sender);
  void __fastcall ImageLoadTimerTimer(TObject *Sender);
  void __fastcall FormCreate(TObject *Sender);
  void __fastcall BoundaryShape1MouseDown(TObject *Sender, TMouseButton Button,
          TShiftState Shift, int X, int Y);
  void __fastcall BoundaryShape1MouseUp(TObject *Sender, TMouseButton Button,
          TShiftState Shift, int X, int Y);
  void __fastcall BoundaryShape2MouseDown(TObject *Sender, TMouseButton Button,
          TShiftState Shift, int X, int Y);
  void __fastcall BoundaryShape2MouseUp(TObject *Sender, TMouseButton Button,
          TShiftState Shift, int X, int Y);
  void __fastcall BoundaryShape1MouseMove(TObject *Sender, TShiftState Shift,
          int X, int Y);
  void __fastcall BoundaryShape2MouseMove(TObject *Sender, TShiftState Shift,
          int X, int Y);
  void __fastcall ImageViewTimerTimer(TObject *Sender);
  void __fastcall VideoTrackBarChange(TObject *Sender);
  void __fastcall VideoPlayBtnClick(TObject *Sender);
  void __fastcall VideoStopBtnClick(TObject *Sender);
  void __fastcall ImageScaleRadioButton1Click(TObject *Sender);
  void __fastcall FormDestroy(TObject *Sender);
  void __fastcall GroupBox4DblClick(TObject *Sender);
  void __fastcall CaptureTriggerTimerTimer(TObject *Sender);
  void __fastcall TPBCaptureButtonClick(TObject *Sender);
  void __fastcall FrameShiftBtn1Click(TObject *Sender);
  void __fastcall FrameShiftBtn2Click(TObject *Sender);
  void __fastcall InsAreaSettingButtonClick(TObject *Sender);
  void __fastcall AreaKindSelect(TObject *Sender);
  void __fastcall AreaSetImageMouseDown(TObject *Sender,
          TMouseButton Button, TShiftState Shift, int X, int Y);
  void __fastcall AreaSetOKButtonClick(TObject *Sender);
  void __fastcall tmrHCBReadTimer(TObject *Sender);
  void __fastcall TntButton1Click(TObject *Sender);
  void __fastcall TntButton2Click(TObject *Sender);
  void __fastcall TntButton3Click(TObject *Sender);
  void __fastcall TntButton4Click(TObject *Sender);
  void __fastcall tmrTPBInsDataTimer(TObject *Sender);
  void __fastcall TntButton5Click(TObject *Sender);
  void __fastcall TntButton6Click(TObject *Sender);
  void __fastcall btnCPBProcReadOnClick(TObject *Sender);
  void __fastcall btnCPBProcReadOffClick(TObject *Sender);
  void __fastcall tmrChkCPBProcessTimer(TObject *Sender);
  void __fastcall ThresholdTrackBarChange(TObject *Sender);
  void __fastcall Button1Click(TObject *Sender);
  void __fastcall BitBtn1Click(TObject *Sender);
  void __fastcall btnTPBSetupClick(TObject *Sender);
  void __fastcall HiddenPanelDblClick(TObject *Sender);
  void __fastcall pcTPBInfoChange(TObject *Sender);

private:	// User declarations
  void __fastcall RefreshCameraInfo();
  bool __fastcall SendSPBCaptureSetup(void);
  void __fastcall WriteTPBCameraInfo();
  void __fastcall ReadTPBCameraInfo();
  void __fastcall RemoveWholeDir(AnsiString folderName);
  void __fastcall RTImageView();
  void __fastcall AreaSettingImageShow();
  int __fastcall LabellingForTabletImage(short *label_Image, unsigned char *smallSizeBinaryImage, int startX, int endX, int startY, int endY, int imageWidth, int imageHeight);

  unsigned char CaptureData[SYSTEM_CAMERA_WIDTH * SYSTEM_CAMERA_HEIGHT];

  bool bOnCapture;

  double timerCheckTime;
  double CaptureStartTime;
  double instantCheckTime;
  double fpsVariance;
  double fpsValInst;

  bool bMouseDown;
  bool bVideoStop;
  bool bVideoPlay;

  POINT startMouse;
  POINT endMouse;

  int boundaryStartPos;
  bool InsAreaImageCheck;

  int AreaKind;
  TRect BoundaryArea;


public:		// User declarations

  AnsiString foldername;

  bool bExeDownloadThread;
  bool bExeVideoThread;
  double LastFrameDownloadTime;

  unsigned char VideoImage[SYSTEM_CAMERA_WIDTH * SYSTEM_CAMERA_HEIGHT];
  int VideoWidth;
  int VideoHeight;

  Graphics::TBitmap *tempImage;
  Graphics::TBitmap *lastImage;
  TTPBCameraParams TPBCameraParams;

  int ImageSettingWidth;
  int ImageSettingHeight;
  int ImageScaleFactor;
  int BoardRemainingImageCount;
  int BoardMaxBufferCount;
  int LastImageDisplayCount;
  int ReceivedImageCount;
  int UploadFrameNumber;
  TTPBImageContainer TPBImageContainer;

  void __fastcall RefreshBounaryResult();
  __fastcall TTPBCameraSettingForm(TComponent* Owner);

  bool uploading;

  unsigned int data[4];
	unsigned int receivedData[2];

  bool CaptureTrigger;

  double captureStopTime;
  bool bCaptureStop;

  bool bExecUploadThread;

};
//---------------------------------------------------------------------------
extern PACKAGE TTPBCameraSettingForm *TPBCameraSettingForm;
//---------------------------------------------------------------------------
#endif
