//---------------------------------------------------------------------------

#ifndef TwoDCalibrationGuide_FormH
#define TwoDCalibrationGuide_FormH
//---------------------------------------------------------------------------
#include <Classes.hpp>
#include <Controls.hpp>
#include <StdCtrls.hpp>
#include <Forms.hpp>
#include "Capture_Frame.h"
#include "Common.h"
#include "TntButtons.hpp"
#include "TntExtCtrls.hpp"
#include "TntStdCtrls.hpp"
#include <Buttons.hpp>
#include <ExtCtrls.hpp>
#include "TntForms.hpp"
#include "AdvMachineControl_Form.h"
#include "TntComCtrls.hpp"
#include <ComCtrls.hpp>

#define MAX_IMAGE_WIDTH 640
#define MAX_IMAGE_HEIGHT 480

#define PROCESS_CAMERA_POSITION 0
#define PROCESS_WHITE_BALANCE 1

#define AREA_BACK 0
#define AREA_SIDE 1
#define AREA_FRONT 2

#define ALLCAM 0
#define FIRSTDISK 1
#define SECONDDISK 2

#define FirstDiskStart 0
#define FirstDiskValueSet 1
#define SecondDiskStart 2
#define SecondDiskValueSet 3
#define Final 4
#define NoneStart 5

#define GGradeCount 1

#define DOWNSW 0
#define UPSW 1
//---------------------------------------------------------------------------
typedef struct
{
  int X;
  int Y;
}TSideFaceLine;

typedef struct
{
  int CenterX;
  int CenterY;
  int Alpa;
  int Beta;
  int XD;
  int YD;
  int XD2;
  int YD2;
  int TestAlpa;
  int TestBeta;

}TCenterPosition;

typedef struct
{
  int minX;
  int maxX;
  double ProductWidth;
  double ProductHeight;
  int FOV;
  int fminX;
  int fmaxX;

}TVerifyFOVInform;

class TTwoDCalibrationGuideForm : public TTntForm
{
__published:	// IDE-managed Components
  TTntPanel *TitlePanel;
  TTntLabel *TwoDCalibrationGuideLabel;
  TTntBitBtn *CloseButton;
  TTntGroupBox *GroupBox4;
  TTntCheckBox *LEDCheckBox1;
  TTntCheckBox *LEDCheckBox2;
  TTntCheckBox *LEDCheckBox3;
  TTntCheckBox *LEDCheckBox4;
  TTntCheckBox *LEDCheckBox5;
  TTntCheckBox *LEDCheckBox6;
  TTntCheckBox *LEDCheckBox7;
  TTntCheckBox *LEDCheckBox8;
  TTntCheckBox *LEDCheckBox9;
  TTntCheckBox *LEDCheckBox10;
  TTntCheckBox *LEDCheckBox11;
  TTntCheckBox *LEDCheckBox12;
  TTimer *DiskImageLoadTimer;
  TTntGroupBox *GuideOption;
  TTntCheckBox *ProductGuideLine;
  TTntEdit *FovSize;
  TTntSpeedButton *ShowGuideLine;
  TTntImage *RedImage;
  TTntImage *GreenImage;
  TTntImage *BlueImage;
  TTntPanel *WhiteBalanceSetPanel;
  TGroupBox *GroupBox5;
  TLabel *CameraNumberLabel;
  TTntLabel *TntLabel22;
  TTntLabel *TntLabel23;
  TTntLabel *TntLabel24;
  TTrackBar *WhiteBalanceBValue;
  TTrackBar *WhiteBalanceGValue;
  TTrackBar *WhiteBalanceRValue;
  TTntEdit *WhiteBalanceBValueEdit;
  TTntEdit *WhiteBalanceGValueEdit;
  TTntEdit *WhiteBalanceRValueEdit;
  TTntEdit *ProductWidthEdit;
  TTntLabel *TntLabel41;
  TTntLabel *TntLabel42;
  TTntImage *CAMImage9;
  TTntImage *CAMImage10;
  TTntImage *CAMImage11;
  TTntImage *CAMImage12;
  TTntImage *CAMImage14;
  TTntImage *CAMImage15;
  TTntImage *CAMImage16;
  TTntLabel *CamLabel9;
  TTntLabel *CamLabel10;
  TTntLabel *CamLabel11;
  TTntLabel *CamLabel14;
  TTntLabel *CamLabel15;
  TTntLabel *CamLabel12;
  TTntLabel *CamLabel16;
  TTntImage *SecondDiskSelectImage;
  TTntPanel *SecondDiskPanel;
  TTntPanel *FirstDiskPanel;
  TTntImage *CAMImage6;
  TTntImage *CAMImage7;
  TTntImage *CAMImage8;
  TTntImage *CAMImage4;
  TTntImage *CAMImage3;
  TTntImage *CAMImage2;
  TTntImage *CAMImage1;
  TTntLabel *CamLabel4;
  TTntLabel *CamLabel8;
  TTntLabel *CamLabel7;
  TTntLabel *CamLabel6;
  TTntLabel *CamLabel1;
  TTntLabel *CamLabel3;
  TTntLabel *CamLabel2;
  TTntImage *FirstDiskSelectImage;
  TTntEdit *ProductHeightEdit;
  TTntLabel *TntLabel60;
  TTntPanel *ResultPanel;
  TTntButton *VerifyOkButton;
  TTntButton *StartButton1;
  TTntPanel *TntPanel1;
  TTntGroupBox *RGBValueBox;
  TTntGroupBox *PositionVerifyGroupBox1;
  TTntLabel *TntLabel3;
  TTntLabel *TntLabel5;
  TTntLabel *TntLabel6;
  TTntLabel *TntLabel7;
  TTntLabel *TntLabel8;
  TTntLabel *TntLabel9;
  TTntLabel *TntLabel10;
  TTntLabel *TntLabel11;
  TTntLabel *TntLabel12;
  TTntLabel *Cam1LRLabel;
  TTntLabel *Cam2LRLabel;
  TTntLabel *Cam3LRLabel;
  TTntLabel *Cam4LRLabel;
  TTntLabel *Cam6LRLabel;
  TTntLabel *Cam7LRLabel;
  TTntLabel *Cam8LRLabel;
  TTntLabel *Cam1UBLabel;
  TTntLabel *Cam2UBLabel;
  TTntLabel *Cam3UBLabel;
  TTntLabel *Cam4UBLabel;
  TTntLabel *Cam6UBLabel;
  TTntLabel *Cam7UBLabel;
  TTntLabel *Cam8UBLabel;
  TTntLabel *TntLabel74;
  TTntLabel *Cam1GradeLabel;
  TTntLabel *Cam2GradeLabel;
  TTntLabel *Cam3GradeLabel;
  TTntLabel *Cam4GradeLabel;
  TTntLabel *Cam6GradeLabel;
  TTntLabel *Cam7GradeLabel;
  TTntLabel *Cam8GradeLabel;
  TTntLabel *TntLabel82;
  TTntLabel *TntLabel83;
  TTntLabel *FOV1;
  TTntLabel *FOV2;
  TTntLabel *FOV3;
  TTntLabel *FOV6;
  TTntLabel *FOV7;
  TTntLabel *FOV8;
  TTntLabel *FOV4;
  TTntLabel *Cam1GradeValueLabel;
  TTntLabel *Cam2GradeValueLabel;
  TTntLabel *Cam3GradeValueLabel;
  TTntLabel *Cam4GradeValueLabel;
  TTntLabel *Cam6GradeValueLabel;
  TTntLabel *Cam7GradeValueLabel;
  TTntLabel *Cam8GradeValueLabel;
  TTntLabel *InclineLabel3;
  TTntLabel *InclineLabel7;
  TTntGroupBox *TntGroupBox3;
  TTntLabel *TntLabel25;
  TTntLabel *TntLabel26;
  TTntEdit *RB1InverterSpeedEdit1;
  TTntEdit *RB2InverterSpeedEdit1;
  TLabel *Label1;
  TTimer *ValueSetTimer;
  TTntPanel *EPanel;
  TTntPanel *ProcessingPanel;
  TTntPanel *TntPanel5;
  TTntPanel *TntPanel6;
  TTntPanel *TntPanel7;
  TTntPanel *TntPanel8;
  TTntPanel *TntPanel9;
  TTntPanel *TntPanel10;
  TTntPanel *TntPanel11;
  TTntPanel *TntPanel12;
  TTntPanel *TntPanel13;
  TTntPanel *TntPanel14;
  TTntPanel *TntPanel15;
  TTntPanel *TntPanel16;
  TTntPanel *TntPanel17;
  TTntPanel *TntPanel18;
  TLabel *Label100;
  TPanel *DiskSelectPanel;
  TTntSpeedButton *Disk1SpeedButton;
  TTntSpeedButton *Disk2SpeedButton;
  TPanel *Panel2;
  TPanel *Panel3;
  TLabel *Label2;
  TLabel *Label3;
  TLabel *Label4;
  TLabel *Label5;
  TLabel *Label6;
  TLabel *Label7;
  TLabel *Label8;
  TPanel *Panel4;
  TPanel *Panel5;
  TLabel *Label9;
  TLabel *Label10;
  TLabel *Label11;
  TPanel *Panel6;
  TTntGroupBox *PositionVerifyGroupBox2;
  TLabel *Label12;
  TLabel *Label13;
  TTntLabel *Cam9LRLabel;
  TTntLabel *Cam10LRLabel;
  TTntLabel *Cam11LRLabel;
  TTntLabel *Cam12LRLabel;
  TTntLabel *Cam14LRLabel;
  TTntLabel *Cam15LRLabel;
  TTntLabel *Cam16LRLabel;
  TTntLabel *Cam9UBLabel;
  TTntLabel *Cam10UBLabel;
  TTntLabel *Cam11UBLabel;
  TTntLabel *Cam12UBLabel;
  TTntLabel *Cam14UBLabel;
  TTntLabel *Cam15UBLabel;
  TTntLabel *Cam16UBLabel;
  TTntLabel *Cam9GradeLabel;
  TTntLabel *Cam10GradeLabel;
  TTntLabel *Cam11GradeLabel;
  TTntLabel *Cam12GradeLabel;
  TTntLabel *Cam14GradeLabel;
  TTntLabel *Cam15GradeLabel;
  TTntLabel *Cam16GradeLabel;
  TTntLabel *FOV9;
  TTntLabel *FOV10;
  TTntLabel *FOV11;
  TTntLabel *FOV14;
  TTntLabel *FOV15;
  TTntLabel *FOV16;
  TTntLabel *FOV12;
  TTntLabel *Cam9GradeValueLabel;
  TTntLabel *Cam10GradeValueLabel;
  TTntLabel *Cam11GradeValueLabel;
  TTntLabel *Cam12GradeValueLabel;
  TTntLabel *Cam14GradeValueLabel;
  TTntLabel *Cam15GradeValueLabel;
  TTntLabel *Cam16GradeValueLabel;
  TTntLabel *InclineLabel11;
  TTntLabel *InclineLabel15;
  TLabel *Label14;
  TLabel *Label15;
  TLabel *Label16;
  TLabel *Label17;
  TLabel *Label18;
  TPanel *Panel7;
  TTntLabel *TntLabel88;
  TTntLabel *TntLabel89;
  TTntLabel *TntLabel90;
  TTntLabel *TntLabel91;
  TTntLabel *TntLabel94;
  TPanel *Panel8;
  TTntLabel *TntLabel95;
  TTntLabel *TntLabel96;
  TTntLabel *TntLabel97;
  TTntLabel *TntLabel98;
  TTntLabel *TntLabel99;
  TTntLabel *TntLabel100;
  TTntLabel *TntLabel101;
  TTntLabel *TntLabel102;
  TLabel *UBEXLabel;
  TLabel *LREXLabel;
  TTntLabel *TntLabel1;
  TPanel *UBLREXPanel;
  TTntImage *TntImage1;
  TTntLabel *TntLabel2;
  TTntLabel *TntLabel4;
  TTntLabel *TntLabel13;
  TTntLabel *TntLabel14;
  TTntLabel *TntLabel15;
  TTntLabel *TntLabel16;
  TTntLabel *TntLabel17;
  TTntLabel *TntLabel18;
  TTntLabel *TntLabel19;
  TTntLabel *TntLabel20;
  TTntPanel *DiskPanel;
  void __fastcall CloseButtonClick(TObject *Sender);
  void __fastcall RBOnSpeedButton1Click(TObject *Sender);
  void __fastcall RBOffSpeedButton1Click(TObject *Sender);
  void __fastcall RB1InverterSpeedEdit11Change(TObject *Sender);
  void __fastcall RB2InverterSpeedEdi1t1Change(TObject *Sender);
  void __fastcall RB1InverterSpeedEdit11Click(TObject *Sender);
  void __fastcall DiskImageLoadTimerTimer(TObject *Sender);

  void __fastcall FormCreate(TObject *Sender);
  void __fastcall SubCaptureFrameCaptureCheckTimerTimer(TObject *Sender);
  void __fastcall Cam1ButtonClick(TObject *Sender);


  void __fastcall FovSizeClick(TObject *Sender);
  void __fastcall VerifyOkButtonClick(TObject *Sender);
  void __fastcall WhiteBalanceRValueChange(TObject *Sender);
  void __fastcall WhiteBalanceGValueChange(TObject *Sender);
  void __fastcall WhiteBalanceBValueChange(TObject *Sender);
  void __fastcall WhiteBalanceRValueEditClick(TObject *Sender);
  void __fastcall CaptureImageMouseMove(TObject *Sender, TShiftState Shift,
          int X, int Y);
  void __fastcall FrontCamButtonClick(TObject *Sender);
  void __fastcall sleeptimeEditClick(TObject *Sender);
  void __fastcall SaveDefaultShutterSpeedButtonClick(TObject *Sender);
  void __fastcall ShutterSpeedEdit1Change(TObject *Sender);
  void __fastcall CameraGainEdit1Change(TObject *Sender);
  void __fastcall ShutterSpeedEdit1Click(TObject *Sender);
  void __fastcall LoadSystemDefaultButtonClick(TObject *Sender);
  void __fastcall SaveProductShutterSpeedButtonClick(TObject *Sender);
  void __fastcall CameraImage1Click(TObject *Sender);
  void __fastcall FirstDiskSelectImageMouseDown(TObject *Sender,
          TMouseButton Button, TShiftState Shift, int X, int Y);
  void __fastcall SecondDiskSelectImageMouseDown(TObject *Sender,
          TMouseButton Button, TShiftState Shift, int X, int Y);
  void __fastcall StartButton1Click(TObject *Sender);
  void __fastcall ValueSetTimerTimer(TObject *Sender);
  void __fastcall Disk1SpeedButtonClick(TObject *Sender);
  void __fastcall Disk2SpeedButtonClick(TObject *Sender);
  void __fastcall TntImage1Click(TObject *Sender);
  void __fastcall FormActivate(TObject *Sender);

private:	// User declarations
  TMachineControlParams MachineControlParams;
  TTntImage *DestImage;
  TPoint MousePos;
  TSideFaceLine SideFaceLine[4]; 
  TCenterPosition CenterPosition[SYSTEM_TOTAL_CAMERA_COUNT];
  TVerifyFOVInform VerifyFOVInform[SYSTEM_TOTAL_CAMERA_COUNT];

  bool bOnCapture;
  int GlobalCameraIndex;
  unsigned int LEDOnMask[SYSTEM_TOTAL_CAMERA_COUNT];
  int CAM_Width;
  int CAM_Height;
  int cam1,cam2,cam3,cam4;
  int VerifyCamNum;
  int whiteBalance[3];
  int ShutterSpeedList[SYSTEM_TOTAL_CAMERA_COUNT];
  unsigned char SubsamplingModeList[SYSTEM_TOTAL_CAMERA_COUNT];
  unsigned char CaptureData[MAX_IMAGE_WIDTH * MAX_IMAGE_HEIGHT];
  unsigned char CaptureData0[MAX_IMAGE_WIDTH * MAX_IMAGE_HEIGHT];
  int NextCount[5][16];

  int Process;
  int DigitalGainList[SYSTEM_TOTAL_CAMERA_COUNT];
  int ActiveCameraNumber;
  int ImageLoadType;
  TTntImage *ActiveCameraImage;

  int testCheck;
  int DistanceChange;
  int alpa, beta, YD,YD2,XD,XD2;
  int GradeCheck[SYSTEM_TOTAL_CAMERA_COUNT][10];
  int GradeCheckNum[SYSTEM_TOTAL_CAMERA_COUNT];
  int GradeNext[SYSTEM_TOTAL_CAMERA_COUNT];
  int CheckgreenVal;
  int ChangeCameraCheck;
  int ActiveCameraSW;
  int BeforeSW;
  int stepSW;
  unsigned char EdgeArea[640*480];
  int InclineCheck[SYSTEM_TOTAL_CAMERA_COUNT];
  int CheckRedVal[SYSTEM_TOTAL_CAMERA_COUNT];
  int CheckBlueVal[SYSTEM_TOTAL_CAMERA_COUNT];

  int RDownSW[SYSTEM_TOTAL_CAMERA_COUNT];
  int RUpSW[SYSTEM_TOTAL_CAMERA_COUNT];
  int BDownSW[SYSTEM_TOTAL_CAMERA_COUNT];
  int BUpSW[SYSTEM_TOTAL_CAMERA_COUNT];

  int RValue[SYSTEM_TOTAL_CAMERA_COUNT];
  int BValue[SYSTEM_TOTAL_CAMERA_COUNT];
  int RValueChangeSW[SYSTEM_TOTAL_CAMERA_COUNT];
  int BValueChangeSW[SYSTEM_TOTAL_CAMERA_COUNT];
  int RVChangeSW[SYSTEM_TOTAL_CAMERA_COUNT];
  int BVChangeSW[SYSTEM_TOTAL_CAMERA_COUNT];
  int RValueList[SYSTEM_TOTAL_CAMERA_COUNT];
  int BValueList[SYSTEM_TOTAL_CAMERA_COUNT];
  int RFinalValueSW[SYSTEM_TOTAL_CAMERA_COUNT];
  int BFinalValueSW[SYSTEM_TOTAL_CAMERA_COUNT];
  int GreenValue[SYSTEM_TOTAL_CAMERA_COUNT];
  int CheckGreenVal;
  int panelCount;



  int L1[SYSTEM_TOTAL_CAMERA_COUNT];
  int R1[SYSTEM_TOTAL_CAMERA_COUNT];
  int B1[SYSTEM_TOTAL_CAMERA_COUNT];
  int U1[SYSTEM_TOTAL_CAMERA_COUNT];

  void __fastcall ChangeCamera(void);
  void __fastcall RefreshLEDCheckBox(void);
  bool __fastcall SendSPBCaptureSetup(void);
  void __fastcall RefreshCameraInfo(int cameraIndex);
  void __fastcall LEDAllOn(void);
  void __fastcall InitCaptureComponent();
  void __fastcall InitCaptureComponent1();
  void __fastcall RefreshSubImage(void);
  void __fastcall RefreshPixelInfo(int X, int Y);
  void __fastcall RefreshPixelInfo1(int X, int Y, int globalCameraIndex);
  void __fastcall LoadSystemInfor(void);
  void __fastcall FindSideFaceLine(void);
  int __fastcall LabellingForTabletImage(short *label_Image, unsigned char *smallSizeBinaryImage, int startX, int endX, int startY, int endY, int imageWidth, int imageHeight);
  void __fastcall CaptureStop();
  void __fastcall PositionVerification(void);
  void __fastcall PositionVerificationForAllCam(int globalcameraIndex);
  void __fastcall GradeGVerify(int globalCameraIndex);
  void __fastcall FindAlpa(int ActiveCameraNumber);
  void __fastcall TrackCenterPosition(int ActiveCameraNumber);
  void __fastcall HorizontalVerification(int globalCameraIndex);
  void __fastcall PixelInformation(int X, int Y, int CameraNumber);
  void __fastcall SetRedValue(int Value, int CamIndex);
  void __fastcall SetBlueValue(int Value, int CamIndex);
  void __fastcall ImageInitBlue(void);
  void __fastcall RGBImageInit(void);

public:		// User declarations
  __fastcall TTwoDCalibrationGuideForm(TComponent* Owner);
  unsigned char ColorSourceImage[HD_IMAGE_WIDTH * HD_IMAGE_HEIGHT * 3];
  void __fastcall SetWhiteBalanceValue(int Value, int rgbIndex);
 // void __fastcall SetCaptureProperty(int captureWidth, int captureHeight, TTntImage *destImage, TPixelFormat pixelFormat);
};
//---------------------------------------------------------------------------
extern PACKAGE TTwoDCalibrationGuideForm *TwoDCalibrationGuideForm;
//---------------------------------------------------------------------------
#endif
