//---------------------------------------------------------------------------
// For SELMA200, 20180221, moon, Ϸ
// ī޶ ε,   Ͽ Form Design  Property 
//---------------------------------------------------------------------------

#include <vcl.h>
#pragma hdrstop

#include "VisionSetting_Form.h"
#include "Environment.h"
#include "SystemSetup.h"
#include "Keyboard_Form.h"
#include "MultiLanguage.h"

//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma link "TntButtons"
#pragma link "TntExtCtrls"
#pragma link "TntStdCtrls"
#pragma resource "*.dfm"
TVisionSettingForm *VisionSettingForm;
//---------------------------------------------------------------------------
__fastcall TVisionSettingForm::TVisionSettingForm(TComponent* Owner)
	: TTntForm(Owner)
{
  if(DefaultLCID == 1028 || DefaultLCID == 2052 || DefaultLCID == 3076 || DefaultLCID == 4100)
    ComponentSetFontName(this, "SimSun");
  else if(DefaultLCID == 1041)
    ComponentSetFontName(this, "Meiryo UI");
  else if(DefaultLCID == 3082)
  {
    ComponentSetFontName(this, "Segoe UI");
    ComponentSetMultiLine(this);
  }

  GetDefaultString();
	CurrentCaptureIndex = 0;
	UpdateMachineCaptureInfo();
	for (int captureIndex = 0; captureIndex < SYSTEM_MACHINE_CAPTURE_COUNT; captureIndex++)
	{
		TTntEdit *illuminatorDelayEdit = (TTntEdit *) FindComponent("IlluminatorDelayEdit" + IntToStr(captureIndex + 1));
		illuminatorDelayEdit->Text = FloatToStr(MachineCaptureInfo.IlluminatorDelay[captureIndex] / 20.0);
		TTntEdit *illuminatorOnTimeEdit = (TTntEdit *) FindComponent("IlluminatorOnTimeEdit" + IntToStr(captureIndex + 1));
		illuminatorOnTimeEdit->Text = FloatToStr(MachineCaptureInfo.IlluminatorTime[captureIndex] / 20.0);
		illuminatorOnTimeEdit->Enabled = true;
	}
	GroupBox6->Visible = true;
	if(Machine.Status.SuctionDisk1LampKind == MACHINE_LAMP_KIND_SUGAR_COATED_TABLET || Machine.Status.SuctionDisk2LampKind ==MACHINE_LAMP_KIND_SUGAR_COATED_TABLET)
	{
		for (int captureIndex = 0; captureIndex < SYSTEM_MACHINE_CAPTURE_COUNT; captureIndex++)
		{
			TTntEdit *illuminatorOnTimeEdit = (TTntEdit *) FindComponent("IlluminatorOnTimeEdit" + IntToStr(captureIndex + 1));
			illuminatorOnTimeEdit->Enabled = false;
		}
		GroupBox6->Visible = false;
	}
}
//---------------------------------------------------------------------------
void __fastcall TVisionSettingForm::GetDefaultString()
{
  CaptureSettingSpeedButton1->Caption = VISIONSETTINGFORM_BUTTON_CAPTION_01;
  CaptureSettingSpeedButton2->Caption = VISIONSETTINGFORM_BUTTON_CAPTION_02;
  CaptureSettingSpeedButton3->Caption = VISIONSETTINGFORM_BUTTON_CAPTION_03;
  CaptureSettingSpeedButton4->Caption = VISIONSETTINGFORM_BUTTON_CAPTION_04;
  CaptureSettingSpeedButton5->Caption = VISIONSETTINGFORM_BUTTON_CAPTION_05;
  CaptureSettingSpeedButton6->Caption = VISIONSETTINGFORM_BUTTON_CAPTION_06;

  GroupBox3->Caption = VISIONSETTINGFORM_GROUPBOX_CAPTION_01;
  GroupBox4->Caption = VISIONSETTINGFORM_GROUPBOX_CAPTION_02;
  GroupBox2->Caption = VISIONSETTINGFORM_GROUPBOX_CAPTION_03;
  GroupBox6->Caption = VISIONSETTINGFORM_GROUPBOX_CAPTION_04;
  GroupBox1->Caption = VISIONSETTINGFORM_GROUPBOX_CAPTION_05;
  GroupBox7->Caption = VISIONSETTINGFORM_GROUPBOX_CAPTION_06;
  LEDModeRadioGroup->Caption = VISIONSETTINGFORM_RADIOGROUP_CAPTION_01;
  LEDModeRadioGroup->Items->Strings[0] = VISIONSETTINGFORM_RADIOGROUP_ITEM_01;
}
//---------------------------------------------------------------------------
void __fastcall TVisionSettingForm::LEDOnSpeedButtonClick(TObject *Sender)
{
	try
	{
		TTntSpeedButton *theButton = (TTntSpeedButton *)Sender;

		int ledIndex = theButton->Tag;
		int mode = 0;
		int interval1 = 0;
		int interval2 = 0;
		if (LEDModeRadioGroup->ItemIndex == 0)
		{
			mode = 0;
    }
	  else if (LEDModeRadioGroup->ItemIndex == 1)
	  {
			mode = 1;
			interval1 = StrToInt(IntervalEdit1->Text) * 20;
	  }
	  else if (LEDModeRadioGroup->ItemIndex == 2)
	  {
			mode = 2;
			interval1 = StrToInt(IntervalEdit1->Text) * 20;
			interval2 = StrToInt(IntervalEdit2->Text) * 20;
		}

		Machine.IlluminatorTestOn(ledIndex, mode, interval1, interval2);
  }
  catch(Exception &ec)
  {
  
  }
}
//---------------------------------------------------------------------------
void __fastcall TVisionSettingForm::LEDOffSpeedButtonClick(
      TObject *Sender)
{
	TTntSpeedButton *theButton = (TTntSpeedButton *)Sender;
	int ledIndex = theButton->Tag;

	Machine.IlluminatorTestOff(ledIndex);
}
//---------------------------------------------------------------------------
void __fastcall TVisionSettingForm::LEDAllOnSpeedButtonClick(
      TObject *Sender)
{
	int ledIndex = 0xFF;
	int mode = 0;
	int interval1 = 0;
	int interval2 = 0;
	if (LEDModeRadioGroup->ItemIndex == 0)
	{
		mode = 0;
	}
	else if (LEDModeRadioGroup->ItemIndex == 1)
	{
		mode = 1;
		interval1 = StrToInt(IntervalEdit1->Text) * 20;
	}
	else if (LEDModeRadioGroup->ItemIndex == 2)
	{
		mode = 2;
		interval1 = StrToInt(IntervalEdit1->Text) * 20;
		interval2 = StrToInt(IntervalEdit2->Text) * 20;
	}

	Machine.IlluminatorTestOn(ledIndex, mode, interval1, interval2);
}
//---------------------------------------------------------------------------
void __fastcall TVisionSettingForm::LEDAllOffSpeedButtonClick(
	  TObject *Sender)
{
	int ledIndex = 0xFF;

	Machine.IlluminatorTestOff(ledIndex);
}
//---------------------------------------------------------------------------
void __fastcall TVisionSettingForm::SetupButtonClick(TObject *Sender)
{
	try
	{
		MachineCaptureInfo.IlluminatorDelay[0] = StrToFloat(IlluminatorDelayEdit1->Text) * 20 + 0.5;
		MachineCaptureInfo.IlluminatorDelay[1] = StrToFloat(IlluminatorDelayEdit2->Text) * 20 + 0.5;
		MachineCaptureInfo.IlluminatorDelay[2] = StrToFloat(IlluminatorDelayEdit3->Text) * 20 + 0.5;
		MachineCaptureInfo.IlluminatorDelay[3] = StrToFloat(IlluminatorDelayEdit4->Text) * 20 + 0.5;
		MachineCaptureInfo.IlluminatorDelay[4] = StrToFloat(IlluminatorDelayEdit5->Text) * 20 + 0.5;
		MachineCaptureInfo.IlluminatorDelay[5] = StrToFloat(IlluminatorDelayEdit6->Text) * 20 + 0.5;

		MachineCaptureInfo.IlluminatorTime[0] = StrToFloat(IlluminatorOnTimeEdit1->Text) * 20 + 0.5;
		MachineCaptureInfo.IlluminatorTime[1] = StrToFloat(IlluminatorOnTimeEdit2->Text) * 20 + 0.5;
		MachineCaptureInfo.IlluminatorTime[2] = StrToFloat(IlluminatorOnTimeEdit3->Text) * 20 + 0.5;
		MachineCaptureInfo.IlluminatorTime[3] = StrToFloat(IlluminatorOnTimeEdit4->Text) * 20 + 0.5;
		MachineCaptureInfo.IlluminatorTime[4] = StrToFloat(IlluminatorOnTimeEdit5->Text) * 20 + 0.5;
		MachineCaptureInfo.IlluminatorTime[5] = StrToFloat(IlluminatorOnTimeEdit6->Text) * 20 + 0.5;
		
		MachineCaptureInfo.SensorSPBMask[0] = 0;
		MachineCaptureInfo.SensorSPBMask[1] = 0;

		for (int captureIndex = 0; captureIndex < SYSTEM_MACHINE_CAPTURE_COUNT; captureIndex++)
		{
			for (int globalCameraIndex = 0; globalCameraIndex < SYSTEM_TOTAL_CAMERA_COUNT; globalCameraIndex++)
			{
				int spbIndex = CameraMapInfo[globalCameraIndex].SPBIndex;
				int camIndex = CameraMapInfo[globalCameraIndex].CamIndex;

				if (MachineCaptureInfo.CamMask[captureIndex] & (0x0001 << globalCameraIndex))
				{
					if (captureIndex < HALF_CAPTURE_INDEX)
					{
						MachineCaptureInfo.SensorSPBMask[0] |= (0x0001 << spbIndex);
					}
					else
					{
						MachineCaptureInfo.SensorSPBMask[1] |= (0x0001 << spbIndex);
					}
				}
			}
		}

    ShowMessageFA("Success to Save");

		ModalResult = mrOk;
	}
	catch (Exception &ec)
	{
		ShowMessageW(ec.Message);
	}
}
//---------------------------------------------------------------------------
void __fastcall TVisionSettingForm::SetCaptureInfo(TMachineCaptureInfo &info)
{
	MachineCaptureInfo = info;
	UpdateMachineCaptureInfo();
	for (int captureIndex = 0; captureIndex < SYSTEM_MACHINE_CAPTURE_COUNT; captureIndex++)
	{
		TTntEdit *illuminatorDelayEdit = (TTntEdit *) FindComponent("IlluminatorDelayEdit" + IntToStr(captureIndex + 1));
		illuminatorDelayEdit->Text = FloatToStr(MachineCaptureInfo.IlluminatorDelay[captureIndex] / 20.0);
		TTntEdit *illuminatorOnTimeEdit = (TTntEdit *) FindComponent("IlluminatorOnTimeEdit" + IntToStr(captureIndex + 1));
		illuminatorOnTimeEdit->Text = FloatToStr(MachineCaptureInfo.IlluminatorTime[captureIndex] / 20.0);
	}
}
//---------------------------------------------------------------------------
void __fastcall TVisionSettingForm::GetCaptureInfo(TMachineCaptureInfo &info)
{
	info = MachineCaptureInfo;
}
//---------------------------------------------------------------------------

void __fastcall TVisionSettingForm::CaptureSettingSpeedButtonClick(
	  TObject *Sender)
{
	TTntSpeedButton *theSpeedButton = (TTntSpeedButton *) Sender;
	CurrentCaptureIndex = theSpeedButton->Tag;
	UpdateMachineCaptureInfo();

  SetActivateComponent();
}
//---------------------------------------------------------------------------
void __fastcall TVisionSettingForm::UpdateMachineCaptureInfo(void)
{
	if(!ProductData.ProductName.IsEmpty())
	{
		if(ProductData.FatTabletCapture)
		{
			MachineCaptureInfo.IlluminatorMask[0] = 0x3;
			MachineCaptureInfo.IlluminatorMask[1] = 0x1F;
			MachineCaptureInfo.IlluminatorMask[2] = 0;
			MachineCaptureInfo.IlluminatorMask[3] = 0xC0;
			MachineCaptureInfo.IlluminatorMask[4] = 0x7C0;
			MachineCaptureInfo.IlluminatorMask[5] = 0;	
			MachineCaptureInfo.IlluminatorDelay[1] = MachineCaptureInfo.IlluminatorDelay[0]+40;
			MachineCaptureInfo.IlluminatorDelay[4] = MachineCaptureInfo.IlluminatorDelay[3]+40;
			MachineCaptureInfo.IlluminatorTime[0] = 20;//StrToFloat(IlluminatorOnTimeEdit1->Text) * 20 + 0.5;
			MachineCaptureInfo.IlluminatorTime[1] = 20;//StrToFloat(IlluminatorOnTimeEdit2->Text) * 20 + 0.5;
			MachineCaptureInfo.IlluminatorTime[2] = 20;//StrToFloat(IlluminatorOnTimeEdit3->Text) * 20 + 0.5;
			MachineCaptureInfo.IlluminatorTime[3] = 20;//StrToFloat(IlluminatorOnTimeEdit4->Text) * 20 + 0.5;
			MachineCaptureInfo.IlluminatorTime[4] = 20;// StrToFloat(IlluminatorOnTimeEdit5->Text) * 20 + 0.5;
			MachineCaptureInfo.IlluminatorTime[5] = 20;//StrToFloat(IlluminatorOnTimeEdit6->Text) * 20 + 0.5;			
		}
		else
		{
			MachineCaptureInfo.IlluminatorMask[0] = 0x1F;
			MachineCaptureInfo.IlluminatorMask[1] = 0x1F;
			MachineCaptureInfo.IlluminatorMask[2] = 0;
			MachineCaptureInfo.IlluminatorMask[3] = 0x7C0;
			MachineCaptureInfo.IlluminatorMask[4] = 0x7C0;
			MachineCaptureInfo.IlluminatorMask[5] = 0;	
			if(abs(MachineCaptureInfo.IlluminatorDelay[1] -MachineCaptureInfo.IlluminatorDelay[0]) >=2)
			{
				MachineCaptureInfo.IlluminatorDelay[1] = MachineCaptureInfo.IlluminatorDelay[0];
			}
			if(abs(MachineCaptureInfo.IlluminatorDelay[4] -MachineCaptureInfo.IlluminatorDelay[3]) >=2)
			{			
				MachineCaptureInfo.IlluminatorDelay[4] = MachineCaptureInfo.IlluminatorDelay[3];
			}
			MachineCaptureInfo.IlluminatorTime[0] = 40;//StrToFloat(IlluminatorOnTimeEdit1->Text) * 20 + 0.5;
			MachineCaptureInfo.IlluminatorTime[1] = 40;//StrToFloat(IlluminatorOnTimeEdit2->Text) * 20 + 0.5;
			MachineCaptureInfo.IlluminatorTime[2] = 40;//StrToFloat(IlluminatorOnTimeEdit3->Text) * 20 + 0.5;
			MachineCaptureInfo.IlluminatorTime[3] = 40;//StrToFloat(IlluminatorOnTimeEdit4->Text) * 20 + 0.5;
			MachineCaptureInfo.IlluminatorTime[4] = 40;// StrToFloat(IlluminatorOnTimeEdit5->Text) * 20 + 0.5;
			MachineCaptureInfo.IlluminatorTime[5] = 40;//StrToFloat(IlluminatorOnTimeEdit6->Text) * 20 + 0.5;						
		}
	}
	else
	{
		MachineCaptureInfo.IlluminatorMask[0] = 0x1F;
		MachineCaptureInfo.IlluminatorMask[1] = 0x1F;
		MachineCaptureInfo.IlluminatorMask[2] = 0;
		MachineCaptureInfo.IlluminatorMask[3] = 0x7C0;
		MachineCaptureInfo.IlluminatorMask[4] = 0x7C0;
		MachineCaptureInfo.IlluminatorMask[5] = 0;	
		if(abs(MachineCaptureInfo.IlluminatorDelay[1] -MachineCaptureInfo.IlluminatorDelay[0]) >=2)
		{
			MachineCaptureInfo.IlluminatorDelay[1] = MachineCaptureInfo.IlluminatorDelay[0];
		}
		if(abs(MachineCaptureInfo.IlluminatorDelay[4] -MachineCaptureInfo.IlluminatorDelay[3]) >=2)
		{			
			MachineCaptureInfo.IlluminatorDelay[4] = MachineCaptureInfo.IlluminatorDelay[3];
		}		
		MachineCaptureInfo.IlluminatorTime[0] = 40;//StrToFloat(IlluminatorOnTimeEdit1->Text) * 20 + 0.5;
		MachineCaptureInfo.IlluminatorTime[1] = 40;//StrToFloat(IlluminatorOnTimeEdit2->Text) * 20 + 0.5;
		MachineCaptureInfo.IlluminatorTime[2] = 40;//StrToFloat(IlluminatorOnTimeEdit3->Text) * 20 + 0.5;
		MachineCaptureInfo.IlluminatorTime[3] = 40;//StrToFloat(IlluminatorOnTimeEdit4->Text) * 20 + 0.5;
		MachineCaptureInfo.IlluminatorTime[4] = 40;// StrToFloat(IlluminatorOnTimeEdit5->Text) * 20 + 0.5;
		MachineCaptureInfo.IlluminatorTime[5] = 40;//StrToFloat(IlluminatorOnTimeEdit6->Text) * 20 + 0.5;			
	}
	
	for (int globalCamIndex = 0; globalCamIndex < SYSTEM_TOTAL_CAMERA_COUNT; globalCamIndex++)
	{
		TTntCheckBox *theCheckBox = (TTntCheckBox *) FindComponent("CamCheckBox" + IntToStr(globalCamIndex + 1));
		if (theCheckBox)
		{
			if (MachineCaptureInfo.CamMask[CurrentCaptureIndex] & (0x0001 << globalCamIndex))
			{
				theCheckBox->Checked = true;
			}
			else
			{
				theCheckBox->Checked = false;
			}
		}
	}

	for (int ledIndex = 0; ledIndex < SYSTEM_TOTAL_LED_COUNT; ledIndex++)
	{
		TTntCheckBox *theCheckBox = (TTntCheckBox *) FindComponent("MCLEDCheckBox" + IntToStr(ledIndex + 1));
		if (theCheckBox)
		{
			if (MachineCaptureInfo.IlluminatorMask[CurrentCaptureIndex] & (0x0001 << ledIndex))
			{
				theCheckBox->Checked = true;
			}
			else
			{
				theCheckBox->Checked = false;
			}
		}
	}
}
//---------------------------------------------------------------------------

void __fastcall TVisionSettingForm::CamCheckBoxClick(TObject *Sender)
{
	TTntCheckBox *theCheckBox = (TTntCheckBox *) Sender;
  int globalCamIndex = theCheckBox->Tag;
  if (theCheckBox->Checked)
  {
    MachineCaptureInfo.CamMask[CurrentCaptureIndex] |= (0x0001 << globalCamIndex);
  }
  else
  {
    MachineCaptureInfo.CamMask[CurrentCaptureIndex] &= ~(0x0001 << globalCamIndex);
  }

  SetActivateComponent();
}
//---------------------------------------------------------------------------

void __fastcall TVisionSettingForm::MCLEDCheckBoxClick(TObject *Sender)
{
	TTntCheckBox *theCheckBox = (TTntCheckBox *) Sender;
  int ledIndex = theCheckBox->Tag;
  if (theCheckBox->Checked)
  {
    MachineCaptureInfo.IlluminatorMask[CurrentCaptureIndex] |= (0x0001 << ledIndex);
  }
  else
  {
    MachineCaptureInfo.IlluminatorMask[CurrentCaptureIndex] &= ~(0x0001 << ledIndex);
  }

  SetActivateComponent();
}
//---------------------------------------------------------------------------

void __fastcall TVisionSettingForm::NumEditClick(TObject *Sender)
{
	TTntEdit *theEdit = (TTntEdit *) Sender;
	KeyboardForm->Text = theEdit->Text;
  if (KeyboardForm->ShowKeypad() == mrOk)
  {
		theEdit->Text = KeyboardForm->Text;
	}
}
//---------------------------------------------------------------------------

void __fastcall TVisionSettingForm::SetActivateComponent()
{
  TTntCheckBox *tempCamCheckBox;
  TTntCheckBox *tempLEDCheckBox;

  for(int tempCamIndex = 1; tempCamIndex <= SYSTEM_TOTAL_CAMERA_COUNT; tempCamIndex++)
  {
    tempCamCheckBox =  (TTntCheckBox *) FindComponent("CamCheckBox" + IntToStr(tempCamIndex));

    if(tempCamCheckBox)
    {
      tempCamCheckBox->Font->Size = 8;
      if(tempCamCheckBox->Checked)
      {
        tempCamCheckBox->Font->Color = clRed;
        tempCamCheckBox->Font->Style = tempCamCheckBox->Font->Style << fsBold;
      }
      else
      {
        tempCamCheckBox->Font->Color = clBlack;
        tempCamCheckBox->Font->Style = tempCamCheckBox->Font->Style >> fsBold;
      }
    }
  }

  for(int tempLEDIndex = 1; tempLEDIndex <= SYSTEM_TOTAL_LED_COUNT; tempLEDIndex++)
  {
    tempLEDCheckBox =  (TTntCheckBox *) FindComponent("MCLEDCheckBox" + IntToStr(tempLEDIndex));

    if(tempLEDCheckBox)
    {
      tempLEDCheckBox->Font->Size = 8;
      if(tempLEDCheckBox->Checked)
      {
        tempLEDCheckBox->Font->Color = clRed;
        tempLEDCheckBox->Font->Style = tempLEDCheckBox->Font->Style << fsBold;
      }
      else
      {
        tempLEDCheckBox->Font->Color = clBlack;
        tempLEDCheckBox->Font->Style = tempLEDCheckBox->Font->Style >> fsBold;
      }
    }
  }
}

void __fastcall TVisionSettingForm::TntFormCreate(TObject *Sender)
{
  for(int globalCameraIndex = 0; globalCameraIndex < SYSTEM_TOTAL_CAMERA_COUNT; globalCameraIndex++ )
  {
    AnsiString ConvertString;
    if(SystemLinkCameraInfo[globalCameraIndex] != 0)
    {
      TTntCheckBox *CamCheckBox = (TTntCheckBox *)FindComponent("CamCheckBox" + IntToStr(globalCameraIndex+1));

      ConvertString = ConvertCameraIndex(globalCameraIndex);
      CamCheckBox->Caption = ConvertString;

    }
  }
  if(GlobalProgramID == PROGRAM_ID_150P)
  {
    // SELMA150P
    for(int globalCameraIndex = 0; globalCameraIndex < SYSTEM_TOTAL_CAMERA_COUNT; globalCameraIndex++)
    {
      AnsiString ConvertString;
      int MoveD = ComponentReposition(1,0,0,CamCheckBox3->Width);
      TTntCheckBox *CamCheckBox = (TTntCheckBox *)FindComponent("CamCheckBox" + IntToStr(globalCameraIndex+1));
      if(SystemLinkCameraInfo[globalCameraIndex] == 0)
      {
        CamCheckBox->Visible = false;
      }
      else
      {
        CamCheckBox->Left += MoveD;
      }
    }

  }
	if(!ProductData.ProductName.IsEmpty())
	{
		if(ProductData.FatTabletCapture)
		{
			IlluminatorDelayEdit2->Enabled = false;
			IlluminatorDelayEdit5->Enabled = false;
			IlluminatorOnTimeEdit1->Enabled = false;
			IlluminatorOnTimeEdit2->Enabled = false;
			IlluminatorOnTimeEdit3->Enabled = false;
			IlluminatorOnTimeEdit4->Enabled = false;
			IlluminatorOnTimeEdit5->Enabled = false;
			IlluminatorOnTimeEdit6->Enabled = false;	
		}
		else
		{
			IlluminatorDelayEdit2->Enabled = true;
			IlluminatorDelayEdit5->Enabled = true;
			IlluminatorOnTimeEdit1->Enabled = true;
			IlluminatorOnTimeEdit2->Enabled = true;
			IlluminatorOnTimeEdit3->Enabled = true;
			IlluminatorOnTimeEdit4->Enabled = true;
			IlluminatorOnTimeEdit5->Enabled = true;
			IlluminatorOnTimeEdit6->Enabled = true;	
		}
	} 
	else
	{
		IlluminatorDelayEdit2->Enabled = true;
		IlluminatorDelayEdit5->Enabled = true;
		IlluminatorOnTimeEdit1->Enabled = true;
		IlluminatorOnTimeEdit2->Enabled = true;
		IlluminatorOnTimeEdit3->Enabled = true;
		IlluminatorOnTimeEdit4->Enabled = true;
		IlluminatorOnTimeEdit5->Enabled = true;
		IlluminatorOnTimeEdit6->Enabled = true;	
	}
}
//---------------------------------------------------------------------------

