//---------------------------------------------------------------------------
#ifndef Capture_FrameH
#define Capture_FrameH
//---------------------------------------------------------------------------
#include <Classes.hpp>
#include <Controls.hpp>
#include <StdCtrls.hpp>
#include <Forms.hpp>
#include <ExtCtrls.hpp>
#include <FileCtrl.hpp>
#include <Buttons.hpp>
#include "TntButtons.hpp"
#include "TntExtCtrls.hpp"
#include "TntStdCtrls.hpp"
#include "TntForms.hpp"

#include "Environment.h"
#include "Calibration_Form.h"

#define MAX_GLOBAL_CAM_COUNT        16
#define MAX_LABEL_COUNT 1000
//---------------------------------------------------------------------------
class TCaptureFrame : public TFrame
{
__published:	// IDE-managed Components
	TTntPanel *Panel1;
	TTntLabel *lblFPS;
	TTntShape *shRefresh;
	TTntImage *BufferImage;
	TTntLabel *lblAvgFPS;
	TTntLabel *Label8;
	TDirectoryListBox *ImageDirectoryListBox;
	TTntButton *StopTimerButton;
	TFileListBox *ImageFileListBox;
	TTntEdit *SubDirEdit;
	TTimer *CaptureCheckTimer;
	TTntButton *SaveImageButton;
	TTntCheckBox *cbRAWData;
	TTntSpeedButton *SaveSpeedButton;
    TDriveComboBox *ImageDriveComboBox;
    TTntButton *NewFolderButton;
	TTntCheckBox *cb3DData;
	void __fastcall StopTimerButtonClick(TObject *Sender);
	void __fastcall CaptureCheckTimerTimer(TObject *Sender);
	void __fastcall SaveImageButtonClick(TObject *Sender);
    void __fastcall NewFolderButtonClick(TObject *Sender);
    void __fastcall ImageDirectoryListBoxChange(TObject *Sender);
    void __fastcall SubDirEditChange(TObject *Sender);
private:	// User declarations
	  int CaptureWidth, CaptureHeight;
    TTntImage *DestImage;
    TTntImage *MultiImage[4];


    unsigned int CaptureStartTime;
    unsigned int CaptureFirstStartTime;
    int CaptureCount;
    bool bOnCapture;
    bool bFrameCapture;
    bool IsSingleMode;
    bool IsFullCapture;

    int MultiImageCameraIndex[4];
    bool MultiImageFrameCaptured[4];

    int CurrentImageIndex;
    int CurrentCamImageIndex[MAX_GLOBAL_CAM_COUNT];
    int ImageSubDirIndex;
	  unsigned char *CaptureData;

    int whiteBalance[3];

    unsigned char ThreeDImage[SYSTEM_CAMERA_WIDTH * SYSTEM_CAMERA_HEIGHT];
    unsigned char DentedThreeDImage[SYSTEM_CAMERA_WIDTH * SYSTEM_CAMERA_HEIGHT];

    void __fastcall FindFirstSubDir(void);
    void __fastcall UpdateImageFileList(void);
    void __fastcall ReadSingleModeImage(void);
    void __fastcall ReadMultiModeImage(void);

    void __fastcall ColorChange(unsigned char *srcImage, int cameraIndex);
    void __fastcall ViewDentedArea();

    //void __fastcall ApplyWhiteBalance(Graphics::TBitmap *srcImage, Graphics::TBitmap *dstImage);
public:		// User declarations
	int GlobalCameraIndex;

	__fastcall TCaptureFrame(TComponent* Owner);
	__fastcall TCaptureFrame::~TCaptureFrame();

    void __fastcall SetCaptureProperty(int captureWidth, int captureHeight, TTntImage *destImage, TPixelFormat pixelFormat);
    void __fastcall SetCaptureProperty_Multi(int captureWidth, int captureHeight,
        TTntImage *destImage1, TTntImage *destImage2, TTntImage *destImage3, TTntImage *destImage4);
    void __fastcall SetGlobalCameraIndex(int cameraIndex);
    void __fastcall SetMultiImageCameraIndex(int index1, int index2, int index3, int index4);
    void __fastcall CaptureStart(bool bFrame, bool bFullCapture,int SubSamplingMode);
    void __fastcall CaptureStop(void);
    void __fastcall SetViewMode(bool bSingleView);
    void __fastcall SetWhiteBalanceValue(int Value, int rgbIndex);

    int kind;
    int SubSamplingMode;
    int threeDOption;
};
//---------------------------------------------------------------------------
extern PACKAGE TCaptureFrame *CaptureFrame;
//---------------------------------------------------------------------------
#endif
