//---------------------------------------------------------------------------
// For SELMA200, 20180223, moon,  
//---------------------------------------------------------------------------

#include <vcl.h>
#include <inifiles.hpp>
#pragma hdrstop

#include "ColorCode_Form.h"
#include "Environment.h"
#include "MultiLanguage.h"
//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma link "TntButtons"
#pragma link "TntExtCtrls"
#pragma link "TntForms"
#pragma link "TntStdCtrls"
#pragma resource "*.dfm"
TColorCodeForm *ColorCodeForm;
//---------------------------------------------------------------------------
__fastcall TColorCodeForm::TColorCodeForm(TComponent* Owner)
	: TTntForm(Owner)
{
  if(DefaultLCID == 1028 || DefaultLCID == 2052 || DefaultLCID == 3076 || DefaultLCID == 4100)
    ComponentSetFontName(this, "SimSun");
  else if(DefaultLCID == 1041)
    ComponentSetFontName(this, "Meiryo UI");
  else if(DefaultLCID == 3082)
  {
    ComponentSetFontName(this, "Segoe UI");
    ComponentSetMultiLine(this);
  }

  GetDefaultString();
	// make color code list
    ColorCodeList = new TList;

    TIniFile *iniFile = new TIniFile(ProgramPath.Env + "\\ColorCode.ini");
    if (iniFile)
    {
        TStringList *colorCodeNames = new TStringList;
    	iniFile->ReadSection("Color Code", colorCodeNames);
        for (int colorIndex = 0; colorIndex < colorCodeNames->Count; colorIndex++)
        {
        	AnsiString colorName = colorCodeNames->Strings[colorIndex];
			int rgbValue = iniFile->ReadInteger("Color Code", colorName, 0);
            AddColorCode(colorName, rgbValue);
        }
        delete colorCodeNames;
		delete iniFile;
    }
	this->Width = 1064;
    this->Height = 744;
    ArrangeComponents();
}
//---------------------------------------------------------------------------
void __fastcall TColorCodeForm::GetDefaultString()
{
  ScrollDownButton->Caption = COLORCODEFORM_BUTTON_CAPTION_01;
  ScrollUpButton->Caption = COLORCODEFORM_BUTTON_CAPTION_02;
  CloseBitBtn->Caption = TABLETDATALOGFORM_BUTTON_CAPTION_01;
  this->Caption = COLORCODEFORM_FORM_CAPTION_01;
}
//---------------------------------------------------------------------------
void __fastcall TColorCodeForm::AddColorCode(AnsiString name, int rgbValue)
{
	TColorCodeUnit *aColorCodeUnit = new TColorCodeUnit;
	aColorCodeUnit->RGBValue = rgbValue;
    aColorCodeUnit->Name = name;
    aColorCodeUnit->Panel = new TTntPanel(this);
    aColorCodeUnit->Shape = new TTntShape(this);
    aColorCodeUnit->NameLabel = new TTntLabel(this);
    aColorCodeUnit->Panel->Parent = ColorListScrollBox;
    aColorCodeUnit->Panel->Color = clBlack;
    aColorCodeUnit->Panel->Width = 150;
    aColorCodeUnit->Panel->Height = 100;
    aColorCodeUnit->Shape->Width = 135;
    aColorCodeUnit->Shape->Height = 64;
    aColorCodeUnit->Shape->Parent = aColorCodeUnit->Panel;
    aColorCodeUnit->Shape->Left = 8;
    aColorCodeUnit->Shape->Top = 8;
    aColorCodeUnit->Shape->Brush->Color = ((rgbValue & 0x0000FF) << 16) | (rgbValue & 0x00FF00) | ((rgbValue & 0xFF0000) >> 16);
    aColorCodeUnit->Shape->Pen->Color = clWhite;
    aColorCodeUnit->Shape->Tag = ColorCodeList->Count;
	aColorCodeUnit->Shape->OnMouseDown = ColorShapeMouseDown;
    aColorCodeUnit->NameLabel->AutoSize = false;
    aColorCodeUnit->NameLabel->Width = 137;
    aColorCodeUnit->NameLabel->Height = 13;
    aColorCodeUnit->NameLabel->Parent = aColorCodeUnit->Panel;
    aColorCodeUnit->NameLabel->Left = 8;
    aColorCodeUnit->NameLabel->Top = 80;
    aColorCodeUnit->NameLabel->Alignment = taCenter;
    aColorCodeUnit->NameLabel->Font->Color = clWhite;
    aColorCodeUnit->NameLabel->Caption = aColorCodeUnit->Name;


    ColorCodeList->Add(aColorCodeUnit);
}
//---------------------------------------------------------------------------
void __fastcall TColorCodeForm::ArrangeComponents(void)
{
	const int compSpace = 16;
    int posY = compSpace;
	int posX = compSpace;
	for (int colorIndex = 0; colorIndex < ColorCodeList->Count; colorIndex++)
    {
		TColorCodeUnit *aColorCodeUnit = (TColorCodeUnit *) ColorCodeList->Items[colorIndex];
		aColorCodeUnit->Panel->Left = posX;
        aColorCodeUnit->Panel->Top = posY;
		posX += aColorCodeUnit->Panel->Width + compSpace;
        if (posX + aColorCodeUnit->Panel->Width >= aColorCodeUnit->Panel->Parent->Width)
        {
			posX = compSpace;
            posY += (aColorCodeUnit->Panel->Height + compSpace);
        }
    }
    ColorListScrollBox->VertScrollBar->Range = posY + 116;
}
//---------------------------------------------------------------------------
void __fastcall TColorCodeForm::ClearColorCodeList(void)
{
	while (ColorCodeList->Count)
    {
		TColorCodeUnit *aColorCodeUnit = (TColorCodeUnit *) ColorCodeList->First();
        ColorCodeList->Remove(aColorCodeUnit);
        delete aColorCodeUnit;
    }
}
//---------------------------------------------------------------------------

void __fastcall TColorCodeForm::FormDestroy(TObject *Sender)
{
	ClearColorCodeList();
    delete ColorCodeList;
}
//---------------------------------------------------------------------------
void __fastcall TColorCodeForm::FormResize(TObject *Sender)
{
	ArrangeComponents();
}
//---------------------------------------------------------------------------
void __fastcall TColorCodeForm::ColorShapeMouseDown(TObject *Sender, TMouseButton Button,
	TShiftState Shift, int X, int Y)
{
	TTntShape *theShape = (TTntShape *) Sender;
	TColorCodeUnit *aColorCodeUnit = (TColorCodeUnit *) ColorCodeList->Items[theShape->Tag];
    SelectedColorCode = aColorCodeUnit->Name;
    ModalResult = mrOk;
}
//---------------------------------------------------------------------------
AnsiString __fastcall TColorCodeForm::GetColorCodeName(void)
{
	return SelectedColorCode;
}
//---------------------------------------------------------------------------
TColor __fastcall GetColorByCode(AnsiString colorCode)
{
	TColor returnColor = clWhite;
    if (colorCode != "")
    {
	    TIniFile *iniFile = new TIniFile(ProgramPath.Env + "\\ColorCode.ini");
	    if (iniFile)
	    {
	    	int rgbColor = iniFile->ReadInteger("Color Code", colorCode, 0xFFFFFF);
	        // rgb to bgr
			returnColor = ((rgbColor & 0x0000FF) << 16) | (rgbColor & 0x00FF00) | ((rgbColor & 0xFF0000) >> 16);
			delete iniFile;
	    }
    }
    return returnColor;
}
//---------------------------------------------------------------------------
void __fastcall TColorCodeForm::ScrollUpButtonClick(TObject *Sender)
{
	ColorListScrollBox->VertScrollBar->Position = (ColorListScrollBox->VertScrollBar->Position - 116) / 116 * 116;
}
//---------------------------------------------------------------------------

void __fastcall TColorCodeForm::ScrollDownButtonClick(TObject *Sender)
{
	ColorListScrollBox->VertScrollBar->Position = (ColorListScrollBox->VertScrollBar->Position + 116) / 116 * 116;
}
//---------------------------------------------------------------------------

