//---------------------------------------------------------------------------

#ifndef ColorCode_FormH
#define ColorCode_FormH
//---------------------------------------------------------------------------
#include <Classes.hpp>
#include <Controls.hpp>
#include <StdCtrls.hpp>
#include <Forms.hpp>
#include <ExtCtrls.hpp>
#include <Buttons.hpp>
#include "TntButtons.hpp"
#include "TntExtCtrls.hpp"
#include "TntForms.hpp"
#include "TntStdCtrls.hpp"
//---------------------------------------------------------------------------
typedef struct
{
	AnsiString Name;
	unsigned int RGBValue;
    TTntPanel *Panel;
    TTntShape *Shape;
    TTntLabel *NameLabel;
} TColorCodeUnit;
//---------------------------------------------------------------------------
class TColorCodeForm : public TTntForm
{
__published:	// IDE-managed Components
	TTntScrollBox *ColorListScrollBox;
	TTntPanel *Panel1;
	TTntShape *Shape1;
	TTntLabel *Label1;
	TTntPanel *Panel2;
	TTntPanel *Panel3;
	TTntBitBtn *CloseBitBtn;
	TTntButton *ScrollUpButton;
	TTntButton *ScrollDownButton;
	void __fastcall FormDestroy(TObject *Sender);
	void __fastcall FormResize(TObject *Sender);
	void __fastcall ScrollUpButtonClick(TObject *Sender);
	void __fastcall ScrollDownButtonClick(TObject *Sender);
private:	// User declarations
	AnsiString SelectedColorCode;
	TList *ColorCodeList;
    void __fastcall AddColorCode(AnsiString name, int rgbValue);
    void __fastcall ArrangeComponents(void);
    void __fastcall ClearColorCodeList(void);
	void __fastcall ColorShapeMouseDown(TObject *Sender, TMouseButton Button,
          TShiftState Shift, int X, int Y);
          void __fastcall GetDefaultString();
public:		// User declarations
	__fastcall TColorCodeForm(TComponent* Owner);
    AnsiString __fastcall GetColorCodeName(void);
};
//---------------------------------------------------------------------------
TColor __fastcall GetColorByCode(AnsiString colorCode);
//---------------------------------------------------------------------------
extern PACKAGE TColorCodeForm *ColorCodeForm;
//---------------------------------------------------------------------------
#endif
