//---------------------------------------------------------------------------

#ifndef CommControl_FormH
#define CommControl_FormH
//---------------------------------------------------------------------------
#include <Classes.hpp>
#include <Controls.hpp>
#include <StdCtrls.hpp>
#include <Forms.hpp>

//#include "USBConnection.h"
#include "TcpComm.h"
#include "common.h"
#include <ExtCtrls.hpp>
#include "TntExtCtrls.hpp"
#include "TntStdCtrls.hpp"
#include "TntForms.hpp"
#include <ScktComp.hpp>
#include "TntButtons.hpp"
#include <Buttons.hpp>

#define COMM_HCB				0
#define COMM_SPB				1
#define COMM_SPB_1				1
#define COMM_SPB_2				2
#define COMM_SPB_3				3
#define COMM_SPB_4				4
#define COMM_SPB_5				5
#define COMM_SPB_6				6
#define COMM_SPB_7				7
#define COMM_SPB_8				8
#define COMM_TPB				9

#define TOTAL_COMM_COUNT		10
//---------------------------------------------------------------------------
class TCommControlForm : public TTntForm
{
__published:	// IDE-managed Components
	TTntGroupBox *GroupBox1;
	TTntLabel *Label1;
	TTntLabel *HCBConnectionLabel;
	TTntLabel *SPBConnectionLabel1;
	TTntLabel *SPBConnectionLabel2;
	TTntLabel *SPBConnectionLabel3;
	TTntLabel *SPBConnectionLabel4;
	TTntButton *ReconnectButton1;
	TTntButton *RecoverButton1;
	TTntButton *ReconnectButton2;
	TTntButton *RecoverButton2;
	TTntButton *ReconnectButton3;
	TTntButton *RecoverButton3;
	TTntButton *ReconnectButton4;
	TTntButton *RecoverButton4;
	TTntButton *ReconnectButton5;
	TTntButton *RecoverButton5;
	TTimer *StatusTimer;
	TTntButton *CloseButton;
  TPanel *SCADAPanel;
        TLabel *Label2;
        TTntButton *ServerButton;
        TTntButton *StopSvrButton;
  TLabel *SCADAStatusLabel;
        TServerSocket *SrvSocket;
  TTntGroupBox *ActiveGroupBox;
  TTntSpeedButton *ActiveStatus1;
  TTntSpeedButton *ActiveStatus2;
  TTntSpeedButton *ActiveStatus3;
  TTntLabel *SPBConnectionLabel5;
  TTntButton *ReconnectButton6;
  TTntButton *RecoverButton6;
  TTntLabel *SPBConnectionLabel6;
  TTntButton *ReconnectButton7;
  TTntButton *RecoverButton7;
  TTntLabel *IPBBoardLable7;
  TTntLabel *IPBBoardLable8;
  TTntLabel *SPBConnectionLabel7;
  TTntLabel *SPBConnectionLabel8;
  TTntButton *ReconnectButton8;
  TTntButton *ReconnectButton9;
  TTntLabel *IPBBoardLable1;
  TTntLabel *IPBBoardLable2;
  TTntLabel *IPBBoardLable3;
  TTntLabel *IPBBoardLable4;
  TTntLabel *IPBBoardLable5;
  TTntLabel *IPBBoardLable6;
        TTntLabel *TPBBoardLable;
        TTntLabel *TPBConnectionLabel;
        TTntButton *ReconnectButton10;
	void __fastcall StatusTimerTimer(TObject *Sender);
	void __fastcall FormCreate(TObject *Sender);
	void __fastcall CloseButtonClick(TObject *Sender);
	void __fastcall ReconnectButtonClick(TObject *Sender);
	void __fastcall RecoverButtonClick(TObject *Sender);
	void __fastcall Panel1DblClick(TObject *Sender);
        void __fastcall SrvSocketClientConnect(TObject *Sender,
          TCustomWinSocket *Socket);
	void __fastcall SrvSocketClientDisconnect(TObject *Sender,
          TCustomWinSocket *Socket);
	void __fastcall SrvSocketClientRead(TObject *Sender,
          TCustomWinSocket *Socket);
	void __fastcall ServerButtonClick(TObject *Sender);
	void __fastcall StopSvrButtonClick(TObject *Sender);
  void __fastcall FormActivate(TObject *Sender);
  void __fastcall ActiveStatus1Click(TObject *Sender);
  void __fastcall TntFormClose(TObject *Sender, TCloseAction &Action);
private:	// User declarations
	int		activemode; // 1-usb all 2-hcb-usb/tcp-spb  3-tcp all
        unsigned char cBuf[20];
	TTcpComm TcpConnection[TOTAL_COMM_COUNT];
	bool FBusy[TOTAL_COMM_COUNT];
  void __fastcall GetDefaultString();
	void __fastcall CheckStatus(void);
public:		// User declarations
	__fastcall TCommControlForm(TComponent* Owner);
	void __fastcall Connect(int commIndex);
	void __fastcall Disconnect(int commIndex);
	bool __fastcall IsConnected(int commIndex);
  bool __fastcall GetIgnoreState(int commIndex);  
	bool __fastcall Request(int commIndex, unsigned short command, void *data = NULL, unsigned int dataLength = 0,
		void *receiveBuffer = NULL, unsigned int receiveBufferMaxSize = 0);
	bool __fastcall RequestEx(int commIndex, unsigned short command, void *shortData, unsigned int shortDataLength,
		void *longData, unsigned int longDataLength, void *receiveBuffer = NULL, unsigned int receiveBufferMaxSize = 0,
		TUSBCompletionRoutine CompletionRoutine = NULL, TOverlapIOStr *OverlapIOStr = NULL);
	void __fastcall SetMaxWaitingTime(int commIndex, int waitingTime);
	void __fastcall SetDefaultMaxWaitingTime(int commIndex);
	bool __fastcall Recover(int commIndex);
    void __fastcall Reconnect(int commIndex);
	void __fastcall RequestStallTest(int commIndex, int testMode);
  void __fastcall TxDataToTcp(AnsiString str);   //sjm TCPIP

    //void __fastcall AlarmDataToTcp(int code,Byte acode);   //sjm TCPIP
    int  __fastcall TxDatalength(AnsiString str);	//sjm TCPIP
    void __fastcall TxAlarmDataToTcp(int code, AnsiString str);    //sjm TCPIP
    TList *SOCLST;  //sjm TCPIP

};
//---------------------------------------------------------------------------
extern PACKAGE TCommControlForm *CommControlForm;

extern bool CommSimulationMode;
extern bool TcpSndFlag; 		 //TCPIP

extern void __fastcall Comm_Connect(int commIndex);
extern void __fastcall Comm_Disconnect(int commIndex);
extern void __fastcall Comm_ConnectAll(void);
extern void __fastcall Comm_DisconnectAll(void);
extern bool __fastcall Comm_IsConnected(int commIndex);

extern bool __fastcall Comm_Request(int commIndex, unsigned short command, void *data = NULL, unsigned int dataLength = 0,
	void *receiveBuffer = NULL, unsigned int receiveBufferMaxSize = 0);
extern bool __fastcall Comm_RequestEx(int commIndex, unsigned short command, void *shortData, unsigned int shortDataLength,
	void *longData, unsigned int longDataLength, void *receiveBuffer = NULL, unsigned int receiveBufferMaxSize = 0,
	TUSBCompletionRoutine CompletionRoutine = NULL, TOverlapIOStr *OverlapIOStr = NULL);

extern void __fastcall Comm_SetMaxWaitingTime(int commIndex, int waitingTime);
extern void __fastcall Comm_SetDefaultMaxWaitingTime(int commIndex);

extern bool __fastcall Comm_Recover(int commIndex);
extern void __fastcall Comm_RequestStallTest(int commIndex, int testMode);
extern void __fastcall Comm_Reconnect(int commIndex);

extern bool __fastcall Comm_GetIgnoreState(int commIndex);
extern bool Comm_IsActiveForm;
//---------------------------------------------------------------------------
#endif
