//---------------------------------------------------------------------------
// For SELMA200, 20180223, moon,  
//---------------------------------------------------------------------------

#include <vcl.h>
#pragma hdrstop

#define SecurityActive 0
#define AuthorityActive 1
#define ProgramSettingActive 2

#include "UserAuthoritySetting_Form.h"
#include "ComputerSystemSetting_Form.h"
#include "InputText_Dialog.h"
#include "Keyboard_Form.h"
#include "Environment.h"
#include "Message_Form.h"
#include "MultiLanguage.h"
#include "Main_Form.h"
#include "Inspection_Form.h"
#include "AdvMachineControl_Form.h"
#include "Processing.h"
#include "EnvironmentSetting_Form.h"
#include <inifiles.hpp>
//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma link "TntButtons"
#pragma link "TntComCtrls"
#pragma link "TntExtCtrls"
#pragma link "TntStdCtrls"
#pragma link "TntGrids"
#pragma link "TntButtons"
#pragma link "TntComCtrls"
#pragma link "TntExtCtrls"
#pragma link "TntGrids"
#pragma link "TntStdCtrls"
#pragma resource "*.dfm"

TComputerSystemSettingForm *ComputerSystemSettingForm;

//---------------------------------------------------------------------------
__fastcall TComputerSystemSettingForm::TComputerSystemSettingForm(TComponent* Owner)
	: TTntForm(Owner)
{
	if (DefaultLCID == 1028 || DefaultLCID == 2052 || DefaultLCID == 3076 || DefaultLCID == 4100)
		ComponentSetFontName(this, "SimSun");
	else if (DefaultLCID == 1041)
		ComponentSetFontName(this, "Meiryo UI");
  else if(DefaultLCID == 3082)
  {
    ComponentSetFontName(this, "Segoe UI");
    ComponentSetMultiLine(this);
  }

	GetDefaultString();


  if((MachineSetupData.CompanyID == INTERNATIONAL_MACHINE1) && (MachineSetupData.InterlockInfo.ACdomesticMode == 0))
  {
    UpstreamCheckbox->Visible = true;
    DownstreamCheckbox->Visible = true;
    DistributorGroupBox->Visible = false;
  }
  else
  {
    SubSamplingModeGroupBox->Visible = false;
    DistributorGroupBox->Visible = true;
  }

	if (MachineSetupData.CompanyID == INTERNATIONAL_MACHINE2)
	{
		LocalNonationLabel->Visible = true;
		AjantaReportCompanyNameComboBox->Visible = true;
		ReportOptionGroupBox->Height = 217;
	}

  if(MachineSetupData.CompanyID == DOMESTIC_MACHINE2)
  {
    UVLaserCheckBox->Visible = true;
  }
}
//---------------------------------------------------------------------------
void __fastcall TComputerSystemSettingForm::GetDefaultString()
{
	AuthoritySettingSpeedButton->Caption = COMPUTERSYSTEMSETTINGFORM_BUTTON_CAPTION_01;
	SecuritySettingSpeedButton->Caption = COMPUTERSYSTEMSETTINGFORM_BUTTON_CAPTION_02;
	CancelButton->Caption = COMPUTERSYSTEMSETTINGFORM_BUTTON_CAPTION_03;
	ProgramSettingSpeedButton->Caption = COMPUTERSYSTEMSETTINGFORM_BUTTON_CAPTION_04;
	OkButton->Caption = COMPUTERSYSTEMSETTINGFORM_BUTTON_CAPTION_05;

	if (MachineSetupData.CompanyID == INTERNATIONAL_MACHINE2)
		InspectionContinueOnRestartCheckBox->Caption = "For Same Batch Inspection, Always Select [Continuously]";
	else
		InspectionContinueOnRestartCheckBox->Caption = COMPUTERSYSTEMSETTINGFORM_CHECKBOX_CAPTION_01;

	QuickStartCheckBox->Caption = COMPUTERSYSTEMSETTINGFORM_CHECKBOX_CAPTION_02;
	PasswordExpirationCheckBox->Caption = COMPUTERSYSTEMSETTINGFORM_CHECKBOX_CAPTION_03;
	InactivityLogoutCheckBox->Caption = COMPUTERSYSTEMSETTINGFORM_CHECKBOX_CAPTION_04;

	this->Caption = COMPUTERSYSTEMSETTINGFORM_FORM_CAPTION_01;
	GroupBox3->Caption = COMPUTERSYSTEMSETTINGFORM_GROUPBOX_CAPITON_01;
	GroupBox8->Caption = COMPUTERSYSTEMSETTINGFORM_GROUPBOX_CAPITON_03;
	GroupBox2->Caption = COMPUTERSYSTEMSETTINGFORM_GROUPBOX_CAPITON_04;
	GroupBox11->Caption = COMPUTERSYSTEMSETTINGFORM_GROUPBOX_CAPITON_05;
	GroupBox1->Caption = COMPUTERSYSTEMSETTINGFORM_GROUPBOX_CAPITON_08;
	GroupBox7->Caption = COMPUTERSYSTEMSETTINGFORM_GROUPBOX_CAPITON_09;
	GroupBox10->Caption = COMPUTERSYSTEMSETTINGFORM_GROUPBOX_CAPITON_10;
	Label24->Caption = "ȸ̵";//COMPUTERSYSTEMSETTINGFORM_LABEL_CAPTION_05;
	Label19->Caption = COMPUTERSYSTEMSETTINGFORM_LABEL_CAPTION_06;
	Label2->Caption = COMPUTERSYSTEMSETTINGFORM_LABEL_CAPTION_07;
	Label5->Caption = COMPUTERSYSTEMSETTINGFORM_LABEL_CAPTION_08;
	Label3->Caption = COMPUTERSYSTEMSETTINGFORM_LABEL_CAPTION_09;
	Label13->Caption = COMPUTERSYSTEMSETTINGFORM_LABEL_CAPTION_11;
	Label6->Caption = COMPUTERSYSTEMSETTINGFORM_LABEL_CAPTION_12;
	Label4->Caption = COMPUTERSYSTEMSETTINGFORM_LABEL_CAPTION_13;
	Label1->Caption = COMPUTERSYSTEMSETTINGFORM_LABEL_CAPTION_14;
	Label16->Caption = COMPUTERSYSTEMSETTINGFORM_LABEL_CAPTION_16;
	Label15->Caption = COMPUTERSYSTEMSETTINGFORM_LABEL_CAPTION_18;

	PrintGradeOnlyRadioButton->Caption = COMPUTERSYSTEMSETTINGFORM_RADIOBTN_CAPTION_01;
	PrintGradeAndSizeRadioButton->Caption = COMPUTERSYSTEMSETTINGFORM_RADIOBTN_CAPTION_02;
	PrintThreeDHeightGradeRadioButton->Caption = COMPUTERSYSTEMSETTINGFORM_RADIOBTN_CAPTION_03;
	PrintThreeDHeightValueRadioButton->Caption = COMPUTERSYSTEMSETTINGFORM_RADIOBTN_CAPTION_04;
	InspectionScreenTabSheet->Caption = COMPUTERSYSTEMSETTINGFORM_RADIOBTN_CAPTION_05;
	TabSheet5->Caption = COMPUTERSYSTEMSETTINGFORM_RADIOBTN_CAPTION_07;
	TabSheet2->Caption = COMPUTERSYSTEMSETTINGFORM_RADIOBTN_CAPTION_08;
	TabSheet1->Caption = COMPUTERSYSTEMSETTINGFORM_RADIOBTN_CAPTION_11;

	//add
	Label20->Caption = COMPUTERSYSTEMSETTINGFORM_LABEL_CAPTION_18;
	Label25->Caption = COMPUTERSYSTEMSETTINGFORM_LABEL_CAPTION_18;
	Label21->Caption = COMPUTERSYSTEMSETTINGFORM_LABEL_CAPTION_16;
	Label26->Caption = COMPUTERSYSTEMSETTINGFORM_LABEL_CAPTION_16;
	FirstLoginChangePWCheckBox->Caption = COMPUTERSYSTEMSETTINGFORM_LABEL_CAPTION_22;


	DHCheckbox->Caption = COMPUTERSYSTEMSETTINGFORM_LABEL_CAPTION_23;
	DHCheckBox2->Caption = COMPUTERSYSTEMSETTINGFORM_LABEL_CAPTION_33;
	HICheckbox->Caption = COMPUTERSYSTEMSETTINGFORM_LABEL_CAPTION_34;
	SensorOutputSettingCheckBox->Caption = COMPUTERSYSTEMSETTINGFORM_LABEL_CAPTION_26;
	IncludeUninsTabletCheckBox->Caption = COMPUTERSYSTEMSETTINGFORM_LABEL_CAPTION_37;

  TntLabel1->Caption = COMPUTERSYSTEMSETTINGFORM_LABEL_CAPTION_40;
  TntLabel2->Caption = COMPUTERSYSTEMSETTINGFORM_LABEL_CAPTION_41;

	if (DefaultLCID == 1042 || DefaultLCID == 2066)
	{
		//TntGroupBox2->Caption = "FPGA  ";
		FPGASecurityCheckbox->Caption = " ";
    	//ѱݸ
    if(MachineSetupData.CompanyID == DOMESTIC_MACHINE2)
      TwoSplitterActivationCheckBox->Caption = COMPUTERSYSTEMSETTINGFORM_LABEL_CAPTION_39;
    else
      TwoSplitterActivationCheckBox->Caption = "2й Ȱȭ";
	}
	else
	{
		//TntGroupBox2->Caption = "FPGA Security Setup";
		FPGASecurityCheckbox->Caption = "Security Setup";
		//TntLabel2->Left = 212;

    if(MachineSetupData.CompanyID == DOMESTIC_MACHINE2)
      TwoSplitterActivationCheckBox->Caption = COMPUTERSYSTEMSETTINGFORM_LABEL_CAPTION_39;
    else
      TwoSplitterActivationCheckBox->Caption = "Two Distributor Activation";
	}

	ReportOptionGroupBox->Caption = COMPUTERSYSTEMSETTINGFORM_LABEL_CAPTION_29;
	DetailReportCheckBox->Caption = COMPUTERSYSTEMSETTINGFORM_LABEL_CAPTION_30;
	DistributorGroupBox->Caption = COMPUTERSYSTEMSETTINGFORM_LABEL_CAPTION_32;
	HIGroupBox->Caption = COMPUTERSYSTEMSETTINGFORM_LABEL_CAPTION_35;
	SensorGroupBox->Caption = COMPUTERSYSTEMSETTINGFORM_LABEL_CAPTION_31;

	SubSamplingModeGroupBox->Caption = PRODUCTINPUTFORM_LABEL_CAPTION_12;
	SubSamplingStandardRadioButton->Caption = PRODUCTINPUTFORM_BUTTON_CAPTION_08;
	SubSamplingHDRadioButton->Caption = PRODUCTINPUTFORM_BUTTON_CAPTION_09;

  GroupBox4->Caption = COMPUTER_SYSTEM_SETTING_NEW_AUTHORITY_SETUP_TEXT_01;
  AuthrorityReviseOrSaveBtn->Caption = COMPUTER_SYSTEM_SETTING_NEW_AUTHORITY_SETUP_TEXT_02;
  AuthoritySettingCancelBtn->Caption = COMPUTER_SYSTEM_SETTING_NEW_AUTHORITY_SETUP_TEXT_03;
  UserAuthoritySettingBtn->Caption = COMPUTER_SYSTEM_SETTING_NEW_AUTHORITY_SETUP_TEXT_04;
  AuthorityRestoreBtn->Caption = COMPUTER_SYSTEM_SETTING_NEW_AUTHORITY_SETUP_TEXT_05;
  AddAuthorityBtn->Caption = COMPUTER_SYSTEM_SETTING_NEW_AUTHORITY_SETUP_TEXT_06;
  DeleteAuthorityBtn->Caption = COMPUTER_SYSTEM_SETTING_NEW_AUTHORITY_SETUP_TEXT_07;
  TntGroupBox1->Caption = COMPUTERSYSTEMSETTINGFORM_GROUPBOX_CAPITON_11;
  UpstreamCheckbox->Caption = COMPUTERSYSTEMSETTINGFORM_LABEL_CAPTION_38;
  DownstreamCheckbox->Caption = COMPUTERSYSTEMSETTINGFORM_LABEL_CAPTION_42;
//  ResultGraphOptCheckBox->Caption = COMPUTERSYSTEMSETTINGFORM_LABEL_CAPTION_43;
}
//----------------------------------------------------------------------------

void __fastcall TComputerSystemSettingForm::NumEditClick(TObject *Sender)
{
	if (Sender == SDMaxSpeedEdit || Sender == BFIDMaxSpeedEdit || Sender == BFODMaxSpeedEdit)
	{
		TInputTextDialog *inputTextDialog = new TInputTextDialog(this);
		if (inputTextDialog->ExecutePassword())
		{
			AnsiString passwordStr = inputTextDialog->InputText;
			if (passwordStr == "9510123")
			{
				TTntEdit *theEdit = (TTntEdit *)Sender;
				KeyboardForm->Text = theEdit->Text;

				if (KeyboardForm->ShowKeypad() == mrOk)
				{
					theEdit->Text = KeyboardForm->Text;
				}
			}
			else
			{
				ShowMessageFA(LOGINFORM_MSG_01);
			}
		}
		else
		{
			ShowMessageFA(CALENDARDIALOGFORM_BUTTON_CAPTION_01);
		}
		delete inputTextDialog;
	}
	else
	{
		TTntEdit *theEdit = (TTntEdit *)Sender;
		KeyboardForm->Text = theEdit->Text;

		if (KeyboardForm->ShowKeypad() == mrOk)
		{
			theEdit->Text = KeyboardForm->Text;
		}
	}
}
//---------------------------------------------------------------------------
void __fastcall TComputerSystemSettingForm::FormCreate(TObject *Sender)
{
	bool ActiveSystemSettingBtn = false;
	if (ProgramAccessAuthorityData.ProgramAccessAuthorityTable[UserInfo.AccessLevel][ACCESS_PGM_EVT_ENVSETUPFORM_AUTHORITY_SETUP])
	{
		AuthoritySettingSpeedButton->Visible = true;
		AuthoritySettingPanel->Visible = true;
		ActiveSystemSettingBtn = true;

		ActivePanelNum = AuthorityActive;
	}
	else
	{
		AuthoritySettingSpeedButton->Visible = false;
		AuthoritySettingPanel->Visible = false;
	}

	if (ProgramAccessAuthorityData.ProgramAccessAuthorityTable[UserInfo.AccessLevel][ACCESS_PGM_EVT_ENVSETUPFORM_SECURITY_SETUP])
	{
		SecuritySettingSpeedButton->Visible = true;
		SecuritySettingPanel->Visible = true;
		ActiveSystemSettingBtn = true;

		ActivePanelNum = SecurityActive;
	}
	else
	{
		SecuritySettingSpeedButton->Visible = false;
		SecuritySettingPanel->Visible = false;
	}

	if (ProgramAccessAuthorityData.ProgramAccessAuthorityTable[UserInfo.AccessLevel][ACCESS_PGM_EVT_ENVSETUPFORM_PGM_SETUP])
	{
		ProgramSettingSpeedButton->Visible = true;
		ProgramSettingPanel->Visible = true;
		ActiveSystemSettingBtn = true;

		ActivePanelNum = ProgramSettingActive;
	}
	else
	{
		ProgramSettingSpeedButton->Visible = false;
		ProgramSettingPanel->Visible = false;
	}

	if (ActiveSystemSettingBtn)
	{
		if (ActivePanelNum == ProgramSettingActive)
		{
			ProgramSettingSpeedButton->Down = true;

			ProgramSettingPanel->BringToFront();
			this->Width = 660;
			this->Height = 845;//760;

			this->Position = poScreenCenter;
		}
		else if (ActivePanelNum == SecurityActive)
		{
			SecuritySettingSpeedButton->Down = true;

			SecuritySettingPanel->BringToFront();
			this->Width = 660;
			this->Height = 760;

			this->Position = poScreenCenter;
		}
		else if (ActivePanelNum == AuthorityActive)
		{
			AuthoritySettingSpeedButton->Down = true;

			AuthoritySettingPanel->BringToFront();

			this->Width = 1044;
			this->Height = 1560;
			this->Position = poScreenCenter;

			SetAuthorityGridTable(&ProgramAccessAuthorityData);

			bRevAuthorityMode = false;
		}
	}

	if (ComputerSystemInfo.InactivityLogoutEnabled)
	{
		InactivityLogoutCheckBox->Checked = true;
	}
	else
	{
		InactivityLogoutCheckBox->Checked = false;
	}

	InactivityTimeoutEdit->Text = IntToStr(ComputerSystemInfo.InactivityTimeout);

	if (ComputerSystemInfo.FirstLoginChangePW)
	{
		FirstLoginChangePWCheckBox->Checked = true;
	}
	else
	{
		FirstLoginChangePWCheckBox->Checked = false;
	}

	if (ComputerSystemInfo.PasswordExpirationEnabled)
	{
		PasswordExpirationCheckBox->Checked = true;
	}
	else
	{
		PasswordExpirationCheckBox->Checked = false;
	}
	TntEdit1->Text = IntToStr(ComputerSystemInfo.PasswordFailAvailableCount);
	PasswordExpirationTimeEdit->Text = IntToStr(ComputerSystemInfo.PasswordExpirationTime);
	PasswordMinLengthEdit->Text = IntToStr(ComputerSystemInfo.PasswordMinLength);

	InspectionContinueOnRestartCheckBox->Checked = !PCProgramOption.InspectionResetOnRestart;
	QuickStartCheckBox->Checked = PCProgramOption.QuickStartEnabled;
	APPCheckBox->Checked = PCProgramOption.AppButtonEnabled;
	FPGASecurityCheckbox->Checked = PCProgramOption.FPGAVersionEnabled;
	SCADASystemSwitchCheckBox->Checked = PCProgramOption.SCADASystemSwitchEnabled;

  UpstreamCheckbox->Checked = PCProgramOption.UVLaserUpstreamEnabled;
  DownstreamCheckbox->Checked = PCProgramOption.UVLaserDownstreamEnabled;
  //ѱݸ
  UVLaserCheckBox->Checked = PCProgramOption.UVLaserEnabled;
	TwoSplitterActivationCheckBox->Checked = PCProgramOption.TwoSplitterEnable;

	DHCheckbox->Checked = PCProgramOption.DHprogram;
	HICheckbox->Checked = PCProgramOption.HIprogram;
	DHCheckBox2->Checked = PCProgramOption.DHGradeHideProgram;
	SensorOutputSettingCheckBox->Checked = PCProgramOption.SensorOutputSettingOption;
	IncludeUninsTabletCheckBox->Checked = PCProgramOption.IncludeUnInsTabletCount;

	if (PCProgramOption.AppButtonEnabled == 1)
	{
		APPCheckBox->Checked = true;
	}
	else
	{
		APPCheckBox->Checked = false;
	}
	if (PCProgramOption.FPGAVersionEnabled == 1)
	{
		FPGASecurityCheckbox->Checked = true;
	}
	else
	{
		FPGASecurityCheckbox->Checked = false;
	}

	if (PCProgramOption.PrintModeOption == 0)	//  
	{
		PrintGradeOnlyRadioButton->Checked = true;
	}
	else		//  ũ 
	{
		PrintGradeAndSizeRadioButton->Checked = true;
	}

	if (PCProgramOption.PrintThreeDHeightOption == 0)	// ġ ǥ
	{
		PrintThreeDHeightValueRadioButton->Checked = true;
	}
	else		//  ǥ
	{
		PrintThreeDHeightGradeRadioButton->Checked = true;
	}

	if (PCProgramOption.DetailRportView == true)
	{
		DetailReportCheckBox->Checked = true;
	}
	else
	{
		DetailReportCheckBox->Checked = false;
	}

	/*if (PCProgramOption.PrintEQName == true)
	{
	EQnameOutputCheckBox->Checked = true;
	}
	else
	{
	EQnameOutputCheckBox->Checked = false;
	}*/

	NameofmachineEdit->Text = PCProgramOption.Nameofmachine;
	MachineIDEdit->Text = PCProgramOption.MachineID;

	if (PCProgramOption.DHprogram)
	{
		DHCheckbox->Checked = true;
	}
	else
	{
		DHCheckbox->Checked = false;
	}

	if (PCProgramOption.HIprogram)
	{
		HICheckbox->Checked = true;
	}
	else
	{
		HICheckbox->Checked = false;
	}

	//ѱݸ
	if (PCProgramOption.TwoSplitterEnable)
	{
		TwoSplitterActivationCheckBox->Checked = true;
	}
	else
	{
		TwoSplitterActivationCheckBox->Checked = false;
	}

	//ѱݸ
	if (DHCheckbox->Checked == true)
		TntRadioGroup2->Visible = true;
	else
		TntRadioGroup2->Visible = false;

	//ѱݸ
	// й => ȣ UI  ؼ ٽ RadioGroup · ߰ .
	if (PCProgramOption.DistributorType1)
	{
		//TntDistributorType1->Checked = true;
		TntRadioGroup2->ItemIndex = 0;
	}
	else if (PCProgramOption.DistributorType2)
	{
		//TntDistributorType2->Checked = true;
		TntRadioGroup2->ItemIndex = 1;
	}
	else if (PCProgramOption.DistributorType3)
	{
		//TntDistributorType3->Checked = true;
		TntRadioGroup2->ItemIndex = 2;
	}
	else if (PCProgramOption.DistributorType4)
	{
		//TntDistributorType3->Checked = true;
		TntRadioGroup2->ItemIndex = 3;
	}
	else
	{
		TntRadioGroup2->ItemIndex = 2;
	}

  ConveyorCheckBox->Checked =  PCProgramOption.DistributorConveyerEnable;

	/*switch(TntRadioGroup2->ItemIndex)
	{
	case 0 :
	{
	PCProgramOption.DistributorType1 = true;
	break;
	}
	case 1 :
	{
	PCProgramOption.DistributorType2 = true;
	break;
	}
	case 2 :
	{
	PCProgramOption.DistributorType3 = true;
	break;
	}
	}   */

	if (PCProgramOption.SensorOutputSettingOption)
	{
		SensorOutputSettingCheckBox->Checked = true;
	}
	else
	{
		SensorOutputSettingCheckBox->Checked = false;
	}

	ResolutionSettingFunctionEnableCheckBox->Checked = PCProgramOption.ActiveResolutionSetting;

	if (ResolutionSettingFunctionEnableCheckBox->Checked)
	{
		if (PCProgramOption.InitSubSamplingMode == 0)
		{
			SubSamplingStandardRadioButton->Checked = true;
		}
		else
		{
			SubSamplingHDRadioButton->Checked = true;
		}

		SubSamplingStandardRadioButton->Enabled = true;
		SubSamplingHDRadioButton->Enabled = true;
	}
	else
	{
		SubSamplingStandardRadioButton->Checked = true;

		SubSamplingStandardRadioButton->Enabled = false;
		SubSamplingHDRadioButton->Enabled = false;
	}

	IncludeUninsTabletCheckBox->Checked = PCProgramOption.IncludeUnInsTabletCount;

	SDMinSpeedEdit->Text = IntToStr(PCProgramOption.MotorMinSpeed[0]);
	SDMaxSpeedEdit->Text = IntToStr(PCProgramOption.MotorMaxSpeed[0]);
	BFIDMinSpeedEdit->Text = IntToStr(PCProgramOption.MotorMinSpeed[1]);
	BFIDMaxSpeedEdit->Text = IntToStr(PCProgramOption.MotorMaxSpeed[1]);
	BFODMinSpeedEdit->Text = IntToStr(PCProgramOption.MotorMinSpeed[2]);
	BFODMaxSpeedEdit->Text = IntToStr(PCProgramOption.MotorMaxSpeed[2]);

	ProgramOptionPageControl->ActivePage = InspectionScreenTabSheet;

	AjantaReportCompanyNameComboBox->ItemIndex = PCProgramOption.AjantaLocalNameNum;

  bRevAuthorityLevel = false;
	bRevAuthorityMode = false;

	CareUpperLowCaseCheckBox->Checked = PCProgramOption.CareUpperLowCasePasswordEnabled;
	ResultGraphOptCheckBox->Checked = PCProgramOption.ResultGraphOpt;
  TcpIpMonitorActiveCheckBox->Checked = PCProgramOption.TcpIpMonitorActive;  
  SPB_HCB_CntMatchingOptOffCheckBox->Checked = PCProgramOption.InsRepOpt.SPB_HCB_InsCntMatchingOptionOff;

  if(PCProgramOption.CSV_PrintMaxPageChangeActive)
  {
  	CSV_PrintMaxPageCntComboBox->Checked = true;
    CSV_PrintMaxPageCntEdit->Enabled = true;
  }
  else
  {
  	CSV_PrintMaxPageCntComboBox->Checked = false;
    CSV_PrintMaxPageCntEdit->Enabled = false;
  }
  
  CSV_PrintMaxPageCntEdit->Text = IntToStr(PCProgramOption.CSV_PrintMaxPageCnt);   

	if(PCProgramOption.BackupSpeedMode == BACKUP_PROCESS_SPEED_FAST)
	{
		BackupFastSpeedRadioButton->Checked = true;
	}
	else
	{
		BackupNormalSpeedRadioButton->Checked = true;	
	}

    PrintInsResUserDisplayRadioGroupBox->ItemIndex = PCProgramOption.PrintInsResUserDisplayOpt; 
   	AllAuthorityNotActiveCheckBox->Checked = PCProgramOption.AllAuthorityNotActive;

	if(VibratorFeederSpeedControlOptCheckBox->Checked)
	{
		PCProgramOption.VibratorFeederSpeedControlOpt = true;
	}
	else
	{
		PCProgramOption.VibratorFeederSpeedControlOpt = false;
	}    

	if(SendCompleteSigDistributorCheckBox->Checked)
	{
		PCProgramOption.SendCompleteSigDistributor = true;
	}
	else
	{
		PCProgramOption.SendCompleteSigDistributor = false;
	}	

    if(UserInfo.AccessLevel == SYSTEM_HIGHEST_ACCESS_LEVEL)
    {
    	AllAuthorityNotActiveCheckBox->Visible = true;
    }        

	if (userIDList != NULL)
	{
		delete userIDList;
	}

	userIDList = new TStringList;

  bNeedLogOut = false;
}
//---------------------------------------------------------------------------

void __fastcall TComputerSystemSettingForm::OkButtonClick(TObject *Sender)
{
	bool bError = false;

	TComputerSystemInfo computerSystemInfo;
	memcpy(&ComputerSystemInfo, &computerSystemInfo, sizeof(TComputerSystemInfo));
	AnsiString saveFileName = ProgramPath.Env + "\\SystemInfor.ini";
	//WriteComputerSystemInfo(saveFileName, ComputerSystemInfo);

	computerSystemInfo.InactivityLogoutEnabled = InactivityLogoutCheckBox->Checked;
	try
	{
		computerSystemInfo.InactivityTimeout = StrToInt(InactivityTimeoutEdit->Text);
	}
	catch (...)
	{
		computerSystemInfo.InactivityTimeout = 5;
	}

	computerSystemInfo.FirstLoginChangePW = FirstLoginChangePWCheckBox->Checked; 
	computerSystemInfo.PasswordExpirationEnabled = PasswordExpirationCheckBox->Checked;
	try
	{
		computerSystemInfo.PasswordExpirationTime = StrToInt(PasswordExpirationTimeEdit->Text);
	}
	catch (...)
	{
		computerSystemInfo.PasswordExpirationTime = 60;
	}

	try
	{
		computerSystemInfo.PasswordMinLength = StrToInt(PasswordMinLengthEdit->Text);
	}
	catch (...)
	{
		computerSystemInfo.PasswordMinLength = 1;
	}

	computerSystemInfo.PasswordFailAvailableCount = StrToInt(TntEdit1->Text);

	if (computerSystemInfo.InactivityTimeout < 1)
	{
		ShowMessageFA(COMPUTERSYSTEMSETTINGFORM_MSG_03);
		bError = true;
	}
	if (computerSystemInfo.PasswordExpirationTime < 1)
	{
		ShowMessageFA(COMPUTERSYSTEMSETTINGFORM_MSG_01);
		bError = true;
	}
	if (computerSystemInfo.PasswordMinLength < 3)
	{
		TntEdit1->Text = "3";
		ShowMessageFA(COMPUTERSYSTEMSETTINGFORM_MSG_02);
		bError = true;
	}

	if (!bError)
	{
		memcpy(&ComputerSystemInfo, &computerSystemInfo, sizeof(TComputerSystemInfo));
		saveFileName = ProgramPath.Env + "\\SystemInfor.ini";
		WriteComputerSystemInfo(saveFileName, ComputerSystemInfo);
	}


	// pc program option
	try
	{
		PCProgramOption.InspectionResetOnRestart = !InspectionContinueOnRestartCheckBox->Checked;
		PCProgramOption.QuickStartEnabled = QuickStartCheckBox->Checked;
		PCProgramOption.AppButtonEnabled = APPCheckBox->Checked;
		PCProgramOption.FPGAVersionEnabled = FPGASecurityCheckbox->Checked;

		if (APPCheckBox->Checked)
		{
			PCProgramOption.AppButtonEnabled = 1;
			//InspectionForm->APP->Visible = true;
		}
		else
		{
			PCProgramOption.AppButtonEnabled = 0;
			//InspectionForm->APP->Visible = false;
		}
		if (FPGASecurityCheckbox->Checked)
		{
			PCProgramOption.FPGAVersionEnabled = 1;
		}
		else
		{
			PCProgramOption.FPGAVersionEnabled = 0;
		}

	 	if (PrintGradeOnlyRadioButton->Checked)
		{
			PCProgramOption.PrintModeOption = 0;
		}
		else
		{
			PCProgramOption.PrintModeOption = 1;
		}

		if (DetailReportCheckBox->Checked)
		{
			PCProgramOption.DetailRportView = true;
		}
		else
		{
			PCProgramOption.DetailRportView = false;
		}

		if (PrintThreeDHeightValueRadioButton->Checked)	// ġ ǥ
		{
			PCProgramOption.PrintThreeDHeightOption = 0;
		}
		else		//  ǥ
		{
			PCProgramOption.PrintThreeDHeightOption = 1;
		}

		//ѱݸ -------
		if (DHCheckbox->Checked)
		{
			PCProgramOption.DHprogram = 1;
		}
		else
		{
			PCProgramOption.DHprogram = 0;
		}

		//ѱݸ
		if (TwoSplitterActivationCheckBox->Checked)
		{
			PCProgramOption.TwoSplitterEnable = 1;
		}
		else
		{
			PCProgramOption.TwoSplitterEnable = 0;
		}

		//ѱݸ
		// й   ߰
		if (TntRadioGroup2->ItemIndex == 0)
		{
			PCProgramOption.DistributorType1 = 1;
			PCProgramOption.DistributorType2 = 0;
			PCProgramOption.DistributorType3 = 0;
			PCProgramOption.DistributorType4 = 0;
		}
		else if (TntRadioGroup2->ItemIndex == 1)
		{
			PCProgramOption.DistributorType1 = 0;
			PCProgramOption.DistributorType2 = 1;
			PCProgramOption.DistributorType3 = 0;
			PCProgramOption.DistributorType4 = 0;
		}
		else if (TntRadioGroup2->ItemIndex == 2)
		{
			PCProgramOption.DistributorType1 = 0;
			PCProgramOption.DistributorType2 = 0;
			PCProgramOption.DistributorType3 = 1;
			PCProgramOption.DistributorType4 = 0;
		}
		else if (TntRadioGroup2->ItemIndex == 3)
		{
			PCProgramOption.DistributorType1 = 0;
			PCProgramOption.DistributorType2 = 0;
			PCProgramOption.DistributorType3 = 0;
			PCProgramOption.DistributorType4 = 1;
		}
		else
		{
			PCProgramOption.DistributorType1 = 0;
			PCProgramOption.DistributorType2 = 0;
			PCProgramOption.DistributorType3 = 0;
			PCProgramOption.DistributorType4 = 0;
		}

    PCProgramOption.DistributorConveyerEnable = ConveyorCheckBox->Checked;

		if (HICheckbox->Checked)
		{
			PCProgramOption.HIprogram = 1;
		}
		else
		{
			PCProgramOption.HIprogram = 0;
		}

		if (SensorOutputSettingCheckBox->Checked)
		{
			PCProgramOption.SensorOutputSettingOption = 1;
			AdvMachineControlForm->TntGroupBox1->Visible = true;
		}
		else
		{
			PCProgramOption.SensorOutputSettingOption = 0;
			AdvMachineControlForm->TntGroupBox1->Visible = false;
		}

		if (DHCheckBox2->Checked)
			PCProgramOption.DHGradeHideProgram = 1;
		else
			PCProgramOption.DHGradeHideProgram = 0;

		PCProgramOption.SCADASystemSwitchEnabled = SCADASystemSwitchCheckBox->Checked;
		PCProgramOption.IncludeUnInsTabletCount = IncludeUninsTabletCheckBox->Checked;

		PCProgramOption.UVLaserEnabled = UVLaserCheckBox->Checked;

    PCProgramOption.UVLaserUpstreamEnabled = UpstreamCheckbox->Checked;
    PCProgramOption.UVLaserDownstreamEnabled = DownstreamCheckbox->Checked;

		PCProgramOption.MotorMinSpeed[0] = StrToInt(SDMinSpeedEdit->Text);
		PCProgramOption.MotorMaxSpeed[0] = StrToInt(SDMaxSpeedEdit->Text);
		PCProgramOption.MotorMinSpeed[1] = StrToInt(BFIDMinSpeedEdit->Text);
		PCProgramOption.MotorMaxSpeed[1] = StrToInt(BFIDMaxSpeedEdit->Text);
		PCProgramOption.MotorMinSpeed[2] = StrToInt(BFODMinSpeedEdit->Text);
		PCProgramOption.MotorMaxSpeed[2] = StrToInt(BFODMaxSpeedEdit->Text);

		PCProgramOption.AjantaLocalNameNum = AjantaReportCompanyNameComboBox->ItemIndex;

		PCProgramOption.ActiveResolutionSetting = ResolutionSettingFunctionEnableCheckBox->Checked;

		if (PCProgramOption.ActiveResolutionSetting)
		{
			if (SubSamplingHDRadioButton->Checked)
			{
				PCProgramOption.InitSubSamplingMode = RESOLUTION_HIGH_QUALITY;
			}
			else
			{
				PCProgramOption.InitSubSamplingMode = RESOLUTION_NORMAL_QUALITY;
			}
		}
		else
		{
			PCProgramOption.InitSubSamplingMode = RESOLUTION_NORMAL_QUALITY;
		}

    PCProgramOption.MachineID = MachineIDEdit->Text;
		PCProgramOption.Nameofmachine = NameofmachineEdit->Text;

		PCProgramOption.CareUpperLowCasePasswordEnabled = CareUpperLowCaseCheckBox->Checked;
    PCProgramOption.ResultGraphOpt = ResultGraphOptCheckBox->Checked;
    PCProgramOption.TcpIpMonitorActive = TcpIpMonitorActiveCheckBox->Checked;  
    PCProgramOption.InsRepOpt.SPB_HCB_InsCntMatchingOptionOff = SPB_HCB_CntMatchingOptOffCheckBox->Checked;

    if(CSV_PrintMaxPageCntComboBox->Checked)
    {
  	  PCProgramOption.CSV_PrintMaxPageChangeActive = true;
    }
    else
    {
  	  PCProgramOption.CSV_PrintMaxPageChangeActive = false;
    }

    if(BackupFastSpeedRadioButton->Checked)
    {
    	PCProgramOption.BackupSpeedMode = BACKUP_PROCESS_SPEED_FAST;
    }
    else
    {
    	PCProgramOption.BackupSpeedMode = BACKUP_PROCESS_SPEED_NORMAL;    
    }

    PCProgramOption.CSV_PrintMaxPageCnt = StrToInt(CSV_PrintMaxPageCntEdit->Text);

    PCProgramOption.PrintInsResUserDisplayOpt = PrintInsResUserDisplayRadioGroupBox->ItemIndex;
	PCProgramOption.AllAuthorityNotActive = AllAuthorityNotActiveCheckBox->Checked;
    PCProgramOption.VibratorFeederSpeedControlOpt = VibratorFeederSpeedControlOptCheckBox->Checked;
    PCProgramOption.SendCompleteSigDistributor = SendCompleteSigDistributorCheckBox->Checked;    

		AnsiString saveFileName = ProgramPath.Env + "\\UserInfor.ini";
		WritePCProgramOption(saveFileName, PCProgramOption);

	AnsiString saveBackupProgramFileName = ProgramPath.Env + "\\BackupProgramInfor.ini";
	WriteBackupProgramOption(saveBackupProgramFileName, PCProgramOption);
		
    ModalResult = mrOk;

	}
	catch (...)
	{
    ModalResult = mrCancel;
	}

}
//---------------------------------------------------------------------------

void __fastcall TComputerSystemSettingForm::SecuritySettingSpeedButtonClick(
	TObject *Sender)
{
	if (ActivePanelNum == SecurityActive)
		return;
	else
		ActivePanelNum = SecurityActive;

	SecuritySettingPanel->BringToFront();
	this->Width = 660;
	this->Height = 760;
	this->Position = poScreenCenter;
}
//---------------------------------------------------------------------------

void __fastcall TComputerSystemSettingForm::ProgramSettingSpeedButtonClick(
	TObject *Sender)
{
	if (ActivePanelNum == ProgramSettingActive)
		return;
	else
		ActivePanelNum = ProgramSettingActive;

	//TntGroupBox2->Visible = false;
	ProgramSettingPanel->BringToFront();
	this->Width = 660;
	this->Height = 845;//760;

	this->Position = poScreenCenter;
}
//---------------------------------------------------------------------------

void __fastcall TComputerSystemSettingForm::AuthoritySettingSpeedButtonClick(
	TObject *Sender)
{
	if (ActivePanelNum == AuthorityActive)
		return;
	else
		ActivePanelNum = AuthorityActive;

  this->Width = 1044;
	this->Height = 1560;
	this->Position = poScreenCenter;
  
	AuthoritySettingPanel->BringToFront();
  SetAuthorityGridTable(&ProgramAccessAuthorityData);
  bRevAuthorityMode = false;
}
//---------------------------------------------------------------------------
void __fastcall TComputerSystemSettingForm::TntPanel1DblClick(
	TObject *Sender)
{
	/*if (TntGroupBox2->Visible == false)
		TntGroupBox2->Visible = true;
	else
		TntGroupBox2->Visible = false; */

  if(CareUpperLowCaseCheckBox->Visible)
  {
    CareUpperLowCaseCheckBox->Visible = false;
  }
  else
  {
    CareUpperLowCaseCheckBox->Visible = true;
  }

  if(ReportOptionGroupBox2->Visible)
  {
    ReportOptionGroupBox2->Visible = false;
  }
  else
  {
    ReportOptionGroupBox2->Visible = true;
  }

  if(CSV_ReportOptionGroupBox1->Visible)
  {
    CSV_ReportOptionGroupBox1->Visible = false;
  }
  else
  {
    CSV_ReportOptionGroupBox1->Visible = true;
  }  

}
//------------------------------------------------------------------------
void __fastcall TComputerSystemSettingForm::SDMinSpeedEditKeyPress(
	TObject *Sender, char &Key)
{
	Key = NULL;
}
//---------------------------------------------------------------------------

void __fastcall TComputerSystemSettingForm::TntFormShow(TObject *Sender)
{
  if (SecuritySettingSpeedButton->Down)
	{
		this->Width = 660;
    this->Height = 760;
		SecuritySettingPanel->BringToFront();
		ActivePanelNum = SecurityActive;
	}
	if (AuthoritySettingSpeedButton->Down)
	{
		this->Width = 1044;
    this->Height = 1560;
		AuthoritySettingPanel->BringToFront();
		ActivePanelNum = AuthorityActive;
	}
	if (ProgramSettingSpeedButton->Down)
	{
		this->Width = 660;
    this->Height = 845;//760;
		ProgramSettingPanel->BringToFront();
		ActivePanelNum = ProgramSettingActive;
	}

	if (MachineSetupData.CompanyID == INTERNATIONAL_MACHINE1 || MachineSetupData.CompanyID == DOMESTIC_MACHINE2)
		TntGroupBox1->Visible = true;
}
//---------------------------------------------------------------------------
void __fastcall TComputerSystemSettingForm::DHCheckboxClick(
	TObject *Sender)
{
	if (DHCheckbox->Checked == true)
	{
		TntRadioGroup2->Visible = true;
    if(TntRadioGroup2->ItemIndex == 2) ConveyorCheckBox->Visible = true;
		TwoSplitterActivationCheckBox->Checked = false;
	}
	else
  {
		TntRadioGroup2->Visible = false;
    ConveyorCheckBox->Visible = false;
  }
}
//---------------------------------------------------------------------------

void __fastcall TComputerSystemSettingForm::TwoSplitterActivationCheckBoxClick(
	TObject *Sender)
{
	if (TwoSplitterActivationCheckBox->Checked == true)
	{
		DHCheckbox->Checked = false;
	}
}
//---------------------------------------------------------------------------

void __fastcall TComputerSystemSettingForm::ResolutionSettingFunctionEnableCheckBoxClick(
	TObject *Sender)
{
	if (ResolutionSettingFunctionEnableCheckBox->Checked)
	{
		SubSamplingStandardRadioButton->Enabled = true;
		SubSamplingHDRadioButton->Enabled = true;
	}
	else
	{
		SubSamplingStandardRadioButton->Checked = true;

		SubSamplingStandardRadioButton->Enabled = false;
		SubSamplingHDRadioButton->Enabled = false;
	}
}
//---------------------------------------------------------------------------

void __fastcall TComputerSystemSettingForm::NameofmachineEditClick(
	TObject *Sender)
{
	TTntEdit *theEdit = (TTntEdit *)Sender;
	TKeyboardForm *logInKeyboardForm = new TKeyboardForm(this);	// Ű Է  ڵ α׾ƿ Ǵ Ȳ óϱ Ͽ Ű带  .
	logInKeyboardForm->IsHangulMode = KeyboardForm->IsHangulMode;
	logInKeyboardForm->CapsLockState = KeyboardForm->CapsLockState;
	logInKeyboardForm->Text = theEdit->Text;
	if (logInKeyboardForm->ShowKeyboard() == mrOk)
	{
		theEdit->Text = logInKeyboardForm->Text;
	}
	KeyboardForm->IsHangulMode = logInKeyboardForm->IsHangulMode;
	KeyboardForm->CapsLockState = logInKeyboardForm->CapsLockState;
	delete logInKeyboardForm;
}
//---------------------------------------------------------------------------

void __fastcall TComputerSystemSettingForm::AuthrorityReviseOrSaveBtnClick(
	TObject *Sender)
{
	if (!bRevAuthorityMode)
	{
		if (MessageDlgFA(COMPUTER_SYSTEM_SETTING_NEW_AUTHORITY_SETUP_MSG_11, mtConfirmation, TMsgDlgButtons() << mbOK << mbCancel) == mrOk)
		{
			bRevAuthorityMode = true;

      AuthrorityReviseOrSaveBtn->Caption = COMPUTER_SYSTEM_SETTING_NEW_AUTHORITY_SETUP_TEXT_08;
			AuthorityStringGrid->Enabled = true;

			OkButton->Enabled = false;
			CancelButton->Enabled = false;

			AuthorityRestoreBtn->Enabled = true;
			AddAuthorityBtn->Enabled = true;
			DeleteAuthorityBtn->Enabled = true;
			UserAuthoritySettingBtn->Enabled = false;
			AuthoritySettingCancelBtn->Visible = true;

			bRevAuthorityLevel = false;

			tempProgramAccessAuthorityData.SystemAuthorityCount = ProgramAccessAuthorityData.SystemAuthorityCount;

			for (int AuthorityID = 0; AuthorityID < ProgramAccessAuthorityData.SystemAuthorityCount; AuthorityID++)
			{
				tempProgramAccessAuthorityData.ProgramAccessAuthorityName[AuthorityID] = ProgramAccessAuthorityData.ProgramAccessAuthorityName[AuthorityID];
			}

			for (int EventID = 0; EventID < MAX_UI_ACCESS_EVENT; EventID++)
			{
				tempProgramAccessAuthorityData.ProgramAccessEventSerialNumber[EventID] = ProgramAccessAuthorityData.ProgramAccessEventSerialNumber[EventID];
			}

			for (int EventID = 0; EventID < MAX_UI_ACCESS_EVENT; EventID++)
			{
				tempProgramAccessAuthorityData.ProgramAccessEventDescription[EventID] = ProgramAccessAuthorityData.ProgramAccessEventDescription[EventID];
			}

			for (int AuthorityID = 0; AuthorityID < ProgramAccessAuthorityData.SystemAuthorityCount; AuthorityID++)
			{
				for (int EventID = 0; EventID < MAX_UI_ACCESS_EVENT; EventID++)
				{
					tempProgramAccessAuthorityData.ProgramAccessAuthorityTable[AuthorityID][EventID] = ProgramAccessAuthorityData.ProgramAccessAuthorityTable[AuthorityID][EventID];
				}
			}

			AuthorityStringGrid->FixedColor = (TColor)0x00A7EDEF;
		}
	}
	else
	{
		if (MessageDlgFA(COMPUTER_SYSTEM_SETTING_NEW_AUTHORITY_SETUP_MSG_01, mtConfirmation, TMsgDlgButtons() << mbOK << mbCancel) == mrOk)
		{
			bool bResetUserIDAuthority = false;
			bool bCompletedResetUserIDAuthority = false;
			bool bUserExist = false;
			if (bRevAuthorityLevel)
			{
				TIniFile *iniFile = new TIniFile(ProgramPath.Env + "\\user.ini");

				if (iniFile)
				{
					iniFile->ReadSections(userIDList);

					if (userIDList->Count > 0)
					{
						bUserExist = true;
					}
				}

				delete iniFile;

				if (bUserExist)
				{
					if (MessageDlgFA(COMPUTER_SYSTEM_SETTING_NEW_AUTHORITY_SETUP_MSG_02, mtConfirmation, TMsgDlgButtons() << mbOK << mbCancel) == mrOk)
					{
						bResetUserIDAuthority = true;

						TUserAuthoritySettingForm *UserAuthoritySettingForm = new TUserAuthoritySettingForm(this);

						UserAuthoritySettingForm->tempProgramAccessAuthorityData.SystemAuthorityCount = tempProgramAccessAuthorityData.SystemAuthorityCount;

						for (int AuthorityID = 0; AuthorityID < tempProgramAccessAuthorityData.SystemAuthorityCount; AuthorityID++)
						{
							UserAuthoritySettingForm->tempProgramAccessAuthorityData.ProgramAccessAuthorityName[AuthorityID] = tempProgramAccessAuthorityData.ProgramAccessAuthorityName[AuthorityID];
						}

						for (int EventID = 0; EventID < MAX_UI_ACCESS_EVENT; EventID++)
						{
							UserAuthoritySettingForm->tempProgramAccessAuthorityData.ProgramAccessEventSerialNumber[EventID] = tempProgramAccessAuthorityData.ProgramAccessEventSerialNumber[EventID];
						}

						for (int EventID = 0; EventID < MAX_UI_ACCESS_EVENT; EventID++)
						{
							UserAuthoritySettingForm->tempProgramAccessAuthorityData.ProgramAccessEventDescription[EventID] = tempProgramAccessAuthorityData.ProgramAccessEventDescription[EventID];
						}

						for (int AuthorityID = 0; AuthorityID < tempProgramAccessAuthorityData.SystemAuthorityCount; AuthorityID++)
						{
							for (int EventID = 0; EventID < MAX_UI_ACCESS_EVENT; EventID++)
							{
								UserAuthoritySettingForm->tempProgramAccessAuthorityData.ProgramAccessAuthorityTable[AuthorityID][EventID] = tempProgramAccessAuthorityData.ProgramAccessAuthorityTable[AuthorityID][EventID];
							}
						}

						if (UserAuthoritySettingForm->ShowModal() != mrOk)
						{
							ShowMessageFA(SYSTEM_AUTHORITY_REVISION_FAIL_MSG);

							delete UserAuthoritySettingForm;
							return;
						}
						else
						{
							bCompletedResetUserIDAuthority = true;

              if(bInitProgramAuthority)
              {
                iniFile = new TIniFile(ProgramPath.Env + "\\SystemAuthorityInformation.ini");
                if (iniFile)
                {
                  iniFile->WriteBool("Initial Authority Complete", "State", true);
                }
                delete iniFile;

                bInitProgramAuthority = false;
              }
						}

						delete UserAuthoritySettingForm;
					}
					else
					{
						ShowMessageFA(SYSTEM_AUTHORITY_REVISION_FAIL_MSG);
						return;
					}
				}
			}

			if (!bResetUserIDAuthority || (bResetUserIDAuthority && bCompletedResetUserIDAuthority))
			{
				ProgramAccessAuthorityData.SystemAuthorityCount = tempProgramAccessAuthorityData.SystemAuthorityCount;

				for (int AuthorityID = 0; AuthorityID < tempProgramAccessAuthorityData.SystemAuthorityCount; AuthorityID++)
				{
					ProgramAccessAuthorityData.ProgramAccessAuthorityName[AuthorityID] = tempProgramAccessAuthorityData.ProgramAccessAuthorityName[AuthorityID];
				}

				for (int EventID = 0; EventID < MAX_UI_ACCESS_EVENT; EventID++)
				{
					ProgramAccessAuthorityData.ProgramAccessEventSerialNumber[EventID] = tempProgramAccessAuthorityData.ProgramAccessEventSerialNumber[EventID];
				}

				for (int EventID = 0; EventID < MAX_UI_ACCESS_EVENT; EventID++)
				{
					ProgramAccessAuthorityData.ProgramAccessEventDescription[EventID] = tempProgramAccessAuthorityData.ProgramAccessEventDescription[EventID];
				}

				for (int AuthorityID = 0; AuthorityID < tempProgramAccessAuthorityData.SystemAuthorityCount; AuthorityID++)
				{
					for (int EventID = 0; EventID < MAX_UI_ACCESS_EVENT; EventID++)
					{
						ProgramAccessAuthorityData.ProgramAccessAuthorityTable[AuthorityID][EventID] = tempProgramAccessAuthorityData.ProgramAccessAuthorityTable[AuthorityID][EventID];
					}
				}

				WriteSystemUserAuthorityInformation(ProgramPath.Env + "\\SystemAuthorityInformation.ini");

        bNeedLogOut = true;

				ShowMessageFA(SYSTEM_AUTHORITY_REVISION_SUCCESS_MSG);

				bRevAuthorityMode = false;

				AuthrorityReviseOrSaveBtn->Caption = COMPUTER_SYSTEM_SETTING_NEW_AUTHORITY_SETUP_TEXT_02;
				AuthorityStringGrid->Enabled = false;

				OkButton->Enabled = true;
				CancelButton->Enabled = true;

				AuthorityRestoreBtn->Enabled = false;
				AddAuthorityBtn->Enabled = false;
				DeleteAuthorityBtn->Enabled = false;
				UserAuthoritySettingBtn->Enabled = true;
				AuthoritySettingCancelBtn->Visible = false;

				AuthorityStringGrid->FixedColor = (TColor)clGray;

        OkButton->OnClick;
			}
		}
	}
}
//---------------------------------------------------------------------------

void __fastcall TComputerSystemSettingForm::SetAuthorityGridTable(TProgramAccessAuthorityData *pProgramAccessAuthorityData)
{
	AuthorityStringGrid->ColCount = 2 + pProgramAccessAuthorityData->SystemAuthorityCount - 1; // System 

	int remainWidth;
	int authorityNameWidth;
	AuthorityStringGrid->ColWidths[0] = 80;
	AuthorityStringGrid->ColWidths[1] = 340;

	remainWidth = AuthorityStringGrid->Width - (AuthorityStringGrid->ColWidths[0] + AuthorityStringGrid->ColWidths[1]) - 10;
	authorityNameWidth = remainWidth / (pProgramAccessAuthorityData->SystemAuthorityCount - 1);

	for (int AuthorityID = 1; AuthorityID < pProgramAccessAuthorityData->SystemAuthorityCount; AuthorityID++)
	{
		AuthorityStringGrid->ColWidths[1 + AuthorityID] = authorityNameWidth;
	}

	AuthorityStringGrid->Refresh();

	AuthorityStringGrid->Cells[0][0] = "Sr/Num";
	AuthorityStringGrid->Cells[1][0] = "Description";

	for (int AuthorityID = 1; AuthorityID < pProgramAccessAuthorityData->SystemAuthorityCount; AuthorityID++)
	{
		AuthorityStringGrid->Cells[1 + AuthorityID][0] = pProgramAccessAuthorityData->ProgramAccessAuthorityName[AuthorityID];
	}

	for (int EventID = 0; EventID < MAX_UI_ACCESS_EVENT; EventID++)
	{
		AuthorityStringGrid->Cells[0][1 + EventID] = pProgramAccessAuthorityData->ProgramAccessEventSerialNumber[EventID];
	}

	for (int EventID = 0; EventID < MAX_UI_ACCESS_EVENT; EventID++)
	{
		AuthorityStringGrid->Cells[1][1 + EventID] = pProgramAccessAuthorityData->ProgramAccessEventDescription[EventID];
	}

	for (int AuthorityID = 1; AuthorityID < pProgramAccessAuthorityData->SystemAuthorityCount; AuthorityID++)
	{
		for (int EventID = 0; EventID < MAX_UI_ACCESS_EVENT; EventID++)
		{
			if (pProgramAccessAuthorityData->ProgramAccessAuthorityTable[AuthorityID][EventID])
			{
				AuthorityStringGrid->Cells[1 + AuthorityID][1 + EventID] = "Enabled ( O )";
			}
			else
			{
				AuthorityStringGrid->Cells[1 + AuthorityID][1 + EventID] = "Disabled ( X )";
			}
		}
	}
}
//---------------------------------------------------------------------------

void __fastcall TComputerSystemSettingForm::AuthorityStringGridSelectCell(
	TObject *Sender, int ACol, int ARow, bool &CanSelect)
{
	int AuthorityID = ACol;
	int EventID = ARow;

	bool nAuthorityValue = !tempProgramAccessAuthorityData.ProgramAccessAuthorityTable[AuthorityID - 1][EventID - 1];

  WideString retValue;
	if (nAuthorityValue)
	{
		retValue = "[Enabled]";
	}
	else
	{
		retValue = "[Disabled]";
	}

  WCHAR TempString[100];
  wsprintfW(TempString, COMPUTER_SYSTEM_SETTING_NEW_AUTHORITY_SETUP_MSG_03, retValue);
  WideString returnStr = WideString(TempString);

	if (MessageDlgFA(returnStr, mtConfirmation, TMsgDlgButtons() << mbOK << mbCancel) == mrOk)
	{
		tempProgramAccessAuthorityData.ProgramAccessAuthorityTable[AuthorityID - 1][EventID - 1] = nAuthorityValue;
	}

	SetAuthorityGridTable(&tempProgramAccessAuthorityData);
}
//---------------------------------------------------------------------------

void __fastcall TComputerSystemSettingForm::AuthorityRestoreBtnClick(
	TObject *Sender)
{
	if (MessageDlgFA(COMPUTER_SYSTEM_SETTING_NEW_AUTHORITY_SETUP_MSG_04, mtConfirmation, TMsgDlgButtons() << mbOK << mbCancel) == mrOk)
	{
		bRevAuthorityLevel = false;

		tempProgramAccessAuthorityData.SystemAuthorityCount = ProgramAccessAuthorityData.SystemAuthorityCount;

		for (int AuthorityID = 0; AuthorityID < ProgramAccessAuthorityData.SystemAuthorityCount; AuthorityID++)
		{
			tempProgramAccessAuthorityData.ProgramAccessAuthorityName[AuthorityID] = ProgramAccessAuthorityData.ProgramAccessAuthorityName[AuthorityID];
		}

		for (int EventID = 0; EventID < MAX_UI_ACCESS_EVENT; EventID++)
		{
			tempProgramAccessAuthorityData.ProgramAccessEventSerialNumber[EventID] = ProgramAccessAuthorityData.ProgramAccessEventSerialNumber[EventID];
		}

		for (int EventID = 0; EventID < MAX_UI_ACCESS_EVENT; EventID++)
		{
			tempProgramAccessAuthorityData.ProgramAccessEventDescription[EventID] = ProgramAccessAuthorityData.ProgramAccessEventDescription[EventID];
		}

		for (int AuthorityID = 0; AuthorityID < ProgramAccessAuthorityData.SystemAuthorityCount; AuthorityID++)
		{
			for (int EventID = 0; EventID < MAX_UI_ACCESS_EVENT; EventID++)
			{
				tempProgramAccessAuthorityData.ProgramAccessAuthorityTable[AuthorityID][EventID] = ProgramAccessAuthorityData.ProgramAccessAuthorityTable[AuthorityID][EventID];
			}
		}

		SetAuthorityGridTable(&tempProgramAccessAuthorityData);
	}
}
//---------------------------------------------------------------------------

void __fastcall TComputerSystemSettingForm::AuthoritySettingCancelBtnClick(
	TObject *Sender)
{
	if (MessageDlgFA(COMPUTER_SYSTEM_SETTING_NEW_AUTHORITY_SETUP_MSG_05, mtConfirmation, TMsgDlgButtons() << mbOK << mbCancel) == mrOk)
	{
		bRevAuthorityMode = false;
		bRevAuthorityLevel = false;

		AuthrorityReviseOrSaveBtn->Caption = COMPUTER_SYSTEM_SETTING_NEW_AUTHORITY_SETUP_TEXT_02;
		AuthorityStringGrid->Enabled = false;

		OkButton->Enabled = true;
		CancelButton->Enabled = true;

		AuthorityRestoreBtn->Enabled = false;
		AddAuthorityBtn->Enabled = false;
		DeleteAuthorityBtn->Enabled = false;
		UserAuthoritySettingBtn->Enabled = true;
		AuthoritySettingCancelBtn->Visible = false;

		AuthorityStringGrid->FixedColor = (TColor)clGray;

		SetAuthorityGridTable(&ProgramAccessAuthorityData);
	}
}
//---------------------------------------------------------------------------

void __fastcall TComputerSystemSettingForm::DeleteAuthorityBtnClick(
	TObject *Sender)
{
	if (tempProgramAccessAuthorityData.SystemAuthorityCount <= MIN_AUTHORITY_COUNT)
	{
		MessageDlgFA(COMPUTER_SYSTEM_SETTING_NEW_AUTHORITY_SETUP_MSG_06, mtConfirmation, TMsgDlgButtons() << mbOK);
	}
	else
	{
		WideString AuthorityName = "";

		for (int AuthorityID = 1; AuthorityID < tempProgramAccessAuthorityData.SystemAuthorityCount; AuthorityID++)
		{
			AuthorityName += IntToStr(AuthorityID) + ". " + tempProgramAccessAuthorityData.ProgramAccessAuthorityName[AuthorityID] + "\r\n";
		}

		if (MessageDlgFA(COMPUTER_SYSTEM_SETTING_NEW_AUTHORITY_SETUP_MSG_07 + AuthorityName, mtConfirmation, TMsgDlgButtons() << mbOK << mbCancel) == mrOk)
		{
			int deleteID;
			KeyboardForm->Text = "";
			if (KeyboardForm->ShowKeypad() == mrOk)
			{
				try
				{
					if (KeyboardForm->Text.Length() != 0 )
					{
						int tempNum = StrToInt(KeyboardForm->Text);

						if (tempNum < 1 || tempNum >= tempProgramAccessAuthorityData.SystemAuthorityCount)
						{
							ShowMessageFA(COMPUTER_SYSTEM_SETTING_NEW_AUTHORITY_SETUP_MSG_08);
						}
						else
						{
							deleteID = tempNum;

							if (deleteID == tempProgramAccessAuthorityData.SystemAuthorityCount - 1)
							{
								tempProgramAccessAuthorityData.ProgramAccessAuthorityName[deleteID] = "";
								tempProgramAccessAuthorityData.SystemAuthorityCount--;
							}
							else
							{
								for (int AuthorityID = deleteID; AuthorityID < tempProgramAccessAuthorityData.SystemAuthorityCount; AuthorityID++)
								{
									tempProgramAccessAuthorityData.ProgramAccessAuthorityName[AuthorityID] = tempProgramAccessAuthorityData.ProgramAccessAuthorityName[AuthorityID + 1];

									for (int EventID = 0; EventID < MAX_UI_ACCESS_EVENT; EventID++)
									{
										tempProgramAccessAuthorityData.ProgramAccessAuthorityTable[AuthorityID][EventID] = tempProgramAccessAuthorityData.ProgramAccessAuthorityTable[AuthorityID + 1][EventID];
									}
								}

								deleteID = tempProgramAccessAuthorityData.SystemAuthorityCount - 1;
								tempProgramAccessAuthorityData.ProgramAccessAuthorityName[deleteID] = "";
								tempProgramAccessAuthorityData.SystemAuthorityCount--;
							}

							bRevAuthorityLevel = true;

							SetAuthorityGridTable(&tempProgramAccessAuthorityData);
						}
					}
					else
					{
						ShowMessageFA(COMPUTER_SYSTEM_SETTING_NEW_AUTHORITY_SETUP_MSG_08);
					}
				}
				catch (...)
				{
					ShowMessageFA(COMPUTER_SYSTEM_SETTING_NEW_AUTHORITY_SETUP_MSG_08);
				}
			}
		}
	}
}
//---------------------------------------------------------------------------

void __fastcall TComputerSystemSettingForm::AddAuthorityBtnClick(
	TObject *Sender)
{
	if (tempProgramAccessAuthorityData.SystemAuthorityCount >= MAX_AUTHORITY_COUNT)
	{
		MessageDlgFA(COMPUTER_SYSTEM_SETTING_NEW_AUTHORITY_SETUP_MSG_09, mtConfirmation, TMsgDlgButtons() << mbOK);
	}
	else
	{
		if (MessageDlgFA(COMPUTER_SYSTEM_SETTING_NEW_AUTHORITY_SETUP_MSG_10, mtConfirmation, TMsgDlgButtons() << mbOK << mbCancel) == mrOk)
		{
			KeyboardForm->Text = "";
			if (KeyboardForm->ShowKeyboard() == mrOk)
			{
				if (KeyboardForm->Text.Length() != 0 )
				{
					bRevAuthorityLevel = true;

					tempProgramAccessAuthorityData.SystemAuthorityCount++;
					tempProgramAccessAuthorityData.ProgramAccessAuthorityName[tempProgramAccessAuthorityData.SystemAuthorityCount - 1] = KeyboardForm->Text;

					for (int EventID = 0; EventID < MAX_UI_ACCESS_EVENT; EventID++)
					{
						tempProgramAccessAuthorityData.ProgramAccessAuthorityTable[tempProgramAccessAuthorityData.SystemAuthorityCount - 1][EventID] = true;
					}

					tempProgramAccessAuthorityData.ProgramAccessAuthorityTable[tempProgramAccessAuthorityData.SystemAuthorityCount - 1][25] = false;
					tempProgramAccessAuthorityData.ProgramAccessAuthorityTable[tempProgramAccessAuthorityData.SystemAuthorityCount - 1][39] = false;

					SetAuthorityGridTable(&tempProgramAccessAuthorityData);
				}
				else
				{
					ShowMessageFA(COMPUTER_SYSTEM_SETTING_NEW_AUTHORITY_SETUP_MSG_08);
				}
			}
		}
	}
}
//---------------------------------------------------------------------------

void __fastcall TComputerSystemSettingForm::AuthorityStringGridMouseDown(
	TObject *Sender, TMouseButton Button, TShiftState Shift, int X,
	int Y)
{
	TRect AuthorityNamePos[MAX_AUTHORITY_COUNT];

	for (int AuthorityID = 1; AuthorityID < tempProgramAccessAuthorityData.SystemAuthorityCount; AuthorityID++)
	{
		AuthorityNamePos[AuthorityID] = AuthorityStringGrid->CellRect(1 + AuthorityID, 0);
	}

	int retID = -1;
	for (int AuthorityID = 1; AuthorityID < tempProgramAccessAuthorityData.SystemAuthorityCount; AuthorityID++)
	{
		if (X > AuthorityNamePos[AuthorityID].left && X < AuthorityNamePos[AuthorityID].right &&
			Y > AuthorityNamePos[AuthorityID].top && Y < AuthorityNamePos[AuthorityID].Bottom)
		{
			retID = AuthorityID;
			break;
		}
	}

	if (retID != -1)
	{
    WCHAR TempString[100];
    wsprintfW(TempString, COMPUTER_SYSTEM_SETTING_NEW_AUTHORITY_SETUP_MSG_13, tempProgramAccessAuthorityData.ProgramAccessAuthorityName[retID]);
    WideString returnStr = WideString(TempString);

		if (MessageDlgFA(returnStr, mtConfirmation, TMsgDlgButtons() << mbOK << mbCancel) == mrOk)
		{
			KeyboardForm->Text = tempProgramAccessAuthorityData.ProgramAccessAuthorityName[retID];
			if (KeyboardForm->ShowKeyboard() == mrOk)
			{
				if (KeyboardForm->Text.Length() != 0 )
				{
					tempProgramAccessAuthorityData.ProgramAccessAuthorityName[retID] = KeyboardForm->Text;
					SetAuthorityGridTable(&tempProgramAccessAuthorityData);
				}
				else
				{
					ShowMessageFA(COMPUTER_SYSTEM_SETTING_NEW_AUTHORITY_SETUP_MSG_08);
				}
			}
		}
	}
}
//---------------------------------------------------------------------------


void __fastcall TComputerSystemSettingForm::UserAuthoritySettingBtnClick(
	TObject *Sender)
{
	bool bUserExist = false;
	TIniFile *iniFile = new TIniFile(ProgramPath.Env + "\\user.ini");

	if (iniFile)
	{
		iniFile->ReadSections(userIDList);

		if (userIDList->Count > 0)
		{
			bUserExist = true;
		}
	}

	delete iniFile;

	if (bUserExist)
	{
		if (MessageDlgFA(COMPUTER_SYSTEM_SETTING_NEW_AUTHORITY_SETUP_MSG_11, mtConfirmation, TMsgDlgButtons() << mbOK << mbCancel) == mrOk)
		{
			TUserAuthoritySettingForm *UserAuthoritySettingForm = new TUserAuthoritySettingForm(this);

			UserAuthoritySettingForm->tempProgramAccessAuthorityData.SystemAuthorityCount = ProgramAccessAuthorityData.SystemAuthorityCount;

			for (int AuthorityID = 0; AuthorityID < ProgramAccessAuthorityData.SystemAuthorityCount; AuthorityID++)
			{
				UserAuthoritySettingForm->tempProgramAccessAuthorityData.ProgramAccessAuthorityName[AuthorityID] = ProgramAccessAuthorityData.ProgramAccessAuthorityName[AuthorityID];
			}

			for (int EventID = 0; EventID < MAX_UI_ACCESS_EVENT; EventID++)
			{
				UserAuthoritySettingForm->tempProgramAccessAuthorityData.ProgramAccessEventSerialNumber[EventID] = ProgramAccessAuthorityData.ProgramAccessEventSerialNumber[EventID];
			}

			for (int EventID = 0; EventID < MAX_UI_ACCESS_EVENT; EventID++)
			{
				UserAuthoritySettingForm->tempProgramAccessAuthorityData.ProgramAccessEventDescription[EventID] = ProgramAccessAuthorityData.ProgramAccessEventDescription[EventID];
			}

			for (int AuthorityID = 0; AuthorityID < ProgramAccessAuthorityData.SystemAuthorityCount; AuthorityID++)
			{
				for (int EventID = 0; EventID < MAX_UI_ACCESS_EVENT; EventID++)
				{
					UserAuthoritySettingForm->tempProgramAccessAuthorityData.ProgramAccessAuthorityTable[AuthorityID][EventID] = ProgramAccessAuthorityData.ProgramAccessAuthorityTable[AuthorityID][EventID];
				}
			}

			if (UserAuthoritySettingForm->ShowModal() == mrOk)
			{
        if(bInitProgramAuthority)
        {
          iniFile = new TIniFile(ProgramPath.Env + "\\SystemAuthorityInformation.ini");
          if (iniFile)
          {
            iniFile->WriteBool("Initial Authority Complete", "State", true);
          }
          delete iniFile;

          bInitProgramAuthority = false;
        }

        bNeedLogOut = true; 
				ShowMessageFA(SYSTEM_AUTHORITY_REVISION_SUCCESS_MSG);

        OkButton->OnClick;
			}
			else
			{
				ShowMessageFA(SYSTEM_AUTHORITY_REVISION_FAIL_MSG);
			}

			delete UserAuthoritySettingForm;
		}
	}
	else
	{
		ShowMessageFA(COMPUTER_SYSTEM_SETTING_NEW_AUTHORITY_SETUP_MSG_12);
	}
}
//---------------------------------------------------------------------------

void __fastcall TComputerSystemSettingForm::TntFormClose(TObject *Sender,
      TCloseAction &Action)
{
  	delete userIDList;
    int bbb = 0;
}
//---------------------------------------------------------------------------

void __fastcall TComputerSystemSettingForm::TntRadioGroup2Click(
      TObject *Sender)
{
  if(TntRadioGroup2->Visible == true)
  {
    if(TntRadioGroup2->ItemIndex == 2 || TntRadioGroup2->ItemIndex == 3) // type3
    {
      ConveyorCheckBox->Visible = true;
    }
    else
    {
      ConveyorCheckBox->Visible = false;
    }
  }
}
//---------------------------------------------------------------------------



void __fastcall TComputerSystemSettingForm::TcpIpMonitorActiveCheckBoxClick(
      TObject *Sender)
{
  if(TcpIpMonitorActiveCheckBox->Checked)
  {
		AllocConsole();
		freopen("CONOUT$","wt",stdout);
  }
  else
  {
		FreeConsole();
		fclose(stdout);  
  }    
}
//---------------------------------------------------------------------------

void __fastcall TComputerSystemSettingForm::CSV_PrintMaxPageCntComboBoxClick(
      TObject *Sender)
{
  if(CSV_PrintMaxPageCntComboBox->Checked)
  {
    CSV_PrintMaxPageCntEdit->Enabled = true;
  }
  else
  {
    CSV_PrintMaxPageCntEdit->Enabled = false;  
  }

   PCProgramOption.CSV_PrintMaxPageChangeActive = CSV_PrintMaxPageCntComboBox->Checked;
}
//---------------------------------------------------------------------------

void __fastcall TComputerSystemSettingForm::CSV_PrintMaxPageCntEditClick(
      TObject *Sender)
{
	TTntEdit *theEdit = (TTntEdit *) Sender;
	KeyboardForm->Text = theEdit->Text;
	if (KeyboardForm->ShowKeypad() == mrOk)
	{
		theEdit->Text = KeyboardForm->Text;
	}
}
//---------------------------------------------------------------------------

