//---------------------------------------------------------------------------
// For SELMA200, 20180223, moon, 
// NFA Camera  ؿ  ߻  
//---------------------------------------------------------------------------

#include <vcl.h>
#include <inifiles.hpp>
#pragma hdrstop

#include "DataMatching_Form.h"
#include "CameraSetting3D_Form.h"
#include "MultiLanguage.h"
//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma link "TntExtCtrls"
#pragma link "TntStdCtrls"
#pragma resource "*.dfm"

#define TARGET_MACHINE_REV				(('D' << 24) | ('5' << 16) | (500))
#define MAX_VOP_COUNT						MAX_PORT_COUNT
#define MAX_VIP_COUNT						MAX_PORT_COUNT
#define PORT_NOT_EXIST						0xFF


typedef struct
{
	unsigned char PortMapValue;
} TPortMapInfoData;

TDataMatchingForm *DataMatchingForm;
//---------------------------------------------------------------------------
__fastcall TDataMatchingForm::TDataMatchingForm(TComponent* Owner)
	: TTntForm(Owner)
{
  if(DefaultLCID == 1028 || DefaultLCID == 2052 || DefaultLCID == 3076 || DefaultLCID == 4100)
    ComponentSetFontName(this, "SimSun");
  else if(DefaultLCID == 1041)
    ComponentSetFontName(this, "Meiryo UI");
  else if(DefaultLCID == 3082)
  {
    ComponentSetFontName(this, "Segoe UI");
    ComponentSetMultiLine(this);
  }

  GetDefaultString();
	SetupSPBIndex = 0;
}
//---------------------------------------------------------------------------
void __fastcall TDataMatchingForm::GetDefaultString()
{
//  WriteHCBToPCButton->Caption = DATAMATCHINGFORM_BUTTON_CAPTION_01;
//  WritePCToHCBButton->Caption = DATAMATCHINGFORM_BUTTON_CAPTION_02;
  CloseButton->Caption = DATAMATCHINGFORM_BUTTON_CAPTION_03;
  this->Caption = DATAMATCHINGFORM_FORM_CAPTION_01;
  Label5->Caption = DATAMATCHINGFORM_LABEL_CAPTION_01;
  Label4->Caption = DATAMATCHINGFORM_LABEL_CAPTION_02;
  Label44->Caption = DATAMATCHINGFORM_LABEL_CAPTION_03;
  Label46->Caption = DATAMATCHINGFORM_LABEL_CAPTION_04;
  Label25->Caption = DATAMATCHINGFORM_LABEL_CAPTION_05;
  Label26->Caption = DATAMATCHINGFORM_LABEL_CAPTION_06;
  Label1->Caption = DATAMATCHINGFORM_LABEL_CAPTION_07;
  SPBDifferenceMessageLabel->Caption = DATAMATCHINGFORM_LABEL_CAPTION_08;

  SPBTargetProjectNameLabel->Caption = DATAMATCHINGFORM_LABEL_CAPTION_09;
  Label22->Caption = DATAMATCHINGFORM_LABEL_CAPTION_10;
  Label10->Caption = DATAMATCHINGFORM_LABEL_CAPTION_11;
  Label11->Caption = DATAMATCHINGFORM_LABEL_CAPTION_11;

    Label21->Caption = DATAMATCHINGFORM_LABEL_CAPTION_13;

  GroupBox3->Caption = DATAMATCHINGFORM_GROUPBOX_CAPTION_02;
  Label28->Caption = DATAMATCHINGFORM_LABEL_CAPTION_15;
  Label30->Caption = DATAMATCHINGFORM_LABEL_CAPTION_12;
  Label31->Caption = DATAMATCHINGFORM_LABEL_CAPTION_14;

  Label36->Caption = DATAMATCHINGFORM_LABEL_CAPTION_15;
  Label38->Caption = DATAMATCHINGFORM_LABEL_CAPTION_12;
  Label39->Caption = DATAMATCHINGFORM_LABEL_CAPTION_14;

  Label24->Caption = DATAMATCHINGFORM_MSG_15;

   Label2->Caption = DATAMATCHINGFORM_LABEL_CAPTION_13;
   Label20->Caption = DATAMATCHINGFORM_LABEL_CAPTION_03;
   Label6->Caption = DATAMATCHINGFORM_LABEL_CAPTION_04;
   Label3->Caption = DATAMATCHINGFORM_LABEL_CAPTION_05;
   Label16->Caption = DATAMATCHINGFORM_LABEL_CAPTION_06;
   Label7->Caption = DATAMATCHINGFORM_LABEL_CAPTION_10;

   GroupBox3->Caption = DATAMATCHINGFORM_GROUPBOX_CAPTION_02;
   Label8->Caption = DATAMATCHINGFORM_LABEL_CAPTION_15;
   Label12->Caption = DATAMATCHINGFORM_LABEL_CAPTION_12;
   Label14->Caption = DATAMATCHINGFORM_LABEL_CAPTION_14;

   GroupBox4->Caption = DATAMATCHINGFORM_GROUPBOX_CAPTION_01;
   Label9->Caption = DATAMATCHINGFORM_LABEL_CAPTION_15;
   Label13->Caption = DATAMATCHINGFORM_LABEL_CAPTION_12;
   Label15->Caption = DATAMATCHINGFORM_LABEL_CAPTION_14;
   Label17->Caption = DATAMATCHINGFORM_MSG_15;

   Label44->Caption = DATAMATCHINGFORM_LABEL_CAPTION_16;
   Label45->Caption = DATAMATCHINGFORM_LABEL_CAPTION_17;
   Label27->Caption = DATAMATCHINGFORM_LABEL_CAPTION_18;
   GroupBox9->Caption = DATAMATCHINGFORM_LABEL_CAPTION_19;
//   WritePCToSPBButton->Caption = DATAMATCHINGFORM_LABEL_CAPTION_21;
//   WriteSPBToPCButton->Caption = DATAMATCHINGFORM_LABEL_CAPTION_20;
   GroupBox8->Caption =  DATAMATCHINGFORM_GROUPBOX_CAPTION_02;

}
//---------------------------------------------------------------------------
void __fastcall TDataMatchingForm::SetHCBDifferences(THCBProgramHeader *hcbProgramHeader, THCBDBHeader *hcbDBHeader,
	THCBMachineSpecificHeader *hcbMachineSpecificHeader)
{
  if(DefaultLCID == 1041)
  {
    TargetProjectNameLabel->Caption = "ACROCIA";
    HCBProjectNameLabel->Caption = "ACROCIA";
  }
  else
  {
    TargetProjectNameLabel->Caption = PCSystemHeader.TargetProjectName;
    HCBProjectNameLabel->Caption = hcbProgramHeader->ProjectName;
  }
	TargetMachineNameLabel->Caption = PCSystemHeader.TargetMachineName;
	TargetDataRevLabel->Caption = IntToStr(PCSystemHeader.TargetHCBDataRev);


	HCBMachineNameLabel->Caption = hcbMachineSpecificHeader->MachineName;
	HCBDataRevLabel->Caption = IntToStr(hcbDBHeader->DataRev);

	HCBDifferenceNotificationPanel->Visible = true;
}
//---------------------------------------------------------------------------
void __fastcall TDataMatchingForm::SetSPBDifferences(TSPBProgramHeader *spbProgramHeader, TSPBDBHeader *spbDBHeader, int spbIndex)
{
  WCHAR TempString[100];
  wsprintfW(TempString, DATAMATCHINGFORM_LABEL_CAPTION_08, spbIndex + 1);
	SPBDifferenceMessageLabel->Caption = TempString;

  if (DefaultLCID == 1041)
  {
    SPBTargetProjectNameLabel->Caption = "ACROCIA";
    SPBProjectNameLabel->Caption = "ACROCIA";
  }
  else
  {
    SPBTargetProjectNameLabel->Caption = PCSystemHeader.TargetProjectName;
    SPBProjectNameLabel->Caption = spbProgramHeader->ProjectName;
  }

	SPBTargetDataRevLabel->Caption = IntToStr(PCSystemHeader.TargetSPBDataRev);
	SPBDataRevLabel->Caption = IntToStr(spbDBHeader->DataRev);

	SPBDifferenceNotificationPanel->Visible = true;
	SetupSPBIndex = spbIndex;
}
//---------------------------------------------------------------------------
void __fastcall CheckHCBDataMatching(THCBProgramHeader *hcbProgramHeader, THCBDBHeader *hcbDBHeader)
{
	bool bDataMatched = false;

	try
	{
		if (hcbDBHeader->DataRev == TARGET_HCB_DATA_REV)
		{
			bDataMatched = true;
			// check data equality
			TMachineSetupData hcbMachineSetupData;
			TUserMachineEnv hcbUserMachineEnv;
			TPortMapInfo hcbPortMapInfo;
			Comm_SetMaxWaitingTime(COMM_HCB, 60000);
			if (!Comm_Request(COMM_HCB, CMD_READ_MACHINE_INFO, NULL, 0, &hcbMachineSetupData, sizeof(TMachineSetupData)))
			{
				throw Exception("Communication error");
			}

			if (!CheckBinaryEquality(&hcbMachineSetupData, &MachineSetupData, sizeof(TMachineSetupData)))
			{
				bDataMatched = false;
                //ShowMessage( "HCB MachineSetupData Error 1");
			}

			TUserMachineEnv UserMachineEnv;
			if (!ReadUserMachineEnvData(ProgramPath.Env + "\\UserMachineInfor.ini", UserMachineEnv))
			{
				throw Exception("Not open UserMachineInfor.ini");
			}
			if (!Comm_Request(COMM_HCB, CMD_READ_USER_MACHINE_ENV, NULL, 0, &hcbUserMachineEnv, sizeof(TUserMachineEnv)))
			{
				throw Exception("Communication error 2");
			}

			if (!CheckBinaryEquality(&hcbUserMachineEnv, &UserMachineEnv, sizeof(TUserMachineEnv)))
			{
				bDataMatched = false;
                //ShowMessage( "HCB UserMachineEnv Error 3");
			}

			TPortMapInfo PortMapInfo;
			if (!MakePortMapInfo(PortMapInfo, TARGET_MACHINE_REV))
			{
				throw Exception("Can not load Port Map.");
			}
			if (!Comm_Request(COMM_HCB, CMD_READ_PORT_MAP_INFO, NULL, 0, &hcbPortMapInfo, sizeof(TPortMapInfo)))
			{
				throw Exception("Communication error");
			}

			if (!CheckBinaryEquality(&hcbPortMapInfo, &PortMapInfo, sizeof(int) + MAX_PORT_COUNT + MAX_PORT_COUNT))
			{
				bDataMatched = false;
			}
			Comm_SetDefaultMaxWaitingTime(COMM_HCB);
		}
		else
		{
			bDataMatched = false;
		}
	}
	catch (...)
	{
		bDataMatched = false;
	}

	if (!bDataMatched)
	{
		THCBMachineSpecificHeader hcbMachineSpecificHeader;
		Comm_Request(COMM_HCB, CMD_READ_MS_HEADER, NULL, 0, &hcbMachineSpecificHeader, sizeof(THCBMachineSpecificHeader));

		DataMatchingForm = new TDataMatchingForm(Application);
		DataMatchingForm->SetHCBDifferences(hcbProgramHeader, hcbDBHeader, &hcbMachineSpecificHeader);
		DataMatchingForm->ShowModal();
		delete DataMatchingForm; DataMatchingForm = NULL;
	}
}
//---------------------------------------------------------------------------
bool __fastcall CheckBinaryEquality(void *lhs, void *rhs, int length)
{
	unsigned char *pLhs = (unsigned char *)lhs;
	unsigned char *pRhs = (unsigned char *)rhs;
	bool bEquality = true;
    
	for (int pos = 0; pos < length; pos++)
	{
		if (*pLhs != *pRhs)
		{
			bEquality = false;
			//ShowMessageFA("Data Not Equal " + IntToStr(pos) + "," + IntToStr(*pLhs) + "," + IntToStr(*pRhs));
			break;
		}
		pLhs++;
		pRhs++;
	}
	return bEquality;
}
//---------------------------------------------------------------------------
bool __fastcall MakePortMapInfo(TPortMapInfo &PortMapInfo, unsigned int machineRev)
{
	TIniFile *iniFile = new TIniFile(ProgramPath.Env + "\\MachineInfor.ini");
	TPortMapInfoData OutputPortMapData[MAX_PORT_COUNT];
	TPortMapInfoData InputPortMapData[MAX_PORT_COUNT];

	if (iniFile)
	{
		for (int outputPortIndex = 0; outputPortIndex < MAX_PORT_COUNT; outputPortIndex++)
		{
			OutputPortMapData[outputPortIndex].PortMapValue = iniFile->ReadInteger("Port Mapping", "Output " + IntToStr(outputPortIndex) + " RP", PORT_NOT_EXIST);
		}

		for (int inputPortIndex = 0; inputPortIndex < MAX_PORT_COUNT; inputPortIndex++)
		{
			InputPortMapData[inputPortIndex].PortMapValue = iniFile->ReadInteger("Port Mapping", "Input " + IntToStr(inputPortIndex) + " RP", PORT_NOT_EXIST);
		}
		delete iniFile;


		for (int portIndex = 0; portIndex < MAX_PORT_COUNT; portIndex++)
		{
			if (InputPortMapData[portIndex].PortMapValue > MAX_PORT_COUNT)
			{
				PortMapInfo.VIPMap[portIndex] = PIP_NOT_EXIST;
			}
			else
			{
				PortMapInfo.VIPMap[portIndex] = InputPortMapData[portIndex].PortMapValue;
			}
		}

		for (int portIndex = 0; portIndex < MAX_PORT_COUNT; portIndex++)
		{
			if (OutputPortMapData[portIndex].PortMapValue > MAX_PORT_COUNT)
			{
				PortMapInfo.VOPMap[portIndex] = POP_NOT_EXIST;
			}
			else
			{
				PortMapInfo.VOPMap[portIndex] = OutputPortMapData[portIndex].PortMapValue;
			}
		}

		PortMapInfo.MachineRev = machineRev;
		return true;
	}
	else
	{
		return false;
	}
}
//---------------------------------------------------------------------------
void __fastcall WritePortMapInfo(TPortMapInfo &portMapInfo)
{
	TPortMapInfoData OutputPortMapData[MAX_PORT_COUNT];
	TPortMapInfoData InputPortMapData[MAX_PORT_COUNT];

	for (int portIndex = 0; portIndex < MAX_PORT_COUNT; portIndex++)
	{
		InputPortMapData[portIndex].PortMapValue = portMapInfo.VIPMap[portIndex];
	}
	for (int portIndex = 0; portIndex < MAX_PORT_COUNT; portIndex++)
	{
		OutputPortMapData[portIndex].PortMapValue = portMapInfo.VOPMap[portIndex];
	}

	AnsiString portMapFileName = ProgramPath.Env + "\\MachineInfor.ini";
	try
	{
	if (!FileExists(portMapFileName))
	{
		throw Exception("Map FIle Not Exists");
	}

	TIniFile *iniFile = new TIniFile(ProgramPath.Env + "\\MachineInfor.ini");
	if (iniFile)
	{
		for (int outputPortIndex = 0; outputPortIndex < MAX_PORT_COUNT; outputPortIndex++)
		{
			iniFile->WriteInteger("Port Mapping", "Output " + IntToStr(outputPortIndex) + " RP", OutputPortMapData[outputPortIndex].PortMapValue);
		}

		for (int inputPortIndex = 0; inputPortIndex < MAX_PORT_COUNT; inputPortIndex++)
		{
			iniFile->WriteInteger("Port Mapping", "Input " + IntToStr(inputPortIndex) + " RP", InputPortMapData[inputPortIndex].PortMapValue);
		}
		delete iniFile;
	}
	}
	catch (Exception &ec)
	{
	}
}
//---------------------------------------------------------------------------
/*
void __fastcall TDataMatchingForm::WritePCToHCBButtonClick(TObject *Sender)
{
	if (MessageDlgFA(DATAMATCHINGFORM_MSG_06, mtConfirmation, TMsgDlgButtons() << mbOK << mbCancel) == mrOk)
	{
		try
		{
			TPortMapInfo PortMapInfo;
			TUserMachineEnv UserMachineEnv;
			if (!ReadUserMachineEnvData(ProgramPath.Env + "\\UserMachineInfor.ini", UserMachineEnv))
			{
				throw Exception("Not open UserMachineInfor.ini");
			}

			if (!MakePortMapInfo(PortMapInfo, TARGET_MACHINE_REV))
			{
				throw Exception("Can not load Port Map.");
			}

			unsigned int data[2];
			unsigned int programID;
			int time;
			time = Now().FileDate();
			programID = PID_MACHINE_INFO;

			memcpy(&data[0], &programID, sizeof(unsigned int));
			memcpy(&data[1], &time, sizeof(int));

			if (Comm_IsConnected(COMM_HCB))
			{
				if (!Comm_RequestEx(COMM_HCB, CMD_DOWNLOAD, data, 2 * sizeof(unsigned int),
					&MachineSetupData, sizeof(TMachineSetupData)))
				{
					throw Exception("Setup fails");
				}
			}
			else
			{
				throw Exception("HCB is not connected");
			}

			time = Now().FileDate();
			programID = PID_USER_MACHINE_ENV;

			memcpy(&data[0], &programID, sizeof(unsigned int));
			memcpy(&data[1], &time, sizeof(int));

			if (Comm_IsConnected(COMM_HCB))
			{
				if (!Comm_RequestEx(COMM_HCB, CMD_DOWNLOAD, data, 2 * sizeof(unsigned int),
					&UserMachineEnv, sizeof(UserMachineEnv)))
				{
					throw Exception("Setup fails");
				}
			}
			else
			{
				throw Exception("HCB is not connected");
			}

			time = Now().FileDate();
			programID = PID_PORT_MAP;

			memcpy(&data[0], &programID, sizeof(unsigned int));
			memcpy(&data[1], &time, sizeof(int));

			if (Comm_IsConnected(COMM_HCB))
			{
				if (!Comm_RequestEx(COMM_HCB, CMD_DOWNLOAD, data, 2 * sizeof(unsigned int),
					&PortMapInfo, sizeof(PortMapInfo)))
				{
					throw Exception("Setup fails");
				}
			}
			else
			{
				throw Exception("HCB is not connected");
			}


			time = Now().FileDate();
			programID = PID_HCB_DB_HEADER;

			THCBDBHeader hcbDBHeader;

			hcbDBHeader.DataRev = TARGET_HCB_DATA_REV;

			memcpy(&data[0], &programID, sizeof(unsigned int));
			memcpy(&data[1], &time, sizeof(int));

			if (Comm_IsConnected(COMM_HCB))
			{
				if (!Comm_RequestEx(COMM_HCB, CMD_DOWNLOAD, data, 2 * sizeof(unsigned int),
					&hcbDBHeader, sizeof(THCBDBHeader)))
				{
					throw Exception("Setup fails");
				}
			}
			else
			{
				throw Exception("HCB is not connected");
			}

			ShowMessageFA("Complete setup");
			this->Close();
		}
		catch (Exception &ec)
		{
			ShowMessageFA(ec.Message);
		}
	}
}
//---------------------------------------------------------------------------

void __fastcall TDataMatchingForm::WriteHCBToPCButtonClick(TObject *Sender)
{
	if (MessageDlgFA(DATAMATCHINGFORM_MSG_04, mtConfirmation, TMsgDlgButtons() << mbOK << mbCancel) == mrOk)
	{
		try
		{
			TPortMapInfo PortMapInfo;
			TUserMachineEnv UserMachineEnv;
			if (!ReadUserMachineEnvData(ProgramPath.Env + "\\UserMachineInfor.ini", UserMachineEnv))
			{
				throw Exception("Not open UserMachineInfor.ini");
			}

			if (!MakePortMapInfo(PortMapInfo, TARGET_MACHINE_REV))
			{
				throw Exception("Can not load Port Map.");
			}

			TMachineSetupData hcbMachineSetupData;
			if (Comm_IsConnected(COMM_HCB))
			{
				if (!Comm_Request(COMM_HCB, CMD_READ_MACHINE_INFO, NULL, 0, &hcbMachineSetupData, sizeof(TMachineSetupData)))
				{
					throw Exception("Fail Upload");
				}
			}
			else
			{
				throw Exception("HCB is not connected");
			}
			memcpy(&MachineSetupData, &hcbMachineSetupData, sizeof(TMachineSetupData));
			WriteMachineSetupData(ProgramPath.Env + "\\SystemInfor.ini", MachineSetupData);

			TUserMachineEnv hcbUserMachineEnv;
			if (Comm_IsConnected(COMM_HCB))
			{
				if (!Comm_Request(COMM_HCB, CMD_READ_USER_MACHINE_ENV, NULL, 0, &hcbUserMachineEnv, sizeof(TUserMachineEnv)))
				{
					throw Exception("Fail Upload");
				}
			}
			else
			{
				throw Exception("HCB is not connected");
			}
			WriteUserMachineEnvData(GetUserMachineEnvDataFileName(), hcbUserMachineEnv);

			TPortMapInfo hcbPortMapInfo;
			if (Comm_IsConnected(COMM_HCB))
			{
				if (!Comm_Request(COMM_HCB, CMD_READ_PORT_MAP_INFO, NULL, 0, &hcbPortMapInfo, sizeof(TPortMapInfo)))
				{
					throw Exception("Upload Failed");
				}
			}
			else
			{
				throw Exception("HCB is not connected");
			}
			WritePortMapInfo(hcbPortMapInfo);

			THCBMachineSpecificHeader hcbMachineSpecificHeader;
			if (Comm_IsConnected(COMM_HCB))
			{
				if (!Comm_Request(COMM_HCB, CMD_READ_MS_HEADER, NULL, 0, &hcbMachineSpecificHeader, sizeof(THCBMachineSpecificHeader)))
				{
					throw Exception("Fail Upload");
				}
			}
			else
			{
				throw Exception("HCB is not connected.");
			}
			PCSystemHeader.TargetMachineName = AnsiString(hcbMachineSpecificHeader.MachineName);
			AnsiString fileName = ProgramPath.Env + "\\SystemInfor.ini";
			WritePCSystemHeader(fileName);

			ShowMessageFA("Complete upload");
			this->Close();
		}
		catch (Exception &ec)
		{
			ShowMessageFA(ec.Message);
		}
	}
}
*/
//---------------------------------------------------------------------------
void __fastcall CheckSPBDataMatching(TSPBProgramHeader *spbProgramHeader, TSPBDBHeader *spbDBHeader, int spbIndex)
{
	bool bDataMatched = false;

	try
	{
		if (spbDBHeader->DataRev == TARGET_SPB_DATA_REV)
		{
			bDataMatched = true;

			TSPBSystemSetupData spbSystemSetupData;
			if (!Comm_Request(COMM_SPB + spbIndex, CMD_READ_SYSTEM_SETUP, NULL, 0, &spbSystemSetupData, sizeof(TSPBSystemSetupData)))
			{
				throw Exception("Communication error");
			}
			if (!CheckBinaryEquality(&spbSystemSetupData, &(SPBSystemSetupData[spbIndex]), sizeof(TSPBSystemSetupData)))
			{
				bDataMatched = false;
			}
		}
		else
		{
			bDataMatched = false;
		}
	}
	catch (Exception &ec)
	{
		ShowMessageFA(ec.Message);
		bDataMatched = false;
	}

	if (!bDataMatched)
	{
		DataMatchingForm = new TDataMatchingForm(Application);
		DataMatchingForm->SetSPBDifferences(spbProgramHeader, spbDBHeader, spbIndex);
		DataMatchingForm->ShowModal();
		delete DataMatchingForm; DataMatchingForm = NULL;
	}
}
//---------------------------------------------------------------------------
/*
void __fastcall TDataMatchingForm::WritePCToSPBButtonClick(TObject *Sender)
{
	if (MessageDlgFA(DATAMATCHINGFORM_MSG_07, mtConfirmation, TMsgDlgButtons() << mbOK << mbCancel) == mrOk)
	{
		try
		{

			unsigned int data[2];
			unsigned int programID;
			int time;

			int spbIndex = SetupSPBIndex;
			if (Comm_IsConnected(COMM_SPB + spbIndex))
			{
				time = Now().FileDate();
				programID = PID_ENVIRONMENT;

				memcpy(&data[0], &programID, sizeof(unsigned int));
				memcpy(&data[1], &time, sizeof(int));

				if (Comm_IsConnected(COMM_SPB + spbIndex))
				{
					if (!Comm_RequestEx(COMM_SPB + spbIndex, CMD_DOWNLOAD, data, 2 * sizeof(unsigned int),
						&SPBSystemSetupData[spbIndex], sizeof(TSPBSystemSetupData)))
					{
						throw Exception("Setup fails");
					}
				}
			}

			time = Now().FileDate();
			programID = PID_SPB_DB_HEADER;

			TSPBDBHeader spbDBHeader;
			memset(&spbDBHeader, 0, sizeof(TSPBDBHeader));
			spbDBHeader.DataRev = TARGET_SPB_DATA_REV;

			memcpy(&data[0], &programID, sizeof(unsigned int));
			memcpy(&data[1], &time, sizeof(int));

			if (Comm_IsConnected(COMM_SPB + spbIndex))
			{
				if (!Comm_RequestEx(COMM_SPB + spbIndex, CMD_DOWNLOAD, data, 2 * sizeof(unsigned int),
					&spbDBHeader, sizeof(TSPBDBHeader)))
				{
					throw Exception("Setup fails");
				}
			}
			else
			{
				throw Exception("SPB is not connected");
			}

			ShowMessageFA(DATAMATCHINGFORM_MSG_13);
			this->Close();
		}
		catch (Exception &ec)
		{
			ShowMessageFA(ec.Message);
		}
	}
}
//---------------------------------------------------------------------------

void __fastcall TDataMatchingForm::WriteSPBToPCButtonClick(TObject *Sender)
{
	if (MessageDlgFA(DATAMATCHINGFORM_MSG_10, mtConfirmation, TMsgDlgButtons() << mbOK << mbCancel) == mrOk)
	{
		try
		{
			int spbIndex = SetupSPBIndex;

			TSPBSystemSetupData spbSystemSetupData;
			if (!Comm_Request(COMM_SPB + spbIndex, CMD_READ_SYSTEM_SETUP, NULL, 0, &spbSystemSetupData, sizeof(TSPBSystemSetupData)))
			{
				throw Exception("Communication error");
			}
			memcpy(&SPBSystemSetupData[spbIndex], &spbSystemSetupData, sizeof(TSPBSystemSetupData));
			memcpy(CameraMapInfo, SPBSystemSetupData[spbIndex].CameraMapInfo, SYSTEM_TOTAL_CAMERA_COUNT * sizeof(TCameraMapInfo));
			WriteCameraMapData(ProgramPath.Env + "\\SystemInfor.ini", CameraMapInfo);
			WriteSPBSystemSetupData(ProgramPath.Env + "\\SystemInfor.ini", SPBSystemSetupData);

			ShowMessageFA("Complete upload");
			this->Close();
		}
		catch (Exception &ec)
		{
			ShowMessageFA(ec.Message);
		}
	}
}
//---------------------------------------------------------------------------
*/

