//---------------------------------------------------------------------------
#ifndef DiskSpaceManagerH
#define DiskSpaceManagerH

#include <Classes.hpp>
#include <list.h>
typedef enum {DSM_STATE_IDLE, DSM_STATE_CALC_PRODUCT_SIZE, DSM_STATE_REDUCE_LOT, DSM_STATE_FORCED_REMOVE} EDSMState;

typedef enum {RD_STATE_BEGIN, RD_STATE_PROCESS, RD_STATE_END} EReduceState;
//---------------------------------------------------------------------------
class TDefectLotInfo
{
	public:
		bool Compressed;
		AnsiString LotName;
		TDateTime Time;
	__fastcall TDefectLotInfo(AnsiString lotName, double time);
	TDefectLotInfo& operator = (const TDefectLotInfo &rhs)
	{
		Compressed = rhs.Compressed;
		LotName = rhs.LotName;
		Time = rhs.Time;
		return *this;
	}
};
//---------------------------------------------------------------------------
 
class TDefectProductInfo
{
private:
	list<TDefectLotInfo> LotList;
	AnsiString ProductPath;
	AnsiString ResultDir;
	bool FReduced;
	list<TDefectLotInfo>::iterator ITReduceLot;
public:
	bool Analyzed;

	AnsiString ProductName;
	TDateTime ReduceBaseTime[3];
	int PrimeLotCount[3], PrimeLotMaxDefectCount[3], TrivialLotMaxDefectCount[3];

	__fastcall TDefectProductInfo(AnsiString productName, AnsiString rootPath, AnsiString productDataPath);
	AnsiString __fastcall GetCurrentReducingLotName(void);
	void __fastcall Analyze(void);
	void __fastcall ReduceBegin(void);
	void __fastcall ReduceOneLot(void);
	double __fastcall GetOldestLotTime(void);
	AnsiString __fastcall GetOldestLotName(void);
	void __fastcall RemoveOldestLot(void);

	__property bool Reduced = {read = FReduced};
	__property AnsiString CurrentReducingLotName = {read = GetCurrentReducingLotName};
};
//---------------------------------------------------------------------------
typedef struct
{
//	bool CompressOldData;
	bool ReduceOldData;
//	TDateTime BMPMaintainTime;
	TDateTime ReduceTime[3];
	int PrimeLotCount[3];
	int PrimeLotMaxDefectCount[3];
	int TrivialLotMaxDefectCount[3];
	int MinDiskSpaceRatio;
	TDateTime ForcedCompressTime;
} TDSMOption;
//---------------------------------------------------------------------------
typedef struct
{
	AnsiString FileName;
	TDateTime FileTime;
} TFileTimeUnit;
//---------------------------------------------------------------------------
class TDSMThread : public TThread
{
private:
	Byte FDrive;
	AnsiString FDefectPath, FProductDataRoot, FLogPath;
	list<TDefectProductInfo> ProductList;

	TDSMOption DSMOption;
	EReduceState RDState;

	bool DSMAlwaysOn;
        bool MainformDiskSpaceEnabled;
	TDateTime DSMStartTime, DSMEndTime;
	void __fastcall MakeProductFolderList(void);
	void __fastcall InitializeProcess(void);
	void __fastcall RetrenchLogFiles(void);
  void __fastcall RetrenchEjectLogFiles(void);
  void __fastcall RemoveWholeDir(AnsiString folderName);
protected:
	void __fastcall Execute();
public:
	int FreeDiskSpace; 		// unit: MB
	int TotalDiskSpace;		// unit: MB
	EDSMState DSMState;
	AnsiString ProcessingProduct;
	AnsiString ProcessingLot;
//	double FreeSpaceRatio;
	__fastcall TDSMThread(bool CreateSuspended);
	__fastcall ~TDSMThread();

	void __fastcall SetLogPath(AnsiString folder);
	void __fastcall SetDefectPath(AnsiString folder);
	void __fastcall SetProductDataRoot(AnsiString folder);
	void __fastcall SetParams(
		double reduceTime0, double reduceTime1, double reduceTime2,
		int PrimeLotCount0, int PrimeLotCount1, int PrimeLotCount2,
		int primeLotMaxDefectCount0, int primeLotMaxDefectCount1, int primeLotMaxDefectCount2,
		int trivialLotMaxDefectCount0, int trivialLotMaxDefectCount1, int trivialLotMaxDefectCount2,
		int minDiskSpaceRatio, bool dsmAlwaysOn,bool mainformDiskSpaceEnabled, TDateTime dsmStartTime, TDateTime dsmEndTime);
//	__property Byte Drive = {read = FDrive, write = SetDrive};
};
//---------------------------------------------------------------------------

#endif
