//---------------------------------------------------------------------------
// For SELMA200, 20180223, moon,  
//---------------------------------------------------------------------------

#include <vcl.h>
#pragma hdrstop

#include "DiskSpaceManagerSetting_Form.h"
#include "Environment.h"
#include "Message_Form.h"
#include "Keyboard_Form.h"
#include "MultiLanguage.h"
#include "Main_Form.h"
//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma link "TntExtCtrls"
#pragma link "TntStdCtrls"
#pragma resource "*.dfm"
TDiskSpaceManagerSettingForm *DiskSpaceManagerSettingForm;
//---------------------------------------------------------------------------
__fastcall TDiskSpaceManagerSettingForm::TDiskSpaceManagerSettingForm(TComponent* Owner)
	: TTntForm(Owner)
{
   if(DefaultLCID == 1028 || DefaultLCID == 2052 || DefaultLCID == 3076 || DefaultLCID == 4100)
    ComponentSetFontName(this, "SimSun");
   else if(DefaultLCID == 1041)
    ComponentSetFontName(this, "Meiryo UI");
   else if(DefaultLCID == 3082)
   {
    ComponentSetFontName(this, "Segoe UI");
    ComponentSetMultiLine(this);
  }

    GetDefaultString();
}
//---------------------------------------------------------------------------
void __fastcall TDiskSpaceManagerSettingForm::GetDefaultString()
{
  Button2->Caption = DISKSPACEMANAGERSETTINGFORM_BUTTON_CAPTION_01;
  ApplyButton->Caption = DISKSPACEMANAGERSETTINGFORM_BUTTON_CAPTION_02;
  GroupBox7->Caption = DISKSPACEMANAGERSETTINGFORM_BUTTON_CAPTION_03;
  this->Caption = DISKSPACEMANAGERSETTINGFORM_FORM_CAPTION_01;
  DSMSetupGroupBox->Caption = DISKSPACEMANAGERSETTINGFORM_GROUPBOX_CAPTION_01;
  GroupBox5->Caption = DISKSPACEMANAGERSETTINGFORM_GROUPBOX_CAPTION_02;
  DSMStatusGroupBox->Caption = DISKSPACEMANAGERSETTINGFORM_GROUPBOX_CAPTION_03;
  DSMPeriodGroupBox->Caption = DISKSPACEMANAGERSETTINGFORM_GROUPBOX_CAPTION_05;
  Label7->Caption = DISKSPACEMANAGERSETTINGFORM_LABEL_CAPTION_01;
  Label12->Caption = DISKSPACEMANAGERSETTINGFORM_LABEL_CAPTION_02;
  Label17->Caption = DISKSPACEMANAGERSETTINGFORM_LABEL_CAPTION_03;
  DSMStateLabel->Caption = DISKSPACEMANAGERSETTINGFORM_LABEL_CAPTION_08;
  Label24->Caption = DISKSPACEMANAGERSETTINGFORM_LABEL_CAPTION_10;
  Label1->Caption = DISKSPACEMANAGERSETTINGFORM_LABEL_CAPTION_12;
  Label23->Caption = DISKSPACEMANAGERSETTINGFORM_LABEL_CAPTION_13;
  Label21->Caption = DISKSPACEMANAGERSETTINGFORM_LABEL_CAPTION_14;
  Label2->Caption = DISKSPACEMANAGERSETTINGFORM_LABEL_CAPTION_17;
  GroupBox4->Caption = DISKSPACEMANAGERSETTINGFORM_LABEL_CAPTION_19;
  Label5->Caption = DISKSPACEMANAGERSETTINGFORM_LABEL_CAPTION_20;
  Label10->Caption = DISKSPACEMANAGERSETTINGFORM_LABEL_CAPTION_21;
  Label3->Caption = DISKSPACEMANAGERSETTINGFORM_LABEL_CAPTION_22;
  Label8->Caption = DISKSPACEMANAGERSETTINGFORM_LABEL_CAPTION_04;
  Label22->Caption = DISKSPACEMANAGERSETTINGFORM_LABEL_CAPTION_23;
  Label9->Caption = DISKSPACEMANAGERSETTINGFORM_LABEL_CAPTION_24;
  DSMDisableRadioButton->Caption = DISKSPACEMANAGERSETTINGFORM_RADIOBTN_CAPTION_01;
  DSMEnableRadioButton->Caption = DISKSPACEMANAGERSETTINGFORM_RADIOBTN_CAPTION_02;
  DSMSometimesOnRadioButton->Caption = DISKSPACEMANAGERSETTINGFORM_RADIOBTN_CAPTION_03;
  DSMAlwaysOnRadioButton->Caption = DISKSPACEMANAGERSETTINGFORM_RADIOBTN_CAPTION_04;

  PrimeMaxCountRadioGroup1->Items->Strings[0] = DISKSPACEMANAGERSETTINGFORM_RADIOGROUP_ITEM_02;
  PrimeMaxCountRadioGroup1->Items->Strings[1] = "              " + DISKSPACEMANAGERSETTINGFORM_RADIOGROUP_ITEM_01;
  TrivialMaxCountRadioGroup1->Items->Strings[0] = DISKSPACEMANAGERSETTINGFORM_RADIOGROUP_ITEM_02;
  TrivialMaxCountRadioGroup1->Items->Strings[1] = "              " + DISKSPACEMANAGERSETTINGFORM_RADIOGROUP_ITEM_01;
  PrimeMaxCountRadioGroup2->Items->Strings[0] = DISKSPACEMANAGERSETTINGFORM_RADIOGROUP_ITEM_02;
  PrimeMaxCountRadioGroup2->Items->Strings[1] = "              " + DISKSPACEMANAGERSETTINGFORM_RADIOGROUP_ITEM_01;
  TrivialMaxCountRadioGroup2->Items->Strings[0] = DISKSPACEMANAGERSETTINGFORM_RADIOGROUP_ITEM_02;
  TrivialMaxCountRadioGroup2->Items->Strings[1] = "              " + DISKSPACEMANAGERSETTINGFORM_RADIOGROUP_ITEM_01;
  PrimeMaxCountRadioGroup3->Items->Strings[0] = DISKSPACEMANAGERSETTINGFORM_RADIOGROUP_ITEM_02;
  PrimeMaxCountRadioGroup3->Items->Strings[1] = "              " + DISKSPACEMANAGERSETTINGFORM_RADIOGROUP_ITEM_01;
  TrivialMaxCountRadioGroup3->Items->Strings[0] = DISKSPACEMANAGERSETTINGFORM_RADIOGROUP_ITEM_02;
  TrivialMaxCountRadioGroup3->Items->Strings[1] = "              " + DISKSPACEMANAGERSETTINGFORM_RADIOGROUP_ITEM_01;

  if(MachineSetupData.CompanyID == INTERNATIONAL_MACHINE2)
  {
    Label11->Caption = "About Batch";
    Label15->Caption = "About Batch";
    Label19->Caption = "About Batch";

    Label13->Caption = "Other Batch";
    Label16->Caption = "Other Batch";
    Label20->Caption = "Other Batch";
  }
  else
  {
    Label11->Caption = DISKSPACEMANAGERSETTINGFORM_LABEL_CAPTION_05;
  Label15->Caption = DISKSPACEMANAGERSETTINGFORM_LABEL_CAPTION_05;
  Label19->Caption = DISKSPACEMANAGERSETTINGFORM_LABEL_CAPTION_05;

    Label13->Caption = DISKSPACEMANAGERSETTINGFORM_LABEL_CAPTION_07;
    Label16->Caption = DISKSPACEMANAGERSETTINGFORM_LABEL_CAPTION_07;
    Label20->Caption = DISKSPACEMANAGERSETTINGFORM_LABEL_CAPTION_07;
  }
  Label14->Caption = DISKSPACEMANAGERSETTINGFORM_LABEL_CAPTION_24;
  Label18->Caption = DISKSPACEMANAGERSETTINGFORM_LABEL_CAPTION_24;
  Label25->Caption = DISKSPACEMANAGERSETTINGFORM_LABEL_CAPTION_13;
  Label26->Caption = DISKSPACEMANAGERSETTINGFORM_LABEL_CAPTION_10;

  Mainform_DiscSpaceViewCheckBox->Caption = DISKSPACEMANAGERSETTINGFORM_LABEL_CAPTION_26;
  Label4->Caption	= DISKSPACEMANAGERSETTINGFORM_LABEL_CAPTION_28;
}
//---------------------------------------------------------------------------
void __fastcall TDiskSpaceManagerSettingForm::StatusTimerTimer(
	  TObject *Sender)
{
  WCHAR TempString[100];
  wsprintfW(TempString, L"%d MB (%S %%)", DSMThread->FreeDiskSpace, FloatToStrF( (double) DSMThread->FreeDiskSpace * 100 / DSMThread->TotalDiskSpace, ffFixed, 10, 2));
	FreeSpaceLabel->Caption = TempString;
  DSMStateLabel->Caption = "";
	ProcessingProductLabel->Caption = "";
	ProcessingLotLabel->Caption = "";
	switch(DSMThread->DSMState)
	{
		case DSM_STATE_IDLE:
			DSMStateLabel->Caption = DISKSPACEMANAGERSETTINGFORM_LABEL_CAPTION_09;
			break;
		case DSM_STATE_CALC_PRODUCT_SIZE:
			DSMStateLabel->Caption = DISKSPACEMANAGERSETTINGFORM_LABEL_CAPTION_06;
			ProcessingProductLabel->Caption = DSMThread->ProcessingProduct;
			break;
		case DSM_STATE_REDUCE_LOT:
			DSMStateLabel->Caption = DISKSPACEMANAGERSETTINGFORM_LABEL_CAPTION_16;
			ProcessingProductLabel->Caption = DSMThread->ProcessingProduct;
			ProcessingLotLabel->Caption = DSMThread->ProcessingLot;
			break;
		case DSM_STATE_FORCED_REMOVE:
			DSMStateLabel->Caption = DISKSPACEMANAGERSETTINGFORM_LABEL_CAPTION_25;
			ProcessingProductLabel->Caption = DSMThread->ProcessingProduct;
			ProcessingLotLabel->Caption = DSMThread->ProcessingLot;
			break;
		default:
			DSMStateLabel->Caption = DISKSPACEMANAGERSETTINGFORM_LABEL_CAPTION_15;
			break;
	}
}
//---------------------------------------------------------------------------
void __fastcall TDiskSpaceManagerSettingForm::ApplyButtonClick(
      TObject *Sender)
{
	try
	{
		TDSMInfo tempDSMInfo;
		tempDSMInfo.DSMEnabled = DSMEnableRadioButton->Checked;
		tempDSMInfo.ReduceTime[0] = 0;
		tempDSMInfo.ReduceTime[1] = 90;
		tempDSMInfo.ReduceTime[2] = 365;
		tempDSMInfo.PrimeLotCount[0] = StrToInt(PrimeLotCountEdit1->Text);
		tempDSMInfo.PrimeLotCount[1] = StrToInt(PrimeLotCountEdit2->Text);
		tempDSMInfo.PrimeLotCount[2] = StrToInt(PrimeLotCountEdit3->Text);
		if (PrimeMaxCountRadioGroup1->ItemIndex == 0)
		{
			tempDSMInfo.PrimeLotMaxDefectCount[0] = -1;
		}
		else
		{
			tempDSMInfo.PrimeLotMaxDefectCount[0] = StrToInt(PrimeLotMaxDefectCountEdit1->Text);
		}
		if (TrivialMaxCountRadioGroup1->ItemIndex == 0)
		{
			tempDSMInfo.TrivialLotMaxDefectCount[0] = -1;
		}
		else
		{
			tempDSMInfo.TrivialLotMaxDefectCount[0] = StrToInt(TrivialLotMaxDefectCountEdit1->Text);
		}

		if (PrimeMaxCountRadioGroup2->ItemIndex == 0)
		{
			tempDSMInfo.PrimeLotMaxDefectCount[1] = -1;
		}
		else
		{
			tempDSMInfo.PrimeLotMaxDefectCount[1] = StrToInt(PrimeLotMaxDefectCountEdit2->Text);
		}
		if (TrivialMaxCountRadioGroup2->ItemIndex == 0)
		{
			tempDSMInfo.TrivialLotMaxDefectCount[1] = -1;
		}
		else
		{
			tempDSMInfo.TrivialLotMaxDefectCount[1] = StrToInt(TrivialLotMaxDefectCountEdit2->Text);
		}

		if (PrimeMaxCountRadioGroup3->ItemIndex == 0)
		{
			tempDSMInfo.PrimeLotMaxDefectCount[2] = -1;
		}
		else
		{
			tempDSMInfo.PrimeLotMaxDefectCount[2] = StrToInt(PrimeLotMaxDefectCountEdit3->Text);
		}
		if (TrivialMaxCountRadioGroup3->ItemIndex == 0)
		{
			tempDSMInfo.TrivialLotMaxDefectCount[2] = -1;
		}
		else
		{
			tempDSMInfo.TrivialLotMaxDefectCount[2] = StrToInt(TrivialLotMaxDefectCountEdit3->Text);
		}
		tempDSMInfo.MinDiskSpaceRatio = StrToInt(MinDiskSpaceRatioEdit->Text);

		tempDSMInfo.DSMAlwaysOn = DSMAlwaysOnRadioButton->Checked;
    tempDSMInfo.MainformDiskSpaceEnabled = Mainform_DiscSpaceViewCheckBox->Checked;
		if (!tempDSMInfo.DSMAlwaysOn)
		{
			tempDSMInfo.DSMStartTime = TDateTime(StrToInt(OptStartTimeHourEdit->Text), StrToInt(OptStartTimeMinEdit->Text), 0, 0);
			tempDSMInfo.DSMEndTime = TDateTime(StrToInt(OptEndTimeHourEdit->Text), StrToInt(OptEndTimeMinEdit->Text), 0, 0); 
		}

		memcpy(&DSMInfo, &tempDSMInfo, sizeof(DSMInfo));

		SaveDSMInfo();
		ShowMessageFA(DISKSPACEMANAGERSETTINGFORM_MSG_01);
		ModalResult = mrOk;
	}
	catch(...)
	{
		ShowMessageFA(DISKSPACEMANAGERSETTINGFORM_MSG_02);
	}
}
//---------------------------------------------------------------------------

void __fastcall TDiskSpaceManagerSettingForm::FormCreate(TObject *Sender)
{
	FreeSpaceLabel->Caption = "";
	DSMStateLabel->Caption = "";
	ProcessingProductLabel->Caption = "";
	ProcessingLotLabel->Caption = "";
//	if (DSMThread) StatusTimer->Enabled = true;
//	else DSMStateLabel->Caption = "Ȱ";
	if (DSMInfo.DSMEnabled)
	{
		DSMEnableRadioButton->Checked = true;
		DSMSetupGroupBox->Color = clBlack;
		DSMPeriodGroupBox->Color = clBlack;
		DSMStatusGroupBox->Color = clBlack;
		DSMSetupGroupBox->Enabled = true;
		DSMPeriodGroupBox->Enabled = true;
		DSMStatusGroupBox->Enabled = true;
	}
	else
	{
		DSMDisableRadioButton->Checked = true;
		DSMSetupGroupBox->Color = clGray;
		DSMPeriodGroupBox->Color = clGray;
		DSMStatusGroupBox->Color = clGray;
		DSMSetupGroupBox->Enabled = false;
		DSMPeriodGroupBox->Enabled = false;
		DSMStatusGroupBox->Enabled = false;
	}
	if (DSMThread)
	{
		StatusTimer->Enabled = true;
	}
	else
	{
		StatusTimer->Enabled = false;
		DSMStateLabel->Caption = DISKSPACEMANAGERSETTINGFORM_LABEL_CAPTION_11;
	}

	PrimeLotCountEdit1->Text = IntToStr(DSMInfo.PrimeLotCount[0]);
	PrimeLotCountEdit2->Text = IntToStr(DSMInfo.PrimeLotCount[1]);
	PrimeLotCountEdit3->Text = IntToStr(DSMInfo.PrimeLotCount[2]);
	if (DSMInfo.PrimeLotMaxDefectCount[0] < 0)
	{
		PrimeMaxCountRadioGroup1->ItemIndex = 0;
	}
	else
	{
		PrimeMaxCountRadioGroup1->ItemIndex = 1;
		PrimeLotMaxDefectCountEdit1->Text = IntToStr(DSMInfo.PrimeLotMaxDefectCount[0]);
	}
	if (DSMInfo.TrivialLotMaxDefectCount[0] < 0)
	{
		TrivialMaxCountRadioGroup1->ItemIndex = 0;
	}
	else
	{
		TrivialMaxCountRadioGroup1->ItemIndex = 1;
		TrivialLotMaxDefectCountEdit1->Text = IntToStr(DSMInfo.TrivialLotMaxDefectCount[0]);
	}

	if (DSMInfo.PrimeLotMaxDefectCount[1] < 0)
	{
		PrimeMaxCountRadioGroup2->ItemIndex = 0;
	}
	else
	{
		PrimeMaxCountRadioGroup2->ItemIndex = 1;
		PrimeLotMaxDefectCountEdit2->Text = IntToStr(DSMInfo.PrimeLotMaxDefectCount[1]);
	}
	if (DSMInfo.TrivialLotMaxDefectCount[1] < 0)
	{
		TrivialMaxCountRadioGroup2->ItemIndex = 0;
	}
	else
	{
		TrivialMaxCountRadioGroup2->ItemIndex = 1;
		TrivialLotMaxDefectCountEdit2->Text = IntToStr(DSMInfo.TrivialLotMaxDefectCount[1]);
	}

	if (DSMInfo.PrimeLotMaxDefectCount[2] < 0)
	{
		PrimeMaxCountRadioGroup3->ItemIndex = 0;
	}
	else
	{
		PrimeMaxCountRadioGroup3->ItemIndex = 1;
		PrimeLotMaxDefectCountEdit3->Text = IntToStr(DSMInfo.PrimeLotMaxDefectCount[2]);
	}
	if (DSMInfo.TrivialLotMaxDefectCount[2] < 0)
	{
		TrivialMaxCountRadioGroup3->ItemIndex = 0;
	}
	else
	{
		TrivialMaxCountRadioGroup3->ItemIndex = 1;
		TrivialLotMaxDefectCountEdit3->Text = IntToStr(DSMInfo.TrivialLotMaxDefectCount[2]);
	}

	MinDiskSpaceRatioEdit->Text = IntToStr(DSMInfo.MinDiskSpaceRatio);

	if (DSMInfo.DSMAlwaysOn)
	{
		DSMAlwaysOnRadioButton->Checked = true;
		OptimizeTimeSettingPanel->Visible = false;
	}
	else
	{
		unsigned short hour, min, sec, msec;
		DSMInfo.DSMStartTime.DecodeTime(&hour, &min, &sec, &msec);
		OptStartTimeHourEdit->Text = IntToStr(hour);
		OptStartTimeMinEdit->Text = IntToStr(min);
		DSMInfo.DSMEndTime.DecodeTime(&hour, &min, &sec, &msec);
		OptEndTimeHourEdit->Text = IntToStr(hour);
		OptEndTimeMinEdit->Text = IntToStr(min);
		DSMSometimesOnRadioButton->Checked = true;
		OptimizeTimeSettingPanel->Visible = true;
	}
  Mainform_DiscSpaceViewCheckBox->Checked = DSMInfo.MainformDiskSpaceEnabled; 
    m_StorageLabel = Mainform_DiscSpaceViewCheckBox->Checked;
  m_DiscSpaceLabel = Mainform_DiscSpaceViewCheckBox->Checked;
}
//---------------------------------------------------------------------------

void __fastcall TDiskSpaceManagerSettingForm::NumEditClick(
      TObject *Sender)
{
	TTntEdit *theEdit = (TTntEdit *) Sender;
	KeyboardForm->Text = theEdit->Text;
    if (KeyboardForm->ShowKeypad() == mrOk)
    {
		theEdit->Text = KeyboardForm->Text;
    }	
}
//---------------------------------------------------------------------------

void __fastcall TDiskSpaceManagerSettingForm::DSMAlwaysOnRadioButtonClick(
	  TObject *Sender)
{
	if (DSMAlwaysOnRadioButton->Checked)
	{
		OptimizeTimeSettingPanel->Visible = false;
	}
}
//---------------------------------------------------------------------------

void __fastcall TDiskSpaceManagerSettingForm::DSMSometimesOnRadioButtonClick(
	  TObject *Sender)
{
	if (DSMSometimesOnRadioButton->Checked)
	{
		OptimizeTimeSettingPanel->Visible = true;
	}
}
//---------------------------------------------------------------------------

void __fastcall TDiskSpaceManagerSettingForm::DSMEnableRadioButtonClick(
	  TObject *Sender)
{
	DSMSetupGroupBox->Color = clBlack;
	DSMPeriodGroupBox->Color = clBlack;
	DSMStatusGroupBox->Color = clBlack;
	DSMSetupGroupBox->Enabled = true;
	DSMPeriodGroupBox->Enabled = true;
	DSMStatusGroupBox->Enabled = true;
}
//---------------------------------------------------------------------------

void __fastcall TDiskSpaceManagerSettingForm::DSMDisableRadioButtonClick(
	  TObject *Sender)
{
	DSMSetupGroupBox->Color = clGray;
	DSMPeriodGroupBox->Color = clGray;
	DSMStatusGroupBox->Color = clGray;
	DSMSetupGroupBox->Enabled = false;
	DSMPeriodGroupBox->Enabled = false;
	DSMStatusGroupBox->Enabled = false;
}
//---------------------------------------------------------------------------


void __fastcall TDiskSpaceManagerSettingForm::Mainform_DiscSpaceViewCheckBoxClick(
      TObject *Sender)
{
        if(Mainform_DiscSpaceViewCheckBox->Checked == true)
        {
                MainForm->StorageLabel->Visible= true;
                MainForm->DiscSpaceLabel->Visible= true;
        }
        else
        {
                MainForm->StorageLabel->Visible= false;
                MainForm->DiscSpaceLabel->Visible= false;
        }
}
//---------------------------------------------------------------------------

void __fastcall TDiskSpaceManagerSettingForm::Button2Click(TObject *Sender)
{
  MainForm->StorageLabel->Visible= m_StorageLabel;
  MainForm->DiscSpaceLabel->Visible= m_DiscSpaceLabel;
}
//---------------------------------------------------------------------------

