//---------------------------------------------------------------------------

#ifndef Download_FormH
#define Download_FormH
//---------------------------------------------------------------------------
#include <Classes.hpp>
#include <Controls.hpp>
#include <StdCtrls.hpp>
#include <Forms.hpp>
#include <Buttons.hpp>
#include <Dialogs.hpp>
#include <ExtCtrls.hpp>
#include <Grids.hpp>

#include "Environment.h"
#include "TntButtons.hpp"
#include "TntDialogs.hpp"
#include "TntExtCtrls.hpp"
#include "TntGrids.hpp"
#include "TntStdCtrls.hpp"

#include "TntForms.hpp"
#include <ComCtrls.hpp>

#define TARGET_MACHINE_REV				(('D' << 24) | ('5' << 16) | (500))
#define MAX_VOP_COUNT						89//73
#define MAX_VIP_COUNT						91//64
#define PORT_NOT_EXIST						0xFF

#define SET 0
#define RESTORE 1

#define HCB_BOOT_PROCESS_STANDBY            0
#define HCB_BOOT_PROCESS_HCB_RESET          1
#define HCB_BOOT_PROCESS_STABLE_WAITING1    2
#define HCB_BOOT_PROCESS_HCB_BOOTING        3
#define HCB_BOOT_PROCESS_STABLE_WAITING2    4
#define HCB_BOOT_PROCESS_FINAL              5

#define SPB_BOOT_PROCESS_STANDBY            0
#define SPB_BOOT_PROCESS_SPB_RESET          1
#define SPB_BOOT_PROCESS_STABLE_WAITING     2
#define SPB_BOOT_PROCESS_SPB_BOOTING        3
#define SPB_BOOT_PROCESS_SPB_CONNECTION     4

#define BOARD_TYPE_HCB  0
#define BOARD_TYPE_SPB  1

typedef struct
{
	unsigned int MachineRev;
	unsigned char VIPMap[MAX_PORT_COUNT];
	unsigned char VOPMap[MAX_PORT_COUNT];
} TPortMapInfo;

typedef struct
{
	unsigned char PortMapValue;
} TPortMapInfoData;
//---------------------------------------------------------------------------
class TDownloadForm : public TTntForm
{
__published:	// IDE-managed Components
	TTntPanel *Panel1;
	TTntPanel *Panel2;
	TTntPanel *Panel3;
	TTntStringGrid *sgFlashInfo;
	TTntOpenDialog *OpenDialog1;
	TTntPanel *Panel5;
	TTntSpeedButton *SPBSpeedButton1;
	TTntSpeedButton *SPBSpeedButton2;
	TTntSpeedButton *SPBSpeedButton3;
	TTntSpeedButton *SPBSpeedButton4;
	TTntSpeedButton *HCBSpeedButton;
	TTntSpeedButton *AllSpeedButton;
	TTntButton *HCBDownloadButton;
	TTntButton *SPBDownloadButton;
	TTntButton *ChangeHCBFileNameButton;
	TTntEdit *HCBFilenameEdit;
	TTntButton *Button1;
	TTntEdit *SPBFilenameEdit;
	TTntButton *CPBDownloadButton;
	TTntButton *CPBProgramChangeButton1;
	TTntEdit *CPBFilenameEdit;
	TTntButton *RunButton;
	TTntButton *btnReadFlashInfo;
	TTntButton *btnFlashFormat;
	TTntButton *HCBSystemSetupButton;
	TTntButton *SPBSystemSetupButton;
	TTntGroupBox *GroupBox1;
	TTntLabel *Label1;
	TEdit *MachineNameEdit;
	TTntButton *ReadMachineNameButton;
	TTntButton *WriteMachineNameButton;
	TTntButton *HCBResetButton;
	TTntButton *SPBResetButton;
	TTntPanel *Panel4;
	TTntButton *ExitButton;
  TTimer *BootingCheckTimer;
  TPanel *Panel6;
  TPanel *Panel7;
  TProgressBar *WaitngBar;
  TTntSpeedButton *SPBSpeedButton5;
  TTntSpeedButton *SPBSpeedButton6;
  TPanel *Panel8;
  TRadioGroup *RadioGroup1;
  TTimer *CPBDownloadCheckTimer;
  TTntSpeedButton *SPBSpeedButton7;
  TTntSpeedButton *SPBSpeedButton8;
  TTntSpeedButton *TPBSpeedButton;
  TTntButton *TPBDownloadButton;
  TTntButton *TPBProgramChangeButton;
  TTntEdit *TPBFilenameEdit;
	TTntCheckBox *AllBoardFomatOptCheckBox;
	void __fastcall FormCreate(TObject *Sender);
	void __fastcall btnReadFlashInfoClick(TObject *Sender);
	void __fastcall HCBSpeedButtonClick(TObject *Sender);
	void __fastcall SPBSpeedButtonClick(TObject *Sender);
	void __fastcall AllSpeedButtonClick(TObject *Sender);
	void __fastcall btnFlashFormatClick(TObject *Sender);
	void __fastcall HCBDownloadButtonClick(TObject *Sender);
	void __fastcall ChangeHCBFileNameButtonClick(TObject *Sender);
	void __fastcall Button1Click(TObject *Sender);
	void __fastcall CPBProgramChangeButtonClick(TObject *Sender);
	void __fastcall SPBDownloadButtonClick(TObject *Sender);
	void __fastcall CPBDownloadButtonClick(TObject *Sender);
	void __fastcall RunButtonClick(TObject *Sender);
	void __fastcall ExitButtonClick(TObject *Sender);
	void __fastcall HCBSystemSetupButtonClick(TObject *Sender);
	void __fastcall SPBSystemSetupButtonClick(TObject *Sender);
	void __fastcall EditClick(TObject *Sender);
	void __fastcall ReadMachineNameButtonClick(TObject *Sender);
	void __fastcall WriteMachineNameButtonClick(TObject *Sender);
	void __fastcall HCBResetButtonClick(TObject *Sender);
	void __fastcall SPBResetButtonClick(TObject *Sender);
  void __fastcall BootingCheckTimerTimer(TObject *Sender);
  void __fastcall Panel8DblClick(TObject *Sender);
  void __fastcall CPBDownloadCheckTimerTimer(TObject *Sender);
  void __fastcall TPBSpeedButtonClick(TObject *Sender);
  void __fastcall TPBDownloadButtonClick(TObject *Sender);
  void __fastcall TPBProgramChangeButtonClick(TObject *Sender);
private:	// User declarations
	//TUSBConnection *CurrentUSBConnection;
	int currentCommIndex;
  bool IsCPBRunning;
  bool RunCheck[SYSTEM_SPB_MAX_COUNT];
  int RunCommandCheckData[SYSTEM_SPB_MAX_COUNT];
  bool bEnabledSPB[SYSTEM_SPB_MAX_COUNT];

	void __fastcall RunComplete(bool result, TOverlapIOStr *OverlapIOStr);
	bool __fastcall MakePortMapInfo(TPortMapInfo &PortMapInfo, unsigned int machineRev);
  void __fastcall GetDefaultString();
  void __fastcall BtnEnableSet(int State);
  void __fastcall HCBBootingProcess();
  void __fastcall SPBBootingProcess();
  void __fastcall SendSPBResetCommand();
  bool __fastcall BoardBootingCheckProcess(int BoardType);

  bool bBootingCheckTimerEnabled;

  int BootingProcessStep;
  int beforetimecount;
  int BootingProcessTimeCount;

  int globalResetSPBCount;
  int checkedSPB[SYSTEM_SPB_MAX_COUNT];
  int BootingTarget;
  int TPBCheckSW;

public:

  bool __fastcall GetbEnabledSPB(int SPBCOUNT);
  void __fastcall CheckTPB_BoardExist(void);

  TTntSpeedButton* GetSpeedBtnPtr(int Number);

  int cpbProgramSize;
  byte *cpbProgramData;
  unsigned int cpbData[2];
  unsigned int cpbProgramID;
	int cpbDownloadTime;
  int cpbDownLoadCount;
  bool cpbDownLoadFinish;
  
  // delete ؾߵ  ߿ Ȯ 

public:		// User declarations
	__fastcall TDownloadForm(TComponent* Owner);

};
//---------------------------------------------------------------------------
extern PACKAGE TDownloadForm *DownloadForm;
//---------------------------------------------------------------------------
#endif
