//---------------------------------------------------------------------------
// For SELMA200, 20180223, moon,  
//---------------------------------------------------------------------------

#include <vcl.h>
#pragma hdrstop

#include "EnvironmentSetting_Form.h"
#include "Environment.h"
#include "Message_Form.h"
#include "MachineEnvSetup_Form.h"
#include "CommControl_Form.h"
#include "DiskSpaceManagerSetting_Form.h"
#include "SystemInfo_Form.h"
#include "ComputerSystemSetting_Form.h"
#include "SystemMonitor_Form.h"
#include "MultiLanguage.h"
#include "Main_Form.h"

//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma link "TntExtCtrls"
#pragma link "TntStdCtrls"
#pragma resource "*.dfm"
TEnvironmentSettingForm *EnvironmentSettingForm;
TComputerSystemSettingForm *computerSystemSettingForm;
//---------------------------------------------------------------------------
__fastcall TEnvironmentSettingForm::TEnvironmentSettingForm(TComponent* Owner)
	: TTntForm(Owner)
{
  if(DefaultLCID == 1028 || DefaultLCID == 2052 || DefaultLCID == 3076 || DefaultLCID == 4100)
    ComponentSetFontName(this, "SimSun");
  else if(DefaultLCID == 1041)
    ComponentSetFontName(this, "Meiryo UI");
  else if(DefaultLCID == 3082)
  {
    ComponentSetFontName(this, "Segoe UI");
    ComponentSetMultiLine(this);
  }

  GetDefaultString();
  DMUExcute = false;
}
//---------------------------------------------------------------------------
void __fastcall TEnvironmentSettingForm::GetDefaultString()
{
  CloseButton->Caption = ENVIRONMENTSETTINGFORM_BUTTON_CAPTION_01;
  DMURunButton->Caption = ENVIRONMENTSETTINGFORM_BUTTON_CAPTION_02;
  SystemMonitorButton->Caption = ENVIRONMENTSETTINGFORM_BUTTON_CAPTION_03;
  SystemInfoButton->Caption = ENVIRONMENTSETTINGFORM_BUTTON_CAPTION_04;
  MachineEnvironmentSettupButton->Caption = ENVIRONMENTSETTINGFORM_BUTTON_CAPTION_05;
  DSMButton->Caption = ENVIRONMENTSETTINGFORM_BUTTON_CAPTION_06;
  ComputerSystemSettingButton->Caption = ENVIRONMENTSETTINGFORM_BUTTON_CAPTION_07;
  CommControlButton->Caption = ENVIRONMENTSETTINGFORM_BUTTON_CAPTION_08;
  this->Caption = ENVIRONMENTSETTINGFORM_FORM_CAPTION_01;
}
//---------------------------------------------------------------------------
void __fastcall TEnvironmentSettingForm::DMURunButtonClick(TObject *Sender)
{
	WideString DMUCmdLine;
   //test Code 
  //DefaultLCID = 1041;       //Ϻ
 // DefaultLCID = 1033;      //

  WideString LCID = WideString(IntToStr(DefaultLCID))+ " -LocaleID " + IntToStr(DefaultLCID);
  /*if(DefaultLCID == 1042)
	  DMUCmdLine = ProgramPath.Root + "\\DMUT.exe";
  else if(DefaultLCID == 1041)
    DMUCmdLine = ProgramPath.Root + "\\ACROCIA_DMU.exe";
  else
    DMUCmdLine = ProgramPath.Root + "\\DMUT_EN.exe";*/

   // DMUCmdLine = ProgramPath.Root + "\\DMUT.exe";

    DMUCmdLine = ProgramPath.Root + "\\DMUT.exe";

    if(DMUExcute)   return;
    
    DMUExcute = true;
    StopCSVLogFile();

    STARTUPINFO start;
    memset(&start, 0, sizeof(STARTUPINFO));
    start.cb = sizeof(start);
    start.wShowWindow = SW_SHOWDEFAULT;
    SECURITY_ATTRIBUTES sec;
    sec.nLength = sizeof(sec);
    sec.lpSecurityDescriptor = NULL;
    sec.bInheritHandle = TRUE;
    PROCESS_INFORMATION pinfo;
    if(CreateProcess(DMUCmdLine.c_bstr(), LCID, &sec, &sec, TRUE, 0, NULL, NULL,  &start, &pinfo) != TRUE)
    {
        int res = GetLastError();
        if(res == 3)
		    ShowMessageFA(ENVIRONMENTSETTINGFORM_MSG_03);
    }  
    DWORD waitresult;
    do
    {
        Application->ProcessMessages();
        waitresult = WaitForSingleObject(pinfo.hProcess, 100);
    } while(waitresult == WAIT_TIMEOUT);
                                        
    ResumeCSVLogFile();
    DMUExcute = false;
       /*
	unsigned int resultDMU = WinExec(DMUCmdLine.c_str(), SW_SHOW);
    if (resultDMU < 32)
    {
		if (resultDMU == 0)
        {
			ShowMessageFA(ENVIRONMENTSETTINGFORM_MSG_01);
        }
        else if (resultDMU == ERROR_PATH_NOT_FOUND || resultDMU == ERROR_FILE_NOT_FOUND)
        {                                        
			ShowMessageFA(ENVIRONMENTSETTINGFORM_MSG_03);
        }
        else
        {
			ShowMessageFA(ENVIRONMENTSETTINGFORM_MSG_02);
        }
    }   */

}
//---------------------------------------------------------------------------

void __fastcall TEnvironmentSettingForm::MachineEnvironmentSettupButtonClick(
      TObject *Sender)
{
    TMachineEnvSetupForm *machineEnvSetupForm = new TMachineEnvSetupForm(this);
    machineEnvSetupForm->ShowModal();
    delete machineEnvSetupForm;
}
//---------------------------------------------------------------------------


void __fastcall TEnvironmentSettingForm::CommControlButtonClick(
      TObject *Sender)
{
	if (CommControlForm)
	{
		CommControlForm->ShowModal();
	}
}
//---------------------------------------------------------------------------

void __fastcall TEnvironmentSettingForm::DSMButtonClick(TObject *Sender)
{
	TDiskSpaceManagerSettingForm *diskSpaceManagerSettingForm = new TDiskSpaceManagerSettingForm(this);
	diskSpaceManagerSettingForm->ShowModal();
	delete diskSpaceManagerSettingForm;
}
//---------------------------------------------------------------------------


void __fastcall TEnvironmentSettingForm::SystemInfoButtonClick(
      TObject *Sender)
{
	TSystemInfoForm *systemInfoForm = new TSystemInfoForm(this);
	systemInfoForm->ShowModal();
	delete systemInfoForm;
}
//---------------------------------------------------------------------------

void __fastcall TEnvironmentSettingForm::FormCreate(TObject *Sender)
{
	bNeedLogOut = false;
  OnUserChange();
}
//---------------------------------------------------------------------------
void __fastcall TEnvironmentSettingForm::OnUserChange(void)
{
  if(ProgramAccessAuthorityData.ProgramAccessAuthorityTable[UserInfo.AccessLevel][ACCESS_PGM_EVT_ENVSETUPFORM_AIR_CONTROL])
    MachineEnvironmentSettupButton->Visible = true;
  else
    MachineEnvironmentSettupButton->Visible = false;

  if(ProgramAccessAuthorityData.ProgramAccessAuthorityTable[UserInfo.AccessLevel][ACCESS_PGM_EVT_ENVSETUPFORM_COMM_SETUP])
		CommControlButton->Visible = true;
  else
		CommControlButton->Visible = false;

  if(ProgramAccessAuthorityData.ProgramAccessAuthorityTable[UserInfo.AccessLevel][ACCESS_PGM_EVT_ENVSETUPFORM_STORAGE_SPACE_SETUP])
    DSMButton->Visible = true;
  else
    DSMButton->Visible = false;

  if(ProgramAccessAuthorityData.ProgramAccessAuthorityTable[UserInfo.AccessLevel][ACCESS_PGM_EVT_ENVSETUPFORM_COM_SYS_SETUP])
    ComputerSystemSettingButton->Visible = true;
  else
    ComputerSystemSettingButton->Visible = false;

  if(ProgramAccessAuthorityData.ProgramAccessAuthorityTable[UserInfo.AccessLevel][ACCESS_PGM_EVT_ENVSETUPFORM_RUN_DMU])
    DMURunButton->Visible = true;
  else
    DMURunButton->Visible = false;

  this->Height = 215 + (abs(ButtonSetLocation(this)-1)*75);
}
//---------------------------------------------------------------------------

void __fastcall TEnvironmentSettingForm::ComputerSystemSettingButtonClick(
      TObject *Sender)
{
  bool bActiveLogout;
	computerSystemSettingForm = new TComputerSystemSettingForm(this);
	computerSystemSettingForm->ShowModal();
  bActiveLogout = computerSystemSettingForm->bNeedLogOut;
	delete computerSystemSettingForm;

  if(bActiveLogout)
  {
    ShowMessageFA(COMPUTER_SYSTEM_SETTING_NEW_AUTHORITY_SETUP_MSG_14);
    bNeedLogOut = true;
    this->Close();
  }
}
//---------------------------------------------------------------------------

void __fastcall TEnvironmentSettingForm::SystemMonitorButtonClick(
      TObject *Sender)
{
	SystemMonitorForm->ShowModal();
}
//---------------------------------------------------------------------------

int TEnvironmentSettingForm::ButtonSetLocation(TComponent *pComponent)
{
  int StartHeight = 13;
  int ButtonCount =0;
  int HeightSize[7] = {13,88,163,238,313,388,463};
  vector<int> Component_vec;
  
  for(int i=0; i<pComponent->ComponentCount;  i++)
  {
     int Topsize = i+1;
     if (pComponent->Components[i]->InheritsFrom(__classid(TTntButton)))
     {
        if(((TTntButton *)(pComponent->Components[i]))->Name == "CloseButton" || ((TTntButton *)(pComponent->Components[i]))->Visible == false)
          continue;
        else
        {
          Component_vec.push_back(i);
          //((TTntButton *)(pComponent->Components[i]))->Top = StartHeight;
          ++ButtonCount;

          //StartHeight += 75;
        }
     }
  }

  int Length =  Component_vec.size();
  for (int i = 0; i < Length; i++)
  {
    for (int j = 0; j < Length - i; j++)
    {
      if (j + 1 < Length && ((TTntButton *)(pComponent->Components[Component_vec.at(j)]))->Tag  > ((TTntButton *)(pComponent->Components[Component_vec.at(j+1)]))->Tag)
      {
        Component_vec.at(j) = Component_vec.at(j) + Component_vec.at(j+1);
        Component_vec.at(j+1) = Component_vec.at(j) - Component_vec.at(j+1);
        Component_vec.at(j) = Component_vec.at(j) - Component_vec.at(j+1);
      }
    }
  }

  for(int z = 0; z < Component_vec.size(); ++z)
  {
    ((TTntButton *)(pComponent->Components[Component_vec.at(z)]))->Top = HeightSize[z];
  }

  return ButtonCount;
}
//---------------------------------------------------------------------------
